<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_langpackdropper', language 'de', version '3.9'.
 *
 * @package     tool_langpackdropper
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['eventlangpackinstalled'] = 'Sprachpaket installiert';
$string['eventlangpackinstalled_desc'] = 'Das Sprachpaket \'{$a->name}\' wurde von {$a->url} installiert';
$string['eventlangpackupdated'] = 'Sprachpaket aktualisiert';
$string['eventlangpackupdated_desc'] = 'Das Sprachpaket \'{$a->name}\' wurde von {$a->url} aktualisiert';
$string['pluginname'] = 'Sprachpaket Platzierung';
$string['privacy:metadata'] = 'Das Sprachpaket Platzierungs-Plugin speichert keine personenbezogenen Daten';
$string['setting_downloadtimeout'] = 'Timeout des Sprachpaket Download';
$string['setting_downloadtimeout_desc'] = 'Moodle wird versuchen, die Sprachpakete von den angegebenen URLs herunterzuladen bis dieser Timeout erreicht ist.';
$string['setting_langpackdropperstatic_desc'] = 'Mit diesem Plugin können Sie Sprachpakete, welche nicht auf AMOS, der offiziellen Moodle Übersetzungsplattform, verwaltet werden, herunterladen. Diese Funktion ist insbesondere dann hilfreich falls Sie eine größere Menge von Sprachanpassungen haben und diese lieber per Git anstatt in der Moodle Sprachanpassungsoberfläche verwalten möchten. Diese Funktion ist darüber hinaus auch hilfreich falls Sie dieselben Sprachanpassungen auf mehreren Moodle Instanzen gleichzeitig nutzen möchten.';
$string['setting_langpackurls'] = 'Sprachpaket URLs';
$string['setting_langpackurls_desc'] = 'Diese Einstellung erwartet eine Liste von Sprachpaketen, die auf dieser Moodle Instanz verwendet werden sollen. Jede Zeile besteht aus dem Sprachpaket-Identifikator und einer URL unter der das Sprachpaket heruntergeladen werden kann.<br/><br/>
Zum Beispiel:<br/>
de_mysublangpack|https://github.com/lernlink/moodle-tool_langpackdropper/raw/master/tests/fixtures/de_droppertest_toplevel.zip
<br/><br/>
Weitere Informationen zu den Parametern:
<ul>
<li><b>Identifikator:</b> Dieser Identifikator wird als Ordnername unterhalb Ihres MOODLEDATA/lang Verzeichnisses verwendet werden, wo das Sprachpaket dann platziert werden wird.</li>
<li><b>URL:</b> Die Download URL wird als vollwertige URL erwartet, unter der Moodle eine ZIP Datei herunterladen kann. URLs zu Github Repository Downloads funktionieren hier sehr gut.</li>
</ul>
Bitte beachten Sie:
<ul>
<li>Ungültige Einstellungszeilen, zum Beispiel weil sie eine ungültige URL enthalten, werden bei der Verarbeitung stillschweigend ignoriert.</li>
<li>Die ZIP Datei des Sprachpakets muss entweder alle Sprachpaket-Dateien auf der obersten Ebene enthalten oder einen einzigen Ordner enthalten, in dem widerum alle Sprachpaket-Dateien liegen. Im letztgenannten Fall ist der Name des Ordners irrelevant. Falls die ZIP Datei diese Anforderungen nicht erfüllt, wird das Sprachpaket nicht verarbeitet werden und ein Fehler wird gelogged werden.</li>
<li>Moodle wird mit diesem Dienstprogramm PHP Code von der angegebenen URL herunterladen und diesen als PHP Dateien eines Sprachpakets ausführen.<em>Es obliegt Ihnen als Administrator nur URLs zu konfigurieren, von denen Sie 100% sicher sind dass Sie nichts anderes als Sprachpaket-Dateien enthalten und bei denen kein Angreifer Schadcode in die ZIP Datei einschleusen können wird.</em></li>
<li>Falls Sie planen, dieses Dienstprogramm dazu einzusetzen um Sprachpakete zu platzieren, die auch in AMOS verwaltet werden - was problemlos möglich ist - sollten Sie bitte prüfen ob Sie den geplanten Task \\tool_langimport\\task\\update_langpacks_task deaktivieren um zu verhindern dass sich beide Aktualisierungsmechanismen in die Quere kommen.</li>
</ul>';
$string['taskupdatelanguagepacks'] = 'Platzierte Sprachpakete aktualisieren';
$string['updatedcallbacknotification'] = 'Die URLs der Sprachpakete wurden aktualisiert. Ein Ad-hoc Task, welcher die Sprachpakete auf der Basis der gespeicherten Einstellungen herunterlädt bzw. aktualisiert, wurde eingeplant und wird in Kürze ausgeführt werden.';
