<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'hu', version '3.9'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Tevékenységek';
$string['addcategory'] = 'Kategória hozzáadása';
$string['addcategoryerror'] = 'Kategória hozzáadása nem sikerült.';
$string['addexceptionerror'] = 'Hiba userid:gradeitem-hez való kivétel hozzáadása közben';
$string['addfeedback'] = 'Visszajelzés hozzáadása';
$string['addgradeletter'] = 'Pontozási betű hozzáadása';
$string['addidnumbers'] = 'Azonosítószámok hozzáadása';
$string['additem'] = 'Osztályozási tétel hozzáadása';
$string['additionalfeedback'] = 'Kiegészítő visszajelzés';
$string['addoutcome'] = 'Eredmény hozzáadása';
$string['addoutcomeitem'] = 'Eredményelem hozzáadása';
$string['addscale'] = 'Skála hozzáadása';
$string['adjustedweight'] = 'Súly beállítva';
$string['aggregateextracreditmean'] = 'Átlagpontszám (külön kreditekkel)';
$string['aggregatemax'] = 'Legmagasabb pont';
$string['aggregatemean'] = 'Átlagpontszám';
$string['aggregatemedian'] = 'Pontok középértéke';
$string['aggregatemin'] = 'Legalacsonyabb pont';
$string['aggregatemode'] = 'Leggyakoribb pont';
$string['aggregatenotonlygraded'] = 'Üres osztályzatokkal együtt';
$string['aggregateonlygraded'] = 'Üres osztályzatok kizárása';
$string['aggregateonlygraded_help'] = '<p>A nem létező pontokat vagy minimális pontokként kezeli, vagy kihagyja az összesítésből.</p>';
$string['aggregateoutcomes'] = 'Eredmények szerepeltetése az összegzésben';
$string['aggregateoutcomes_help'] = '<p>Ha az eredményeket beleveszi az összesítésbe, ezzel nem állhat elő a kívánt globális pont, ezért választhat: beleveszi vagy kihagyja őket.</p>';
$string['aggregatesonly'] = 'Áttérés csak az összegzésekhez';
$string['aggregatesubcatsupgradedgrades'] = 'Megjegyzés: A portál frissítése során törlődött az "Összesítés az alkategóriákkal" beállítás. Mivel a kurzus ezt korábban használta, ajánlott a változást ellenőriznie az osztályozónaplóban.';
$string['aggregatesum'] = 'Természetes';
$string['aggregateweightedmean'] = 'Pontok súlyozott átlaga';
$string['aggregateweightedmean2'] = 'Pontok egyszerű súlyozott átlaga';
$string['aggregation'] = 'Összegzés';
$string['aggregation_help'] = 'Az összesítés szabja meg, hogy egy kategória esetén az osztályzatok miként kombinálódnak.

* Osztályzatok átlaga - Az összes pont összege a pontok számával elosztva.
* Osztályzatok felezőértéke - Méret szerint rendezett osztályzatok esetén a középső osztályzat
* Legalacsonyabb osztályzat
* Legmagasabb osztályzat
* Osztályzatok módusza - A módusz a leggyakrabban előforduló osztályzat
* Természetes - Minden súllyal skálázott pontérték összege';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Összegzési együttható';
$string['aggregationcoefextra'] = 'Külön kreditpont';
$string['aggregationcoefextra_help'] = 'Ha az összesítés Természetes vagy Egyszerű súlyozott átlag és a plusz kreditpont be van jelölve, akkor a kategória maximális pontjához az osztályozási tételre adott maximális pont nem adódik hozzá, így anélkül elérhető a kategória maximális pontja (vagy az azt meghaladó pontszám, ha ilyet a rendszergazda beállított), hogy minden osztályozási tétel esetén maximális pontot kellene teljesíteni.

Ha az összesítés Osztályzatok átlaga (plusz kreditpontokkal) és a plusz kreditpont nullánál nagyobb értékre van beállítva, akkor a plusz kreditpont  lesz az a tényező, amellyel az osztályzatot az átlagszámítás utáni összeghez való hozzáadás előtt megszorozzuk.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Külön kreditpont';
$string['aggregationcoefextrasum_help'] = 'Ha a Pluszpont négyzet be van jelölve, az osztályozási tétel maximális pontja nem adódik hozzá a kategória maximális pontjához. Így a kategórián belül a maximális pont (vagy, ha a rendszergazda engedélyezi, a maximális fölötti pont) anélkül érhető el, hogy minden osztályozási tétel esetén meglenne a maximális pont.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Külön kreditpont súlya';
$string['aggregationcoefextraweight_help'] = '<p>A 0-nál nagyobb érték ezen osztályozási tétel pontjait összegzés során külön kreditpontként kezeli. A szám az a tényező, amellyel a pontérték megszorzódik, mielőtt az összes pont összegéhez hozzáadódik, de maga a tétel az osztásba nem számít bele. Például:</p>

<ul>
    <li>Az 1. tétel pontja 0-100, "külön kreditpont" értéke pedig 2</li>
    <li>A 2. tétel pontja 0-100, "külön kreditpont" értéke pedig 0,0000 marad</li>
    <li>A 3. tétel pontja 0-100, "külön kreditpont" értéke pedig 0,0000 marad</li>
    <li>Mindhárom tétel az 1. kategóriába tartozik, melynek "Pontátlaga (külön kreditpontokkal együtt)" jelenti összegzési stratégiáját</li>
    <li>Egy tanuló az 1. tételre 20 pontot, a 2.-ra 40-et, a 3.-ra 70-et kap</li>
    <li>A tanuló 1. kategóriára kapott pontja összesen 95/100 lesz, mivel 20*2 + (40 + 70)/2 = 95</li>
</ul>';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Tétel súlya';
$string['aggregationcoefweight_help'] = '<p>Az egyéb osztályozási tételekkel való összegzés során a jelen osztályozási tétel összes pontjára alkalmazott súly.</p>';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '(Kihagyva)';
$string['aggregationhintexcluded'] = '(Kizárva)';
$string['aggregationhintextra'] = '(Plusz kreditpont)';
$string['aggregationhintnovalue'] = '(Üres)';
$string['aggregationofa'] = '{$a} összesítése';
$string['aggregationposition'] = 'Összegzési pozíció';
$string['aggregationposition_help'] = '<p>Meghatározza az összegzés összege oszlopának a helyzetét a jelentésben az összegezendő pontokhoz viszonyítva.</p>';
$string['aggregationsvisible'] = 'Használható összegzési típusok';
$string['aggregationsvisiblehelp'] = 'Válassza ki az összes használandó összegzési típust. Több elem kiválasztásához nyomja le a Ctrl billentyűt.';
$string['allgrades'] = 'Kategóriánként az összes pont';
$string['allstudents'] = 'Minden tanuló';
$string['allusers'] = 'Minden felhasználó';
$string['autosort'] = 'Automatikus rendezés';
$string['availableidnumbers'] = 'Használható azonosítószámok';
$string['average'] = 'Átlag';
$string['averagesdecimalpoints'] = 'Oszlopátlagok tizedesjegyei';
$string['averagesdecimalpoints_help'] = 'Meghatározza, hány tizedesjegy jelenjen meg az egyes oszlopátlagok esetén, vagy a kategória vagy osztályozási tétel globális beállítását használja inkább (öröklés).';
$string['averagesdisplaytype'] = 'Oszlopátlagok megjelenítésének típusa';
$string['averagesdisplaytype_help'] = '<p>Meghatározza, hogyan jelenjen meg átlag az egyes oszlopok esetén. Az Öröklés kiválasztása esetén az egyes oszlopok megjelenítési típusa lesz használatos.</p>';
$string['backupwithoutgradebook'] = 'A biztonsági mentés nem tartalmazza az osztályozónapló beállítását';
$string['badgrade'] = 'A megadott pont érvénytelen';
$string['badlyformattedscale'] = 'Adjon meg egy vesszőkkel elválasztott értéklistát (legalább két értékkel).';
$string['baduser'] = 'A megadott felhasználó érvénytelen';
$string['bonuspoints'] = 'Jutalompontok';
$string['bulkcheckboxes'] = 'Vegyes jelölőnégyzetek';
$string['calculatedgrade'] = 'Számított pont';
$string['calculation'] = 'Számítás';
$string['calculation_help'] = 'A pontszámítás az osztályzat meghatározására használt képlet. A képlet egyenlőségjellel (=) kezdődik, és szokásos matematikai műveletjeleket -- pl. max, min és sum -- tartalmazhat. Szükség esetén egyéb osztályozási tételek illeszthetők a számításba: ehhez kettős szögletes zárójelben adja meg az azonosítószámokat.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Számítás hozzáadása';
$string['calculationedit'] = 'Számítás szerkesztése';
$string['calculationsaved'] = 'Számítás elmentve';
$string['calculationview'] = 'Számítás megtekintése';
$string['cannotaccessgroup'] = 'A kiválasztott csoport pontjai nem érhetők el.';
$string['categories'] = 'Kategóriák';
$string['category'] = 'Kategória';
$string['categoryedit'] = 'Kategória szerkesztése';
$string['categoryname'] = 'Kategória neve';
$string['categorytotal'] = 'Kategória összes pontszáma';
$string['categorytotalfull'] = '{$a->category} összesen';
$string['categorytotalname'] = 'Kategória összegzésének neve ';
$string['changedefaults'] = 'Alapbeállítások módosítása';
$string['changereportdefaults'] = 'Jelentés alapbeállításainak módosítása';
$string['chooseaction'] = 'Válasszon egy lépést ...';
$string['choosecategory'] = 'Kategória kiválasztása';
$string['collapsecriterion'] = 'Feltétel összecsukása';
$string['combo'] = 'Tabulátorok és lenyíló menü';
$string['compact'] = 'Tömör';
$string['componentcontrolsvisibility'] = 'A tevékenység beállításaival szabályozza az osztályozási tétel láthatóságát.';
$string['contract'] = 'Szerződéskategória';
$string['contributiontocoursetotal'] = 'Hozzájárulás a kurzus összpontszámához';
$string['controls'] = 'Vezérlőelemek';
$string['courseavg'] = 'Kurzusátlag';
$string['coursegradecategory'] = 'Kurzuspontok kategóriája';
$string['coursegradedisplaytype'] = 'Kurzuspontok megjelenítési típusa';
$string['coursegradedisplayupdated'] = 'A kurzuspontok megjelenítési típusának frissítése megtörtént.';
$string['coursegradesettings'] = 'Kurzuspontok beállításai';
$string['coursename'] = 'Kurzus neve';
$string['coursescales'] = 'Kurzusskálák';
$string['coursesettings'] = 'Kurzus beállításai';
$string['coursesettingsexplanation'] = 'A kurzus osztályzatbeállításaitól függ, miként jelenik meg a kurzus résztvevői számára az osztályozónapló.';
$string['coursesiamtaking'] = 'Felvett kurzusaim';
$string['coursesiamteaching'] = 'Oktatott kurzusaim';
$string['coursetotal'] = 'Kurzus összegezve';
$string['createcategory'] = 'Kategória létrehozása';
$string['createcategoryerror'] = 'Új kategória létrehozása nem sikerült';
$string['creatinggradebooksettings'] = 'Osztályozónapló beállításainak létrehozása';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Jelenlegi szülők egyesítése';
$string['curveto'] = 'Görbe';
$string['decimalpoints'] = 'Összes tizedesjegy';
$string['decimalpoints_help'] = 'Megadja, hány tizedeshely jelenjen meg az egyes pontoknál. A beállításnak a számításokra nincs hatása, azok 5 tizedesnyi pontossággal állnak elő.';
$string['default'] = 'Alapbeállítás';
$string['defaultprev'] = 'Alapbeállítás ({$a})';
$string['deletecategory'] = 'Kategória törlése';
$string['disablegradehistory'] = 'Pont előzményeinek kikapcsolása';
$string['disablegradehistory_help'] = 'A pontokhoz kapcsolódó táblázatokban végrehajtott módosítások nyomon követésének kikapcsolása. Ezzel kissé felgyorsítható a szerver működése és hely takarítható meg az adatbázisban.';
$string['displaylettergrade'] = 'Pontozó betűk megjelenítése';
$string['displaypercent'] = 'Kijelzés százalékkal';
$string['displaypoints'] = 'Kijelzés pontokkal';
$string['displayweighted'] = 'Kijelzés súlyozott osztályzatokkal';
$string['dropdown'] = 'Lenyíló menü';
$string['droplow'] = 'A legalacsonyabb kihagyása';
$string['droplow_help'] = '<p>Beállítása esetén kihagyja a legalacsonyabb X pontot, ahol is az X az adott opcióhoz kiválasztott értéket jelenti.</p>';
$string['droplowestvalue'] = 'Kieső alacsony osztályzat beállítása';
$string['droplowestvalues'] = '{$a} legalacsonyabb érték kihagyása';
$string['dropped'] = 'Kihagyva';
$string['dropxlowest'] = 'Legalacsonyabb X kihagyása';
$string['dropxlowestwarning'] = 'Megjegyzés: a legalacsonyabb X kihagyása esetén a pontozás abból indul ki, hogy minden kategóriában a tételek azonos pontértékkel rendelkeznek. Ha eltérnek, az eredmény megjósolhatatlanná válik.';
$string['duplicatedgradeitem'] = '{$a} (másolat)';
$string['duplicatescale'] = 'Ismétlődő skála';
$string['edit'] = 'Szerkesztés';
$string['editcalculation'] = 'Kalkuláció szerkesztése';
$string['editcalculationverbose'] = '{$a->category} {$a->itemmodule}{$a->itemname} számítás szerkesztése';
$string['editfeedback'] = 'Visszajelzés szerkesztése';
$string['editgrade'] = 'Pont szerkesztése';
$string['editgradeletters'] = 'Pontozó betűk szerkesztése';
$string['editoutcome'] = 'Eredmény szerkesztése';
$string['editoutcomes'] = 'Eredmények szerkesztése';
$string['editscale'] = 'Kategóriák és elemek';
$string['edittree'] = 'Beállítás';
$string['editverbose'] = 'A(z) {$a->category} {$a->itemmodule} {$a->itemname} szerkesztése';
$string['enableajax'] = 'Az AJAX bekapcsolása';
$string['enableajax_help'] = 'A pontozói jelentést AJAX-funkciókkal egészíti ki, így az általános műveletek egyszerűbben és gyorsabban hajthatók végre. Attól függ, hogy a javascript a felhasználó böngészőjében be van-e kapcsolva.';
$string['enableoutcomes'] = 'Eredmények bekapcsolása';
$string['enableoutcomes_help'] = 'Bekapcsolása esetén az osztályozási tételek eredmény-megállapításokhoz kötött egy vagy több skála segítségével értékelhetők.';
$string['encoding'] = 'Kódolás';
$string['encoding_help'] = 'Válassza ki a karakterkódolást. (A standard karakterkódolás az UTF-8.) Ha véletlenül hibás kódolást választ, az látható lesz az importálandó adatok előnézetében.';
$string['errorcalculationbroken'] = 'Vélhetően körkörös hivatkozás vagy hibás számítási képlet';
$string['errorcalculationnoequal'] = 'A képletnek egyenlőségjellel kell kezdődnie (=1+2)';
$string['errorcalculationunknown'] = 'Hibás képlet';
$string['errorgradevaluenonnumeric'] = 'Nem számjegyes alacsony vagy magas pont érkezett erre';
$string['errornocalculationallowed'] = 'Ezen tétel esetén számítás nem alkalmazható';
$string['errornocategorisedid'] = 'Nincs kategorizálatlan azonosító!';
$string['errornocourse'] = 'Nincs kurzusinformáció';
$string['errorreprintheadersnonnumeric'] = 'Újranyomtatási fejléchez nem számjegyes érték érkezett';
$string['errorsavegrade'] = 'A pontot nem lehetett elmenteni.';
$string['errorsettinggrade'] = 'Hiba {$a->userid} felhasználó "{$a->itemname}" osztályzatának mentése közben';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Hiba a(z) {$a->id} pontozási kategória-azonosító "Csak a nem üres pontok összegzése" beállításának frissítése közben';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Hiba a(z) {$a->id} pontozási kategória-azonosító "Eredmények beillesztése az összegzésbe" beállításának frissítése közben';
$string['errorupdatinggradecategoryaggregation'] = 'Hiba a(z) {$a->id} pontozási kategória-azonosító összegzési típusának frissítése közben';
$string['errorupdatinggradeitemaggregationcoef'] = 'Hiba a(z) {$a->id} pontozási kategória-azonosító összegzési együtthatójának (súly vagy külön kreditpont) frissítése közben';
$string['eventgradedeleted'] = 'Osztályzat törölve';
$string['eventgradeitemcreated'] = 'Osztályozási tétel létrehozva';
$string['eventgradeitemupdated'] = 'Osztályozási tétel frissítve';
$string['eventgradelettercreated'] = 'Osztályozó betű létrehozva';
$string['eventgradeletterdeleted'] = 'Osztályozó betű törölve';
$string['eventgradeletterupdated'] = 'Osztályozó betű frissítve';
$string['eventgradeviewed'] = 'Az osztálynaplóban lévő osztályzatokat megtekintették';
$string['eventscalecreated'] = 'Skála létrehozva';
$string['eventscaledeleted'] = 'Skála törölve';
$string['eventscaleupdated'] = 'Skála frissítve';
$string['eventusergraded'] = 'Felhasználó osztályozva';
$string['excluded'] = 'Kizárva';
$string['excluded_help'] = '<p>Ha a -kimarad- be van kapcsolva, a pont kimarad minden összegzésből, amelyet bármely felette lévő osztályozási tétel vagy kategória végrehajt.</p>';
$string['expand'] = 'Kategória kiterjesztése';
$string['expandcriterion'] = 'Feltétel kibontása';
$string['export'] = 'Exportálás';
$string['exportalloutcomes'] = 'Minden eredmény exportálása';
$string['exportfeedback'] = 'Visszajelzés beillesztése az exportálásba';
$string['exportfeedback_desc'] = 'Ez exportálás során fölülírható.';
$string['exportformatoptions'] = 'Exportálási formátum beállításai';
$string['exportonlyactive'] = 'Felfüggesztett felhasználók kizárása';
$string['exportonlyactive_help'] = 'Csak a nem felfüggesztett, beiratkozott tanulók exportálása';
$string['exportplugins'] = 'Segédprogramok exportálása';
$string['exportsettings'] = 'Beállítások exportálása';
$string['exportto'] = 'Exportálás helye';
$string['externalurl'] = 'Külső URL';
$string['externalurl_desc'] = 'Külső osztálynapló használata esetén itt adja meg a webcímet.';
$string['extracreditvalue'] = 'Külön kreditpont {$a} esetén';
$string['extracreditwarning'] = 'Megjegyzés: ha egy kategória minden tétele külön kreditponttal szerepel, akkor kimaradnak a pontszámításból, mert nem születik összegzett pontszám';
$string['feedback'] = 'Visszajelzés';
$string['feedback_help'] = '<p>A tanár által a pontokhoz fűzött megjegyzések. Lehet részletes, személyre szóló visszajelzés vagy egy egyszerű kód, amely a visszajelzés belső rendszerére utal.</p>';
$string['feedbackadd'] = 'Visszajelzés hozzáadása';
$string['feedbackedit'] = 'Visszajelzés szerkesztése';
$string['feedbackfiles'] = 'Visszajelzés állományai';
$string['feedbackforgradeitems'] = '{$a} visszajelzése';
$string['feedbackhistoryfiles'] = 'Visszajelzési előzmények állományai';
$string['feedbacks'] = 'Visszajelzések';
$string['feedbacksaved'] = 'Visszajelzés elmentve';
$string['feedbackview'] = 'Visszajelzés megtekintése';
$string['finalgrade'] = 'Végső pontszám';
$string['finalgrade_help'] = '<p>Az a (gyorsítótárban előálló) végső pont, amely az összes számítás elvégzése után jön létre.</p>';
$string['fixedstudents'] = 'Statikus tanulói hasáb';
$string['fixedstudents_help'] = 'Statikus tanulói hasábbal az osztályzatok vízszintesen görgethetők.';
$string['forceimport'] = 'Importálás végrehajtása';
$string['forceimport_help'] = 'Osztályzatok importálásának előírása az importálási állomány exportálása utáni osztályzatfrissítést követően is';
$string['forceoff'] = 'Előírás: Ki';
$string['forceon'] = 'Előírás: Be';
$string['forelementtypes'] = 'a kiválasztott {$a} részére';
$string['forstudents'] = 'Tanulóknak';
$string['full'] = 'Teljes';
$string['fullmode'] = 'Áttérés teljes nézetre';
$string['generalsettings'] = 'Általános beállítások';
$string['grade'] = 'Pont';
$string['grade_help'] = 'A tanuló munkájára adandó osztályzat.';
$string['gradeadministration'] = 'Osztályozás kezelése';
$string['gradealreadyupdated'] = '{$a} osztályzat importálása elmaradt, mert az importálási állományban lévő osztályzatok régebbiek az osztálynaplóban lévőknél. Ha ennek ellenére folytatja az importálást, válassza az Importálás végrehajtása beállítást.';
$string['gradeanalysis'] = 'Pontszámok elemzése';
$string['gradebook'] = 'Osztályozónapló';
$string['gradebookcalculationsfixbutton'] = 'Osztályzatok változásának elfogadása és számítási hibák javítása';
$string['gradebookcalculationsuptodate'] = 'A napló számításai naprakészek. A változások megtekintéséhez töltse újra az oldalt.';
$string['gradebookcalculationswarning'] = 'Megjegyzés: a naplóban látszó osztályzatok számítása hibát tartalmaz. Az alábbi gombra kattintva javítsa ki, bár emiatt néhány osztályzat módosulni fog. Ha a kurzus már véget ért és sor került osztályzatok leadására, ne javítsa.

Az újabb verzió {$a->currentversion}; a most használt pedig a(z) {$a->gradebookversion}. Változások felsorolása: <a href="{$a->url}">Gradebook calculation changes</a>.';
$string['gradebookhiddenerror'] = 'Az osztályozónapló a mostani beállításban mindent elrejt a tanulók elől.';
$string['gradebookhistories'] = 'Pont előzményei';
$string['gradebooksetup'] = 'Osztályozónapló beállítása';
$string['gradeboundary'] = 'Betűpontozás határértéke';
$string['gradeboundary_help'] = '<p>Százalékos határ, mely fölött a pontok pontozási betűt kapnak (ha a pontozási betű megjelenítése be van kapcsolva). </p>';
$string['gradecategories'] = 'Pontozási kategóriák';
$string['gradecategory'] = 'Pontozási kategória';
$string['gradecategoryonmodform'] = 'Pontozási kategória';
$string['gradecategoryonmodform_help'] = 'Ez a beállítás szabályozza azt a kategóriát, amelyikbe ezen tevékenység pontjai az osztályozónaplóba bekerülnek.';
$string['gradecategorysettings'] = 'Pontozási kategória beállításai';
$string['gradedisplay'] = 'Pont megjelenítése';
$string['gradedisplaytype'] = 'Pont megjelenítésének típusa';
$string['gradedisplaytype_help'] = 'Megadja, miként jelenjenek meg az osztályzatok az osztályozónaplóban és a felhasználói jelentésben. Az osztályzatok megjelenhetnek

* Valós számok - tényleges osztályzatok
* Százalékok - maximális és minimális osztályzatokhoz viszonyítva
* Betű formájában. - A betűk vagy szavak osztályzatok tartományát jelölik.';
$string['gradedon'] = 'Pontozott {$a}';
$string['gradeexport'] = 'Pontexportálás';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Pontexportálás egyedi profilmezői';
$string['gradeexportcustomprofilefields_desc'] = 'A pontexportálás egyedi profilmezőit vesszőkkel elválasztva adja meg.';
$string['gradeexportdecimalpoints'] = 'Osztályzatexportálás tizedesjegyei';
$string['gradeexportdecimalpoints_desc'] = 'Az exportáláshoz megjelenítendő tizedesjegyek száma. Exportálás közben ez felülírható.';
$string['gradeexportdisplaytype'] = 'Pontexportálás megjelenítésének típusa';
$string['gradeexportdisplaytype_desc'] = 'A pontok exportálása során megjelenhetnek valós pontszámok, (a minimális és maximális pontszámhoz viszonyított) százalékok vagy betűk (A, B, C stb.) formájában. Exportálás közben ez felülírható.';
$string['gradeexportdisplaytypes'] = 'Osztályzat exportálásának megjelenítési típusai';
$string['gradeexportuserprofilefields'] = 'Pontexportálás felhasználói profilmezői';
$string['gradeexportuserprofilefields_desc'] = 'A pontexportálás felhasználói profilmezőit vesszőkkel elválasztva adja meg.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Kezdeti legalacsonyabb és legmagasabb osztályzat';
$string['gradehelp'] = 'Súgó az osztályozáshoz';
$string['gradehistorylifetime'] = 'Pont előzményeinek őrzési ideje';
$string['gradehistorylifetime_help'] = 'Megadja, mennyi ideig kívánja a változásokat megőrizni a pontokhoz kapcsolódó táblázatokban. Ajánlott minél hosszabb ideig megőrizni. Ha teljesítmény vagy tárhely terén problémába ütközik, próbálkozzék egy alacsonyabb értékkel.';
$string['gradeimport'] = 'Pontimportálás';
$string['gradeimportfailed'] = 'Osztályzat importálása véglegesítés során sikertelen. Részletek:';
$string['gradeitem'] = 'Osztályozási tétel';
$string['gradeitemaddusers'] = 'Osztályozásból kizárni';
$string['gradeitemadvanced'] = 'További pontozási lehetőségek';
$string['gradeitemadvanced_help'] = 'Osztályozási tételek szerkesztése során válassza ki az összes továbbiként megjelenítendő elemet.';
$string['gradeitemislocked'] = 'Ez a tevékenység az osztályozónaplóban zárolva van. Feloldásáig az osztályzatok módosítása nem kerül bele az osztályozónaplóba.';
$string['gradeitemlocked'] = 'Pontozás zárolva';
$string['gradeitemmembersselected'] = 'Osztályozásból kizárva';
$string['gradeitemminmax'] = 'Legalacsonyabb és legmagasabb osztályzat az osztályozási tételek beállításában';
$string['gradeitemnonmembers'] = 'Pontozásban szerepeltetve';
$string['gradeitemremovemembers'] = 'Pontozásban szerepeltetni';
$string['gradeitems'] = 'Osztályozási tételek';
$string['gradeitemsettings'] = 'Osztályozási tétel beállításai';
$string['gradeitemsinc'] = 'Szerepeltetendő osztályozási tételek';
$string['gradeletter'] = 'Pontozó betű';
$string['gradeletter_help'] = '<p>Olyan betű vagy szimbólum, amely egy ponttartományt reprezentál.</p>';
$string['gradeletternote'] = 'Betűvel megadott pont törléséhez a betűhöz tartozó három szövegterület valamelyikét törölje, és kattintson a Beküldés gombra.';
$string['gradeletteroverridden'] = 'Az osztályozás alapbetűi módosultak.';
$string['gradeletters'] = 'Pontozó betűk';
$string['gradelocked'] = 'Pont zárolva';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Maximális pont';
$string['grademax_help'] = '<p>Érték szerinti ponttípus használata esetén beállítható egy maximális pont. Tevékenység-alapú osztályozási tétel legmagasabb pontját a tevékenységet frissítő oldalon lehet beállítani.</p>';
$string['grademin'] = 'Minimális pont';
$string['grademin_help'] = '<p>Érték szerinti ponttípus használata esetén beállítható egy minimális pont.</p>';
$string['gradenotificationmessage'] = 'A(z) "{$a}" munkával kapcsolatosan új visszajelzése érkezett';
$string['gradenotificationsubject'] = 'Osztályozására sor került';
$string['gradeoutcomeitem'] = 'Pontozási eredménytétel';
$string['gradeoutcomes'] = 'Eredmények';
$string['gradeoutcomescourses'] = 'Kurzus eredményei';
$string['gradepass'] = 'Pont a teljesítéshez';
$string['gradepass_help'] = '<p>Ha egy tételhez olyan pont kapcsolódik, amelyet a felhasználóknak el kell érni vagy meg kell haladni a tétel teljesítéséhez, akkor azt itt állíthatja be.</p>';
$string['gradepassgreaterthangrade'] = 'Az elfogadható osztályzat nem lehet nagyobb, mint a lehetséges maximális {$a} osztályzat.';
$string['gradepointdefault'] = 'Alaposztályzat';
$string['gradepointdefault_help'] = 'Ez határozza meg egy tevékenységhez kapcsolódóan az osztályzat alapvető pontértékét.';
$string['gradepointdefault_validateerror'] = '1 és a maximális osztályzat közé eső egész számot kell megadni';
$string['gradepointmax'] = 'Maximális osztályzat';
$string['gradepointmax_help'] = 'Ez határozza meg egy tevékenységhez kapcsolódóan a maximális osztályzat pontértékét.';
$string['gradepointmax_validateerror'] = '1 és 10000 közé eső egész számot kell megadni';
$string['gradepreferences'] = 'Pontozási beállítások';
$string['gradepreferenceshelp'] = 'Súgó az osztályozási beállításokhoz';
$string['gradepublishing'] = 'Közzététel bekapcsolása';
$string['gradepublishing_help'] = 'Az osztályzatok közzététele azoknak egy webcímről való exportálását vagy importálását jelenti anélkül, hogy a Moodle-portálra be kellene jelentkezni. Bekapcsolása esetén a rendszergazdák és az osztályzatok közzétételére jogosultak (alapesetben az igazgatók) minden kurzusnaplóban megkapják az osztályzatok exportálásához szükséges beállításokat.';
$string['gradepublishinglink'] = 'Letöltés: {$a}';
$string['gradereport'] = 'Pontozási jelentés';
$string['graderreport'] = 'Pontozói jelentés';
$string['grades'] = 'Pontok';
$string['gradesforuser'] = '{$a->user} pontjai';
$string['gradesmoduledeletionpendingwarning'] = 'Figyelem! Tevékenység törlése folyamatban. Néhány osztályzat törlődik.';
$string['gradesmoduledeletionprefix'] = '[Törlés folyamatban]';
$string['gradesonly'] = 'Áttérés csak az osztályzatokra';
$string['gradessettings'] = 'Pontbeállítások';
$string['gradetype'] = 'Pont típusa';
$string['gradetype_help'] = '<p>Megadja a használandó pont típusát: nincs (nem lehet pontozni), érték (bekapcsolja a maximális és minimális pont beállítását), skála (bekapcsolja a skála beállítását) vagy szöveg (csak visszajelzés). Csak értéken és skálán alapuló pontokat lehet összegezni. Tevékenység-alapú osztályozási tétel ponttípusa a tevékenységet frissítő oldalon állítható be.</p>';
$string['gradevaluetoobig'] = 'Az egyik pontozási érték magasabb az engedélyezett {$a} max. értéknél';
$string['gradeview'] = 'Osztályzat megtekintése';
$string['gradewasmodifiedduringediting'] = '{$a->username} esetén a(z) {$a->itemname} tételhez megadott osztályzat kimaradt, mert valaki később frissítette azt.';
$string['gradeweighthelp'] = 'Súgó az osztályozás súlyozásához';
$string['gradingmodulename'] = 'Osztályozás ({$a})';
$string['groupavg'] = 'Csoportátlag';
$string['hidden'] = 'Rejtve';
$string['hidden_help'] = 'Bejelölése esetén a tanulók a pontokat nem látják. Szükség esetén beállítható egy elrejtési időtartam, így a pontok a pontozás befejezése után jelenhetnek meg.';
$string['hiddenasdate'] = 'Rejtett pontoknál leadás dátumának megjelenítése';
$string['hiddenasdate_help'] = 'Ha a felhasználó nem láthatja a rejtett pontokat, a \'-\' helyett jelenjen meg a leadás dátuma.';
$string['hiddenuntil'] = 'Rejtve eddig';
$string['hiddenuntildate'] = 'Rejtve eddig: {$a}';
$string['hideadvanced'] = 'Részletes funkciók elrejtése';
$string['hideaverages'] = 'Átlagok elrejtése';
$string['hidecalculations'] = 'Számítások elrejtése';
$string['hidecategory'] = 'Rejtett';
$string['hideeyecons'] = 'Elrejtés/Felfedés ikonok elrejtése';
$string['hidefeedback'] = 'Visszajelzés elrejtése';
$string['hideforcedsettings'] = 'Előírt beállítások elrejtése';
$string['hideforcedsettings_help'] = 'Előírt beállítások elrejtése a pontozási felületen.';
$string['hidegroups'] = 'Csoportok elrejtése';
$string['hidelocks'] = 'Zárolások elrejtése';
$string['hidenooutcomes'] = 'Eredmények megjelenítése';
$string['hidequickfeedback'] = 'Gyors visszajelzés elrejtése';
$string['hideranges'] = 'Tartományok elrejtése';
$string['hidetotalifhiddenitems'] = 'Összesítések elrejtése, ha azok rejtett tételeket tartalmaznak.';
$string['hidetotalifhiddenitems_help'] = 'Itt adható meg, hogy a rejtett tételeket tartalmazó összesítéseket látják-e a tanulók, vagy kötőjel (-) jelenjen meg helyükön. Megjelenítés esetén az összesítésben választhatóan szerepelhetnek a rejtett tételek. Az összesítést a pontozási jelentésben a tanár másként fogja látni, mivel ő mindig az összes tétellel számított összesítést látja. Ha a rejtett tételek is szerepelnek, akkor a tanulók kiszámíthatják a rejtett tételeket.';
$string['hidetotalshowexhiddenitems'] = 'Összesítés megjelenítése rejtett tételek nélkül';
$string['hidetotalshowinchiddenitems'] = 'Összesítés megjelenítése rejtett tételekkel együtt';
$string['hideverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} elrejtése';
$string['highgradeascending'] = 'Növekvő rendezés';
$string['highgradedescending'] = 'Csökkenő rendezés';
$string['highgradeletter'] = 'Magas';
$string['identifier'] = 'Felhasználó azonosítási szempontja';
$string['idnumbers'] = 'Azonosítószámok';
$string['ignore'] = 'Kihagy';
$string['import'] = 'Importálás';
$string['importcsv'] = 'CSV importálása';
$string['importcsv_help'] = 'Az osztályzatokat CSV-állományból importálhatja az alábbiak szerint:

* Az állomány minden sora egy rekordot tartalmaz
* Minden rekord egymástól vesszővel vagy más elválasztóval határolt adatokat tartalmaz
* Az első rekord az állomány fennmaradó részének a formáját meghatározó mezőneveket tartalmazza
* Kötelezően szerepelnie kell egy felhasználót azonosító mezőnévnek - ez lehet felhasználónév, azonosítószám vagy e-mail cím

Egy helyesen formált állományt előállíthat úgy, hogy először csak néhány osztályzatot exportál. Ezután az állományt szerkesztheti és CSV-állományként elmentheti.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Importálás egyéni eredményként (csak ezen kurzus esetén)';
$string['importerror'] = 'Hiba, a kód meghívása nem a megfelelő paraméterekkel  történt.';
$string['importfailed'] = 'Sikertelen importálás. Adatimportálás nem történt.';
$string['importfeedback'] = 'Importálási visszajelzés';
$string['importfile'] = 'Állomány importálása';
$string['importfilemissing'] = 'Állomány importálására nem kerül sor, térjen vissza az űrlaphoz és töltsön föl egy érvényes állományt.';
$string['importfrom'] = 'Importálás helye';
$string['importoutcomenofile'] = 'A feltöltött állomány üres vagy hibás. Ellenőrizze, érvényes-e az állomány. A probléma a(z) {$a} soron jelentkezett; az az oka, hogy az adatsorok nem rendelkeznek annyi oszloppal, amennyivel az első sor (a fejléc), vagy az importált állományhoz nincsenek meg a szükséges fejlécek. Az exportált állomány alapján ellenőrizheti, hogy néz ki egy érvényes fejléccel rendelkező állomány.';
$string['importoutcomes'] = 'Eredmények importálása';
$string['importoutcomes_help'] = 'Eredmények importálhatók az exportált eredményekkel azonos formájú csv-állományokból.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Importálási eredmény #{$a->id} azonosítójú "{$a->name}" esetén';
$string['importplugins'] = 'Segédprogramok importálása';
$string['importpreview'] = 'Nyomtatási kép importálása';
$string['importsettings'] = 'Beállítások importálása';
$string['importskippednomanagescale'] = 'Nem jogosult új skála felvételére, ezért a(z) "{$a}" eredmény kimaradt, mivel ahhoz új skálát kellett volna fölvenni';
$string['importskippedoutcome'] = 'Ebben a környezetben már létezik "{$a}" rövid nevű eredmény, az importált állományban lévő ezért kimaradt.';
$string['importstandard'] = 'Importálás standard eredményekként';
$string['importsuccess'] = 'A pont importálása sikerült';
$string['importxml'] = 'XML importálása';
$string['includescalesinaggregation'] = 'Skálák szerepeltetése az összegzésben';
$string['includescalesinaggregation_help'] = 'Módosíthatja azt, hogy a skálák számokként bekerüljenek-e minden kurzus minden osztályozónaplójának minden összegzett osztályzatába. VIGYÁZAT: ezen beállítás módosítása esetén minden összegzett osztályzatot újraszámol a rendszer.';
$string['incorrectcourseid'] = 'Hibás volt a kurzus-azonosító';
$string['incorrectcustomscale'] = '(Hibás egyéni tartomány, módosítsa.)';
$string['incorrectminmax'] = 'A minimumnak a maximumnál kisebbnek kell lennie';
$string['inherit'] = 'Örököl';
$string['intersectioninfo'] = 'Információ a tanuló/pontszám tekintetében';
$string['invalidgradeexporteddate'] = 'Érvénytelen exportálási dátum: vagy régebbi egy évnél, vagy a jövőt illetően formátuma érvénytelen.';
$string['item'] = 'Tétel';
$string['iteminfo'] = 'Tétel adatai';
$string['iteminfo_help'] = '<p>A tétellel kapcsolatos adatok rögzítésére szolgáló hely. A megadott szöveg sehol máshol nem jelenik meg.</p>';
$string['itemname'] = 'Tétel neve';
$string['itemnamehelp'] = 'A tétel modulból származó neve.';
$string['items'] = 'Tételek';
$string['itemsedit'] = 'Osztályozási tétel szerkesztése';
$string['keephigh'] = 'A legmagasabb megtartása';
$string['keephigh_help'] = 'Bekapcsolása esetén csak a legmagasabb X pontot tartja meg, ahol az X a kiválasztott érték.';
$string['keephighestvalues'] = 'A legmagasabb {$a} érték megtartása';
$string['keymanager'] = 'Kulcs kezelője';
$string['lessthanmin'] = 'A(z) {$a->itemname} {$a->username} esetén megadott pont nagyobb a maximálisan megengedettnél';
$string['letter'] = 'Betű';
$string['lettergrade'] = 'Betűpontozás';
$string['lettergradenonnumber'] = 'Az alacsony és/vagy magas pont nem számjegyes volt';
$string['letterpercentage'] = 'Betű (százalék)';
$string['letterreal'] = 'Betű (valós)';
$string['letters'] = 'Betűk';
$string['linkedactivity'] = 'Kapcsolt tevékenység';
$string['linkedactivity_help'] = '<p>Meghatároz egy opcionális tevékenységet, amelyhez ez az eredménytétel kapcsolódik. Ezzel mérhető a tanulói teljesítmény olyan kritériumok alapján, amelyeket a tevékenységhez tartozó pont nem értékel.</p>';
$string['linktoactivity'] = 'Kapcsolás a(z) {$a->title} című {$a->name} tevékenységhez';
$string['lock'] = 'Zárolás';
$string['locked'] = 'Zárolt';
$string['locked_help'] = 'Bejelölése esetén a pontokat a kapcsolódó tevékenység a továbbiakban nem fogja tudni automatikusan frissíteni.';
$string['locktime'] = 'Ezután zárolandó';
$string['locktimedate'] = 'Ezután zárolandó: {$a}';
$string['lockverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} zárolása';
$string['lowest'] = 'Legalacsonyabb';
$string['lowgradeletter'] = 'Alacsony';
$string['manualitem'] = 'Kézi tétel';
$string['mapfrom'] = 'Illesztés innen';
$string['mapfrom_help'] = 'Válassza ki a tábla felhasználót (felhasználónévvel, azonosítószámmal vagy e-mail címmel) azonosító adatokat tartalmazó oszlopát.';
$string['mappings'] = 'Osztályozási tétel illesztései';
$string['mappings_help'] = 'A tábla osztályzatokat tartalmazó egyes oszlopaihoz válassza ki az osztályzatoknak megfelelő pontozási tételt.';
$string['mapto'] = 'Illesztés ehhez';
$string['mapto_help'] = 'Válassza ki az \'Átvitel innen\' mezőhöz kiválasztottakkal egyező azonosító adatokat..';
$string['max'] = 'Legmagasabb';
$string['maxgrade'] = 'Max. osztályzat';
$string['meanall'] = 'Az összes pont';
$string['meangraded'] = 'Nem üres pontok';
$string['meanselection'] = 'Oszlopátlagokhoz kiválasztott pontok';
$string['meanselection_help'] = 'Válassza ki az oszlopátlagokban megjelenő pontok típusát. A pont nélküli cellák kimaradhatnak vagy 0-nak számíthatnak (alapbeállítás).';
$string['median'] = 'Középérték';
$string['min'] = 'Legalacsonyabb';
$string['minimum_show'] = 'Minimális osztályzat megjelenítése';
$string['minimum_show_help'] = 'A minimális osztályzat pontok és súlyok számítására használatos. Ha nem jelenik meg, alapértéke 0 lesz, és nem lehet szerkeszteni.';
$string['minmaxtouse'] = 'Számításban használt legalacsonyabb és legmagasabb osztályzat';
$string['minmaxtouse_desc'] = 'Ez a beállítás szabja meg, hogy adott osztályzat esetén kezdeti legalacsonyabb és legmagasabb osztályzatot, vagy az osztálynaplóban megjelenő osztályzat kiszámításához az osztályozási tétel beállításában megadott legalacsonyabb és legmagasabb osztályzatot használja-e. A módosítást lehetőleg ne csúcsidőben hajtsa végre, mert az összes osztályzat újraszámítása megterheli a szervert.';
$string['minmaxtouse_help'] = 'Ez a beállítás szabja meg, hogy adott osztályzat esetén kezdeti legalacsonyabb és legmagasabb osztályzatot, vagy az osztálynaplóban megjelenő osztályzat kiszámításához az osztályozási tétel beállításában megadott legalacsonyabb és legmagasabb osztályzatot használja-e.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Megjegyzés: egyes osztályzatok módosultak az osztálynaplóban megjelenő osztályzat kiszámítása során a legalacsonyabb és a legmagasabb osztályzat változásából adódó következetlenség miatt. A változásokat ellenőrizze és fogadja el.';
$string['minmaxupgradefixbutton'] = 'Következetlenség feloldása';
$string['minmaxupgradewarning'] = 'Megjegyzés: egyes osztályzatok módosultak az osztálynaplóban megjelenő osztályzat kiszámítása során a legalacsonyabb és a legmagasabb osztályzat változásából adódó következetlenség miatt. A következetlenség feloldásához kattintson az alábbi gombra; emiatt egyes osztályzatok módosulni fognak.';
$string['missingitemtypeoreid'] = 'A grade_edit_tree_column_select::get_item_cell($item, $params) 2. paraméteréből hiányzik a tömbkulcs (itemtype vagy eid)';
$string['missingscale'] = 'Skálát kell kiválasztani';
$string['mode'] = 'Leggyakoribb';
$string['modgrade'] = 'Osztályzat';
$string['modgrade_help'] = 'Válassza ki a tevékenységhez kapcsolódó osztályozás típusát. Skála esetén a Skála lenyíló menüből választhat. Pont esetén megadhatja a tevékenységért járó maximális pontszámot.';
$string['modgradecantchangegradetype'] = 'A típust nem módosíthatja, mert már születtek osztályzatok.';
$string['modgradecantchangegradetypemsg'] = 'Már vannak osztályzatok, ezért a típusuk nem módosítható. Ha a maximális osztályzatot szeretné módosítani, először döntse el, változzanak-e a meglévő osztályzatok.';
$string['modgradecantchangegradetyporscalemsg'] = 'Már vannak osztályzatok, ezért a típus és a tartomány nem módosítható.';
$string['modgradecantchangeratingmaxgrade'] = 'A maximális osztályzatot nem módosíthatja, ha az értékelendő tevékenységhez már vannak osztályzatok.';
$string['modgradecantchangescale'] = 'A tartományt nem módosíthatja, mert már születtek osztályzatok.';
$string['modgradecategorycantchangegradetypemsg'] = 'Az osztályozás típusa nem módosítható. Ha módosítani akarja a maximális osztályzatot, előbb el kell döntenie, módosuljanak-e a meglévő osztályzatok,';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Az osztályozás típusa meglévő osztályzatok miatt nem módosítható.';
$string['modgradecategoryrescalegrades'] = 'Felülírt osztályzatok átminősítése';
$string['modgradecategoryrescalegrades_help'] = 'A maximális osztályzatok módosítása során el kell döntenie, módosuljanak-e a meglévő százalékos osztályzatok is,

\'Igen\' esetén a  meglévő felülírt osztályzatok átminősítése során a százalékos osztályzatok nem változnak.,

Ha pl. \'Igen\' esetén a  maximális osztályzat 10-ről 20-ra módosul, egy 6/10 (60%) osztályzat 12/20-ra (60%) változik, \'Nem\' esetén viszont az osztályzat nem változik, ezért kézzel kell beállítani a helyes pontszámokat.';
$string['modgradedonotmodify'] = 'Ne módosítson meglévő osztályzatokat.';
$string['modgradeerrorbadpoint'] = 'Érvénytelen pontérték. 1 és {$a} közötti egész számnak kell lennie.';
$string['modgradeerrorbadscale'] = 'Érvénytelen skálát választott. Az alábbiak közül kell választania egyet.';
$string['modgrademaxgrade'] = 'Maximális osztályzat';
$string['modgraderescalegrades'] = 'Meglévő osztályzatok megváltoztatása';
$string['modgraderescalegrades_help'] = 'Osztályozási tétel maximális osztályzatának módosításakor meg kell adnia, hogy emiatt változzanak-e a százalékosztályzatok is.

\'Igen\' esetén a meglévő osztályzatok úgy változnak, hogy a százalékosztályzatok ugyanazok maradnak.

\'Igen\' esetén például egy tétel maximális osztályzatának 10-ről 20-ra módosításakor a 6/10 (60%) osztályzat 12/20-ra (60%) változik. \'Nem\' esetén viszont az osztályzat 6/10-ről (60%) 6/20-ra (30%) módosul, ezért a helyes pontszámhoz az osztályozási tételeket kézzel kell módosítani.';
$string['modgradetype'] = 'Típus';
$string['modgradetypenone'] = 'Nincs';
$string['modgradetypepoint'] = 'Pont';
$string['modgradetypescale'] = 'Skála';
$string['morethanmax'] = 'A(z) {$a->itemname} esetén {$a->username} részére beírt pont nagyobb, mint a megengedett legmagasabb';
$string['moveselectedto'] = 'A kiválasztott elemek áthelyezése ide:';
$string['movingelement'] = '{$a} áthelyezése';
$string['multfactor'] = 'Szorzó';
$string['multfactor_help'] = '<p>Az a tényező, amellyel az osztályozási tétel összes pontját meg kell szorozni.</p>';
$string['multfactorvalue'] = 'Szorzó {$a} esetén';
$string['mustchooserescaleyesorno'] = 'Megváltoztatja a meglévő osztályzatokat?';
$string['mygrades'] = 'Felhasználói menü hivatkozása az osztályzatokra';
$string['mygrades_desc'] = 'Ezzel kapcsolódhat a felhasználói menüből egy külső osztálynaplóhoz.';
$string['mypreferences'] = 'Beállításaim';
$string['myreportpreferences'] = 'Jelentéseim beállításai';
$string['navmethod'] = 'Böngészési mód';
$string['neverdeletehistory'] = 'Soha ne törölje az előzményt';
$string['newcategory'] = 'Új kategória';
$string['newitem'] = 'Új pontozási elem';
$string['newoutcomeitem'] = 'Új eredményelem';
$string['no'] = 'Nem';
$string['nocategories'] = 'A kurzushoz nincs, vagy nem lehetett hozzáadni pontkategóriát';
$string['nocategoryname'] = 'Nincs megadva kategórianév.';
$string['nocategoryview'] = 'Nincs megtekinthető kategória';
$string['nocourses'] = 'Még nincsenek kurzusok';
$string['noforce'] = 'Ne írja elő';
$string['nogradeletters'] = 'Nincs beállítva pontozó betű';
$string['nogradesreturned'] = 'Nincs kapott pont';
$string['noidnumber'] = 'Nincs azonosítószám';
$string['nolettergrade'] = 'Nincs pontozó betű ehhez';
$string['nomode'] = 'Nem érvényes';
$string['nonnumericweight'] = 'Nem számjegyes érték érkezett ehhez';
$string['nonunlockableverbose'] = 'A pont nem oldható fel, amíg a(z) {$a->itemname} fel van oldva.';
$string['nonweightedpct'] = 'súlyozatlan %';
$string['nooutcome'] = 'Nincs eredmény';
$string['nooutcomes'] = 'Az eredménytételeket kurzuseredményhez kell kötni, de a kurzusban nincsenek eredmények. Hozzáad egyet?';
$string['nopermissiontoresetweights'] = 'Súlyok visszaállítása nem engedélyezett';
$string['nopublish'] = 'Ne tegye közzé';
$string['noreports'] = 'A portálon nem tanul és nem tanít.';
$string['norolesdefined'] = 'Nincs szerep megadva a Rendszergazda > Pontok > Általános beállítások > Pontozott szerepek esetén';
$string['noscales'] = 'Az eredményeket kurzusskálához vagy globális skálához kell kötni, de a kurzusban nincsenek ilyenek. Hozzáad egyet?';
$string['noselectedcategories'] = 'nem voltak kiválasztva kategóriák.';
$string['noselecteditems'] = 'nem voltak kiválasztva tételek.';
$string['notenrolled'] = 'Jelenleg egy kurzust sem vett fel.';
$string['notteachererror'] = 'Ennek a használatához tanárnak kell lennie.';
$string['nousersloaded'] = 'Nincs betöltve felhasználó';
$string['nouserstograde'] = 'Nincs osztályozásra váró felhasználó';
$string['numberofgrades'] = 'Pontok száma';
$string['onascaleof'] = '{$a->grademin} és {$a->grademax} közötti skálán';
$string['operations'] = 'Műveletek';
$string['options'] = 'Lehetőségek';
$string['others'] = 'Egyebek';
$string['outcome'] = 'Eredmény';
$string['outcome_help'] = 'Ezen osztályozási tétel eredménye.';
$string['outcomeassigntocourse'] = 'Másik eredmény hozzárendelése a kurzushoz';
$string['outcomecategory'] = 'Kategória eredményeinek létrehozása';
$string['outcomecategorynew'] = 'Új kategória';
$string['outcomeconfirmdelete'] = 'Biztosan törli a(z) "{$a}" eredményt?';
$string['outcomecreate'] = 'Új eredmény hozzáadása';
$string['outcomedelete'] = 'Eredmény törlése';
$string['outcomefullname'] = 'Teljes név';
$string['outcomeitem'] = 'Eredménytétel';
$string['outcomeitemsedit'] = 'Eredménytétel szerkesztése';
$string['outcomereport'] = 'Eredményről szóló jelentés';
$string['outcomes'] = 'Eredmények';
$string['outcomescourse'] = 'Kurzusban használt eredmények';
$string['outcomescoursecustom'] = 'Testre szabott (nem mozgatható)';
$string['outcomescoursenotused'] = 'Standard nincs használatban';
$string['outcomescourseused'] = 'Standard használatos (nem mozgatható)';
$string['outcomescustom'] = 'Testre szabott eredmények';
$string['outcomeshortname'] = 'Rövid név';
$string['outcomesstandard'] = 'Standard eredmények';
$string['outcomesstandardavailable'] = 'Elérhető standard eredmények';
$string['outcomestandard'] = 'Standard eredmény';
$string['outcomestandard_help'] = '<p>A standard eredmény az egész portálon minden kurzus számára elérhető.</p>';
$string['overallaverage'] = 'Globális átlag';
$string['overridden'] = 'Felülírva';
$string['overridden_help'] = '<p>Bekapcsolása esetén a felülírt címkével megakadályozható minden későbbi próbálkozás a pontérték automatikus módosítására. A címkét gyakran az osztályozónapló belülről állítja, de ezen űrlapelem segítségével kézi úton ki-be kapcsolható.</p>';
$string['overriddennotice'] = 'A tevékenységgel kapcsolatos végső pontja kézzel módosítva lett.';
$string['overridecat'] = 'Kategóriaosztályzatok kézi felülírásának engedélyezése';
$string['overridecat_help'] = 'Kikapcsolása esetén a kategóriaosztályzatokat nem lehet felülírni.';
$string['overridesitedefaultgradedisplaytype'] = 'Portál alapbeállításainak felülírása';
$string['overridesitedefaultgradedisplaytype_help'] = '<p>Ezen jelölőnégyzet bejelölésével kapcsolhatja be a portálon az osztályozónaplóban megjelenő pontok kijelzésének alapbeállításait. Ezzel űrlapelemeket kapcsol be, melyekkel tetszése szerint határozhat meg pontozó betűket és ponthatárokat.</p>';
$string['overrideweightofa'] = '{$a} súly felülírása';
$string['parentcategory'] = 'Szülőkategória';
$string['pctoftotalgrade'] = '%-a az összpontszámnak';
$string['percent'] = 'Százalék';
$string['percentage'] = 'Százalék';
$string['percentageletter'] = 'Százalék (betű)';
$string['percentagereal'] = 'Százalék (valós)';
$string['percentascending'] = 'Rendezés növekvő százalék szerint';
$string['percentdescending'] = 'Rendezés csökkenő százalék szerint';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Eltolás';
$string['plusfactor_help'] = '<p>Az a szám, amely a szorzó alkalmazása után a jelen osztályozási tétel minden pontjához hozzáadódik.</p>';
$string['plusfactorvalue'] = 'Eltolási érték  {$a} esetén';
$string['points'] = 'pont';
$string['pointsascending'] = 'Rendezés növekvő pontok szerint';
$string['pointsdescending'] = 'Rendezés csökkenő pontok szerint';
$string['positionfirst'] = 'Első';
$string['positionlast'] = 'Utolsó';
$string['preferences'] = 'Beállítások';
$string['prefgeneral'] = 'Általános';
$string['prefletters'] = 'Pontozó betűk és határértékek';
$string['prefrows'] = 'Speciális sorok';
$string['prefshow'] = 'Mutatás/elrejtés váltogatása';
$string['previewrows'] = 'Sorok nyomtatási képe';
$string['privacy:metadata:categorieshistory'] = 'Az osztályozási kategóriák korábbi változatainak a rekordja';
$string['privacy:metadata:filepurpose'] = 'A naplóban egy felhasználó visszajelzési állományai';
$string['privacy:metadata:grade_import_newitem'] = 'Az osztályozás importálásából az új grade_item nevek tárolására használt ideiglenes tábla';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Importálások egy tételét azonosító egyedi tételkód';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Az adatokat importáló felhasználó';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Új osztályozási tétel neve';
$string['privacy:metadata:grade_import_values'] = 'Osztályzatok importálásából használt ideiglenes tábla';
$string['privacy:metadata:grade_import_values:feedback'] = 'Osztályozási visszajelzés';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Nyers osztályzatérték';
$string['privacy:metadata:grade_import_values:importcode'] = 'Importálások egy tételét azonosító egyedi tételkód';
$string['privacy:metadata:grade_import_values:importer'] = 'Az adatokat importáló felhasználó';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Megjelölendő, ha csak a visszajelzést importálták';
$string['privacy:metadata:grade_import_values:userid'] = 'Az a felhasználó, akinek az osztályzatát importálták';
$string['privacy:metadata:grades'] = 'Az osztályzatok rekordja';
$string['privacy:metadata:grades:aggregationstatus'] = 'Az összesítés állapota';
$string['privacy:metadata:grades:aggregationweight'] = 'Az összesítés súlya';
$string['privacy:metadata:grades:feedback'] = 'A visszajelzés';
$string['privacy:metadata:grades:finalgrade'] = 'Az osztályzat';
$string['privacy:metadata:grades:information'] = 'További információk az osztályzatról';
$string['privacy:metadata:grades:timemodified'] = 'Az osztályzat utolsó módosításának az időpontja';
$string['privacy:metadata:grades:userid'] = 'Az osztályzattal rendelkező felhasználó azonosítója';
$string['privacy:metadata:grades:usermodified'] = 'A rekordot utoljára módosító felhasználó azonosítója';
$string['privacy:metadata:gradeshistory'] = 'A korábbi osztályzatok rekordja';
$string['privacy:metadata:history:loggeduser'] = 'A verziószámozás idején bejelentkezett felhasználó azonosítója';
$string['privacy:metadata:history:timemodified'] = 'A verziószámozás időpontja';
$string['privacy:metadata:itemshistory'] = 'Az osztályozási tételek korábbi változatainak a rekordja';
$string['privacy:metadata:outcomes'] = 'Az eredmények rekordja';
$string['privacy:metadata:outcomes:timemodified'] = 'A rekord módosításának az időpontja';
$string['privacy:metadata:outcomes:usermodified'] = 'A rekordot utoljára módosító felhasználó';
$string['privacy:metadata:outcomeshistory'] = 'Az eredmények korábbi változatainak a rekordja';
$string['privacy:metadata:scale'] = 'Skálák rekordja';
$string['privacy:metadata:scale:timemodified'] = 'A rekord utolsó módosításának időpontja';
$string['privacy:metadata:scale:userid'] = 'A rekordot utoljára módosító felhasználó';
$string['privacy:metadata:scalehistory'] = 'Skálák korábbi verzióinak rekordja';
$string['privacy:path:relatedtome'] = 'Hozzám kapcsolódó';
$string['privacy:request:historyactiondelete'] = 'Törlés';
$string['privacy:request:historyactioninsert'] = 'Beszúrás';
$string['privacy:request:historyactionupdate'] = 'Frissítés';
$string['privacy:request:unknowndeletedgradeitem'] = 'Ismeretlen (az osztályozási tétel törlődött)';
$string['profilereport'] = 'Felhasználói profilról szóló jelentés';
$string['profilereport_help'] = 'A felhasználó profiloldalán használatos pontozói jelentés.';
$string['publishing'] = 'Közzététel';
$string['publishingoptions'] = 'Osztályzat közzétételének lehetőségei';
$string['quickfeedback'] = 'Gyors visszajelzés';
$string['quickgrading'] = 'Gyors osztályozás';
$string['quickgrading_help'] = '<p>Gyors pontozás során az osztályozó jelentés minden pontcellájába bekerül egy szövegmező, ahol egyszerre szerkeszthet több pontot is. Ezután a Frissítés gombra kattintva egyszerre hajthatja végre az összes módosítást, így nem kell egyenként sort keríteni erre.</p>';
$string['range'] = 'Tartomány';
$string['rangedecimals'] = 'Tartomány tizedesjegyei';
$string['rangedecimals_help'] = 'Tartományhoz kijelzendő tizedesjegyek száma';
$string['rangesdecimalpoints'] = 'Tartományon belül látható tizedesjegyek';
$string['rangesdecimalpoints_help'] = 'Meghatározza, hány tizedesjegy jelenjen meg az egyes tartományok esetén, vagy a kategória vagy osztályozási tétel globális beállítását használja inkább (öröklés).';
$string['rangesdisplaytype'] = 'Tartomány megjelenítésének típusa';
$string['rangesdisplaytype_help'] = '<p>Megadja az egyes tartományok megjelenítésének módját. Az Öröklés kiválasztása esetén az egyes oszlopok megjelenítési típusa lesz használatos.</p>';
$string['rank'] = 'Sorrend';
$string['rawpct'] = 'Nyers %';
$string['real'] = 'Valós';
$string['realletter'] = 'Valós (betű)';
$string['realpercentage'] = 'Valós (százalék)';
$string['recalculatinggrades'] = 'Osztályzatok újraszámítása';
$string['recovergradesdefault'] = 'Pontok alapbeállításának visszaállítása';
$string['recovergradesdefault_help'] = 'Pontok alapbeállításának visszaállítása felhasználó újbóli beiratkoztatása esetén';
$string['refreshpreview'] = 'Előnézet frissítése';
$string['regradeanyway'] = 'Újrapontozás mindenképpen';
$string['removeallcoursegrades'] = 'Összes pont törlése';
$string['removeallcoursegrades_help'] = 'Bejelölése esetén minden kézzel hozzáadott pontozási tétel törlődik az osztálynaplóból a felülírt, kizárt, rejtett és zárolt osztályzatokkal együtt. Csak a tevékenységekhez kapcsolódó pontozási tételek őrződnek meg.';
$string['removeallcourseitems'] = 'Összes elem és kategória törlése';
$string['removeallcourseitems_help'] = 'Bejelölése esetén minden kézzel hozzáadott kategória és pontozási tétel törlődik az osztálynaplóból a felülírt, kizárt, rejtett és zárolt osztályzatokkal együtt. Csak a tevékenységekhez kapcsolódó pontozási tételek őrződnek meg.';
$string['report'] = 'Jelentés';
$string['reportdefault'] = 'Jelentés alapbeállítása ({$a})';
$string['reportplugins'] = 'Jelentés segédprogramjai';
$string['reportsettings'] = 'Jelentés beállításai';
$string['reprintheaders'] = 'Fejlécek újranyomtatása';
$string['resetweights'] = '{$a->itemname} súlyainak visszaállítása';
$string['resetweightsshort'] = 'Súlyok visszaállítása';
$string['respectingcurrentdata'] = 'a jelenlegi beállítás változatlanul hagyása';
$string['rowpreviewnum'] = 'Sorok előnézete';
$string['rowpreviewnum_help'] = 'Az importálás megerősítése előtt megtekintheti az importálandó adatokat. Ez a beállítás szabja meg, hány sor jelenjen meg az előnézetben.';
$string['savechanges'] = 'Módosítások mentése';
$string['savepreferences'] = 'Beállítások mentése';
$string['scaleconfirmdelete'] = 'Biztosan törli "{$a}" skáláját?';
$string['scaledpct'] = 'Léptékes %';
$string['seeallcoursegrades'] = 'Lásd az összes kurzuspontot';
$string['select'] = '{$a} kiválasztása';
$string['selectalloroneuser'] = 'Az összes vagy egy felhasználó kiválasztása';
$string['selectauser'] = 'Válasszon ki egy felhasználót';
$string['selectdestination'] = '{$a} célállomásának kiválasztása';
$string['separator'] = 'Elválasztó';
$string['separator_help'] = 'Válassza ki a CSV-állományban használandó elválasztót (ez általában a vessző).';
$string['sepcolon'] = 'Kettőspont';
$string['sepcomma'] = 'Vessző';
$string['sepsemicolon'] = 'Pontosvessző';
$string['septab'] = 'Tabulátor';
$string['setcategories'] = 'Kategóriák beállítása';
$string['setcategorieserror'] = 'Súlyok hozzáadása előtt kategóriákat kell a kurzusához beállítania.';
$string['setgradeletters'] = 'Pontozó betűk beállítása';
$string['setpreferences'] = 'Preferenciák beállítása';
$string['setting'] = 'Beállítás';
$string['settings'] = 'Beállítások';
$string['setweights'] = 'Súlyok beállítása';
$string['showactivityicons'] = 'Tevékenységikonok megjelenítése';
$string['showactivityicons_help'] = '<p>Megjelenjenek-e a tevékenységikonok a tevékenységek neve mellett?</p>';
$string['showallhidden'] = 'Az összes rejtett megjelenítése';
$string['showallstudents'] = 'Minden tanuló megjelenítése';
$string['showanalysisicon'] = 'A Pontszámok elemzése ikon megjelenítése';
$string['showanalysisicon_desc'] = 'A Pontszámok elemzése ikon megjelenítésének bekapcsolása. Ha a tevékenységmodul támogatja, a Pontszámok elemzése ikon a pontszámok és elérésük részletesebb kifejtését tartalmazó oldalra viszi a felhasználót.';
$string['showanalysisicon_help'] = 'Ha a tevékenységmodul támogatja, a Pontszámok elemzése ikon a pontszámok és elérésük részletesebb kifejtését tartalmazó oldalra viszi a felhasználót.';
$string['showaverage'] = 'Átlag kijelzése';
$string['showaverage_help'] = 'Megjelenjen-e az átlagok oszlopa? Ha az átlag kiszámítása csak néhány osztályzat alapján történik, a tanulók megbecsülhetik a többiek osztályzatát. A teljesítmény érdekében az átlag közelítőleges, ha rejtett elemeken alapszik.';
$string['showaverages'] = 'Oszlopátlagok megjelenítése';
$string['showaverages_help'] = 'Oszlopátlagok megjelenítése a pontozói jelentésben.';
$string['showcalculations'] = 'Számítások megjelenítése';
$string['showcalculations_help'] = 'Bekapcsolásakor szerkesztés közben egy kalkulátorikon jelenik meg az egyes osztályozási tételek és kategóriák mellett egy látható kijelzéssel, mely mutatja, hogy az osztályozási tétel kiszámítása folyamatban van.';
$string['showcontributiontocoursetotal'] = 'A kurzus összpontszámához való hozzájárulás kijelzése';
$string['showcontributiontocoursetotal_help'] = 'Megjelenjen a kurzus összpontszámához osztályozási tételenként való hozzájárulást mutató hasáb (súlyozás alkalmazása után)?';
$string['showeyecons'] = 'Megjelenítő/elrejtő ikonok kijelzése';
$string['showeyecons_help'] = 'Az egyes pontok mellett megjelenjen-e egy Mutat/Elrejt ikon (a felhasználói láthatóság beállításához).';
$string['showfeedback'] = 'Visszajelzés megjelenítése';
$string['showfeedback_help'] = 'Megjelenjen-e a visszajelzések oszlopa?';
$string['showgrade'] = 'Pontok kijelzése';
$string['showgrade_help'] = 'Megjelenjen-e az osztályzatok oszlopa?';
$string['showgroups'] = 'Csoportok megjelenítése';
$string['showhiddenitems'] = 'Rejtett tételek megjelenítése';
$string['showhiddenitems_help'] = 'Teljesen rejtve legyenek-e a rejtett osztályozási tételek, vagy nevük megjelenjen-e a tanulók számára.

* Rejtettek megjelenítése - A rejtett osztályozási tételek neve látható, de a tanulói pontok nem
* Rejtve csak eddig - Az osztályozási tételek a "rejtve eddig" alatt beállított időpontig nem láthatók, utána a teljes tétel látszik
* Nem látszik - A rejtett osztályozási tételek egyáltalán nem láthatók';
$string['showhiddenuntilonly'] = 'Rejtve csak eddig';
$string['showingaggregatesonly'] = 'Csak az összegzések kijelzése';
$string['showingfullmode'] = 'Teljes nézet kijelzése';
$string['showinggradesonly'] = 'Csak az osztályzatok kijelzése';
$string['showlettergrade'] = 'Osztályzat kijelzése betűkkel';
$string['showlettergrade_help'] = 'Megjelenjen-e a betűvel kifejezett osztályzatok oszlopa?';
$string['showlocks'] = 'Zárak megjelenítése';
$string['showlocks_help'] = 'Legyen-e Lezár/Felold ikon az egyes pontok mellett?';
$string['shownohidden'] = 'Nem látszik';
$string['shownooutcomes'] = 'Eredmények elrejtése';
$string['shownumberofgrades'] = 'Pontok számának feltüntetése az átlagokban';
$string['shownumberofgrades_help'] = 'Az egyes összegzett pontok kijelzése az egyes átlagok mellett zárójelben. Például: 45 (34).';
$string['showonlyactiveenrol'] = 'Csak a beiratkozottak megjelenítése';
$string['showonlyactiveenrol_help'] = 'Ez határozza meg, hogy az osztálynaplóban csak a beiratkozottak jelenjenek meg. Bekapcsolása esetén a felfüggesztett felhasználók nem jelennek meg az osztálynaplóban.';
$string['showpercentage'] = 'Százalék megjelenítése';
$string['showpercentage_help'] = 'Megjelenjen-e az egyes osztályozási tételek százalékos értéke?';
$string['showquickfeedback'] = 'Gyors visszajelzés megjelenítése';
$string['showquickfeedback_help'] = 'A gyors visszajelzés a pontozói jelentés minden cellájába beszúr egy szövegbeviteli mezőt, így egyszerre sok pont visszajelzését tudja szerkeszteni. Ezután a Frissítés gombra kattintva az összes módosítást egyszerre végezheti el ahelyett, hogy egyesével hajtaná őket végre.';
$string['showrange'] = 'Tartományok kijelzése';
$string['showrange_help'] = 'Megjelenjen-e tartomány oszlopa?';
$string['showranges'] = 'Tartományok megjelenítése';
$string['showranges_help'] = 'Az osztályozói jelentésben megjelenít egy sort az egyes osztályozási tételek lehetséges tartományával.';
$string['showrank'] = 'Besorolás mutatása';
$string['showrank_help'] = 'Megjelenjen-e a tanuló helyzete az osztályhoz viszonyítva az egyes osztályozási tételek esetén?';
$string['showuserimage'] = 'Felhasználói profilképek megjelenítése';
$string['showuserimage_help'] = 'A pontozói jelentésben megjelenjen-e a felhasználó neve mellett a profilképe?';
$string['showverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} megjelenítése';
$string['showweight'] = 'Súlyozások kijelzése';
$string['showweight_help'] = 'Megjelenjen-e az osztályozási súlyok oszlopa?';
$string['simpleview'] = 'Egyszeres nézet';
$string['singleview'] = '{$a} egyedi nézete';
$string['sitewide'] = 'Egész portálra kiterjedő';
$string['sort'] = 'rendez';
$string['sortasc'] = 'Rendezés növekvő sorrendben';
$string['sortbyfirstname'] = 'Keresztnév szerinti rendezés';
$string['sortbylastname'] = 'Vezetéknév szerinti rendezés';
$string['sortdesc'] = 'Rendezés csökkenő sorrendben';
$string['standarddeviation'] = 'Szórás';
$string['stats'] = 'Statisztika';
$string['statslink'] = 'Statisztikák';
$string['student'] = 'Tanuló';
$string['studentsperpage'] = 'Tanuló oldalanként';
$string['studentsperpage_help'] = 'A pontozói jelentésben oldalanként megjelenítendő tanulók száma.';
$string['studentsperpagereduced'] = 'Oldalankénti tanulószám csökkentése {$a->originalstudentsperpage} -- {$a->studentsperpage}. Esetleg növelje a PHP max_input_vars beállítását erről:{$a->maxinputvars}.';
$string['subcategory'] = 'Szokásos kategória';
$string['submissions'] = 'Leadott munkák';
$string['submittedon'] = 'Leadva:';
$string['sumofgradesupgradedgrades'] = 'Megjegyzés: a portál frissítése során az Osztályzatok összege Természetes összesítési módszerre változott, ezért ajánlatos átvizsgálnia a napló osztályzatait.';
$string['switchtofullview'] = 'Váltás teljes nézetre';
$string['switchtosimpleview'] = 'Váltás egyszerű nézetre';
$string['tabs'] = 'Tabulátorok';
$string['topcategory'] = 'Felettes kategória';
$string['total'] = 'Összesen';
$string['totalweight100'] = 'Az összsúly 100-zal egyenlő';
$string['totalweightnot100'] = 'Az összsúly nem egyenlő 100-zal';
$string['turnfeedbackoff'] = 'Visszajelzés kikapcsolása';
$string['turnfeedbackon'] = 'Visszajelzés bekapcsolása';
$string['typenone'] = 'Nincs';
$string['typescale'] = 'Skála';
$string['typescale_help'] = '<p>Skálázó pontozás használata esetén kiválaszthat egy skálát. Tevékenységalapú osztályozási tételhez a skála a tevékenységet frissítő oldalról választható ki.</p>';
$string['typetext'] = 'Szöveg';
$string['typevalue'] = 'Érték';
$string['uncategorised'] = 'Nincs kategorizálva';
$string['unchangedgrade'] = 'A pont nem módosult';
$string['unenrolledusersinimport'] = 'Az importálás az alábbi pontokat eredményezte a kurzusba be nem iratkozott felhasználók esetén: {$a}';
$string['unlimitedgrades'] = 'Korlátlan pontszámok';
$string['unlimitedgrades_help'] = 'Alapesetben az osztályzatokat az osztályozási tétel maximális és minimális értéke határolja be. Ezzel a beállítással megszünteti a korlátot és 100% fölötti osztályzatokat rögzíthet közvetlenül az osztályozónaplóban';
$string['unlock'] = 'Zár feloldása';
$string['unlockverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} feloldása';
$string['unused'] = 'Nem használatos';
$string['updatedgradesonly'] = 'Csak új vagy frissített pontok exportálása';
$string['upgradedgradeshidemessage'] = 'Figyelmeztetés kihagyása';
$string['upgradedminmaxrevertmessage'] = 'Változások visszaállítása';
$string['uploadgrades'] = 'Pontok feltöltése';
$string['useadvanced'] = 'Részletes funkciók használata';
$string['usedcourses'] = 'Használatban lévő kurzusok';
$string['usedgradeitem'] = 'Használatban lévő osztályozási tétel';
$string['usenooutcome'] = 'Nem használ eredményt';
$string['usenoscale'] = 'Nem használ skálát';
$string['usepercent'] = 'Százalék használata';
$string['user'] = 'Felhasználó';
$string['userenrolmentsuspended'] = 'A beiratkozás szünetel.';
$string['userfields_show'] = 'Felhasználói mezők megjelenítése';
$string['userfields_show_help'] = 'További felhasználói mezők - pl. e-mail cím - megjelenítése az osztályozási jelentésen. A konkrét megjelenített mezőket a "showuseridentity" portálbeállítás vezérli.';
$string['usergrade'] = '{$a->fullname} ({$a->useridnumber}) felhasználó {$a->gradeidnumber} tétel esetén';
$string['userid'] = 'Felhasználói azonosító';
$string['useridnumberwarning'] = 'Az azonosítószám nélküli felhasználók az exportálásból kimaradnak, mivel nem importálhatók.';
$string['usermappingerror'] = 'Felhasználó-azonosítási hiba. Nincs "{$a->value}" értékkel rendelkező {$a->field} felhasználó.';
$string['usermappingerrorcurrentgroup'] = 'A felhasználó nem az adott csoport tagja.';
$string['usermappingerrormultipleusersfound'] = 'Felhasználóillesztési hiba: Több felhasználó létezik {$a->field} és "{$a->value}" értékkel. Használjon egyedi illesztési mezőt.';
$string['usermappingerrorusernotfound'] = 'Felhasználó-azonosítási hiba. Nincs ilyen felhasználó.';
$string['userpreferences'] = 'Felhasználói beállítások';
$string['useweighted'] = 'Súlyozás használata';
$string['verbosescales'] = 'Szöveges skálák';
$string['verbosescales_help'] = 'A leíró skálában számok helyett szavak szerepelnek. Ha \'Igen\'-t állít be, a számok mellett a leírásokat is importálni fogja, \'Nem\' esetén csak a számokat.';
$string['viewbygroup'] = 'Csoport';
$string['viewgrades'] = 'Osztályzatok kijelzése';
$string['weight'] = 'Súly';
$string['weight_help'] = 'Kategóriában vagy kurzusban több osztályozási tétel viszonylagos értékének meghatározására való érték.';
$string['weightcourse'] = 'Súlyozott pontok használata a kurzushoz';
$string['weightedascending'] = 'Növekvő súlyozott százalék szerinti rendezés';
$string['weighteddescending'] = 'Csökkenő súlyozott százalék szerinti rendezés';
$string['weightedpct'] = 'súlyozott %';
$string['weightedpctcontribution'] = 'súlyozott %-os hozzájárulás';
$string['weightofa'] = '{$a} súlya';
$string['weightorextracredit'] = 'Súly vagy külön kreditpont';
$string['weightoverride'] = 'súlybeállítás';
$string['weightoverride_help'] = 'Ha nem jelöli be, a súly visszaáll az automatikusan számított értékre. Ellenkező esetben elmarad a súly automatikus beállítása.';
$string['weights'] = 'Súlyok';
$string['weightsadjusted'] = 'Súlyait összesen 100-ra állítottuk.';
$string['weightsedit'] = 'Súlyok és külön kreditpontok szerkesztése';
$string['weightuc'] = 'Számított súly';
$string['writinggradebookinfo'] = 'Osztályozónapló beállításainak írása';
$string['xml'] = 'XML';
$string['yes'] = 'Igen';
$string['yourgrade'] = 'Pontja';
