<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'hu', version '3.9'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutdemosite'] = 'Bemutató portálunk egy komplett Moodle-portál néhány mintakurzussal, melyeket tanárként, tanulóként, vagy akár rendszergazdaként kipróbálhat. Ha kezdetben összekavarodnak a dolgok, aggodalomra semmi ok: az egész portál óránként visszaáll kiinduló állapotába.';
$string['aboutdemositetitle'] = 'Bemutató portál';
$string['aboutintro'] = 'A Moodle nyílt forráskódú kurzuskezelő rendszer (CMS), más néven oktatáskezelő rendszer (LMS) vagy virtuális oktatási környezet (VLE). Szerte a világban nagy népszerűségre tett szert az oktatók körében, akik a programot tanulóik számára online dinamikus weboldalak létrehozására használják. Működtetéséhez valamilyen webszerverre kell telepítenie, amely lehet akár valamelyik számítógépük, akár egy internetes szolgáltató cég gépe.';
$string['aboutoverview'] = '<p>A Moodle-projekt középpontjában az oktatók tanítást kezelő és támogató eszközökkel való ellátása áll, ugyanakkor a Moodle igen sokféleképpen használható:</p>
<ul>
<li>a Moodle egyformán használható akár több ezer tanuló oktatására, akár egy általános iskolában, vagy akár a pedagógiát hobbiként űző amatőr számítógépén.</li>
<li>A programot számos intézményben működtetik teljesen online kurzusok megtartására, mások csak a tantermi oktatás kiegészítésére (vegyes oktatásra) használják.</li>
<li>Sok felhasználó előszeretettel támaszkodik a beépített tevékenységekre (pl. fórumok, adatbázis és wikik), melyek révén egy-egy témakörben összedolgozó tanuló közösségeket alakítanak ki (a szociális konstruktivista pedagógia szellemében), mások a Moodle-t elsősorban az ismeretanyag (pl. standard SCORM-csomagok formájában való) átadására, valamint felméréseken és teszteken keresztül az ismeretanyag elsajátításának ellenőrzésére használják.</li>
</ul>';
$string['aboutoverviewtitle'] = 'Mi a Moodle?';
$string['aboutstatistics'] = 'A Moodle ingyenesen letölthető, a regisztráció önkéntes, így nem rendelkezünk átfogó információkkal minden felhasználóról. Az általunk ismert adatok alapján automatikusan előállítunk néhány érdekes grafikont és számadatot a Statisztika oldalon.';
$string['aboutstatisticsheading'] = 'Moodle-statisztika';
$string['aboutstatisticstitle'] = 'Moodle.org:Moodle-statisztika';
$string['activeusers24hours'] = 'Az elmúlt 24 órában belépett regisztrált felhasználó:';
$string['activeuserspastmonth'] = 'Az elmúlt hónapban belépett regisztrált felhasználó:';
$string['browsegittitle'] = 'Böngészés a forráskódban';
$string['cachedef_frontpagecolumn'] = 'Címoldali hasábok';
$string['cachedef_usefulposts'] = 'Hasznos üzenetek';
$string['communities'] = 'Közösségek';
$string['communitiesmy'] = 'Közösségeim';
$string['community'] = 'Közösség';
$string['communityadministration'] = 'Közösség kezelése';
$string['communitycurrent'] = 'Aktuális közösség';
$string['communityenrolme'] = 'Legyen a közösség tagja';
$string['communityenrolmentoptions'] = 'Csatlakozás egy közösséghez';
$string['communityintro'] = 'A Moodle kiterjedt és sokszínű felhasználói közösséggel rendelkezik több mint <a href="http://moodle.org/userpics">{$a->usercount} regisztrált felhasználóval</a> csak ezen az egyetlen Moodle-portálon, akik több mint <a href="http://download.moodle.org/langpack/">{$a->langcount} nyelvet</a> beszélnek <a href="http://moodle.org/sites">{$a->countrycount} országot képviselve</a> (<a href="http://moodle.org/stats">további statisztikák</a>).';
$string['communityjoinbyyourself'] = 'Egyéni csatlakozás';
$string['communityjoinbyyourselfas'] = 'Egyéni csatlakozás {$a->rolename} szerepkörben';
$string['communitynoguestaccess'] = 'A közösségi területre vendégek nem léphetnek be, próbáljon meg bejelentkezni.';
$string['communitynotenrollable'] = 'Egyénileg nem csatlakozhat a közösséghez. Forduljon a közösség ügyintézőjéhez.';
$string['communitysomeallowguest'] = 'Egyes közösségek engedélyezhetik vendégek belépését.';
$string['communityunenrolme'] = 'A(z) {$a} közösség elhagyása';
$string['conferencecenter'] = 'Moodle-Konferenciaközpont';
$string['connectedsites'] = 'Egyes Moodle-portálok hálózati Moodle használatával kapcsolódnak a moodle.org portálhoz, így itteni hitelesítését követően közvetlenül be tud jelentkezni a portálra.';
$string['contactbugs'] = 'A Moodle Trackerben (Moodle-nyomkövető) új kérdést vethet fel, melyben a szoftverrel vagy bármely moodle.org portállal kapcsolatos problémáit oszthatja meg másokkal.';
$string['contactbugstitle'] = 'Hibajelentés';
$string['contactintro'] = 'Válasszon az alábbi elérhetőségek közül:';
$string['contactlogin'] = 'Minden egyéb kérdéssel kapcsolatosan lépjen be erre a portálra és használja az oldalon megjelenő kapcsolatfelvevő űrlapot.';
$string['contactmoodlecom'] = 'Ha a használati engedéllyel, védjeggyel vagy forgalmazási kérdésekkel, továbbá a Moodle fontosabb fejlesztéseivel kapcsolatosan van közölnivalója, forduljon a <a href="http://moodle.com/">Moodle.com</a> címen elérhető ügyfélszolgálathoz.';
$string['contactmoodlecomhelpdesk'] = 'A Moodle.com ügyfélszolgálata';
$string['contactmoodlecomtitle'] = 'Moodle.com';
$string['contactmoodleorgemail'] = 'A moodle.org portálon lévő fiók jóváhagyásával kapcsolatos gondok esetén írjon e-mailt erre a címre:';
$string['contactmoodleorglogin'] = 'Lépjen be a portálra most';
$string['contactmoodleorgother'] = 'Minden egyéb kérdés esetén használja az alábbi kapcsolatfelvevő űrlapot.';
$string['contactmoodleorgtitle'] = 'Moodle.org';
$string['contactsecurity'] = 'A biztonsággal kapcsolatos kérdéseket úgyszintén fölvetheti a Moodle-nyomkövetőben, feltéve, hogy a biztonsági szintet megfelelő módon állítja be.';
$string['contactsent'] = 'Üzenetét e-mailben továbbítottuk a Moodle-közösség vezetőjéhez';
$string['contactsupport'] = 'A Moodle-szoftver használatával kapcsolatos támogatásért látogasson el támogató oldalunkra, ahol számos segítséget nyújtó forrással ismerkedhet meg.';
$string['contactsupporttitle'] = 'Támogatás';
$string['developerlist'] = 'Írási jogosultsággal rendelkező fejlesztők teljes jegyzéke';
$string['developermeetings'] = 'Fejlesztői találkozók';
$string['developers'] = 'A Moodle fő fejlesztési irányát a Moodle.com csapata vezeti, melynek munkáját a világ minden részéből több száz fejlesztő támogatja. Ezen fejlesztők közül sokan közvetlenül felelősek egyes modulok és segédprogramok kidolgozásáért is.';
$string['developerstitle'] = 'Fejlesztők';
$string['developmentdocs'] = 'Dokumentációnk zöme a Moodle Docs között található, beleértve a specifikációkat, az ötleteléseket, az eljárásokat, a szabványokat és a felhasználói kézikönyveket.';
$string['developmentdocstitle'] = 'Fejlesztői dokumentáció';
$string['developmentintro'] = 'Olyan átlátható és nyitott fejlesztési folyamatot tűztünk ki célul, amely a felhasználók teljes közösségét bekapcsolódásra invitálja. Örömmel vesszük PHP-programozók közreműködését, de lehetőség nyílik a közreműködésre vitákban való részvétel, tesztelés, visszajelzés és dokumentálás terén is.';
$string['developmenttracker'] = 'Minden fejlesztési problémát (pl. hibát, új jellemzőket és javításokat) a a Moodle-nyomkövetőben rögzítünk és kezelünk. Ebből megállapíthatjha, ki min dolgozik, és minden vitához hozzászólhat. Ha egy konkrét kérdés iránt érdeklődik, előbb keressen rá a nyomkövetőben és ne feledjen el <strong>szavazni</strong> az Ön által legsürgősebbnek vélt kérdésekkel kapcsolatosan, mert szavazatai segítenek a fejlesztési prioritások meghatározásában.';
$string['donations'] = 'A Moodle használata semmilyen anyagi kötelezettséggel nem jár. Ugyanakkor a közösségből sokan adománnyal segítik a projektet, amelyből a fejlesztőket támogatjuk.';
$string['donationsmoney'] = 'Közvetlen készpénzadománnyal is hozzájárulhat az alap támogatásához. Ezek a pénzek a fejlesztési kívánságlistán szereplő funkciók megvalósítását szolgálják mindannyiunk érdekében. Ha a főbb valuták valamelyikében bankkártyáról szeretne adományozni, kattintson az alábbi PayPal-gombra..<br /><br />A 10,- USD-nél nagyobb összeget adományozók egy éven keresztül feltüntethetik nevüket ezen az oldalon. Fizetés után ne felejtse el megnyomni a "continue" [tovább] gombot, amely megjeleníti az adatai szerkesztésére szolgáló űrlapot.';
$string['donationsservices'] = 'Ha valamilyen Moodle-szolgáltatásra, például portálüzemeltetésre, támogatásra, telepítésre, egyedi programozásra, kurzusfejlesztésre vagy tanácsadásra van szüksége, forduljon a helyi hivatalos <a href="http://moodle.com/">Moodle-partnerhez</a> (hirdetését megtalálja a portálon). A partnerek bevételük meghatározott százalékát a Moodle Fejlesztési Alapítványnak juttatják, így mindenki jól jár';
$string['donationstitle'] = 'Adományok';
$string['donationstrust'] = 'A  Moodle Fejlesztési Alapítványa programozókat bíz meg a Moodle fejlesztésével és támogatja az egyéb, pl. a moodle.org portál működtetésével kapcsolatos kiadásokat.';
$string['downloadcore'] = 'A forgalmazás fő eszköze a standard alapcsomagok közreadása. Ezek egy sor alapfejlesztők által fenntartott modult tartalmaznak, amelyek szinte tetszőleges, PHP-val és telepített adatbázissal rendelkező rendszeren futtathatók.';
$string['downloadcoretitle'] = 'Standard Moodle-csomagok';
$string['downloadintro'] = 'A Moodle nyílt forráskódú, <a href="http://docs.moodle.org/dev/License">GPL-licenc</a> alapján hozzáférhető fejlesztés. Minden csomagunkat ingyenesen letöltheti és használhatja.';
$string['downloadlang'] = 'A Moodle friss verzióiban új nyelvek hozzáadása automatikusan történik portáljának adminisztrációs menüje segítségével. Ha régebbi verziót használ, az új nyelvi csomagokat kézzel kell letöltenie.';
$string['downloadlangtitle'] = 'Nyelvi csomagok';
$string['downloadlogotitle'] = 'A Moodle logói';
$string['downloadmac'] = 'Ha még nincs telepített webszervere, ezekkel a komplett csomagokkal egyszerűen telepítheti a Moodle-t bármely Mac OS X rendszert futtató Apple-gépre.';
$string['downloadmactitle'] = 'Moodle Mac OS X rendszerhez';
$string['downloadmodules'] = 'Ha az alapcsomagokon kívül külön modulokkal vagy segédprogramokkal bővítené Moodle-portálját, böngéssze végig gazdag adatbázisunkat.';
$string['downloadmodulestitle'] = 'Segédprogramok';
$string['downloadthemes'] = 'A Moodle-portál megjelenését radikálisan módosíthatja egy másik stílus alkalmazásával. A Moodle felhasználói által kidolgozott és megosztott stílusokról adatbázist vezetünk.';
$string['downloadthemestitle'] = 'Stílusok';
$string['downloadviagitcvs'] = 'A Moodle-t emellett letöltheti <a href="http://docs.moodle.org/en/Git_for_Administrators">Git</a> vagy <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">CVS</a> segítségével is.';
$string['downloadwin'] = 'Ha még nincs telepített webszervere, ezekkel a komplett csomagokkal egyszerűen telepítheti a Moodle-t bármely Microsoft Windows rendszert futtató számítógépre.';
$string['downloadwintitle'] = 'Moodle Windows rendszerhez';
$string['erroradminonly'] = 'A felületre csak rendszergazdák léphetnek be.';
$string['erroralreadyvoted'] = 'Már szavazott erre:  {$a}';
$string['errormaxmessages'] = 'Csak legfeljebb 3 üzenetet küldhet.';
$string['errornomainnews'] = 'A portálhoz nincs vagy nem hozható létre fő hírfórum.';
$string['errorsendingmail'] = 'Hiba az üzenet küldése közben. Próbálja meg később, vagy forduljon a rendszergazdához.';
$string['events'] = 'Habár online tanulással foglalkozunk, kapóra jöhet egy tantermi összejövetel. Konferenciákkal (itteni elnevezése: MoodleMoot) és más eseményekkel kapcsolatban az alábbi ugrópontokon kap részletesebb tájékoztatást.';
$string['eventstitle'] = 'Események';
$string['feed_events'] = 'Események';
$string['feed_events_more'] = 'További naptárbejegyzések';
$string['feed_news'] = 'Hirdetmények';
$string['feed_news_more'] = 'Az összes hirdetmény megjelenítése';
$string['feed_resources'] = 'Tananyagok';
$string['feed_useful'] = 'Hasznos hozzászólások';
$string['feed_useful_more'] = 'További hozzászólások';
$string['focusbox_community'] = 'Támogatás és közösségi fórumok';
$string['focusbox_community_text'] = 'Szerezzen támogatást és ossza meg ötleteit a saját nyelvén';
$string['focusbox_community_viewall'] = 'Minden közösség';
$string['focusbox_future'] = 'Segítse a Moodle jövőjének formálását!';
$string['focusbox_future_crowdfund'] = 'Közösségi finanszírozású projektek';
$string['focusbox_future_gdf'] = 'Fejlesztői megbeszélések';
$string['focusbox_future_research'] = 'Moodle-kutatás';
$string['focusbox_future_roadmap'] = 'Iránytű';
$string['focusbox_future_text'] = 'Értesüljön a közelgő lépésekről és járuljon hozzá az eszköz formálásához.';
$string['focusbox_settingup'] = 'Beállítás';
$string['focusbox_settingup_community'] = 'Közösségi támogatás';
$string['focusbox_settingup_download'] = 'Ingyenes letöltés';
$string['focusbox_settingup_hosting'] = 'Üzemeltetés';
$string['focusbox_settingup_install'] = 'Telepítés';
$string['focusbox_settingup_own'] = 'Önerőből';
$string['focusbox_settingup_partner'] = 'Moodle-partneren keresztül';
$string['focusbox_settingup_plugins'] = 'Segédprogramok';
$string['focusbox_settingup_support'] = 'Fizetős támogatás';
$string['focusbox_teaching'] = 'Oktatás a Moodle segítségével';
$string['focusbox_teaching_books'] = 'Könyvek';
$string['focusbox_teaching_courses'] = 'Kurzusok és tartalom';
$string['focusbox_teaching_docs'] = 'Dokumentáció';
$string['focusbox_teaching_text'] = 'Fedezze fel a Moodle számtalan funkcióját és elérhető tananyagait.';
$string['focusbox_theproject'] = 'A Moodle-projekt';
$string['focusbox_theproject_about'] = 'A Moodle-ról';
$string['focusbox_theproject_devs'] = 'Fejlesztők';
$string['focusbox_theproject_hq'] = 'Moodle-központ';
$string['focusbox_theproject_partners'] = 'Moodle-partnerek';
$string['focusbox_theproject_stats'] = 'Statisztika';
$string['focusbox_theproject_text'] = 'Tudjon meg többet a Moodle-projektről és nyitott együttműködési kezdeményezéseinkről';
$string['focusbox_uptodate'] = 'Legyen naprakész';
$string['focusbox_uptodate_buzz'] = 'Moodle-vélemények';
$string['focusbox_uptodate_planet'] = 'A Moodle-bolygó';
$string['focusbox_uptodate_security'] = 'Biztonsági értesítések';
$string['focusbox_uptodate_social'] = 'Közösségi média';
$string['focusbox_uptodate_text'] = 'A Moodle-lal kapcsolatos legfrissebb hírek, fejlesztések, vélemények';
$string['frontpagewelcome1'] = 'A Moodle egy kurzuskezelő rendszer (CMS), más néven oktatáskezelő rendszer (LMS) vagy virtuális oktatási környezet (VLE). Olyan ingyenes internetes alkalmazás, amellyel az oktatók hatékony online tanulási környezeteket hozhatnak létre.';
$string['frontpagewelcome2'] = 'A moodle.org az a közösségi portál, ahol a Moodle készül és a fejlesztés megvitatása zajlik. A menük segítségével nézzen körbe és, ha kedve van, csatlakozzon!';
$string['frontpagewelcometitle'] = 'Üdvözöljük a Moodle közösségében!';
$string['generaldeveloperforum'] = 'Általános fejlesztői fórum';
$string['graphpopulation'] = 'A Moodle elterjedésének grafikonja';
$string['graphregistrationmap'] = 'A Moodle regisztrációs térképe';
$string['graphregistrationmapdesc'] = 'A 10 legnépszerűbb regisztrált portál  {$a} országból.';
$string['graphusersites'] = 'Moodle-felhasználók és portálok';
$string['heroslide_community_description'] = 'Üdvözöljük a Moodle-közösségben. Fedezze fel a világ egyik legnagyobb nyílt forráskóddal dolgozó csapata nyitott együttműködésen alapuló munkájának értékét.';
$string['heroslide_community_headline'] = 'Közösségen alapuló, globális támogatású';
$string['heroslide_community_slidecontrol'] = 'Globális közösség által támogatott';
$string['heroslide_global_description'] = 'A több mint 100 nyelven elérhető Moodle-t kis és nagy szervezetekben és intézményekben felhasználók milliói használják megelégedéssel szerte a világban.';
$string['heroslide_global_headline'] = 'Tanulási környezetek működtetése szerte a világban';
$string['heroslide_global_slidecontrol'] = 'Tanulási környezetek működtetése szerte a világban';
$string['heroslide_link_demo'] = 'Demó';
$string['heroslide_link_features'] = 'Jellemzők';
$string['heroslide_link_forums'] = 'Közösségi fórumok';
$string['heroslide_link_sites'] = 'Regisztrált protálok';
$string['heroslide_link_stats'] = 'Statisztika';
$string['heroslide_link_stories'] = 'Bővebben';
$string['heroslide_power_description'] = 'A világ ingyenes tanulási platformja, amely hatékony online oktatási és tanulási feltételeket biztosít úgy együttműködésen alapuló, mint egyéni elsajátítási környezetben.';
$string['heroslide_power_headline'] = 'Hatékony. Biztonságos. Nyílt forráskódú.';
$string['heroslide_power_slidecontrol'] = 'Robusztus és nyílt forráskódú tanulási platform';
$string['heroslide_story_description'] = '“A technológiai alapú tanulás vezető szereplőjeként támogatja a felfedező, kreatív elsajátítást.” - Darrell Evans professzor, oktatási rektorhelyettes, Monash Egyetem';
$string['heroslide_story_headline'] = 'Az oktatás és a tanulás fejlesztése minden szinten';
$string['heroslide_story_slidecontrol'] = 'Moddle-lal kapcsolatos történetek a világ minden szegletéből';
$string['jobs'] = 'A Moddle-lal kapcsolatos állásokkal kapcsolatban nézze meg a világ minden részére kiterjedő adatbázisunkat.';
$string['logoinfo'] = 'A Moodle™ elnevezés a Moodle Trust bejegyzett védjegye.

Ha a nevet vagy a logót valamely alapvető Moodle-szolgáltatás (pl. a Moodle üzemeltetése, a Moodle támogatása, a Moodle tanúsítása, Moodle-oktatás, Moodle-tanácsadás, Moodle-testreszabás, Moodle-tananyagfejlesztés, Moodle-stílustervezés, Moodle-összeépítés, Moodle-telepítés stb.) hirdetésére vagy egy szoftvercsomag elnevezésére kívánja használni, írásban közvetlenül az Alapítványtól a [moodle.com helpdesk] révén írásos engedélyt kell kérnie (http://moodle.com/helpdesk/), a védjegyekre vonatkozó szokásos korlátozások betartásával.

Egyéb helyzetekben az elnevezést korlátozás nélkül használhatja (például ha a Moodle-t kurzustartásra használja). Ha kétsége támad, keressen bennünket a [moodle.com helpdesk] segítségével (http://moodle.com/helpdesk/). Szívesen adunk hivatalos írásos engedélyt vagy segítünk a névhasználat kérdésében.';
$string['logotitle'] = 'Moodle-logó';
$string['moodledocs'] = 'A Moodle dokumentációja';
$string['moodlepartner_corporate'] = 'Vállalati oktatás';
$string['moodlepartner_other'] = 'Egyéb szektorok';
$string['moodlepartner_school'] = 'Iskola';
$string['moodlepartner_university'] = 'Egyetem';
$string['mycoursesintro'] = 'Jelenleg a közösségi portál alábbi "kurzusaiba" iratkozott be, melyek mindegyike egy vagy több fórumot működtet.';
$string['nameabout'] = 'Névjegy';
$string['nameaboutmoodle'] = 'A Moodle névjegye';
$string['namecommercial'] = 'Kereskedelmi szolgáltatások';
$string['namecommunity'] = 'Közösség';
$string['namecontact'] = 'Kapcsolat';
$string['namedevelopment'] = 'Fejlesztés';
$string['namedocumentation'] = 'Dokumentáció';
$string['namedownloads'] = 'Letöltések';
$string['nameevents'] = 'Események';
$string['nameforums'] = 'Fórumok';
$string['namemycourses'] = 'Kurzusaim';
$string['namenetwork'] = 'Kapcsolódó portálok';
$string['namenews'] = 'Hírek';
$string['namesecurity'] = 'Biztonsági hírek';
$string['namesupport'] = 'Támogatás';
$string['networkinfo'] = 'Az alábbi Moodle-portálok Moodle-hálózaton keresztül kapcsolódnak a moodle-org portálhoz, így innen közvetlenül beléphet.';
$string['networkintro'] = 'Az alábbi Moodle-portálok kapcsolódnak a moodle.org portálhoz a hálózati Moodle révén, vagyis innen közvetlenül be tud jelentkezni.';
$string['networktitle'] = 'Kapcsolódó portálok';
$string['newregistrations'] = 'Új regisztrációk';
$string['newstitle'] = 'Hirdetmények';
$string['noenrolledcoursesyet'] = 'Ezen a portálon még egyetlen kurzusra sem iratkozott be';
$string['partnerslogan'] = 'A Moodle-projektet szerte a világban 60 tanúsított Moodle-partner támogatja.<br/><a href="http://moodle.com/partners/about/">Tudjon meg többet</a> a Moodle-partnerek programjáról és keresse meg az Önhöz legközelebb lévő <a href="http://moodle.com/partners">Moodle-partnert</a>.';
$string['permalink'] = 'Permalink';
$string['pluginname'] = 'Moodle.org portál';
$string['popularissues'] = 'A legkedveltebb témák';
$string['recentlyratedposts'] = 'Aktuális értékelt hozzászólások';
$string['recentpart'] = 'Ezen az oldalon néhány olyan személy látható, aki a moodle.org portált ma használja.';
$string['registeredsites'] = 'Az intézményeknek nem szükséges senkit tájékoztatni a Moodle használatáról, mivel a Moodle nyílt forráskódú alkalmazás. Vannak azonban intézmények, amelyek a regisztráció mellett döntöttek. Ezek jegyzékét folyamatosan nyilvántartjuk.';
$string['registeredsitestitle'] = 'Regisztrált portálok';
$string['registereduserslastday'] = 'Új felhasználók az elmúlt 24 órában:';
$string['registereduserstotal'] = 'Összes regisztrált felhasználó:';
$string['registrationgraphalt'] = 'Összes adott idő alatti Moodle-regisztráció';
$string['registrationgraphdesc'] = 'Rendszeresen <a href="http://docs.moodle.org/en/Usage">végignézzük a portálokat</a> és ellenőrizzük, működnek-e még, ezért esetenként ez a szám csökkenhet.';
$string['registrationslast6months'] = 'Új regisztráció az elmúlt 6 hónapban.';
$string['registrationstotal'] = 'Összes jelenlegi regisztráció';
$string['resources_buzz'] = 'Vélemény';
$string['resources_courses'] = 'Kurzusok';
$string['resources_jobs'] = 'Állások';
$string['resources_plugins'] = 'Segédprogramok';
$string['roadmap'] = 'Iránytű a Moodle honlapjához';
$string['rssdescription'] = 'Aktuális vagy hasznosnak értékelt hozzászólások a moodle.org portálról.';
$string['rsstitle'] = 'A moodle.org portál fórumüzenetei.';
$string['searchmoodleorg'] = 'Keresés a moodle.org portálon';
$string['securitytitle'] = 'Biztonsági hirdetmények';
$string['shop'] = 'Szeretné valamiképpen jelezni, hogy Ön a közösségünk tagja? Látogasson el boltunkba, ahol pólókat, bögréket és mindenféle egyebet talál.';
$string['social-facebook-moodle'] = 'Hivatalos Moodle-oldal a Facebookon';
$string['social-googleplus-community'] = 'Hivatalos Moodle közösségi oldal a Google+-on';
$string['social-googleplus-moodle'] = 'Hivatalos Moodle-oldal a Google+-on';
$string['social-linkedin-moodle'] = 'Hivatalos Moodle-oldal a LinkedIn portálján';
$string['social-twitter-moodle'] = 'Hivatalos Moodle-bejelentések, összesített Moodle-hírek a  Planet Moodle és a Moodle Buzz portálokról, hasznos fórumüzenetekkel,';
$string['social-twitter-moodledev'] = 'Hírek és frissítések a Moodle fejlesztésével kapcsolatosan';
$string['social-twitter-moodlehq'] = 'Szöveges üzenetek a Moodle főhadiszállásáról';
$string['social-twitter-moodlejobs'] = 'Moodle-hoz kapcsolódó álláshirdetések';
$string['social-twitter-moodlenet'] = 'Megosztott Moodle-kurzusok és -tartalmak';
$string['social-twitter-moodleplugins'] = 'Frissen közzétett Moodle-kiegészítések';
$string['social-twitter-moodleresearch'] = 'Hírek és aktuális közlemények az éves Moodle-Kutatók Konferenciájáról és a Moodle-lal kapcsolatos kutatásokról';
$string['social-twitter-moodlesecurity'] = 'Moodle-hoz kapcsolódó biztonsági értesítések';
$string['social-twitter-moodlesites'] = 'Állapotfrissítések a Moodle főhadiszállása számára a portálok és szolgáltatások hálózatáról';
$string['social-twitter-moodlethemes'] = 'Frissen közzétett Moodle-stílusok';
$string['social-youtube-moodle'] = 'Hivatalos Moodle-csatorna a YouTube-on';
$string['socialinfo'] = 'Több közösségi médiaportálon vagyunk jelen annak érdekében, hogy felhívjuk a figyelmet a Moodle-projektre és megosszuk a Moodle világában zajló eseményeket és híreket. Kövesse a fejleményeket és találkozzon a közösség tagjaival!';
$string['socialtitle'] = 'Közösségi média';
$string['statscountries'] = 'Országok';
$string['statscourses'] = 'Kurzusok';
$string['statsenrolments'] = 'Beiratkozások';
$string['statsposts'] = 'Fórumhozzászólások';
$string['statsquestions'] = 'Tesztkérdések';
$string['statsresources'] = 'Tananyagok';
$string['statsteachers'] = 'Tanárok';
$string['statsusers'] = 'Felhasználók';
$string['supportbooks'] = 'Számos megvásárolható Moodle-könyv közül válogathat';
$string['supportcommercial'] = 'A <a href="http://moodle.com/">Moodle Partners</a> engedéllyel rendelkező szolgáltató vállalatok világhálózata, melyek elkötelezettek a nyílt forráskódú Moodle-projekt anyagi támogatása mellett. Ezek egy sor kereskedelmi szolgáltatást nyújtanak a Moodle-felhasználóknak szerte a világban:';
$string['supportdocs1'] = 'A Moodle Docs megfelelő kezdőpont, különösen annak a gyakran ismételt kérdéseket (FAQ) tartalmazó oldalai.';
$string['supportdocs2'] = 'A kapcsolódó dokumentáció könnyen elérhető a Moodle-portálja minden oldalának alján megjelenő "Az oldalhoz tartozó Moodle-dokumentumok" ugrópontról.';
$string['supportdocsfaq'] = 'Gyakran ismételt kérdések';
$string['supportdocslang'] = 'A Moodle Docs egyéb nyelveken';
$string['supportforums'] = 'Közösségünk tagjai általában a Moodle-alapú portál "kurzusaiban" lévő fórumokon keresztül kommunikálnak egymással. Fórumüzenetek küldéséhez "be kell iratkoznia" az adott kurzusba (a beiratkozás teljesen ingyenes).';
$string['supportforumsenglish'] = 'A felhasználók és a fejlesztők közötti legfontosabb támogatási és fejlesztési megbeszélések angol nyelven itt találhatók:';
$string['supportforumsenglishname'] = 'A Moodle használata';
$string['supportforumslang'] = 'A Moodle-használók legfontosabb angol nyelvű közösségi fóruma itt található:';
$string['supportforumslangname'] = 'A Moodle társalgója';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Számos egyéb fórumot is működtetünk, különféle nyelveken:';
$string['supportforumslistname'] = 'Az összes fórum felsorolása';
$string['supportintro'] = 'Nem hagyjuk magára! A Moodle sokféle segítséget kínál, ha valahol elakad.';
$string['top10countriesbyregistration'] = 'A 10 legtöbb regisztrált Moodle-portállal rendelkező ország';
$string['top10sitesbycourses'] = '10 legkiemelkedőbb portál kurzusok alapján';
$string['top10sitesbyusers'] = '10 legkiemelkedőbb portál felhasználók alapján';
$string['url-about'] = 'http://docs.moodle.org/en/About_Moodle';
$string['url-features'] = 'http://docs.moodle.org/en/Features';
$string['url-install'] = 'http://docs.moodle.org/en/Installation';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/en/';
$string['versionsused'] = 'Aktuális verziók';
