<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'dataform', language 'es_mx', version '3.9'.
 *
 * @package     dataform
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acccesstypesnotfound'] = 'Lo siento, no hay tipos de acceso instalados o habilitados. Por favor, contacte a su administrador para más detalles.';
$string['access'] = 'Acceso';
$string['accessadd'] = 'Añadir contexto de acceso';
$string['accessedit'] = 'Editando \'{$a}\'';
$string['accessenabled'] = 'Habilitado';
$string['accessnew'] = 'Nuevo {$a}';
$string['actions'] = 'Acciones de entrada';
$string['activityadministration'] = 'Administración de Actividad';
$string['activityicon'] = 'Ícono de actividad';
$string['activityicon_help'] = 'Usted puede subir un archivo de imagen para remplazar el ícono por defecto para la actividad Dataform que se muestra en la página del curso junto al enlace hacia la actividad.';
$string['alignment'] = 'Alineación';
$string['and'] = 'Y';
$string['andor'] = 'y/o';
$string['anonymousentries'] = 'Permitir entradas anónimas';
$string['anonymousentries_help'] = 'Si se habilita, los invitados y los usuarios-no-ingresados-al-sitio podrán añadir entradas en esta actividad.
Esto puede ser útil para aplicaciones tales como \'contáctenos\', en donde los visitantes al sitio pueden enviar una solicitud para contacto. La opción debe de ser habilitada por el administrador en las configuraciones del módulo.';
$string['ascending'] = 'Ascendente';
$string['author'] = 'Autor';
$string['authorinfo'] = 'Info autor';
$string['availablefrom'] = 'Disponible a partir de';
$string['availableplugins'] = 'Plugins disponibles';
$string['availableto'] = 'Disponible hasta';
$string['between'] = 'Entre';
$string['browse'] = 'Mirar';
$string['cancel'] = 'Cancelar';
$string['cancelbutton'] = 'Cancelar';
$string['cancelbutton_help'] = 'Cancela envío y regresa a la vista';
$string['cancelbutton_label'] = 'Botón para cancelar';
$string['characterpatterns'] = 'Patrones de caracteres';
$string['characterpatterns_help'] = 'Patrones de caracteres';
$string['columns'] = 'columnas';
$string['comment'] = 'Comentario';
$string['commentadd'] = 'Añadir comentario';
$string['commentbynameondate'] = 'por {$a->name} - {$a->date}';
$string['commentdelete'] = '¿Esta Usted seguro de querer eliminar este comentario?';
$string['commentdeleted'] = 'Comentario eliminado';
$string['commentedit'] = 'Editar comentario';
$string['commentempty'] = 'Comentario estaba vacío';
$string['commentinputtype'] = 'Tipo de entrada en comentario';
$string['comments'] = 'Comentarios';
$string['commentsallow'] = '¿Permitir comentarios?';
$string['commentsaved'] = 'Comentarios guardados';
$string['commentsn'] = '{$a} comentarios';
$string['commentsnone'] = 'Sin comentarios';
$string['completionentries'] = 'Los participantes deben añadir entradas:';
$string['completionentriesgroup'] = 'Requerir entradas';
$string['completionentrieshelp'] = 'requiriendo entradas para completar';
$string['completionspecificgrade'] = 'Los participantes deben de recibir calificación';
$string['completionspecificgradegroup'] = 'Requerir calificación específica';
$string['completionspecificgradehelp'] = 'Requerir calificación específica para completar';
$string['configanonymousentries'] = 'Este interruptor habilitará la posibilidad de entradas de visitante/anónimas para todos los dataforms. Usted todavía necesitará conectar manualmente las configuraciones para cada dataform.';
$string['configenablerssfeeds'] = 'Este interruptor habilitará la posibilidad de de canales RSS para todos los Dataforms. Usted todavía necesitará añadir vistas RSS en la instancia Dataform para generar un canal.';
$string['configmaxentries'] = 'Este valor determina el número máximo de entradas que pueden añadirse a una actividad dataform.';
$string['configmaxfields'] = 'Este valor determina el número máximo de campos que pueden añadirse a una actividad dataform.';
$string['configmaxfilters'] = 'Este valor determina el número máximo de filtros que pueden añadirse a una actividad dataform.';
$string['configmaxviews'] = 'Este valor determina el número máximo de vistas que pueden añadirse a una actividad dataform.';
$string['configmultigradeitems'] = 'Configurar a \'Sí\' para permitir múltiples ítems de calificación en una actividad Dataform.';
$string['configplugins'] = 'Por favor, habilite todos los plugins necesarios y arréglelos en un orden apropiado.';
$string['contains'] = 'Contiene';
$string['contentview'] = 'Contenido de vista';
$string['conversation'] = 'Conversación';
$string['correct'] = 'Correcto';
$string['csscode'] = 'Código CSS';
$string['cssinclude'] = 'CSS';
$string['cssincludes'] = 'Incluir CSS externo';
$string['csssaved'] = 'CSS guardado';
$string['cssupload'] = 'Subir archivos CSS';
$string['csvdelimiter'] = 'delimitador';
$string['csvenclosure'] = 'adjunto';
$string['csvfailed'] = 'No se pudo leer los datos crudos del archivo CSV';
$string['csvoutput'] = 'Salida CSV';
$string['csvsettings'] = 'Configuraciones CSV';
$string['csvwithselecteddelimiter'] = '<acronym title="Valores Separados por Coma ">CSV</acronym> texto con delimitador seleccionado:';
$string['dataform:addinstance'] = 'Añadir un nuevo dataform';
$string['dataform:approve'] = '** Obsoleta **';
$string['dataform:comment'] = '** Obsoleta **';
$string['dataform:entryanonymousadd'] = 'Entrada anónima - Añadir';
$string['dataform:entryanonymousdelete'] = 'Entrada anónima - Eliminar';
$string['dataform:entryanonymousexport'] = 'Entrada anónima - Exportar';
$string['dataform:entryanonymousupdate'] = 'Entrada anónima - Actualizar';
$string['dataform:entryanonymousview'] = 'Entrada anónima - Ver';
$string['dataform:entryanyadd'] = 'Cualquier entrada - Añadir';
$string['dataform:entryanydelete'] = 'Cualquier entrada - Eliminar';
$string['dataform:entryanyexport'] = 'Cualquier entrada - Exportar';
$string['dataform:entryanyupdate'] = 'Cualquier entrada - Actualizar';
$string['dataform:entryanyview'] = 'Cualquier entrada - Ver';
$string['dataform:entryearlyadd'] = 'Entrada temprana - Añadir';
$string['dataform:entryearlydelete'] = 'Entrada temprana - Eliminar';
$string['dataform:entryearlyupdate'] = 'Entrada temprana - Actualizar';
$string['dataform:entryearlyview'] = 'Entrada temprana - Ver';
$string['dataform:entrygroupadd'] = 'Entrada de grupo - Añadir';
$string['dataform:entrygroupdelete'] = 'Entrada de grupo - Eliminar';
$string['dataform:entrygroupexport'] = 'Entrada de grupo - Exportar';
$string['dataform:entrygroupupdate'] = 'Entrada de grupo - Actualizar';
$string['dataform:entrygroupview'] = 'Entrada de grupo - Ver';
$string['dataform:entrylateadd'] = 'Entrada tardía - Añadir';
$string['dataform:entrylatedelete'] = 'Entrada tardía - Eliinar';
$string['dataform:entrylateupdate'] = 'Entrada tardía - Actualizar';
$string['dataform:entrylateview'] = 'Entrada tardía - Ver';
$string['dataform:entryownadd'] = 'Entrada propia - Añadir';
$string['dataform:entryowndelete'] = 'Entrada propia - Eliminar';
$string['dataform:entryownexport'] = 'Entrada propia - Exportar';
$string['dataform:entryownupdate'] = 'Entrada propia - Actualizar';
$string['dataform:entryownview'] = 'Entrada propia - Ver';
$string['dataform:exportallentries'] = '** Obsoleta **';
$string['dataform:exportentry'] = '** Obsoleta **';
$string['dataform:exportownentry'] = '** Obsoleta **';
$string['dataform:indexview'] = 'Ver índice';
$string['dataform:manageaccess'] = 'Gestionar reglas de acceso';
$string['dataform:managecomments'] = '** Obsoleta **';
$string['dataform:managecss'] = 'Gestionar CSS';
$string['dataform:manageentries'] = 'Gestionar entradas';
$string['dataform:managefields'] = 'Gestionar campos';
$string['dataform:managefilters'] = 'Gestionar filtros';
$string['dataform:managejs'] = 'Gestionar JS';
$string['dataform:managenotifications'] = 'Gestionar reglas de notificación';
$string['dataform:managepresets'] = 'Gestionar preajustes';
$string['dataform:manageratings'] = '** Obsoleta **';
$string['dataform:managetemplates'] = 'Gestionar plantillas';
$string['dataform:managetools'] = 'Gestionar herramientas';
$string['dataform:manageviews'] = 'Gestionar vistas';
$string['dataform:messagingview'] = 'Ver mensajería';
$string['dataform:presetsviewall'] = 'Ver preajustes para todos los usuarios';
$string['dataform:rate'] = '** Obsoleta **';
$string['dataform:ratingsview'] = '** Obsoleta **';
$string['dataform:ratingsviewall'] = '** Obsoleta **';
$string['dataform:ratingsviewany'] = '** Obsoleta **';
$string['dataform:viewaccess'] = 'Ver - Acceso';
$string['dataform:viewaccessdisabled'] = 'Ver - Acceso deshabilitado';
$string['dataform:viewaccessearly'] = 'Ver - Acceso temprano';
$string['dataform:viewaccesshidden'] = '** Obsoleto **';
$string['dataform:viewaccesslate'] = 'Ver - Acceso tardío';
$string['dataform:viewanonymousentry'] = '** Obsoleta **';
$string['dataform:viewentry'] = '** Obsoleta **';
$string['dataform:viewfilteroverride'] = 'Ver - Anulación de filtro';
$string['dataform:writeentry'] = '** Obsoleta **';
$string['dataformearly'] = 'Esta actividad está agendada para comenzar a las {$a}';
$string['dataformnew'] = 'Nuevo Dataform';
$string['dataformnone'] = 'No se encontraron Dataforms';
$string['dataformnotready'] = 'Esta actividad no está lista para verse';
$string['dataformpastdue'] = 'Esta actividad tenía fecha esperada de {$a}';
$string['deleteactivity'] = 'Eliminar actividad';
$string['deletenotenrolled'] = 'Eliminar entradas por usuarios no inscritos';
$string['descending'] = 'Descendente';
$string['dfupdatefailed'] = '¡No se pudo actualizar dataform!';
$string['documenttype'] = 'Tipo de documento';
$string['dots'] = '...';
$string['download'] = 'Descargar';
$string['editing'] = 'Editando';
$string['editordisable'] = 'Deshabilitar editor';
$string['editorenable'] = 'Habilitar editor';
$string['email'] = 'Email';
$string['embed'] = 'Incrustar';
$string['embedded'] = 'Incrustada';
$string['embedded_help'] = 'Una vista en_línea seleccionada puede ser incrustada en la página del curso dentro de un iframe para permitir interactuar con la vista sin abandonar la página del curso.';
$string['empty'] = 'Vacía';
$string['enabled'] = 'Habilitado';
$string['entries'] = 'Entradas';
$string['entriesadded'] = '{$a} entrada(s) añadida(s)';
$string['entriesconfirmadd'] = 'Está a punto de duplicar {$a} entrada(s). ¿Desea hacerlo realmente?';
$string['entriesconfirmdelete'] = 'Está a punto de eliminar {$a} entrada(s). ¿Desea hacerlo realmente?';
$string['entriesconfirmduplicate'] = 'Usted está a punto de duplicar {$a} entrada(s). ¿Desea continuar?';
$string['entriesconfirmupdate'] = 'Está a punto de actualizar {$a} entrada(s). ¿Desea hacerlo realmente?';
$string['entriescount'] = '{$a} entrada(s)';
$string['entriesdeleteall'] = 'Eliminar todas las entradas';
$string['entriesdeleted'] = '{$a} entrada(s) eliminada(s)';
$string['entriesduplicated'] = '{$a} entrada(s) duplicada(s)';
$string['entriesfound'] = '{$a} entrada(s) encontrada(s)';
$string['entriesimport'] = 'Importar entradas';
$string['entrieslefttoadd'] = 'Usted debe añadir {$a} más entrada(s) para completar esta actividad';
$string['entrieslefttoaddtoview'] = 'Usted debe añadir {$a} más entrada(s) antes de que pueda ver las entradas de otros participantes.';
$string['entriesmanager'] = 'Gestor de Entradas';
$string['entriesmax'] = 'Máximo de entradas';
$string['entriesmax_help'] = 'El número máximo de entradas que puede añadirle a una actividad un usuario sin la capacidad manageentries.
<ul>
<li><b>-1:</b> Número ilimitado de entradas permitidas.
<li><b> 0:</b> Sin entradas permitidas.
<li><b> N:</b> N entradas permitidas (donde N es cualquier número positivo; por ejemplo,10).
</ul>
Si la actividad tiene intervalos, este número se aplica a cada intervalo; y el número máximo de entradas para la actividad completa es este número multiplicado por el número de intervalos.';
$string['entriesnotsaved'] = 'No se guardaron entradas. Por favor revise el formato del archivo subido.';
$string['entriespending'] = 'Pendiente';
$string['entriesrequired'] = 'Entradas requeridas';
$string['entriessaved'] = '{$a} entrada(s) guardada(s)';
$string['entriesupdated'] = '{$a} entrada(s) actualizada(s)';
$string['entry'] = 'Entrada';
$string['entryaddmultinew'] = 'Añadir nuevas entradas';
$string['entryaddnew'] = 'Añadir una nueva entrada';
$string['entryinfo'] = 'Información de entrada';
$string['entrynew'] = 'Nueva entrada';
$string['entrynoneforaction'] = 'No se encontraron entradas para la acción requerida';
$string['entrynoneindataform'] = 'Sin entradas en dataform';
$string['entryrating'] = 'Valoración de entrada';
$string['entrysaved'] = 'Su entrada ha sido guardada';
$string['entrysettings'] = 'Configuraciones de entradas';
$string['entrysettingsupdated'] = 'Configuraciones de entradas actualizadas';
$string['entrytemplate'] = 'Plantilla de entrada';
$string['entrytimelimit'] = 'Límite de tiempo para editar (minutos)';
$string['entrytype'] = 'Tipo de entrada';
$string['entrytype_help'] = 'Usted puede especificar un tipo de entrada cuando los tipos de entrada están definidos para la actividad. Las entradas serán entonces filtradas por ese tipo. Las entradas nuevas añadidas vía una vista con el tipo especificado serán asignadas a ese tipo. Usted puede definir tipos de entrada en el campo de Entrada (interna)';
$string['entrytypes'] = 'Tipos de entrada';
$string['equal'] = 'Igual';
$string['err_lowername'] = 'El nombre no puede contener MAYÚSCULAS';
$string['error:cannotbenegative'] = 'El valor no puede ser negativo';
$string['errorinvalidtimeto'] = 'Tiempo-hasta debe ser posterior a Tiempo-desde';
$string['errornoitemsselected'] = 'Debe seleccionarse al menos un ítem';
$string['event'] = 'Evento';
$string['event_entry_created'] = 'Entrada creada';
$string['event_entry_deleted'] = 'Entrada denegada';
$string['event_entry_updated'] = 'Entrada actualizada';
$string['event_field_content_updated'] = 'Contenido del campo actualizado';
$string['event_field_created'] = 'Campo creado';
$string['event_field_deleted'] = 'Campo eliminado';
$string['event_field_updated'] = 'Campo actualizado';
$string['event_filter_created'] = 'Filtro creado';
$string['event_filter_deleted'] = 'Filtro eliminado';
$string['event_filter_updated'] = 'Filtro actualizado';
$string['event_view_created'] = 'Vista creada';
$string['event_view_deleted'] = 'Vista eliminada';
$string['event_view_updated'] = 'Vista actualizada';
$string['event_view_viewed'] = 'Vista accesada';
$string['events'] = 'Eventos';
$string['export'] = 'Exportar';
$string['exportcontent'] = 'Exportar contenido';
$string['field'] = 'campo';
$string['fieldadd'] = 'Añadir un campo';
$string['fieldallowautolink'] = 'Permitir auto-ligar';
$string['fieldapplydefault'] = 'Aplicar valores por defecto al editar';
$string['fieldattributes'] = 'Atributos del campo';
$string['fieldcreate'] = 'Crear un nuevo campo';
$string['fielddefaultany'] = 'Cualquier entrada';
$string['fielddefaultcontent'] = 'Contenido por defecto';
$string['fielddefaultnew'] = 'Solamente entradas nuevas';
$string['fielddefaultvalue'] = 'Valor por defecto';
$string['fielddescription'] = 'Descripción del campo';
$string['fieldedit'] = 'Editando \'{$a}\'';
$string['fieldeditable'] = 'Editable';
$string['fieldids'] = 'IDs del campo';
$string['fieldmappings'] = 'Mapeos del Campo';
$string['fieldname'] = 'Nombre del campo';
$string['fieldnew'] = 'Nuevo {$a} campo';
$string['fieldnoneforaction'] = 'No se encontraron campos para la acción solicitada';
$string['fieldnoneindataform'] = 'No hay campos definidos para este dataform';
$string['fieldnonematching'] = 'No se encontraron campos que coincidan';
$string['fieldnotmatched'] = 'Los sguientes campos de su archivo no son conocidos en este dataform: {$a}';
$string['fieldpatterns'] = 'Patrones de entradas';
$string['fieldpatterns_help'] = 'Patrnes cuyo contenido es sensible a la entrada.';
$string['fieldplugins'] = 'Plugins del campo';
$string['fieldrequired'] = 'Usted debe poner un valor aquí';
$string['fieldrules'] = 'Reglas para editar campo';
$string['fields'] = 'Campos';
$string['fieldsadded'] = 'Campos añadidos';
$string['fieldsconfirmdelete'] = 'Usted está a punto de eliminar {$a} campo(s). ¿Quiere hacerlo?';
$string['fieldsconfirmduplicate'] = 'Usted está a punto de duplicar {$a} campo(s). ¿Quiere hacerlo?';
$string['fieldsdeleted'] = 'Campos eliminados. Usted puede necesitar actualizar las configuraciones de ordenamiento por defecto.';
$string['fieldsinternal'] = 'Campos internos';
$string['fieldsmax'] = 'Campos máximo';
$string['fieldsnonedefined'] = 'No hay campos definidos';
$string['fieldsupdated'] = 'Campos actualizados';
$string['fieldtemplate'] = 'Plantilla';
$string['fieldvisibility'] = 'Visible para';
$string['fieldvisibleall'] = 'Todos';
$string['fieldvisiblenone'] = 'Solamente Mánagers';
$string['fieldvisibleowner'] = 'Propietario y mánagers';
$string['fieldwidth'] = 'Ancho';
$string['filemaxsize'] = 'Tamaño total de arcivos subidos';
$string['filesettings'] = 'Configuraciones del archivo';
$string['filesmax'] = 'Número máximo de archivos subidos';
$string['filetypeany'] = 'Cualquier tipo de archivo';
$string['filetypeaudio'] = 'Archivos de audio';
$string['filetypegif'] = 'archivos GIF';
$string['filetypehtml'] = 'archivos HTML';
$string['filetypeimage'] = 'archivos de imágenes';
$string['filetypejpg'] = 'archivos JPG';
$string['filetypepng'] = 'archivos PNG';
$string['filetypes'] = 'Tipos de archivos aceptados';
$string['filter'] = 'Filtro';
$string['filteradd'] = 'Añadir un filtro';
$string['filteradvanced'] = 'Filtro avanzado';
$string['filterbypage'] = 'Por página';
$string['filtercancel'] = 'Cancelar filtro';
$string['filtercreate'] = 'Crear un nuevo filtro';
$string['filtercurrent'] = 'Filtro actual';
$string['filtercustomsearch'] = 'Opciones de búsqueda';
$string['filtercustomsort'] = 'Opciones de ordenamiento';
$string['filterdescription'] = 'Descripción del filtro';
$string['filteredit'] = 'Editando \'{$a}\'';
$string['filtergroupby'] = 'Agrupar por';
$string['filterincomplete'] = 'Las condiciones de búsqueda deben completarse.';
$string['filtername'] = 'Auto-enlazado de Dataform';
$string['filternew'] = 'Nuevo filtro';
$string['filternoneforaction'] = 'No se encontraron filtros para la acción solicitada ({$a})';
$string['filterperpage'] = 'Por página';
$string['filterquick'] = 'Filtro rápido';
$string['filterquickreset'] = '* Reiniciar filtro rápido';
$string['filters'] = 'Filtros';
$string['filtersadded'] = '{$a} filtro(s) añadido(s)';
$string['filtersave'] = 'Guardar filtro';
$string['filtersaved'] = 'Mis filtros guardados';
$string['filtersavedreset'] = '* Reiniciar filtros guardados';
$string['filtersconfirmdelete'] = 'Está a punto de eliminar {$a} filtro(s). ¿Quiere hacerlo?';
$string['filtersconfirmduplicate'] = 'Está a punto de duplicar {$a} filtro(s). ¿Quiere hacerlo?';
$string['filtersdeleted'] = '{$a} filtro(s) eliminado(s)';
$string['filtersduplicated'] = '{$a} filtro(s) duplicado(s)';
$string['filtersearchfieldlabel'] = 'Campo de búsqueda';
$string['filterselection'] = 'Selección';
$string['filtersimplesearch'] = 'Búsqueda simple';
$string['filtersmax'] = 'Máximo filtros';
$string['filtersnonedefined'] = 'No se definieron filtros';
$string['filtersnoneindataform'] = 'No hay filtros definidos para este dataform.';
$string['filtersortfieldlabel'] = 'Campo para ordenar';
$string['filtersupdated'] = '{$a} filtro(s) actualizado(s)';
$string['filterupdate'] = 'Actualizar un filtro existente';
$string['filterurlquery'] = 'Consulta de URL';
$string['first'] = 'Primero';
$string['firstdayofweek'] = 'Lunes';
$string['formemptyadd'] = '¡Usted no llenó ningún campo!';
$string['fromfile'] = 'Importar desde archivo ZIP';
$string['generalactions'] = 'Acciones generales';
$string['getstarted'] = 'Este dataform parece ser nuevo o tiene incompleta su configuración.';
$string['getstartedfields'] = 'Añadir campos en la sección {$a}';
$string['getstartedpresets'] = 'Aplicar una preconfiguración a la sección {$a}';
$string['getstartedviews'] = 'Añadir vistas en la sección {$a}';
$string['gradecalc'] = 'Cálculo de calificación';
$string['gradecalc_help'] = 'Un cálculo de calificación es una fórmula que determina la calificación de la actividad. La fórmula puede usar operadores matemáticos comunes, tales como max, min y sum (suma). También puede usar ciertos patrones de campo para determinar la calificación de la actividad basándose en el contenido del usuario.';
$string['gradeguide'] = 'Rúbrica/guía de calificación';
$string['gradeguide_help'] = 'Elija una guía para calificar o rúbrica que debería de usarse para asignar calificaciones en este ítem de actividad/calificación.';
$string['gradeitems'] = 'Ítems de calificación';
$string['gradeitems_help'] = 'Esta página le permite añadir/editar ítems de calificación para esta actividad.';
$string['gradeitemsin'] = 'Ítems de calificación en {$a}';
$string['greaterorequal'] = 'Mayor o igual';
$string['greaterthan'] = 'Mayor que';
$string['groupentries'] = 'Agrupar entradas';
$string['groupentries_help'] = 'Las entradas serán añadidas con la información del grupo pero sin información del autor. Esta configuración requiere del modo de grupo.';
$string['headercss'] = 'Estilos CSS personalizados para todas las vistas';
$string['headerjs'] = 'JavaScript personalizado para todas las vistas';
$string['horizontal'] = 'Horizontal';
$string['import'] = 'Importar';
$string['importadd'] = 'Añadir una nueva vista Importar';
$string['importnoneindataform'] = 'No hay importaciones definidas para este dataform';
$string['in'] = 'En';
$string['incorrect'] = 'Incorrecto';
$string['index'] = 'Índice';
$string['inlineview'] = 'Vista en-línea';
$string['instances'] = 'Instancias';
$string['insufficiententries'] = 'se necesitan más entradas para ver este dataform';
$string['internal'] = 'interno/a';
$string['intervalcount'] = 'Número de intervalos';
$string['intervalcount_help'] = 'Si la actividad se configura para tener más de 1 intervalo entonces las configuraciones de disponibilidad y de la entrada se aplican separadamente a cada intervalo.';
$string['intro'] = 'Introducción';
$string['invalidname'] = 'Por favor elija otro nombre para este/a {$a}';
$string['invalidrate'] = 'Valoración de dataform inválida ({$a})';
$string['invalidurl'] = 'La URL que recién escribió no es válida';
$string['is'] = 'ES';
$string['jscode'] = 'Código JavaScript';
$string['jsinclude'] = 'JS';
$string['jsincludes'] = 'Incluir JavaScript externo';
$string['jssaved'] = 'JavaScript guardado';
$string['jsupload'] = 'Subir archivos JavaScript';
$string['lessorequal'] = 'Menor o igual';
$string['lessthan'] = 'Menor que';
$string['lock'] = 'Bloquear';
$string['manage'] = 'Gestionar';
$string['managefields'] = 'Gestionar plugins de campo';
$string['manageviews'] = 'Gestionar plugins de vista';
$string['mappingwarning'] = 'Todos los campos antiguos no mapeados a un campo nuevo se perderán y todos los datos en ese campo serán removidos.';
$string['max'] = 'Méximo';
$string['maxsize'] = 'Tamaño máximo';
$string['mediafile'] = 'Archivo multimedia';
$string['message'] = 'Mensaje';
$string['messageprovider:dataform_notification'] = 'Modificaciones Dataform';
$string['min'] = 'Mínimo';
$string['modeeditinline'] = 'Entradas editadas en-línea con otras entradas';
$string['modeeditonly'] = 'Solamente entradas editadas';
$string['modeeditseparate'] = 'Entradas editadas separadas de otras entradas';
$string['modulename'] = 'Dataform (formulario de datos)';
$string['modulename_help'] = 'El módulo dataform (formulario de datos) puede emplearse para crear una amplia gama de actividades/recursos al permitirle al instructor diseñar y crear un formato de contenido personalizado desde varios elementos de entrada (textos, números, imágenes, archivos, URLs, etc), y a los participantes les permite enviar contenido y ver los contenidos enviados.';
$string['modulenameplural'] = 'Dataforms (formularios de datos)';
$string['modulesettings'] = 'Configuraciones del módulo';
$string['more'] = 'Más';
$string['moreurl'] = 'Más URLs';
$string['movezipfailed'] = 'No puede moverse ZIP';
$string['multidelete'] = 'Eliminar';
$string['multidownload'] = 'Descargar';
$string['multiduplicate'] = 'Duplicar';
$string['multiedit'] = 'Editar';
$string['multiexport'] = 'Exportar';
$string['multigradeitems'] = 'Permitir ítems múltiples de calificación';
$string['multishare'] = 'Compartir';
$string['newvalue'] = 'Nuevo valor';
$string['newvalueallow'] = 'Permitir nuevos valores';
$string['noaccess'] = 'Usted no tiene acceso a esta página';
$string['noautocompletioninline'] = 'Finalización automática al ver la actividad no puede seleccionarse junto con la opción para "vista en-línea!"';
$string['nomatch'] = '¡No se encontraron entradas que coincidan!';
$string['nomaximum'] = 'Sin máximo';
$string['noreply'] = 'Sin-respuesta';
$string['not'] = 'NO';
$string['notapplicable'] = 'No/Aplica';
$string['notification'] = 'Notificación';
$string['notificationtypesnotfound'] = 'Los entimos, no hay tipos de notificación instalados o habilitados. Por favor contacte a su administrador para los detalles.';
$string['notopenyet'] = 'Lo siento, esta actividad no estará disponible sino hasta después de {$a}';
$string['or'] = 'O';
$string['page-mod-dataform-access-index'] = 'Página del índice de reglas de acceso para actividad Dataform';
$string['page-mod-dataform-field-index'] = 'Página del índice de campos para actividad Dataform';
$string['page-mod-dataform-notification-index'] = 'Página del índice de reglas de notificación para actividad Dataform';
$string['page-mod-dataform-view-index'] = 'Página del índice de vistas para actividad Dataform';
$string['page-mod-dataform-x'] = 'Cualquier página de módulo actividad Dataform';
$string['pagesize'] = 'Entradas por página';
$string['pagingbar'] = 'Barra de paginación';
$string['patternbroken'] = 'Se encontró un patrón roto';
$string['patterncleanup'] = 'Limpiar';
$string['patterns'] = 'Patrones';
$string['patternsnonebroken'] = 'No se encontraron patrones rotos';
$string['patternsreplacement'] = 'Remplazo de patrones';
$string['patternsuspect'] = 'Se encontraron patrones sospechosos';
$string['patternvalid'] = 'Patrones validos';
$string['pluginadministration'] = 'Administración de actividad dataform';
$string['pluginhasinstances'] = 'ATENCIÓN: Este plugin tiene {$a} instancias.';
$string['pluginname'] = 'Dataform (formulario de datos)';
$string['presetadd'] = 'Añadir preajustes';
$string['presetapply'] = 'Aplicar';
$string['presetavailableincourse'] = 'Preajustes del curso';
$string['presetavailableinsite'] = 'Preajustes del sitio';
$string['presetchoose'] = 'elija un preajuste predefinido';
$string['presetdata'] = 'con datos del usuario';
$string['presetdataanon'] = 'con datos del usuario anonimizados';
$string['presetfaileddelete'] = '¡Error al eliminar un preajuste!';
$string['presetfromdataform'] = 'Hacer un preajuste de este dataform';
$string['presetfromfile'] = 'Subir preajuste desde archivo';
$string['presetimportsuccess'] = 'El preajuste ha sido aplicado exitosamente.';
$string['presetinfo'] = 'Guardando como un preajuste publicará esta vista. Otros usuarios podrán usarlo en sus dataforms.';
$string['presetmap'] = 'mapear campos';
$string['presetnodata'] = 'sin datos de usuario';
$string['presetnodefinedfields'] = '¡El nuevo preajuste no tiene campos definidos!';
$string['presetnodefinedviews'] = '¡El nuevo preajuste no tiene vistas definidas!';
$string['presetnoneavailable'] = 'No hay preajustes disponibles para mostrar';
$string['presetplugin'] = 'Plug in';
$string['presetrefreshlist'] = 'Refrescar lista';
$string['presets'] = 'Preajustes';
$string['presetshare'] = 'Compartir';
$string['presetsharesuccess'] = 'Guardado exitosamente. Su preajuste estará ahora disponible a todo lo ancho del sitio.';
$string['presetsource'] = 'Orígen de preajuste';
$string['presetusestandard'] = 'Usar un preajuste';
$string['random'] = 'Aleatorio/a';
$string['range'] = 'Rango';
$string['recipient'] = 'Recipiente';
$string['reference'] = 'Referencia';
$string['renewactivity'] = 'Renovar actividad';
$string['renewconfirm'] = 'Usted está a punto de reiniciar completamente esta actividad. Toda la estructura de la actividad y los datos de usuarios serán eliminados. ¿Desea continuar?';
$string['requiredall'] = 'todas requeridas';
$string['requirednotall'] = 'no todas requeridas';
$string['resetsettings'] = 'Reiniciar filtros';
$string['returntoimport'] = 'Regresar a importación';
$string['rule'] = 'regla';
$string['ruleadd'] = 'Añadir una regla';
$string['ruleenabled'] = 'Habilitado/a';
$string['rulenew'] = 'Nueva regla {$a}';
$string['rules'] = 'Reglas';
$string['rulesnone'] = 'Sin reglas';
$string['save'] = 'Guardar';
$string['savebutton'] = 'Guardar';
$string['savebutton_help'] = 'Guardar la entrada editada y regresar a la vista.';
$string['savebutton_label'] = 'Botón para Guardar';
$string['savecont'] = 'Guardar y continuar';
$string['savecontbutton'] = 'Guardar y Continuar';
$string['savecontbutton_help'] = 'Guardar la entrada editada y permanece en el formato para continuar editando la entrada.';
$string['savecontbutton_label'] = 'Botón para Guardar y Continuar';
$string['savecontnew'] = 'Guardar y empezar nuevo';
$string['savecontnewbutton'] = 'Guardar y Empezar Nuevo';
$string['savecontnewbutton_help'] = 'Guarda la entrada editada y abre un nuevo formato de entrada.';
$string['savecontnewbutton_label'] = 'Botón para Guardar y Continuar Nuevo';
$string['savenew'] = 'Guardar nuevo';
$string['savenewbutton'] = 'Guardar como Nuevo';
$string['savenewbutton_help'] = 'Guarda la entrada editada como una entrada nueva (la entrada original no es cambiada) y regresa a la vista.';
$string['savenewbutton_label'] = 'Botón para Guardar Nuevo';
$string['savenewcont'] = 'Guardar nuevo y continuar';
$string['savenewcontbutton'] = 'Guardar como Nuevo y Continuar';
$string['savenewcontbutton_help'] = 'Guarda la entrada editada como una entrada nueva (la entrada original no se cambia) y permanece en el formato para continuar editando la nueva entrada.';
$string['savenewcontbutton_label'] = 'Botón para Guardar Nuevo y continuar';
$string['search'] = 'Búsqueda';
$string['sender'] = 'Persona que envía';
$string['sendinratings'] = 'enviar mis últimas valoraciones';
$string['separateentries'] = 'Cada entrada en un archivo separado';
$string['separateparticipants'] = 'Participantes separados';
$string['separateparticipants_help'] = 'Separar participantes';
$string['settings'] = 'Configuraciones';
$string['spreadsheettype'] = 'Tipo hoja de cálculo';
$string['subject'] = 'Asunto';
$string['submission'] = 'Envío';
$string['submissiondefaultmessage'] = 'Gracias';
$string['submissiondisplay'] = 'Mostrar al editar';
$string['submissiondisplayafter'] = 'Mostrar solamente entrads editadas';
$string['submissiondisplayafter_help'] = 'Por defecto todas las entrads visibles pueden ser mostradas después del envío. Configurar a \'Si\' si Usted quiere mostrar solamente las entradas editadas.';
$string['submissionmessage'] = 'Respuesta al envío';
$string['submissionmessage_help'] = 'Un mensaje a mostrarle al usuario después de un envío exitoso y antes de que el usuario sea re-direccionado a la vista destino.';
$string['submissionredirect'] = 'Redireccionar a otra vista';
$string['submissionredirect_help'] = 'Por defecto el usuario permanece en la misma vista después del envío de la entrada. Si se seleccionara una vista alterna, el usuario será redireccionado a esa vista después del envío.';
$string['submissionsinpopup'] = 'Envíos en ventana emergente';
$string['submissionsview'] = 'Vista de envíos';
$string['submissiontimeout'] = 'Respuesta caducada';
$string['submissiontimeout_help'] = 'El retraso (en segundos) depués del envío y antes de que el usuario sea redireccionado a la vista destino.';
$string['submitfailure'] = 'No pudo guardarse su envío. Por favor inténtelo nuevamente.';
$string['subplugintype_dataformfield'] = 'Tipo de campo dataform';
$string['subplugintype_dataformfield_plural'] = 'Tipos de campo dataform';
$string['subplugintype_dataformtool'] = 'Tipo de herramienta dataform';
$string['subplugintype_dataformtool_plural'] = 'Tipos de herramienta dataform';
$string['subplugintype_dataformview'] = 'Tipo de vista dataform';
$string['subplugintype_dataformview_plural'] = 'Tipos de vista dataform';
$string['timeavailable'] = 'Disponible a partir de';
$string['timeavailable_help'] = 'La hora designada de inicio de la actividad. Esta hora aparece en el calendario del curso.  El conjunto de capacidades de \'earlyentry\' permite controlar los permisos para entrada antes de esta hora.';
$string['timedue'] = 'Fecha de entrega';
$string['timedue_help'] = 'La hora de fin designada de la actividad. Esta hora aparece en el calendario del curso. El conjunto de capacidades  \'lateentry\' permite controlar los permisos de entrada después de esta hora.';
$string['timeinterval'] = 'Duración';
$string['timeinterval_err'] = 'La duración de la actividad es necesaria para intervalos múltiples.';
$string['timeinterval_help'] = 'La duración de esta actividad desde su hora de Disponible-desde.';
$string['timing'] = 'Tiempos e intervalos';
$string['toolnoneindataform'] = 'No hay herramientas definidas para este dataform';
$string['toolrun'] = 'Correr';
$string['tools'] = 'Herramientas';
$string['type'] = 'Tipo';
$string['unlock'] = 'Desbloquear';
$string['usegradeitemsform'] = 'Esta instancia contiene múltiples ítems de calificación. Para editar estos ítems, por favor use el <a href="{$a}">formato de ítems de calificación</a>.';
$string['userpref'] = 'Preferencias del usuario';
$string['view'] = 'vista';
$string['viewadd'] = 'Añadir una vista';
$string['viewcreate'] = 'Crear una nueva vista';
$string['viewcurrent'] = 'Vista actual';
$string['viewcustomdays'] = 'Días de intervalo de refresco personalizados';
$string['viewcustomhours'] = 'Intervalo de refresco personalizado: horas';
$string['viewcustomminutes'] = 'Intervalo de refresco personalizado: minutos';
$string['viewdescription'] = 'Ver descripción';
$string['viewdescription_help'] = 'Descripción breve del propósito de la vista y sus características, para permitirle a los mánagers ver de un vistazo lo que se pretende en cada vista. Esta descripción es mostrada solamente en la lista de gestión de vista.';
$string['viewdisabled'] = 'Deshabilitado';
$string['viewedit'] = 'Editado \'{$a}\'';
$string['vieweditthis'] = 'Editar esta vista';
$string['viewfilter'] = 'Filtro';
$string['viewfilter_help'] = 'Un filtro predeterminado de la lista de Filtros (si hubiera) que será empleado en la vista.';
$string['viewforedit'] = 'Vista para \'editar\'';
$string['viewformore'] = 'Vista para \'más\'';
$string['viewfromdate'] = 'Visible desde';
$string['viewgeneral'] = 'Configuraciones de vista general';
$string['viewgeneral_help'] = 'Configuraciones de vista general';
$string['viewhidden'] = 'Oculta';
$string['viewinterval'] = 'Cuando refrescar vista contenidos';
$string['viewintervalsettings'] = 'Configuraciones de intervalo';
$string['viewname'] = 'Ver nombre';
$string['viewname_help'] = 'Nombre corto para la vista. el nombre de la vista puede ser usado enciertos patrones de vista en cuyo caso el formato del nombre debería ser tan simple como sea posible. Solamente caracteres alfabéticos o alfanuméricos para evitar problemas al procesar el patrón.';
$string['viewnew'] = 'Nueva {$a} vista';
$string['viewnodefault'] = 'La vista por defecto no está configurada. Elija una de las vistas en la lista {$a} como la vista por defecto.';
$string['viewnoneforaction'] = 'No se encontraron vistas para la acción solicitada';
$string['viewnoneindataform'] = 'No hay vistas definidas para este dataform.';
$string['viewoptions'] = 'Ver opciones';
$string['viewpagingfield'] = 'Campo de paginación';
$string['viewpatterns'] = 'Ver patrones';
$string['viewpatterns_help'] = 'Patrones cuyo contenido es típicamente indistinto que sean MAYÚSCULAS/minúsculas.';
$string['viewperpage'] = 'Por página';
$string['viewplugins'] = 'Ver plugins';
$string['viewresettodefault'] = 'Reiniciar a por-defecto';
$string['viewreturntolist'] = 'Regresar a lista';
$string['views'] = 'Vistas';
$string['viewsadded'] = '{$a} vista(s) añadida(s)';
$string['viewsconfirmdelete'] = 'Está a punto de eliminar {$a} vista(s). ¿Desea proceder?';
$string['viewsconfirmduplicate'] = 'Está a punto de duplicar {$a} vista(s). ¿Desea proceder?';
$string['viewsdeleted'] = '{$a} vista(s) eliminada(s)';
$string['viewsectionpos'] = 'Posición de sección';
$string['viewslidepaging'] = 'Paginación de diapositiva';
$string['viewsmax'] = 'Vistas máximas';
$string['viewsupdated'] = '{$a} vista(s) actualizada(s)';
$string['viewtemplate'] = 'Ver plantilla';
$string['viewtiming'] = 'Ver horario';
$string['viewvisibility'] = 'Visibilidad';
$string['viewvisible'] = 'Visible';
$string['wrongdataid'] = 'ID de dataform proporcionada equivocada';
