<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'reservation', language 'es', version '3.9'.
 *
 * @package     reservation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addparticipant'] = 'Añadir reserva';
$string['after10min'] = 'Después de 10 minutos del comienzo del evento';
$string['after12h'] = 'Después de 12 horas del comienzo del evento';
$string['after1d'] = 'Después de 1día del comienzo del evento';
$string['after1h'] = 'Después de 1 hora del comienzo del evento';
$string['after1w'] = 'Después de 1 semana del comienzo del evento';
$string['after2d'] = 'Después de 2 días del comienzo del evento';
$string['after2h'] = 'Después de 2 horas del comienzo del evento';
$string['after2w'] = 'Después de 2 semanas del comienzo del evento';
$string['after30min'] = 'Después de 30 minutos del comienzo del evento';
$string['after3w'] = 'Después de 3 semanas del comienzo del evento';
$string['after4h'] = 'Después de 4 horas del comienzo del evento';
$string['after4w'] = 'Después de 4 semanas del comienzo del evento';
$string['after5min'] = 'Después de 5 minutos del comienzo del evento';
$string['after6h'] = 'Después de 6 horas del comienzo del evento';
$string['alreadybooked'] = 'Ya has hecho una reserva';
$string['alreadyoverbooked'] = 'Ya estás en la lista de espera';
$string['atstart'] = 'Al comienzo del evento';
$string['autohide'] = 'Ocultar lista de reservas automáticamente';
$string['availablerequests'] = 'Plazas disponibles';
$string['badcourse'] = 'El curso no existe';
$string['badparent'] = 'Esta reserva fue enlazada a otra reserva no restaurada. El enlace ha sido eliminado. En caso necesario, enlaza de nuevo las reservas manualmente';
$string['badsection'] = 'La sección no existe en el curso "{$a}"';
$string['badteachers'] = 'No se encontró el email de profesor especificado ({$a})';
$string['badteachersmail'] = 'El email de profesor especificado ({"a}) es incorrecto';
$string['badtimeclose'] = 'La fecha de cierre es incorrecta';
$string['badtimeend'] = 'La fecha de finalización es incorrecta';
$string['badtimeopen'] = 'La fecha de apertura es incorrecta';
$string['badtimestart'] = 'La fecha de inicio es incorrecta';
$string['by'] = 'por';
$string['bydate'] = 'Fecha del evento';
$string['byname'] = 'Nombre';
$string['bysection'] = 'Tema/Semana';
$string['cancelledon'] = 'Cancelada en';
$string['checkclashes'] = 'Comprobar disponibilidad de lugar y hora';
$string['clashesfound'] = 'Se encontraron algunos solapamientos de lugar y hora';
$string['clashesreport'] = 'Informe de solapamientos';
$string['cleanview'] = 'Ver sólo las reservas actuales';
$string['close'] = 'cerrar';
$string['closed'] = 'Cerrado';
$string['completionreserved'] = 'Los estudiantes deben hacer una reserva para completar la actividad';
$string['config'] = 'Ajustes generales del módulo de reservas';
$string['configautohide'] = 'Este ajuste define cuando deben ocultarse las reservas de la lista (mod/reservation/index.php). Puede ser útil en las listas públicas, para que se muestre una lista limpia.';
$string['configcheckclashes'] = 'Activar el botón "Comprobar solapamientos de hora y lugar" en la página de edición de la reserva.';
$string['configconnectto'] = 'Defina donde busca el módulo las reservas a las que conectarse.';
$string['configdownload'] = 'Este ajuste define el formato predeterminado de descarga para todas las listas de reservas.';
$string['configevents'] = 'Este ajuste define que eventos serán creados para cada reserva.';
$string['configfields'] = 'Este ajuste define que campos se mostrarán en la tabla de reservas.';
$string['configlocations'] = 'En esta página puede administrar los lugares predeterminados para las reservas de esta página de Moodle';
$string['configmanualusers'] = 'Este ajuste define qué lista de usuarios se muestra en el menú utilizado para hacer reservas manuales.';
$string['configmaxoverbook'] = 'Esto define el porcentaje máximo de overbooking para las reservas.';
$string['configmaxrequests'] = 'Indique el límite del menú desplegable mostrado en la página de edición de las reservas.';
$string['configminduration'] = 'Esto indica la duración mínima del evento. Se utiliza para comprobar la disponibilidad de hora y lugar en los eventos sin final establecido';
$string['confignotifies'] = 'Este ajuste define las notificaciones que serán enviadas';
$string['configoverbookstep'] = 'Esto define el porcentaje de granularidad del overbooking. A pasos más pequeños, mayor granularidad';
$string['configpubliclists'] = 'Este ajuste define si las listas de reservas son públicas (visibles sin identificarse) o no.';
$string['configsortby'] = 'Esto define como se muestran las listas de reservas';
$string['configsublimits'] = 'Define el número de fila de reglas de sublímites en la página de edición de la reserva';
$string['configupload'] = 'Crea varias reservas cargándolas desde un fichero de texto';
$string['confirmdelete'] = '¿Está seguro de que desea eliminar las solicitudes de reserva seleccionadas?';
$string['connectedto'] = 'Reserva conectada a';
$string['connectto'] = 'Reserva enlazable desde';
$string['description'] = 'Descripción';
$string['downloadas'] = 'Formato de descarga por defecto';
$string['duration10h'] = '10 horas';
$string['duration10min'] = '10 minutos';
$string['duration11h'] = '11 horas';
$string['duration12h'] = '12 horas';
$string['duration15min'] = '15 minutos';
$string['duration20min'] = '20 minutos';
$string['duration2h'] = '2 horas';
$string['duration30min'] = '30 minutos';
$string['duration3h'] = '3 horas';
$string['duration45min'] = '45 minutos';
$string['duration4h'] = '4 horas';
$string['duration5h'] = '5 horas';
$string['duration5min'] = '5 minutos';
$string['duration60min'] = '60 minutos';
$string['duration6h'] = '6 horas';
$string['duration7h'] = '7 horas';
$string['duration8h'] = '8 horas';
$string['duration90min'] = '90 minutos';
$string['duration9h'] = '9 horas';
$string['enablenote'] = 'Permitir comentarios de los usuarios';
$string['equal'] = 'igual a';
$string['err_sublimitsgreater'] = 'La suma de los sublímites es mayor que el máximo de peticiones permitidas';
$string['err_timeendlower'] = 'La fecha de finalización del evento se ha establecido antes de la fecha de inicio.';
$string['err_timeopengreater'] = 'La fecha de inicio de las reservas se ha establecido después de la fecha de finalización del evento.';
$string['eventevent'] = 'Crear un evento desde el inicio hasta el final de las reservas';
$string['eventreminder'] = '{$a} (reservado)';
$string['eventrequestadded'] = 'Petición de reserva añadida';
$string['eventrequestcancelled'] = 'Petición de reserva cancelada';
$string['eventrequestdeleted'] = 'Petición de reserva eliminada';
$string['events'] = 'Eventos del calendario';
$string['eventsettings'] = 'Ajustes del evento';
$string['explainconfig'] = 'Los administradores pueden definir aquí los ajustes globales para el Módulo de Reservas';
$string['fields'] = 'Mostrar campos';
$string['fullview'] = 'Ver también las reservas canceladas';
$string['gradedmail'] = 'El profesor {$a->teacher} ha realizado algún comentario en tu reserva \'{$a->reservation}\'

Puedes acceder desde aquí:

      {$a->url}';
$string['gradedmailhtml'] = 'El profesor {$a->teacher} ha realizado algún comentario en tu reserva \'<i>{$a->reservation}</i>\'<br /><br /> Puedes verlo <a href=\\"{$a->url}\\">aquí</a>.';
$string['importreservations'] = 'Importar reservas';
$string['justbooked'] = 'Te has apuntado como: {$a}';
$string['justoverbooked'] = 'Estás en lista de espera como: {$a}';
$string['linenumber'] = '#';
$string['listafterclose'] = 'lista de peticiones de reserva tras el cierre del plazo de reserva';
$string['listalways'] = 'lista de peticiones de reserva en cualquier momento';
$string['location'] = 'Lugar';
$string['locations'] = 'Administrar lugares';
$string['locationslist'] = 'Lista de lugares';
$string['mail'] = 'Las reservas para \'{$a->reservation}\' están cerradas.

Puede descargar la lista de reservas desde:

{$a->url}';
$string['mailhtml'] = 'La reserva <em>{$a->reservation}</em> está cerrada.<br /><br />
Puedes descargar la lista de reservas <a href="{$a->url}">aquí</a>.';
$string['mailrequest'] = 'La reserva \'{$a->reservation}\' ha sido cerrada.

Puedes obtener tu número de reserva en:

    {$a->url}';
$string['mailrequesthtml'] = 'La reserva <em>{$a->reservation}</em> ha sido cerrada.<br /><br />
Puedes obtener tu número de reserva <a href="{$a->url}">aquí</a>.';
$string['manage'] = 'Administrar';
$string['manualusers'] = 'Mostrar usuarios con reserva manual';
$string['maxoverbook'] = 'Porcentaje máximo de overbooking';
$string['maxrequest'] = 'Límite de reservas';
$string['message'] = 'Mensaje a los participantes';
$string['minduration'] = 'Duración mínima del evento';
$string['modulename'] = 'Reserva';
$string['modulename_help'] = '<p>El objetivo principal de esta actividad es programar sesiones de laboratorio y exámenes, pero puede programar todo lo que desee.</p><p>El profesor puede definir el número de asientos disponibles para el evento, la fecha del evento, las fechas de apertura y cierre de la reserva.<br />Una reserva puede tener una calificación o escala.<br />Los estudiantes pueden apuntarse o desapuntarse de una sesión y añadir una nota sobre esta reserva. </p><p> Después de que comience el evento, el profesor puede calificar el evento. Los estudiantes serán notificados por correo electrónico.</p><p> La lista de reserva puede descargarse en varios formatos.</ P>';
$string['modulenameplural'] = 'Reservas';
$string['newlocation'] = 'Nueva Ubicación';
$string['noclashes'] = 'No se encontraron conflictos de lugar u hora';
$string['nocourseswithnsections'] = 'No se encontraron cursos con {$a} secciones';
$string['nolimit'] = 'Sin límite de reservas';
$string['nomorerequest'] = 'No hay más sitios disponibles';
$string['none'] = 'sin información sobre el orden de reservas';
$string['nooverbook'] = 'Sin Overbooking';
$string['noparent'] = 'Ninguno';
$string['noreservations'] = 'No hay reservas para mostrar';
$string['note'] = 'Nota';
$string['noteachers'] = 'No hay profesores disponibles';
$string['notequal'] = 'no es igual a';
$string['notifies'] = 'Notificaciones enviadas';
$string['notifygrades'] = 'Notificar las calificaciones de las reservas a los estudiantes';
$string['notifystudents'] = 'Notificar tiempo de cierre de reserva a los estudiantes';
$string['notifyteachers'] = 'Notificar tiempo de cierre de reserva a los profesores';
$string['notopened'] = 'No abierto';
$string['novalues'] = 'No hay valores disponibles para este campo';
$string['number'] = 'Número de Reserva';
$string['numberafterclose'] = 'su número de solicitud de reserva después del cierre de la reserva';
$string['numberalways'] = 'su número de solicitud de reserva en cualquier momento';
$string['otherlocation'] = 'Otra ubicación especificada';
$string['overbook'] = 'Overbooking';
$string['overbookonly'] = 'Sólo hay asientos disponibles en overbooking';
$string['overbookstep'] = 'Paso de overbooking';
$string['overview'] = 'Vista global';
$string['parent'] = 'Enlazar esta reserva con';
$string['pluginadministration'] = 'Administración de reservas';
$string['pluginname'] = 'Reserva';
$string['publiclists'] = 'Lista pública de reservas';
$string['requestoverview'] = 'Vista de peticiones';
$string['requests'] = 'Peticiones';
$string['reservation:addinstance'] = 'Añadir una nueva reserva';
$string['reservation:downloadrequests'] = 'Lista de peticiones descargable';
$string['reservation:grade'] = 'Puede calificar';
$string['reservation:manualdelete'] = 'Puede borrar peticiones de otros usuarios';
$string['reservation:manualreserve'] = 'Puede enviar peticiones para otros usuarios';
$string['reservation:reserve'] = 'Puede enviar sus propias peticiones';
$string['reservation:uploadreservations'] = 'Puede subir reservas';
$string['reservation:viewnote'] = 'Puede ver notas de las peticiones';
$string['reservation:viewrequest'] = 'Puede ver la lista de peticiones';
$string['reservation_listing'] = 'Ajustes de página de inicio';
$string['reservation_other'] = 'Otros ajustes';
$string['reservation_settings'] = 'Ajustes de edición';
$string['reservation_view'] = 'Ver página de ajustes';
$string['reservationcancelled'] = 'Reserva cancelada';
$string['reservationclosed'] = 'Reservas cerradas';
$string['reservationdenied'] = 'Reservas no permitidas';
$string['reservationevent'] = 'Crear un evento de curso desde la apertura al cierre de fechas (tiempo de reserva)';
$string['reservationnotopened'] = 'Reservas todavía no abiertas';
$string['reservations'] = 'Reservas';
$string['reservationsettings'] = 'Ajustes de Reservas';
$string['reserve'] = 'Reservar';
$string['reservecancel'] = 'Cancelar reserva';
$string['reserved'] = 'Reservado';
$string['reservedon'] = 'Reservado en';
$string['reservedonconnected'] = 'Ya has reservado en una reserva enlazada: {$a}';
$string['resetreservation'] = 'Borrar todas las reservas';
$string['save'] = 'Guardar calificación';
$string['search:activity'] = 'Reserva - información de actividad';
$string['selectvalue'] = 'Elige uno de los valores disponibles';
$string['showrequest'] = 'Los usuarios puedes ver la lista de peticiones';
$string['showuserrequest'] = 'Los usuarios pueden ver';
$string['sortby'] = 'Lista de reservas ordenada por';
$string['sublimit'] = 'Sublímite {$a}';
$string['sublimitrules'] = 'Reglas de sublímites';
$string['sublimits'] = 'Sublímites de reservas';
$string['timeclose'] = 'La reserva finaliza el';
$string['timeend'] = 'Fecha de fin';
$string['timeopen'] = 'La reserva comienza el';
$string['timestart'] = 'Fecha de comienzo';
$string['tools'] = 'Herramientas de reserva';
$string['upload'] = 'Subida de reservas';
$string['upload_help'] = '<p>Las reservas se pueden cargar a través de un archivo de texto. El formato del archivo debe ser el siguiente: </p><ul><li>Cada línea del archivo contiene un registro</li><li>Cada registro es una serie de datos separados por comas (u otros delimitadores)</li><li>El primer registro contiene una lista de nombres de campo que definen el formato del resto del archivo</li><li>Campos obligatorios son sección, nombre y fecha y hora<li><li>Los campos opcionales son cursos, introducción, profesores, fechafin, calificaciónmáxima, tiempoapertura, tiempoclausura, peticionesmáximas</li><li>Si no se especifica el curso, debe elegirse después de la vista previa</li></ul>';
$string['uploadreservations'] = 'Subir Reservas';
$string['uploadreservationspreview'] = 'Subir vista previa de las Reservas';
$string['uploadreservationsresult'] = 'Subir resultados de las Reservas';
$string['userevent'] = 'Crear un evento de usuario desde el comienzo hasta el fin de las fechas cuando el usuario realice una reserva';
$string['with'] = 'con';
$string['withselected'] = 'Con los seleccionados...';
$string['yourgrade'] = 'Tu calificación de esta reserva es: {$a->grade}/{$a->maxgrade}';
$string['yourscale'] = 'Tu calificación de esta reserva es: {$a}';
