<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'sr_cr', version '3.9'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bbbduetimeoverstartingtime'] = 'Време завршетка ове активност мора бити након времена њеног почетка';
$string['bbbdurationwarning'] = 'Максимално трајање овe сесијe је %duration% минута.';
$string['bbbrecordwarning'] = 'Ова сесија може да се сними.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Додај нови састанак';
$string['bigbluebuttonbn:join'] = 'Приступи састанку';
$string['bigbluebuttonbn:managerecordings'] = 'Управљање снимцима';
$string['calendarstarts'] = '{$a} заказан је за';
$string['completionattendancegroup'] = 'Захтевајте присуство';
$string['completionengagementemojis'] = 'Емотикони';
$string['completionengagementpollvotes'] = 'Гласови у анкети/Одговори на питања';
$string['completionupdatestate'] = 'Статус ажурирања завршетка';
$string['completionvalidatestate'] = 'Провера завршетка';
$string['completionvalidatestatetriggered'] = 'Провера завршетка је покренута';
$string['config_default_messages'] = 'Подразумеване поруке';
$string['config_default_messages_description'] = 'Подесите подразумеване поруке за активности';
$string['config_disablecam_default_description'] = 'Ако је ова опција омогућена, веб камере ће бити онемогућене.';
$string['config_disablemic_default'] = 'Опција \'Онемогући микрофон\' је стандардно омогућена';
$string['config_disablemic_default_description'] = 'Ако је ова опција омогућена, микрофони ће бити онемогућени.';
$string['config_disablemic_editable'] = 'Опција \'Онемогући микрофон\' може да се уређује';
$string['config_disablemic_editable_description'] = 'Опција \'Онемогући микрофон\', која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_disablenote_default'] = 'Опција \'Онемогући дељене белешке\' је стандардно омогућена';
$string['config_disablenote_default_description'] = 'Ако је ова опција омогућена, дељене белешке ће бити онемогућене.';
$string['config_disablenote_editable'] = 'Опција \'Онемогући дељене белешке\' може да се уређује';
$string['config_disablenote_editable_description'] = 'Опција \'Онемогући дељене белешке\' која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_disableprivatechat_default'] = 'Опција \'Онемогући приватни разговор\' је стандардно омогућена';
$string['config_disableprivatechat_default_description'] = 'Ако је ова опција омогућена, јавни разговор ће бити онемогућен.';
$string['config_disableprivatechat_editable'] = 'Опција \'Онемогући приватни разговор\' може да се уређује';
$string['config_disableprivatechat_editable_description'] = 'Опција \'Онемогући приватни разговор\'која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_disablepublicchat_default'] = 'Опција \'Онемогући јавни разговор\' је стандардно омогућена';
$string['config_disablepublicchat_default_description'] = 'Ако је ова опција омогућена, приватни разговор ће бити онемогућен.';
$string['config_disablepublicchat_editable'] = 'Опција \'Онемогући јавни разговор\' може да се уређује';
$string['config_disablepublicchat_editable_description'] = 'Опција \'Онемогући јавни разговор\', која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_experimental_features_description'] = 'Конфигурација за експерименталне функције.';
$string['config_extended_capabilities'] = 'Конфигурација за додатне могућности';
$string['config_extended_capabilities_description'] = 'Конфигурација за проширене могућности када их нуди BigBlueButton сервер.';
$string['config_general'] = 'Општа конфигурација';
$string['config_general_description'] = 'Ова подешавања се <b>увек</b> користе';
$string['config_hideuserlist_default'] = 'Опција \'Сакриј списак корисника\' је стандардно омогућена';
$string['config_hideuserlist_default_description'] = 'Ако је ова опција омогућена, списак корисника сесије ће бити сакривен.';
$string['config_hideuserlist_editable'] = 'Опција \'Сакриј списак корисника\' може да се уређује';
$string['config_hideuserlist_editable_description'] = 'Опција \'Сакриј списак корисника\' која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_importrecordings_enabled'] = 'Увоз снимака је омогућен';
$string['config_importrecordings_enabled_description'] = 'Када су ово и функција снимања омогућене, могуће је увести снимке са различитих курсева у активност.';
$string['config_importrecordings_from_deleted_enabled'] = 'Увоз снимака из обрисаних снимака је омогућен';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Када су ово и функција увоза снимака омогућене, могуће је увести снимке из активности које више не постоје на курсу.';
$string['config_lockonjoin_default'] = 'Опција \'Закључавања подешавања приликом приступа сесији\' је стандардно омогућена';
$string['config_lockonjoin_default_description'] = 'Ако је ова опција омогућена, подешавања закључана конфигурацијом се примењују када корисник приступа сесији. Конфигурација закључавања мора бити омогућена да би се ово применило.';
$string['config_lockonjoin_editable'] = 'Опција \'Закључавања подешавања приликом приступа сесији\' може да се уређује';
$string['config_lockonjoin_editable_description'] = 'Опција \'Закључавања подешавања приликом приступа сесији\' која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_locksettings'] = 'Конфигурација за закључавање подешавања';
$string['config_muteonstart_default'] = 'Опција \'Искључите звук на почетку\' је стандардно омогућена';
$string['config_muteonstart_default_description'] = 'Ако је ова опција омогућена, звук ће бити искључена на почетку сесије.';
$string['config_muteonstart_description'] = 'Ова подешавања омогућавају или онемогућавају опције у корисничком интерфејсу и такође дефинишу подразумеване вредности за ове опције.';
$string['config_muteonstart_editable'] = 'Опција \'Искључите звук на почетку\' може да се уређује';
$string['config_muteonstart_editable_description'] = 'Опција \'Искључите звук на почетку\' која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_participant_moderator_default_description'] = 'Ово правило се стандардно користи када се додаје нова конференцијска соба.';
$string['config_preuploadpresentation_editable'] = 'Опција \'Унапред постављена презентација\' може да уређује';
$string['config_preuploadpresentation_editable_description'] = 'Опција \'Унапред постављена презентација\' може да се уређује у корисничком интерфејсу када се додаје или ажурира соба/конференција.';
$string['config_recording_description'] = 'Ова подешавања су специфична за ову функцију';
$string['config_recording_hide_button_default'] = 'Сакриј дугме за снимање';
$string['config_recordings_deleted_default'] = 'Опција \'Укључи снимке из обрисаних активности\' је стандардно омогућена';
$string['config_recordings_deleted_editable'] = 'Опција \'Укључи снимке из обрисаних активности\' може да се уређује';
$string['config_recordings_deleted_editable_description'] = 'Опција \'Укључи снимке из обрисаних активности\' која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_recordings_description'] = 'Ова подешавања су специфична за ову функцију';
$string['config_recordings_general'] = 'Прикажи подешавања за снимање';
$string['config_recordings_general_description'] = 'Ова подешавања се користе само приликом приказивања снимака';
$string['config_recordings_imported_default'] = 'Опција \'Прикажи само увезене линкове\' је стандардно омогућена';
$string['config_recordings_imported_default_description'] = 'Ако је ова опција омогућена табела са снимцима ће садржати само линкове ка снимцима.';
$string['config_recordings_imported_editable'] = 'Опција \'Прикажи само увезене линкове\' може да се мења';
$string['config_recordings_imported_editable_description'] = 'Опција \'Прикажи само увезене линкове\' која је стандардно омогућена може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_recordings_preview_default'] = 'Опција \'Преглед\' је стандардно омогућена';
$string['config_recordings_preview_default_description'] = 'Ако је ова опција омогућена табела са снимцима ће садржати преглед презентације.';
$string['config_recordings_preview_editable'] = 'Опција \'Преглед\' може да се уређује';
$string['config_recordings_preview_editable_description'] = 'Опција \'Преглед\' може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['config_recordings_sortorder'] = 'Поређајте снимке растућим редоследом.';
$string['config_recordings_sortorder_description'] = 'Стандардно, снимци су приказани опадајућим редоследом. Када је ово поље означено, они ће бити сортирани растућим редоследом.';
$string['config_scheduled'] = 'Конфигурација за функционалност ”Планиране сесије”';
$string['config_scheduled_description'] = 'Ова подешавања дефинишу нека од стандардних понашања за планиране сесије.';
$string['config_scheduled_duration_compensation'] = 'Компензаторно време (минути)';
$string['config_scheduled_duration_compensation_description'] = 'Број минута који се додаје планираном времену затварања сесије приликом израчунавања њеног трајања.';
$string['config_scheduled_duration_enabled'] = 'Израчунавање трајања сесије омогућено';
$string['config_scheduled_duration_enabled_description'] = 'Трајање планиране сесије се израчунава на основу података о времену почетка односно завршетка сесије.';
$string['config_scheduled_pre_opening'] = 'Сесија доступна пре отварања (минути)';
$string['config_scheduled_pre_opening_description'] = 'Временски период у минутима, током којег ће моћи да се приступи сесији и пре планираног времена њеног отварања.';
$string['config_server_url'] = 'URL адреса BigBlueButton сервера';
$string['config_server_url_description'] = 'URL адреса вашег BigBlueButton сервера мора да се завршава са /bigbluebutton/. (Ова подразумевана URL адреса је за BigBlueButton сервер који је обезбедио Blindside Networks, и који можете да користите за тестирање).';
$string['config_shared_secret'] = 'BigBlueButton тајни кључ';
$string['config_shared_secret_description'] = 'Безбедносни насумични стринг (salt) вашег BigBlueButton сервера. (Ово је подразумевани насумични стринг BigBlueButton сервера који је обезбдио Blindside Networks, и који можете да користите за тестирање).';
$string['config_uidelegation_enabled'] = 'Прослеђивање корисничког интерфејса је омогућено';
$string['config_uidelegation_enabled_description'] = 'Ова подешавања омогућавају или онемогућавају прослеђивање корисничког интерфејса BigBlueButton серверу.';
$string['config_userlimit_default'] = 'Опција \'Ограничење броја корисника\' је стандардно омогућена';
$string['config_userlimit_description'] = 'Ова подешавања омогућавају или онемогућавају опције у корисничком интерфејсу и такође дефинишу подразумеване вредности за ове опције.';
$string['config_userlimit_editable'] = 'Опција \'Ограничење броја корисника\' може да се уређује';
$string['config_userlimit_editable_description'] = 'Опција \'Ограничење броја корисника\' која је стандардно омогућена може да се уређује када се додаје или ажурира конференцијска соба.';
$string['config_voicebridge_description'] = 'Ова подешавања омогућавају или онемогућавају опције у корисничком интерфејсу и такође дефинишу подразумеване вредности за ове опције.';
$string['config_voicebridge_editable'] = 'Конференцијски гласовни мост се може да се уређује';
$string['config_waitformoderator_cache_ttl'] = 'Сачекајте модератора - TTL кеш (секунде)';
$string['config_waitformoderator_cache_ttl_description'] = 'Како би подржао велики број клијената, овај додатак користи кеш меморију. Овај параметар дефинише колико дуго ће се кеш чувати пре него што се пошаље следећи захтев BigBlueButton серверу.';
$string['config_waitformoderator_default'] = 'Опција \'Сачекајте модератора\' је стандардно омогућено';
$string['config_waitformoderator_description'] = 'Ова подешавања су специфична за ову функцију';
$string['config_waitformoderator_ping_interval'] = 'Сачекајте модератора - пинг сигнал (секунде)';
$string['config_warning_curl_not_installed'] = 'Ова функционалност захтева да php екстензија CURL буде инсталирана и омогућена. Подешавања ће бити доступна само ако је испуњен овај услов.';
$string['config_welcome_default'] = 'Подразумевана порука добродошлице';
$string['config_welcome_editable'] = 'Опцију \'Подразумевана порука добродошлице\' могу да уређују предавачи';
$string['config_welcome_editable_description'] = 'Порука добродошлице може да се уређује када се додаје или ажурира инстанца BigBlueButtona.';
$string['email_body_notification_meeting_by'] = 'од стране';
$string['email_body_notification_meeting_description'] = 'Опис';
$string['email_body_notification_meeting_details'] = 'Детаљне информације';
$string['email_body_notification_meeting_end_date'] = 'Датум краја';
$string['email_body_notification_meeting_has_been'] = 'је';
$string['email_body_notification_meeting_start_date'] = 'Датум почетка';
$string['email_body_notification_meeting_title'] = 'Наслов';
$string['email_body_recording_ready_for'] = 'Снимак';
$string['email_body_recording_ready_is_ready'] = 'је спремaн';
$string['email_footer_sent_by'] = 'Ову аутоматску порука са обавештењем послао је';
$string['email_footer_sent_from'] = 'са курса';
$string['ends_at'] = 'Завршава се';
$string['event_activity_created'] = 'Активност креирана';
$string['event_activity_deleted'] = 'Активност обрисана';
$string['event_activity_updated'] = 'Активност ажурирана';
$string['event_activity_viewed'] = 'BigBlueButtonBN активност приказана';
$string['event_live_session'] = 'Сесија уживо';
$string['event_meeting_created'] = 'Састанак креиран';
$string['event_meeting_ended'] = 'Састанак принудно завршен';
$string['event_meeting_joined'] = 'Састанку приступљено';
$string['event_meeting_left'] = 'Састанак напуштен';
$string['event_recording_deleted'] = 'Снимак обрисан';
$string['event_recording_edited'] = 'Снимак уређиван';
$string['event_recording_imported'] = 'Снимак увезен';
$string['event_recording_protected'] = 'Снимак заштићен';
$string['event_recording_published'] = 'Снимак објављен';
$string['event_recording_unprotected'] = 'Заштита са снимка уклоњена';
$string['event_recording_unpublished'] = 'Објављивање снимка опозвано';
$string['event_recording_viewed'] = 'Снимак приказан';
$string['general_error_unable_connect'] = 'Није могуће повезати се са сервером. Молимо, проверите URL адресу BigBlueButton сервера. Такође, проверите да ли BigBlueButton сервер ради.';
$string['index_confirm_end'] = 'Да ли желите да завршите виртуелни час?';
$string['index_disabled'] = 'онемогућено';
$string['index_enabled'] = 'омогућено';
$string['index_ending'] = 'Виртуелна учионица се завршава... молимо сачекајте';
$string['index_error_bbtn'] = 'BigBlueButton ID ознака {$a} је неисправна';
$string['index_error_checksum'] = 'Дошло је до грешке контролног збира. Проверите да ли сте унели исправан тајни кључ.';
$string['index_error_forciblyended'] = 'Није могуће приступити овом састанку зато што је ручно завршен.';
$string['index_error_unable_display'] = 'Није могуће приказати састанак. Молимо, проверите URL адресу BigBlueButton сервера. Такође, проверите да ли BigBlueButton сервер ради.';
$string['index_heading'] = 'BigBlueButton собе';
$string['index_heading_actions'] = 'Акције';
$string['index_heading_group'] = 'Група';
$string['index_heading_moderator'] = 'Модератори';
$string['index_heading_name'] = 'Конференцијска соба';
$string['index_heading_recording'] = 'Снимак';
$string['index_heading_users'] = 'Корисници';
$string['index_heading_viewer'] = 'Посматрачи';
$string['indicator:cognitivedepth'] = 'BigBlueButton - когнитивни аспект';
$string['indicator:cognitivedepth_help'] = 'Овај индикатор се заснива на когнитивној дубини коју је полазник постигао у оквиру активности \'BigBlueButton\'.';
$string['indicator:socialbreadth'] = 'BigBlueButton - социјални аспект';
$string['indicator:socialbreadth_help'] = 'Овај индикатор се заснива на обиму социјалних интеракција који је полазник постигао у оквиру активности \'BigBlueButton\'.';
$string['instance_type_recording_only'] = 'Само снимци';
$string['minute'] = 'минут';
$string['minutes'] = 'минути';
$string['mod_form_block_general'] = 'Општа подешавања';
$string['mod_form_block_participants'] = 'Улога додељена током сесије уживо';
$string['mod_form_block_presentation'] = 'Садржај презентације';
$string['mod_form_block_presentation_default'] = 'Подразумевани садржај презентације';
$string['mod_form_block_record'] = 'Подешавања снимања';
$string['mod_form_block_schedule'] = 'Распоред за сесију';
$string['mod_form_field_closingtime'] = 'Приступ сесији се затвара';
$string['mod_form_field_conference_name'] = 'Назив конференције';
$string['mod_form_field_disablecam'] = 'Онемогући веб камере';
$string['mod_form_field_disablemic'] = 'Онемогући микрофоне';
$string['mod_form_field_disablenote'] = 'Онемогући дељене белешке';
$string['mod_form_field_disableprivatechat'] = 'Онемогући приватни разговор';
$string['mod_form_field_disablepublicchat'] = 'Онемогући јавни разговор';
$string['mod_form_field_duration'] = 'Трајање';
$string['mod_form_field_duration_help'] = 'Подешавање трајања састанка ће утврдити максимално време састанка, како би он потрајао док се снимање не заврши.';
$string['mod_form_field_hideuserlist'] = 'Сакриј списак корисника';
$string['mod_form_field_instanceprofiles'] = 'Тип инстанце';
$string['mod_form_field_intro'] = 'Опис';
$string['mod_form_field_intro_help'] = 'Кратак опис собе или конференције.';
$string['mod_form_field_lockonjoin'] = 'Подешавања закључавања приликом приступа сесији';
$string['mod_form_field_muteonstart'] = 'Искључите звук на почетку';
$string['mod_form_field_name'] = 'Назив виртуелне учионице';
$string['mod_form_field_nosettings'] = 'Ниједно подешавање се не може мењати';
$string['mod_form_field_notification'] = 'Пошаљи обавештење';
$string['mod_form_field_notification_created_help'] = 'Пошаљите обавештење уписаним корисницима како би знали да је ова активност креирана';
$string['mod_form_field_notification_help'] = 'Пошаљите обавештење уписаним корисницима како би знали да је ова активност креирана или промењена';
$string['mod_form_field_notification_modified_help'] = 'Пошаљите обавештење уписаним корисницима како би знали да је ова активност промењена';
$string['mod_form_field_notification_msg_at'] = 'у';
$string['mod_form_field_notification_msg_created'] = 'креирана';
$string['mod_form_field_notification_msg_modified'] = 'промењена';
$string['mod_form_field_openingtime'] = 'Приступ сесији се отвара';
$string['mod_form_field_participant_add'] = 'Додај учесника';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Модератор';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Посматрач';
$string['mod_form_field_participant_list'] = 'Списак учесника';
$string['mod_form_field_participant_list_action_add'] = 'Додај';
$string['mod_form_field_participant_list_action_remove'] = 'Уклони';
$string['mod_form_field_participant_list_text_as'] = 'приступа сесији као';
$string['mod_form_field_participant_list_type_all'] = 'Сви уписани корисници';
$string['mod_form_field_participant_list_type_owner'] = 'Власник';
$string['mod_form_field_participant_list_type_role'] = 'Улога';
$string['mod_form_field_participant_list_type_user'] = 'Корисник';
$string['mod_form_field_record'] = 'Сесија може бити снимљена';
$string['mod_form_field_recordallfromstart'] = 'Сними све од почетка';
$string['mod_form_field_recordhidebutton'] = 'Сакриј дугме за снимање';
$string['mod_form_field_recordings_deleted'] = 'Укључи снимке из обрисаних активности';
$string['mod_form_field_recordings_imported'] = 'Прикажи само увезене линкове';
$string['mod_form_field_recordings_preview'] = 'Прикажи преглед снимка';
$string['mod_form_field_room_name'] = 'Назив конференцијске собе';
$string['mod_form_field_userlimit'] = 'Ограничење броја корисника';
$string['mod_form_field_userlimit_help'] = 'Максималан број корисника којима је дозвољено да присуствују састанку. Ако је лимит подешен на 0 онда је број корисника неограничен.';
$string['mod_form_field_voicebridge'] = 'Гласовни мост [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Грешка у формату. Потребно је да унесете број између 1 и 9999.';
$string['mod_form_field_voicebridge_help'] = 'Број гласовне конференције који корисници уносе за приступ конференцији путем телефона. Унети број мора бити између 1 и 9999. Ако је вредност 0 статични гласовни мост биће игнорисан, а BigBlueButton ће генерисати насумични број. Број 7 ће претходити унетом четвороцифреном броју.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Није јединствена вредност. Овај број већ користе друга соба или конференција.';
$string['mod_form_field_wait'] = 'Сачекајте модератора';
$string['mod_form_field_wait_help'] = 'Посматрачи морају да сачекају да модератор први уђе на сесију пре него што они буду могли то да учине';
$string['mod_form_field_welcome'] = 'Порука добродошлице';
$string['mod_form_field_welcome_default'] = '<br>Добро дошли на<b>%%CONFNAME%%</b>!<br><br>Да бисте разумели како BigBlueButton ради погледајте наша <a href="event:http://www.bigbluebutton.org/content/videos"><u>видео упутства</u></a>.<br><br>За приступ ”аудио мосту” кликните на иконицу са слушалицама (горњи леви угао). <b>Молимо вас да користите слушалице како би се избегло прављење буке.</b>';
$string['mod_form_field_welcome_help'] = 'Замењује подразумевану поруку подешену за BigBlueButton сервер. Порука мора да укључује кључне речи (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) које ће бити аутоматски замењене, као и html ознаке попут <b>...</b> или <i></i>';
$string['mod_form_locksettings'] = 'Подешавања закључавања';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButtonBN вам допушта да у оквиру Moodlea креирате онлајн учионице у реалном времену користећи BigBlueButton, веб-конференцијски систем отвореног кôда, за образовање на даљину.

Користећи BigBlueButton може да наведете наслов, опис, време одржавање сесије, групе и детаљне информације о снимку онлајн сесије.

Како бисте касније могли да погледате снимке, додајте ресурс RecordingsBN на овај курс,';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['pluginadministration'] = 'Администрација BigBlueButtona';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Да бисте креирали и приступили BigBlueButton сесији, кориснички подаци морају да се размене са сервером.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Чува догађаје покренуте приликом коришћења додатка.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Тип догађаја који је покренуо корисник.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ID ознака корисника који је покренуо догађај.';
$string['removedevents'] = 'Обрисани догађаји';
$string['removedlogs'] = 'Обрисани прилагођени записи';
$string['removedrecordings'] = 'Обрисани снимци';
$string['removedtags'] = 'Обрисане ознаке';
$string['resetevents'] = 'Oбриши догађаје';
$string['resetlogs'] = 'Обриши прилагођене записе';
$string['resetrecordings'] = 'Обриши снимке';
$string['resettags'] = 'Обриши ознаке';
$string['search:activity'] = 'BigBlueButton - информације о активности';
$string['search:tags'] = 'BigBlueButton - информације о ознакама';
$string['sendnotification'] = 'Пошаљи обавештење';
$string['started_at'] = 'Почело';
$string['starts_at'] = 'Почиње';
$string['view_conference_action_end'] = 'Заврши сесију';
$string['view_conference_action_join'] = 'Приступи сесији';
$string['view_error_action_not_completed'] = 'Акција није могла да се заврши';
$string['view_error_bigbluebutton'] = 'BigBlueButton је послао поруку о грешци. {$a}';
$string['view_error_create'] = 'BigBlueButton север је одговорио са поруком о грешци. Састанак није могао да буде креиран.';
$string['view_error_current_state_not_found'] = 'Тренутни статус није пронађен. Снимак је можда избрисан или BigBlueButton сервер није компатибилан са извршеном акцијом.';
$string['view_error_import_no_courses'] = 'Нема курсева за претрагу снимака';
$string['view_error_import_no_recordings'] = 'На овом курсу нема снимака за увоз';
$string['view_error_max_concurrent'] = 'Достигнут је дозвољени број истовремених састанака.';
$string['view_error_no_group'] = 'Још увек не постоје креиране групе. Молимо, подесите групе пре него што покушате да приступите састанку.';
$string['view_error_no_group_student'] = 'Нисте уписани у групу. Молимо, контактирајте свог предавача или администратора.';
$string['view_error_no_group_teacher'] = 'Још увек не постоје креиране групе. Молимо, подесите групе или контактирајте администратора.';
$string['view_error_unable_join'] = 'Није могуће приступити састанку. Молимо, проверите URL адресу BigBlueButton сервера. Такође, проверите да ли BigBlueButton сервер ради.';
$string['view_error_unable_join_student'] = 'Није могуће успоставити везу са BigBlueButton сервером. Молимо, контактирајте свог предавача или администратора.';
$string['view_error_unable_join_teacher'] = 'Није могуће успоставити везу са BigBlueButton сервером. Молимо, контактирајте администратора.';
$string['view_error_url_missing_parameters'] = 'Постоје параметри који недостају у овој URL адреси';
$string['view_error_userlimit_reached'] = 'Достигнут је дозвољени број корисника на састанку.';
$string['view_groups_nogroups_warning'] = 'Конференцијска соба је конфигурисана за коришћење група, али на нивоу курса нема дефинисаних групе.';
$string['view_groups_selection'] = 'Изаберите групу којој желите да приступите и потврдите акцију';
$string['view_groups_selection_join'] = 'Приступите';
$string['view_groups_selection_warning'] = 'Постоји конференцијска соба за сваку групу. Ако имате приступ већем броју соба будите сигурни да сте изабрали праву.';
$string['view_login_moderator'] = 'Пријављивање као модератор...';
$string['view_login_viewer'] = 'Пријављивање као посматрач...';
$string['view_message_and'] = 'и';
$string['view_message_conference_has_ended'] = 'Ова конференција је завршена.';
$string['view_message_conference_in_progress'] = 'Ова конференција је у току.';
$string['view_message_conference_not_started'] = 'Ова конференција још није почела.';
$string['view_message_conference_room_ready'] = 'Ова конференцијска соба је спремна. Сада можете да приступите сесији.';
$string['view_message_conference_wait_for_moderator'] = 'Сачекајте да модератор приступи.';
$string['view_message_finished'] = 'Ова активност је завршена.';
$string['view_message_has_joined'] = 'приступио/ла је';
$string['view_message_have_joined'] = 'приступили су';
$string['view_message_hour'] = 'сат';
$string['view_message_hours'] = 'сати';
$string['view_message_minute'] = 'минут';
$string['view_message_minutes'] = 'минути';
$string['view_message_moderator'] = 'модератор';
$string['view_message_moderators'] = 'модератори';
$string['view_message_norecordings'] = 'Не постоји снимак овог састанка.';
$string['view_message_notavailableyet'] = 'Ова сесија још није доступна.';
$string['view_message_room_closed'] = 'Ова конференцијска соба је затворена.';
$string['view_message_room_open'] = 'Ова конференцијска соба је отворена.';
$string['view_message_room_ready'] = 'Ова конференцијска соба је спремна.';
$string['view_message_session_for'] = 'сесија за';
$string['view_message_session_has_user'] = 'Постоји';
$string['view_message_session_has_users'] = 'Постоје';
$string['view_message_session_no_users'] = 'Нема корисника у овој сесији';
$string['view_message_session_running_for'] = 'Ова сесија траје већ';
$string['view_message_session_started_at'] = 'Ова сесија је почела у';
$string['view_message_tab_close'] = 'Ова картица/прозор мора ручно да се затвори';
$string['view_message_times'] = 'пута';
$string['view_message_user'] = 'корисник';
$string['view_message_users'] = 'корисници';
$string['view_message_viewer'] = 'посматрач';
$string['view_message_viewers'] = 'посматрачи';
$string['view_noguests'] = 'BigBlueButtonBN није отворен за госте';
$string['view_nojoin'] = 'Нисте у улози којој дозвољено да приступи овој сесији.';
$string['view_recording'] = 'снимак';
$string['view_recording_actionbar'] = 'Трака са алаткама';
$string['view_recording_activity'] = 'Активност';
$string['view_recording_button_import'] = 'Увези линкове снимака';
$string['view_recording_button_return'] = 'Врати се';
$string['view_recording_course'] = 'Курс';
$string['view_recording_date'] = 'Датум';
$string['view_recording_delete_confirmation'] = 'Да ли сте сигурни да желите да обришете овај {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Овај снимак има {$a} придружена/их линк(ов)а који су били увезени у различите курсеве или активности. Ако се снимaк обрише онда ће и ти линкови бити обрисани.';
$string['view_recording_delete_confirmation_warning_s'] = 'Овај снимак има {$a} придружени линк који је био увезен у различит курс или активност.  Ако се снимaк обрише онда ће и тај линк бити обрисани.';
$string['view_recording_description'] = 'Опис';
$string['view_recording_duration'] = 'Трајање';
$string['view_recording_duration_min'] = 'мин';
$string['view_recording_format_errror_unreachable'] = 'URL адреса за овај формат снимка је недоступан.';
$string['view_recording_format_notes'] = 'Белешке';
$string['view_recording_format_podcast'] = 'Поткаст';
$string['view_recording_format_presentation'] = 'Презентација';
$string['view_recording_format_screenshare'] = 'Дељење екрана';
$string['view_recording_format_statistics'] = 'Статистика';
$string['view_recording_format_video'] = 'Видео';
$string['view_recording_import_confirmation'] = 'Да ли сте сигурни да желите да увезете овај снимак?';
$string['view_recording_length'] = 'Дужина';
$string['view_recording_link'] = 'увезен линк';
$string['view_recording_link_warning'] = 'Ово је линк који показује на снимак који је креиран унутар другог курса или активности';
$string['view_recording_list_action_delete'] = 'Брисање';
$string['view_recording_list_action_edit'] = 'Ажурирање';
$string['view_recording_list_action_play'] = 'Репродукуј снимак';
$string['view_recording_list_action_process'] = 'Обрада';
$string['view_recording_list_action_protect'] = 'Заштита';
$string['view_recording_list_action_publish'] = 'Објављивање';
$string['view_recording_list_action_unprotect'] = 'Уклањање заштите';
$string['view_recording_list_action_unpublish'] = 'Опозив објављивања';
$string['view_recording_list_action_update'] = 'Ажурирање';
$string['view_recording_list_actionbar'] = 'Трака са алаткама';
$string['view_recording_list_actionbar_delete'] = 'Обриши';
$string['view_recording_list_actionbar_edit'] = 'Уреди';
$string['view_recording_list_actionbar_hide'] = 'Сакриј';
$string['view_recording_list_actionbar_import'] = 'Увоз';
$string['view_recording_list_actionbar_protect'] = 'Учини снимак приватним';
$string['view_recording_list_actionbar_publish'] = 'Објави';
$string['view_recording_list_actionbar_show'] = 'Прикажи';
$string['view_recording_list_actionbar_unprotect'] = 'Учини снимак јавним';
$string['view_recording_list_actionbar_unpublish'] = 'Опозови објављени снимак';
$string['view_recording_list_activity'] = 'Активност';
$string['view_recording_list_course'] = 'Курс';
$string['view_recording_list_date'] = 'Датум';
$string['view_recording_list_description'] = 'Опис';
$string['view_recording_list_duration'] = 'Трајање';
$string['view_recording_list_recording'] = 'Снимак';
$string['view_recording_meeting'] = 'Састанак';
$string['view_recording_modal_button'] = 'Примени';
$string['view_recording_modal_title'] = 'Подесите вредности за снимање';
$string['view_recording_name'] = 'Назив';
$string['view_recording_playback'] = 'Репродукција';
$string['view_recording_preview'] = 'Преглед';
$string['view_recording_preview_help'] = 'Пређите курсором преко слике како бисте је видели у пуној величини';
$string['view_recording_recording'] = 'Снимак';
$string['view_recording_tags'] = 'Ознаке';
$string['view_recording_unpublish_confirmation'] = 'Да ли сте сигурни да желите да опозовете објаву овог снимка {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Овај снимак има {$a} придружена/их линк(ов)а који су били увезени у различите курсеве или активности. Ако се опозове објава снимка онда ће и ти линкови бити опозвани.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Овај снимак има {$a} придружени линк који је био увезен у различит курс или активност. Ако се опозове објава снимка онда ће и тај линк бити опозван.';
$string['view_recording_yui_first'] = 'Прва';
$string['view_recording_yui_go'] = 'Иди';
$string['view_recording_yui_last'] = 'Последња';
$string['view_recording_yui_next'] = 'Следећа';
$string['view_recording_yui_page'] = 'Страница';
$string['view_recording_yui_prev'] = 'Претходна';
$string['view_recording_yui_rows'] = 'Редови';
$string['view_recording_yui_show_all'] = 'Прикажи све';
$string['view_room'] = 'Прикажи конференцијску собу';
$string['view_section_title_presentation'] = 'Датотека презентације';
$string['view_section_title_recordings'] = 'Снимци';
