<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'sr_lt', version '3.9'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'Proces kreiranja rezervne kopije je završen';
$string['asyncbackupcompletebutton'] = 'Nastavi';
$string['asyncbackupcompletedetail'] = 'Proces kreiranja rezervne kopije je uspešno završen. <br/> Rezervnoj kopiji možete pristupiti na <a href="{$a}">stranici za restauriranje.</a>';
$string['asyncbackuperror'] = 'Proces kreiranja rezervne kopije nije uspeo';
$string['asyncbackuperrordetail'] = 'Proces kreiranja rezervne kopije nije uspeo. Obratite se administratoru sistema.';
$string['asyncbackuppending'] = 'Proces kreiranja rezervne kopije je na čekanju';
$string['asyncbackupprocessing'] = 'Kreiranja rezervne kopije je u toku';
$string['asyncbadexecution'] = 'Loš kontroler kreiranja rezervne kopije. Vrednost mu je {$a} a treba da bude 2.';
$string['asynccheckprogress'] = 'Napredak možete proveriti u bilo kom trenutku na <a href="{$a}">stranici za restauriranje</a>.';
$string['asyncemailenable'] = 'Omogući obaveštenja sa porukom';
$string['asyncemailenabledetail'] = 'Ako je ova opcija omogućena, korisnici će primiti poruku kada se završi asinhrono kreiranje ili restauriranje rezervne kopije.';
$string['asyncgeneralsettings'] = 'Asinhrono kreiranje/restauriranje rezervne kopije';
$string['asyncmessagebody'] = 'Poruka';
$string['asyncmessagebodydefault'] = 'Poštovani/a {user_firstname} {user_lastname}, <br/> Vaše {operation} (ID: {backupid}) uspešno je završeno. <br/><br/>Možete mu pristupiti ovde {link}.';
$string['asyncmessagebodydetail'] = 'Poruka za slanje kada se završi asinhrono kreiranje ili restauriranje rezervne kopije.';
$string['asyncmessagesubject'] = 'Tema';
$string['asyncmessagesubjectdefault'] = 'Moodle {operation} uspešno završen/a/o';
$string['asyncmessagesubjectdetail'] = 'Tema poruke';
$string['asyncnowait'] = 'Ne morate da čekate ovde, jer će se proces nastaviti u pozadini.';
$string['asyncprocesspending'] = 'Proces na čekanju';
$string['asyncrestorecomplete'] = 'Proces restauriranja je završen';
$string['asyncrestorecompletebutton'] = 'Nastavi';
$string['asyncrestorecompletedetail'] = 'Proces restauriranja rezervne kopije uspešno je završen. Klik na dugme \'Nastavi\' odvešće vas na <a href="{$a}">kurs za restauriranu stavku.</a>';
$string['asyncrestoreerror'] = 'Proces restauriranja rezervne kopije nije uspeo';
$string['asyncrestoreerrordetail'] = 'Proces restauriranja rezervne kopije nije uspeo. Obratite se administratoru sistema.';
$string['asyncrestoreinprogress'] = 'Proces restauriranja rezervne kopije je u toku';
$string['asyncrestoreinprogress_help'] = 'Ovde su prikazana asinhrona restauriranja rezervnih kopija kurseva koja su u toku.';
$string['asyncrestorepending'] = 'Proces restauriranja rezervne kopije na čekanju';
$string['asyncrestoreprocessing'] = 'Restauriranja rezervne kopije u toku';
$string['asyncreturn'] = 'Povratak na kurs';
$string['autoactivedescription'] = 'Izaberite hoće li rezervne kopije biti kreirane automatski ili ne. Ako je izabrana opcija \'Ručno\', automatsko pravljenje rezervnih kopija biće moguće jedino putem automatizovane CLI skripte. Navedena skripta može da bude pokrenuta bilo ručno iz komandne linije ili putem krona.';
$string['autoactivedisabled'] = 'Onemogućeno';
$string['autoactiveenabled'] = 'Omogućeno';
$string['autoactivemanual'] = 'Ručno';
$string['automatedbackupschedule'] = 'Raspored';
$string['automatedbackupschedulehelp'] = 'Izaberite dane u sedmici kada će se automatski kreirati rezervne kopije.';
$string['automatedbackupsinactive'] = 'Administrator sajta nije omogućio automatsko kreiranje rezervnih kopija';
$string['automatedbackupstatus'] = 'Status automatskog kreiranja rezervnih kopija';
$string['automateddeletedays'] = 'Obriši rezervne kopije starije od';
$string['automatedmaxkept'] = 'Maksimalan broj rezervnih kopija koji se čuva';
$string['automatedmaxkepthelp'] = 'Ovo podešavanje određuje maksimalan broj skorašnjih automatskih rezervnih kopija koji se čuva za svaki kurs. Starije rezervne kopije biće automatski obrisane.';
$string['automatedminkept'] = 'Minimalan broj rezervnih kopija koji se čuva';
$string['automatedminkepthelp'] = 'Ako se rezervne kopije, starije od navedenog broja dana, brišu, može se desiti da neaktivni kursevi budu bez rezervnih kopija. Da se ovo ne bi dogodilo potrebno je navesti minimalan broj kopija koji se čuva.';
$string['automatedsettings'] = 'Podešavanja za automatsko kreiranje rezervnih kopija';
$string['automatedsetup'] = 'Podešavanje automatskog kreiranja rezervnih kopija';
$string['automatedstorage'] = 'Prostor za čuvanje automatski kreiranih rezervnih kopija';
$string['automatedstoragehelp'] = 'Izaberite mesto na kojem želite da sačuvate rezervne kopije kada budu automatski kreirane.';
$string['backupactivity'] = 'Aktivnost kreiranja rezervne kopije: {$a}';
$string['backupcourse'] = 'Rezervna kopija kursa: {$a}';
$string['backupcoursedetails'] = 'Podaci o kursu';
$string['backupcoursesection'] = 'Sekcija: {$a}';
$string['backupcoursesections'] = 'Sekcije kursa';
$string['backupdate'] = 'Datum';
$string['backupdetails'] = 'Detalji rezervne kopije';
$string['backupdetailsnonstandardinfo'] = 'Izabrana datoteka nije standardna Moodle datoteka rezervne kopije. Proces restauracije će pokušati da konvertuje datoteku u standardni format i potom da je restaurira.';
$string['backupformat'] = 'Format';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Nepoznati format';
$string['backuplog'] = 'Tehničke informacije i upozorenja';
$string['backupmode'] = 'Način';
$string['backupmode10'] = 'Opšti';
$string['backupmode20'] = 'Uvoz';
$string['backupmode30'] = 'Čvorište';
$string['backupmode40'] = 'Isti sajt';
$string['backupmode50'] = 'Automatizovano';
$string['backupmode60'] = 'Konvertovano';
$string['backupmode70'] = 'Asinhrono';
$string['backupsection'] = 'Rezervna kopija sekcije kursa: {$a}';
$string['backupsettings'] = 'Podešavanja rezervne kopije';
$string['backupsitedetails'] = 'Detalji o sajtu';
$string['backupstage16action'] = 'Nastavi';
$string['backupstage1action'] = 'Sledeće';
$string['backupstage2action'] = 'Sledeće';
$string['backupstage4action'] = 'Kreiraj rezervnu kopiju';
$string['backupstage8action'] = 'Nastavi';
$string['backuptype'] = 'Tip';
$string['backuptypeactivity'] = 'Aktivnost';
$string['backuptypecourse'] = 'Kurs';
$string['backuptypesection'] = 'Sekcija';
$string['backupversion'] = 'Verzija rezervne kopije';
$string['cannotfindassignablerole'] = 'Nije moguće preslikati ulogu {$a} u datoteci rezervne kopije ni na jednu od uloga koje Vi možete da dodelite.';
$string['choosefilefromactivitybackup'] = 'Prostor za rezervne kopije aktivnosti';
$string['choosefilefromactivitybackup_help'] = 'Rezervne kopije aktivnosti, kreirane korišćenjem podrazumevanih podešavanja, smeštene su ovde.';
$string['choosefilefromautomatedbackup'] = 'Automatsko kreiranje rezervnih kopija';
$string['choosefilefromautomatedbackup_help'] = 'Sadrži automatski generisane rezervne kopije';
$string['choosefilefromcoursebackup'] = 'Prostor za rezervne kopije kursa';
$string['choosefilefromcoursebackup_help'] = 'Rezervne kopije kurseva, kreirane korišćenjem podrazumevanih podešavanja, smeštene su ovde.';
$string['choosefilefromuserbackup'] = 'Prostor za privatne rezervne kopije korisnika';
$string['choosefilefromuserbackup_help'] = 'Datoteke rezervnih kopija sa uključenom opcijom \'Anonimizuj informacije o korisniku\', smeštene su ovde.';
$string['config_keep_groups_and_groupings'] = 'Standardno, zadrži tekuće grupe i grupisanja.';
$string['config_keep_roles_and_enrolments'] = 'Standardno, zadrži tekuće uloge i upise.';
$string['config_overwrite_conf'] = 'Omogućava korisniku da izmeni trenutnu konfiguraciju kursa';
$string['config_overwrite_course_fullname'] = 'Standardno, zamenite pun naziv kursa sa onim koji je u rezervnoj kopiji. Ovo zahteva da opcija "Izmeni konfiguraciju kursa" bude označena i da trenutni korisnik ima sposobnost da menja pun naziv kursa (moodle/course:changefullname)';
$string['config_overwrite_course_shortname'] = 'Standardno, zamenite skraćeni naziv kursa sa onim koji je u rezervnoj kopiji. Ovo zahteva da opcija "Izmeni konfiguraciju kursa" bude označena i da trenutni korisnik ima sposobnost da menja skraćeni naziv kursa (moodle/course:changeshortname)';
$string['config_overwrite_course_startdate'] = 'Standardno, zamenite datum početka kursa sa onim koji je u rezervnoj kopiji. Ovo zahteva da opcija "Izmeni konfiguraciju kursa" bude označena i da trenutni korisnik prilikom restauriranja ima sposobnost da menja datum početka kursa (moodle/restore:rolldates)';
$string['configgeneralactivities'] = 'Postavlja podrazumevanu vrednost za uključivanje aktivnosti u rezervnu kopiju.';
$string['configgeneralanonymize'] = 'Ako je omogućeno ova opcija, sve informacije o korisnicima biće sakrivene (postaće anonimne).';
$string['configgeneralbadges'] = 'Postavlja podrazumevanu vrednost za uključivanje bedževa u rezervne kopije.';
$string['configgeneralblocks'] = 'Postavlja podrazumevanu vrednost za uključivanje blokova u rezervnu kopiju.';
$string['configgeneralcalendarevents'] = 'Postavlja podrazumevanu vrednost za uključivanje događaja iz kalendara u rezervnu kopiju.';
$string['configgeneralcomments'] = 'Postavlja podrazumevanu vrednost za uključivanje komentara u rezervnu kopiju.';
$string['configgeneralcompetencies'] = 'Postavlja podrazumevanu vrednost za uključivanje kompetencija u rezervnu kopiju.';
$string['configgeneralcontentbankcontent'] = 'Podešava uključivanje sadržaja banke sadržaja u rezervnu kopiju kao podrazumevano.';
$string['configgeneralfiles'] = 'Podešava uključivanje datoteka u rezervne kopije kao podrazumevano. Imajte u vidu: Isključivanje ovog podešavanja rezultiraće rezervnom kopijom koja uključuje samo reference na datoteke. Ovo nije problem ako se rezervna kopija restaurira na istom sajtu i datoteke nisu izbrisane u skladu sa podešavanjem \'Očisti datoteke označene kao smeće\'.';
$string['configgeneralfilters'] = 'Postavlja podrazumevanu vrednost za uključivanje filtera u rezervnu kopiju.';
$string['configgeneralgroups'] = 'Postavlja podrazumevano uključivanja grupa i grupisanja u rezervne kopije.';
$string['configgeneralhistories'] = 'Postavlja podrazumevanu vrednost za uključivanje istorije korisnika u rezervnu kopiju.';
$string['configgenerallogs'] = 'Ako je ova opcija omogućena, zapisi o aktivnostima, standardno će biti uključeni u rezervne kopije.';
$string['configgeneralquestionbank'] = 'Ako omogućite ovu opciju, banka pitanja biće standardno uključena u rezervne kopije. NAPOMENA: Isključivaanje ovog podešavanja onemogućiće kreiranje rezervne kopije onih aktivnosti koje koriste banku pitanja, kao što je to test.';
$string['configgeneralroleassignments'] = 'Ako je omogućeno dodele uloga biće, takođe, uključene u rezervne kopije.';
$string['configgeneralusers'] = 'Postavlja podrazumevanu vrednost za uključivanje korisnika u rezervnu kopiju.';
$string['configgeneraluserscompletion'] = 'Ako je ova opcija omogućena, onda će informacije o tome u kojoj meri su polaznici završili pojedine aktivnosti, standardno biti uključene u rezervnu kopiju';
$string['configloglifetime'] = 'Ovo podešavanje određuje koliko dugo želite da čuvate informacije o zapisima nastalim tokom kreiranja rezervnih kopija kurseva. Zapisi koji su stariji biće automatski obrisani. Preporučuje se da ovaj vremenski interval bude kratak jer navedenih informacija može biti veoma mnogo.';
$string['configrestoreactivities'] = 'Postavlja podrazumevanu vrednost za restauriranje aktivnosti.';
$string['configrestorebadges'] = 'Postavlja podrazumevanu vrednost za restauriranje bedževa.';
$string['configrestoreblocks'] = 'Postavlja podrazumevanu vrednost za restauriranje blokova.';
$string['configrestorecalendarevents'] = 'Postavlja podrazumevanu vrednost za restauriranje događaja u kalendaru.';
$string['configrestorecomments'] = 'Postavlja podrazumevanu vrednost za restauriranje komentara.';
$string['configrestorecompetencies'] = 'Postavlja podrazumevanu vrednost za restauriranje kompetencija.';
$string['configrestorecontentbankcontent'] = 'Podešava podrazumevane vrednosti za restauriranje sadržaja banke sadržaja.';
$string['configrestoreenrolments'] = 'Postavlja podrazumevanu vrednost za restauriranje metoda upisa.';
$string['configrestorefilters'] = 'Postavlja podrazumevanu vrednost za restauriranje filtera.';
$string['configrestoregroups'] = 'Postavlja podrazumevanu vrednost za restauriranje grupa i grupisanja ako su uključeni u rezervnu kopiju.';
$string['configrestorehistories'] = 'Postavlja podrazumevanu vrednost za restauriranje istorije korisnika ako je uključena u rezervnu kopiju.';
$string['configrestorelogs'] = 'Ako je ova opcija omogućena, zapisi će standardno biti restaurisani ukoliko su uključeni u rezervnu kopiju.';
$string['configrestoreroleassignments'] = 'Ako je ova opcija omogućena, dodele uloga će standardno biti restaurisane ukoliko su uključene u rezervnu kopiju.';
$string['configrestoreusers'] = 'Postavlja podrazumevanu vrednost za restauriranje korisnika ako su uključeni u rezervnu kopiju.';
$string['configrestoreuserscompletion'] = 'Ako je ova opcija omogućena, informacije o završetku će standardno biti restaurisane ukoliko su uključene u rezervnu kopiju.';
$string['confirmcancel'] = 'Otkaži kreiranje rezervne kopije';
$string['confirmcancelimport'] = 'Otkaži uvoz';
$string['confirmcancelno'] = 'Ne otkazuj';
$string['confirmcancelquestion'] = 'Da li ste sigurni da želite da odustanete? Sve informacije koje ste uneli biće izgubljene.';
$string['confirmcancelrestore'] = 'Otkaži restauriranje';
$string['confirmcancelyes'] = 'Otkaži rezervnu kopiju';
$string['confirmnewcoursecontinue'] = 'Upozorenje o novom kursu';
$string['confirmnewcoursecontinuequestion'] = 'Procedura za restauraciju kursa će kreirati privremeni (sakriveni) kurs. Da biste prekinuli proceduru kliknite na \'Otkaži\'. Nemojte zatvarati veb čitač dok je restauracija u toku.';
$string['copiesinprogress'] = 'Procedura kopiranja ovog kursa je u toku. <a href="{$a}">Pogledajte procedure kopiranja koje su u toku.</a>';
$string['copycoursedesc'] = 'Ovaj kurs će biti dupliran i smešten u izabranu kategoriju kursa.';
$string['copycourseheading'] = 'Kopiraj kurs';
$string['copycoursetitle'] = 'Kopiranje kursa: {$a}';
$string['copydest'] = 'Odredište';
$string['copyfieldnotfound'] = 'Obavezno polje nije pronađeno';
$string['copyformfail'] = 'AJAX obrazac za predaju kopije kursa nije uspeo.';
$string['copyingcourse'] = 'U toku je kopiranje kursa';
$string['copyingcourseshortname'] = 'kopiranje';
$string['copyop'] = 'Tekuće operacije';
$string['copyprogressheading'] = 'Kopije kurseva u toku';
$string['copyprogressheading_help'] = 'Ova tabela prikazuje status svih vaših nedovršenih kopija kurseva.';
$string['copyprogresstitle'] = 'Napredak kopije kursa';
$string['copyreturn'] = 'Kopiraj i vrati se nazad';
$string['copysource'] = 'Izvor';
$string['copyview'] = 'Kopiraj i pregledaj';
$string['coursecategory'] = 'Kategorija u koju će kurs biti restauriran';
$string['courseid'] = 'Originalni ID';
$string['coursesettings'] = 'Podešavanja kursa';
$string['coursetitle'] = 'Naslov';
$string['currentstage1'] = 'Početna podešavanja';
$string['currentstage16'] = 'Završeno';
$string['currentstage2'] = 'Podešavanja šeme';
$string['currentstage4'] = 'Potvrda i pregled';
$string['currentstage8'] = 'Kreiraj rezervnu kopiju';
$string['enableasyncbackup'] = 'Omogućite asinhrono kreiranje rezervnih kopija';
$string['enableasyncbackup_help'] = 'Ako je ova opcija omogućena, sve operacije kreiranja i restauriranja rezervnih kopija biće izvršene asinhrono. Ovo ne utiče na uvoz i izvoz. Asinhrona kreiranja i restauriranja rezervnih kopija omogućavaju korisnicima da obavljaju druge operacije dok su kreiranje i restauriranje u toku.';
$string['enterasearch'] = 'Unesite pojam za pretraživanje';
$string['error_block_for_module_not_found'] = 'Pronađena je napuštena instanca bloka (id: {$a}). Rezervna kopija ovog bloka neće biti kreirana.';
$string['error_course_module_not_found'] = 'Pronađen je napušten modul kursa (id: {$a}). Rezervna kopija ovog modula neće biti kreirana.';
$string['errorcopyingbackupfile'] = 'Pokušaj kopiranja datoteke rezervne kopije u privremeni direktorijum nije uspeo, pre restaurianja.';
$string['errorfilenamemustbezip'] = 'Naziv datoteke mora biti ZIP arhiva i imati mbz ekstenziju';
$string['errorfilenamerequired'] = 'Morate uneti ispravan naziv datoteke za ovu rezervnu kopiju';
$string['errorfilenametoolong'] = 'Dužina naziva datoteke mora da bude manja od 255 znakova';
$string['errorinvalidformat'] = 'Nepoznat format rezervne kopije';
$string['errorinvalidformatinfo'] = 'Izabrana datoteka nije ispravna Moodle datoteka rezervne kopije i ne može biti restaurirana.';
$string['errorminbackup20version'] = 'Ova datoteka rezervne kopije je kreirana pomoću razvojne verzije Moodle funkcije za kreiranje rezervne kopije ({$a->backup}). Minimalana zahtevana verzija je {$a->min}. Ova rezervna kopija ne može biti restaurirana.';
$string['errorrestorefrontpagebackup'] = 'Rezervne kopije naslovne strane možete restaurirati samo na naslovnoj strani';
$string['executionsuccess'] = 'Datoteka rezervne kopije je uspešno kreirana';
$string['failed'] = 'Kreiranje rezervne kopije nije uspelo';
$string['filealiasesrestorefailures'] = 'Neuspešna restauriranja alijasa';
$string['filealiasesrestorefailures_help'] = 'Alijasi su simbolički linkovi ka drugim datotekama, uključujući one koje su uskladištene u eksternim repozitorijumima. U nekim slučajevima Moodle ne može da restaurira alijase - na primer, kada restaurira rezervnu kopiju na drugom sajtu ili kada datoteka na koju se referencira ne postoji.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Neki alijasi uključeni u datoteku rezervne kopije ne mogu da se restauriraju. Sledeći spisak sadrži njihove očekivane lokacije, kao i izvornu datoteku na koju alijasi referenciraju na originalnom sajtu.';
$string['filename'] = 'Naziv datoteke';
$string['filereferencesincluded'] = 'Reference datoteka ka spoljašnjim sadržajima uključene su u rezervnu kopiju. Ovo neće funkcionisati ako se rezervna kopija restauiriše na nekom drugom sajtu.';
$string['filereferencesnotsamesite'] = 'Datoteka rezervna kopije je sa drugog sajta, tako da reference datoteka ne mogu da se restaurišu.';
$string['filereferencessamesite'] = 'Datoteka rezervna kopije je sa ovog sajta, tako da reference datoteka mogu da se restaurišu.';
$string['generalactivities'] = 'Uključi aktivnosti i resurse';
$string['generalanonymize'] = 'Sakrivanje informacija';
$string['generalbackdefaults'] = 'Opšta podrazumevana podešavanja za kreiranje rezervnih kopija';
$string['generalbadges'] = 'Uključi bedževe';
$string['generalblocks'] = 'Uključi blokove';
$string['generalcalendarevents'] = 'Uključi događaje iz kalendara';
$string['generalcomments'] = 'Uključi komentare';
$string['generalcompetencies'] = 'Uključi kompetencije';
$string['generalcontentbankcontent'] = 'Uključi sadržaj banke sadržaja';
$string['generalenrolments'] = 'Uključi metode upisa';
$string['generalfiles'] = 'Uključi datoteke';
$string['generalfilters'] = 'Uključi filtere';
$string['generalgradehistories'] = 'Uključi istorije ocena';
$string['generalgroups'] = 'Uključi grupe i grupisanja';
$string['generalhistories'] = 'Uključi istorije';
$string['generallogs'] = 'Uključi zapise o aktivnostima';
$string['generalquestionbank'] = 'Uključi banku pitanja';
$string['generalrestoredefaults'] = 'Opšta podrazumevana podešavanja za restauriranje';
$string['generalrestoresettings'] = 'Opšta podešavanja za restauriranje';
$string['generalroleassignments'] = 'Uključi dodeljene uloge';
$string['generalsettings'] = 'Opšta podešavanja vezana za kreiranje rezervnih kopija';
$string['generalusers'] = 'Uključi korisnike';
$string['generaluserscompletion'] = 'Uključi korisničke informacije o završetku aktivnosti';
$string['hidetypes'] = 'Sakrij opcije tipa';
$string['importbackupstage16action'] = 'Nastavi';
$string['importbackupstage1action'] = 'Sledeće';
$string['importbackupstage2action'] = 'Sledeće';
$string['importbackupstage4action'] = 'Uvezi';
$string['importbackupstage8action'] = 'Nastavi';
$string['importcurrentstage0'] = 'Izbor kursa';
$string['importcurrentstage1'] = 'Početna podešavanja';
$string['importcurrentstage16'] = 'Završeno';
$string['importcurrentstage2'] = 'Podešavanja šeme';
$string['importcurrentstage4'] = 'Potvrda i pregled';
$string['importcurrentstage8'] = 'Uvezi';
$string['importfile'] = 'Uvezi datotetku rezervne kopije';
$string['importgeneralduplicateadminallowed'] = 'Dozvoli rešavanje administrativnog konflikta';
$string['importgeneralduplicateadminallowed_desc'] = 'Ako na sajtu postoji nalog sa korisničkim imenom \'admin\', pokušaj restauracije rezervne kopije koja sadrži nalog sa korisničkim imenom \'admin\' može prouzrokovati konflikt. Ako je ovo podešavanje aktivirano, konflikt će biti rešen promenom korisničkog imena u rezervnoj kopiji na \'admin_xyz\'.';
$string['importgeneralmaxresults'] = 'Maksimalan broj kurseva navedenih za uvoz';
$string['importgeneralmaxresults_desc'] = 'Ova opcija kontroliše broj kurseva koji su navedeni tokom prvog koraka u procesu uvoza';
$string['importgeneralsettings'] = 'Opšte podrazumevane vrednosti uvoza';
$string['importrootsettings'] = 'Podešavanja uvoza';
$string['importsettings'] = 'Opšta podešavanja uvoza';
$string['importsuccess'] = 'Uvoz je završen. Klikni na \'Nastavi\' za povratak na kurs.';
$string['includeactivities'] = 'Uključi';
$string['includeditems'] = 'Uključene stavke';
$string['includefilereferences'] = 'Reference datoteka ka spoljašnjim datotekama';
$string['includesection'] = 'Sekcija {$a}';
$string['includeuserinfo'] = 'Uključi korisničke informacije';
$string['inprogress'] = 'Kreiranje rezervne kopije u toku';
$string['jumptofinalstep'] = 'Idi na završni korak';
$string['keep'] = 'Zadrži';
$string['keptroles'] = 'Uključi upise uloga';
$string['keptroles_help'] = 'Korisnici sa izabranim ulogama biće upisani u novi kurs. Nijedan korisnički podatak neće se kopirati ako nije omogućeno \'Uključi korisničke podatke\'.';
$string['locked'] = 'Zaključano';
$string['lockedbyconfig'] = 'Ovo podešavanje je zaključano podrazumevanim podešavanjima za kreiranje rezervne kopije';
$string['lockedbyhierarchy'] = 'Zaključano od strane zavisnih elemenata';
$string['lockedbypermission'] = 'Nemate dovoljna ovlašćenja za promenu ovog podešavanja';
$string['loglifetime'] = 'Čuvaj zapise';
$string['managefiles'] = 'Upravljanje rezervnim kopijama';
$string['mergerestoredefaults'] = 'Restauriraj podrazumevana podešavanja prilikom spajanja sa drugim kursom';
$string['missingfilesinpool'] = 'Neke datoteke nisu mogle biti sačuvana tokom kreiranja rezervne kopije, tako da restauracija tih datoteka neće biti moguća.';
$string['module'] = 'Modul';
$string['moodleversion'] = 'Verzija Moodlea';
$string['morecoursesearchresults'] = 'Pronađeno je više od {$a} kursa/eva, prikazuje se prva/ih {$a} rezultata';
$string['moreresults'] = 'Previše rezultata, unesite preciznije pojmove za pretragu.';
$string['nomatchingcourses'] = 'Nema kurseva za prikaz';
$string['norestoreoptions'] = 'Nema kategorija ili postojećih kurseva u koje se mogu resaurirati rezervne kopije';
$string['originalwwwroot'] = 'URL adresa rezervne kopije';
$string['overwrite'] = 'Izmeni';
$string['pendingasyncdeletedetail'] = 'Ovaj kurs ima asinhrono kreiranje rezervne kopije na čekanju. <br/> Kursevi ne mogu biti obrisani dok se ovo kreiranje rezervne kopije ne završi.';
$string['pendingasyncdetail'] = 'Asinhrono kreiranje rezervnih kopija omogućava korisniku da u isto vreme ima samo jedno kreiranje rezervne kopije resursa na čekanju. <br/> Na čekanju ne može biti više asinhronih kreiranja rezervnih kopija istog resursa, jer bi to verovatno rezultiralo višestrukim rezervnim kopijama sa istim sadržajem.';
$string['pendingasyncedit'] = 'Za ovaj kurs postoji asinhrono kreiranje rezervne kopije na čekanju. Nemojte uređivati ovaj kurs dok se ne završi kreiranje rezervne kopije.';
$string['pendingasyncerror'] = 'Rezervna kopija za ovaj resurs na čekanju';
$string['preparingdata'] = 'Priprema podataka';
$string['preparingui'] = 'Priprema za prikazivanje stranice';
$string['previousstage'] = 'Prethodno';
$string['privacy:metadata:backup:detailsofarchive'] = 'Ova arhiva može da sadrži različite korisničke podatke vezane za kurs, kao što su ocene, upisi i zapisi o aktivnostima.';
$string['privacy:metadata:backup:externalpurpose'] = 'Svrha ove arhive je da čuva informacije vezane za kurs, koje mogu biti restaurirane u budućnosti.';
$string['privacy:metadata:backup_controllers'] = 'Spisak operacija za kreiranje rezervnih kopija';
$string['privacy:metadata:backup_controllers:itemid'] = 'Identifikator kursa';
$string['privacy:metadata:backup_controllers:operation'] = 'Operacija koja je izvršena, npr. restauracija.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Vreme kada je kreirana akcija';
$string['privacy:metadata:backup_controllers:timemodified'] = 'Vreme kada je izmenjena akcija';
$string['privacy:metadata:backup_controllers:type'] = 'Tip stavke s kojom se radi, npr. aktivnost.';
$string['qcategory2coursefallback'] = 'Kategorija pitanja "{$a->name}", izvorno smeštena u kontekst sistema/kategorije kursa u datoteci rezervne kopije, biće kreirana u kontekstu kursa tokom restauracije';
$string['qcategorycannotberestored'] = 'Kategorija pitanja "{$a->name}" ne može biti kreirana tokom restauracije rezervne kopije';
$string['question2coursefallback'] = 'Kategorija pitanja "{$a->name}", izvorno smeštena u kontekst sistema/kategorije kursa u datoteci rezervne kopije, biće kreirana u kontekstu kursa, tokom restauracije';
$string['questionegorycannotberestored'] = 'Pitanja "{$a->name}" ne mogu biti kreirana tokom restauracije';
$string['recyclebin_desc'] = 'Imajte na umu da će ova podešavanja biti korišćena i za korpu za otpatke.';
$string['replacerestoredefaults'] = 'Restauriraj podrazumevana podešavanja prilikom restauriranja u drugi kurs i brisanja njegovog sadržaja';
$string['restoreactivity'] = 'Restauriraj aktivnost';
$string['restorecourse'] = 'Restauriraj kurs';
$string['restorecoursesettings'] = 'Podešavanja kursa';
$string['restoreexecutionsuccess'] = 'Kurs je uspešno restauriran, klik na dugme za nastavak će vas odvesti na pregled kursa koji ste restaurirali.';
$string['restorefileweremissing'] = 'Neke datoteke se ne mogu restaurisati zato što su nedostajale u rezervnoj kopiji.';
$string['restorenewcoursefullname'] = 'Novi naziv kursa';
$string['restorenewcourseshortname'] = 'Novi skraćeni naziv kursa';
$string['restorenewcoursestartdate'] = 'Novi datum početka kursa';
$string['restorerolemappings'] = 'Odredi uloge';
$string['restorerootsettings'] = 'Podešavanja za restauriranje';
$string['restoresection'] = 'Restauriraj sekciju';
$string['restorestage1'] = 'Potvrdi';
$string['restorestage16'] = 'Pregled';
$string['restorestage16action'] = 'Pokreni restauriranje';
$string['restorestage1action'] = 'Sledeće';
$string['restorestage2'] = 'Odredište';
$string['restorestage2action'] = 'Sledeće';
$string['restorestage32'] = 'Proces';
$string['restorestage32action'] = 'Nastavi';
$string['restorestage4'] = 'Podešavanja';
$string['restorestage4action'] = 'Sledeće';
$string['restorestage64'] = 'Završeno';
$string['restorestage64action'] = 'Nastavi';
$string['restorestage8'] = 'Šema';
$string['restorestage8action'] = 'Sledeće';
$string['restoretarget'] = 'Restauriraj odredišni kurs';
$string['restoretocourse'] = 'Restauriraj u kurs';
$string['restoretocurrentcourse'] = 'Restauriraj u ovaj kurs';
$string['restoretocurrentcourseadding'] = 'Dodaj rezervnu kopiju kursa u ovaj kurs';
$string['restoretocurrentcoursedeleting'] = 'Obriši sadržaj ovog kursa a onda restauriraj rezervnu kopiju';
$string['restoretoexistingcourse'] = 'Restauriraj u postojeći kurs';
$string['restoretoexistingcourseadding'] = 'Dodaj rezervnu kopiju kursa u postojeći kurs';
$string['restoretoexistingcoursedeleting'] = 'Obriši sadržaj postojećeg kursa i potom restauriraj rezervnu kopiju';
$string['restoretonewcourse'] = 'Restauriraj kao novi kurs';
$string['restoringcourse'] = 'Restauriranje kursa u toku';
$string['restoringcourseshortname'] = 'restauriranje';
$string['rootenrolmanual'] = 'Restauriraj kao ručne upise';
$string['rootsettingactivities'] = 'Uključi aktivnosti i resurse';
$string['rootsettinganonymize'] = 'Sakrij korisničke informacije';
$string['rootsettingbadges'] = 'Uključi bedževe';
$string['rootsettingblocks'] = 'Uključi blokove';
$string['rootsettingcalendarevents'] = 'Uključi događaje iz kalendara';
$string['rootsettingcomments'] = 'Uključi komentare';
$string['rootsettingcompetencies'] = 'Uključi kompetencije';
$string['rootsettingcontentbankcontent'] = 'Uključi sadržaj banke sadržaja';
$string['rootsettingcustomfield'] = 'Uključi prilagođena polja';
$string['rootsettingenrolments'] = 'Uključi metode upisa';
$string['rootsettingenrolments_always'] = 'Da, uvek';
$string['rootsettingenrolments_never'] = 'Ne, restauriraj korisnike kao ručno upisane';
$string['rootsettingenrolments_withusers'] = 'Da, ali samo ako su korisnici uključeni';
$string['rootsettingfiles'] = 'Uključi datoteke';
$string['rootsettingfilters'] = 'Uključi filtere';
$string['rootsettinggradehistories'] = 'Uključi istoriju ocena';
$string['rootsettinggroups'] = 'Uključi grupe i grupisanja';
$string['rootsettingimscc1'] = 'Konvertuj u IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'Konvertuj u IMS Common Cartridge 1.1';
$string['rootsettinglogs'] = 'Uključi zapise o aktivnostima na kursu';
$string['rootsettingquestionbank'] = 'Uključi banku pitanja';
$string['rootsettingroleassignments'] = 'Uključi dodeljene korisničke uloge';
$string['rootsettings'] = 'Podešavanja kreiranja rezervne kopije';
$string['rootsettingusers'] = 'Uključi upisane korisnike';
$string['rootsettinguserscompletion'] = 'Uključi korisničke detalje o završetku aktivnosti';
$string['samesitenotification'] = 'Ova rezervna kopija je kreirana samo sa referencama na datoteke, ne sa samim datotekama. Restauracija će raditi samo na ovom sajtu.';
$string['sectionactivities'] = 'Aktivnosti';
$string['sectioninc'] = 'Uključeno u rezеrvnu kopiju (bez korisničkih informacija)';
$string['sectionincanduser'] = 'Uključeno u rezеrvnu kopiju zajedno sa korisničkim informacijama';
$string['selectacategory'] = 'Izaberi kategoriju';
$string['selectacourse'] = 'Odaberi kurs';
$string['setting_course_fullname'] = 'Naziv kursa';
$string['setting_course_shortname'] = 'Skraćeni naziv kursa';
$string['setting_course_startdate'] = 'Datum početka kursa';
$string['setting_keep_groups_and_groupings'] = 'Zadrži tekuće grupe i grupisanja';
$string['setting_keep_roles_and_enrolments'] = 'Zadrži tekuće uloge i upise';
$string['setting_overwrite_conf'] = 'Izmeni konfiguraciju kursa';
$string['setting_overwrite_course_fullname'] = 'Izmeni pun naziv kursa';
$string['setting_overwrite_course_shortname'] = 'Izmeni skraćeni naziv kursa';
$string['setting_overwrite_course_startdate'] = 'Izmeni datum početka kursa';
$string['showtypes'] = 'Prikaži opcije tipa';
$string['sitecourseformatwarning'] = 'Ovo je rezervna kopija naslovne strane, obratite pažnju da se ona može restaurirati samo na naslovnoj strani.';
$string['skiphidden'] = 'Preskoči skrivene kurseve';
$string['skiphiddenhelp'] = 'Izaberite da li da preskočite ili ne skrivene kurseve';
$string['skipmodifdays'] = 'Preskoči kurseve koji nisu promenjeni';
$string['skipmodifdayshelp'] = 'Izaberite da li da preskočite kurseve koji nisu menjani navedeni broj dana';
$string['skipmodifprev'] = 'Preskoči kurseve koji nisu promenjeni od prethodnog kreiranja rezervne kopije';
$string['skipmodifprevhelp'] = 'Izaberite da li da preskočite ili ne kurseve koji nisu menjani od poslednjeg kreiranja rezervne kopije. To zahteva uključenu opciju za kreiranje zapisa o korišćenju platforme.';
$string['status'] = 'Status';
$string['storagecourseandexternal'] = 'Prostor za datoteke kursa namenjen rezervnim kopijama i navedeni direktorijum';
$string['storagecourseonly'] = 'Prostor za datoteke kursa namenjen rezervnim kopijama';
$string['storageexternalonly'] = 'Navedeni direktorijum za automatski kreirane rezervne kopije';
$string['successful'] = 'Rezervna kopija uspešno kreirana';
$string['successfulcopy'] = 'Kopiranje je uspešno završeno';
$string['successfulrestore'] = 'Rezervna kopija uspešno restaurirana';
$string['timetaken'] = 'Utrošeno vreme';
$string['title'] = 'Naslov';
$string['totalcategorysearchresults'] = 'Ukupno kategorija: {$a}';
$string['totalcoursesearchresults'] = 'Ukupno kurseva: {$a}';
$string['undefinedrolemapping'] = 'Mapiranje uloga nije definisano za arhetip \'{$a}\'';
$string['unnamedsection'] = 'Neimenovana sekcija';
$string['userdata'] = 'Uključi korisničke podatke';
$string['userdata_help'] = 'Ako je ova opcija omogućena, podaci kao što su postovi na forumu, predati zadaci itd. biće kopirani u novi kurs za sve učesnike koji imaju ulogu izabranu u \'Uključi upise uloga\'';
$string['userinfo'] = 'Informacije o korisniku';
