<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_security', language 'sr_lt', version '3.9'.
 *
 * @package     report_security
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_configrw_details'] = '<p>Preporučljivo je da se nakon instalacije ovlašćenja nad datotekom <code>config.php</code> promeni tako da veb server ne može da je menja.
Imajte u vidu da ova mera ne povećava značajno bezbednost servera, iako može da uspori ili ograniči mogućnost opšte zloupotrebe.</p>';
$string['check_configrw_name'] = 'Upisiva config.php datoteka';
$string['check_configrw_ok'] = 'PHP skriptovi ne mogu da izmene config.php datoteku.';
$string['check_configrw_warning'] = 'PHP skriptovi mogu da izmene config.php.';
$string['check_cookiesecure_details'] = '<p>Ukoliko je omogućena https komunikacija preporučuje se da omogućite slanje bezbednih kolačića. Trebalo bi da imate permanentnu redirekciju sa http na https, a u idealnom slučaju ponudite i HSTS zaglavlja.</p>';
$string['check_cookiesecure_error'] = 'Molimo da omogućite bezbedne kolačiće';
$string['check_cookiesecure_http'] = 'Morate da uključite https kako biste koristili sigurne kolačiće';
$string['check_cookiesecure_name'] = 'Bezbedni kolačići';
$string['check_cookiesecure_ok'] = 'Bezbedni kolačići omogućeni';
$string['check_crawlers_details'] = '<p>Podešavanje "Otvoreno za pretraživače" dopušta pretraživačkim mašinama da pristupe kursevima kao gosti. Ne postoji način da se ova podešavanje uključi ukoliko prijavljivanje u ulozi gosta nije dozvonjeno.</p>';
$string['check_crawlers_error'] = 'Pristup pretraživačkim mašinama je dozvoljen ali je pristup gostima onemogućen.';
$string['check_crawlers_info'] = 'Pretraživači mogu ući kao gosti';
$string['check_crawlers_name'] = 'Otvoreno za pretraživače';
$string['check_crawlers_ok'] = 'Pristup pretraživačima nije omogućen';
$string['check_defaultuserrole_details'] = '<p>Svim korisnicima koji su prijavljeni na sistem daju se sposobnosti koje ima podrazumevana korisnička uloga. Molimo vas, proverite da za tu ulogu nisu dozvoljene opasne sposobnosti.</p>
<p>Jedino podržani tip nasleđivanja za podrazumevanu korisničku ulogu je <em>Autorizovani korisnik</em>. Sposobnost za pregled kursa ne sme biti omogućena.</p>';
$string['check_defaultuserrole_error'] = 'Podrazumevana uloga korsnika "{$a}" je pogrešno definisana!';
$string['check_defaultuserrole_name'] = 'Podrazumevana uloga za sve korisnike';
$string['check_defaultuserrole_notset'] = 'Podrazumevana uloga nije podešena';
$string['check_defaultuserrole_ok'] = 'Definicija podrazumevane ulog za sve korisnike je OK';
$string['check_displayerrors_details'] = '<p>Uključivanje PHP podešavanja <code>display_errors</code> se ne preporučuje na sajtovima sa aktivnim kursevima zato što poruke o greškama mogu otkriti osetljive informacije o vašem serveru.</p>';
$string['check_displayerrors_error'] = 'PHP podešavanje za prikazivanje grešaka je uključeno. Preporučuje se da ga isključite.';
$string['check_displayerrors_name'] = 'Prikaz PHP grešaka';
$string['check_displayerrors_ok'] = 'Prikaz PHP grešaka je onemohućen';
$string['check_emailchangeconfirmation_details'] = '<p>Preporučuje se da potvrda putem e-pošte bude neophodna kada korisnici promene elektronsku adresu u svojim profilima. Ako je ova opcija isključena, spameri mogu pokušati da iskoriste server za slanje neželjene pošte.</p>
<p>Polje za elektronsku adresu, takođe, može biti zaključano od strane dodataka za proveru identiteta. Ova mogućnost se ovde ne razmatra.</p>';
$string['check_emailchangeconfirmation_error'] = 'Korisnici mogu da unesu bilo koju elektronsku adresu';
$string['check_emailchangeconfirmation_info'] = 'Korisnici mogu mogu da unesu samo  elektronske adrese dozvonjenih domena.';
$string['check_emailchangeconfirmation_name'] = 'Potvrda promene elektronske adrese';
$string['check_emailchangeconfirmation_ok'] = 'Potvrda promene elektronske adrese u korisničkom profilu.';
$string['check_embed_details'] = 'Neograničeno umetanje objekata je veroma opasno - bilo koji registrovani korisnik može da pokrene XSS napad protiv drugih korisnika. Ovo podešavanje treba onemogućiti na serverima sa aktivnim kursevima.</p>';
$string['check_embed_error'] = 'Neograničeno umetanje objekata je omogućeno - to je veoma opasno za većinu servera.';
$string['check_embed_name'] = 'Dozvoli EMBED i OBJECT';
$string['check_embed_ok'] = 'Neograničeno umetanje objekata nije dozvoljeno';
$string['check_frontpagerole_details'] = '<p>Podrazumevana uloga naslovne stranice je data svim registrovanim korisnicima za aktivnosti na naslovnoj stranici. Molimo vas da proverite da li su za ovu ulogu dozvoljene rizične mogućnosti.</p>
<p>Preporučljivo je da se za ovu namenu kreira posebna uloga, bez upotrebe tipa nasleđivanja uloge</p>';
$string['check_frontpagerole_error'] = 'Otkrivena je pogrešno definisana uloga naslovne stranice "{$a}"!';
$string['check_frontpagerole_name'] = 'Uloga na naslovnoj stranici';
$string['check_frontpagerole_notset'] = 'Uloga na naslovnoj stranici nije podešena';
$string['check_frontpagerole_ok'] = 'Deifinicija uloge naslovne stranice je OK.';
$string['check_guestrole_details'] = '<p>Uloga Gost se koristi za goste, korisnike koje nisu prijavljeni na sistem kao i za privremeni pristup kursu. Molimo da proverite da nisu dozvoljene rizične mogućnosti za ovu ulogu.</p>
<p>Jedini podrržani nasleđeni tip za ulogu gosta je <em>Gost</em>.</p>';
$string['check_guestrole_error'] = 'Uloga gosta "{$a}" je pogrešno definisana';
$string['check_guestrole_name'] = 'Uloga gosta';
$string['check_guestrole_notset'] = 'Uloga gosta nije postavljena';
$string['check_guestrole_ok'] = 'Definicija za ulogu gosta je OK';
$string['check_mediafilterswf_details'] = '<p>Automatsko umetanje swf datoteka je veoma opasno - bilo koji registrovani korisnik može da pokrene XSS napad protiv drugih korisnika. Molimo Vas da onemogućite ovu opciju na serverima sa aktivnim kursevima.</p>';
$string['check_mediafilterswf_error'] = 'Filter za Fleš je omogućen - ovo je vrlo opasno za većinu servera.';
$string['check_mediafilterswf_name'] = '.swf filter je omogućen';
$string['check_mediafilterswf_ok'] = 'Filter za Fleš nije omogućen';
$string['check_nodemodules_details'] = '<p>Direktorijum <code>{$a->path}</code> sadrži Node.js module i njihove zavisnosti, obično instalirane pomoću NPM alata. Ovi moduli mogu biti potrebni za lokalni razvoj Moodlea, kao što je korišćenje Grunt alata. Oni nisu potrebni za pokretanje Moodlea na produkcionom severu i mogu da sadrže potencijalno opasan kôd i tako izlože vaš sajt udaljenim napadima.</p><p>Preporučuje se da uklonite direktorijum ako je sajt dostupan preko javne URL adrese, ili da barem zabranite veb pristup ovom direktorijumu, u konfiguraciji vašeg veb servera.</p>';
$string['check_nodemodules_info'] = 'Direktorijum node_modules ne bi trebalo da bude prisutan na javnim sajtovima.';
$string['check_nodemodules_name'] = 'Direktorijum Node.js modula';
$string['check_openprofiles_details'] = 'Otvorene korisničke profile mogu da zloupotrebe spameri. Preporučuje se da bude uključena ili opcija <code>Primoraj korisnike da se prijave na sistem za da bi videli korisničke profile</code> ili <code>Primoraj korisnike da se prijave na sistem</code>.';
$string['check_openprofiles_error'] = 'Svako može da vidi korisničke profile bez prijavljivanja na sistem';
$string['check_openprofiles_name'] = 'Otvoreni korisnički profili';
$string['check_openprofiles_ok'] = 'Za gledanje korisničkih profila neophodna je prethodna prijava na sistem.';
$string['check_passwordpolicy_details'] = '<p>Preporučljivo je da pravila o kreiranju lozinke bude podešena jer je pogađanje lozinki vrlo često najlakši način za sticanje neovlašćenog pristupa.
Nemojte postavljati previše stroga pravila, pošto to za posledicu može imati da korisnici ne budu u stanju da zapamte svoje lozinke, pa će ih ili zaboravljati ili zapisivati.</p>';
$string['check_passwordpolicy_error'] = 'Pravila za kreiranje lozinke nisu podešena.';
$string['check_passwordpolicy_name'] = 'Pravila za kreiranje lozinke';
$string['check_passwordpolicy_ok'] = 'Pravila za kreiranje lozinke su omogućena';
$string['check_preventexecpath_details'] = '<p>Dozvola da putanje budu podešene preko grafičkog korisničkog interfejsa za administratore predstavlja potencijalnu opasnost da pojedini korisnici steknu privilegije u sistemu koje im normalno ne pripadaju. Zato se ovo mora sprečiti sledećim podešavanjem u config.php datoteci:</p><p><code>$CFG->preventexecpath = true;<code></p>';
$string['check_preventexecpath_name'] = 'Izvršne putanje';
$string['check_preventexecpath_ok'] = 'Izvršne putanje se mogu podesiti samo u datoteci config.php.';
$string['check_preventexecpath_warning'] = 'Izvršne putanje se mogu podesiti u grafičkom korisničkom interfejsu za administratore.';
$string['check_riskadmin_detailsok'] = '<p>Molimo Vas da potvrdite sledeći spisak administratora sistema:</p>{$a}';
$string['check_riskadmin_detailswarning'] = '<p>Molimo potvrdite sledeći spisak administratora sistema:</p>{$a->admins}
<p>Preporučuje da se da ulogu administratora dodeljujete samo u kontekstu sistema. Sledeći korisnicima su dodeljene (nepodržane) administratorske uloge u drugim kontekstima:</p>{$a->unsupported}
';
$string['check_riskadmin_name'] = 'Administratori';
$string['check_riskadmin_ok'] = 'Pronađen/o je {$a} server administrator/a.';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) pregledaj dodeljene uloge</a>';
$string['check_riskadmin_warning'] = 'Pronađeno je {$a->admincount} administratora servera i {$a->unsupcount} dodeljenih administratorskih uloga koje nisu podržane.';
$string['check_riskbackup_details_overriddenroles'] = '<p>Ove aktivne izmene ovlašćenja daju korisnicima mogućniost da uključe korisničke podatke u rezervne kopije. Molimo, proverite da li je ovo ovlašćenje neophodno.</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>Sledeće sistemske uloge dopuštaju korisnicima da uključe korisničke podatke u rezervne kopije. Molimo, proverite da li je ovo ovlašćenje neophodno.</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>Zbog gore navedenih uloga ili lokalnih izmena ovlašćenja, sledeći korisnički nalozi trenutno imaju ovlašćenje da kreiraju rezervne kopije podataka koje sadrže privatne podatke bilo kog korisnika upisanog na kurs. Proverite da li su ti korisnici (a) pouzdani i (b) zaštićeni jakim lozinkama:</p> {$a}';
$string['check_riskbackup_detailsok'] = 'Nema uloge koja eksplicitno dozvoljava kreiranje rezervne kopije korisničkih podataka. Međutim imajte na umu da će administratori, koji imaju sposobnost "doanything" verovatno i dalje moći ovo da urade.';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->name} u {$a->contextname}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'Rezervna kopija korisničkih podataka';
$string['check_riskbackup_ok'] = 'Nema uloge koja eksplicitno dozvoljava kreiranje rezervne kopije korisničkih podataka';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) u {$a->contextname}</a>';
$string['check_riskbackup_warning'] = 'Pronađeno je {$a->rolecount} uloga/e, {$a->overridecount} izmena ovlašćenja i {$a->usercount} korisnika koji imaju mogućnost da kreiraju rezervne kopije korisničkih podataka.';
$string['check_riskxss_details'] = '<p>RISK_XSS označava sve opasne sposobnosti koje mogu da koriste samo pouzdani korisnici.</p>
<p>Molimo, potvrdite sledeći spisak korisnika na ovom serveru i proverite da li imate poptuno poverenje u njih:</p><p>{$a}</p>';
$string['check_riskxss_name'] = 'XSS pouzdani korisnici';
$string['check_riskxss_warning'] = 'RISK_XSS - pronađeno je {$a} korisnika koji moraju da budu pouzdani.';
$string['check_unsecuredataroot_details'] = '<p>Direktorijum dataroot ne sme biti dostupan preko Weba. Najbolji način da budete sigurni da direktorijum nije dostupan je da koristite onaj koji je izvan javnog Web direktorijuma.</p>
<p>Ako premestite direktorijum, morate da ažurirate <code>$CFG->dataroot</code> podešavanje u <code>config.php</code> datoteci.</p>';
$string['check_unsecuredataroot_error'] = 'Vaš direktorijum za podatke <code>{$a}</code> je na pogrešnoj lokaciji i dostupan je preko veba!';
$string['check_unsecuredataroot_name'] = 'Nebezbedni direktorijum za podatke';
$string['check_unsecuredataroot_ok'] = 'Direktorijum za podatke ne sme biti dostupan preko veba.';
$string['check_unsecuredataroot_warning'] = 'Vaš direktorijum za podatke <code>{$a}</code> je na pogrešnom mestu i može mu se pristupiti putem veba!';
$string['check_vendordir_details'] = '<p>Direktorijum <code>{$a->path}</code> sadrži biblioteke nezavisnog proizvođača i njihove zavisnosti, obično instalirane pomoću PHP Composera. Ove biblioteke mogu biti potrebne za lokalni razvoj Moodlea, kao što je instaliranje PHPUnit okvira. One nisu potrebni za pokretanje Moodlea na produkcionom severu i mogu da sadrže potencijalno opasan kôd i tako izlože vaš sajt udaljenim napadima.</p><p>Preporučuje se da uklonite direktorijum ako je sajt dostupan preko javne URL adrese, ili da barem zabranite veb pristup ovom direktorijumu, u konfiguraciji svog veb servera.</p>';
$string['check_vendordir_info'] = 'Direktorijum <em>vendor</em> ne bi trebalo da bude prisutan na javnim sajtovima.';
$string['check_vendordir_name'] = 'Direktorijum <em>vendor</em>';
$string['check_webcron_details'] = '<p>Pokretanje krona iz veb čitača može da otkrije privilegovane informacije anonimnim korisnicima. Preporučuje se pokretanje krona samo iz komandne linije ili postavljanje kron lozinke za udaljeni pristup.</p>';
$string['check_webcron_name'] = 'Veb kron';
$string['check_webcron_ok'] = 'Anonimni korisnici ne mogu da pristupe kronu.';
$string['check_webcron_warning'] = 'Anonimni korisnici mogu da pristupe kronu.';
$string['configuration'] = 'Konfiguracija';
$string['description'] = 'Opis';
$string['details'] = 'Detaljnije informacije';
$string['eventreportviewed'] = 'Izveštaj o bezbednosnoj proveri prikazan';
$string['issue'] = 'Problem';
$string['pluginname'] = 'Bezbednosne provere';
$string['privacy:metadata'] = 'Dodatak Pregled bezbednosti sistema ne čuva nikakve lične podatke.';
$string['security:view'] = 'Pogledaj izveštaj o bezbednosti';
$string['timewarning'] = 'Obrada podataka može potrajati, molim vas da budete strpljivi';
