<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_oauth2', language 'sr_lt', version '3.9'.
 *
 * @package     tool_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['authconfirm'] = 'Ova akcija će odobriti stalni API pristup Moodleu za ovlašćeni nalog. Namera je da se ovaj nalog koristi kao sistemski za upravljanje datotekama koje su u vlasništvu Moodlea.';
$string['authconnected'] = 'Sistemski nalog je sada povezan za oflajn pristup';
$string['authnotconnected'] = 'Sistemski nalog nije povezan za oflajn pristup';
$string['configured'] = 'Konfigurisano';
$string['configuredstatus'] = 'Konfigurisano';
$string['connectsystemaccount'] = 'Uspostavi vezu sa sistemskim nalogom';
$string['createfromtemplate'] = 'Kreiraj OAuth 2 servis na osnovu šablona';
$string['createfromtemplatedesc'] = 'Izaberite, u nastavku, jedan od šablona OAuth 2 servisa kako biste kreirali OAuth servis sa ispravnom konfiguracijom za jedan od poznatih tipova servisa. To će kreirati OAuth 2 servis, sa svim svim ispravnim krajnjim tačkama i parametrima potrebnim za proveru identiteta. Ipak, moraćete da unesete ID oznaku klijenta i tajni ključ za novi servis, pre nego što on bude mogao da se koristi.';
$string['createnewendpoint'] = 'Kreiraj novu krajnju tačku za davaoca servisa "{$a}"';
$string['createnewfacebookissuer'] = 'Kreiraj novi Facebook servis';
$string['createnewgoogleissuer'] = 'Kreiraj novi Google servis';
$string['createnewissuer'] = 'Kreiraj novi prilagođeni servis';
$string['createnewmicrosoftissuer'] = 'Kreiraj novi Microsoft servis';
$string['createnewnextcloudissuer'] = 'Kreirajte novi Nextcloud servis';
$string['createnewuserfieldmapping'] = 'Kreiraj novo mapiranje korisničkog polja za davaoca identiteta "{$a}"';
$string['deleteconfirm'] = 'Da li ste sigurni da želite da obrišete davaoca identiteta "{$a}"? Svi dodaci koji su povezani sa ovim davaocem prestaće sa radom.';
$string['deleteendpointconfirm'] = 'Da li ste sigurni da želite da obrišete krajnju tačku "{$a->endpoint}" za davaoca identiteta "{$a}"? Svi dodaci koji su povezani sa ovim davaocem prestaće sa radom.';
$string['deleteuserfieldmappingconfirm'] = 'Da li ste sigurni da želite da obrišete mapiranje korisničkog polja za davaoca identiteta "{$a}"?';
$string['discovered'] = 'Servis uspešno pronađen';
$string['discovered_help'] = 'Pronalaženje servisa znači da se krajnje tačke OAuth 2 servisa mogu automatski odredite iz osnovne URL adrese. Nije neophodno da svi servisi budu "pronađeni", ali ako nisu, onda će biti potrebno da se krajnje tačke i informacije o mapiranju korisnika ručno unesu.';
$string['discoverystatus'] = 'Pronalaženje';
$string['editendpoint'] = 'Krajnja tačka "{$a->endpoint}" za davaoca identiteta {$a->issuer}';
$string['editendpoints'] = 'Konfiguriši krajnje tačke';
$string['editissuer'] = 'Uredi davaoca identiteta: {$a}';
$string['edituserfieldmapping'] = 'Uredi mapiranje korisničkog polja za davaoca identiteta {$a}';
$string['edituserfieldmappings'] = 'Konfiguriši mapiranja korisničkog polja';
$string['endpointdeleted'] = 'Krajnja tačka obrisana';
$string['endpointname'] = 'Naziv';
$string['endpointname_help'] = 'Ključ koji se koristi za pretraživanje ove krajnje tačke. Mora da se završava sa "_endpoint".';
$string['endpointsforissuer'] = 'Krajnje tačke za davaoca identiteta: {$a}';
$string['endpointurl'] = 'URL adresa';
$string['endpointurl_help'] = 'URL adresa za ovu krajnju tačku. Mora da koristi https:// protocol.';
$string['issueralloweddomains'] = 'Domeni za prijavu';
$string['issueralloweddomains_help'] = 'Ako je postavljeno, ovo podešavanje je spisak domena, razdvojenih zarezom, na koje će biti ograničena prijava na sistem kada se koristi ovaj davalac.';
$string['issueralloweddomains_link'] = 'OAuth_2_login_domains';
$string['issuerbaseurl'] = 'Osnovna URL adresa servisa';
$string['issuerbaseurl_help'] = 'Osnovna URL adresa koja se koristi za pristup servisu';
$string['issuerclientid'] = 'ID oznaka klijenta';
$string['issuerclientid_help'] = 'ID oznaka OAuth klijenta za ovog davaoca.';
$string['issuerclientsecret'] = 'Klijentski tajni ključ';
$string['issuerclientsecret_help'] = 'OAuth klijentski tajni ključ za ovog davaoca.';
$string['issuerdeleted'] = 'Davalac identiteta obrisan';
$string['issuerdisabled'] = 'Davalac identiteta onemogućen';
$string['issuerenabled'] = 'Davalac identiteta omogućen';
$string['issuerimage'] = 'URL adresa logotipa';
$string['issuerimage_help'] = 'URL adresa slike koja se koristi kao logo za ovog davaoca identiteta. Može biti prikazan na stranici za prijavljivljnje na sistem.';
$string['issuerloginparams'] = 'Dodatni parametri uključeni u zahtev za prijavu na sistem';
$string['issuerloginparams_help'] = 'Neki sistemi traže da u zahtev za prijavu na sistem budu uključeni dodatni parametri kako bi pročitali osnovni profil korisnika.';
$string['issuerloginparamsoffline'] = 'Dodatni parametri uključeni u zahtev za prijavu na sistem za oflajn pristup.';
$string['issuerloginparamsoffline_help'] = 'Svaki OAuth sistem definiše na drugačiji način zahtev za oflajn pristup. Npr. Google zahteva dodatne parametre: "access_type=offline&prompt=consent". Ovi parametri treba da budu u formatu parametara URL upita.';
$string['issuerloginscopes'] = 'Dodatni opsezi važenja uključeni u zahtev za prijavu na sistem.';
$string['issuerloginscopes_help'] = 'Neki sistemi zahtevaju da u zahtev za prijavu na sistem budu uključeni dodatni opsezi važenja kako bi pročitali korisnikov osnovni profil. Standardni opsezi važenja za OpenID Connect kompatibilni sistem su "openid profile email".';
$string['issuerloginscopesoffline'] = 'Dodatni opsezi važenja uključeni u zahtev za prijavu na sistem za oflajn pristup.';
$string['issuerloginscopesoffline_help'] = 'Svaki OAuth sistem definiše na drugačiji način zahtev za oflajn pristup. Npr. Microsoft zahteva dodatni opseg važenja "offline_access".';
$string['issuername'] = 'Naziv';
$string['issuername_help'] = 'Naziv davaoca identiteta. Može biti prikazan na stranici za prijavljivljnje na sistem.';
$string['issuerrequireconfirmation'] = 'Zahtevaj putem e-pošte';
$string['issuerrequireconfirmation_help'] = 'Zahtevajte da svi korisnici potvrde svoje adrese e-pošte pre nego što se mogu prijaviti pomoću OAuth sistema. Ovo se odnosi na novokreirane naloge kao deo procesa prijavljivanja ili kada je postojeći Moodle nalog povezan sa OAuth prijavom putem odgovarajućih e-adresa.';
$string['issuers'] = 'Davaoci identiteta';
$string['issuersetup'] = 'Detaljna uputstva o konfiguraciji opštih OAuth 2 servisa';
$string['issuersetuptype'] = 'Detaljna uputstva o podešavanju {$a} OAuth 2 davaoca';
$string['issuershowonloginpage'] = 'Prikaži na stranici za prijavljivljnje na sistem';
$string['issuershowonloginpage_help'] = 'Ako je dodatak za proveru identiteta OAuth 2 omogućen, ovaj davalac identiteta biće naveden na stranici za prijavljivanje kako bi omogućio korisnicima da se prijave na sistem sa nalogom ovog davaoca identiteta.';
$string['loginissuer'] = 'Dozvoli prijavu na sistem';
$string['notconfigured'] = 'Nije konfigurisano';
$string['notdiscovered'] = 'Pronalaženje servisa nije uspelo';
$string['notloginissuer'] = 'Nemoj dozvoliti prijavu na sistem';
$string['pluginname'] = 'OAuth 2 servisi';
$string['privacy:metadata'] = 'Dodatak OAuth 2 servisi ne čuva nikakve lične podatke.';
$string['savechanges'] = 'Sačuvaj promene';
$string['serviceshelp'] = 'Uputstva za podešavanje davaoca servisa';
$string['systemaccountconnected'] = 'Veza sa sistemskim nalogom uspostavljena';
$string['systemaccountconnected_help'] = 'Sistemski nalozi se koriste za pružanje naprednih funkcionalnosti za dodatke. Oni nisu potrebni samo za prijavu na sistem. Drugi dodaci koji koriste OAuth servis mogu da ponude redukovani skup funkcija ukoliko veza sa sistemskim nalogom nije uspostavljena. Na primer, repozitorijumi ne mogu da podrže "kontrolisane linkove" bez sistemskog naloga, kako bi obavili operacije sa datotekama.';
$string['systemaccountnotconnected'] = 'Veza sa sistemskim nalogom nije uspostavljena';
$string['systemauthstatus'] = 'Veza sa sistemskim nalogom uspostavljena';
$string['usebasicauth'] = 'Zahtevi za tokenima za proveru identiteta putem HTTP zaglavlja';
$string['usebasicauth_help'] = 'Koristite shemu osnovne HTTP provere identiteta prilikom slanja ID oznake i lozinke klijenta sa zahtevom za osvežavanje tokena. Preporučeno prema OAuth 2 standardu, ali možda nije dostupno kod nekih davaoca identiteta.';
$string['userfieldexternalfield'] = 'Naziv eksternog polja';
$string['userfieldexternalfield_error'] = 'Ovo polje ne može da sadrži HTML.';
$string['userfieldexternalfield_help'] = 'Naziv polja koje pruža eksterni OAuth sistem';
$string['userfieldinternalfield'] = 'Naziv internog polja';
$string['userfieldinternalfield_help'] = 'Naziv Moodle korisničkog polja koje treba da bude preslikano iz eksternog polja.';
$string['userfieldmappingdeleted'] = 'Mapiranje korisničkog polja obrisano';
$string['userfieldmappingsforissuer'] = 'Mapiranja korisničkih polja za davaoca identiteta: {$a}';
