<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_tenant', language 'it', version '3.9'.
 *
 * @package     tool_tenant
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accent'] = 'Enfasi';
$string['accent_help'] = 'Il colore utilizzato per indicare l\'elemento attivo nel cassetto.';
$string['activetenants'] = 'Tenant attivi';
$string['addtenant'] = 'Nuovo tenant';
$string['adduser'] = 'Nuovo utente';
$string['admin'] = 'Amministratore';
$string['administrators'] = 'Amministratori';
$string['advanced'] = 'Avanzato';
$string['allocateusers'] = 'Assegna utenti';
$string['archivedtenants'] = 'Tenant archiviati';
$string['archivetenant'] = 'Archivia tenant';
$string['basicinformation'] = 'Informazione di base';
$string['brand'] = 'Barra di navigazione';
$string['brand_help'] = 'Il colore utilizzato nella barra di navigazione superiore';
$string['button'] = 'Pulsanti principali';
$string['button_help'] = 'Il colore dei pulsanti principali';
$string['cachedef_mytenant'] = 'Informazioni sul tenant attuale';
$string['cachedef_tenants'] = 'Elenco dei tenant';
$string['cannotarchivetenant'] = 'None è possibile archiviare il tenant di default';
$string['category'] = 'Categoria di corsi';
$string['category_help'] = 'Agli amministratori del tenant verrà assegnato il ruolo di \'Amministratore del tenant nella categoria di corso\' e potranno creare corsi, assegnare ruoli, eccetera.
A tutti gli utenti del tenant verrà assegnato il ruolo di "Utente del tenant\' in questa categoria.<br><br>Come categoria del tenant è possibile selezionare solamente categorie del livello più alto.<br>
Selezionando \'Nuova categoria\', verrà creata una categoria di corsi con lo stesso nome del tenant.';
$string['categorynameexist'] = 'Esiste già una categoria di nome \'{$a}\' al livello più alto. Per favore selezionare questa categoria oppure cambiare il nome.';
$string['categorytaken'] = 'Questa categoria è assegnata ad un altro tenant';
$string['chooseexistingcategory'] = 'Seleziona una categoria esistente';
$string['colours'] = 'Colori';
$string['confirmallocateusers'] = 'Sei sicuro si assegnare gli utenti selezionati al tenant?';
$string['confirmarchivetenant'] = 'Sei sicuro di archiviare il tenant\'{$a}\'? Tutti gli utenti assegnati a questo tenant saranno spostati nel tenant di default.';
$string['confirmdeletetenant'] = 'Sei sicuro di eliminare il tenant \'{$a}\'? L\'azione non potrà essere annullata.';
$string['confirmdeleteuser'] = 'Sei sicuro di eliminare questo utente? L\'azione non potrà essere annullata.';
$string['confirmdeleteusers'] = 'Sei sicuro di eliminare gli utenti selezionati? L\'azione non potrà essere annullata.';
$string['confirmrestoretenant'] = 'Sei sicuro di ripristinare il tenant \'{$a}\'?';
$string['confirmsuspenduser'] = 'Sei sicuro di sospendere questo utente?';
$string['confirmsuspendusers'] = 'Sei sicuro di sospendere gli utenti selezionati?';
$string['confirmunsuspenduser'] = 'Sei sicuro di riattivare questo utente?';
$string['confirmunsuspendusers'] = 'Sei sicuro di riattivare gli utenti selezionati?';
$string['createnewcategory'] = 'Crea categoria';
$string['customcss'] = 'SCSS Personalizzato';
$string['defaultname'] = 'Tenant di default';
$string['defaulttenantmobileconfig'] = 'Questo è il tenant di default, la sua configurazione sarà utilizzata nell\'app mobile.';
$string['deletetenant'] = 'Elimina tenant';
$string['deleteuser'] = 'Elimina utente';
$string['deleteusers'] = 'Elimina utenti';
$string['drawer'] = 'Cassetto';
$string['drawer_help'] = 'Il colore utilizzato nello sfondo del cassetto di navigazione';
$string['drawertext'] = 'Testo del cassetto';
$string['drawertext_help'] = 'Il colore utilizzato nel cassetto di navigazione dai link e dalle icone quando non sono attivi.';
$string['editdetails'] = 'Modifica dettagli';
$string['editdetailsinsharedspace'] = 'Modifica nello Spazio condiviso';
$string['edittenant'] = 'Modifica tenant \'{$a}\'';
$string['edittenantname'] = 'Modifica nome';
$string['edituser'] = 'Modifica account utente';
$string['edituserwithname'] = 'Modifica utente \'{$a}\'';
$string['enablesharedspace'] = 'Abilita Spazio condiviso';
$string['enrolinseparategroups'] = 'Questo corso potrà essere condiviso con altri tenant. Gli utenti di tenant diversi saranno assegnati a gruppi separati.';
$string['enrolwithoutgroups'] = 'Utenti di altri tenant potranno essere iscritti a questo corso e potranno vedersi tra loro poiché il corso non è impostato a gruppi separati';
$string['errorcannotallocate'] = 'Non è possibile assegnare al tenant';
$string['errorinvalidtenant'] = 'Tenant \'{$a}\' non valido';
$string['eventtenantcreated'] = 'Creazione tenant';
$string['eventtenantdeleted'] = 'Eliminazione tenant';
$string['eventtenantupdated'] = 'Aggiornamento tenant';
$string['eventtenantusercreated'] = 'Assegnazione utente ad un tenant';
$string['eventtenantuserupdated'] = 'Modifica assegnazione utente ad un tenant';
$string['favicon'] = 'Favicon';
$string['footer'] = 'Piè di pagina';
$string['footer_help'] = 'Il colore utilizzato nello sfondo del piè di pagina.';
$string['footertext'] = 'Testo del piè di pagina';
$string['gotosharedspace'] = 'Vai allo Spazio condiviso';
$string['headerlogo'] = 'Logo dell\'intestazione';
$string['idnumber'] = 'Codice identificativo';
$string['idnumber_help'] = 'Il codice identificativo di un tenant verrà utilizzato solamente per corrispondenza con dati di sistemi esterni o nello strumento caricamento utenti e non sarà visualizzato all\'interno del  sito. E\' possibile utilizzare il codice identificativo ufficiale, in mancanza può essere lasciato vuoto.';
$string['images'] = 'Immagini';
$string['invalidcolour'] = 'Il codice del colore non è nel formato corretto. Per favore utilizzare il formato #000 oppure #000000.';
$string['loginbackground'] = 'Immagine di sfondo di login';
$string['loginlogo'] = 'Logo di login';
$string['loginurl'] = 'URL di login';
$string['loginurl_help'] = 'All’amministratore del tenant verranno visualizzate URL selezionate che loro potranno passare ai propri utenti affinché il tema del tenant venga visualizzato immediatamente. Se non viene specificato il \'Codice identificativo\', il link non sarà disponibile anche se selezionato. Da notare che durante la creazione del tenant, l\'id del tenant non è disponibile.';
$string['management'] = 'Gestione';
$string['managetenants'] = 'Gestione tenant';
$string['managetheme'] = 'Personalizzazione tenant';
$string['managethemewpmenu'] = 'Tenant';
$string['migrationcoursecategories'] = 'Categorie di corso, con i gruppi globali e la struttura dei corsi';
$string['migrationcreate'] = 'Crea tenant';
$string['migrationdestinationsummary'] = 'Destinazione: {$a}';
$string['migrationexporterdescription'] = 'Tenant con i relativi elementi';
$string['migrationlogerror'] = 'Non è stato possibile importare il tenant \'{$a}\'';
$string['migrationlogsuccess'] = 'Importato il tenant \'<a href="{$a->url}">{$a->name}</a>\'';
$string['migrationmappingerror'] = 'Alcuni tenant non esistono';
$string['migrationmappingerrorlog'] = 'Non è stato trovato il tenant {$a}';
$string['migrationmerge'] = 'Unisci ad un tenant esistente...';
$string['migrationmerge_help'] = 'Unisce ad un tenant esistetene le informazioni e gli elementi selezionati. Da notare che i dettagli e l\'aspetto, se presenti, saranno sovrascritti.';
$string['migrationmergeselecttenant'] = 'Selezionare il tenant dove unire';
$string['migrationmergetoomany'] = 'Per unire ad in un tenant esistente è possibile selezionare solamente una singola istanza';
$string['migrationselectalltenants'] = 'Seleziona tutti i tenant';
$string['migrationselectexcludingarchived'] = 'Seleziona tutti i tenant (esclusi gli archiviati)';
$string['migrationselectincludingarchived'] = 'Seleziona tutti i tenant (inclusi gli archiviati)';
$string['migrationselectmanually'] = 'Seleziona manualmente i tenant...';
$string['movebetweentenants'] = 'Sposta tra tenant';
$string['movetenant'] = 'Sposta tenant \'{$a}\'';
$string['name'] = 'Nome del tenant';
$string['newname'] = 'Nuovo tenant \'{$a}\'';
$string['newnamefor'] = 'Nome del tenant \'{$a}\'';
$string['nocategory'] = 'Nessuna categoria';
$string['nomanualassignment'] = 'Questo ruolo non può essere assegnato manualmente in nessun contesto';
$string['notnow'] = 'Non adesso';
$string['notspecified'] = 'Non specificato';
$string['organisationadmintab'] = 'Organzzazione';
$string['pluginname'] = 'Multi-tenancy';
$string['primary'] = 'Link';
$string['primary_help'] = 'Il colore utilizzato dai link e dagli elementi interattivi';
$string['privacy:metadata:user'] = 'Assegnazione degli utenti al tenant';
$string['privacy:metadata:user:component'] = 'Componente responsabile dell\'assegnazione';
$string['privacy:metadata:user:id'] = 'ID';
$string['privacy:metadata:user:reason'] = 'Motivo dell\'assegnazione';
$string['privacy:metadata:user:tenantid'] = 'Tenant';
$string['privacy:metadata:user:timecreated'] = 'Ora di assegnazione';
$string['privacy:metadata:user:timemodified'] = 'Ora di modifica';
$string['privacy:metadata:user:userid'] = 'Utente';
$string['privacy:metadata:user:usermodified'] = 'Utente che ha modificato il record';
$string['reg_wptenants'] = 'Numero di tenant ({$a})';
$string['resetappearance'] = 'Resetta aspetto';
$string['resettenantappearance'] = 'Resetta aspetto del tenant';
$string['resettenantappearancecolours'] = 'Resetta tutti i colori personalizzati';
$string['resettenantappearancecss'] = 'Elimina SCSS personalizzato';
$string['resettenantappearancedesc'] = 'Cliccando il pulsante, sarà possibile selezionare gli elementi (immagini, coloro, ecc.) da ripristinare agli standard di accessibilità.';
$string['resettenantappearancefooter'] = 'Elimina testo del piè di pagina';
$string['resettenantappearanceformend'] = 'L\'azione non potrà essere annullata';
$string['resettenantappearanceformintro'] = 'Resetta la configurazione di questo tenant alla configurazione standard accessibile.<br> L\'azione:';
$string['resettenantappearanceimages'] = 'Elimina tutte le immagini caricate (logo, sfondi)';
$string['restoretenant'] = 'Ripristina tenant';
$string['selecttenant'] = 'Seleziona tenant';
$string['selectuser'] = 'Seleziona utente \'{$a}\'';
$string['separatetenantsingroups'] = 'Nei corsi condivisi tra tenant, gli utenti di ciascun tenant vengono aggiunti a gruppi separati.';
$string['sharedspace'] = 'Spazio condiviso';
$string['sharedspaceconfirmationtext'] = 'Lo Spazio condiviso è in luogo dove condividere elementi e contenuti tra tutti i tenant. Qualsiasi cosa creata nello Spazio Condiviso sarà reso immediatamente disponibile a tutti gli utenti di tutti i tenant se dispongono degli opportuni privilegi.<br/> Una volta abilitato lo Spazio condiviso, non sarà più possibile disabilitarlo<br/> Sei sicuro di attivare lo Spazio condiviso?';
$string['sharedspaceenabledmessage'] = 'Lo Spazio condiviso è stato abilitato correttamente. Per accederlo, utilizzare il cambio tenant nella barra di navigazione.';
$string['sitename'] = 'Nome del sito';
$string['siteshortname'] = 'Nome abbreviato del sito';
$string['suspenduser'] = 'Sospendi utente';
$string['suspendusers'] = 'Sospendi utenti';
$string['switchedto'] = 'Se passato al tenant \'{$a}\'';
$string['switchtenant'] = 'Cambia tenant';
$string['tenant'] = 'Tenant';
$string['tenant:allocate'] = 'Assegnare utenti a tutti i tenant';
$string['tenant:browseusers'] = 'Visualizzare utenti del tenant';
$string['tenant:manage'] = 'Gestire l\'aggiunta e la modifica di tenant';
$string['tenant:managetheme'] = 'Gestire le impostazioni del tema del tenant corrente';
$string['tenant:manageusers'] = 'Aggiungere e modificare utenti del tenant corrente';
$string['tenantadmin'] = 'Amministratore del tenant';
$string['tenantadmincapabilitieslimit'] = 'Non sono elencati i privilegi non compatibili con la Multi-tenancy. <a href="{$a}">Maggiori informazioni</a>';
$string['tenantadmindescription'] = 'Il ruolo dell\'amministratore del tenant. Asseganto automaticamente agli amministratori del tenant nel contesto di sistema.';
$string['tenantadministration'] = 'Amministratore del tenant';
$string['tenantadministrator'] = 'Questo utente è un amministratore del tenant';
$string['tenantcategorycapabilitieslimit'] = 'Sono elencati solamente i privilegi impostabili nel contesto della categoria di corsi';
$string['tenantdetails'] = 'Dettagli';
$string['tenantlimit'] = 'Limite di tenant';
$string['tenantlimit1'] = '1 (Multi-tenancy disabilitata)';
$string['tenantlimit_desc'] = 'Il numero massimo di tenant consentiti, sia attivi sia archiviati.';
$string['tenantlimitenabled'] = 'Abilita limite di tenant';
$string['tenantlimitenabled_desc'] = 'Consente di limitare il numero massimo di';
$string['tenantlimitreached'] = 'Raggiunto limite del tenant';
$string['tenantlimitreached1'] = 'La multi-tenancy non è abilitata in questo sito';
$string['tenantlimitreachedmult'] = 'E\' possibile creare solamente {$a} tenant. Da notare che i tenant archiviati sono conteggiati per il calcolo del limite.';
$string['tenantlimitunlimited'] = 'Senza limiti';
$string['tenantmanager'] = 'Amministratore del tenant nella categoria di corsi';
$string['tenantmanagerdescription'] = 'Il ruolo del secondo amministratore del tenant. Assegnato automaticamente all\'amministratore del tenant nel contesto della categoria di corsi.';
$string['tenantnotfound'] = 'Tenant non trovato';
$string['tenants'] = 'Tenants';
$string['tenantuser'] = 'Utente del tenant';
$string['tenantuserdescription'] = 'Il ruolo degli utenti del tenant. Assegnato automaticamente agli utenti del tenant nel contesto della loro categoria di corsi.';
$string['themesettingssaved'] = 'Le impostazioni del tema sono state salvate. Prima che le modifiche siano visibili, devono trascorrere diversi minuti.';
$string['toomanytenantstoshow'] = 'Ci sono troppi tenant da visualizzare';
$string['unsuspenduser'] = 'Riattiva utente';
$string['unsuspendusers'] = 'Riattiva utenti';
$string['userscount'] = 'Utenti';
$string['usersuspendedsuccess'] = 'Utente sospeso correttamente';
$string['userunsuspendedsuccess'] = 'Utente riattivato correttamente';
$string['viewusers'] = 'Gestione tenant \'{$a}\'';
