<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_mobile', language 'cs', version '3.9'.
 *
 * @package     tool_mobile
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adodbdebugwarning'] = 'Ladění ADOdb je povoleno. Mělo by být zakázáno v nastavení externí autentizace databáze nebo v nastavení doplňku zápisu pro externí databázi.';
$string['androidappid'] = 'Jedinečný identifikátor aplikace pro Android';
$string['androidappid_desc'] = 'Pokud máte vlastní aplikaci pro Android, může být toto nastavení ponecháno jako výchozí,.';
$string['apppolicy'] = 'Adresa URL aplikace zásad';
$string['apppolicy_help'] = 'Adresa URL zásad pro uživatele aplikací, která je uvedena na stránce O aplikaci. Pokud pole zůstane prázdné, použije se místo toho URL adresa zásady webu.';
$string['apprequired'] = 'Tato funkce je dostupná pouze při přístupu přes mobilní aplikaci Moodle nebo desktop aplikaci.';
$string['autologinkeygenerationlockout'] = 'Automatické  generování klíčů je blokováno. Mezi žádostmi je třeba počkat 6 minut .';
$string['autologinnotallowedtoadmins'] = 'Automatické přihlášení není povolena pro správce stránek.';
$string['cachedef_plugininfo'] = 'Uloží seznam pluginů s mobilními doplňky';
$string['cachedef_subscriptiondata'] = 'Tím se uloží informace o předplatném aplikace Moodle.';
$string['clickheretolaunchtheapp'] = 'Klikněte sem, pokud se aplikace automaticky neotevře.';
$string['configmobilecssurl'] = 'CSS soubor pro lokální úpravu zobrazování na mobilních zařízeních.';
$string['customlangstrings'] = 'Vlastní jazykové řetězce';
$string['customlangstrings_desc'] = 'Slova a fráze zobrazené v aplikaci lze zde přizpůsobit. Vložte vlastní jazykový řetězec na nový řádek s formátem: identifikátor řetězce, vlastní jazykový řetězec a kód jazyka, oddělené znaky svislítka. Například:
<pre>
mm.user.student|Learner|en
mm.user.student|Aprendiz|es
mm.user.student|Student|cs
</pre>
Úplný seznam identifikátorů textových řetězců a další informace naleznete v dokumentaci.';
$string['custommenuitems'] = 'Položky uživatelské nabídky';
$string['custommenuitems_desc'] = 'Do hlavního menu aplikace mohou být přidány další položky které zadáte zde. Zadejte každou položku vlastní nabídky na novém řádku ve formátu: textová položka, odkaz URL, metoda otevření odkazu  a kód jazyka (volitelné, pro zobrazení položky pro uživatele v stanoveném jazyce), které jsou odděleny znaky svislítka.

Metody otevírání odkazů jsou: app (pro propojení s aktivitou podporovanou aplikací), inappbrowser (pro otevření odkazu v prohlížeči bez opuštění aplikace), prohlížeče (pro otevření odkazu ve výchozím prohlížeči zařízení mimo aplikaci) a vloženého (pro zobrazení odkazu v rámci iframe na nové stránce v aplikaci).

Pokud některým položkám chybí překlad pro daný jazyk, použijí jako záložku jiné jazyky, pokud k jazykovému kódu nebude připojeno  "_only".

Například:
<pre>
App help | https://someurl.xyz/help | inappbrowser | en
Visit our SIS | https://someurl.xyz | browser | en
My grades | https://someurl.xyz/local/mygrades/index.php | embedded | en
Moje známky pouze Česky | https://someurl.xyz/local/mygrades/index.php | embedded | cs_only
</pre>';
$string['darkmode'] = 'Temný režim';
$string['disabledfeatures'] = 'Zakázané funkce';
$string['disabledfeatures_desc'] = 'Zde vyberte funkce, které chcete zakázat pro vaše stránky v mobilní aplikaci. Upozorňujeme, že některé zde uvedené funkce, by mohly být již zakázány prostřednictvím dalších nastavení webu. Budete muset odhlásit a znovu přihlásit v aplikaci, abyste změny viděli.';
$string['displayerrorswarning'] = 'Je povoleno zobrazovat zprávy o ladění (debugdisplay). Mělo by být zakázáno.';
$string['downloadcourse'] = 'Stáhnout kurz';
$string['downloadcourses'] = 'Stáhnout kurzy';
$string['enablesmartappbanners'] = 'Povolit App Banners';
$string['enablesmartappbanners_desc'] = 'Je-li povoleno, zobrazí se při návštěvě webu v mobilním prohlížeči nápis propagující Moodle mobilní aplikaci.';
$string['forcedurlscheme'] = 'Pokud chcete povolit, aby se v okně prohlížeče otevíralo pouze vaše vlastní značkové aplikace, zadejte zde jeho schéma adres URL. Pokud chcete povolit pouze oficiální aplikaci, nastavte výchozí hodnotu. Pokud chcete některou aplikaci povolit, ponechte pole prázdné.';
$string['forcedurlscheme_key'] = 'URL schéma';
$string['forcelogout'] = 'Vynucené odhlášení';
$string['forcelogout_desc'] = 'Je-li povoleno, volba "Změnit stránky" je nahrazena slovem "Odhlásit". To má za následek, že uživatel je zcela odhlášen. Musí při příštím přístupu na web zadat znovu své heslo.';
$string['getmoodleonyourmobile'] = 'Stáhněte si mobilní aplikaci';
$string['h5poffline'] = 'Zobrazit obsah H5P offline';
$string['httpsrequired'] = 'Požadováno HTTPS';
$string['insecurealgorithmwarning'] = 'Zdá se, že certifikát HTTPS používá nezabezpečený algoritmus pro podepisování (SHA-1). Zkuste aktualizovat certifikát.';
$string['invalidcertificatechainwarning'] = 'Zdá se, že řetězec certifikátů je neplatný.';
$string['invalidcertificateexpiredatewarning'] = 'Zdá se, že certifikát HTTPS pro web vypršel.';
$string['invalidcertificatestartdatewarning'] = 'Zdá se, že certifikát HTTPS pro web ještě není platný (budoucí datum zahájení platnosti).';
$string['invalidprivatetoken'] = 'Neplatný soukromý token. Token by neměl být prázdný nebo prošel přes parametr GET.';
$string['invaliduserquotawarning'] = 'Uživatelská kvóta (userquota) je nastavena na neplatné číslo. Měla by být nastavena na stránce Nastavení zabezpečení stránek na platné číslo (celočíselná hodnota).';
$string['iosappid'] = 'Unikátní identifikátor iOS aplikace';
$string['iosappid_desc'] = 'Pokud máte vlastní iOS aplikaci, toto nastavení může být ponecháno jako výchozí.';
$string['loginintheapp'] = 'Prostřednictvím aplikace';
$string['logininthebrowser'] = 'Přes okno prohlížeče (pro doplněk SSO)';
$string['loginintheembeddedbrowser'] = 'Přes vložený prohlížeč (pro doplněk SSO)';
$string['mainmenu'] = 'Hlavní nabídka';
$string['minimumversion'] = 'Pokud je zadána verze aplikace (3.8.0 nebo vyšší), budou všichni uživatelé používající starší verzi aplikace vyzváni, aby upgradovali svou aplikaci, než jim bude povolen přístup na stránky.';
$string['minimumversion_key'] = 'Je požadována minimální verze aplikace';
$string['mobileapp'] = 'Mobile app';
$string['mobileappconnected'] = 'Připojena mobilní aplikace';
$string['mobileappearance'] = 'Mobilní vzhled';
$string['mobileappenabled'] = 'Na tomto webu je povolen přístup k mobilním aplikacím. <br /><a href="{$a}">Stáhnout mobilní aplikaci</a>.';
$string['mobileappsubscription'] = 'Předplatné aplikace Moodle';
$string['mobileauthentication'] = 'Mobilní autentizace';
$string['mobilecssurl'] = 'CSS';
$string['mobilefeatures'] = 'Mobilní funkce';
$string['mobilenotificationsdisabledwarning'] = 'Nejsou povolena mobilní oznámení. Měla by být povolena na stránce Nastavení oznámení.';
$string['mobilesettings'] = 'Mobilní nastavení';
$string['moodleappsportalfeatureswarning'] = 'Upozorňujeme, že některé funkce mohou být omezeny v závislosti na předplatném aplikace Moodle. Podrobnosti naleznete na <a href="{$a}" target="_blank"> Portálu Moodle Apps </a>.';
$string['notifications'] = 'Oznámení';
$string['notificationsactivedevices'] = 'Aktivní zařízení';
$string['notificationscurrentactivedevices'] = 'Zařízení, která tento měsíc dostávají oznámení';
$string['notificationsignorednotifications'] = 'Oznámení nebyla odeslána';
$string['notificationslimitreached'] = 'Byl překročen měsíční limit aktivních uživatelských zařízení. Pro některé uživatele nebudou zasílána oznámení. Doporučujeme upgradovat plán aplikace na webu <a href="{$a}" target="_blank">Moodle Apps Portal</a>.';
$string['notificationsmissingwarning'] = 'Statistiky oznámení aplikace Moodle nelze načíst. Je to pravděpodobně proto, že mobilní oznámení na webu zatím nejsou povolena. Můžete je povolit ve Správa stránek /  Zprávy / Nastavení zpráv.';
$string['notificationsnewdevices'] = 'Nová zařízení';
$string['notificationsseemore'] = 'Poznámka: Statistiky využití aplikace Moodle nejsou počítány v reálném čase. Chcete-li získat podrobnější statistiky, včetně údajů z předchozích měsíců, přihlaste se prosím na <a href="{$a}" target="_blank">Moodle Apps Portal</a>.';
$string['notificationssentnotifications'] = 'Oznámení byla odeslána';
$string['oauth2identityproviders'] = 'Poskytovatelé identity OAuth 2';
$string['offlineuse'] = 'Používat offline';
$string['openusingembeddedbrowser'] = 'Otevřít pomocí integrovaného prohlížeče';
$string['pluginname'] = 'Nástroje Moodle aplikace';
$string['pluginnotenabledorconfigured'] = 'Doplněk není povolen nebo nakonfigurován.';
$string['privacy:metadata:core_userkey'] = 'Uživatelské klíče slouží k vytvoření klíče pro automatické přihlášení aktuálního uživatele.';
$string['privacy:metadata:preference:tool_mobile_autologin_request_last'] = 'Datum posledního požadavku na automatické přihlášení. Mezi každou žádostí se vyžaduje 6 minut.';
$string['qrcodedisabled'] = 'Přístup přes QR kód je zakázán';
$string['qrcodeformobileappaccess'] = 'QR kód pro přístup k mobilní aplikaci';
$string['qrcodeformobileapploginabout'] = 'Naskenujte QR kód pomocí své mobilní aplikace a budete automaticky přihlášeni. Platnost QR kódu vyprší za {$a} minut.';
$string['qrcodeformobileappurlabout'] = 'Naskenujte QR kód pomocí své mobilní aplikace a vyplňte adresu URL své aplikace.';
$string['qrcodetype'] = 'QR přístupový kód';
$string['qrcodetype_desc'] = 'Uživatelům mobilních aplikací může být poskytnut QR kód ke skenování. To lze použít k vyplnění adresy URL webu nebo tam, kde je web zabezpečen pomocí protokolu HTTPS, k automatickému přihlášení uživatele bez nutnosti zadávat jeho uživatelské jméno a heslo.';
$string['qrcodetypelogin'] = 'QR kód s automatickým přihlášením';
$string['qrcodetypeurl'] = 'QR kód s URL stránky';
$string['qrsiteadminsnotallowed'] = 'Z bezpečnostních důvodů není přihlášení přes QR kód povoleno pro administrátory stránek nebo pokud jste přihlášeni jako jiný uživatel.';
$string['readingthisemailgettheapp'] = 'Čtěte to ve svém e-mailu? <a href="{$a}">Stáhněte si mobilní aplikaci a přijímejte upozornění na svých mobilních zařízeních</a>.';
$string['remoteaddons'] = 'Vzdálené doplňky';
$string['responsivemainmenuitems'] = 'Responsivní položky nabídky';
$string['scanqrcode'] = 'Naskenovat QR kód';
$string['selfsignedoruntrustedcertificatewarning'] = 'Zdá se, že certifikát HTTPS je podepsán sám sebou nebo není důvěryhodný. Mobilní aplikace bude pracovat pouze s důvěryhodnými stránkami.';
$string['setuplink'] = 'Stránka ke stažení aplikace';
$string['setuplink_desc'] = 'Adresa URL stránky s odkazy ke stažení mobilní aplikace z App Store a Google Play. Odkaz na stránku pro stažení aplikace se zobrazí v zápatí stránky a v profilu uživatele.  Aby se nezobrazil odkaz, nechte prázdné.';
$string['smartappbanners'] = 'App Banners';
$string['subscription'] = 'Předplatné';
$string['subscriptioncreated'] = 'Datum zahájení';
$string['subscriptionerrorrequest'] = 'Při pokusu o načtení informací o předplatném aplikace Moodle došlo k neočekávané chybě.';
$string['subscriptionexpiration'] = 'Datum vypršení platnosti';
$string['subscriptionfeaturenotapplied'] = 'Tato funkce je nakonfigurována na vašem webu, ale není zahrnuta v plánu aplikace Moodle. Nastavení tedy nebude mít žádný účinek.';
$string['subscriptionfeatures'] = 'Vlastnosti předplatného';
$string['subscriptionlimitsurpassed'] = 'Limit předplatného byl překročen';
$string['subscriptionregister'] = 'Podrobnosti o různých aplikačních plánech a přístupu ke statistikám využití aplikací Moodle najdete na webu <a href="{$a}" target="_blank">Moodle Apps Portal</a>.';
$string['subscriptionsseemore'] = 'Poznámka: Zobrazené informace nejsou aktualizovány v reálném čase. Možná se budete muset odhlásit a znovu přihlásit, abyste mohli zobrazit aktualizace. Chcete-li získat informace o upgradu plánu aplikace, přihlaste se prosím na <a href="{$a}" target="_blank">Moodle Apps Portal</a>.';
$string['typeoflogin'] = 'Typ přihlášení';
$string['typeoflogin_desc'] = 'V případě, že web používá metodu ověřování SSO, vyberte pomocí okna prohlížeče nebo vestavěným prohlížečem. Vložený prohlížeč poskytuje lepší uživatelskou zkušenost, i když to nebude fungovat se všemi  doplňky SSO.';
$string['viewqrcode'] = 'Zobrazit QR kód';
