<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'ja', version '3.9'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = '連絡先';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'アンカーを挿入/編集する';
$string['advanced:backcolor_desc'] = '背景色を選択する';
$string['advanced:block'] = 'フォーマット';
$string['advanced:blockquote'] = '引用';
$string['advanced:blockquote_desc'] = '引用';
$string['advanced:bold_desc'] = '太字 (Ctrl+B)';
$string['advanced:bullist_desc'] = '番号なしリストを挿入/削除する';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = '特殊文字を挿入する';
$string['advanced:cleanup_desc'] = 'コード整形';
$string['advanced:clipboard_msg'] = 'コピー/切り取り/貼り付けはMozillaおよびFirefoxでは使用できません。この件に関して詳細情報を閲覧しますか?';
$string['advanced:code'] = 'コード';
$string['advanced:code_desc'] = 'HTMLソースを編集する';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'コピー';
$string['advanced:custom1_desc'] = 'あなたのカスタム説明をここに入力してください。';
$string['advanced:cut_desc'] = '切り取り';
$string['advanced:dd'] = '語句説明';
$string['advanced:div'] = 'DIV';
$string['advanced:dt'] = '語句定義';
$string['advanced:font_size'] = 'フォントサイズ';
$string['advanced:fontdefault'] = 'フォントファミリ';
$string['advanced:forecolor_desc'] = '文字色を選択する';
$string['advanced:h1'] = '見出し1';
$string['advanced:h2'] = '見出し2';
$string['advanced:h3'] = '見出し3';
$string['advanced:h4'] = '見出し4';
$string['advanced:h5'] = '見出し5';
$string['advanced:h6'] = '見出し6';
$string['advanced:help_desc'] = 'ヘルプ';
$string['advanced:help_shortcut'] = 'ツールバーを表示するには「ALT-F10」、ヘルプを表示するには「ALT-0」を押してください。';
$string['advanced:hr_desc'] = '水平線を挿入する';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'イメージを挿入/編集する';
$string['advanced:image_props_desc'] = 'イメージプロパティ';
$string['advanced:indent_desc'] = 'インデントを増やす';
$string['advanced:italic_desc'] = '斜体 (Ctrl+I)';
$string['advanced:justifycenter_desc'] = '中央揃え';
$string['advanced:justifyfull_desc'] = '均等割付';
$string['advanced:justifyleft_desc'] = '左揃え';
$string['advanced:justifyright_desc'] = '右揃え';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'リンクを挿入/編集する';
$string['advanced:more_colors'] = '色をさらに ...';
$string['advanced:newdocument'] = '本当にコンテンツすべてをクリアしてもよろしいですか?';
$string['advanced:newdocument_desc'] = '新しいドキュメント';
$string['advanced:numlist_desc'] = '番号付きリストを挿入/削除する';
$string['advanced:outdent_desc'] = 'インデントを減らす';
$string['advanced:paragraph'] = '段落';
$string['advanced:paste_desc'] = '貼り付け';
$string['advanced:path'] = 'パス';
$string['advanced:pre'] = '整形済み';
$string['advanced:redo_desc'] = 'やり直す (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'フォーマットを解除する';
$string['advanced:rich_text_area'] = 'リッチテキストエリア';
$string['advanced:samp'] = 'コードサンプル';
$string['advanced:shortcuts_desc'] = 'アクセシビリティヘルプ';
$string['advanced:striketrough_desc'] = '打ち消し線';
$string['advanced:style_select'] = 'スタイル';
$string['advanced:sub_desc'] = '下付き';
$string['advanced:sup_desc'] = '上付き';
$string['advanced:toolbar'] = 'ツールバー';
$string['advanced:toolbar_focus'] = 'ツールボタンへジャンプする - 「Alt+Q」、エディタにジャンプする - 「Alt-Z」、エレメントパスにジャンプする - 「Alt-X」';
$string['advanced:underline_desc'] = '下線 (Ctrl+U)';
$string['advanced:undo_desc'] = '元に戻す (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'リンク解除';
$string['advanced:visualaid_desc'] = 'ガイドライン/非表示エレメントを表示/非表示にする';
$string['advanced_dlg:'] = '&nbsp;';
$string['advanced_dlg:about_author'] = '作者';
$string['advanced_dlg:about_general'] = '詳細';
$string['advanced_dlg:about_help'] = 'ヘルプ';
$string['advanced_dlg:about_license'] = 'ライセンス';
$string['advanced_dlg:about_loaded'] = '読み込みプラグイン';
$string['advanced_dlg:about_plugin'] = 'プラグイン';
$string['advanced_dlg:about_plugins'] = 'プラグイン';
$string['advanced_dlg:about_title'] = 'TinyMCEについて';
$string['advanced_dlg:about_version'] = 'バージョン';
$string['advanced_dlg:accessibility_help'] = 'アクセシビリティヘルプ';
$string['advanced_dlg:accessibility_usage_title'] = '一般使用';
$string['advanced_dlg:anchor_invalid'] = '有効なアンカー名を指定してください。';
$string['advanced_dlg:anchor_name'] = 'アンカー名';
$string['advanced_dlg:anchor_title'] = 'アンカーを挿入/編集する';
$string['advanced_dlg:charmap_title'] = '特殊文字を選択する';
$string['advanced_dlg:charmap_usage'] = 'ナビゲーションに左右の矢印を使用します。';
$string['advanced_dlg:code_title'] = 'HTMLソースエディタ';
$string['advanced_dlg:code_wordwrap'] = 'ワードラップ';
$string['advanced_dlg:colorpicker_color'] = '色:';
$string['advanced_dlg:colorpicker_name'] = '名称:';
$string['advanced_dlg:colorpicker_named_tab'] = '既定色';
$string['advanced_dlg:colorpicker_named_title'] = '既定色';
$string['advanced_dlg:colorpicker_palette_tab'] = 'パレット';
$string['advanced_dlg:colorpicker_palette_title'] = 'パレット色';
$string['advanced_dlg:colorpicker_picker_tab'] = 'ピッカ';
$string['advanced_dlg:colorpicker_picker_title'] = 'カラーピッカ';
$string['advanced_dlg:colorpicker_title'] = '色を選択する';
$string['advanced_dlg:image_align'] = 'アラインメント';
$string['advanced_dlg:image_align_baseline'] = 'ベースライン';
$string['advanced_dlg:image_align_bottom'] = '下揃え';
$string['advanced_dlg:image_align_left'] = '左寄せ';
$string['advanced_dlg:image_align_middle'] = '中央揃え';
$string['advanced_dlg:image_align_right'] = '右寄せ';
$string['advanced_dlg:image_align_textbottom'] = 'テキスト下端';
$string['advanced_dlg:image_align_texttop'] = 'テキスト上端';
$string['advanced_dlg:image_align_top'] = '上端揃え';
$string['advanced_dlg:image_alt'] = 'イメージ説明';
$string['advanced_dlg:image_border'] = '枠線';
$string['advanced_dlg:image_dimensions'] = 'サイズ';
$string['advanced_dlg:image_hspace'] = '水平方向の余白';
$string['advanced_dlg:image_list'] = 'イメージリスト';
$string['advanced_dlg:image_src'] = 'イメージURL';
$string['advanced_dlg:image_title'] = 'イメージを挿入/編集する';
$string['advanced_dlg:image_vspace'] = '垂直方向の余白';
$string['advanced_dlg:invalid_color_value'] = '無効なカラー値です。';
$string['advanced_dlg:link_is_email'] = 'あなたが入力したURLはメールアドレスのようです。必須の「mailto:」接頭辞を付加しますか?';
$string['advanced_dlg:link_is_external'] = 'あなたが入力したURLは外部リンクのようです。必須の「http://」接頭辞を付加しますか?';
$string['advanced_dlg:link_list'] = 'リンクリスト';
$string['advanced_dlg:link_target'] = 'ターゲット';
$string['advanced_dlg:link_target_blank'] = 'リンクを新しいウィンドウで開く';
$string['advanced_dlg:link_target_same'] = 'リンクを同じウィンドウで開く';
$string['advanced_dlg:link_title'] = 'リンクを挿入/編集する';
$string['advanced_dlg:link_titlefield'] = 'タイトル';
$string['advanced_dlg:link_url'] = 'リンクURL';
$string['advhr:advhr_desc'] = '水平線を挿入する';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'ノーマル';
$string['advhr_dlg:noshade'] = '影なし';
$string['advhr_dlg:size'] = '高さ';
$string['advhr_dlg:width'] = '幅';
$string['advhr_dlg:widthunits'] = '単位';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'イメージを挿入/編集する';
$string['advimage_dlg:align'] = 'アラインメント';
$string['advimage_dlg:align_baseline'] = 'ベースライン';
$string['advimage_dlg:align_bottom'] = '下端揃え';
$string['advimage_dlg:align_left'] = '左寄せ';
$string['advimage_dlg:align_middle'] = '中央揃え';
$string['advimage_dlg:align_right'] = '右寄せ';
$string['advimage_dlg:align_textbottom'] = 'テキスト下端';
$string['advimage_dlg:align_texttop'] = 'テキスト上端';
$string['advimage_dlg:align_top'] = '上端揃え';
$string['advimage_dlg:alt'] = 'イメージ説明';
$string['advimage_dlg:alt_image'] = '代替イメージ';
$string['advimage_dlg:border'] = '枠線';
$string['advimage_dlg:classes'] = 'クラス';
$string['advimage_dlg:constrain_proportions'] = '縦横比を固定する';
$string['advimage_dlg:dialog_title'] = 'イメージを挿入/編集する';
$string['advimage_dlg:dimensions'] = 'サイズ';
$string['advimage_dlg:example_img'] = 'アピアランスプレビューイメージ';
$string['advimage_dlg:general'] = '一般';
$string['advimage_dlg:height'] = '高さ';
$string['advimage_dlg:hspace'] = '水平方向の余白';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'イメージリスト';
$string['advimage_dlg:langcode'] = '言語コード';
$string['advimage_dlg:langdir'] = '言語の方向';
$string['advimage_dlg:list'] = 'イメージリスト';
$string['advimage_dlg:long_desc'] = '詳細説明リンク';
$string['advimage_dlg:ltr'] = '左から右';
$string['advimage_dlg:map'] = 'イメージマップ';
$string['advimage_dlg:misc'] = 'その他';
$string['advimage_dlg:missing_alt'] = '本当にイメージ説明なしで続けてもよろしいですか? イメージ説明がない場合、障害のあるユーザ、テキストブラウザを使用しているユーザ、イメージ表示を無効にしているユーザがアクセスできないことがあります。';
$string['advimage_dlg:mouseout'] = 'マウスアウト時';
$string['advimage_dlg:mouseover'] = 'マウスオーバー時';
$string['advimage_dlg:preview'] = 'プレビュー';
$string['advimage_dlg:rtl'] = '右から左';
$string['advimage_dlg:src'] = 'イメージURL';
$string['advimage_dlg:style'] = 'スタイル';
$string['advimage_dlg:swap_image'] = 'スワップイメージ';
$string['advimage_dlg:tab_advanced'] = '高度な設定';
$string['advimage_dlg:tab_appearance'] = '表示';
$string['advimage_dlg:tab_general'] = '一般';
$string['advimage_dlg:title'] = 'タイトル';
$string['advimage_dlg:vspace'] = '垂直方向の余白';
$string['advimage_dlg:width'] = '幅';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'リンクを挿入/編集する';
$string['advlink_dlg:accesskey'] = 'アクセスキー';
$string['advlink_dlg:advanced_props'] = '高度なプロパティ';
$string['advlink_dlg:advanced_tab'] = '高度な設定';
$string['advlink_dlg:anchor_names'] = 'アンカー';
$string['advlink_dlg:classes'] = 'クラス';
$string['advlink_dlg:encoding'] = 'ターゲット文字エンコーディング';
$string['advlink_dlg:event_props'] = 'イベント';
$string['advlink_dlg:events_tab'] = 'イベント';
$string['advlink_dlg:general_props'] = '一般プロパティ';
$string['advlink_dlg:general_tab'] = '一般';
$string['advlink_dlg:height'] = '高さ';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'あなたが入力したURLはメールアドレスのようです。必須の「mailto:」接頭辞を付加しますか？';
$string['advlink_dlg:is_external'] = 'あなたが入力したURLは外部リンクのようです。必須の「http://」接頭辞を付加しますか？';
$string['advlink_dlg:langcode'] = '言語コード';
$string['advlink_dlg:langdir'] = '言語の方向';
$string['advlink_dlg:link_list'] = 'リンクリスト';
$string['advlink_dlg:list'] = 'リンクリスト';
$string['advlink_dlg:ltr'] = '左から右';
$string['advlink_dlg:mime'] = 'ターゲットのMIMEタイプ';
$string['advlink_dlg:popup'] = 'JavaScriptポップアップ';
$string['advlink_dlg:popup_dependent'] = 'Dependent (Mozilla/Firefoxのみ)';
$string['advlink_dlg:popup_location'] = 'ロケーションバーを表示する';
$string['advlink_dlg:popup_menubar'] = 'メニューバーを表示する';
$string['advlink_dlg:popup_name'] = 'ウィンドウ名';
$string['advlink_dlg:popup_opts'] = 'オプション';
$string['advlink_dlg:popup_position'] = '位置 (X/Y)';
$string['advlink_dlg:popup_props'] = 'ポップアッププロパティ';
$string['advlink_dlg:popup_resizable'] = 'ウィンドウのサイズ変更を許可する';
$string['advlink_dlg:popup_return'] = '「return false」を挿入する';
$string['advlink_dlg:popup_scrollbars'] = 'スクロールバーを表示する';
$string['advlink_dlg:popup_size'] = 'サイズ';
$string['advlink_dlg:popup_statusbar'] = 'ステータスバーを表示する';
$string['advlink_dlg:popup_tab'] = 'ポップアップ';
$string['advlink_dlg:popup_toolbar'] = 'ツールバーを表示する';
$string['advlink_dlg:popup_url'] = 'ポップアップURL';
$string['advlink_dlg:rel'] = 'ページのターゲットに対する関係';
$string['advlink_dlg:rev'] = 'ターゲットのページに対する関係';
$string['advlink_dlg:rtl'] = '右から左';
$string['advlink_dlg:style'] = 'スタイル';
$string['advlink_dlg:tabindex'] = 'タブインデックス';
$string['advlink_dlg:target'] = 'ターゲット';
$string['advlink_dlg:target_blank'] = '新しいウィンドウで開く';
$string['advlink_dlg:target_langcode'] = 'ターゲット言語';
$string['advlink_dlg:target_name'] = 'ターゲット名';
$string['advlink_dlg:target_parent'] = '親ウィンドウ/フレームで開く';
$string['advlink_dlg:target_same'] = 'このウィンドウ/フレームで開く';
$string['advlink_dlg:target_top'] = 'トップのフレームで開く (すべてのフレームを置換する)';
$string['advlink_dlg:title'] = 'リンクを挿入/編集する';
$string['advlink_dlg:titlefield'] = 'タイトル';
$string['advlink_dlg:url'] = 'リンクURL';
$string['advlink_dlg:width'] = '幅';
$string['advlist:circle'] = '白丸';
$string['advlist:def'] = 'デフォルト';
$string['advlist:disc'] = '黒丸';
$string['advlist:lower_alpha'] = '小文字のアルファベット';
$string['advlist:lower_greek'] = '小文字のギリシャ文字';
$string['advlist:lower_roman'] = '小文字のローマ文字';
$string['advlist:square'] = '四角';
$string['advlist:types'] = 'タイプ';
$string['advlist:upper_alpha'] = '大文字のアルファベット';
$string['advlist:upper_roman'] = '大文字のローマ文字';
$string['aria:rich_text_area'] = 'リッチテキストエリア';
$string['autosave:restore_content'] = 'オートセーブコンテンツをリストアします。';
$string['autosave:unload_msg'] = 'このページから移動した場合、あなたの編集内容は破棄されます。';
$string['autosave:warning_message'] = '保存されたコンテンツをリストアした場合、あなたはエディタ内の現在のコンテンツすべてを失うことになります。

本当に保存されたコンテンツをリストアしてもよろしいですか?';
$string['availablebuttons'] = '利用可能なボタン';
$string['colors:000000'] = '黒';
$string['colors:000080'] = 'ネイビーブルー';
$string['colors:0000FF'] = '青';
$string['colors:003300'] = 'ダークグリーン';
$string['colors:003366'] = 'ダークアズール';
$string['colors:008000'] = 'グリーン';
$string['colors:008080'] = 'ティール';
$string['colors:00CCFF'] = 'スカイブルー';
$string['colors:00FF00'] = 'ライム';
$string['colors:00FFFF'] = 'アクア';
$string['colors:333300'] = 'ダークオリーブ';
$string['colors:333333'] = '濃いダークグレー';
$string['colors:333399'] = 'インディゴ';
$string['colors:3366FF'] = 'ロイヤルブルー';
$string['colors:339966'] = 'シーグリーン';
$string['colors:33CCCC'] = 'ターコイズ';
$string['colors:666699'] = '納戸色';
$string['colors:800000'] = 'マルーン';
$string['colors:800080'] = 'パープル';
$string['colors:808000'] = 'オリーブ';
$string['colors:808080'] = 'グレー';
$string['colors:993300'] = 'バーントオレンジ';
$string['colors:993366'] = 'ブラウン';
$string['colors:999999'] = 'ミディアムグレー';
$string['colors:99CC00'] = 'イエローグリーン';
$string['colors:99CCFF'] = 'ライトスカイブルー';
$string['colors:C0C0C0'] = 'シルバー';
$string['colors:CC99FF'] = 'プラム';
$string['colors:CCFFCC'] = 'ペールグリーン';
$string['colors:CCFFFF'] = 'ペールシアン';
$string['colors:FF0000'] = '赤';
$string['colors:FF00FF'] = 'マゼンタ';
$string['colors:FF6600'] = 'オレンジ';
$string['colors:FF9900'] = 'アンバー';
$string['colors:FF99CC'] = 'ピンク';
$string['colors:FFCC00'] = 'ゴールド';
$string['colors:FFCC99'] = 'ピーチ';
$string['colors:FFFF00'] = '黄色';
$string['colors:FFFF99'] = 'ライトイエロー';
$string['colors:FFFFFF'] = '白';
$string['common:apply'] = '適用';
$string['common:browse'] = '参照';
$string['common:cancel'] = 'キャンセル';
$string['common:class_name'] = 'クラス';
$string['common:clipboard_msg'] = 'コピー/切り取り/貼り付けはFirefoxおよびMozillaでは使用できません。この件に関してさらに情報が必要ですか?';
$string['common:clipboard_no_support'] = '現在、あなたのブラウザでは対応されていません。代わりにキーボードのショートカットキーをお使いください。';
$string['common:close'] = '閉じる';
$string['common:edit_confirm'] = 'このテキストエリアをWYSIWYGモードに切り替えますか?';
$string['common:insert'] = '挿入';
$string['common:invalid_data'] = 'エラー: 入力に誤りがあります (赤字の項目)。';
$string['common:invalid_data_min'] = '{#field} は {#min} より大きな数字である必要があります。';
$string['common:invalid_data_number'] = '{#field} は数字である必要があります。';
$string['common:invalid_data_size'] = '{#field} は数字またはパーセンテージである必要があります。';
$string['common:more_colors'] = '色をさらに ...';
$string['common:not_set'] = '-- 未設定 --';
$string['common:popup_blocked'] = '申し訳ございません、あなたのポップアップブロッカがアプリケーション機能を提供するためのウィンドウを無効にしました。このサイトでこのツールを完全に使用するにはあなたはポップアップブロッキングを無効にする必要があります。';
$string['common:update'] = '更新';
$string['common:value'] = '(値)';
$string['contextmenu:align'] = 'アラインメント';
$string['contextmenu:center'] = '中央揃え';
$string['contextmenu:full'] = '均等割付';
$string['contextmenu:left'] = '左揃え';
$string['contextmenu:right'] = '右揃え';
$string['customconfig'] = 'カスタム設定';
$string['customconfig_desc'] = 'JSONフォーマットにおけるTinyMCEの高度なカスタム設定です。例えば次のようになります: {"option1" : "value2", "option2" : "value2"}。ここで指定されたオプションは標準およびプラグイン設定をオーバーライドします。';
$string['customtoolbar'] = 'エディタツールバー';
$string['customtoolbar_desc'] = 'それぞれの行にはカンマで区切られたボタン名一覧を含みます。グループのセパレータにはラップ (wrap) を使用してください。空白行は無視されます。デフォルトのTinyMCEのボタンに関して<a href="{$a}" target="_blank">{$a}</a>をご覧ください。<br />2番目および3番目のツールバーの可視性は切り替え可能であるのに対して最初の行は常に表示されます。';
$string['directionality:ltr_desc'] = '左から右';
$string['directionality:rtl_desc'] = '右から左';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'エモーション';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'Cry';
$string['emotions_dlg:desc'] = 'エモーション';
$string['emotions_dlg:embarassed'] = 'Embarassed';
$string['emotions_dlg:foot_in_mouth'] = 'Foot in mouth';
$string['emotions_dlg:frown'] = 'Frown';
$string['emotions_dlg:innocent'] = 'Innocent';
$string['emotions_dlg:kiss'] = 'Kiss';
$string['emotions_dlg:laughing'] = 'Laughing';
$string['emotions_dlg:money_mouth'] = 'Money mouth';
$string['emotions_dlg:sealed'] = 'Sealed';
$string['emotions_dlg:smile'] = 'Smile';
$string['emotions_dlg:surprised'] = 'Surprised';
$string['emotions_dlg:title'] = 'エモーションを挿入する';
$string['emotions_dlg:tongue_out'] = 'Tongue out';
$string['emotions_dlg:undecided'] = 'Undecided';
$string['emotions_dlg:usage'] = 'ナビゲートに左および右矢印を使用します。';
$string['emotions_dlg:wink'] = 'Wink';
$string['emotions_dlg:yell'] = 'Yell';
$string['fontselectlist'] = '利用可能なフォント一覧';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'ドキュメントプロパティ';
$string['fullpage_dlg:active_color'] = 'アクティブ色';
$string['fullpage_dlg:add'] = '新しいエレメントを追加する';
$string['fullpage_dlg:add_base'] = 'Base要素';
$string['fullpage_dlg:add_comment'] = 'Commentノード';
$string['fullpage_dlg:add_link'] = 'Link要素';
$string['fullpage_dlg:add_meta'] = 'Meta要素';
$string['fullpage_dlg:add_script'] = 'Script要素';
$string['fullpage_dlg:add_style'] = 'Style要素';
$string['fullpage_dlg:add_title'] = 'Title要素';
$string['fullpage_dlg:advanced_props'] = '高度な設定';
$string['fullpage_dlg:advanced_tab'] = '高度な設定';
$string['fullpage_dlg:appearance_bgprops'] = '背景プロパティ';
$string['fullpage_dlg:appearance_linkprops'] = 'リンク色';
$string['fullpage_dlg:appearance_marginprops'] = 'Body余白';
$string['fullpage_dlg:appearance_style'] = 'スタイルシートおよびスタイルプロパティ';
$string['fullpage_dlg:appearance_tab'] = 'アピアランス';
$string['fullpage_dlg:appearance_textprops'] = 'テキストプロパティ';
$string['fullpage_dlg:author'] = '作者';
$string['fullpage_dlg:base_element'] = 'Base要素';
$string['fullpage_dlg:bgcolor'] = '背景色';
$string['fullpage_dlg:bgimage'] = '背景イメージ';
$string['fullpage_dlg:bottom_margin'] = '下余白';
$string['fullpage_dlg:charset'] = '文字セット';
$string['fullpage_dlg:comment_element'] = 'コメント';
$string['fullpage_dlg:content'] = 'コンテンツ';
$string['fullpage_dlg:copyright'] = '著作権';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'DOCTYPE';
$string['fullpage_dlg:encoding'] = '文字エンコーディング';
$string['fullpage_dlg:font_face'] = 'フォントフェイス';
$string['fullpage_dlg:font_size'] = '文字サイズ';
$string['fullpage_dlg:fontface'] = 'フォントファミリ';
$string['fullpage_dlg:fontsize'] = '文字サイズ';
$string['fullpage_dlg:general_props'] = '一般';
$string['fullpage_dlg:head_elements'] = 'Head要素';
$string['fullpage_dlg:hover_color'] = 'リンク色 (hover)';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'インフォメーション';
$string['fullpage_dlg:langcode'] = '言語コード';
$string['fullpage_dlg:langdir'] = '文章の方向';
$string['fullpage_dlg:langprops'] = '言語およびエンコーディング';
$string['fullpage_dlg:language'] = '言語';
$string['fullpage_dlg:left_margin'] = '左余白';
$string['fullpage_dlg:link_color'] = 'リンク色';
$string['fullpage_dlg:link_element'] = 'Link要素';
$string['fullpage_dlg:ltr'] = '左から右';
$string['fullpage_dlg:media'] = 'メディア';
$string['fullpage_dlg:meta_description'] = '説明';
$string['fullpage_dlg:meta_element'] = 'Meta要素';
$string['fullpage_dlg:meta_index_follow'] = 'このページおよびリンク先を巡回する';
$string['fullpage_dlg:meta_index_nofollow'] = 'このページの巡回を許可・リンク先の巡回を禁止する';
$string['fullpage_dlg:meta_keywords'] = 'キーワード';
$string['fullpage_dlg:meta_noindex_follow'] = 'このページの巡回を禁止・リンク先の巡回を許可する';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'このページおよびリンク先の巡回を禁止する';
$string['fullpage_dlg:meta_props'] = 'メタ情報';
$string['fullpage_dlg:meta_robots'] = 'ロボット';
$string['fullpage_dlg:meta_tab'] = '一般';
$string['fullpage_dlg:meta_title'] = 'タイトル';
$string['fullpage_dlg:movedown'] = '選択済み要素を下へ移動する';
$string['fullpage_dlg:moveup'] = '選択済み要素を上へ移動する';
$string['fullpage_dlg:name'] = '名称';
$string['fullpage_dlg:properties'] = 'プロパティ';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = '選択済み要素を削除する';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = '右余白';
$string['fullpage_dlg:rtl'] = '右から左';
$string['fullpage_dlg:script_element'] = 'Script要素';
$string['fullpage_dlg:src'] = 'ソース';
$string['fullpage_dlg:style'] = 'スタイル';
$string['fullpage_dlg:style_element'] = 'スタイル要素';
$string['fullpage_dlg:stylesheet'] = 'スタイルシート';
$string['fullpage_dlg:target'] = 'Target';
$string['fullpage_dlg:text_color'] = '文字色';
$string['fullpage_dlg:textcolor'] = '色';
$string['fullpage_dlg:title'] = 'ドキュメントプロパティ';
$string['fullpage_dlg:title_element'] = 'タイトル要素';
$string['fullpage_dlg:top_margin'] = '上余白';
$string['fullpage_dlg:type'] = 'タイプ';
$string['fullpage_dlg:value'] = '値';
$string['fullpage_dlg:visited_color'] = 'リンク色 (訪問済み)';
$string['fullpage_dlg:xml_pi'] = 'XML宣言';
$string['fullscreen:desc'] = 'フルスクリーンモード';
$string['iespell:download'] = 'ieSpellが見つかりません。今からインストールしますか?';
$string['iespell:iespell_desc'] = 'スペルチェック';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = '日曜日,月曜日,火曜日,水曜日,木曜日,金曜日,土曜日,日曜日';
$string['insertdatetime:day_short'] = '(日),(月),(火),(水),(木),(金),(土),(日)';
$string['insertdatetime:insertdate_desc'] = '日付を挿入する';
$string['insertdatetime:inserttime_desc'] = '時刻を挿入する';
$string['insertdatetime:months_long'] = '1月,2月,3月,4月,5月,6月,7月,8月,9月,10月,11月,12月';
$string['insertdatetime:months_short'] = '1,2,3,4,5,6,7,8,9,10,11,12';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = '絶対位置指定を切り替える';
$string['layer:backward_desc'] = '背面へ移動する';
$string['layer:content'] = '新しいレイヤー ...';
$string['layer:forward_desc'] = '前面へ移動する';
$string['layer:insertlayer_desc'] = '新しいレイヤーを挿入する';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = '埋め込みメディアを挿入/編集する';
$string['media:edit'] = '埋め込みメディアを編集する';
$string['media_dlg:advanced'] = '高度な設定';
$string['media_dlg:align'] = 'アライン';
$string['media_dlg:align_bottom'] = '下';
$string['media_dlg:align_bottom_left'] = '左下';
$string['media_dlg:align_bottom_right'] = '右下';
$string['media_dlg:align_center'] = '中央';
$string['media_dlg:align_left'] = '左';
$string['media_dlg:align_right'] = '右';
$string['media_dlg:align_top'] = '上';
$string['media_dlg:align_top_left'] = '左上';
$string['media_dlg:align_top_right'] = '右上';
$string['media_dlg:altsource1'] = '代替ソース1';
$string['media_dlg:altsource2'] = '代替ソース2';
$string['media_dlg:audio'] = 'HTML5オーディオ';
$string['media_dlg:autogotourl'] = '自動URL';
$string['media_dlg:autohref'] = '自動HREF';
$string['media_dlg:autostart'] = '自動再生';
$string['media_dlg:balance'] = 'バランス';
$string['media_dlg:base'] = 'ベース';
$string['media_dlg:baseurl'] = 'ベースURL';
$string['media_dlg:bgcolor'] = '背景色';
$string['media_dlg:cache'] = 'キャッシュ';
$string['media_dlg:captioningid'] = 'キャプションID';
$string['media_dlg:center'] = '中央';
$string['media_dlg:class_name'] = 'クラス';
$string['media_dlg:console'] = 'コンソール';
$string['media_dlg:constrain_proportions'] = '縦横比を固定する';
$string['media_dlg:controller'] = 'コントローラ';
$string['media_dlg:controls'] = 'コントロール';
$string['media_dlg:correction'] = 'No correction';
$string['media_dlg:currentmarker'] = '現在のマーカ';
$string['media_dlg:currentposition'] = '現在の位置';
$string['media_dlg:defaultframe'] = 'デフォルトフレーム';
$string['media_dlg:embedded_audio_options'] = '埋め込みオーディオオプション';
$string['media_dlg:embeddedaudio'] = '埋め込みオーディオ';
$string['media_dlg:enabled'] = '有効';
$string['media_dlg:enablejavascript'] = 'JavaScriptを有効にする';
$string['media_dlg:endtime'] = '終了時間';
$string['media_dlg:file'] = 'ファイル/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flashオプション';
$string['media_dlg:flashvars'] = 'Flash vars';
$string['media_dlg:fullscreen'] = 'フルスクリーン';
$string['media_dlg:general'] = '一般';
$string['media_dlg:hidden'] = '非表示';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = '横方向余白';
$string['media_dlg:html5_audio_options'] = 'オーディオオプション';
$string['media_dlg:html5_video_options'] = 'HTML5ビデオオプション';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'イメージステータス';
$string['media_dlg:invokeurls'] = 'URLを開く';
$string['media_dlg:kioskmode'] = 'Kioskモード';
$string['media_dlg:list'] = 'リスト';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = '繰り返し';
$string['media_dlg:maintainaspect'] = '縦横比を保持する';
$string['media_dlg:menu'] = 'メニューを表示する';
$string['media_dlg:mute'] = 'ミュート';
$string['media_dlg:name'] = '名称';
$string['media_dlg:nojava'] = 'Javaなし';
$string['media_dlg:numloop'] = '繰り返し回数';
$string['media_dlg:play'] = '自動再生';
$string['media_dlg:playcount'] = '再生回数';
$string['media_dlg:playeveryframe'] = '全フレーム再生';
$string['media_dlg:poster'] = 'ポスター';
$string['media_dlg:prefetch'] = 'プリフェッチ';
$string['media_dlg:preload'] = 'プリロード';
$string['media_dlg:preload_auto'] = 'ユーザのブラウザに決定させる';
$string['media_dlg:preload_metadata'] = 'ビデオメタデータをプリロードする';
$string['media_dlg:preload_none'] = 'プリロードしない';
$string['media_dlg:preview'] = 'プレビュー';
$string['media_dlg:progress'] = '進捗';
$string['media_dlg:qt_options'] = 'QuickTimeオプション';
$string['media_dlg:qt_stream_warn'] = 'RTSPストリームリソースを高度な設定タブのQTソースフィールドに入力してください。あなたはソースフィールドに非ストリームバージョーンを追加する必要があります。';
$string['media_dlg:qtsrc'] = 'QTソース';
$string['media_dlg:qtsrcchokespeed'] = '再生データレート';
$string['media_dlg:quality'] = '品質';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = '再生レート';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Real Media Playerオプション';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = '伸縮';
$string['media_dlg:scriptcallbacks'] = 'スクリプトコールバック';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwaveオプション';
$string['media_dlg:shuffle'] = 'シャッフル';
$string['media_dlg:size'] = 'サイズ';
$string['media_dlg:sound'] = 'サウンド';
$string['media_dlg:source'] = 'ソース';
$string['media_dlg:starttime'] = '開始時間';
$string['media_dlg:stretchtofit'] = '自動サイズ変更';
$string['media_dlg:swstretchhalign'] = '水平伸縮';
$string['media_dlg:swstretchstyle'] = 'スタイル伸縮';
$string['media_dlg:swstretchvalign'] = '垂直伸縮';
$string['media_dlg:target'] = 'ターゲット';
$string['media_dlg:targetcache'] = 'ターゲットキャッシュ';
$string['media_dlg:title'] = '埋め込みメディアを挿入/編集する';
$string['media_dlg:type'] = 'タイプ';
$string['media_dlg:uimode'] = 'UIモード';
$string['media_dlg:video'] = 'HTML5ビデオ';
$string['media_dlg:volume'] = '音量';
$string['media_dlg:vspace'] = '上下余白';
$string['media_dlg:windowlessvideo'] = 'Windowlessビデオ';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Windows Media Playerオプション';
$string['nonbreaking:nonbreaking_desc'] = '改行なしスペースを挿入する';
$string['pagebreak:desc'] = '印刷のために改ページを挿入する';
$string['paste:paste_text_desc'] = 'プレインテキストとして貼り付ける';
$string['paste:paste_word_desc'] = 'Wordから貼り付ける';
$string['paste:plaintext_mode'] = '現在、ペーストはプレインテキストモードです。通常ペーストモードに戻るには再度クリックしてください。あなたが何かを貼り付けた場合、通常ペーストモードに戻ります。';
$string['paste:plaintext_mode_stick'] = '現在、ペーストはプレインテキストモードです。通常ペーストモードに戻るには再度クリックしてください。';
$string['paste:selectall_desc'] = 'すべてを選択する';
$string['paste_dlg:text_linebreaks'] = '改行を保持する';
$string['paste_dlg:text_title'] = 'ウィンドウにテキストを貼り付けるにはあなたのキーボードの「CTRL+V」を使用してください。';
$string['paste_dlg:word_title'] = 'ウィンドウにテキストを貼り付けるにはあなたのキーボードの「CTRL+V」を使用してください。';
$string['pluginname'] = 'TinyMCE HTMLエディタ';
$string['preview:preview_desc'] = 'プレビュー';
$string['print:print_desc'] = '印刷';
$string['privacy:metadata'] = 'TinyMCE HTMLエディタプラグインはいかなる個人データも保存しません。';
$string['save:cancel_desc'] = 'すべての変更を破棄する';
$string['save:save_desc'] = '保存';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = '検索/置換';
$string['searchreplace:search_desc'] = '検索';
$string['searchreplace_dlg:allreplaced'] = 'すべての検索ストリングが置換されました。';
$string['searchreplace_dlg:direction'] = '方向';
$string['searchreplace_dlg:down'] = '下へ';
$string['searchreplace_dlg:findnext'] = '次へ';
$string['searchreplace_dlg:findwhat'] = '検索文字列';
$string['searchreplace_dlg:mcase'] = '大文字/小文字を区別する';
$string['searchreplace_dlg:notfound'] = '検索を完了しました。検索文字列は見つかりませんでした。';
$string['searchreplace_dlg:replace'] = '置換';
$string['searchreplace_dlg:replace_title'] = '検索/置換';
$string['searchreplace_dlg:replaceall'] = 'すべてを置換する';
$string['searchreplace_dlg:replacewith'] = '置換文字列';
$string['searchreplace_dlg:search_title'] = '検索';
$string['searchreplace_dlg:searchnext_desc'] = '再検索';
$string['searchreplace_dlg:up'] = '上へ';
$string['settings'] = '一般設定';
$string['simple:bold_desc'] = '太字 (Ctrl+B)';
$string['simple:bullist_desc'] = '番号なしリストを挿入/削除する';
$string['simple:cleanup_desc'] = 'コード整形';
$string['simple:italic_desc'] = '斜体 (Ctrl+I)';
$string['simple:numlist_desc'] = '番号付きリストを挿入/削除する';
$string['simple:redo_desc'] = 'やり直す (Ctrl+Y)';
$string['simple:striketrough_desc'] = '打ち消し線';
$string['simple:underline_desc'] = '下線 (Ctrl+U)';
$string['simple:undo_desc'] = '元に戻す (Ctrl+Z)';
$string['spellchecker:desc'] = 'スペルチェックOn/Off';
$string['spellchecker:ignore_word'] = 'この単語を無視する';
$string['spellchecker:ignore_words'] = 'すべて無視する';
$string['spellchecker:langs'] = '言語';
$string['spellchecker:learn_word'] = '単語を学習する';
$string['spellchecker:menu'] = 'スペルチェック設定';
$string['spellchecker:no_mpell'] = 'スペルミスはありませんでした。';
$string['spellchecker:no_sug'] = '候補がありません。';
$string['spellchecker:sug'] = '候補';
$string['spellchecker:wait'] = 'しばらくお待ちください ...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'CSSスタイルを編集する';
$string['style_dlg:apply'] = '適用';
$string['style_dlg:background'] = '背景';
$string['style_dlg:background_attachment'] = '添付';
$string['style_dlg:background_color'] = '背景色';
$string['style_dlg:background_hpos'] = '水平位置';
$string['style_dlg:background_image'] = '背景イメージ';
$string['style_dlg:background_repeat'] = '繰り返し';
$string['style_dlg:background_tab'] = '背景';
$string['style_dlg:background_vpos'] = '垂直位置';
$string['style_dlg:block'] = 'ブロック';
$string['style_dlg:block_display'] = '表示';
$string['style_dlg:block_letterspacing'] = '文字間隔';
$string['style_dlg:block_tab'] = 'ブロック';
$string['style_dlg:block_text_align'] = 'テキストアライン';
$string['style_dlg:block_text_indent'] = 'テキストインデント';
$string['style_dlg:block_vertical_alignment'] = '垂直アラインメント';
$string['style_dlg:block_whitespace'] = '空白文字';
$string['style_dlg:block_wordspacing'] = '単語の間隔';
$string['style_dlg:border'] = '枠線';
$string['style_dlg:border_tab'] = '枠線';
$string['style_dlg:bottom'] = 'ボトム';
$string['style_dlg:box'] = 'ボックス';
$string['style_dlg:box_clear'] = 'クリア';
$string['style_dlg:box_float'] = '回り込み';
$string['style_dlg:box_height'] = '高さ';
$string['style_dlg:box_tab'] = 'ボックス';
$string['style_dlg:box_width'] = '幅';
$string['style_dlg:bullet_image'] = 'ブレットイメージ';
$string['style_dlg:clip'] = '切り抜き';
$string['style_dlg:color'] = '色';
$string['style_dlg:height'] = '高さ';
$string['style_dlg:left'] = '左';
$string['style_dlg:list'] = 'リスト';
$string['style_dlg:list_tab'] = 'リスト';
$string['style_dlg:list_type'] = 'タイプ';
$string['style_dlg:margin'] = 'マージン';
$string['style_dlg:overflow'] = 'オーバーフロー';
$string['style_dlg:padding'] = 'パディング';
$string['style_dlg:placement'] = '位置';
$string['style_dlg:position'] = 'ポジション';
$string['style_dlg:positioning_tab'] = 'ポジショニング';
$string['style_dlg:positioning_type'] = 'タイプ';
$string['style_dlg:right'] = '右';
$string['style_dlg:same'] = 'すべて同じにする';
$string['style_dlg:style'] = 'スタイル';
$string['style_dlg:text'] = 'テキスト';
$string['style_dlg:text_blink'] = '点滅';
$string['style_dlg:text_case'] = '大文字小文字';
$string['style_dlg:text_color'] = '色';
$string['style_dlg:text_decoration'] = '装飾';
$string['style_dlg:text_font'] = 'フォント';
$string['style_dlg:text_lineheight'] = '行の高さ';
$string['style_dlg:text_none'] = 'なし';
$string['style_dlg:text_overline'] = '上線';
$string['style_dlg:text_props'] = 'テキスト';
$string['style_dlg:text_size'] = 'サイズ';
$string['style_dlg:text_striketrough'] = '打ち消し線';
$string['style_dlg:text_style'] = 'スタイル';
$string['style_dlg:text_tab'] = 'テキスト';
$string['style_dlg:text_underline'] = '下線';
$string['style_dlg:text_variant'] = '変形';
$string['style_dlg:text_weight'] = '太さ';
$string['style_dlg:title'] = 'CSSスタイルを編集する';
$string['style_dlg:toggle_insert_span'] = '選択した場所にspanタグを挿入する';
$string['style_dlg:top'] = 'トップ';
$string['style_dlg:visibility'] = '可視性';
$string['style_dlg:width'] = '幅';
$string['style_dlg:zindex'] = 'Z-Index';
$string['subplugintype_tinymce'] = 'プラグイン';
$string['subplugintype_tinymce_plural'] = 'プラグイン';
$string['table:cell'] = 'セル';
$string['table:cell_desc'] = 'テーブルセルプロパティ';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'カラム';
$string['table:col_after_desc'] = 'カラムを後に挿入する';
$string['table:col_before_desc'] = 'カラムを前に挿入する';
$string['table:copy_row_desc'] = 'テーブル行をコピーする';
$string['table:cut_row_desc'] = 'テーブル行を切り取る';
$string['table:del'] = 'テーブルを削除する';
$string['table:delete_col_desc'] = 'カラムを削除する';
$string['table:delete_row_desc'] = '行を削除';
$string['table:desc'] = 'テーブルを挿入/編集する';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'テーブルセルを結合する';
$string['table:paste_row_after_desc'] = '行を下に貼り付ける';
$string['table:paste_row_before_desc'] = '行を上に貼り付ける';
$string['table:props_desc'] = 'テーブルプロパティ';
$string['table:row'] = '行';
$string['table:row_after_desc'] = '行を下に挿入する';
$string['table:row_before_desc'] = '行を上に挿入する';
$string['table:row_desc'] = 'テーブル行プロパティ';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'テーブルセルの結合を解除する';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = '高度な設定';
$string['table_dlg:advanced_tab'] = '高度';
$string['table_dlg:align'] = 'アラインメント';
$string['table_dlg:align_bottom'] = '下端揃え';
$string['table_dlg:align_default'] = 'デフォルト';
$string['table_dlg:align_left'] = '左揃え';
$string['table_dlg:align_middle'] = '中央揃え';
$string['table_dlg:align_right'] = '右揃え';
$string['table_dlg:align_top'] = '上端揃え';
$string['table_dlg:bgcolor'] = '背景色';
$string['table_dlg:bgimage'] = '背景イメージ';
$string['table_dlg:border'] = '枠線';
$string['table_dlg:bordercolor'] = '枠線の色';
$string['table_dlg:caption'] = 'テーブル見出し';
$string['table_dlg:cell_all'] = 'テーブル内すべてのセルを更新する';
$string['table_dlg:cell_cell'] = '現在のセルを更新する';
$string['table_dlg:cell_col'] = 'カラム内すべてのセルを更新する';
$string['table_dlg:cell_limit'] = 'あなたは {$cells} のセルの最大数を超えました。';
$string['table_dlg:cell_row'] = '行内すべてのセルを更新する';
$string['table_dlg:cell_title'] = 'テーブルセルプロパティ';
$string['table_dlg:cell_type'] = 'セルタイプ';
$string['table_dlg:cellpadding'] = 'セル余白';
$string['table_dlg:cellspacing'] = 'セル間隔';
$string['table_dlg:col_limit'] = 'あなたは {$cols} の列の最大数を超えました。';
$string['table_dlg:colgroup'] = '列グループ';
$string['table_dlg:cols'] = '列';
$string['table_dlg:frame'] = 'セル枠線';
$string['table_dlg:frame_all'] = 'すべて';
$string['table_dlg:frame_cols'] = '列';
$string['table_dlg:frame_groups'] = 'グループ';
$string['table_dlg:frame_none'] = 'なし';
$string['table_dlg:frame_rows'] = '行';
$string['table_dlg:general_props'] = '一般プロパティ';
$string['table_dlg:general_tab'] = '一般';
$string['table_dlg:height'] = '高さ';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = '言語コード';
$string['table_dlg:langdir'] = '文字表記の方向';
$string['table_dlg:ltr'] = '左から右';
$string['table_dlg:merge_cells_title'] = 'テーブルセルを結合する';
$string['table_dlg:mime'] = 'ターゲットのMIMEタイプ';
$string['table_dlg:missing_scope'] = '本当にこのテーブルのヘッダセルのスコープを設定せずに続けてもよろしいですか? スコープがない場合、障害のあるユーザに関してテーブルに表示されるコンテンツまたはデータの理解が難しくなる可能性があります。';
$string['table_dlg:row_all'] = 'テーブル内すべての行を更新する';
$string['table_dlg:row_even'] = 'テーブル内の偶数行を更新する';
$string['table_dlg:row_limit'] = 'あなたは {$rows} の行の最大数を超えました。';
$string['table_dlg:row_odd'] = 'テーブル内の奇数行を更新する';
$string['table_dlg:row_row'] = '現在の行を更新する';
$string['table_dlg:row_title'] = 'テーブル行プロパティ';
$string['table_dlg:rowgroup'] = '行グループ';
$string['table_dlg:rows'] = '行';
$string['table_dlg:rowtype'] = '行タイプ';
$string['table_dlg:rtl'] = '右から左';
$string['table_dlg:rules'] = 'テーブルの外枠';
$string['table_dlg:rules_above'] = '上';
$string['table_dlg:rules_below'] = '下';
$string['table_dlg:rules_border'] = '上下左右 (border)';
$string['table_dlg:rules_box'] = '上下左右 (box)';
$string['table_dlg:rules_hsides'] = '上下';
$string['table_dlg:rules_lhs'] = '左';
$string['table_dlg:rules_rhs'] = '右';
$string['table_dlg:rules_void'] = 'なし';
$string['table_dlg:rules_vsides'] = '左右';
$string['table_dlg:scope'] = 'スコープ';
$string['table_dlg:style'] = 'スタイル';
$string['table_dlg:summary'] = 'サマリ';
$string['table_dlg:tbody'] = 'ボディ';
$string['table_dlg:td'] = 'データ';
$string['table_dlg:tfoot'] = 'フッタ';
$string['table_dlg:th'] = 'ヘッダ';
$string['table_dlg:thead'] = 'ヘッダ';
$string['table_dlg:title'] = 'テーブルを挿入/編集する';
$string['table_dlg:valign'] = '垂直アラインメント';
$string['table_dlg:width'] = '幅';
$string['template:desc'] = 'テンプレートコンテンツを挿入する';
$string['template_dlg:cdate_format'] = '%Y/%m/%d %H:%M:%S';
$string['template_dlg:day_long'] = '日曜日,月曜日,火曜日,水曜日,木曜日,金曜日,土曜日,日曜日';
$string['template_dlg:day_short'] = '(日),(月),(火),(水),(木),(金),(土),(日)';
$string['template_dlg:desc'] = 'テンプレートコンテンツを挿入する';
$string['template_dlg:desc_label'] = '説明';
$string['template_dlg:label'] = 'テンプレート';
$string['template_dlg:mdate_format'] = '%Y/%m/%d %H:%M:%S';
$string['template_dlg:months_long'] = '1月,2月,3月,4月,5月,6月,7月,8月,9月,10月,11月,12月';
$string['template_dlg:months_short'] = '1,2,3,4,5,6,7,8,9,10,11,12';
$string['template_dlg:preview'] = 'プレビュー';
$string['template_dlg:select'] = 'テンプレートを選択する';
$string['template_dlg:title'] = 'テンプレート';
$string['template_dlg:warning'] = '警告：テンプレートを上書きした場合、以前のデータを失う可能性があります。';
$string['visualblocks:desc'] = 'ブロックエレメントを表示/非表示にする';
$string['visualchars:desc'] = '視覚制御文字を表示/非表示にする';
$string['wordcount:words'] = '語:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = '略語';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = '頭字語';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = '属性を挿入/編集する';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = '引用';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = '削除';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = '挿入';
$string['xhtmlxtras_dlg:attrib_tab'] = '属性';
$string['xhtmlxtras_dlg:attribs_title'] = '属性を挿入/編集する';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = '属性';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'イベント';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'アクセスキー';
$string['xhtmlxtras_dlg:attribute_label_cite'] = '引用';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'クラス';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = '日付/時刻';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = '言語';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'テキストの方向';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'スタイル';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'タブインデックス';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'タイトル';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = '左から右';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = '右から左';
$string['xhtmlxtras_dlg:events_tab'] = 'イベント';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'エレメント属性';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'エレメントイベント';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = '一般設定';
$string['xhtmlxtras_dlg:general_tab'] = '一般';
$string['xhtmlxtras_dlg:insert_date'] = '現在の日付/時刻を挿入する';
$string['xhtmlxtras_dlg:option_ltr'] = '左から右';
$string['xhtmlxtras_dlg:option_rtl'] = '右から左';
$string['xhtmlxtras_dlg:remove'] = '削除';
$string['xhtmlxtras_dlg:title_abbr_element'] = '略語エレメント';
$string['xhtmlxtras_dlg:title_acronym_element'] = '頭字語エレメント';
$string['xhtmlxtras_dlg:title_cite_element'] = '引用エレメント';
$string['xhtmlxtras_dlg:title_del_element'] = 'エレメント削除';
$string['xhtmlxtras_dlg:title_ins_element'] = 'エレメント挿入';
