<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'ja', version '3.9'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'インストールされます';
$string['accept'] = '承認';
$string['action'] = '操作';
$string['actionchoice'] = 'このファイル「 {$a} 」で何をしたいですか?';
$string['actions'] = '操作';
$string['actionsfor'] = '{$a } へのアクション';
$string['actionsmenu'] = 'アクションメニュー';
$string['active'] = 'アクティブ';
$string['activeusers'] = 'アクティブユーザ';
$string['activities'] = '活動';
$string['activities_help'] = 'フォーラム、小テストおよびWiki等の活動では対話型コンテンツをコースに追加できます。';
$string['activity'] = '活動';
$string['activityclipboard'] = 'この活動を移動する: {$a}';
$string['activityiscurrentlyhidden'] = '申し訳ございません、この活動は現在非表示にされています。';
$string['activitymodule'] = '活動モジュール';
$string['activitymodules'] = '活動モジュール';
$string['activityreport'] = '活動レポート';
$string['activityreports'] = '活動レポート';
$string['activityselect'] = '他の場所に移動するため、この活動を選択する';
$string['activitysince'] = '{$a} 以来の活動';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'ユーザごとの活動';
$string['add'] = '追加';
$string['addactivity'] = '活動を追加する ...';
$string['addactivitytosection'] = 'セクション「 {$a} 」に活動を追加する';
$string['addadmin'] = '管理者を追加する';
$string['addblock'] = 'ブロックを追加する';
$string['addcomment'] = 'コメントを追加する ...';
$string['addcountertousername'] = 'ユーザ名に番号を付加してユーザを作成する';
$string['addcreator'] = 'コース作成者を追加する';
$string['adddots'] = '追加 ...';
$string['added'] = '{$a} が追加されました';
$string['addedrecip'] = '新しい取得者 {$a} 名が追加されました。';
$string['addedrecips'] = '新しい取得者 {$a} 名が追加されました。';
$string['addedtogroup'] = 'グループ「 {$a} 」に追加されました。';
$string['addedtogroupnot'] = 'グループ「 {$a} 」に追加されませんでした。';
$string['addedtogroupnotenrolled'] = 'コースに登録されていないため、グループ「 {$a} 」に追加されませんでした。';
$string['addfilehere'] = 'ファイルをここに追加する';
$string['addinganew'] = '新しい {$a} を追加する';
$string['addinganewto'] = '新しい {$a->what} を {$a->to} に追加する';
$string['addingdatatoexisting'] = '既存のデータに追加する';
$string['additionalnames'] = '追加氏名';
$string['addlinkhere'] = 'リンクをここに追加する';
$string['addnew'] = '新しい {$a} を追加する';
$string['addnewcategory'] = '新しいカテゴリを追加する';
$string['addnewcourse'] = '新しいコースを追加する';
$string['addnewuser'] = '新しいユーザを追加する';
$string['addnousersrecip'] = 'この {$a} にアクセスしていないユーザを取得者リストに追加する';
$string['addpagehere'] = 'ここにテキストを追加する';
$string['addresource'] = 'リソースを追加する ...';
$string['addresourceoractivity'] = '活動またはリソースを追加する';
$string['addresourcetosection'] = 'セクション「 {$a} 」にリソースを追加する';
$string['address'] = '住所';
$string['addsections'] = 'セクションを追加する';
$string['addstudent'] = '学生を追加する';
$string['addsubcategory'] = 'サブカテゴリを追加する';
$string['addteacher'] = '教師を追加する';
$string['admin'] = '管理';
$string['adminhelpaddnewuser'] = '新しいユーザアカウントを手動作成します。';
$string['adminhelpassignadmins'] = '管理者はサイト内ですべての作業および移動ができます。';
$string['adminhelpassigncreators'] = 'コース作成者は新しいコースを作成できます。';
$string['adminhelpassignsiteroles'] = '定義済みサイトロールを特定のユーザに適用します。';
$string['adminhelpassignstudents'] = 'コースに入って管理メニューより学生を追加します。';
$string['adminhelpauthentication'] = 'あなたは内部ユーザアカウントまたは外部データベースを使用できます。';
$string['adminhelpbackup'] = '自動バックアップおよびそのスケジュールを設定します。';
$string['adminhelpconfiguration'] = 'サイトのデザインおよび動作を設定します。';
$string['adminhelpconfigvariables'] = 'サイト全般の運用に影響する変数を設定します。';
$string['adminhelpcourses'] = 'コース・カテゴリの設定およびユーザの割り当て、承認審査中のコースを編集します。';
$string['adminhelpeditorsettings'] = 'HTMLエディタの基本設定を定義します。';
$string['adminhelpedituser'] = 'ユーザアカウントリストを表示および編集します。';
$string['adminhelpenvironment'] = 'あなたのサーバが現在および将来のインストールのシステム要件を満たしているかチェックします。';
$string['adminhelpfailurelogs'] = 'ログイン失敗のログを表示します。';
$string['adminhelplanguage'] = '現在の言語パックを確認および編集します。';
$string['adminhelplogs'] = 'サイトの活動すべてに関するログを表示します。';
$string['adminhelpmanageblocks'] = 'インストール済みブロックを管理および設定します。';
$string['adminhelpmanagedatabase'] = 'データベースに直接アクセスします (注意してください!)。';
$string['adminhelpmanagefilters'] = 'テキストフィルタおよび関連設定を選択します。';
$string['adminhelpmanagemodules'] = 'インストール済みモジュールおよびその設定を管理します。';
$string['adminhelpmanageroles'] = 'ユーザに適用可能なロールを作成および定義します。';
$string['adminhelpmymoodle'] = 'ユーザのマイMoodleブロックを設定します。';
$string['adminhelpreports'] = 'サイトレベルレポート';
$string['adminhelpsitefiles'] = '一般的なファイルの公開または外部バックアップファイルをアップロードします。';
$string['adminhelpsitesettings'] = 'サイトのフロントページのデザインを設定します。';
$string['adminhelpstickyblocks'] = 'Moodle全体のスティッキーブロックを設定します。';
$string['adminhelpthemes'] = 'サイトのデザイン (色、フォント等) を選択します。';
$string['adminhelpuploadusers'] = 'テキストファイルから新しいユーザをインポートします。';
$string['adminhelpusers'] = 'あなたのユーザを定義して認証を設定します。';
$string['adminhelpxmldbeditor'] = 'XMLDBファイルを編集するためのインタフェースです。開発者専用です。';
$string['administration'] = '管理';
$string['administrationsite'] = 'サイト管理';
$string['administrator'] = '管理者';
$string['administratordescription'] = '通常、管理者はサイト内のすべてのコースでどのような作業でも実施できます。';
$string['administrators'] = '管理者';
$string['administratorsall'] = 'すべての管理者';
$string['administratorsandteachers'] = '管理者および教師';
$string['advanced'] = '高度';
$string['advancedfilter'] = '高度な検索';
$string['advancedsettings'] = '高度な設定';
$string['afterresource'] = 'リソース「 {$a} 」の後';
$string['aftersection'] = 'セクション「 {$a} 」の後';
$string['again'] = 'もう一度';
$string['agelocationverification'] = '年齢および場所の確認';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAXおよびJavaScript';
$string['all'] = 'すべて';
$string['allactions'] = 'すべてのアクション';
$string['allactivities'] = 'すべての活動';
$string['allcategories'] = 'すべてのカテゴリ';
$string['allchanges'] = 'すべての変更';
$string['alldays'] = 'すべての日付';
$string['allfieldsrequired'] = 'すべてのフィールドは必須入力です。';
$string['allfiles'] = 'すべてのファイル';
$string['allgroups'] = 'すべてのグループ';
$string['alllogs'] = 'すべてのログ';
$string['allmods'] = 'すべての {$a}';
$string['allow'] = '許可する';
$string['allowinternal'] = '内部登録も許可する';
$string['allownone'] = 'どれも許可しない';
$string['allownot'] = '許可しない';
$string['allowstealthmodules'] = 'ステルス活動を許可する';
$string['allowstealthmodules_help'] = 'この設定を有効にした場合、活動をコースページの可視セクション内に表示せずに利用可能にできます。この場合、ステルス活動のリンクをページリソース等で提供する必要があります。ステルス活動は評定表およびその他レポートには表示されます。';
$string['allparticipants'] = 'すべての参加者';
$string['allteachers'] = 'すべての教師';
$string['alphanumerical'] = '半角英数字、ハイフン (-)、ピリオド (.) のみ含めます。';
$string['alreadyconfirmed'] = 'ユーザ登録はすでに承認されています。';
$string['alternatename'] = '別名';
$string['always'] = '常に';
$string['and'] = '{$a->one} および {$a->two}';
$string['answer'] = '回答';
$string['any'] = 'どれか';
$string['appearance'] = 'アピアランス';
$string['approve'] = '承認';
$string['areyousure'] = '本当によろしいですか?';
$string['areyousuretorestorethis'] = '本当に続けてもよろしいですか?';
$string['areyousuretorestorethisinfo'] = 'あなたはこの処理の後、このバックアップを既存のコースに追加するか、完全に新しいコースを作成するか選択できます。';
$string['asc'] = '昇順';
$string['assessment'] = '評価';
$string['assignadmins'] = '管理者を割り当てる';
$string['assigncreators'] = 'コース作成者を割り当てる';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'サイト全体のロールを割り当てる';
$string['authenticateduser'] = '認証済みユーザ';
$string['authenticateduserdescription'] = 'すべてのログイン済みユーザです。';
$string['authentication'] = '認証';
$string['authenticationplugins'] = '認証プラグイン';
$string['autosubscribe'] = 'フォーラム自動メール購読';
$string['autosubscribeno'] = 'いいえ: フォーラムディスカッションをメール購読しません';
$string['autosubscribeyes'] = 'はい: 私が投稿した場合、フォーラムディスカッションをメール購読します';
$string['availability'] = '利用';
$string['availablecourses'] = 'コース一覧';
$string['back'] = '戻る';
$string['backto'] = '{$a} に戻る';
$string['backtocourselisting'] = 'コース一覧に戻る';
$string['backtohome'] = 'サイトホームに戻る';
$string['backtopageyouwereon'] = '元のページに戻る';
$string['backtoparticipants'] = '参加者リストに戻る';
$string['backup'] = 'バックアップ';
$string['backupactivehelp'] = '自動バックアップを実行するかどうか選択してください。';
$string['backupadhocpending'] = 'コースバックアップアドホックタスク保留';
$string['backupcancelled'] = 'バックアップが中止されました。';
$string['backupcoursefileshelp'] = 'この設定を有効にした場合、自動バックアップにコースファイルが含まれます。';
$string['backupdate'] = 'バックアップ日付';
$string['backupdatenew'] = '&nbsp; 現在の {$a->TAG} は {$a->weekday}, {$a->mday} {$a->month} {$a->year} です。<br />';
$string['backupdateold'] = '{$a->TAG} は {$a->weekday}, {$a->mday} {$a->month} {$a->year} でした。';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'バックアップ詳細';
$string['backuperrorinvaliddestination'] = 'バックアップ先フォルダが存在しないか、書き込み可能ではありません。';
$string['backupexecuteathelp'] = '何時に自動バックアップを実行するか選択してください。';
$string['backupfailed'] = 'あなたのいくつかのコースが保存されませんでした!!';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'バックアップが正常に完了しました。';
$string['backupfromthissite'] = 'バックアップはこのサイトで作成されましたか?';
$string['backupgradebookhistoryhelp'] = 'この設定を有効にした場合、自動バックアップに評定表履歴が含まれます。この機能を動作させるにはサーバ設定の評定履歴を無効 (disablegradehistory) にできない点に留意してください。';
$string['backupincludemoduleshelp'] = '自動バックアップにコースモジュールにユーザデータを含むかどうか選択してください。';
$string['backupincludemoduleuserdatahelp'] = 'モジュールのユーザデータを自動バックアップに含むかどうか選択してください。';
$string['backuplogdetailed'] = '詳細実行ログ';
$string['backuploglaststatus'] = '最新実行ログ';
$string['backupmissinguserinfoperms'] = '注意: このバックアップにはユーザデータが含まれていません。また、このタイプのバックアップに互換性がないためエクササイズおよびワークショップ活動はバックアップに含まれません。';
$string['backupnext'] = '次のバックアップ';
$string['backupnonisowarning'] = '警告: このバックアップは非ユニコードバージョンのMoodle (1.6以前) によって作成されたものです。このバックアップに非ISO-8859-1テキストが含まれている場合、ユニコードバージョンのMoodleにリストアすることにより文字化けが発生する可能性があります。このバックアップを正常化にするための詳細情報は<a href="https://docs.moodle.org/ja/バックアップFAQ">バックアップFAQ</a>をご覧ください。';
$string['backupnotyetrun'] = '自動バックアップ保留';
$string['backuporiginalname'] = 'バックアップ名';
$string['backuproleassignments'] = 'これらのロールに対するロール割り当てをバックアップする';
$string['backupsavetohelp'] = 'あなたがバックアップファイルを保存したいディレクトリのフルパスです。';
$string['backupsitefileshelp'] = 'この設定を有効にした場合、コースで使用されたサイトファイルが自動バックアップに含まれます。';
$string['backuptakealook'] = '次のバックアップログをご覧ください: {$a}';
$string['backupuserfileshelp'] = '自動バックアップにユーザファイル (例 プロファイルイメージ) を含むかどうか選択してください。';
$string['backupversion'] = 'バックアップバージョン';
$string['badges'] = 'バッジ';
$string['block'] = 'ブロック';
$string['blockconfiga'] = '{$a} ブロックの設定';
$string['blockconfigbad'] = 'このブロックは正常に組み込まれていないため、設定インタフェースを表示できません。';
$string['blocks'] = 'ブロック';
$string['blocksaddedit'] = 'ブロックを追加/編集する';
$string['blockseditoff'] = 'ブロック編集の終了';
$string['blocksediton'] = 'ブロック編集の開始';
$string['blocksetup'] = 'ブロックテーブル設定中';
$string['blocksuccess'] = '{$a} テーブルが正常に設定されました。';
$string['brief'] = '概要';
$string['bulkactions'] = 'バルク処理';
$string['bulkactionselect'] = '{$a} バルク処理選択';
$string['bulkmovecoursessuccess'] = '{$a->courses} 件のコースを正常に「 {$a->category} 」に移動しました。';
$string['bycourseorder'] = 'コース順';
$string['byname'] = 'by {$a}';
$string['bypassed'] = 'バイパス';
$string['cachecontrols'] = 'キャッシュコントロール';
$string['calltofeedback'] = 'このソフトウェアの作成者があなたのフィードバックを希望しています。';
$string['calltofeedback_give'] = 'このソフトウェアに関してフィードバックを与える';
$string['calltofeedback_remind'] = '私に後で知らせて';
$string['cancel'] = 'キャンセル';
$string['cancelled'] = 'キャンセルされました。';
$string['categories'] = 'コースカテゴリ';
$string['categoriesandcourses'] = 'コースカテゴリおよびコース';
$string['category'] = 'カテゴリ';
$string['categoryadded'] = 'カテゴリ「 {$a} 」 が追加されました。';
$string['categorybulkaction'] = '選択されたカテゴリのバルク処理';
$string['categorycontents'] = 'サブカテゴリおよびコース';
$string['categorycurrentcontents'] = '{$a} のコンテンツ';
$string['categorydeleted'] = 'カテゴリ「 {$a} 」 が削除されました。';
$string['categoryduplicate'] = 'カテゴリ名「{$a}」はすでに存在します!';
$string['categoryhidden'] = '(非表示)';
$string['categorymodifiedcancel'] = 'カテゴリが変更されました! キャンセルの後、再度お試しください。';
$string['categoryname'] = 'カテゴリ名';
$string['categorysubcategoryof'] = '{$a->category} - {$a->parentcategory} のサブカテゴリ';
$string['categoryupdated'] = 'カテゴリ「 {$a} 」が更新されました。';
$string['changedpassword'] = 'パスワードを変更しました。';
$string['changepassword'] = 'パスワードを変更する';
$string['changesmadereallygoaway'] = 'あなたは変更しました。本当に移動して、あなたの変更を失ってもよろしいですか?';
$string['changessaved'] = '変更が保存されました。';
$string['check'] = 'チェック';
$string['checkall'] = 'すべてをチェック';
$string['checkingbackup'] = 'バックアップの確認中';
$string['checkingcourse'] = 'コースの確認中';
$string['checkingforbbexport'] = 'BlackBoardエクスポートの確認中';
$string['checkinginstances'] = 'インスタンスの確認中';
$string['checkingsections'] = 'セクションの確認中';
$string['checklanguage'] = '言語の確認';
$string['checknone'] = 'チェックなし';
$string['checks'] = 'チェック';
$string['checksok'] = 'すべての「 {$a} 」チェック OK';
$string['childcoursenotfound'] = '子コースが見つかりませんでした!';
$string['childcourses'] = '子コース';
$string['choose'] = '選択';
$string['choosecourse'] = 'コースを選択してください。';
$string['choosedots'] = '選択 ...';
$string['chooselivelogs'] = 'または現在の活動を表示する';
$string['chooselogs'] = 'あなたが表示したいログを選択してください';
$string['choosereportfilter'] = 'レポートのフィルタを選択してください。';
$string['choosetheme'] = 'テーマの選択';
$string['chooseuser'] = 'ユーザを選択してください。';
$string['city'] = '都道府県';
$string['cleaningtempdata'] = '一時データの消去';
$string['clear'] = 'クリア';
$string['clearsearch'] = '検索入力をクリアする';
$string['clickhelpiconformoreinfo'] = '... 続ける ... 詳細記事を閲覧するにはヘルプアイコンをクリックしてください。';
$string['clickhere'] = 'ここをクリック ...';
$string['clicktochangeinbrackets'] = '{$a} (クリックで変更)';
$string['clicktohideshow'] = '展開または折りたたむにはここをクリックしてください。';
$string['closebuttontitle'] = '閉じる';
$string['closewindow'] = 'ウィンドウを閉じる';
$string['collapse'] = '折りたたむ';
$string['collapseall'] = 'すべてを折りたたむ';
$string['collapsecategory'] = '{$a} を折りたたむ';
$string['commentincontext'] = 'このコメントをコンテクスト内で探す';
$string['comments'] = 'コメント';
$string['commentscount'] = 'コメント ({$a})';
$string['commentsnotenabled'] = 'コメント機能は有効にされていません。';
$string['commentsrequirelogin'] = 'コメントを閲覧するにはあなたはログインする必要があります。';
$string['comparelanguage'] = '現在の言語を比較・編集する';
$string['complete'] = '詳細';
$string['completereport'] = '詳細レポート';
$string['configuration'] = '設定';
$string['confirm'] = '確認';
$string['confirmcheckfull'] = '本当に {$a} を承認してもよろしいですか?';
$string['confirmcoursemove'] = '本当にこのコース ({$a->course}) をこのカテゴリ ({$a->category}) に移動してもよろしいですか?';
$string['confirmdeletesection'] = '本当に「 {$a} 」および含まれる活動すべてを完全に削除してもよろしいですか?';
$string['confirmed'] = 'あなたの登録が承認されました。';
$string['confirmednot'] = 'あなたの登録はまだ承認されていません。メールボックスで承認メールを確認してください。';
$string['considereddigitalminor'] = 'あなたがこのサイトでアカウントを作成するには若すぎます。';
$string['content'] = 'コンテンツ';
$string['contentbank'] = 'コンテンツバンク';
$string['continue'] = '続ける';
$string['continuetocourse'] = 'あなたのコースに入るにはここをクリックしてください';
$string['convertingwikitomarkdown'] = 'WikiをMarkdownに変換する';
$string['cookiesenabled'] = 'あなたのブラウザのクッキーを有効にしてください。';
$string['cookiesenabled_help'] = 'このサイトでは2種類のクッキーが使用されます:

重要なクッキーはセッションクッキーで通常MoodleSessionと呼ばれます。継続的にログインしてサイトを閲覧できるようにするため、あなたのブラウザでこのクッキーを有効にしてください。 ログアウトまたはブラウザを閉じた場合、(あなたのブラウザおよびサーバの) クッキーは破棄されます。

もう1つのクッキーは純粋に便宜的な理由で使用され、通常MOODLEIDのように呼ばれます。このクッキーはあなたのユーザ名をブラウザに憶えさせるために使用されます。これはあなたがサイトへ戻った場合、ログインページのユーザ名が初めから入力されていることを意味します。このクッキーは拒否しても安全です - あなたはログイン時にユーザ名を毎回入力する必要があります。';
$string['cookiesenabledonlysession'] = 'あなたのブラウザのクッキーを有効にしてください。';
$string['cookiesenabledonlysession_help'] = 'このサイトでは通常MoodleSessionと呼ばれるセッションクッキーを使用します。継続的にログインしてサイトを閲覧できるようにするため、あなたのブラウザでこのクッキー有効にしてください。 ログアウトまたはブラウザを閉じた場合、(あなたのブラウザおよびサーバの) クッキーは破棄されます。';
$string['cookiesnotenabled'] = '残念ですが、あなたのブラウザではクッキーが有効にされていません。';
$string['copy'] = 'コピー';
$string['copyasnoun'] = 'コピー';
$string['copycourse'] = 'コースをコピーする';
$string['copyingcoursefiles'] = 'コースファイルのコピー';
$string['copyingsitefiles'] = 'コースで使用されているサイトファイルのコピー';
$string['copyinguserfiles'] = 'ユーザファイルのコピー';
$string['copyingzipfile'] = 'ZIPファイルのコピー';
$string['copyrightnotice'] = '著作権表示';
$string['coresystem'] = 'システム';
$string['cost'] = '費用';
$string['costdefault'] = 'デフォルト費用';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = '国';
$string['course'] = 'コース';
$string['courseadministration'] = 'コース管理';
$string['courseapprovedemail'] = 'あなたのリクエストしたコース「 {$a->name} 」が承認されて、 {$a->teacher} になりました。新しいコースにアクセスするには {$a->url} へ移動してください。';
$string['courseapprovedemail2'] = 'あなたのリクエストしたコース「 {$a->name} 」が承認されました。新しいコースにアクセスするには {$a->url} へ移動してください。';
$string['courseapprovedfailed'] = 'コースを承認済みとして保存できませんでした!';
$string['courseapprovedsubject'] = 'あなたのコースが承認されました!';
$string['courseavailable'] = '学生はこのコースを利用できる';
$string['courseavailablenot'] = '学生はこのコースを利用できない';
$string['coursebackup'] = 'コースバックアップ';
$string['coursebulkaction'] = '選択されたコースのバルク処理';
$string['coursecategories'] = 'コースカテゴリ';
$string['coursecategory'] = 'コースカテゴリ';
$string['coursecategory_help'] = 'この設定ではコース一覧内のコースが表示されるカテゴリを決定します。';
$string['coursecategorydeleted'] = 'コースカテゴリ {$a} を削除しました。';
$string['coursecatmanagement'] = 'コースおよびカテゴリ管理';
$string['coursecompletion'] = 'コース完了';
$string['coursecompletions'] = 'コース完了';
$string['coursecreators'] = 'コース作成者';
$string['coursecreatorsdescription'] = 'コース作成者は新しいコースを作成できます。';
$string['coursedeleted'] = 'コース {$a} を削除しました。';
$string['coursedetails'] = 'コース詳細';
$string['coursedisplay'] = 'コースレイアウト';
$string['coursedisplay_help'] = 'この設定では1ページにコース全体を表示するか、複数ページに分割するか決定します。';
$string['coursedisplay_multi'] = '1ページあたり1セクションを表示する';
$string['coursedisplay_single'] = '1ページにすべてのセクションを表示する';
$string['courseduration'] = 'コース継続期間';
$string['courseduration_desc'] = 'コース継続期間はデフォルトのコース終了日を計算するため使用されます。コース終了日はユーザのコース一覧に含むコースを決定するため使用されます。コース終了日はカスタムレポートにも使用できます。ユーザは終了日の後でもコースに入れます。';
$string['courseenddateenabled'] = 'デフォルトでコース終了日を有効にする';
$string['courseenddateenabled_desc'] = 'この設定では新しいコースのコース終了日をデフォルトで有効にしてコース継続期間より計算された日付を設定するか決定します。';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'レガシコースファイル';
$string['coursefilesedit'] = 'レガシコースファイルを編集する';
$string['coursefileswarning'] = 'コースファイルは廃止されました。';
$string['coursefileswarning_help'] = 'コースファイルはMoodle 2.0以降廃止されます。代わりに可能な限り外部リポジトリを使用してください。';
$string['courseformatdata'] = 'コースフォーマットデータ';
$string['courseformatoptions'] = '{$a} のフォーマットオプション';
$string['courseformats'] = 'コースフォーマット';
$string['courseformatudpate'] = 'フォーマットを更新する';
$string['coursegrades'] = 'コース評定';
$string['coursehelpcategory'] = 'コース一覧上にコースを配置することで学生がコースを探しやすくします。';
$string['coursehelpforce'] = 'コース内すべての活動でコースグループモードを強制します。';
$string['coursehelpformat'] = 'このフォーマットでコースメインページが表示されます。';
$string['coursehelphiddensections'] = 'コース内の非表示セクションを学生にどのように表示するか設定します。';
$string['coursehelpmaximumupload'] = 'このコースで学生がアップロードできる最大サイズを設定します。サイト全体の設定に制限されます。';
$string['coursehelpnewsitemsnumber'] = 'コースページの最新アナウンスメントブロック内に表示される最近のアナウンスメント数です。ゼロに設定した場合、アナウンスメントフォーラムは作成されません。';
$string['coursehelpnumberweeks'] = 'コース内のセクション数です (特定のコースフォーマットにのみ適用されます)。';
$string['coursehelpshowgrades'] = '評定表の表示を有効にします。個別の活動に関して評定の表示を抑制するものではありません。';
$string['coursehidden'] = '現在、学生はこのコースを利用できません。';
$string['courseinfo'] = 'コース情報';
$string['courselegacyfiles'] = 'レガシコースファイル';
$string['courselegacyfiles_help'] = 'コースファイルエリアはMoodle 1.9およびそれ以前のバージョンのために下位互換性を確保します。このファイルエリアのファイルすべてには (あなたがリンクするかどうかにかかわらず) コース参加者すべてがアクセスできます。また、これらのファイルがMoodle内のどこで使用されているか知る手段がありません。

あなたがこのファイルエリアをコースファイルの保存に使用する場合、多くのプライバシーおよびセキュリティ問題に自分を晒すことになります。同時にバックアップおよびコースインポートのファイル喪失、常にコンテンツの共有および再利用を経験することになります。そのため、あなたが何をしているのか本当に理解している場合以外、このエリアの使用はお勧めできません。';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'レガシコースファイル: {$a}';
$string['coursemessage'] = 'コースユーザにメッセージを送信する';
$string['coursenotaccessible'] = 'このコースはパブリックアクセスを許可していません。';
$string['courseoverview'] = 'コース概要';
$string['courseoverviewfiles'] = 'コースイメージ';
$string['courseoverviewfiles_help'] = 'コースイメージはダッシュボードのコース概要に表示されます。追加で許可されるファイルタイプおよび2つ以上のファイルはサイト管理者により有効にできます。その場合、これらのファイルはコースページ一覧のコース概要の隣に表示されます。';
$string['courseoverviewfilesext'] = 'コースイメージファイル拡張子';
$string['courseoverviewfileslimit'] = 'コースイメージファイル制限';
$string['courseoverviewgraph'] = 'コース概要グラフ';
$string['coursepreferences'] = 'コースプレファレンス';
$string['courseprofiles'] = 'コースプロファイル';
$string['coursereasonforrejecting'] = 'あなたがこのリクエストを拒否する理由';
$string['coursereasonforrejectingemail'] = 'これは申請者にメールで送信されます。';
$string['coursereject'] = 'コースリクエストを拒否する';
$string['courserejected'] = 'コースは拒否されて申請者に通知メールが送信されました。';
$string['courserejectemail'] = '申し訳ございません、あなたがリクエストしたコースは拒否されました。拒否理由は以下のとおりです:

{$a}';
$string['courserejectreason'] = 'あなたがこのコースを拒否する理由の概要<br />(この内容は申請者にメールで送信されます)';
$string['courserejectsubject'] = 'あなたのコースは拒否されました。';
$string['coursereport'] = 'コースレポート';
$string['coursereports'] = 'コースレポート';
$string['courserequest'] = 'コースリクエスト';
$string['courserequestdetails'] = 'あなたがリクエストしているコースの詳細';
$string['courserequestfailed'] = 'あなたのコースリクエストを何らかの理由で保存できませんでした。';
$string['courserequestintro'] = 'あなたのコース作成をリクエストをするにはこのフォームを使用してください。<br />コース開設の理由を管理者が理解して承認するために必要な情報を可能な限りく<br />多く入力してください。';
$string['courserequestreason'] = 'このコースを開設したい理由';
$string['courserequestsuccess'] = 'あなたのコースリクエストが正常に保存されました。あなたのリクエスト承認の可否に関するメールが送信されます。';
$string['courserequestsupport'] = '管理者がこのリクエストを判断するための支援情報';
$string['courserequestwarning'] = 'このコースをリクエストしたユーザは自動的に「 {$a} 」ロールが割り当てられた上で登録されます。';
$string['courserestore'] = 'コースリストア';
$string['courses'] = 'コース';
$string['coursesearch'] = 'コースを検索する';
$string['coursesearch_help'] = 'あなたは同時に複数の語句で検索できます。また、あなたの検索を次のように絞り込めます:

* 語句 : この語句がテキストの中に含まれるものを探します。
* +語句 : 厳密に語句に合致するもののみを検索します。
* -語句 : この語句を含まないものを検索をします。';
$string['coursesectionsummaries'] = 'コースセクション概要';
$string['coursesectiontitle'] = 'コース: {$a->course} - {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'コースデフォルト設定';
$string['coursesmovedout'] = '{$a} からコースを移動しました。';
$string['coursespending'] = '承認審査中コース';
$string['coursestart'] = 'コース開始';
$string['coursesummary'] = 'コース概要';
$string['coursesummary_help'] = 'コース概要はコース一覧に表示されます。コース検索ではコース名に加えてコース概要も検索対象とします。';
$string['coursetitle'] = 'コース: {$a->course}';
$string['courseupdates'] = 'コース更新内容';
$string['coursevisibility'] = 'コース可視性';
$string['coursevisibility_help'] = 'この設定ではコースがコース一覧に表示されて学生がアクセスできるかどうか決定します。非表示に設定された場合、非表示のコースを閲覧できるケイパビリティのあるユーザ (教師等) にアクセスが制限されます。';
$string['create'] = '作成';
$string['createaccount'] = '私の新しいアカウントを作成する';
$string['createcategory'] = 'カテゴリを作成する';
$string['createfolder'] = '{$a} にフォルダを作成する';
$string['createnew'] = '新しく作成する';
$string['createnewcategory'] = '新しいカテゴリを作成する';
$string['createnewcourse'] = '新しいコースを作成する';
$string['createnewsubcategory'] = '新しいサブカテゴリを作成する';
$string['createsubcategoryof'] = '{$a} のサブカテゴリを作成する';
$string['createuser'] = 'ユーザを作成する';
$string['createuserandpass'] = 'あなたのユーザ名およびパスワードを入力してください。';
$string['createziparchive'] = 'ZIPアーカイブを作成する';
$string['creatingblocks'] = 'ブロックの作成';
$string['creatingblocksroles'] = 'ブロックレベルのロール割り当ておよびオーバーライドの作成';
$string['creatingblogsinfo'] = 'ブログ情報の作成';
$string['creatingcategoriesandquestions'] = 'カテゴリおよび問題の作成';
$string['creatingcoursemodules'] = 'コースモジュールの作成';
$string['creatingcourseroles'] = 'コースレベルのロール割り当ておよびオーバーライドの作成';
$string['creatingevents'] = 'イベントの作成';
$string['creatinggradebook'] = '評定表の作成';
$string['creatinggroupings'] = 'グルーピングの作成';
$string['creatinggroupingsgroups'] = 'グルーピングへのグループの追加';
$string['creatinggroups'] = 'グループの作成';
$string['creatinglogentries'] = 'ログエントリの作成';
$string['creatingmessagesinfo'] = 'メッセージ情報の作成';
$string['creatingmodroles'] = 'モジュールレベルのロール割り当ておよびオーバーライドの作成';
$string['creatingnewcourse'] = '新しいコースの作成';
$string['creatingrolesdefinitions'] = 'ロール定義の作成';
$string['creatingscales'] = '評価尺度の作成';
$string['creatingsections'] = 'セクションの作成';
$string['creatingtemporarystructures'] = '一時構造の作成';
$string['creatinguserroles'] = 'ユーザレベルのロール割り当ておよびオーバーライドの作成';
$string['creatingusers'] = 'ユーザの作成';
$string['creatingxmlfile'] = 'XMLファイルの作成';
$string['currency'] = '通貨';
$string['currentcourse'] = '現在のコース';
$string['currentcourseadding'] = '現在のコース、データを追加する';
$string['currentcoursedeleting'] = '現在のコース、最初に削除する';
$string['currentlanguage'] = '現在の言語';
$string['currentlocaltime'] = 'あなたの現在のローカルタイム';
$string['currentlyselectedusers'] = '現在の選択済みユーザ';
$string['currentpicture'] = '現在の画像';
$string['currentrelease'] = '現在のリリース情報';
$string['currentversion'] = '現在のバージョン';
$string['databasechecking'] = 'Moodleデータベースをバージョン {$a->oldversion} から {$a->newversion} にアップグレードします。';
$string['databaseperformance'] = 'データベースパフォーマンス';
$string['databasesetup'] = 'データベース設定中';
$string['databasesuccess'] = 'データベースが正常にアップグレードされました。';
$string['databaseupgradebackups'] = '現在のバックアップバージョンは {$a} です。';
$string['databaseupgradeblocks'] = '現在のブロックバージョンは {$a} です。';
$string['databaseupgradegroups'] = '現在のグループバージョンは {$a} です。';
$string['databaseupgradelocal'] = '現在のローカルデータベースのカスタマイズバージョンは {$a} です。';
$string['databaseupgrades'] = 'データベースのアップグレード';
$string['dataformats'] = 'データフォーマット';
$string['date'] = '日付';
$string['datechanged'] = '開講日変更';
$string['datemostrecentfirst'] = '日付 - 新しいものを最初に';
$string['datemostrecentlast'] = '日付 - 新しいものを最後に';
$string['day'] = '日';
$string['days'] = '日';
$string['decodinginternallinks'] = '内部リンクのデコード';
$string['default'] = 'デフォルト';
$string['defaultcompetencescale'] = 'デフォルトコンピテンシ尺度';
$string['defaultcompetencescaledesc'] = '誰かが熟達度を示したかどうか関して、さらなる情報が存在しない二要素評価尺度です。';
$string['defaultcompetencescalenotproficient'] = 'コンピテント未達';
$string['defaultcompetencescaleproficient'] = 'コンピテント';
$string['defaultcoursestudent'] = '学生';
$string['defaultcoursestudentdescription'] = '通常、学生にはコース内でより少ない権限が割り当てられます。';
$string['defaultcoursestudents'] = '学生';
$string['defaultcoursesummary'] = 'このコースに関する簡潔で興味深い説明文をここに入力してください。';
$string['defaultcourseteacher'] = '教師';
$string['defaultcourseteacherdescription'] = '教師はコース内で活動の変更および学生の評定を含むどのような作業でも実施できます。';
$string['defaultcourseteachers'] = '教師';
$string['defaulteditor'] = 'デフォルトエディタ';
$string['defaulthomepageuser'] = 'ホームページ';
$string['defaulthomepageuser_help'] = 'あなたのホームページはナビゲーション内の最初のリンクです。';
$string['delete'] = '削除';
$string['deleteablock'] = 'ブロックを削除する';
$string['deleteall'] = 'すべてを削除する';
$string['deleteallcannotundo'] = 'すべてを削除する - 元に戻せません。';
$string['deleteallcomments'] = 'すべてのコメントを削除する';
$string['deleteallratings'] = 'すべての評価を削除する';
$string['deletecategory'] = 'カテゴリを削除する: {$a}';
$string['deletecategorycheck'] = '本当にこのカテゴリ<b>「 {$a} 」</b>を完全に削除してもよろしいですか? 親カテゴリがある場合、このカテゴリ内すべてのコースが親カテゴリに移動されます。親カテゴリがない場合、その他のカテゴリに移動されます。';
$string['deletecategorycheck2'] = 'このカテゴリを削除した場合、あなたはカテゴリが含むコースおよびサブカテゴリをどのようにするか選択する必要があります。';
$string['deletecategoryempty'] = 'このカテゴリは空です。';
$string['deletecheck'] = '{$a} を削除してもよろしいですか?';
$string['deletecheckfiles'] = '本当にこれらのファイルを削除してもよろしいですか?';
$string['deletecheckfull'] = '本当に登録、活動およびその他のユーザデータを含むユーザ {$a} を完全に削除してもよろしいですか?';
$string['deletechecktype'] = '本当にこの {$a->type} を削除してもよろしいですか?';
$string['deletechecktypename'] = '本当にこの {$a->type} 「 {$a->name} 」を削除してもよろしいですか?';
$string['deletecheckwarning'] = 'あなたはこれらのファイルを削除しようとしています';
$string['deletecommentbyon'] = '{$a->user} により {$a->time} に投稿されたコメントを削除する';
$string['deletecompletely'] = '完全に削除する';
$string['deletecourse'] = 'コースを削除する';
$string['deletecoursecheck'] = '本当にこのコースおよびコース内データすべてを完全に削除してもよろしいですか?';
$string['deleted'] = '削除完了';
$string['deletedactivity'] = '{$a} を削除しました。';
$string['deletedcourse'] = '{$a} が完全に削除されました。';
$string['deletednot'] = '{$a} を削除できませんでした!';
$string['deletepicture'] = '画像を削除する';
$string['deletesection'] = 'セクションを削除する';
$string['deleteselected'] = '選択したものを削除する';
$string['deleteselectedkey'] = '選択したキーを削除する';
$string['deletingcourse'] = '{$a} の削除';
$string['deletingexistingcoursedata'] = '既存のコースデータの削除';
$string['deletingolddata'] = '古いデータの削除';
$string['department'] = '部署';
$string['deprecatedeventname'] = '{$a} (使用中止)';
$string['desc'] = '降順';
$string['description'] = '説明';
$string['descriptiona'] = '説明: {$a}';
$string['deselectall'] = 'すべての選択を解除する';
$string['deselectnos'] = 'すべての「No」を選択解除する';
$string['detailedless'] = '一覧表示';
$string['detailedmore'] = '詳細表示';
$string['details'] = '詳細';
$string['digitalminor'] = 'デジタル未成年';
$string['digitalminor_desc'] = 'あなたの保護者が次の人に連絡するようにしてください:';
$string['directory'] = 'ディレクトリ';
$string['disable'] = '無効にする';
$string['disabledcomments'] = 'コメントは無効にされています。';
$string['dismissnotification'] = 'この通知を破棄する';
$string['displayingfirst'] = '最初の {$a->count} {$a->things} のみ表示されます。';
$string['displayingrecords'] = 'レコード {$a} 件を表示';
$string['displayingusers'] = 'ユーザを {$a->start} から {$a->end} まで表示';
$string['displayonpage'] = 'ページに表示する';
$string['dndcourse'] = 'あなたは並び順を変更または別カテゴリに移動するため、このコースをドラッグ＆ドロップできます。';
$string['dndenabled_inbox'] = 'あなたはファイルをここにドラッグ＆ドロップして追加できます。';
$string['dndnotsupported'] = 'ドラッグ＆ドロップアップロードはサポートされていません。';
$string['dndnotsupported_help'] = 'あなたのブラウザはドラッグ＆ドロップアップロードをサポートしていません。この機能はすべての最新バージョンのChrome、Firefox、SafariおよびInternet Explorer v10以上で利用できます。';
$string['dndnotsupported_insentence'] = 'ドラッグ＆ドロップはサポートされていません。';
$string['dnduploadwithoutcontent'] = 'このアップロードにはコンテンツが含まれていません。';
$string['dndworkingfile'] = 'ファイルをアップロードするにはコースセクションにドラッグ＆ドロップしてください。';
$string['dndworkingfilelink'] = 'ファイルまたはリンクをアップロードするにはコースセクションにドラッグ＆ドロップしてください。';
$string['dndworkingfiletext'] = 'ファイルまたはテキストをアップロードするにはコースセクションにドラッグ＆ドロップしてください。';
$string['dndworkingfiletextlink'] = 'ファイル、テキストまたはリンクをアップロードするにはコースセクションにドラッグ＆ドロップしてください。';
$string['dndworkinglink'] = 'リンクをアップロードするにはコースセクションにドラッグ＆ドロップしてください。';
$string['dndworkingtext'] = 'テキストをアップロードするにはコースセクションにドラッグ＆ドロップしてください。';
$string['dndworkingtextlink'] = 'テキストまたはリンクをアップロードするにはコースセクションにドラッグ＆ドロップしてください。';
$string['documentation'] = 'Moodleドキュメンテーション';
$string['dontsortcategories'] = 'カテゴリを並べ替えない';
$string['dontsortcourses'] = 'コースを並べ替えない';
$string['down'] = '下へ';
$string['download'] = 'ダウンロード';
$string['downloadall'] = 'すべてをダウンロードする';
$string['downloadexcel'] = 'Excelフォーマットでダウンロードする';
$string['downloadfile'] = 'ファイルをダウンロードする';
$string['downloadods'] = 'ODSフォーマットでダウンロードする';
$string['downloadtext'] = 'テキストフォーマットでダウンロードする';
$string['doyouagree'] = 'これらの要件を読んで理解できましたか?';
$string['droptoupload'] = 'アップロードするファイルをここにドロップする';
$string['duplicate'] = '複製';
$string['duplicatedmodule'] = '{$a} (コピー)';
$string['edhelpaspellpath'] = 'エディタでスペルチェックを利用するには<strong>aspell 0.50</strong>またはそれ以上をサーバにインストールしてください。また、aspellバイナリの正しいパスを指定する必要があります。Unix/Linuxシステムでは通常このパスは<strong>/usr/bin/aspell</strong>となりますが、他のパスになる場合もあります。';
$string['edhelpbgcolor'] = '編集領域の背景色を設定します。<br />正しい値の例: #FFFFFFまたはwhite';
$string['edhelpcleanword'] = 'ここではWord特有のフォーマットをフィルタするかどうか設定します。';
$string['edhelpenablespelling'] = 'ここではスペルチェックするかどうか設定します。有効にした場合、サーバに<strong>aspell</strong>をインストールする必要があります。2番目の設定値は<strong>デフォルト辞書</strong>です。aspellにユーザ言語辞書がない場合、この設定値が使用されます。';
$string['edhelpfontfamily'] = 'フォントファミリ属性はフォントファミリのリストおよび総称フォントファミリ名です。フォントファミリ名はカンマで区切ってください。';
$string['edhelpfontlist'] = 'エディタのドロップダウンメニューで使用されるフォントを設定します。';
$string['edhelpfontsize'] = 'ここではデフォルトのフォントサイズを設定します。<br />有効な設定値の例: medium, large, smaller, larger, 10pt, 11px';
$string['edit'] = '編集';
$string['edita'] = '{$a} を編集する';
$string['editcategorysettings'] = 'カテゴリ設定を編集する';
$string['editcategorythis'] = 'このカテゴリを編集する';
$string['editcoursesettings'] = 'コース設定を編集する';
$string['editfiles'] = 'ファイルを編集する';
$string['editgroupprofile'] = 'グループプロファイルを編集する';
$string['editinga'] = '{$a} の編集';
$string['editingteachershort'] = 'コース編集者';
$string['editlock'] = 'この値は編集できません!';
$string['editmyprofile'] = 'プロファイルを編集する';
$string['editorbgcolor'] = '背景色';
$string['editorcleanonpaste'] = 'ペースト時にWord HTMLを消去する';
$string['editorcommonsettings'] = '共通設定';
$string['editordefaultfont'] = 'デフォルトフォント';
$string['editorenablespelling'] = 'スペルチェックを有効にする';
$string['editorfontlist'] = 'フォントリスト';
$string['editorfontsize'] = 'デフォルトフォントサイズ';
$string['editorpreferences'] = 'エディタプレファレンス';
$string['editorresettodefaults'] = 'デフォルト値にリセットする';
$string['editorsettings'] = 'エディタ設定';
$string['editorshortcutkeys'] = 'エディタショートカットキー';
$string['editsection'] = 'セクションを編集する';
$string['editsectionname'] = 'セクション名を編集する';
$string['editsettings'] = '設定を編集する';
$string['editsummary'] = '概要を編集する';
$string['editthisactivity'] = 'この活動を編集する';
$string['editthiscategory'] = 'このカテゴリを編集する';
$string['edittitle'] = 'タイトルを編集する';
$string['edittitleinstructions'] = 'Escape=キャンセル / Enter=終了';
$string['edituser'] = 'ユーザアカウントを編集する';
$string['edulevel'] = 'すべてのイベント';
$string['edulevel_help'] = '* 教える - 教師により実行されるアクションです。例) リソースをアップロードする
* 参加する - 学生により実行されるアクションです。例) フォーラムに投稿する
* その他 - 教師および学生以外のロールのユーザにより実行されるアクションです。';
$string['edulevelother'] = 'その他';
$string['edulevelparticipating'] = '参加する';
$string['edulevelteacher'] = '教える';
$string['email'] = 'メールアドレス';
$string['emailactive'] = 'メール有効化';
$string['emailagain'] = 'メールアドレス (もう一度)';
$string['emailalreadysent'] = 'パスワードリセットメールはすでに送信されています。あなたのメールを確認してください。';
$string['emailcharset'] = 'メール文字コード';
$string['emailconfirm'] = 'アカウントの確定';
$string['emailconfirmation'] = '「 {$a->sitename} 」であなたのメールアドレスによる新しいアカウントの作成が依頼されました。

あなたの新しいアカウントを確定するには以下のウェブアドレスにアクセスしてください:

{$a->link}

ほとんどのメールプログラムではあなたがクリックできる青いリンクとして表示されています。クリックできない場合、あなたのウェブブラウザウィンドウ上部のアドレス欄にアドレスをコピー＆ペーストしてください。

分からないことがある場合、サイト管理者にご連絡ください。
{$a->admin}';
$string['emailconfirmationresend'] = '確認メールを再送する';
$string['emailconfirmationsubject'] = '{$a}: アカウントの確定';
$string['emailconfirmsent'] = '<p>あなたの <b>{$a}</b> のメールアドレス宛にメールが送信されました。</p>
<p>あなたの登録を確認するための簡単な説明がメールに記載されています。</p>
<p>分からないことがある場合、サイト管理者にご連絡ください。</p>';
$string['emailconfirmsentfailure'] = '確認メールの送信に失敗しました。';
$string['emailconfirmsentsuccess'] = '確認メールが正常に送信されました。';
$string['emaildigest'] = 'メール要約タイプ';
$string['emaildigest_help'] = 'これはフォーラムにデフォルトとして使用される日次要約設定です。

* 要約なし - あなたはフォーラム投稿ごとに1通のメールを受信します。
* 要約 - 投稿すべて - あなたはそれぞれのフォーラム投稿すべてのコンテンツを含むメール要約を1日1通受信します。
* 要約 - 件名のみ - あなたはそれぞれのフォーラム投稿の件名を含むメールダイジェストを1日1通受信します。

必要であれば、あなたはそれぞれのフォーラムで異なる設定を選択することもできます。';
$string['emaildigestcomplete'] = 'すべて (投稿すべてを含む日次メール)';
$string['emaildigestoff'] = '要約なし (フォーラム投稿ごとのメール)';
$string['emaildigestsubjects'] = '件名 (件名のみを含む日次メール)';
$string['emaildisable'] = 'このメールアドレスは無効です';
$string['emaildisableclick'] = 'このメールアドレス宛にすべてのメールが送信されないようにする';
$string['emaildisplay'] = 'メールアドレス公開';
$string['emaildisplay_help'] = '権限のあるユーザ (教師およびマネージャ等) は常にあなたのメールアドレスを閲覧することができます。';
$string['emaildisplaycourse'] = '同じコースのメンバにだけ私のメールアドレスを公開します';
$string['emaildisplayhidden'] = 'メールアドレス非表示';
$string['emaildisplayno'] = '権限のないユーザから私のメールアドレスを隠します';
$string['emaildisplayyes'] = 'すべてのユーザに私のメールアドレスを公開します';
$string['emailenable'] = 'このメールアドレスは有効です';
$string['emailenableclick'] = 'このメールアドレスにメールすべてが再度送信されるようにする';
$string['emailexists'] = 'このメールアドレスはすでに使用されています。';
$string['emailexistshintlink'] = '忘れたユーザ名またはパスワードを回復する';
$string['emailexistssignuphint'] = '恐らく過去にアカウントを作成しませんでしたか? {$a}';
$string['emailformat'] = 'メールフォーマット';
$string['emailmustbereal'] = '注意：メールアドレスは実際に使えるアドレスを入力してください。';
$string['emailnotallowed'] = 'これらのドメインのメールアドレスは許可されていません ({$a})';
$string['emailnotfound'] = 'データベース内にメールアドレスが見つかりませんでした。';
$string['emailonlyallowed'] = 'このメールアドレスは許可されている次のドメインに入っていません ({$a})';
$string['emailpasswordchangeinfo'] = '{$a->firstname} さん

「 {$a->sitename} 」 のあなたのアカウント「 {$a->username} 」へ新しいパスワードのリクエストがありました。

パスワードを変更するには以下のウェブアドレスにアクセスしてください:

{$a->link}

クリックできない場合、ウェブブラウザウィンドウのアドレス欄にアドレスをコピー＆ペーストしてください。

分からないことがある場合、サイト管理者 ( {$a->admin}) にご連絡ください。';
$string['emailpasswordchangeinfodisabled'] = 'こんにちは {$a->firstname} さん

「 {$a->sitename} 」のあなたのアカウントへ新しいパスワードのリクエストがありました。

申し訳ありませんが、このサイトであなたのアカウントは無効にされているため、パスワードをリセットすることができません。サイト管理者 {$a->admin} にご連絡ください。';
$string['emailpasswordchangeinfofail'] = 'こんにちは {$a->firstname} さん

「 {$a->sitename} 」のあなたのアカウントへ新しいパスワードのリクエストがありました。

申し訳ありませんが、このサイトではパスワードをリセットすることができません。サイト管理者 {$a->admin} にご連絡ください。';
$string['emailpasswordchangeinfosubject'] = '{$a}: パスワード変更情報';
$string['emailpasswordconfirmation'] = '{$a->firstname} さん

「 {$a->sitename} 」 のあなたのアカウントへ新しいパスワードのリクエストがありました。

新しいパスワードリクエストを確認して、新たなパスワードをメールであなた宛に送信するために以下のページをご覧ください:

{$a->link}

上のリンクがクリックできない場合、ウェブブラウザウィンドウのアドレス欄にアドレスをコピー＆ペーストしてください。

分からないことがある場合、サイト管理者 ( {$a->admin}) にご連絡ください。';
$string['emailpasswordconfirmationsubject'] = '{$a}: パスワード変更確認';
$string['emailpasswordconfirmmaybesent'] = '<p>正しいユーザ名またはユニークなメールアドレスを入力した場合、あなたにメールが送信されているはずです。</p>
<p>送信されたメールにはパスワードの変更を確認および完了するための簡単な説明が記載されています。パスワード変更作業が難しい場合、サイト管理者にご連絡ください。</p>';
$string['emailpasswordconfirmnoemail'] = '<p>あなたが選択したユーザアカウントには記録されたメールアドレスがありません。</p>
<p>サイト管理者にご連絡ください。</p>';
$string['emailpasswordconfirmnotsent'] = '<p>あなたが提供したユーザ詳細では既存のユーザアカウントを特定できません。</p>
<p>あなたが入力した情報を確認して再度お試しください。問題が持続する場合、サイト管理者にご連絡ください。</p>';
$string['emailpasswordconfirmsent'] = 'あなたの <b>{$a}</b> のメールアドレス宛にメールが送信されました。
<br />このパスワード変更に関して、確認および完了のための簡単な説明が記載されています。分からない場合、サイト管理者にご連絡ください。';
$string['emailpasswordsent'] = 'パスワードの変更確認ありがとうございます。
<p>新しいパスワードが記載されたメールがあなたのメールアドレス<br /><b>{$a->email}</b>に送信されました。<br />新しいパスワードは自動的に生成されたものです - <a href="{$a->link}">パスワードの変更</a> で覚えやすいものに変更できます。';
$string['emailresetconfirmation'] = '{$a->lastname} さん

{$a->sitename} において、あなたのアカウント「 {$a->username} 」のパスワードリセットがリクエストされました。

このリクエストを確認して、あなたのアカウントに新しいパスワードを設定するため、以下のウェブサイトにアクセスしてください:

{$a->link}
(このリンクは最初にリセットがリクエストされてから {$a->resetminutes} 分間有効です)

あなたからこのパスワードリセットがリクエストされていない場合、作業は不要です。

分からないことがある場合、サイト管理者 {$a->admin} にご連絡ください。';
$string['emailresetconfirmationsubject'] = '{$a}: パスワードリセットリクエスト';
$string['emailresetconfirmsent'] = 'あなたの <b>{$a}</b> のメールアドレス宛にメールが送信されました。
<br />このパスワード変更に関して、確認および完了のための簡単な説明が記載されています。分からない場合、サイト管理者にご連絡ください。';
$string['emailstop'] = '通知を無効にする';
$string['emailtoprivatefiles'] = 'あなたのプライベートファイルスペースに直接ファイルを添付としてメール送信することができます。あなたのファイルをメールに添付して、 {$a} に送信してください。';
$string['emailtoprivatefilesdenied'] = 'あなたの管理者はあなたのプライベートファイルをアップロードするオプションを無効にしています。';
$string['emailuserhasnone'] = 'ユーザのメールアドレスがありません。';
$string['emailvia'] = '{$a->name} ({$a->siteshortname})';
$string['emojicategoryactivities'] = '活動';
$string['emojicategoryanimalsnature'] = '動物 & 自然';
$string['emojicategoryflags'] = '旗';
$string['emojicategoryfooddrink'] = 'フード & ドリンク';
$string['emojicategoryobjects'] = '物';
$string['emojicategoryrecent'] = '最近';
$string['emojicategorysmileyspeople'] = 'スマイリー & 人';
$string['emojicategorysymbols'] = '記号';
$string['emojicategorytravelplaces'] = '旅行 & 場所';
$string['emptydragdropregion'] = '空白リージョン';
$string['enable'] = '有効にする';
$string['encryptedcode'] = '暗号化コード';
$string['enddate'] = 'コース終了日';
$string['enddate_help'] = 'コース終了日はユーザのコース一覧に含むコースを決定するため使用されます。終了日を過ぎた場合、コースはナビゲーションに表示されず過去のコースとしてコース概要に記載されます。コース終了日はカスタムレポートにも使用することができます。ユーザは終了日の後でもコースに入ることができます。言い換えれば日付はコースアクセスを制限することはありません。';
$string['english'] = '英語';
$string['enrolmentmethods'] = '登録方法';
$string['entercourse'] = 'このコースに入るにはクリックしてください。';
$string['enteremail'] = 'あなたのメールアドレスを入力してください。';
$string['enteremailaddress'] = 'パスワードをリセットして新しいパスワードをメール経由で送信するため、あなたのメールアドレスを入力してください。';
$string['enterusername'] = 'あなたのユーザ名を入力してください。';
$string['entries'] = 'エントリ';
$string['error'] = 'エラー';
$string['errorcreatingactivity'] = '活動「 {$a} 」のインスタンスを作成することができません。';
$string['errorfiletoobig'] = 'ファイルサイズが制限の {$a} バイトを超えています。';
$string['errornouploadrepo'] = 'このサイトで有効にされているアップロードリポジトリはありません。';
$string['errorwhenconfirming'] = 'エラーが発生したため、あなたのアカウントは認証されませんでした。メール本文のリンクをクリックして、このページにたどり着いた場合、リンクが記されている行が崩れていないか確認してください。正しくリンクを動作させるためにコピー＆ペーストを使用してください。';
$string['eventcommentcreated'] = 'コメントが作成されました。';
$string['eventcommentdeleted'] = 'コメントが削除されました。';
$string['eventcommentsviewed'] = 'コメントが閲覧されました。';
$string['eventconfiglogcreated'] = '設定ログが作成されました。';
$string['eventcontentviewed'] = 'コンテンツが閲覧されました。';
$string['eventcoursebackupcreated'] = 'コースバックアップが作成されました。';
$string['eventcoursecategorycreated'] = 'カテゴリが作成されました。';
$string['eventcoursecategorydeleted'] = 'カテゴリが削除されました。';
$string['eventcoursecategoryupdated'] = 'カテゴリが更新されました。';
$string['eventcoursecategoryviewed'] = 'カテゴリが閲覧されました。';
$string['eventcoursecontentdeleted'] = 'コースコンテンツが削除されました。';
$string['eventcoursecreated'] = 'コースが作成されました。';
$string['eventcoursedeleted'] = 'コースが削除されました。';
$string['eventcourseinformationviewed'] = 'コース概要が閲覧されました。';
$string['eventcoursemodulecreated'] = 'コースモジュールが作成されました。';
$string['eventcoursemoduledeleted'] = 'コースモジュールが削除されました。';
$string['eventcoursemoduleinstancelistviewed'] = 'コースモジュールインスタンス一覧が閲覧されました。';
$string['eventcoursemoduleupdated'] = 'コースモジュールが更新されました。';
$string['eventcoursemoduleviewed'] = 'コースモジュールが閲覧されました。';
$string['eventcourseresetended'] = 'コースリセットが終了しました。';
$string['eventcourseresetstarted'] = 'コースリセットが開始しました。';
$string['eventcourserestored'] = 'コースがリストアされました。';
$string['eventcoursesectioncreated'] = 'コースセクションが作成されました。';
$string['eventcoursesectiondeleted'] = 'コースセクションが削除されました。';
$string['eventcoursesectionupdated'] = 'コースセクションが更新されました。';
$string['eventcoursessearched'] = 'コースが検索されました。';
$string['eventcourseupdated'] = 'コースが更新されました。';
$string['eventcourseuserreportviewed'] = 'コースユーザレポートが閲覧されました。';
$string['eventcourseviewed'] = 'コースが閲覧されました。';
$string['eventdashboardreset'] = 'ダッシュボードがリセットされました。';
$string['eventdashboardsreset'] = 'ダッシュボードがリセットされました。';
$string['eventdashboardviewed'] = 'ダッシュボードが閲覧されました。';
$string['eventdatabasetextfieldcontentreplaced'] = 'データベースグローバル検索および置換';
$string['eventemailfailed'] = 'メール送信に失敗しました。';
$string['eventname'] = 'イベント名';
$string['eventrecentactivityviewed'] = '最近の活動が閲覧されました。';
$string['eventsearchindexed'] = '検索データがインデックス化されました。';
$string['eventsearchresultsviewed'] = '検索結果が閲覧されました。';
$string['eventunknownlogged'] = '不明なイベント';
$string['eventusercreated'] = 'ユーザが作成されました。';
$string['eventuserdeleted'] = 'ユーザが削除されました。';
$string['eventuserfeedbackgiven'] = 'フィードバックリンクがクリックされました。';
$string['eventuserfeedbackremind'] = '「私に後で知らせて」フィードバックリンクがクリックされました。';
$string['eventuserinfocategorycreated'] = 'ユーザプロファイルフィールドカテゴリが作成されました。';
$string['eventuserinfocategorydeleted'] = 'ユーザプロファイルフィールドカテゴリが削除されました。';
$string['eventuserinfocategoryupdated'] = 'ユーザプロファイルフィールドカテゴリが更新されました。';
$string['eventuserinfofieldcreated'] = 'ユーザプロファイルフィールドが作成されました。';
$string['eventuserinfofielddeleted'] = 'ユーザプロファイルフィールドが削除されました。';
$string['eventuserinfofieldupdated'] = 'ユーザプロファイルフィールドが更新されました。';
$string['eventuserlistviewed'] = 'ユーザ一覧が閲覧されました。';
$string['eventuserloggedout'] = 'ユーザがログアウトしました。';
$string['eventuserpasswordpolicyfailed'] = 'ユーザパスワードがパスワードポリシーに合致しませんでした。';
$string['eventuserpasswordupdated'] = 'ユーザパスワードが更新されました。';
$string['eventuserprofileviewed'] = 'ユーザプロファイルが閲覧されました。';
$string['eventuserupdated'] = 'ユーザが更新されました。';
$string['everybody'] = '全員';
$string['executeat'] = 'バックアップ処理開始時刻';
$string['existing'] = '既存';
$string['existingadmins'] = '管理者一覧';
$string['existingcourse'] = '既存のコース';
$string['existingcourseadding'] = '既存のコース、既存のコースにデータを追加する';
$string['existingcoursedeleting'] = '既存のコース、最初に既存のコースを削除する';
$string['existingcreators'] = '既存のコース作成者';
$string['existingstudents'] = '登録済み学生';
$string['existingteachers'] = '教師一覧';
$string['expand'] = '展開する';
$string['expandall'] = 'すべてを展開する';
$string['expandcategory'] = '{$a} を展開する';
$string['explanation'] = '説明';
$string['explanationdigitalminor'] = 'この情報はあなたの年齢がデジタル許可年齢以上であることを確認するため必要です。これは個人が利用条件および自分のデータが合法的に保存および処理されることに同意できる年齢です。';
$string['extendperiod'] = '延長期間';
$string['extendsession'] = 'セッションを延長する';
$string['failedloginattempts'] = 'あなたの最終ログインより {$a->attempts} 回のログイン失敗がありました。';
$string['favourites'] = '星付き';
$string['feedback'] = 'フィードバック';
$string['file'] = 'ファイル';
$string['fileexists'] = 'ファイル名「 {$a} 」のファイルはすでに存在します。';
$string['filemissing'] = '{$a} が見つかりません。';
$string['filereaderror'] = 'ファイル「 {$a} 」を読み込めません。これが本当にフォルダではなくファイルであることを確認してください。';
$string['files'] = 'ファイル';
$string['filesanduploads'] = 'ファイルおよびアップロード';
$string['filesfolders'] = 'ファイル/フォルダ';
$string['fileuploadwithcontent'] = 'ファイルアップロードにコンテンツパラメータは含めません。';
$string['filloutallfields'] = 'このフォームのフィールドすべてに入力してください。';
$string['filter'] = 'フィルタ';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filters'] = 'フィルタ';
$string['findmorecourses'] = 'さらにコースを探す ...';
$string['first'] = '最初';
$string['firstaccess'] = '初回アクセス';
$string['firstname'] = '名';
$string['firstnamephonetic'] = '名 - ヨミガナ';
$string['firstpage'] = '最初のページ';
$string['firstsiteaccess'] = 'サイトへの最初のアクセス';
$string['firsttime'] = 'はじめての方ですか?';
$string['folder'] = 'フォルダ';
$string['folderclosed'] = 'クローズフォルダ';
$string['folderopened'] = 'オープンフォルダ';
$string['followingoptional'] = '以下の項目は任意入力です。';
$string['followingrequired'] = '以下の項目は必須入力です。';
$string['for'] = '-';
$string['force'] = '強制';
$string['forcelanguage'] = '言語の強制';
$string['forceno'] = '強制しない';
$string['forcepasswordchange'] = 'パスワード変更を強制する';
$string['forcepasswordchange_help'] = 'この設定を有効にした場合、次回ログイン時、ユーザにパスワードの変更を促します。';
$string['forcepasswordchangecheckfull'] = '本当に {$a} にパスワードの変更を強制してもよろしいですか?';
$string['forcepasswordchangenot'] = '{$a} のパスワード変更を強制できませんでした。';
$string['forcepasswordchangenotice'] = '続けるにはパスワードを変更してください。';
$string['forcepasswordresetfailurenotice'] = 'あなたの現在のパスワードは設定されたパスワードポリシーに合致しないようになりました。サポートが必要な場合、あなたのMoodle管理者にご連絡ください。
{$a}';
$string['forcepasswordresetnotice'] = 'あなたの現在のパスワードは設定されたパスワードポリシーに合致しないようになりました。ログインするにはあなたのパスワードをリセットする必要があります。
{$a}';
$string['forcetheme'] = 'テーマを強制する';
$string['forgotaccount'] = 'パスワードを忘れましたか?';
$string['forgotten'] = 'あなたのユーザ名またはパスワードを忘れましたか?';
$string['forgottenduplicate'] = 'メールアドレスが複数のアカウントにより共有されています。代わりにユーザ名を入力してください。';
$string['forgotteninvalidurl'] = 'パスワードリセットのURLが正しくありません。';
$string['format'] = 'フォーマット';
$string['format_help'] = 'コースフォーマットではコースページのレイアウトを決定します。

* 単一活動フォーマット - コースページに単一の活動またはリース (小テストまたはSCORM パッケージ等) が表示されます。
* ソーシャルフォーマット - コースページにフォーラムが表示されます。
* トピックフォーマット - コースページはトピックセクションにより構成されます。
* ウィークリーフォーマット - 最初の週がコース開始日となるようコースページはウィークリーセクションにより構成されます。';
$string['formathtml'] = 'HTMLフォーマット';
$string['formatmarkdown'] = 'Markdownフォーマット';
$string['formatplain'] = 'プレインテキストフォーマット';
$string['formattext'] = 'Moodleオートフォーマット';
$string['formattexttype'] = 'フォーマット';
$string['forumpreferences'] = 'フォーラムプレファレンス';
$string['framesetinfo'] = 'このフレームセットのドキュメント:';
$string['from'] = 'From';
$string['frontpagecategorycombo'] = 'コンボリスト';
$string['frontpagecategorynames'] = 'カテゴリ一覧';
$string['frontpagecourselist'] = 'コース一覧';
$string['frontpagecoursesearch'] = 'コース検索ボックス';
$string['frontpagedescription'] = 'フロントページ概要';
$string['frontpagedescriptionhelp'] = 'この概要は「コース/サイト概要」ブロックを使用してフロントページに表示できます。';
$string['frontpageenrolledcourselist'] = '登録済みコース';
$string['frontpageformat'] = 'フロントページフォーマット';
$string['frontpageformatloggedin'] = 'フロントページフォーマット (ログイン後)';
$string['frontpagenews'] = 'アナウンスメント';
$string['frontpagesettings'] = 'フロントページ設定';
$string['fulllistofcourses'] = 'すべてのコース';
$string['fullname'] = 'フルネーム';
$string['fullnamecourse'] = '長いコース名';
$string['fullnamecourse_help'] = '長いコース名はコースページ内トップおよびコース一覧に表示されます。';
$string['fullnamedisplay'] = '{$a->lastname} {$a->firstname}';
$string['fullnameuser'] = 'ユーザフルネーム';
$string['fullprofile'] = 'プロファイル詳細';
$string['fullsitename'] = '長いサイト名';
$string['functiondisabled'] = 'この機能は現在無効にされています。';
$string['general'] = '一般';
$string['geolocation'] = '緯度 - 経度';
$string['gettheselogs'] = 'これらのログを取得する';
$string['go'] = 'Go';
$string['gpl'] = 'Copyright (C) 1999 onwards Martin Dougiamas (https://moodle.com)

このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア財団によって発行された GNU 一般公衆利用許諾契約書 (バージョン2か、希望によってはそれ以降のバージョンのうちどれか) の定める条件の下で再頒布または改変することができます。

このプログラムは有用であることを願って頒布されますが、*全くの無保証*です。商業可能性の保証や特定の目的への適合性は言外に示されたものも含め全く存在しません。

詳細はMoodleライセンス情報をご覧ください: https://docs.moodle.org/ja/%E3%83%A9%E3%82%A4%E3%82%BB%E3%83%B3%E3%82%B9';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (https://moodle.com)

このプログラムはフリーソフトウェアです。あなたはこれをフリーソフトウェア財団によって発行された GNU 一般公衆利用許諾契約書 (バージョン2か、希望によってはそれ以降のバージョンのうちどれか) の定める条件の下で再頒布または改変することができます。

このプログラムは有用であることを願って頒布されますが*全くの無保証*です。商業可能性の保証や特定の目的への適合性は言外に示されたものも含め全く存在しません。

詳細はMoodleライセンス情報をご覧ください: https://docs.moodle.org/ja/%E3%83%A9%E3%82%A4%E3%82%BB%E3%83%B3%E3%82%B9';
$string['gpllicense'] = 'GPLライセンス';
$string['grade'] = '評点';
$string['grades'] = '評定';
$string['gravatarenabled'] = 'このサイトでは<a href="https://www.gravatar.com/">Gravatar</a>が有効にされています。あなたがプロファイル画像をアップロードしていない場合、MoodleはGravatarよりプロファイル画像の取得を試みます。';
$string['group'] = 'グループ';
$string['groupadd'] = '新しいグループを追加する';
$string['groupaddusers'] = '選択した人をグループに追加する';
$string['groupfor'] = 'グループ';
$string['groupinfo'] = '選択したグループの情報';
$string['groupinfoedit'] = 'グループ設定を編集する';
$string['groupinfomembers'] = '選択したメンバの情報';
$string['groupinfopeople'] = '選択したユーザの情報';
$string['groupmembers'] = 'グループメンバ';
$string['groupmemberssee'] = 'グループメンバを表示する';
$string['groupmembersselected'] = '選択したグループのメンバ';
$string['groupmode'] = 'グループモード';
$string['groupmodeforce'] = '強制グループモード';
$string['groupmy'] = 'マイグループ';
$string['groupnonmembers'] = 'グループに属さないユーザ';
$string['groupnotamember'] = '申し訳ございません、あなたはグループのメンバではありません。';
$string['grouprandomassign'] = 'すべてをランダムにグループに割り当てる';
$string['groupremove'] = '選択したグループを削除する';
$string['groupremovemembers'] = '選択したメンバを削除する';
$string['groups'] = 'グループ';
$string['groupsnone'] = 'グループなし';
$string['groupsseparate'] = '分離グループ';
$string['groupsvisible'] = '可視グループ';
$string['guest'] = 'ゲスト';
$string['guestdescription'] = 'ゲストには最小限の権限があり、通常どの場所でもテキストを入力することはできません。';
$string['guestskey'] = '登録キーを持っているゲストを許可する';
$string['guestsno'] = 'ゲストを許可しない';
$string['guestsnotallowed'] = '申し訳ございません、「 {$a} 」ではゲストでの入室は許可されていません。';
$string['guestsyes'] = '登録キーを持っていないゲストを許可する';
$string['guestuser'] = 'ゲストユーザ';
$string['guestuserinfo'] = 'このユーザはいくつかのコースに閲覧のみ許可された特別ユーザです。';
$string['help'] = 'ヘルプ';
$string['helpprefix2'] = '{$a} のヘルプ';
$string['helpwiththis'] = 'この内容に関するヘルプ';
$string['hiddenassign'] = '割り当て非表示';
$string['hiddenfromstudents'] = '学生から秘匿';
$string['hiddenoncoursepage'] = '利用可能、しかしコースページに表示しない';
$string['hiddensections'] = '非表示セクション';
$string['hiddensections_help'] = 'ここでは学生に非表示セクションを折りたたんだ形で (恐らくウィークリーフォーマットのコースで休日を示すため) 表示するか完全に隠すか指定します。';
$string['hiddensectionscollapsed'] = '非表示コースセクションを折りたたんで表示する';
$string['hiddensectionsinvisible'] = '非表示セクションを完全に見えなくする';
$string['hiddenwithbrackets'] = '(非表示)';
$string['hide'] = '非表示';
$string['hideadvancedsettings'] = '高度な設定を隠す';
$string['hidechartdata'] = 'チャートデータを隠す';
$string['hidefromstudents'] = '学生から隠す';
$string['hideoncoursepage'] = 'コースページに表示せずに利用可能にする';
$string['hidepicture'] = '画像を隠す';
$string['hidepopoverwindow'] = 'ポップオーバーウィンドウを隠す';
$string['hidesection'] = 'セクション {$a} を隠す';
$string['hidesettings'] = '設定を隠す';
$string['hideshowblocks'] = 'ブロックを隠す、または表示する';
$string['highlight'] = 'ハイライト';
$string['highlightoff'] = 'ハイライトを削除する';
$string['hits'] = 'アクセス';
$string['hitsoncourse'] = 'アクセス状況 - コース: {$a->coursename} / ユーザ: {$a->username}';
$string['hitsoncoursetoday'] = '本日のアクセス状況 - コース: {$a->coursename} / ユーザ: {$a->username}';
$string['home'] = 'Home';
$string['hour'] = '時間';
$string['hours'] = '時間';
$string['howtomakethemes'] = '新しいテーマの作り方';
$string['htmleditor'] = 'HTMLエディタを使用します';
$string['htmleditoravailable'] = 'HTMLエディタは利用可能です';
$string['htmleditordisabled'] = 'あなたのユーザプロファイルではHTMLエディタの使用が禁止されています。';
$string['htmleditordisabledadmin'] = '管理者がサイトでのHTMLエディタの使用を禁止しています。';
$string['htmleditordisabledbrowser'] = 'あなたのブラウザの互換性がないため、HTMLエディタを使用できません。';
$string['htmlfilesonly'] = 'HTMLファイルのみ';
$string['htmlformat'] = 'HTMLフォーマット';
$string['icon'] = 'アイコン';
$string['icqnumber'] = 'ICQナンバー';
$string['idnumber'] = 'IDナンバー';
$string['idnumbercourse'] = 'コースIDナンバー';
$string['idnumbercourse_help'] = 'コースIDナンバーは外部のシステムのコースとマッチングする場合にのみ使用され、サイト内のどこにも表示されることはありません。このコースに関する公式のコードがある場合はここに入力してください。それ以外は空白のままにできます。';
$string['idnumbercoursecategory'] = 'カテゴリIDナンバー';
$string['idnumbercoursecategory_help'] = 'コースカテゴリのIDナンバーは外部のシステムのカテゴリとマッチングする場合にのみ使用されます。また、サイト内のどこにも表示されることはありません。このカテゴリに関する公式のコード名がある場合はここに入力してください。そうでない場合、フィールドを空白のままにできます。';
$string['idnumbergroup'] = 'グループIDナンバー';
$string['idnumbergroup_help'] = 'グループのIDナンバーは外部のシステムのコースとマッチングする場合にのみ使用されます。また、サイト内のどこにも表示されることはありません。このグループに関する公式のコード名がある場合はここに入力してください。そうでない場合、フィールドを空白のままにできます。';
$string['idnumbergrouping'] = 'グルーピングIDナンバー';
$string['idnumbergrouping_help'] = 'グルーピングのIDナンバーは外部のシステムのコースとマッチングする場合にのみ使用されます。また、サイト内のどこにも表示されることはありません。このグルーピングに関する公式のコード名がある場合はここに入力してください。そうでない場合、フィールドを空白のままにできます。';
$string['idnumbermod'] = 'IDナンバー';
$string['idnumbermod_help'] = 'IDナンバーを設定することで評定計算またはカスタムレポートのために活動またはリソースを識別する手段を提供します。そうでない場合、フィールドを空白のままにできます。

IDナンバーは活動設定ページでのみ編集できますが評定可能な活動では評定表でも設定できます。';
$string['idnumbertaken'] = 'このIDナンバーはすでに取得されています。';
$string['imagealt'] = '画像説明';
$string['import'] = 'インポート';
$string['importdata'] = 'コースデータをインポートする';
$string['importdataexported'] = 'コースデータのエクスポートが完了しました。<br /> 続けてあなたのコースにインポートします。';
$string['importdatafinished'] = 'インポートが完了しました! あなたのコースに移動します。';
$string['importdatafrom'] = 'データをインポートするコースを探す:';
$string['inactive'] = '停止';
$string['include'] = 'バックアップ';
$string['includeallusers'] = 'すべてのユーザを含む';
$string['includecoursefiles'] = 'コースファイルを含む';
$string['includecourseusers'] = 'コースユーザを含む';
$string['included'] = 'バックアップ済';
$string['includelogentries'] = 'ログエントリを含む';
$string['includemodules'] = 'モジュールを含む';
$string['includemoduleuserdata'] = 'モジュールユーザデータを含む';
$string['includeneededusers'] = '必要なユーザを含む';
$string['includenoneusers'] = 'ユーザを含まない';
$string['includeroleassignments'] = 'ロール割り当てを含む';
$string['includesitefiles'] = 'このコースで使用されているサイトファイルを含む';
$string['includeuserfiles'] = 'ユーザファイルを含む';
$string['increasesections'] = 'セクション数を増やす';
$string['indicator:accessesafterend'] = '終了日以降のコースアクセス';
$string['indicator:accessesafterend_help'] = 'この指標はコース終了日以降の学生によるコースアクセスを示します。';
$string['indicator:accessesbeforestart'] = '開始日前のコースアクセス';
$string['indicator:accessesbeforestart_help'] = 'この指標はコース開始日以前の学生によるコースアクセスを示します。';
$string['indicator:activitiesdue'] = '活動期限';
$string['indicator:activitiesdue_help'] = 'ユーザに活動期限があります。';
$string['indicator:anycourseaccess'] = 'すべてのコースアクセス';
$string['indicator:anycourseaccess_help'] = 'この指標はユーザが登録されているすべてのコースへのアクセスを反映します。';
$string['indicator:anywrite'] = 'すべての書く動作';
$string['indicator:anywrite_help'] = 'この指標は学生による執筆 (送信) 活動を示します。';
$string['indicator:anywriteincourse'] = 'コースにおけるすべての執筆活動';
$string['indicator:anywriteincourse_help'] = 'この指標はすべてのコースにおける学生による執筆 (送信) 活動を示します。';
$string['indicator:completeduserprofile'] = 'ユーザプロファイル完了';
$string['indicator:completeduserprofile_help'] = 'この指標は学生がユーザプロファイルを完了したことを示します。';
$string['indicator:completeduserprofiledef'] = 'ユーザプロファイル完了';
$string['indicator:completeduserprofiledef_help'] = 'サイトポリシーに同意してユーザが次のフィールドを入力した場合: 所属組織, 部署, 住所, 都道府県, 国, URL';
$string['indicator:completionenabled'] = '完了トラッキング有効';
$string['indicator:completionenabled_help'] = 'この指標はこのコースで完了トラッキングが有効にされたことを示します。';
$string['indicator:nostudent'] = '学生登録';
$string['indicator:nostudent_help'] = 'この指標はコースへの学生参加可否を反映します。';
$string['indicator:noteacher'] = '教師参加可否';
$string['indicator:noteacher_help'] = 'この指標はコースへの教師参加可否を反映します。';
$string['indicator:potentialcognitive'] = 'コース潜在的認識深度';
$string['indicator:potentialcognitive_help'] = 'この指標はコース活動で学生が到達できた潜在的認識深度に基づきます。';
$string['indicator:potentialcognitivedef'] = 'コース潜在的認識深度';
$string['indicator:potentialcognitivedef_help'] = 'コースが提供する「深い」認知的関与の度合いです。例) フィードバックのための作成物の提出、他の人の作成物をレビューする機会、作成物を見直しおよび再提出する機会';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'コース潜在的社会的広がり';
$string['indicator:potentialsocial_help'] = 'この指標はコース活動で学生が到達できた潜在的社会的広がりに基づきます。';
$string['indicator:potentialsocialdef'] = 'コース潜在的社会的広がり';
$string['indicator:potentialsocialdef_help'] = 'コースが提供する「広範囲」の社会的関与、他の参加者との関係およびクラスを超えた参加者コミュニティとの関係の度合いです。';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'すべての読む動作';
$string['indicator:readactions_help'] = 'この指標は学生による読書 (閲覧) 活動を示します。';
$string['indicator:userforumstracking'] = 'ユーザはフォーラム未読管理中';
$string['indicator:userforumstracking_help'] = 'この指標は学生がフォーラム内で未読管理を有効にしているかどうか示します。';
$string['info'] = '情報';
$string['institution'] = '所属組織';
$string['instudentview'] = ': 学生モード使用中';
$string['interests'] = '興味のあること';
$string['interestslist'] = '興味のあることリスト';
$string['interestslist_help'] = 'あなたの興味のあることを1つずつ入力してください。これはプロファイルページにタグとして表示されます。';
$string['invalidemail'] = '無効なメールアドレスです。';
$string['invalidlogin'] = '不正なログインです。再度ログインしてください。';
$string['invalidusername'] = 'ユーザ名には半角英数小文字 (文字および数字)、アンダースコア (_)、ハイフン (-)、ピリオド (.) またはアットマーク (@) のみ含むことができます。';
$string['invalidusernameupload'] = '無効なユーザ名です。';
$string['ip_address'] = 'IPアドレス';
$string['jump'] = '移動';
$string['jumpto'] = '移動 ...';
$string['keep'] = '保存';
$string['keepsearching'] = '再度検索する';
$string['langltr'] = '言語の向き 左 >> 右';
$string['langrtl'] = '言語の向き 右 >> 左';
$string['language'] = '言語設定';
$string['languagegood'] = 'この言語パックは最新版です! :-)';
$string['last'] = '最後';
$string['lastaccess'] = '最終アクセス';
$string['lastcourseaccess'] = 'コースへの最終アクセス';
$string['lastedited'] = '最終編集日時';
$string['lastip'] = '最新IPアドレス';
$string['lastlogin'] = '最終ログイン';
$string['lastmodified'] = '最終更新日時';
$string['lastname'] = '姓';
$string['lastnamephonetic'] = '姓 - ヨミガナ';
$string['lastpage'] = '最後のページ';
$string['lastsiteaccess'] = 'サイトへの最終アクセス';
$string['lastyear'] = '昨年';
$string['latestlanguagepack'] = 'moodle.orgで最新の言語パックをチェックする';
$string['layouttable'] = 'レイアウトテーブル';
$string['leavetokeep'] = '現在のパスワードを使用する場合、空白にしてください。';
$string['legacylogginginuse'] = '現在、このサイトではレガシログストアへの書き込みが有効にされています。このログストアへの書き込みは廃止される予定です。「標準」または「外部」のようなサポートされているログストアに書き込んでください。';
$string['legacythemeinuse'] = 'あなたのブラウザが古すぎるため、このサイトは互換モードで表示されています。';
$string['license'] = 'ライセンス';
$string['licenses'] = 'ライセンス';
$string['liketologin'] = 'フルユーザアカウントでログインしますか?';
$string['list'] = 'リスト';
$string['listfiles'] = '{$a} のファイルリスト';
$string['listofallpeople'] = '全員を表示する';
$string['listofcourses'] = 'コース一覧';
$string['loading'] = '読み込み中';
$string['loadinghelp'] = '読み込み中 ...';
$string['local'] = 'ローカル';
$string['localplugins'] = 'ローカルプラグイン';
$string['localpluginsmanage'] = 'ローカルプラグインを管理する';
$string['location'] = 'ロケーション';
$string['locktimeout'] = 'ロック待ち時の操作タイムアウトです。';
$string['log_excel_date_format'] = 'yyyy/mm/dd h:mm';
$string['loggedinas'] = 'あなたは {$a} としてログインしています';
$string['loggedinasguest'] = 'あなたは現在ゲストアクセスを利用しています';
$string['loggedinnot'] = 'あなたはログインしていません。';
$string['login'] = 'ログイン';
$string['login_failure_logs'] = 'ログイン失敗ログ';
$string['loginactivity'] = 'ログイン活動';
$string['loginalready'] = 'あなたはすでにログインしています';
$string['loginas'] = 'このユーザとしてログインする';
$string['loginaspasswordexplain'] = '<p>この機能を使用するには特別な「ログインパスワード」を入力する必要があります。<br />パスワードが分からない場合、サーバ管理者にお尋ねください。</p>';
$string['loginguest'] = 'ゲストとしてログインする';
$string['loginsite'] = 'サイトにログインする';
$string['loginsteps'] = 'このサイトを利用するにはあなたは最初にアカウントを作成する必要があります。';
$string['loginstepsnone'] = '<p>こんにちは!</p>
<p>コースを利用するにはあなた自身でアカウントを作成する必要があります。</p>
<p>このページのフォームを使用してユーザ名およびパスワードを作成するだけで完了です。</p>
<p>すでに誰か他の人が同じユーザ名を使用している場合、別のユーザ名をお試しください。</p>';
$string['loginto'] = '{$a} にログインする';
$string['logoof'] = '{$a} のロゴ';
$string['logout'] = 'ログアウト';
$string['logoutconfirm'] = '本当にログアウトしてもよろしいですか?';
$string['logs'] = 'ログ';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">さらに表示する</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">さらに表示する</a> ]';
$string['lookback'] = '期間';
$string['mailadmins'] = '管理者に通知する';
$string['mailstudents'] = '学生に通知する';
$string['mailteachers'] = '教師に通知する';
$string['maincoursepage'] = 'メインコースページ';
$string['makeafolder'] = 'フォルダを作成する';
$string['makeavailable'] = '利用可能にする';
$string['makeeditable'] = '「 {$a} 」をサーバ上 (例 apache) で編集可能にした場合、あなたはこのファイルを直接このページで編集できます。';
$string['makethismyhome'] = 'これを私のデフォルトホームページにする';
$string['makeunavailable'] = '利用不可にする';
$string['manageblocks'] = 'ブロック';
$string['managecategorythis'] = 'このカテゴリを管理する';
$string['managecontentbanktypes'] = 'コンテンツタイプを管理する';
$string['managecourses'] = 'コースを管理する';
$string['managedatabase'] = 'データベース';
$string['managedataformats'] = 'データフォーマットを管理する';
$string['manageeditorfiles'] = 'エディタで使用されるファイルを管理する';
$string['managefilters'] = 'フィルタ';
$string['managemodules'] = 'モジュール';
$string['manageroles'] = 'ロールおよびパーミッション';
$string['markallread'] = 'すべてを既読にする';
$string['markedthistopic'] = 'このトピックは最新トピックとして強調表示されています。';
$string['markthistopic'] = 'このトピックを最新トピックとして強調表示します。';
$string['matchingsearchandrole'] = '「 {$a->search} 」および「 {$a->role} 」に合致';
$string['maxareabytesreached'] = 'ファイル (または複数ファイルの合計サイズ) がこのエリアの空き容量を超えています。';
$string['maxfilesize'] = '新しいファイルの最大サイズ: {$a}';
$string['maxfilesreached'] = 'あなたはこのアイテムに最大 {$a} 個のファイルを添付できます。';
$string['maximumchars'] = '{$a} の最大文字数';
$string['maximumgrade'] = '最大評点';
$string['maximumgradex'] = '最大評点: {$a}';
$string['maximumshort'] = '最大';
$string['maximumupload'] = '最大アップロードサイズ';
$string['maximumupload_help'] = 'ここではコース内で学生がアップロードできるファイルの最大サイズを設定します。このサイズは管理者がサイト全体に設定したファイルの最大サイズに制限されます。さらにファイルサイズを制限するため、活動モジュールには最大アップロードサイズ設定もあります。';
$string['maxnumberweeks'] = 'セクション最大数';
$string['maxnumberweeks_desc'] = 'ドロップダウンメニューに表示されるセクション数の最大値です (特定のコースフォーマットにのみ適用されます)。';
$string['maxnumcoursesincombo'] = '<a href="{$a->link}">{$a->numberofcourses} 件のコース</a>を閲覧します。';
$string['maxsectionslimit'] = 'このコース ({$a}) に許可された最大セクション数を超過したため、新しいセクションを作成することができません。';
$string['maxsize'] = '最大サイズ: {$a}';
$string['maxsizeandareasize'] = '新しいファイルの最大サイズ: {$a->size} / 全体の制限: {$a->areasize}';
$string['maxsizeandattachments'] = '最大ファイルサイズ: {$a->size} / 最大ファイル数: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = '最大ファイルサイズ: {$a->size} / 最大ファイル数: {$a->attachments} / 最大合計サイズ: {$a->areasize}';
$string['memberincourse'] = 'コースに属するユーザ';
$string['messagebody'] = 'メッセージ本文';
$string['messagedselectedcountusersfailed'] = '問題が発生したため、{$a} 件のメッセージが送信されませんでした。';
$string['messagedselecteduserfailed'] = 'メッセージはユーザ {$a->fullname} に送信されませんでした。';
$string['messagedselectedusers'] = '選択されたユーザにメッセージが送信されました。同時に受信者リストがリセットされました。';
$string['messagedselectedusersfailed'] = '選択されたユーザへのメッセージ送信中に問題が発生しました。一部のユーザにはメールが送信されました。';
$string['messageprovider:asyncbackupnotification'] = '非同期バックアップ/リストア通知';
$string['messageprovider:availableupdate'] = '利用可能な更新に関する通知';
$string['messageprovider:backup'] = 'バックアップ通知';
$string['messageprovider:badgecreatornotice'] = 'バッジ作成者通知';
$string['messageprovider:badgerecipientnotice'] = 'バッジ取得者通知';
$string['messageprovider:competencyplancomment'] = '学習プランに投稿されたコメント';
$string['messageprovider:competencyusercompcomment'] = 'コンピテンシに投稿されたコメント';
$string['messageprovider:courserequestapproved'] = 'コース作成リクエスト承認通知';
$string['messageprovider:courserequested'] = 'コース作成リクエスト通知';
$string['messageprovider:courserequestrejected'] = 'コース作成リクエスト拒否通知';
$string['messageprovider:errors'] = 'サイトの重大なエラー';
$string['messageprovider:errors_help'] = '管理者が知る必要のある重大なエラーです。';
$string['messageprovider:gradenotifications'] = '評定通知';
$string['messageprovider:insights'] = '予測モデルから生成された洞察';
$string['messageprovider:instantmessage'] = 'ユーザ間のパーソナルメッセージ';
$string['messageprovider:instantmessage_help'] = 'このセクションではこのサイトの他のユーザからあなた宛に直接メッセージ送信された場合の動作を設定します。';
$string['messageprovider:messagecontactrequests'] = 'メッセージコンタクトリクエスト通知';
$string['messageprovider:notices'] = '小さな問題に関する警告';
$string['messageprovider:notices_help'] = 'これらは管理者にとって興味深い内容の通知です。';
$string['messageselect'] = 'このユーザをメッセージ受信者として選択する';
$string['messageselectadd'] = 'メッセージを送信する';
$string['middlename'] = 'ミドルネーム';
$string['migratinggrades'] = '評定の移行';
$string['min'] = '分';
$string['mins'] = '分';
$string['minute'] = '分';
$string['minutes'] = '分';
$string['miscellaneous'] = 'その他';
$string['missingcategory'] = 'あなたはカテゴリを選択する必要があります。';
$string['missingdescription'] = '自己紹介が入力されていません。';
$string['missingemail'] = 'メールアドレスが入力されていません。';
$string['missingfirstname'] = '名が入力されていません。';
$string['missingfromdisk'] = 'ディスクにありません';
$string['missingfullname'] = 'フルネームが入力されていません。';
$string['missinglastname'] = '姓が入力されていません。';
$string['missingname'] = '名前が入力されていません。';
$string['missingnewpassword'] = '新しいパスワードが入力されていません。';
$string['missingpassword'] = 'パスワードが入力されていません。';
$string['missingrecaptchachallengefield'] = 'reCAPTCHAのチャレンジに失敗しました。再度お試しください。';
$string['missingreqreason'] = '理由が入力されていません。';
$string['missingshortname'] = '省略名が入力されていません。';
$string['missingshortsitename'] = 'サイト省略名が入力されていません。';
$string['missingsitedescription'] = 'サイト説明が入力されていません。';
$string['missingsitename'] = 'サイト名が入力されていません。';
$string['missingstrings'] = '未翻訳ストリングを確認する';
$string['missingstudent'] = '何か選択してください。';
$string['missingsummary'] = '概要が入力されていません。';
$string['missingteacher'] = '何か選択してください。';
$string['missingurl'] = 'URLが入力されていません。';
$string['missingusername'] = 'ユーザ名が入力されていません。';
$string['moddoesnotsupporttype'] = 'モジュール「 {$a->modname} 」はタイプ「 {$a->type} 」のアップロードをサポートしていません。';
$string['modhide'] = '非表示';
$string['modified'] = '更新日時';
$string['modshow'] = '表示';
$string['moduleintro'] = '説明';
$string['modulesetup'] = 'モジュールテーブル設定中';
$string['modulesuccess'] = '{$a} テーブルが正常に設定されました。';
$string['modulesused'] = '使用モジュール';
$string['modvisible'] = '利用';
$string['modvisible_help'] = '「利用」に「コースページに表示する」が設定された場合、学生が活動またはリソースを利用できます (設定可能なアクセス制限に依存します)。

「利用」に「学生から秘匿する」が設定された場合、非表示活動を閲覧できるパーミッションが割り当てられたユーザのみ活動またはリソースを利用できます (デフォルトでは教師または編集権限のない教師です)。';
$string['modvisiblehiddensection'] = '利用';
$string['modvisiblehiddensection_help'] = '「利用」に「学生から秘匿する」が設定された場合、非表示活動を閲覧できるパーミッションが割り当てられたユーザのみ活動またはリソースを利用できます (デフォルトでは教師または編集権限のない教師です)。

コースに多くの活動またはリソースが含まれる場合、「利用」を「コースページに表示せずに利用可能にする」に設定してコースページをシンプルにできます。この場合、ページリソース等のどこかで活動またはリソースへのリンクを提供する必要があります。活動は評定表および他のレポートには一覧表示されます。';
$string['modvisiblewithstealth'] = '利用';
$string['modvisiblewithstealth_help'] = '「利用」に「コースページに表示する」が設定された場合、学生が活動またはリソースを利用することができます (設定可能なアクセス制限に依存します)。

「利用」に「学生から秘匿する」が設定された場合、非表示活動を閲覧できるパーミッションが割り当てられたユーザのみ活動またはリソースを利用できます (デフォルトでは教師または編集権限のない教師です)。

コースに多くの活動またはリソースが含まれる場合、「利用」を「コースページに表示せずに利用可能にする」に設定してコースページをシンプルにできます。この場合、ページリソース等のどこかで活動またはリソースへのリンクを提供する必要があります。活動は評定表および他のレポートには一覧表示されます。';
$string['month'] = '月';
$string['months'] = '月';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'このページのMoodle Docs';
$string['moodlelogo'] = 'Moodleロゴ';
$string['moodlerelease'] = 'Moodleリリース';
$string['moodleversion'] = 'Moodleバージョン';
$string['more'] = '詳細';
$string['morehelp'] = '詳細情報';
$string['morehelpaboutmodule'] = '{$a} 活動に関する詳細情報';
$string['moreinfo'] = '詳細情報';
$string['moreinformation'] = 'このエラーに関する詳細情報';
$string['morenavigationlinks'] = 'さらに ...';
$string['moreprofileinfoneeded'] = 'あなたのことをもっと教えてください。';
$string['mostrecently'] = '直近の';
$string['move'] = '移動';
$string['movecategoriessuccess'] = '{$a->count} 件のカテゴリをカテゴリ「 {$a->to} 」に正常に移動しました。';
$string['movecategoriestotopsuccess'] = '{$a->count} 件のカテゴリを正常にトップレベルに移動しました。';
$string['movecategorycontentto'] = '移動先';
$string['movecategorysuccess'] = 'カテゴリ「 {$a->moved} 」をカテゴリ「 {$a->to} 」に正常に移動しました。';
$string['movecategoryto'] = 'カテゴリを移動する:';
$string['movecategorytotopsuccess'] = 'カテゴリ「 {$a->moved} 」を正常にトップレベルに移動しました。';
$string['movecontent'] = '移動対象: {$a}';
$string['movecontentafter'] = '「 {$a} 」の後';
$string['movecontentstoanothercategory'] = 'コンテンツを別のカテゴリに移動する';
$string['movecontenttothetop'] = 'リストのトップ';
$string['movecoursemodule'] = 'リソースを移動する';
$string['movecoursesection'] = 'セクションを移動する';
$string['movecourseto'] = 'コースを移動する:';
$string['movedown'] = '下へ';
$string['movefilestohere'] = 'ファイルをここに移動する';
$string['movefull'] = '{$a} をこの場所に移動する';
$string['movehere'] = 'ここに移動する';
$string['moveleft'] = '左へ';
$string['moveright'] = '右へ';
$string['movesection'] = 'セクション {$a} を移動する';
$string['moveselectedcategoriesto'] = '選択したカテゴリを移動する ...';
$string['moveselectedcoursesto'] = '選択したコースを移動する ...';
$string['movetoanotherfolder'] = '別のフォルダへ移動する';
$string['moveup'] = '上へ';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = '新しいパスワードには現在のパスワードと異なるものを指定してください。';
$string['mustconfirm'] = 'あなたのアカウントを確認してください。';
$string['mycourses'] = 'マイコース';
$string['myfiles'] = 'マイプライベートファイル';
$string['myfilesmanage'] = 'マイプライベートファイルを管理する';
$string['myhome'] = 'ダッシュボード';
$string['mymoodledashboard'] = 'マイMoodleダッシュボード';
$string['myprofile'] = 'マイプロファイル';
$string['name'] = '名称';
$string['namedfiletoolarge'] = 'ファイル「 {$a->filename} 」は大きすぎるためアップロードできません。';
$string['nameforlink'] = 'このリンクを何と呼びますか?';
$string['nameforpage'] = '名称';
$string['navigation'] = 'ナビゲーション';
$string['needed'] = '必要';
$string['networkdropped'] = 'あなたのインターネット接続の未確立または中断を検出しました。<br />あなたの接続が改善するまで変更が適切に保存されない場合があることに留意してください。';
$string['never'] = 'なし';
$string['neverdeletelogs'] = 'ログを削除しない';
$string['new'] = '新規';
$string['newaccount'] = '新しいアカウント';
$string['newactivityname'] = '活動 {$a} の新しい名称';
$string['newcourse'] = '新しいコース';
$string['newpassword'] = '新しいパスワード';
$string['newpassword_help'] = '新しいパスワードを入力してください。現在のパスワードを使用する場合は空白にしてください。';
$string['newpasswordfromlost'] = '<strong>注意:</strong> 喪失パスワードリカバリ処理の一環として送信される2通のメールの<strong>2番目</strong>にあなたの<strong>現在のパスワード</strong>が送信されます。この画面を続ける前にあなたの新しいパスワードが記載されたメールを受信したことを確認してください。';
$string['newpasswordtext'] = '{$a->firstname} さん

「 {$a->sitename} 」のパスワードリセットおよび仮パスワードの作成が完了しました。

あなたのログイン情報は以下のとおりです。
ユーザ名: username: {$a->username}
パスワード: password: {$a->newpassword}

パスワードを変更する場合は次のページにアクセスしてください:
{$a->link}

ほとんどのメールプログラムではあなたがクリックできる青いリンクとして表示されているはずです。クリックできない場合、あなたのウェブブラウザウィンドウのアドレス欄にアドレスをコピー＆ペーストしてください。

「 {$a->sitename} 」の管理者よりご挨拶でした。
{$a->signoff}';
$string['newpicture'] = '新しい画像';
$string['newpicture_help'] = '新しい画像を追加するにはイメージ (JPGまたはPNGフォーマット) を閲覧および選択して「プロファイルを更新する」をクリックしてください。イメージは正方形にトリミングおよび100x100ピクセルにリサイズされます。';
$string['newpictureusernotsetup'] = 'すべての必須プロファイル情報が保存された場合のみプロファイル画像を追加できます。';
$string['newsectionname'] = 'セクション {$a} の新しい名称';
$string['newsitem'] = 'ニュースアイテム';
$string['newsitems'] = 'アナウンスメント';
$string['newsitemsnumber'] = 'アナウンスメントの表示件数';
$string['newsitemsnumber_help'] = 'アナウンスメントフォーラムはコース内に自動作成およびデフォルトで購読強制される特別なフォーラムです。適切なパーミッションを持つユーザ (デフォルトでは教師) のみが投稿できます。

この設定では何件の最近のアナウンスメントが最新アナウンスメントブロック内に表示されるか決定します。

コース内にアナウンスメントフォーラムが必要ではない場合、この設定はゼロにしてください。';
$string['newuser'] = '新しいユーザ';
$string['newusernewpasswordsubj'] = '新しいユーザアカウント';
$string['newusernewpasswordtext'] = '{$a->firstname} さん

あなたの新しいアカウントが「 {$a->sitename} 」に作成されて新しい一時パスワードが発行されました。

あなたの現在のログイン情報は以下のとおりです:
ユーザ名: {$a->username}
パスワード: {$a->newpassword}
(最初にログインしたときにパスワードを変更してください)

{$a->sitename} で作業を始めるには {$a->link} にログインしてください。

クリックできない場合、ウェブブラウザのアドレス欄にアドレスをコピー＆ペーストしてください。

「 {$a->sitename} 」の管理者よりご挨拶でした。
{$a->signoff}';
$string['newusers'] = '新しいユーザ';
$string['newwindow'] = '新しいウィンドウ';
$string['next'] = '次へ';
$string['nextpage'] = '次のページ';
$string['nextsection'] = '次のセクション';
$string['no'] = 'No';
$string['noblockstoaddhere'] = 'あなたがこのページに追加できるブロックはありません。';
$string['nobody'] = 'なし';
$string['nochange'] = '変更なし';
$string['nocomments'] = 'コメントなし';
$string['nocourses'] = 'コースなし';
$string['nocoursesfound'] = 'キーワード 「 {$a} 」 でコースは見つかりませんでした。';
$string['nocoursestarttime'] = 'コースに開始日はありません。';
$string['nocoursesyet'] = 'このカテゴリにコースはありません。';
$string['nodstpresets'] = '管理者は夏時間のサポートを設定していません。';
$string['nofilesselected'] = 'リストアするファイルが選択されていません。';
$string['nofilesyet'] = 'あなたのコースにはまだファイルがアップロードされていません。';
$string['nofiltersapplied'] = '適用フィルタなし';
$string['nograde'] = '評点なし';
$string['nohelpforactivityorresource'] = '現在、このリソースまたは活動に関連付けられたヘルプはありません。';
$string['noimagesyet'] = 'あなたのコースにはまだイメージがアップロードされていません。';
$string['nologsfound'] = 'ログが見つかりませんでした。';
$string['nomatchingusers'] = '「 {$a} 」に合致するユーザは見つかりませんでした。';
$string['nomorecourses'] = '合致するコースは見つかりませんでした。';
$string['nomoreidnumber'] = '重複を回避するためのIDナンバーは使用されていません。';
$string['none'] = 'なし';
$string['noneditingteacher'] = '編集権限のない教師';
$string['noneditingteacherdescription'] = '編集権限のない教師はコース内で教育および学生を評定できますが、活動を変更することはできません。';
$string['nonstandard'] = '非標準';
$string['nopendingcourses'] = '承認処理中のコースはありません。';
$string['nopotentialadmins'] = '潜在的な管理者は登録されていません。';
$string['nopotentialcreators'] = '潜在的なコース作成者は登録されていません。';
$string['nopotentialstudents'] = '潜在的な学生は登録されていません。';
$string['nopotentialteachers'] = '潜在的な教師は登録されていません。';
$string['norecentactivity'] = '最近の活動はありません。';
$string['noreplybouncemessage'] = 'あなたはno-replyメールアドレスに返信しました。フォーラムの投稿に返信したい場合、メール返信する代わりにフォーラム {$a} で返信を投稿してください。

あなたのメール本文は以下のとおりです:';
$string['noreplybouncesubject'] = '{$a} -宛先不明メール';
$string['noreplyname'] = 'このメールアドレス宛に返信しないでください';
$string['noresetrecord'] = 'リセットリクエストのレコードがありません。新しいパスワードリセットリクエストを実行してください。';
$string['noresults'] = '該当データはありません。';
$string['normal'] = 'ノーマル';
$string['normalfilter'] = '通常検索';
$string['nosite'] = 'サイトレベルのコースは見つかりませんでした。';
$string['nostudentsfound'] = '{$a} が見つかりませんでした。';
$string['nostudentsingroup'] = 'このグループにはまだ学生が登録されていません。';
$string['nostudentsyet'] = 'このコースにはまだ学生が登録されていません。';
$string['nosuchemail'] = 'そのようなメールアドレスは存在しません。';
$string['notavailable'] = '利用できません。';
$string['notavailablecourse'] = '{$a} は利用できません。';
$string['noteachersyet'] = 'このコースにはまだ教師は登録されていません。';
$string['noteachingupcomingcourses'] = '公開予定のコースに教師または学生が登録されていません。';
$string['notenrolled'] = '{$a} はこのコースに登録されていません。';
$string['notenrolledprofile'] = 'コースに登録されていないため、このユーザのプロファイルを閲覧できません。';
$string['noteusercannotrolldatesoncontext'] = '<strong>注意:</strong> あなたには必要なパーミッションが不足しているため、このバックアップをリストアする場合の日付変更機能が無効にされました。';
$string['noteuserschangednonetocourse'] = '<strong>注意:</strong> ユーザデータをリストアする場合、コースユーザをリストアする必要があります。あなたの設定が変更されました。';
$string['nothingnew'] = '新しい活動はありません。';
$string['nothingtodisplay'] = '表示するデータはありません。';
$string['notice'] = '警告';
$string['noticenewerbackup'] = 'このバックアップファイルは現在インストールされているMoodle {$a->serverrelease} ({$a->serverversion}) より新しいバージョンMoodle {$a->backuprelease} ({$a->backupversion}) により作成されました。旧バージョンへの互換性が保障されないため、バックアップデータに矛盾を生じる恐れがあります。';
$string['notifications'] = '通知';
$string['notifyloginfailuresmessage'] = '{$a->time}  IP: {$a->ip}  ユーザ: {$a->info}  ユーザフルネーム: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'あなたはこれらのログを {$a} で閲覧することができます。';
$string['notifyloginfailuresmessagestart'] = '前回、あなたに報告して以降の {$a} におけるログイン失敗の一覧です。';
$string['notifyloginfailuressubject'] = '{$a} :: ログイン失敗通知';
$string['notincluded'] = 'バックアップ対象外';
$string['notingroup'] = '申し訳ございません、このページを閲覧するためにはあなたはグループに属している必要があります。';
$string['notpublic'] = '非公開!';
$string['nousersfound'] = 'ユーザは見つかりませんでした。';
$string['nousersmatching'] = '「 {$a} 」に合致するユーザは見つかりませんでした。';
$string['nousersyet'] = 'まだユーザは登録されていません。';
$string['novalidcourses'] = '表示する有効なコースはありません。';
$string['now'] = '現在';
$string['numattempts'] = 'ログイン失敗回数 {$a}';
$string['numberofcourses'] = 'コース数';
$string['numberweeks'] = 'セクション数';
$string['numday'] = '{$a} 日';
$string['numdays'] = '{$a} 日';
$string['numhours'] = '{$a} 時間';
$string['numletters'] = '{$a} 文字';
$string['numminutes'] = '{$a} 分';
$string['nummonth'] = '{$a} 月';
$string['nummonths'] = '{$a} ヶ月';
$string['numseconds'] = '{$a} 秒';
$string['numviews'] = '{$a} 閲覧';
$string['numweek'] = '{$a} 週';
$string['numweeks'] = '{$a} 週';
$string['numwords'] = '{$a} 語';
$string['numyear'] = '{$a} 年';
$string['numyears'] = '{$a} 年';
$string['ok'] = 'OK';
$string['oldpassword'] = '現在のパスワード';
$string['olduserdirectory'] = 'これは古いユーザディレクトリのため、必要ではありません。あなたはこのディレクトリを安全に削除することができます。古いユーザディレクトリに含まれるファイルは新しいユーザディレクトリにコピーされました。';
$string['optional'] = '任意';
$string['options'] = 'オプション';
$string['order'] = '表示順';
$string['originalpath'] = 'オリジナルパス';
$string['orphanedactivitiesinsectionno'] = '迷子の活動 (セクション {$a})';
$string['other'] = 'その他';
$string['outline'] = 'アウトライン';
$string['outlinereport'] = 'アウトラインレポート';
$string['page'] = 'ページ';
$string['pagea'] = 'ページ {$a}';
$string['pagedcontentnavigation'] = 'ページネーションナビゲーション';
$string['pagedcontentnavigationactiveitem'] = '現在のページ、ページ {$a}';
$string['pagedcontentnavigationitem'] = 'ページ {$a} に移動する';
$string['pagedcontentpagingbaritemsperpage'] = '1ページあたり {$a} アイテムを表示する';
$string['pageheaderconfigablock'] = '{$a->fullname} 内のブロック設定';
$string['pagepath'] = 'ページパス';
$string['pageshouldredirect'] = 'このページは自動的にリダイレクトされます。何も起こらない場合、下の「続ける」リンクをクリックしてください。';
$string['parentcategory'] = '親カテゴリ';
$string['parentcoursenotfound'] = '親コースが見つかりませんでした!';
$string['parentfolder'] = '親フォルダ';
$string['participants'] = '参加者';
$string['participantscount'] = '受信者数: {$a}';
$string['participantslist'] = '参加者リスト';
$string['participationratio'] = '参加率';
$string['participationreport'] = '参加レポート';
$string['password'] = 'パスワード';
$string['passwordchanged'] = 'パスワードが変更されました。';
$string['passwordconfirmchange'] = 'パスワード変更を確認する';
$string['passwordextlink'] = '次のリンクはあなたの喪失パスワードを回復するために提供されています。クリックすることで、Moodle外部に移動します。';
$string['passwordforgotten'] = 'パスワード喪失';
$string['passwordforgotteninstructions'] = '最初に、あなたの詳細情報がユーザデータベースに登録されている必要があります。あなたの「ユーザ名」<strong>または</strong>登録に使用した「メールアドレス」をテキストボックスに入力してください。両方を入力する必要はありません。';
$string['passwordforgotteninstructions2'] = 'パスワードをリセットするにはあなたのユーザ名またはメールアドレスを以下に入力してください。データベース内であなたを探すことができた場合、再度アクセスするための手順を記載したメールをあなたのメールアドレス宛に送信します。';
$string['passwordnohelp'] = 'あなたのパスワードを探すためのヘルプは利用できません。Moodle管理者にご連絡ください。';
$string['passwordpolicynomatch'] = 'あなたの現在のパスワードはパスワードポリシーに合致しないようになりました。
{$a}';
$string['passwordrecovery'] = 'はい、ログイン情報を教えてください';
$string['passwordsdiffer'] = 'パスワードが正しくありません。';
$string['passwordsent'] = 'パスワードが送信されました。';
$string['passwordsenttext'] = '<p>メールが {$a->email} 宛に送信されました。
<p><b>メールに記載されている新パスワードを確認してください。</b>
<p>新パスワードは自動的に作成されたものです。あなたが<a href="{$a->link}">覚えやすいものに変更してください</a>。';
$string['passwordset'] = 'あなたのパスワードが設定されました。';
$string['path'] = 'パス';
$string['pathnotexists'] = 'サーバにパスが見当たりません!';
$string['pathslasherror'] = 'パスの最後にスラッシュを付けないでください!!';
$string['paymentinstant'] = '下のボタンをお使いください。支払いおよび登録がすぐに完了します!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> 保留</small>)';
$string['paymentrequired'] = 'このコースへの登録は有料です。';
$string['payments'] = '支払い';
$string['paymentsorry'] = 'お支払いありがとうございます! 残念ですが、あなたの支払いおよびコース 「 {$a->fullname} 」 に入るための登録作業は完了していません。再度、支払いおよび登録作業を実施してください。引き続きエラーが表示される場合、{$a->teacher} またはサイト管理者にご連絡ください。';
$string['paymentthanks'] = 'お支払いありがとうございます! あなたは次のコースに登録されました:<br /> 「 {$a} 」';
$string['pendingrequests'] = '保留中のリクエスト';
$string['percents'] = '{$a}%';
$string['periodending'] = '期間終了 ({$a})';
$string['perpage'] = '1ページあたり';
$string['perpagea'] = '1ページあたり: {$a}';
$string['personal'] = 'パーソナル';
$string['personalprofile'] = 'パーソナルプロファイル';
$string['phone'] = '電話';
$string['phone1'] = '電話';
$string['phone2'] = '携帯電話';
$string['phpinfo'] = 'PHP情報';
$string['pictureof'] = '画像 {$a}';
$string['pictureofuser'] = 'ユーザ画像';
$string['pleaseclose'] = 'このウィンドウを閉じてください。';
$string['pleasesearchmore'] = 'もう少し検索してください。';
$string['pleaseusesearch'] = '検索を使用してください。';
$string['plugin'] = 'プラグイン';
$string['plugincheck'] = 'プラグインチェック';
$string['plugindeletefiles'] = 'データベースよりプラグイン「 {$a->name} 」に関わるデータすべてが削除されました。プラグインの再インストールを防ぐため、あなたのサーバより次のディレクトリを削除してください: {$a->directory}';
$string['pluginsetup'] = 'プラグインテーブル設定中';
$string['policyaccept'] = '私は内容を理解して同意します。';
$string['policyagree'] = 'このサイトを継続して利用するにはあなたは使用許諾に同意する必要があります。同意しますか?';
$string['policyagreement'] = 'サイト使用許諾';
$string['policyagreementclick'] = 'サイト使用許諾へのリンク';
$string['popup'] = 'ポップアップ';
$string['popupwindow'] = '新しいウィンドウでファイルを開く';
$string['popupwindowname'] = 'ポップアップウィンドウ';
$string['post'] = '投稿';
$string['posts'] = '投稿';
$string['potentialadmins'] = '潜在的な管理者';
$string['potentialcreators'] = '潜在的なコース作成者';
$string['potentialstudents'] = '潜在的な学生';
$string['potentialteachers'] = '潜在的な教師';
$string['preferences'] = 'プレファレンス';
$string['preferredlanguage'] = '優先言語';
$string['preferredtheme'] = '優先テーマ';
$string['preprocessingbackupfile'] = 'バックアップファイル処理中';
$string['prev'] = '前へ';
$string['preview'] = 'プレビュー';
$string['previewhtml'] = 'HTMLフォーマットプレビュー';
$string['previeworchoose'] = 'テーマを選択またはプレビューしてください。';
$string['previous'] = '前へ';
$string['previouslyselectedusers'] = '前回選択されて、「 {$a} 」に合致しないユーザ';
$string['previouspage'] = '前のページ';
$string['previoussection'] = '前のセクション';
$string['primaryadminsetup'] = '管理者アカウントを設定する';
$string['privacy:metadata:config_log'] = '設定変更のログです。';
$string['privacy:metadata:config_log:name'] = '設定変更の名称です。';
$string['privacy:metadata:config_log:oldvalue'] = 'この設定の前の値です。';
$string['privacy:metadata:config_log:plugin'] = '修正されたプラグインです。';
$string['privacy:metadata:config_log:timemodified'] = '変更された日時です。';
$string['privacy:metadata:config_log:userid'] = '変更したユーザです。';
$string['privacy:metadata:config_log:value'] = 'この設定の新しい値です。';
$string['privacy:metadata:events_queue'] = '処理待ちのユーザイベントのキューです。';
$string['privacy:metadata:events_queue:eventdata'] = 'イベントに保存されたデータです。';
$string['privacy:metadata:events_queue:stackdump'] = 'このイベントに関連するすべてのスタックトレースです。';
$string['privacy:metadata:events_queue:timecreated'] = 'イベントの作成日時です。';
$string['privacy:metadata:events_queue:userid'] = 'このイベントに関連するユーザIDです。';
$string['privacy:metadata:log'] = '一群の過去のイベントです。';
$string['privacy:metadata:log:action'] = 'アクションの説明です。';
$string['privacy:metadata:log:cmid'] = 'cmidです。';
$string['privacy:metadata:log:course'] = 'courseです。';
$string['privacy:metadata:log:info'] = '追加情報です。';
$string['privacy:metadata:log:ip'] = 'イベントの時間に使用されるIPアドレスです。';
$string['privacy:metadata:log:module'] = 'モジュールです。';
$string['privacy:metadata:log:time'] = 'アクションが実施された日時です。';
$string['privacy:metadata:log:url'] = 'イベントに関連するURLです。';
$string['privacy:metadata:log:userid'] = 'アクションを実行したユーザのIDです。';
$string['privacy:metadata:task_adhoc'] = 'アドホックタスクのステータスです。';
$string['privacy:metadata:task_adhoc:component'] = 'タスクに所有されているコンポーネントです。';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'このタスクが実行された最も古い日時です。';
$string['privacy:metadata:task_adhoc:userid'] = 'このタスクを実行するユーザです。';
$string['privacy:metadata:task_log'] = 'ログのログアウトプット';
$string['privacy:metadata:task_log:component'] = 'タスクを所有するコンポーネントです。';
$string['privacy:metadata:task_log:userid'] = 'タスクが属するユーザです。';
$string['privacy:metadata:upgrade_log'] = 'アップグレードログです。';
$string['privacy:metadata:upgrade_log:backtrace'] = 'このアップグレードステップに関連するすべてのバックトレースです。';
$string['privacy:metadata:upgrade_log:details'] = 'アップグレードに関連するその他の情報です。';
$string['privacy:metadata:upgrade_log:info'] = 'このアップグレードステップの主情報です。';
$string['privacy:metadata:upgrade_log:plugin'] = 'アップグレードされたプラグインです。';
$string['privacy:metadata:upgrade_log:targetversion'] = 'アップグレードする新しいバージョンです。';
$string['privacy:metadata:upgrade_log:timemodified'] = 'アップグレードが実施された日時です。';
$string['privacy:metadata:upgrade_log:type'] = 'ログエントリのタイプです。';
$string['privacy:metadata:upgrade_log:userid'] = 'アップグレードを実行したユーザです。';
$string['privacy:metadata:upgrade_log:version'] = 'プラグインの古いバージョンです。';
$string['private_files_handler'] = 'メールの添付をユーザのプライベートファイル保存スペースに保存します。';
$string['private_files_handler_name'] = 'プライベートファイルにメールで送信する';
$string['privatefiles'] = 'プライベートファイル';
$string['privatefilesmanage'] = 'プライベートファイルを管理する';
$string['proceed'] = '進む';
$string['profile'] = 'プロファイル';
$string['profilenotshown'] = 'このユーザが少なくとも1つのコースに登録されるまで、プロファイル自己紹介欄は表示されません。';
$string['publicprofile'] = 'パブリックプロファイル';
$string['publicsitefileswarning'] = '注意: ここに置いたファイルには誰でもアクセスすることができます。';
$string['publicsitefileswarning2'] = '注意: ここに置いたファイルはURLを知っている (または推測できる) 誰でもアクセスすることができます。セキュリティ上の理由から、リストア完了後、すべてのバックアップファイルをすぐに削除することをお勧めします。';
$string['publicsitefileswarning3'] = '注意: ここに置いたファイルはURLを知っている (または推測できる) 誰でもアクセスすることができます。<br />セキュリティ上の理由から、バックアップファイルは安全なbackupdataフォルダにのみ保存してください。';
$string['question'] = '問題';
$string['questionsinthequestionbank'] = '問題バンクの問題';
$string['queued'] = 'キュー';
$string['quotausage'] = '現在、あなたは  {$a->total} 制限のうち {$a->used} を使用しています。';
$string['readinginfofrombackup'] = 'バックアップより情報を読取り中';
$string['readme'] = 'README';
$string['recentactivity'] = '最近の活動';
$string['recentactivityreport'] = '最近の活動詳細 ...';
$string['recipientslist'] = '受信者リスト';
$string['recommended'] = '推奨';
$string['recreatedcategory'] = '再作成カテゴリ {$a}';
$string['redirect'] = 'リダイレクト';
$string['reducesections'] = 'セクション数を減らす';
$string['refresh'] = 'リフレッシュ';
$string['refreshingevents'] = 'イベントの更新';
$string['registration'] = 'Moodle登録';
$string['registrationcontact'] = '一般からの問い合わせ';
$string['registrationcontactno'] = 'いいえ、他の人から私に連絡しないでください';
$string['registrationcontactyes'] = 'はい、他のMoodlerが私に問い合わせできるようフォームを設置してください';
$string['registrationemail'] = 'メール通知';
$string['registrationinfo'] = '<p>このページではあなたのMoodleサイトをmoodle.orgに登録できます。登録は無料です。登録の主な利点は発信数の少ないメーリングリストにあなたのメールアドレスが追加され、セキュリティに関する警告やMoodleの最新リリースに関する情報を受取れることです。</p>
<p>あなたの情報はデフォルトでは公開されません。また、他の人に販売および転送されることはありません。情報を収集する唯一の理由はサポートを目的とするものであり、Moodleコミュニティの統計的全体像を構築することにあります。</p>
<p>登録する場合、あなたのサイト名、国、URLがMoodleサイトの公開リストに登録されます。</p>
<p>すべての新しい登録は公開リストに登録される前に手作業で確認されますが、一旦登録されるといつでも登録内容 (および公開リストの内容) をこのフォームで再登録することができます。</p>';
$string['registrationinfotitle'] = '登録情報';
$string['registrationno'] = 'いいえ、どのようなメールも送信しないでください';
$string['registrationsend'] = 'moodle.orgに登録情報を送信する';
$string['registrationyes'] = 'はい、私に新しいMoodleリリース、セキュリティ通知およびその他の重要なニュースを通知してください。';
$string['reject'] = '拒否';
$string['rejectdots'] = '拒否 ...';
$string['relativedatesmode'] = '相対日付モード';
$string['relativedatesmode_help'] = 'ユーザのコース開始日に相対的なコースまたは活動の日付を表示します。

コース開始日前にユーザが受講登録を完了して開始日がコース開始日になる以外、ユーザのコース開始日はユーザの登録日です。

注意: これは実験的な機能であり、すべての活動でサポートされているわけではありません。コース作成完了後、この設定は変更できないようになります。';
$string['relativedatesmode_warning'] = '<strong>注意:</strong> コース相対日付モードはコース作成後には変更できません。';
$string['reload'] = 'リロード';
$string['remoteappuser'] = 'リモート {$a} ユーザ';
$string['remove'] = '削除';
$string['removeadmin'] = '管理者を削除する';
$string['removecreator'] = 'コース作成者を削除する';
$string['removestudent'] = '学生を削除する';
$string['removeteacher'] = '教師を削除する';
$string['rename'] = 'リネーム';
$string['renamefileto'] = '<b>{$a}</b> を以下の名称にリネームする';
$string['report'] = 'レポート';
$string['reports'] = 'レポート';
$string['repositories'] = 'リポジトリ';
$string['requestcourse'] = 'コースをリクエストする';
$string['requestedby'] = 'リクエスト:';
$string['requestedcourses'] = 'リクエストされたコース';
$string['requestreason'] = 'コースリクエストの理由';
$string['requests'] = 'リクエスト';
$string['required'] = '必須';
$string['requirespayment'] = 'このコースにアクセスするには支払いが必要です。';
$string['resendemail'] = 'メールを再送する';
$string['reset'] = 'リセット';
$string['resetcomponent'] = 'コンポーネント';
$string['resetcourse'] = 'コースをリセットする';
$string['resetinfo'] = 'このページでは活動および他の設定を保持しながらコースのユーザデータを空にすることができます。以下のアイテムを選択してこのページを実行することにより選択されたユーザデータがこのコースから完全に削除されますので注意してください!';
$string['resetnotimplemented'] = 'リセット未実装';
$string['resetrecordexpired'] = 'あなたが使用したパスワードリセットリンクは {$a} 分以上経過したため、有効期限が切れています。新しいパスワードリセットリクエストを実行してください。';
$string['resetstartdate'] = '開講日をリセットする';
$string['resetstatus'] = 'ステータス';
$string['resettable'] = 'テーブルプレファレンスをリセットする';
$string['resettask'] = 'タスク';
$string['resettodefaults'] = 'デフォルトにリセットする';
$string['resortcourses'] = 'コースを並べ替える';
$string['resortsubcategoriesby'] = 'サブカテゴリを {$a} の昇順に並べ替える';
$string['resortsubcategoriesbyreverse'] = 'サブカテゴリを {$a} の降順に並べ替える';
$string['resource'] = 'リソース';
$string['resourcedisplayauto'] = '自動';
$string['resourcedisplaydownload'] = '強制的にダウンロードする';
$string['resourcedisplayembed'] = '埋め込み';
$string['resourcedisplayframe'] = 'フレーム';
$string['resourcedisplaynew'] = '新しいウィンドウ';
$string['resourcedisplayopen'] = 'オープン';
$string['resourcedisplaypopup'] = 'ポップアップ';
$string['resources'] = 'リソース';
$string['resources_help'] = 'リソースタイプではほとんどの種類のウェブコンテンツをコース内に追加することができます。';
$string['restore'] = 'リストア';
$string['restorecancelled'] = 'リストアがキャンセルされました。';
$string['restorecannotassignroles'] = 'リストアにはロールを割り当てる必要がありますが、あなたにはそのパーミッションがありません。';
$string['restorecannotcreateorassignroles'] = 'リストアにはロールを作成または割り当てる必要がありますが、あなたにはそのパーミッションがありません。';
$string['restorecannotcreateuser'] = 'リストアにはバックアップファイルよりユーザ「 {$a} 」を作成する必要がありますが、あなたにはそのパーミッションがありません。';
$string['restorecannotoverrideperms'] = 'リストアにはパーミッションをオーバーライドする必要がありますが、あなたにはそのパーミッションがありません。';
$string['restorecoursenow'] = 'このコースをリストアする!';
$string['restoredaccount'] = 'リストア済みアカウント';
$string['restoredaccountinfo'] = 'このアカウントは別のサーバからインポートされたため、パスワードが喪失しました。新しいパスワードをメールで設定するには「続ける」をクリックしてください。';
$string['restorefinished'] = 'リストアが正常に完了しました。';
$string['restoremnethostidmismatch'] = 'ユーザ「 {$a} 」のMNetホストIDがローカルのMNetホストIDと合致しません。';
$string['restoreto'] = 'リストア';
$string['restoretositeadding'] = '警告: あなたはサイトフロントページをリストアしようとしています。サイトフロントページにデータが追加されます!';
$string['restoretositedeleting'] = '警告: あなたはサイトフロントページをリストアしようとしています。最初にサイトフロントページからデータが削除されます!';
$string['restoreuserconflict'] = 'バックアップからユーザ「 {$a} 」をリストアすることで衝突が発生します。';
$string['restoreuserinfofailed'] = 'あなたにはユーザデータをリストアするためのパーミッションがないため、リストア処理は中止されました。';
$string['restoreusersprecheck'] = 'ユーザデータのチェック';
$string['restoreusersprecheckerror'] = 'ユーザデータのチェックに関して問題が検出されました。';
$string['restricted'] = '利用制限';
$string['resultsfound'] = '{$a} 件の結果が見つかりました。';
$string['retry'] = '再試行';
$string['returningtosite'] = 'アカウントをお持ちの方ですか?';
$string['returntooriginaluser'] = '{$a} に戻る';
$string['revert'] = '元に戻す';
$string['role'] = 'ロール';
$string['roleassignments'] = 'ロール割り当て';
$string['rolemappings'] = 'ロールマッピング';
$string['rolerenaming'] = 'ロールのリネーム';
$string['rolerenaming_help'] = 'このオプションではあなたのコースで表示されるロール名を変更することができます。ロール表示名のみ変更されます - 実際のロールパーミッションは影響を受けません。新しいロール名はコース参加者ページおよびコース内の様々な場所で表示されます。リネームしたロールが管理者によりコース管理者として選択されたロールの場合、コース一覧においても新しいロール名が表示されます。';
$string['roles'] = 'ロール';
$string['rss'] = 'RSS';
$string['rssarticles'] = '最近の記事のRSS数';
$string['rsserror'] = 'RSSデータの読み込み中にエラーが発生しました。';
$string['rsserrorauth'] = 'あなたのRSSリンクには有効な認証トークンが含まれていません。';
$string['rsserrorguest'] = 'このフィードはデータへのアクセスにゲストアクセスを使用しますが、データを読むためのパーミッションがありません。このフィードのオリジナルロケーション (URL) に有効なユーザでアクセスした後、新しいRSSリンクを取得してください。';
$string['rsskeyshelp'] = '<p>セキュリティおよびプライバシーを保証するため、RSSフィードURLにはユーザを識別するための特別なトークンを含みます。これでRSSフィード経由でアクセスできないMoodleエリアにユーザがアクセスすることを防ぎます。</p><p>このトークンはMoodleがRSSフィードを生成する場所にあなたが初回アクセスした時点で自動的に作成されます。RSSフィードトークンに問題が漏洩したと思われる場合、あなたはリセットリンクをクリックすることで新しいトークンをリクエストすることができます。この場合、あなたの現在のRSSフィードURLが無効になることに留意してください。</p>';
$string['rsstype'] = 'この活動のRSSフィード';
$string['save'] = '保存';
$string['saveandnext'] = '保存して次を表示する';
$string['savechanges'] = '変更を保存する';
$string['savechangesanddisplay'] = '保存して表示する';
$string['savechangesandreturn'] = '保存して戻る';
$string['savechangesandreturntocourse'] = '保存してコースに戻る';
$string['savecomment'] = 'コメントを保存する';
$string['savedat'] = '保存日時:';
$string['savepreferences'] = 'プレファレンスを保存する';
$string['saveto'] = '保存先';
$string['scale'] = '評価尺度';
$string['scale_help'] = '活動内のパフォーマンスを評価または評定するために評価尺度が提供されます。評価尺度自体はマイナスからプラスへ、カンマで区切られた値の並びです。例えば「不満足, 不十分, 平均, 良い, 大変良い, 素晴らしい!」のように定義します。';
$string['scale_link'] = 'grade/scale';
$string['scales'] = '評価尺度';
$string['scalescustom'] = 'カスタム評価尺度';
$string['scalescustomcreate'] = '新しい評価尺度を追加する';
$string['scalescustomno'] = 'カスタム評価尺度はまだ作成されていません。';
$string['scalesstandard'] = '標準評価尺度';
$string['scalestandard'] = '標準評価尺度';
$string['scalestandard_help'] = '標準評価尺度はサイト全体およびすべてのコースで利用可能な評価尺度です。';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'カスタム評価尺度を作成するにはコース管理メニューにある「評価尺度..」を使用してください。';
$string['scalestip2'] = 'カスタム評価尺度を作成するにはコース管理メニューにある「評定」リンクをクリックした後、「評価尺度」を選択してください。';
$string['schedule'] = 'スケジュール';
$string['screenshot'] = 'スクリーンショット';
$string['search'] = '検索';
$string['search_help'] = 'テキスト中に存在する1つまたはそれ以上の言葉を検索する基本的な検索では空白で区切られた言葉を入力してください。半角2文字より大きな言葉が検索に使用されます。

高度な検索では検索ボックス内に文字を入力せずに検索ボタンをクリックしてください。高度な検索フォームが表示されます。';
$string['searchactivities'] = '名称または説明で活動を検索する';
$string['searchagain'] = '再検索';
$string['searchbyemail'] = 'メールアドレスで検索する';
$string['searchbyusername'] = 'ユーザ名で検索する';
$string['searchcoursecategories'] = 'カテゴリを検索する';
$string['searchcourses'] = 'コースを検索する';
$string['searchoptions'] = '検索オプション';
$string['searchresults'] = '検索結果';
$string['sec'] = '秒';
$string['seconds'] = '秒';
$string['secondsleft'] = '{$a} 秒';
$string['secondstotime172800'] = '2日間';
$string['secondstotime259200'] = '3日間';
$string['secondstotime345600'] = '4日間';
$string['secondstotime432000'] = '5日間';
$string['secondstotime518400'] = '6日間';
$string['secondstotime604800'] = '1週間';
$string['secondstotime86400'] = '1日間';
$string['secretalreadyused'] = 'パスワード変更の確認リンクはすでに使用されています。パスワードは変更されませんでした。';
$string['secs'] = '秒';
$string['section'] = 'セクション';
$string['sectionactionnotsupported'] = 'セクションアクション「 {$a} 」はここでサポートされていません。';
$string['sectionname'] = 'セクション名';
$string['sections'] = 'セクション';
$string['seealsostats'] = '関連項目: 統計';
$string['selctauser'] = 'ユーザを選択する';
$string['select'] = '選択';
$string['selectacategory'] = 'カテゴリを選択してください。';
$string['selectacountry'] = '国を選択する';
$string['selectacourse'] = 'コースを選択する';
$string['selectacoursesite'] = 'コースまたはサイトを選択する';
$string['selectagroup'] = 'グループを選択する';
$string['selectall'] = 'すべてを選択する';
$string['selectallusersonpage'] = 'このページのユーザすべてを選択する';
$string['selectalluserswithcount'] = '{$a} ユーザすべてを選択する';
$string['selectamodule'] = '活動モジュールを選択してください。';
$string['selectanaction'] = '操作を選択する';
$string['selectanoptions'] = 'オプションを選択する';
$string['selectaregion'] = '区を選択する';
$string['selectcategorysort'] = 'あなたはどのカテゴリを並べ替えたいですか?';
$string['selectcategorysortby'] = 'あなたがどのようにカテゴリを並べ替えるか選択する';
$string['selectcoursesortby'] = 'あなたがどのようにコースを並べ替えるか選択する';
$string['selectdefault'] = 'デフォルトを選択する';
$string['selectedcategories'] = '選択済みカテゴリ';
$string['selectedfile'] = '選択済みファイル';
$string['selectednowmove'] = '移動するためのファイル {$a} 個が選択されました。移動先フォルダに移動して「ファイルをここに移動する」ボタンをクリックしてください。';
$string['selectfiles'] = 'ファイルを選択する';
$string['selectitem'] = '「 {$a} 」を選択する';
$string['selectmoduletoviewhelp'] = 'ヘルプを表示するには活動またはリソースを選択してください。

活動名またはリソース名をダブルクリックすることにより、素早く追加することができます。';
$string['selectnos'] = 'すべて「No」を選択する';
$string['selectperiod'] = '期間を選択する';
$string['senddetails'] = '私のログイン情報をメール送信する';
$string['separate'] = '分離';
$string['separateandconnected'] = '分離・関連認識';
$string['separateandconnectedinfo'] = '分離認識および関連認識の理論に基づく評価尺度です。
この理論では私たちが見たり聞いたりすることを評価および学習する、2つの方法を説明しています。
<ul>
<li><strong>分離認識の人</strong> は感情を含まず可能な限り客観的であろうとします。他の人とのディスカッションにおいて、相手の考えの穴を探す論理を使って自分たちの意見を守ることを好みます。</li>
<li><strong>関連認識の人</strong> は他の人に対してより敏感です。また、相手に共感する能力があり、自分が関係できて「相手の立場に立ってものごとを理解できた」と感じるまで話を聞く傾向があります。そして、自分に知識をもたらす他の人の経験を共有することで学ぼうとします。</li>
</ul>';
$string['servererror'] = 'サーバとの通信中にエラーが発生しました。';
$string['serverlocaltime'] = 'サーバのローカルタイム';
$string['sessionforceclean'] = 'このセッションではユーザ作成スクリプトはセキュリティ上の理由から無効にされています。';
$string['sessiontimeoutsoon'] = 'あなたのセッションはタイムアウトしようとしています。あなたの現在のセッションを延長しますか?';
$string['setcategorytheme'] = 'カテゴリテーマの設定';
$string['setpassword'] = 'パスワードを設定する';
$string['setpasswordinstructions'] = 'あなたの新しいパスワードを以下に入力した後、保存してください。';
$string['settings'] = '設定';
$string['shortname'] = '省略名';
$string['shortnamecollisionwarning'] = '[*] = この省略名はすでに他のコースで使用されています。承認されるためには省略名を変更する必要があります。';
$string['shortnamecourse'] = 'コース省略名';
$string['shortnamecourse_help'] = 'コース省略名はナビゲーションおよびコースメールメッセージの件名に使用されます。';
$string['shortnametaken'] = '省略名は別のコース ({$a}) で使用されています。';
$string['shortnameuser'] = 'ユーザ省略名';
$string['shortsitename'] = 'サイト省略名 (例 単語)';
$string['show'] = '表示';
$string['showactions'] = '行動の表示';
$string['showadvancededitor'] = '高度';
$string['showadvancedsettings'] = '高度な設定を表示する';
$string['showall'] = '{$a} すべてを表示する';
$string['showallcourses'] = 'すべてのコースを表示する';
$string['showallusers'] = 'すべてのユーザを表示する';
$string['showblockcourse'] = 'ブロックを含むコース一覧を表示する';
$string['showcategory'] = '{$a} を表示する';
$string['showchartdata'] = 'チャートデータを表示する';
$string['showcomments'] = 'コメントを表示/非表示にする';
$string['showcommentsnonjs'] = 'コメントを表示する';
$string['showdescription'] = 'コースページに説明を表示する';
$string['showdescription_help'] = 'この設定を有効にした場合、上記説明文がコースページ内の活動またはリソースのリンクの下に表示されます。';
$string['showgrades'] = '学生に評定表を表示する';
$string['showgrades_help'] = 'コース内の多くの活動では評定を設定することができます。この設定ではコース管理ブロック内の評定リンク経由で学生が自分のコース評定すべてを一覧表示できるかどうか決定します。';
$string['showingacourses'] = '{$a} 件のコースすべてを表示する';
$string['showingxofycourses'] = '{$a->total} 件のコース中、{$a->start} から {$a->end} までを表示する';
$string['showlistofcourses'] = 'コース一覧を表示する';
$string['showmodulecourse'] = '活動を含むコース一覧を表示する';
$string['showoncoursepage'] = 'コースページに表示する';
$string['showonly'] = '表示限定';
$string['showperpage'] = '1ページあたりの表示数: {$a}';
$string['showpopoverwindow'] = 'ポップオーバーウィンドウを表示する';
$string['showrecent'] = '最新の活動を表示する';
$string['showreports'] = '活動レポートを表示する';
$string['showreports_help'] = '活動レポートでは現在のコースに関する活動内容を表示して、それぞれの参加者が利用することができます。これらのレポートには参加者の投稿内容および詳細なアクセスログも含まれます。この設定では学生がプロファイルページ経由で自分の活動レポートを閲覧できるかどうか決定します。';
$string['showsettings'] = '設定を表示する';
$string['showtheselogs'] = '選択したログを表示する';
$string['showthishelpinlanguage'] = 'このヘルプを次の言語で表示する: {$a}';
$string['sidepanel'] = 'サイドパネル';
$string['signoutofotherservices'] = 'すべてをサインアウトする';
$string['signoutofotherservices_help'] = 'この設定を有効にした場合、モバイルアプリ等、ウェブサービスを使用しているすべてのデバイスおよびシステムはサインアウトされます。';
$string['since'] = '対象範囲';
$string['sincelast'] = '最終ログインより';
$string['site'] = 'サイト';
$string['sitedefault'] = 'サイトデフォルト';
$string['siteerrors'] = 'サイトエラー';
$string['sitefiles'] = 'サイトファイル';
$string['sitefilesused'] = 'このコースで使用されているサイトファイル';
$string['sitehome'] = 'サイトホーム';
$string['sitelegacyfiles'] = 'レガシサイトファイル';
$string['sitelogs'] = 'サイトログ';
$string['sitemessage'] = 'ユーザにメッセージを送信する';
$string['sitenews'] = 'サイトアナウンスメント';
$string['sitepages'] = 'サイトページ';
$string['sitepartlist'] = 'あなたには参加者リストを閲覧するために必要なパーミッションがありません。';
$string['sitepartlist0'] = 'サイト参加者リストを閲覧するにはあなたはサイト教師である必要があります。';
$string['sitepartlist1'] = 'サイト参加者リストを閲覧するにはあなたは教師である必要があります。';
$string['sites'] = 'サイト';
$string['sitesection'] = 'トピックセクションを含む';
$string['sitesettings'] = 'サイト設定';
$string['siteteachers'] = 'サイト教師';
$string['size'] = 'サイズ';
$string['sizeb'] = 'バイト';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'スキップ';
$string['skiptocategorylisting'] = 'カテゴリ一覧にスキップする';
$string['skiptocoursedetails'] = 'コース詳細情報にスキップする';
$string['skiptocourselisting'] = 'コース一覧にスキップする';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'ソーシャルフォーラム - 最新トピック';
$string['someallowguest'] = 'いくつかのコースにはゲストアクセスできます';
$string['someerrorswerefound'] = 'いくつかの情報が未入力または正しくありません。詳細は以下をご覧ください。';
$string['sort'] = '並べ替え';
$string['sortby'] = '並べ替え';
$string['sortbyx'] = '{$a} の昇順で並べ替える';
$string['sortbyxreverse'] = '{$a} の降順で並べ替える';
$string['sorting'] = '並べ替え';
$string['sourcerole'] = 'ソースロール';
$string['specifyname'] = 'あなたは名前を指定する必要があります。';
$string['standard'] = '標準';
$string['starpending'] = '([*] = 承認審査中コース)';
$string['startdate'] = '開講日';
$string['startdate_help'] = 'この設定ではウィークリーフォーマットのコースにおける最初の週の開始日を設定します。また、コース活動のログを利用できる最も早い日付も決定します。コースがリセットされてコース開始日が変更された場合、新しい開始日に基づいてコース内すべての日付が移動されます。';
$string['startingfrom'] = '開始日';
$string['startsignup'] = '新しいアカウントを作成する';
$string['state'] = '州/県';
$string['statistics'] = '統計';
$string['statisticsgraph'] = '統計グラフ';
$string['stats'] = '統計';
$string['statslogins'] = 'ログイン';
$string['statsmodedetailed'] = '詳細 (ユーザ) 表示';
$string['statsmodegeneral'] = '概要表示';
$string['statsnodata'] = 'このコースおよび期間の組み合わせで利用できるデータはありません。';
$string['statsnodatauser'] = 'このコース、ユーザおよび期間の組み合わせで利用できるデータはありません。';
$string['statsoff'] = '現在、統計は有効にされていません。';
$string['statsreads'] = '表示';
$string['statsreport1'] = 'ログイン';
$string['statsreport10'] = 'ユーザ活動';
$string['statsreport11'] = '最も活発なコース';
$string['statsreport12'] = '最も活発なコース (加重)';
$string['statsreport13'] = '最も参加者の多いコース (登録)';
$string['statsreport14'] = '最も参加者の多いコース (投稿/閲覧)';
$string['statsreport2'] = '閲覧 (すべてのロール)';
$string['statsreport3'] = '投稿 (すべてのロール)';
$string['statsreport4'] = 'すべての活動 (すべてのロール)';
$string['statsreport5'] = 'すべての活動 (閲覧および投稿)';
$string['statsreport7'] = 'ユーザ活動 (閲覧および投稿)';
$string['statsreport8'] = 'すべてのユーザの活動';
$string['statsreport9'] = 'ログイン (サイトコース)';
$string['statsreportactivity'] = 'すべての活動 (すべてのロール)';
$string['statsreportactivitybyrole'] = 'すべての活動 (閲覧および投稿)';
$string['statsreportforuser'] = ':';
$string['statsreportlogins'] = 'ログイン';
$string['statsreportreads'] = '閲覧 (すべてのロール)';
$string['statsreporttype'] = 'レポートタイプ';
$string['statsreportwrites'] = '投稿 (すべてのロール)';
$string['statsstudentactivity'] = '学生の活動';
$string['statsstudentreads'] = '学生の閲覧';
$string['statsstudentwrites'] = '学生の投稿';
$string['statsteacheractivity'] = '教師の活動';
$string['statsteacherreads'] = '教師の閲覧';
$string['statsteacherwrites'] = '教師の投稿';
$string['statstimeperiod'] = '期間 - 直近:';
$string['statsuniquelogins'] = 'ユニークログイン';
$string['statsuseractivity'] = 'すべての活動';
$string['statsuserlogins'] = 'ログイン';
$string['statsuserreads'] = '閲覧';
$string['statsuserwrites'] = '投稿';
$string['statswrites'] = '投稿';
$string['status'] = 'ステータス';
$string['statuscritical'] = 'クリティカル';
$string['statuserror'] = 'エラー';
$string['statusinfo'] = '情報';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statuswarning'] = '警告';
$string['stringsnotset'] = '以下の文字は {$a} で定義されていません。';
$string['studentnotallowed'] = '申し訳ございません、あなたはこのコースに「 {$a} 」として入ることはできません。';
$string['students'] = '学生';
$string['studentsandteachers'] = '学生および教師';
$string['subcategories'] = 'サブカテゴリ';
$string['subcategory'] = 'サブカテゴリ';
$string['subcategoryof'] = '{$a} のサブカテゴリ';
$string['submit'] = '送信';
$string['success'] = '成功';
$string['successduration'] = '成功 ({$a} 秒)';
$string['summary'] = '概要';
$string['summary_help'] = '概要はトピックまたは週の中の活動を学生が準備するための短いテキストです。テキストはコースページのセクション名の下に表示されます。';
$string['summaryof'] = '{$a} 概要';
$string['supplyinfo'] = '詳細情報';
$string['suspended'] = '一時停止';
$string['suspendedusers'] = '一時停止ユーザ';
$string['switchdevicedefault'] = '標準テーマにスイッチする';
$string['switchdevicerecommended'] = 'あなたのデバイスの推奨テーマにスイッチする';
$string['switchrolereturn'] = '通常ロールに戻る';
$string['switchroleto'] = 'ロールを切り替える ...';
$string['switchroleto_help'] = 'ロールのユーザにコースがどのように見えるのか確認するため、ロールを選択してください。

この表示は完璧なものではないことに留意してください (<a href="https://docs.moodle.org/en/Switch_roles">詳細および代替手段はこちらをご覧ください</a>)。';
$string['tag'] = 'タグ';
$string['tagalready'] = 'このタグはすでに登録されています。';
$string['tagmanagement'] = 'タグを追加/削除する ...';
$string['tags'] = 'タグ';
$string['targetrole'] = 'ターゲットロール';
$string['teacheronly'] = '{$a} 専用';
$string['teacherroles'] = '{$a} ロール';
$string['teachers'] = '教師';
$string['textediting'] = 'テキストエディタ';
$string['textediting_help'] = 'AttoまたはTinyMCEのようなHTMLエディタが選択された場合、コンテンツを簡単に追加できるようテキスト入力エリアにはボタンを含むツールバーが配置されます。

「プレインテキストエリア」が選択された場合、HTMLまたはマークダウンのようなフォーマットのテキスト入力エリアを選択することができます。

利用可能なテキストエディタのリストはサイト管理者によって決定されます。';
$string['texteditor'] = '標準ウェブフォームを使用します';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'プレインテキストフォーマット';
$string['thanks'] = 'ありがとうございます';
$string['theme'] = 'テーマ';
$string['themes'] = 'テーマ';
$string['themesaved'] = '新しいテーマが保存されました。';
$string['therearecourses'] = '{$a} 件のコースがあります。';
$string['thereareno'] = 'このコースには {$a} がありません。';
$string['thiscategory'] = 'このカテゴリ';
$string['thiscategorycontains'] = 'このカテゴリは以下のコンテンツを含みます。';
$string['time'] = '時間';
$string['timecreatedcourse'] = 'コース作成日時';
$string['timesplitting:deciles'] = '直前の10分割';
$string['timesplitting:deciles_help'] = 'この分析間隔はコースを10分割 (10等分) します。それぞれの予測は直前の10分割のデータのみを基にします。';
$string['timesplitting:decilesaccum'] = '前のすべての10分割';
$string['timesplitting:decilesaccum_help'] = 'この分析間隔はコースを10分割 (10等分) します。それぞれの予測は前のすべての10分割のデータを基にします。';
$string['timesplitting:nosplitting'] = '時間制限なし';
$string['timesplitting:nosplitting_help'] = 'このモデルには分析間隔が定義されていません。';
$string['timesplitting:onemonthafterstart'] = '開始1ヶ月後';
$string['timesplitting:onemonthafterstart_help'] = 'この分析間隔では分析可能な開始の1ヶ月後の予測を生成します。';
$string['timesplitting:oneweekafterstart'] = '開始1週間後';
$string['timesplitting:oneweekafterstart_help'] = 'この分析間隔では分析可能な開始の1週間後の予測を生成します。';
$string['timesplitting:past3days'] = '過去3日間';
$string['timesplitting:past3days_help'] = 'この分析間隔では3日ごとの予測を生成します。指標計算は過去3日間に基づきます。';
$string['timesplitting:pastmonth'] = '過去1ヶ月間';
$string['timesplitting:pastmonth_help'] = 'この分析間隔では1ヶ月ごとの予測を生成します。指標計算は過去1ヶ月間に基づきます。';
$string['timesplitting:pastweek'] = '過去1週間';
$string['timesplitting:pastweek_help'] = 'この分析間隔では1週間ごとの予測を生成します。指標計算は過去1週間に基づきます。';
$string['timesplitting:quarters'] = '直前の4分割';
$string['timesplitting:quarters_help'] = 'この分析間隔はコースを4分割 (4等分) します。それぞれの予測は直前の4分割のデータのみを基にします。';
$string['timesplitting:quartersaccum'] = '前のすべての4分割';
$string['timesplitting:quartersaccum_help'] = 'この分析間隔はコースを4分割 (4等分) します。それぞれの予測は前のすべての4分割のデータを基にします。';
$string['timesplitting:singlerange'] = '開始から終了まで';
$string['timesplitting:singlerange_help'] = 'この分析間隔はコース全体を単一期間とみなします。';
$string['timesplitting:tenpercentafterstart'] = '開始後10%';
$string['timesplitting:tenpercentafterstart_help'] = 'この分析間隔ではコースが10%完了した後の予測を生成します。';
$string['timesplitting:upcoming3days'] = '直近3日';
$string['timesplitting:upcoming3days_help'] = 'この分析間隔は3日ごとに予測を生成します。指標は直近3日を基に計算されます。';
$string['timesplitting:upcomingfortnight'] = '直近2週間';
$string['timesplitting:upcomingfortnight_help'] = 'この分析間隔は2週間ごとに予測を生成します。指標は直近2週間を基に計算されます。';
$string['timesplitting:upcomingweek'] = '次週';
$string['timesplitting:upcomingweek_help'] = '分析間隔は毎週予測を生成します。指標は次週を基に計算されます。';
$string['timezone'] = 'タイムゾーン';
$string['to'] = 'To';
$string['tocontent'] = '移動先: {$a}';
$string['tocreatenewaccount'] = '新しいアカウント作成にスキップする';
$string['today'] = '本日';
$string['todaylogs'] = '本日のログ';
$string['toeveryone'] = '全員';
$string['toggleemojipicker'] = '絵文字ピッカを切り替える';
$string['toomanybounces'] = 'このメールアドレスには多くの宛先不明メールが戻って来ています。続けるにはメールアドレスを<b>変更してください</b>。';
$string['toomanytags'] = 'この検索には多すぎるタグを含むため、いくつかは無視されました。';
$string['toomanytoshow'] = '表示するユーザが多すぎます。';
$string['toomanyusersmatchsearch'] = '「{$a->search}」に対して合致するユーザ ({$a->count}) が多すぎます。';
$string['toomanyuserstoshow'] = '表示するユーザ ({$a}) が多すぎます。';
$string['toonly'] = '{$a} のみ';
$string['top'] = 'トップ';
$string['topic'] = 'トピック';
$string['topichide'] = 'このトピックを {$a} から隠す';
$string['topicoutline'] = 'トピックアウトライン';
$string['topicshow'] = 'このトピックを {$a} に表示する';
$string['toplevelcategory'] = 'トップレベルカテゴリ';
$string['total'] = '合計';
$string['totopofsection'] = 'セクション「 {$a} 」のトップ';
$string['trackforums'] = 'フォーラム未読管理';
$string['trackforumsno'] = 'いいえ: 私が閲覧した投稿を追跡しません';
$string['trackforumsyes'] = 'はい: 私に新しい投稿をハイライトしてください';
$string['trysearching'] = '代わりに検索してください。';
$string['turneditingoff'] = '編集モードの終了';
$string['turneditingon'] = '編集モードの開始';
$string['unauthorisedlogin'] = 'このサイトではユーザアカウント「 {$a} 」は利用できません。';
$string['undecided'] = '未決定';
$string['unfinished'] = '未了';
$string['unknowncategory'] = '不明のカテゴリ';
$string['unknownerror'] = '不明なエラー';
$string['unknownuser'] = '不明なユーザ';
$string['unlimited'] = '無制限';
$string['unpacking'] = '{$a} の展開';
$string['unsafepassword'] = '安全ではないパスワードです - 他のパスワードを入力してください。';
$string['untilcomplete'] = '完了するまで';
$string['unusedaccounts'] = '{$a} 日以上利用されていないアカウントは自動的に登録解除されます。';
$string['unzip'] = '展開';
$string['unzippingbackup'] = 'バックアップの展開';
$string['up'] = '上へ';
$string['update'] = '更新';
$string['updated'] = '{$a} を更新しました。';
$string['updatemymoodleoff'] = 'このページのカスタマイズを終了する';
$string['updatemymoodleon'] = 'このページをカスタマイズする';
$string['updatemyprofile'] = 'プロファイルを更新する';
$string['updatesevery'] = '{$a} 秒ごとに更新する';
$string['updatethis'] = 'この {$a} を更新する';
$string['updatethiscourse'] = 'このコースを更新する';
$string['updatinga'] = '更新中: {$a}';
$string['updatingain'] = '{$a->in} の {$a->what} を更新中';
$string['upload'] = 'アップロード';
$string['uploadafile'] = 'ファイルをアップロードする';
$string['uploadcantwrite'] = 'ディスクへのファイル書き込みに失敗しました。';
$string['uploadedfile'] = 'ファイルが正常にアップロードされました。';
$string['uploadedfileto'] = '{$a->file} を {$a->directory} にアップロードしました。';
$string['uploadedfiletoobig'] = '申し訳ございません、ファイルサイズが大きすぎます (上限 {$a} バイト)。';
$string['uploadextension'] = 'PHP拡張モジュールを原因としてファイルアップロードが停止しました。';
$string['uploadfailednotrecovering'] = 'ファイル {$a->name} に問題があるため、あなたのファイルは正常にアップロードされませんでした。<br /> この問題に関するログ:<br />{$a->problem}<br />この問題は解消されていません。';
$string['uploadfilelog'] = 'ファイル {$a} のアップロードログ';
$string['uploadformlimit'] = 'アップロードファイル「 {$a} 」がフォームで設定された最大サイズを超えました。';
$string['uploadlabel'] = 'タイトル:';
$string['uploadlimitwithsize'] = '{$a->contextname} アップロード上限 ({$a->displaysize})';
$string['uploadnewfile'] = '新しいファイルをアップロードする';
$string['uploadnofilefound'] = 'ファイルが見つかりませんでした - アップロードするファイルを選択しましたか?';
$string['uploadnotallowed'] = 'アップロードは許可されていません';
$string['uploadnotempdir'] = '一時フォルダがありません。';
$string['uploadoldfilesdeleted'] = 'あなたのアップロードエリアの古いファイルが削除されました。';
$string['uploadpartialfile'] = 'ファイルが部分的にアップロードされました。';
$string['uploadproblem'] = 'ファイル「 {$a} 」のアップロード中、不明なエラーが発生しました (ファイルサイズが大きすぎると思われます)。';
$string['uploadrenamedchars'] = '無効な文字が使用されているため、ファイルが {$a->oldname} から {$a->newname} にリネームされました。';
$string['uploadrenamedcollision'] = '同一名称のファイルが存在するため、ファイルが {$a->oldname} から {$a->newname} にリネームされました。';
$string['uploadserverlimit'] = 'アップロードファイルがサーバで設定された最大サイズ制限を超えました。';
$string['uploadthisfile'] = 'このファイルをアップロードする';
$string['url'] = 'URL';
$string['used'] = '使用';
$string['usedinnplaces'] = '{$a} 箇所で使用';
$string['user'] = 'ユーザ';
$string['useraccount'] = 'ユーザアカウント';
$string['useractivity'] = '活動';
$string['userconfirmed'] = '{$a} を承認しました';
$string['userdata'] = 'ユーザデータ';
$string['userdeleted'] = 'このユーザのアカウントは削除されました。';
$string['userdescription'] = '自己紹介';
$string['userdescription_help'] = 'このテキストボックスにはあなた自身に関するテキストを入力することができます。入力した内容は他のユーザが閲覧できるようあなたのプロファイルページに表示されます。';
$string['userdetails'] = 'ユーザ詳細';
$string['userfiles'] = 'ユーザファイル';
$string['userfilterplaceholder'] = 'キーワードで探すかフィルタを選択する';
$string['userlist'] = 'ユーザリスト';
$string['usermenu'] = 'ユーザメニュー';
$string['username'] = 'ユーザ名';
$string['usernameemail'] = 'ユーザ名/メール';
$string['usernameemailmatch'] = 'ユーザ名およびメールアドレスが同じユーザに関連していません。';
$string['usernameexists'] = 'このユーザ名はすでに使用されています。別のユーザ名を選択してください。';
$string['usernamelowercase'] = '小文字のみ使用できます。';
$string['usernamenotfound'] = 'ユーザ名がデータベース内に見つかりませんでした。';
$string['usernameoremail'] = 'ユーザ名またはメールアドレスを入力してください。';
$string['usernotconfirmed'] = '{$a} を確認できませんでした。';
$string['userpic'] = 'ユーザ画像';
$string['userpreferences'] = 'ユーザプレファレンス';
$string['users'] = 'ユーザ';
$string['userselectorautoselectunique'] = '検索該当ユーザが1名のみの場合、自動的にユーザを選択する';
$string['userselectorpreserveselected'] = '検索に合致しない場合でも、選択したユーザを保持する';
$string['userselectorsearchanywhere'] = '表示フィールドのどの部分に対しても、検索テキストを一致させる';
$string['usersnew'] = '新しいユーザ';
$string['usersnoaccesssince'] = '次の期間以上活動していない';
$string['userswithfiles'] = 'ファイルを含むユーザ';
$string['useruploadtype'] = 'ユーザアップロードタイプ: {$a}';
$string['userzones'] = 'ユーザゾーン';
$string['usetheme'] = 'テーマを使用する';
$string['usingexistingcourse'] = '既存のコースを使用する';
$string['validatehtml'] = 'HTMLを検証する';
$string['valuealreadyused'] = 'この値はすでに使用されています。';
$string['version'] = 'バージョン';
$string['view'] = '表示';
$string['viewallcourses'] = 'すべてのコースを表示する';
$string['viewallcoursescategories'] = 'すべてのコースおよびカテゴリを表示する';
$string['viewallsubcategories'] = 'すべてのサブカテゴリを表示する';
$string['viewfileinpopup'] = 'ファイルをポップアップウィンドウに表示する';
$string['viewing'] = '表示:';
$string['viewmore'] = 'さらに表示する';
$string['viewprofile'] = 'プロファイルを表示する';
$string['views'] = '表示';
$string['viewsolution'] = '解決方法を表示する';
$string['visible'] = '可視性';
$string['visible_help'] = 'この設定ではコース一覧にコースを表示するかどうか決定します。教師および管理者以外、ユーザはコースへ入ることを許可されません。';
$string['visibletostudents'] = '{$a} に表示する';
$string['warning'] = '警告';
$string['warningdeleteresource'] = '警告: {$a} はりソースで参照されています。本当にリソースを更新してもよろしいですか?';
$string['wcagcheck'] = 'ウェブコンテンツアクセシビリティガイドライン (WCAG) チェック';
$string['webpage'] = 'ウェブページ';
$string['week'] = '週';
$string['weekhide'] = '{$a} からこの週を隠す';
$string['weeklyoutline'] = 'ウィークリーアウトライン';
$string['weeks'] = '週';
$string['weekshow'] = '{$a} にこの週を表示する';
$string['welcometocourse'] = '{$a} へようこそ';
$string['welcometocoursetext'] = '{$a->coursename} へようこそ!

まだプロファイルの編集が終えていない場合、私や受講している皆さんがあなたのことを知れるようにあなたのプロファイルページを編集してください:

 {$a->profileurl}';
$string['whatforlink'] = 'このリンクで何をしますか?';
$string['whatforpage'] = 'このテキストで何をしますか?';
$string['whatisyourage'] = 'あなたの年齢は?';
$string['whattocallzip'] = 'Zipファイルの名称は?';
$string['whattodo'] = '処理';
$string['wheredoyoulive'] = 'あなたが住んでいる国は?';
$string['whyisthisrequired'] = 'なぜこれが必要ですか?';
$string['windowclosing'] = 'このウィンドウは自動的に閉じられます。自動的に閉じられない場合、ウィンドウを閉じてください。';
$string['withchosenfiles'] = '選択したものを';
$string['withdisablednote'] = '{$a} (無効)';
$string['withoutuserdata'] = 'ユーザデータを除く';
$string['withselectedusers'] = '選択したユーザに対して ...';
$string['withuserdata'] = 'ユーザデータを含む';
$string['wordforstudent'] = '学生 (単数) に対する呼称';
$string['wordforstudenteg'] = '例) 学生、参加者等';
$string['wordforstudents'] = '学生 (複数) に対する呼称';
$string['wordforstudentseg'] = '例) 学生、参加者等';
$string['wordforteacher'] = '教師 (単数) に対する呼称';
$string['wordforteachereg'] = '例 教師、チューター、世話役等';
$string['wordforteachers'] = '教師 (複数) に対する呼称';
$string['wordforteacherseg'] = '例 教師、チューター、世話役等';
$string['writingblogsinfo'] = 'ブログ情報の書き出し';
$string['writingcategoriesandquestions'] = 'カテゴリおよび質問の書き出し';
$string['writingcoursedata'] = 'コースデータの書き出し';
$string['writingeventsinfo'] = 'イベント情報の書き出し';
$string['writinggeneralinfo'] = '一般情報の書き出し';
$string['writinggradebookinfo'] = '評定表情報の書き出し';
$string['writinggroupingsgroupsinfo'] = 'グルーピング-グループ情報の書き出し';
$string['writinggroupingsinfo'] = 'グルーピング情報の書き出し';
$string['writinggroupsinfo'] = 'グループ情報の書き出し';
$string['writingheader'] = 'ヘッダの書き出し';
$string['writingloginfo'] = 'ログ情報の書き出し';
$string['writingmessagesinfo'] = 'メッセージ情報の書き出し';
$string['writingmoduleinfo'] = 'モジュール情報の書き出し';
$string['writingscalesinfo'] = '評価尺度情報の書き出し';
$string['writinguserinfo'] = 'ユーザ情報の書き出し';
$string['wrongpassword'] = 'このユーザ名のパスワードは正しくありません。';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = '年';
$string['years'] = '年';
$string['yes'] = 'Yes';
$string['youareabouttocreatezip'] = 'あなたは以下のファイルを含むzipファイルを作成しようとしています';
$string['youaregoingtorestorefrom'] = 'あなたは以下のファイルの復元処理を開始しようとしています';
$string['youhaveupcomingactivitiesdue'] = 'あなたには期限が近付いている活動があります。';
$string['youhaveupcomingactivitiesdueinfo'] = '{$a} さん

<br/><br/>あなたには期限が近付いている活動があります:';
$string['youneedtoenrol'] = 'この操作を実行するにはあなたはこのコースに登録する必要があります。';
$string['yourlastlogin'] = 'あなたの最終ログイン';
$string['yourself'] = 'あなた自身';
$string['yourteacher'] = 'あなたの {$a}';
$string['yourwordforx'] = '「{$a} 」に対するあなたの呼称';
$string['zippingbackup'] = 'バックアップファイルをZIP圧縮中';
