<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'vpl', language 'ja', version '3.9'.
 *
 * @package     vpl
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['VPL_COMPILATIONFAILED'] = 'コンパイルか実行の準備に失敗しました';
$string['about'] = 'VPLについて';
$string['acceptcertificates'] = '自己署名証明書を受諾';
$string['acceptcertificates_description'] = '実行サーバが自己署名証明書を使用していない場合はこのオプションのチェックをはずしてください。';
$string['acceptcertificatesnote'] = '<p>あなたは暗号化接続を使用しています。</p>
<p>実行サーバとの接続に暗号化接続を使用するためには、証明書の受諾が必要です。</p>
<p>このプロセスで問題が発生した場合、http(非暗号化接続)を使用するか、他のブラウザを使用してください。</p>
<p>以下のリンク(サーバ #)をクリックして、サーバ証明書を受諾してください。</p>';
$string['addfile'] = 'ファイルの追加';
$string['allfiles'] = 'すべてのファイル';
$string['allsubmissions'] = 'すべての提出物';
$string['always_use_ws'] = 'つねに非暗号化Websocketプロトコル(ws)を使用';
$string['always_use_wss'] = 'つねに暗号化Websocketプロトコル(wss)を使用';
$string['anyfile'] = '任意のファイル';
$string['attemptnumber'] = '試行番号{$a}';
$string['autodetect'] = '自動検出';
$string['automaticevaluation'] = '自動実行';
$string['automaticgrading'] = '自動評価';
$string['averagetime'] = '平均時間 {$a}';
$string['basedon'] = 'オプションのコピー';
$string['basic'] = '基本';
$string['binaryfile'] = 'バイナリ・ファイル';
$string['browserupdate'] = 'Webブラウザを最新版に更新してください。<br />もしくはWebcoketに対応済みのブラウザを使用してください。';
$string['calculate'] = '計算';
$string['changesNotSaved'] = '変更は保存されません';
$string['check_jail_servers'] = 'jailサーバのチェック';
$string['check_jail_servers_help'] = '<h1>jailサーバのチェック</h1>
<p>このページでは、この活動で利用するjailサーバの状態を検査して表示する。</p>';
$string['clipboard'] = 'クリップボード';
$string['closed'] = '終了';
$string['comments'] = 'コメント';
$string['compilation'] = 'コンパイル';
$string['connected'] = '接続した';
$string['connecting'] = '接続中';
$string['connection_closed'] = '接続が閉じられました';
$string['connection_fail'] = '接続に失敗しました';
$string['console'] = 'コンソール';
$string['copy'] = 'コピー';
$string['create_new_file'] = '新規ファイルの作成';
$string['currentstatus'] = '現在の状態';
$string['cut'] = 'カット';
$string['datesubmitted'] = '提出されたデータ';
$string['debug'] = 'デバッグ';
$string['debugging'] = 'デバッグ中';
$string['debugscript'] = 'デバッグ・スクリプト';
$string['debugscript_help'] = 'この活動で使用するデバッグ・スクリプトの選択';
$string['defaultexefilesize'] = 'デフォルトの実行ファイルの最大サイズ';
$string['defaultexememory'] = 'デフォルトのメモリ使用量の最大値';
$string['defaultexeprocesses'] = 'デフォルトのプロセス数の最大値';
$string['defaultexetime'] = 'デフォルトの実行時間の最大値';
$string['defaultfilesize'] = 'デフォルトのアップロードファイルの最大値';
$string['defaultresourcelimits'] = 'デフォルトの実行時資源の制限';
$string['delete'] = '削除';
$string['delete_file_fq'] = 'ファイル\'{$a}\'を削除しますか?';
$string['delete_file_q'] = 'ファイルを削除しますか?';
$string['deleteallsubmissions'] = 'すべての提出物を削除する';
$string['depends_on_https'] = 'httpかhttpsかに応じてwsもしくはwssを使用';
$string['description'] = '説明';
$string['diff'] = '差分';
$string['discard_submission_period'] = '提出物を破棄する期間';
$string['discard_submission_period_description'] = 'すべての学生と課題に関して、システムは提出物の破棄を試みます。システムは、最後に提出された物と、すべての期間について少なくとも1つの提出物を保持します';
$string['download'] = 'ダウンロード';
$string['downloadallsubmissions'] = 'すべての提出物をダウンロード';
$string['downloadsubmissions'] = '提出物をダウンロード';
$string['duedate'] = '締め切り日時';
$string['edit'] = '編集';
$string['editing'] = '編集中';
$string['editortheme'] = 'エディタ・テーマ';
$string['evaluate'] = '評価';
$string['evaluateonsubmission'] = '提出時に評価';
$string['evaluating'] = '評価中';
$string['evaluation'] = '評価結果';
$string['examples'] = '例';
$string['execution'] = '実行';
$string['executionfiles'] = '実行ファイル';
$string['executionfiles_help'] = '<h1>実行ファイル</h1>
<h2>イントロダクション</h2>
<p>ここでは、実行準備、デバッグ、提出物の評価などに必要なファイルを設定する。
これには、スクリプトファイル、プログラムのテストファイル、データファイルなどがある。</p>
<h2>実行やデバッグのためのデフォルトスクリプト</h2>
<p>実行やデバッグのためのスクリプトファイルを設定しなかった場合、
システムは使用しているプログラミング言語を（ファイルの拡張子から）判定し、
あらかじめ定義されているスクリプトファイルを用いる。
次に示す表は、使用可能なプログラミング言語、ファイル名の拡張子、
スクリプトが準備されているか、スクリプトによりコンパイラ/インタプリタ/デバッガが使えるのかが示してある。
<table>
<tr><th>言語</th>
<th>ファイル名<br />
拡張子</th>
<th>実行</th>
<th>デバッグ</th>
<th>コンパイラ/<br />インタプリタ</th>
<th>コメント</th>
</tr>
<tr>
<td>Ada</td><td>ada, adb, ads</td><td>X</td><td>X</td><td>gnat (Ada 2005)/gdb</td><td>最初のファイルをメインとして扱う</td>
</tr>
<tr>
<td>C</td><td>c</td><td>X</td><td>X</td><td>gcc C99/gdb</td><td>すべてのソースファイルをコンパイルする</td>
</tr>
<tr>
<td>C++</td><td>cpp, C</td><td>X</td><td>X</td><td>g++/gdb</td><td>すべてのソースファイルをコンパイルする</td>
</tr>
<tr>
<td>C#</td><td>cs</td><td>X</td><td>X</td><td>gmcs+mono/mdb</td><td>すべてのソースファイルをコンパイルする</td>
</tr>
<tr>
<td>Fortran</td><td>f, f77</td><td>X</td><td>X</td><td>gfortran/gdb</td><td>すべてのソースファイルをコンパイルする</td>
</tr>
<tr>
<td>Haskell</td><td>hs</td><td>X</td><td></td><td>hugs</td><td>最初のファイルを実行する</td>
</tr>
<tr>
<td>Java</td><td>java</td><td>X</td><td>X</td><td>javac+java/jdb</td><td>すべてのソースファイルをコンパイルする<br />メインファイルを指定する</td>
</tr>
<tr>
<td>Matlab/Octave</td><td>m</td><td>X</td><td>-</td><td>matlab, octave</td><td>最初のファイルを実行する<br>描画後にvpl_replotを使用する</td>
</tr>
<tr>
<td>Pascal</td><td>pas, p</td><td>X</td><td>X</td><td>fpc or gpc/gdb</td><td>最初のファイルをコンパイル(fpc)<br />すべてのソースファイルをコンパイル(gpc)</td>
</tr>
<tr>
<td>Perl</td><td>perl, prl</td><td>X</td><td>X</td><td>perl</td><td>最初のファイルを実行する</td>
</tr>
<tr>
<td>PHP</td><td>php</td><td>X</td><td>-</td><td>php5</td><td>最初のファイルを実行する</td>
</tr>
<tr>
<td>Prolog</td><td>pl, pro</td><td>X</td><td>-</td><td>swipl</td><td>最初のファイルを実行する</td>
</tr>
<tr>
<td>Python</td><td>py</td><td>X</td><td>X</td><td>python</td><td>最初のファイルを実行する</td>
</tr>
<tr>
<td>Ruby</td><td>rb</td><td>X</td><td>X</td><td>ruby</td><td>最初のファイルを実行する</td>
</tr>
<tr>
<td>Scheme</td><td>scm, s</td><td>X</td><td>-</td><td>mzscheme</td><td>最初のファイルを実行する</td>
</tr>
<tr>
<td>Shell script</td><td>sh</td><td>X</td><td>-</td><td>bash</td><td>最初のファイルを実行する</td>
</tr>
<tr>
<td>SQL</td><td>sql</td><td>X</td><td>-</td><td>sqlite3</td><td>すべてのファイルを実行する<br />最初のファイルを実行する</td>
</tr>
<tr>
<td>VHDL</td><td>vhd, vhdl</td><td>X</td><td>-</td><td>ghdl</td><td>すべてのファイルコンパイルするが、最初のファイルにMainメソッドがなければならない</td>
</tr>
</table>
<h2>自動評価</h2>
<p>VPL1.4では、学生の提出物を評価する機能が導入された。
この機能により、学生のプログラムを実行し、決められた入力に対する出力を検査できる。
評価のためのケースを準備するには、&quot;vpl_evaluate.cases&quot;ファイルを準備する。</p>
<p>"vpl_evaluate.cases"ファイルは、次のような形式である。
<ul>
<li> "<strong>case </strong>= ケースの説明": 省略可能。テストケースの定義を開始することを示す。</li>
<li> "<strong>input </strong>= テキスト": プログラムに対する入力。複数行に渡ってもよい。他の指示行により終了する。</li>
<li> "<strong>output </strong>= テキスト": 想定されるプログラムの出力。複数行に渡ってもよい。他の指示行により終了する。ケースごとに複数の正解の出力を持つことができる。出力には次の3種類がある。
<ul>
<li> <strong>数値</strong>: 数値（整数または浮動小数点数）の並び。出力中の数字だけが検査され、その他のテキストは無視される。浮動小数点数は誤差を許容する形で検査される。</li>
<li> <strong>テキスト</strong>: ダブルクォートでくくらないテキストとして定義。単語だけが検査されその他の文字は無視される。比較は大文字と小文字を無視して行われる。</li>
<li> <strong>厳密なテキスト</strong>: テキストをダブルクォートでくくって定義。出力の検査に厳密な比較が行われる。</li>
</ul>
</li>
<li> "<strong>grade reduction</strong> = [値|パーセンテージ%]" : デフォルトでは、エラーにより学生の評価は(最高評価)から(評価幅/ケース数)だけ削減されるが、これを指定すると削減される値やパーセンテージを変更できる。</li>
</ul>

<h2>汎用のファイル</h2>
<p>新しいファイルは、&quot;<b>ファイルの追加</b>&quot;ボックスにファイル名を指定して&quot;<b>ファイルの追加</b>&quot;ボタンを押すことで追加できる。</p>
<p>既存のファイルをアップロードする場合には、&quot;<b>ファイルのアップロード</b>&quot;を使う。</p>
<p>すべての追加されたまたはアップロードされたファイルは編集可能であり、
次に示す3つの名前のスクリプトファイル以外は自由に名前を変更したり削除したりできる。</p>

<h2>自作のrun, execute, evaluation</h2>
<p>処理の準備のための3つのスクリプトファイルを設定できる。
これらの名前は決まっており、
<b>vpl_run.sh</b>（実行用）、
<b>vpl_debug.sh</b>（デバッグ用）、
<b>vpl_evaluate.sh</b>（評価用）である。</p>
<p>これらのスクリプトを実行したときには、
<b>vpl_execution</b>と言う名前のファイルを生成しなければならない。
このファイルは、実行可能ファイルか&quot;#!/bin/sh &quot;で始まるスクリプトファイルでなければならない。
このファイルを生成しないと、選択したアクションを実行できなくなる。</p>
<p>設定している活動が別の活動から「オプションのコピー」しているなら、
参照元の活動におけるファイルが自動的に追加される。
vpl_run.sh、vpl_debug.sh、vpl_evaluate.shファイルの内容は、
現在の活動から「オプションのコピー」のレベルが深い物から順に連結される。</p>
<p>最後に、<b>vpl_environment.sh</b>ファイルが自動的に追加される。
このスクリプトファイルには、提出物に関する情報が含まれている。
この情報は、環境変数として参照できる。</p>
<ul> <li> LANG: 使用する言語 </li>
<li> LC_ALL: LANGと同じ </li>
<li> VPL_MAXTIME: 秒単位の実行時間の最長限度</li>
<li> VPL_FILEBASEURL: コースのファイルにアクセスするためのURL</li>
<li> VPL_SUBFILE#:  学生により提出されたそれぞれのファイルの名前。#は0から提出されたファイル数まで </Li>
<li> VPL_SUBFILES: すべての提出されたファイルのリスト </li>
<li> VPL_VARIATION + id: ここで、idは0から始まるバリエーションの順番である。また、値はバリエーションの値である </li>
</ul>
要求されたアクションが評価の場合、さらに次の変数が追加される。
<ul>
	<li>VPL_MAXTIME: 秒単位の実行時間の最長限度</li>
	<li>VPL_MAXMEMORY: 利用可能な最大メモリ</li>
	<li>VPL_MAXFILESIZE: バイト単位の作成可能なファイルの最大サイズ</li>
	<li>VPL_MAXPROCESSES: 同時に実行可能なプロセスの最大数</li>
	<Li>VPL_FILEBASEURL: コースファイルへのURL</li>
	<li>VPL_GRADEMIN: この活動の評価の最小値</li>
	<li>VPL_GRADEMAX: この活動の評価の最大値</li>
</ul>
<h2>評価結果</h2>
<p>評価の出力が取り出され、可能であればコメントとして、提案された評価とともに表示される。
コメントは2つの方法で設定できる。
\'Comment :=&gt;&gt;\'で始まる行は、1行コメントとして取り扱われる。
\'&lt;|--\'だけの行から\'--|&gt;\'だけの行までの間は、
ブロックコメントとして扱われる。
評価は\'Grade :=&gt;&gt;\'で始まる最後の行から取り出される。
</p>';
$string['executionoptions'] = '実行オプション';
$string['executionoptions_help'] = '<h1>実行オプション</h1>
<p>このページでは、各種実行時オプションを設定する。</p>
<ul>
<li><b>オプションのコピー</b>: 他のVPL活動から設定などを取り込む
<ul><li>実行ファイル（あらかじめ決められたスクリプトファイルを連結する）</li>
<li>実行時リソースに関する制限</li>
<li>バリエーションは連結される</li>
<li>提出時にアップロードされるそれぞれのファイルの最大長</li>
</ul>
</li>
<li><b>実行</b>、<b>デバッグ</b>、<b>評価</b>: 提出物の編集中にそれぞれのアクションを可能にするのであれば"Yes"に設定する。これは学生にのみ影響する。評価が可能なユーザに対しては、これらの機能は常に利用可能である。</li>
<li><b>提出時に評価</b>: 提出物は、アップロードされたときに自動的に評価される。</li>
<li><b>自動評価</b>: 評価結果に評価コードが含まれる場合、自動的に評価の値として設定される。</li>
</ul>';
$string['file'] = 'ファイル';
$string['fileNotChanged'] = 'ファイルは変更されていません';
$string['file_name'] = 'ファイル名';
$string['fileadded'] = 'ファイル {$a} が追加されました';
$string['filedeleted'] = 'ファイル {$a} が削除されました';
$string['filelist'] = 'ファイルリスト';
$string['filenotadded'] = 'ファイルは追加されていません';
$string['filenotdeleted'] = 'ファイル {$a} は削除されません';
$string['filenotrenamed'] = 'ファイル {$a} は名前変更されません';
$string['filerenamed'] = 'ファイル {$a->from} は {$a->to} に名前変更されました';
$string['filesChangedNotSaved'] = 'ファイルが変更されていますが保存されていません';
$string['filesNotChanged'] = 'ファイルは変更されていません';
$string['filestoscan'] = '調べるファイル';
$string['fileupdated'] = 'ファイル {$a} は更新されています';
$string['find'] = '検索';
$string['find_replace'] = '検索/置換';
$string['freeevaluations'] = '自動評価';
$string['freeevaluations_help'] = '最終評点が減点されない自動評価の回数';
$string['fulldescription'] = '詳細説明';
$string['fulldescription_help'] = '<h1>詳細説明</h1>
<p>ここには、活動の詳細な説明を書かなければならない。</p>
<p>ここに何も書かなければ、簡単な説明が代わりに表示される。</p>
<p>自動的に評価するつもりならば、課題のインタフェースは詳細に曖昧でない形で示さなければならない。</p>';
$string['fullscreen'] = '全画面';
$string['getjails'] = '実行サーバの取得';
$string['gradeandnext'] = '採点して次へ';
$string['graded'] = '採点済み';
$string['gradedbyuser'] = '採点者';
$string['gradedon'] = '採点日時';
$string['gradedonby'] = '{$a->gradername} により {$a->date} にレビュー';
$string['gradenotremoved'] = '採点は取り除けません。採点帳の活動設定を確認してください。';
$string['gradenotsaved'] = '採点は保存されていません。採点帳の活動設定を確認してください。';
$string['gradeoptions'] = '採点オプション';
$string['grader'] = '採点者';
$string['gradercomments'] = '採点者のコメント';
$string['graderemoved'] = '採点は削除されました';
$string['groupwork'] = 'グループワーク';
$string['inconsistentgroup'] = 'あなたが所属しているグループ数は1ではありません';
$string['incorrect_file_name'] = '不正なファイル名';
$string['individualwork'] = '個別の作業';
$string['instanceselection'] = 'VPLセレクション';
$string['isexample'] = 'この活動は例としてふるまう';
$string['jail_servers'] = 'jailサーバリスト';
$string['jail_servers_config'] = 'jailサーバ設定';
$string['jail_servers_description'] = 'サーバごとに1行記述';
$string['joinedfiles'] = '選択したファイルを結合';
$string['keepfiles'] = '実行時に保持するファイル';
$string['keepfiles_help'] = '<h1>実行時に保持するファイル</h1>
<p>セキュリティ上の問題により、&quot;実行ファイル&quot;により追加されたファイルはvpl_executionファイルの実行前に削除される。</p>
<p>これらのファイルを（例えば、テストデータとして用いるなど）実行時に残しておく必要がある場合、ここで指定する。</p>';
$string['keyboard'] = 'キーボード';
$string['lasterror'] = '最新のエラー情報';
$string['lasterrordate'] = '最新のエラー日時';
$string['listofcomments'] = 'コメントのリスト';
$string['listsimilarity'] = '類似を検出したリスト';
$string['listwatermarks'] = '透かしのリスト';
$string['local_jail_servers'] = 'ローカルのjailサーバ';
$string['local_jail_servers_help'] = '<h1>ローカルjailサーバ</h1>
<p>ここでは、この活動で利用するローカルjailサーバを追加し設定できる。</p>
<p>サーバのURLを1台につき1行で入力する。このとき、空行や"#"で始まるコメント行も利用できる。</p>
<p>この活動は、jailサーバリストを利用します。
このサーバリストは、ここで設定されたサーバに加え、コピー元の活動のリスト、
さらには共通のリストから構成される。
もしこの活動やここからコピーされる活動が他のサーバを利用しないようにするには、
サーバリストの最後に"end_of_jails"を含む行を記述する。</p>';
$string['manualgrading'] = '手作業の採点';
$string['maxexefilesize'] = '実行ファイルの最大サイズ';
$string['maxexememory'] = '使用メモリの最大サイズ';
$string['maxexeprocesses'] = 'プロセス数の最大数';
$string['maxexetime'] = '実行時間の最長限度';
$string['maxfiles'] = '提出可能なファイル数';
$string['maxfilesexceeded'] = 'ファイルの最大数を超えました';
$string['maxfilesize'] = 'ファイルの最大サイズ';
$string['maxfilesizeexceeded'] = 'ファイルの最大サイズを超えました';
$string['maxresourcelimits'] = '実行時資源の最大値';
$string['maxsimilarityoutput'] = '類似度による最大の出力';
$string['menucheck_jail_servers'] = 'jailサーバのチェック';
$string['menuexecutionfiles'] = 'ファイル';
$string['menuexecutionoptions'] = 'オプション';
$string['menukeepfiles'] = '保持するファイル';
$string['menulocal_jail_servers'] = 'ローカルjailサーバ';
$string['menuresourcelimits'] = 'リソース制限';
$string['minsimlevel'] = '表示する最小の類似度のレベル';
$string['moduleconfigtitle'] = 'VPLモジュール設定';
$string['modulename'] = 'Virtual programming lab';
$string['modulename_help'] = '<p>VPLは、プログラミング課題の管理をするためのMoodleの活動モジュールであり、次のような特徴を持っている。</p>
<ul>
<li>アプレットを用い、プログラムのソースコードをブラウザ内で編集することが可能</li>
<li>学生はブラウザ内でプログラムを対話的に実行可能（ここの環境では不可）</li>
<li>プログラムのレビューのためにテストケースで実行可能</li>
<li>ファイル間の類似度を検索できる</li>
<li>編集に制限を掛けたり、外部からの貼り付けを無効にできる</li>
</ul>
<p>提出に関する制限は、<b>提出の制限</b>パネルで設定できる。</p>
<ul>
<li>提出可能なファイル数。ファイル名は「要求されたファイル」タブで設定できる。</li>
<li>制限されたコードエディタを用いた提出しか許さない。
このオプションを設定した場合、ファイルをアップロードしたり、コードエディタ外からテキストを貼り付けることができなくなる。</li>
<li>アップロードするファイルの最大サイズ。</li>
<li>活動にアクセスしたり課題を提出するためのパスワード。
パスワードを設定した場合、活動にアクセスするときにシステムがパスワードを問い合わせる。</li>
<li>提出することができるネットワーク。</li>
</ul>
<p>また、評価のスケールやグループなど、標準的なオプションもこのページで設定できる。</p>';
$string['modulename_link'] = 'mod/vpl/view';
$string['modulenameplural'] = 'Virtual programming labs';
$string['new'] = '新規';
$string['new_file_name'] = '新規ファイル名';
$string['next'] = '次';
$string['nojailavailable'] = '利用可能なjailサーバがありません';
$string['noright'] = 'アクセス権限がありません';
$string['nosubmission'] = '提出物がありません';
$string['notexecuted'] = '実行されていません';
$string['notgraded'] = '採点待ち';
$string['notsaved'] = '未保存';
$string['novpls'] = 'Virtual programming labが定義されていません';
$string['nowatermark'] = '透かし {$a} を所有する';
$string['nsubmissions'] = '{$a} 提出物';
$string['numcluster'] = 'クラスタ {$a}';
$string['open'] = '開催中';
$string['opnotallowfromclient'] = 'このマシンではその動作は許されていません';
$string['options'] = 'オプション';
$string['optionsnotsaved'] = 'オプションは保存されていません';
$string['optionssaved'] = 'オプションが保存されました';
$string['origin'] = '元';
$string['othersources'] = '調査に加えるその他のソース';
$string['outofmemory'] = 'メモリー不足';
$string['paste'] = '貼り付け';
$string['pluginadministration'] = 'VPLの管理';
$string['pluginname'] = 'Virtual programming lab';
$string['previoussubmissionslist'] = 'これまでの提出物のリスト';
$string['proposedgrade'] = '提案された評価: {$a}';
$string['proxy'] = 'プロキシ';
$string['proxy_description'] = 'Moodleから実行サーバに接続するためのプロキシ';
$string['redo'] = '再実行';
$string['reductionbyevaluation'] = '自動評価ごとの減点';
$string['reductionbyevaluation_help'] = '学生が要求した自動評価ごとに最終評点から一定の評点または一定の割合を減点します';
$string['regularscreen'] = '通常画面';
$string['removegrade'] = '採点の削除';
$string['rename'] = '名前変更';
$string['rename_file'] = 'ファイル名の変更';
$string['replace_find'] = '置換/検索';
$string['requestedfiles'] = '要求されたファイル';
$string['requestedfiles_help'] = '<h1>要求されたファイル</h1>
<p>ここでは、活動の基本部で指定されたファイル数まで、要求されたファイルの名前を指定する。</p>
<p>もしファイル名が指定されていない物があれば、それらは提出しないことも可能であり、どんな名前を付けても良い。</p>
<p>要求されたファイルの内容を登録することも可能で、その場合、まだファイルが提出されていない間は、最初にエディタでファイルを開いたときにその内容が用いられる。</p>';
$string['requirednet'] = '提出が許可されたネットワーク';
$string['requiredpassword'] = 'パスワードが必要です';
$string['resetfiles'] = 'ファイルのリセット';
$string['resetvpl'] = '{$a} のリセット';
$string['resourcelimits'] = '実行リソース制限';
$string['resourcelimits_help'] = '<h1>実行時リソース制限</h1>
<p>実行時間、使用メモリ、実行ファイルの大きさ、同時に実行するプロセス数の制限を指定できる。</p>
<p>これらの制限は、スクリプトファイルvpl_run.sh、vpl_debug.sh、vpl_evaluate.shを実行する際や、
その実行により作られるvpl_executionファイルに適用される。</p>
<p>この活動がオプションを別の活動からコピーするようにしている場合、コピー元やその祖先の活動で設定されている制限、さらにはモジュール全体に対する制限に影響される。</p>';
$string['restrictededitor'] = 'コードエディタからの提出のみ';
$string['run'] = '実行';
$string['running'] = '実行中';
$string['runscript'] = '実行スクリプト';
$string['runscript_help'] = 'この活動で使用する実行スクリプトを選択';
$string['save'] = '保存';
$string['savecontinue'] = '保存して継続';
$string['saved'] = '保存済み';
$string['savedfile'] = 'ファイル {$a} は保存されました';
$string['saveoptions'] = 'オプションの保存';
$string['saving'] = '保存中';
$string['scanactivity'] = 'アクティビティ';
$string['scandirectory'] = 'ディレクトリ';
$string['scanningdir'] = 'ディレクトリの調査中';
$string['scanoptions'] = '調査オプション';
$string['scanother'] = '追加されたソースについて類似度を調査';
$string['scanzipfile'] = 'Zipファイル';
$string['select_all'] = 'すべて選択';
$string['server'] = 'サーバ';
$string['serverexecutionerror'] = 'サーバ実行エラー';
$string['shortcuts'] = 'キーボード・ショートカット';
$string['shortdescription'] = '短い説明';
$string['similarity'] = '類似度';
$string['similarto'] = '似ている';
$string['startdate'] = '使用可能日時';
$string['submission'] = '提出';
$string['submissionperiod'] = '提出期間';
$string['submissionrestrictions'] = '提出の制限';
$string['submissions'] = '提出物';
$string['submissionselection'] = '提出物のセレクション';
$string['submissionslist'] = '提出物リスト';
$string['submissionview'] = '提出物ビュー';
$string['submittedby'] = '提出者: {$a}';
$string['submittedon'] = '提出日時';
$string['submittedonp'] = '{$a} に提出された';
$string['sureresetfiles'] = '変更を破棄してファイルを元の状態に戻しますか?';
$string['test'] = 'テスト';
$string['testcases'] = 'テストケース';
$string['timelimited'] = '時間制限あり';
$string['timeout'] = 'タイムアウト';
$string['timeunlimited'] = '時間制限なし';
$string['totalnumberoferrors'] = 'エラー';
$string['undo'] = '取り消し';
$string['unzipping'] = '展開中...';
$string['uploadfile'] = 'ファイルのアップロード';
$string['usevariations'] = 'バリエーションの利用';
$string['usewatermarks'] = '透かしの使用';
$string['usewatermarks_description'] = '学生のファイルに透かしを追加 (サポート済みの言語に限定)';
$string['variation_options'] = 'バリエーションオプション';
$string['variations'] = 'バリエーション';
$string['variations_help'] = '<h1>バリエーション</h1>
<p>活動には、いくつかのバリエーションを定義できる。このバリエーションは、ランダムに学生に割り当てられる。</p>
<p>活動にバリエーションがあるなら、それを示して、バリエーションに名前を指定する。</p>
<p>バリエーションには識別コードと説明がある。識別コードは、<b>vpl_environment.sh</b>ファイルによって、
それぞれの学生に割り当てられたバリエーションをスクリプトファイルに受け渡すために用いられる。
HTMLで書かれた説明は、対応するバリエーションが割り当てられた学生に提示される。</p>';
$string['variations_unused'] = 'アクティビティにはバリエーションがあるが無効化されている';
$string['variationtitle'] = 'バリエーションタイトル';
$string['varidentification'] = '識別コード';
$string['visiblegrade'] = '可視性';
$string['vpl'] = 'Virtual Programming Lab';
$string['vpl:addinstance'] = '新しいVPLインスタンスを追加';
$string['vpl:grade'] = 'VPL課題の採点';
$string['vpl:manage'] = 'VPL課題の管理';
$string['vpl:setjails'] = '特定のVPLインスタンスにjailサーバを割り当てる';
$string['vpl:similarity'] = 'VPL課題の類似度の検索';
$string['vpl:submit'] = 'VPL課題の提出';
$string['vpl:view'] = 'VPL課題の完全な説明の閲覧';
$string['vpl_debug.sh'] = 'このスクリプトは提出されたプログラムをデバッグのために準備します';
$string['vpl_evaluate.cases'] = '提出されたプログラムを評価するための実行時ケースをここに記述します';
$string['vpl_evaluate.sh'] = 'このスクリプトは提出されたプログラムを評価します';
$string['vpl_run.sh'] = 'このスクリプトは提出されたプログラムを実行のために準備します';
$string['websocket_protocol'] = 'Websocketプロトコル';
$string['websocket_protocol_description'] = 'ブラウザが実行サーバに接続するために使用するWebsocketプロトコル(ws:// もしくは wss://)の種類。';
$string['workingperiods'] = '作業時間';
$string['worktype'] = '作業の種類';
