<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_configurable_reports', language 'no', version '3.9'.
 *
 * @package     block_configurable_reports
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitypost'] = 'Bidrag i aktiviteten';
$string['activityview'] = 'Visninger av aktiviteten';
$string['addreport'] = 'Legg til rapport';
$string['anyone'] = 'Alle';
$string['anyone_summary'] = 'Alle brukerne på portalen vil kunne bruke denne rapporten';
$string['availablemarks'] = 'Tilgjengelige tilbakemeldinger';
$string['average'] = 'Gjennomsnitt';
$string['badconditionexpr'] = 'Uttrykket for betingelsene er ugyldig';
$string['badsize'] = 'Feil størrelse, den må være i &#37; eller px';
$string['badtablewidth'] = 'Feil bredde, den må være i &#37; eller absoluttverdi';
$string['blockname'] = 'Konfigurerbare Rapporter';
$string['calcs'] = 'Utregninger';
$string['categories'] = 'Kategorier';
$string['categoryfield'] = 'Kategori';
$string['categoryfieldorder'] = 'Sortering av kategorier';
$string['ccoursefield'] = 'Course field condition';
$string['cellalign'] = 'Cellejustering';
$string['cellsize'] = 'Cellestørrelse';
$string['cellwrap'] = 'Cell wrap';
$string['column'] = 'Kolonne';
$string['columnandcellproperties'] = 'Kolonne og celleegenskaper';
$string['columncalculations'] = 'Kolonneutregninger';
$string['columns'] = 'Kolonner';
$string['comp_calcs'] = 'Utregninger';
$string['comp_calcs_help'] = '<p>Her kan du legge til utregninger for kolonner, f.eks. gjennomsnittlig antall brukere påmeldt i kurs</p>

<p>Mer hjelp: <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">Plugin documentation</a></p>';
$string['comp_calculations'] = 'Utregninger';
$string['comp_calculations_help'] = '<p>Her kan du legge til utregninger for kolonner, f.eks. gjennomsnittlig antall brukere påmeldt i kurs</p>';
$string['comp_columns'] = 'Kolonner';
$string['comp_columns_help'] = '<p>Her kan du velge de ulike kolonnene du ønsker å bruke avhengig av rapporttypen.</p>

<p>Mer hjelp: <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">Plugin documentation</a></p>';
$string['comp_conditions'] = 'Betingelser';
$string['comp_conditions_help'] = '<p>Her kan du sette betingelsene (f.eks, kun kurs fra denne kategorien, kun brukere fra Spania, etc.. </p>

<p>Du kan legge til et logisk uttrykk om du bruker mer enn en betingelse.</p>

<p>Mer hjelp: <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">Plugin documentation</a></p>';
$string['comp_customsql'] = 'Standard SQL';
$string['comp_customsql_help'] = '<p>Legg til en SQL-spørring. Ikke bruke moodle databasens prefiks  $CFG->prefix, bruk istedenfor "prefix_" (without quotes)uten anførselstegn)</p>
<p>Eksempel: Velg * FROM prefix_course</p>

<p>Du kan finne mange SQLrapporter her: <a href="http://docs.moodle.org/en/ad-hoc_contributed_reports" target="_blank">ad-hoc contributed reports</a></p>

<p>Siden denne blokken støtter Tim Hunt\'s CustomSQL Queries Reports, kan du bruke enhver spørring.</p>

<p>Husk å legg til et tidsfilter hvis du skal bruke kurs med tidsinnstillinger. </p>

<p>For bruk av flere filter, se: <a href="http://docs.moodle.org/en/blocks/configurable_reports/#Creating_a_SQL_Report" target="_blank">Creating a SQL Report Tutorial</a></p>';
$string['comp_filters'] = 'Filterer';
$string['comp_filters_help'] = '<p>Her kan du velge hvilke filtere som skal vises.</p>

<p>Et filter lar brukeren velge hvilke kolonner i rapporten som skal inkluderes i resultatet</p>

<p>For å bruke filtere i en SQL-rapport se: <a href="http://docs.moodle.org/en/blocks/configurable_reports/#Creating_a_SQL_Report" target="_blank">Creating a SQL Report Tutorial</a></p>

<p>Mer hjelp: <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">Plugin documentation</a></p>';
$string['comp_ordering'] = 'Sortering';
$string['comp_ordering_help'] = '<p>Her kan du velge hvordan du ønsker å sortere resultatene fra rapporten ved å bruke felt og retning</p>

<p>Mer hjelp: <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">Plugin documentation</a></p>';
$string['comp_permissions'] = 'Tillatelser';
$string['comp_permissions_help'] = '<p>Her kan du velge hvem som skal se rapportene.</p>

<p>Du kan legge til et logisk uttrykk for tillatelsene dersom du bruker mer enn en betingelse.</p>

<p>Mer hjelp: <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">Plugin documentation</a></p>';
$string['comp_plot'] = 'Plot';
$string['comp_plot_help'] = '<p>Her kan du legge til grafer i rapporten ut fra rapportens kolonner og verdier</p>

<p>Mer hjelp: <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">Plugin documentation</a></p>';
$string['comp_template'] = 'Mal';
$string['comp_template_help'] = '<p>Du kan modifisere rapportens utseende ved å lage en mal</p>

<p>For å lage en mal, se merknader som du kan bruke i topptekst, bunntekst og for hver rapport ved å bruke hjelp-knappene eller informasjonen som er vist på samme skjermbilde.</p>

<p>Mer hjelp: <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">Plugin documentation</a></p>';
$string['componenthelp'] = 'Hjelp for denne komponenten';
$string['conditionexpr'] = 'Betingelse';
$string['conditionexpr_conditions'] = 'Betingelse';
$string['conditionexpr_conditions_help'] = '<p>Du kan kombinere betingelser ved å bruke en logisk kommando</p>

<p>Sett inn en gyldig logisk kommando ved å bruke disse operatorene: og, eller, verken (and, or, nor).</p>';
$string['conditionexpr_permissions'] = 'Tillatelser';
$string['conditionexpr_permissions_help'] = '<p>Du kan kombinere tillatelser ved å bruke et logisk uttrykk</p>

<p>Sett inn et gydlig logisk uttrykk ved å bruke disse operatorene. og, eller (and, or).</p>';
$string['conditionexprhelp'] = 'Sett inn en gyldig betingelse f.eks.: (c1 and c2) eller (c4 and c3)';
$string['conditions'] = 'Betingelser';
$string['configurable_reports:addinstance'] = 'Legg til den nye blokken Konfigurerbare Rapporter';
$string['configurable_reports:manageownreports'] = 'Administrer egne rapporter';
$string['configurable_reports:managereports'] = 'Administrer rapporter';
$string['configurable_reports:managesqlreports'] = 'Administrer SQL rapporter';
$string['configurable_reports:viewreports'] = 'Vis rapporter';
$string['confirmdeletereport'] = 'Er du sikker på at du ønsker å slette denne rapporten?';
$string['coursecategories'] = 'Kursfilter på kategori';
$string['coursecategory'] = 'kurs i kategori';
$string['coursechild'] = 'Courses that are children of';
$string['coursededicationtime'] = 'Tid brukt i kurset';
$string['coursefield'] = 'Course field';
$string['coursefieldorder'] = 'Sortering av kursfelt';
$string['coursemodules'] = 'Kursmodul';
$string['courseparent'] = 'Courses whose parent is';
$string['courses'] = 'Kurs';
$string['coursestats'] = 'Kursstatistikk';
$string['cron'] = 'Kjør automatisk daglig';
$string['cron_help'] = 'Tidfest denne spørringen til å kjøre en gang i døgnet (om natten)';
$string['crondescription'] = 'Tidfest denne spørringen til å kjøre en gang i døgnet (om natten)';
$string['crrepository'] = 'Rapportoversikt';
$string['crrepositoryinfo'] = 'Delt eksternlager med fullt operative rapporter';
$string['currentreportcourse'] = 'Nåværende kursrapport';
$string['currentreportcourse_summary'] = 'Kurset der rapporten er laget';
$string['currentuser'] = 'Aktiv bruker';
$string['currentuser_summary'] = 'Brukeren som ser på rapporten';
$string['currentusercourses'] = 'Brukerens kurs';
$string['currentusercourses_summary'] = 'En liste med brukerens kurs (kun synlige kurs)';
$string['currentuserfinalgrade'] = 'Nåværende brukers endelig karakter i emnet';
$string['currentuserfinalgrade_summary'] = 'Denne kolonnen viser den endelige karakteren for brukeren i kursraden';
$string['cuserfield'] = 'Betingelse for profilfelt';
$string['custom'] = 'Standard';
$string['customdateformat'] = 'Standard datoformat';
$string['customsql'] = 'Tilpass SQL';
$string['datatables'] = 'Aktiver JS datatabell-bibliotek';
$string['datatablesinfo'] = 'JS datatabell-bibliotek (kolonnesortering, låste kolonneoverskrifter, søk, sidenummerering...)';
$string['date'] = 'Dato';
$string['dateformat'] = 'Datoformat';
$string['dbhost'] = 'DB-vert';
$string['dbhostinfo'] = 'Ekstern databasevert-navn (hvor vi skal kjøre SQL-spørringene)';
$string['dbname'] = 'DB-navn';
$string['dbnameinfo'] = 'Navn på den eksterne databasen (hvor vi skal kjøre SQL-spørringene)';
$string['dbpass'] = 'DB passord';
$string['dbpassinfo'] = 'Passord for den eksterne databasen (for brukernavnet over)';
$string['dbuser'] = 'DB brukernavn';
$string['dbuserinfo'] = 'Brukernavn for den eksterne databasen (må ha SELECT-rettigheter i databasen)';
$string['direction'] = 'Rekkefølge';
$string['disabled'] = 'Deaktivert';
$string['displayglobalreports'] = 'Vis globale rapporter';
$string['displayreportslist'] = 'Vis rapportlista i sideblokken';
$string['donotshowtime'] = 'Ikke vis datoinformasjon';
$string['download'] = 'Last ned';
$string['downloadreport'] = 'Last ned rapporter';
$string['email_message'] = 'Melding';
$string['email_send'] = 'Send';
$string['email_subject'] = 'Emne';
$string['enabled'] = 'Aktivert';
$string['enableglobal'] = 'Dette er en global rapport (tilgjengelig fra alle kurs)';
$string['enablejsordering'] = 'Aktiver JavaScript sortering';
$string['enablejspagination'] = 'Aktiver JavaScript sidesetting';
$string['endtime'] = 'Sluttdato';
$string['enrolledstudents'] = 'Påmeldte studenter';
$string['error_field'] = 'Ugyldig felt';
$string['error_operator'] = 'Ugyldig operator';
$string['error_value_expected_integer'] = 'Feil: Tar bare inn heltall';
$string['executeat'] = 'Kjøres';
$string['executeatinfo'] = 'Moodle CRON vil kjøre tidfestede SQL-spørringer etter oppgitt tidspunkt og en gang i døgnet.';
$string['export_ods'] = 'Eksporter i ODS format';
$string['export_xls'] = 'Eksporter i XLS format';
$string['exportoptions'] = 'Valg for eksport';
$string['exportreport'] = 'Eksporter rapport';
$string['fcoursefield'] = 'Kursefelt filtrering';
$string['field'] = 'Felt';
$string['filter'] = 'Filtere';
$string['filter_all'] = 'Alle';
$string['filter_apply'] = 'Legg til';
$string['filter_searchtext'] = 'Søketekst';
$string['filter_searchtext_summary'] = 'Fritekstsøk';
$string['filtercategories'] = 'Filterer kategorier';
$string['filtercategories_summary'] = 'Filtrer etter kategori';
$string['filtercoursecategories'] = 'Kursfilter basert på kategori';
$string['filtercoursecategories_summary'] = 'Filterer kurs innen kategorien de hører til';
$string['filtercoursemodules'] = 'Kursmodul';
$string['filtercoursemodules_summary'] = 'Filtrer kursmoduler';
$string['filtercourses'] = 'Kurs';
$string['filtercourses_summary'] = 'Dette filteret viser en liste med kurs. Kun ett kurs kan velges om gangen.';
$string['filterenrolledstudents'] = 'Påmeldte kursstudenter';
$string['filterenrolledstudents_summary'] = 'Filtrerer en bruker (etter id) blant påmeldte kursstudenter';
$string['filterrole'] = 'rolle';
$string['filterrole_summary'] = 'Filtrerer systemroller (Lærer, Student...)';
$string['filters'] = 'Filtere';
$string['filtersemester'] = 'Semester (hebraisk)';
$string['filtersemester_list'] = 'סמסטר א,סמסטר ב,סמסטר ג,סמינריון';
$string['filtersemester_summary'] = 'מאפשר סינון לפני סמסטרים (בעברית, למשל: סמסטר א,סמסטר ב)';
$string['filterstartendtime_summary'] = 'Startdato/sluttdato filter';
$string['filtersubcategories'] = 'Kategori (ta med underkategorier)';
$string['filtersubcategories_summary'] = 'Bruk: %%FILTER_CATEGORIES:mdl_course_category.path%%';
$string['filteruser'] = 'Gjeldene kursbruker';
$string['filteruser_summary'] = 'Filtrerer en bruker (etter id) fra gjeldelde kursbrukere';
$string['filterusers'] = 'Systembruker';
$string['filterusers_summary'] = 'Filtrerer en bruker (etter id) fra systemets brukerliste';
$string['filteryearhebrew'] = 'År (hebraisk)';
$string['filteryearhebrew_list'] = 'תשע,תשעא,תשעב,תשעג,תשעד,תשעה';
$string['filteryearhebrew_summary'] = 'Filterer etter hebraisk år (תשעג,...)';
$string['filteryearnumeric'] = 'År (numerisk)';
$string['filteryearnumeric_summary'] = 'Filtrerer etter numerisk år (2013, ...)';
$string['filteryears'] = 'År (numerisk)';
$string['filteryears_list'] = '2010,2011,2012,2013,2014,2015';
$string['filteryears_summary'] = 'Filtrerer etter år (numerisk angitt, 2013...)';
$string['fixeddate'] = 'Satt dato';
$string['footer'] = 'Bunntekst';
$string['forcemidnight'] = 'Tving ved midnatt';
$string['fuserfield'] = 'Profilfelt filtrering';
$string['global'] = 'Global rapport';
$string['global_help'] = 'En global rapport er tilgjengelig fra alle kurs på portalen, ved at du ganske enkelt legger til &courseid=MINKURS_ID i rapport-URL.';
$string['globalstatsshouldbeenabled'] = 'Statistikk må være aktivert for portalen. Vennligst kontakt din portaladministrator.';
$string['groupseries'] = 'Grupper serier';
$string['groupvalues'] = 'Grupper med lik verdi (sum)';
$string['header'] = 'Topptekst';
$string['importfromrepository'] = 'Importer rapport fra eksternt lager';
$string['importreport'] = 'Importer rapport';
$string['includesubcats'] = 'Inkluder underkategorier';
$string['jsordering'] = 'JavaScript sortering';
$string['jsordering_help'] = 'JavaScript sortering gir deg muligheten til å sortere tabellen uten å oppdatere siden';
$string['lastexecutiontime'] = 'Kjøres = {$a} (sekunder)';
$string['line'] = 'Linjediagram';
$string['linesummary'] = 'Et linjediagram med flere dataserier';
$string['listofsqlreports'] = '<a href="http://docs.moodle.org/en/ad-hoc_contributed_reports" target="_blank">List of SQL Contributed reports</a>';
$string['managereports'] = 'Administrer rapporter';
$string['max'] = 'Beste resultat';
$string['min'] = 'Dårligste resultat';
$string['missingcolumn'] = 'En kolonne er påkrevd';
$string['module'] = 'Aktivitet/ressurs';
$string['newreport'] = 'Ny rapport';
$string['nocalcsyet'] = 'Ingen utregninger så langt';
$string['nocolumnsyet'] = 'Ingen kolonner er lagt til ennå';
$string['noconditionsyet'] = 'Ingen betingelser satt';
$string['noexplicitprefix'] = 'Ingen spesielle prefiks';
$string['nofiltersyet'] = 'Ingen filtere er lagt til ennå';
$string['nofilteryet'] = 'Ingen filtere satt';
$string['noorderingyet'] = 'Ingen sortering satt';
$string['nopermissionsyet'] = 'Ingen tillatelser satt';
$string['noplotyet'] = 'Ingen plott så langt';
$string['norecordsfound'] = 'Fant ingen oppføringer';
$string['noreportsavailable'] = 'Ingen rapporter er tilgjengelige';
$string['norowsreturned'] = 'Ingen rader ble returnert';
$string['nosemicolon'] = 'Ingen semikolon';
$string['notallowedwords'] = 'Ikke tillatte ord';
$string['operator'] = 'Operator';
$string['ordering'] = 'Sortering';
$string['pagination'] = 'Sideinnstillinger';
$string['pagination_help'] = 'Antallet oppføringer som skal vises på hver side. 0 betyr ingen sidesetting';
$string['parentcategory'] = 'Toppkategorier';
$string['permissions'] = 'Tillatelser';
$string['pie'] = 'Kake';
$string['pieareaname'] = 'Name';
$string['pieareavalue'] = 'Verdi';
$string['piesummary'] = 'Kakediagram';
$string['plot'] = 'Diagram - Grafer';
$string['pluginname'] = 'Konfigurerbare Rapporter';
$string['previousdays'] = 'Siste dager';
$string['previousend'] = 'Forrige sluttdato';
$string['previousstart'] = 'Forrige startdato';
$string['printreport'] = 'Skriv ut rapporten';
$string['puserfield'] = 'Profilfelt';
$string['puserfield_summary'] = 'Bruker med ønsket verdi i valgt profilfelt';
$string['queryfailed'] = 'Spørringen mislyktes';
$string['querysql'] = 'SQL-spørring';
$string['remotequerysql'] = 'SQL-spørring';
$string['report'] = 'Rapport';
$string['report_categories'] = 'Kategorirapport';
$string['report_courses'] = 'Kursrapport';
$string['report_sql'] = 'SQL-rapport';
$string['report_timeline'] = 'Tidslinjerapport';
$string['report_users'] = 'Brukerrapport';
$string['reportcategories'] = '1) Velg en ekstern rapportkategori';
$string['reportcolumn'] = 'Andre rapportkolonner';
$string['reportcreated'] = 'Opprettelsen av rapporten var vellykket';
$string['reports'] = 'Rapporter';
$string['reportscapabilities'] = 'Rapporttillatelser';
$string['reportscapabilities_summary'] = 'Brukere med tillatelsen moodle/site:viewreports aktivert';
$string['reportsincategory'] = '2) Velg en rapport fra listen';
$string['reporttable'] = 'Rapporttabell';
$string['reporttable_help'] = '<p>Dette er bredden på tabellen som vil vise rapportdataene.</p>

<p>Hvis du bruker en mal, vil ikke dette valget ha noen betydning.</p>';
$string['reporttableui'] = 'Rapporttabell UI';
$string['reporttableuiinfo'] = 'Vis rapporttabellen som: Enkel scrollbar HTML-tabell, JQueri med kolonnesortering eller JS-baserte datatabeller (Kolonnesortering, låste kolonneoverskrifter, søk, sidenummerering...)';
$string['repository'] = 'Rapportlager';
$string['repository_help'] = 'Du kan importere eksempelrapporter fra et offentlig tilgjengelig lager. Vennligst merk at det er en daglig begrensning på antall forespørsler til dette eksterne lageret.

Hvis koblingen til lageret ikke fungerer, kan du herfra: <a href="https://github.com/jleyva/moodle-configurable_reports_repository" target="_blank">https://github.com/jleyva/moodle-configurable_reports_repository</a>  manuelt laste ned en rapport og deretter importere den via funksjonen for "importer rapport" under.';
$string['role'] = 'Rolle';
$string['roleincourse'] = 'Brukere med valgt rolle(r) i dette kurset';
$string['roleusersn'] = 'Antall brukere med rolle...';
$string['searchtext'] = 'Søketekst';
$string['semester'] = 'Semester (hebraisk)';
$string['serieid'] = 'Kolonne';
$string['setcourseid'] = 'Angi kursid';
$string['sharedsqlrepository'] = 'Delt SQL-lager';
$string['sharedsqlrepositoryinfo'] = 'Navn på github kontoeier + slash + gitlager-navn';
$string['sqlsecurity'] = 'SQL sikkerhet';
$string['sqlsecurityinfo'] = 'Deaktiverer for  kjøring av SQL-spørringer med kode for å legge til data (Github kontoeier + slash + gitlager-navn)';
$string['sqlsyntaxhighlight'] = 'Uthev SQL-syntaksen';
$string['sqlsyntaxhighlightinfo'] = 'Uthev SQL-syntaksen i kodeeditoren (CodeMirror JS Library)';
$string['startendtime'] = 'Startdato/sluttdato filter';
$string['starttime'] = 'Startdato';
$string['stat'] = 'Statistikk';
$string['statsactiveenrolments'] = 'Aktive (forrige ukes) innmeldinger';
$string['statslogins'] = 'Innlogginer på portalen';
$string['statstotalenrolments'] = 'Totalt antall innmeldinger';
$string['student'] = 'Student';
$string['subcategories'] = 'Kategori (ta med underkategorier også)';
$string['sum'] = 'Sum';
$string['tablealign'] = 'Tabelljustering';
$string['tablecellpadding'] = 'Table cellpadding';
$string['tablecellspacing'] = 'Table cellspacing';
$string['tableclass'] = 'Tabelltype';
$string['tablewidth'] = 'Tabellbredde';
$string['template'] = 'Mal';
$string['template_marks'] = 'Mal for merknader';
$string['template_marks_help'] = '<p>Du kan bruke disse malene for merknader:</p>

<ul>
<li>##rapportnavn## - For inkludering av rapportnavnet</li>
<li>##rapportbeskrivelse## - For inkludering av rapportbeskrivelsen</li>
<li>##grafer## - For inkludering av grafene</li>
<li>##eksporteringsvalg## - For inkludering av eksporteringsvalgene</li>
<li>##utregningstabell## - For inkludring av utregingstabellen</li>
<li>##sideinnstillinger## - For inkludering av sideinnstillingene </li>

</ul>';
$string['templaterecord'] = 'Mal for oppføringer';
$string['timeinterval'] = 'Tidsintervall';
$string['timeline'] = 'Tidslinje';
$string['timemode'] = 'Tidsinnstillinger';
$string['totalrecords'] = 'Totalt antall oppføringer = {$a->totalrecords}';
$string['type'] = 'Rapporttype';
$string['typeofreport'] = 'Rapporttype';
$string['typeofreport_help'] = 'Velg rapporttypen du ønsker å bruke. Av sikkerhetsmessige årsaker krever SQL-rapporten ekstra rettigheter.';
$string['user'] = 'Kursbruker (id)';
$string['usercompletion'] = 'Brukers kursfullføringsstatus';
$string['usercompletionsummary'] = 'Kursfullføringsstatus';
$string['userfield'] = 'Profilfelt';
$string['userfieldorder'] = 'Sortering på profilfelt';
$string['usermodactions'] = 'Brukerens aktivitet i aktiviteten/ressursen';
$string['usermodoutline'] = 'Brukerens karakter i en bestemt aktivitet/ressurs';
$string['users'] = 'Systembruker (id)';
$string['usersincohorts'] = 'Bruker som er medlem av en/flere kohorter';
$string['usersincohorts_summary'] = 'Bare brukere som er medlem av valgte kohorter';
$string['usersincoursereport'] = 'Alle brukerne i den nåværende kursrapporten';
$string['usersincoursereport_summary'] = 'Alle brukere i den nåværende kursrapporten';
$string['usersincurrentcourse'] = 'Brukere fra dette kurset';
$string['usersincurrentcourse_summary'] = 'Brukere med en bestemt rolle i kurset';
$string['userstats'] = 'Brukerstatistikk';
$string['value'] = 'Verdi';
$string['viewreport'] = 'Vis rapport';
$string['xaxis'] = 'X Akse';
$string['yaxis'] = 'Y Akse';
$string['yearhebrew'] = 'År (hebraisk)';
$string['yearnumeric'] = 'År (numerisk)';
$string['years'] = 'År (numerisk)';
$string['youmustselectarole'] = 'Du må velge minst en rolle';
