<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'no', version '3.9'.
 *
 * @package     scheduler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Handling';
$string['actions'] = 'Handlinger';
$string['addappointment'] = 'Legg til deltaker';
$string['addcommands'] = 'Legg til time';
$string['addondays'] = 'Kun disse dagene';
$string['addsession'] = 'Legg til gjentatt time';
$string['addsingleslot'] = 'Legg til enkel time';
$string['addslot'] = 'Du kan legge til flere timer senere.';
$string['addstudenttogroup'] = 'Legg denne deltakeren i gruppe';
$string['allappointments'] = 'Alle timer';
$string['allononepage'] = 'Alle timer på samme side';
$string['allowgroup'] = 'Eksklusiv (kun én deltaker) - klikk for å endre.';
$string['alreadyappointed'] = 'Timen kan ikke opprettes. Det er ikke flere ledige tider.';
$string['appointagroup_help'] = 'Velg om du vil opprette en time for deg selv eller en hel gruppe.';
$string['appointfor'] = 'Opprett time for';
$string['appointforgroup'] = 'Opprett time for: {$a}';
$string['appointment'] = 'Time';
$string['appointmentno'] = 'Time {$a}';
$string['appointmentnote'] = 'Notater (synlig for deltaker)';
$string['appointments'] = 'Timer';
$string['appointmentsgrouped'] = 'Timer sortert etter tid';
$string['appointsolo'] = 'Kun meg';
$string['appointsomeone'] = 'Legg til ny time';
$string['areaappointmentnote'] = 'Filer i avtalenotatene';
$string['areaslotnote'] = 'Filer i timenotatene';
$string['areateachernote'] = 'Filer i fortrolige notater';
$string['attended'] = 'Deltok';
$string['availableslots'] = 'Ledige timer';
$string['availableslotsall'] = 'Alle timer';
$string['bookaslot'] = 'Bestill time';
$string['bookingdetails'] = 'Detaljer';
$string['bookingformoptions'] = 'Bestillingsskjema og informasjon fra deltaker';
$string['bookinginstructions'] = 'Instruksjon for bestilling';
$string['bookinginstructions_help'] = 'Denne teksten vil bli vist til studentene før de bestiller. Den kan for eksempel instruere elevene hvordan de fyller ut det valgfrie meldingsfeltet eller hvilke filer som skal lastes opp.';
$string['bookslot'] = 'Bestill time';
$string['bookwithteacher'] = 'Lærer';
$string['bookwithteacher_help'] = 'Velg lærer for timen.';
$string['break'] = 'Pause mellom timene';
$string['breaknotnegative'] = 'Pausens lengde kan ikke være negativ';
$string['canbook1appointment'] = 'Du kan bestille enda en time.';
$string['canbooknappointments'] = 'Du har mulighet til å bestille følgende antall timer: {$a}';
$string['canbooknofurtherappointments'] = 'Du kan ikke bestille flere timer i denne planleggingsaktiviteten.';
$string['canbooksingleappointment'] = 'Du kan bestille enda en time.';
$string['canbookunlimitedappointments'] = 'Det er ingen begrensning for antall avtaler.';
$string['cancelbooking'] = 'Avlys time.';
$string['chooseexisting'] = 'Velg eksisterende';
$string['choosingslotstart'] = 'Velgs starttid.';
$string['comments'] = 'Kommentarer';
$string['complete'] = 'Bestilt';
$string['confirmbooking'] = 'Bekreft time';
$string['confirmdelete-mine'] = 'Dette vil slette alle timene dine i denne planleggeren. Sletting kan ikke angres. Fortsett likevel?';
$string['confirmdelete-myunused'] = 'Dette vil slette alle ubenyttede timer i denne planleggeren. Sletting kan ikke angres. Fortsett likevel?';
$string['confirmdelete-one'] = 'Slett time?';
$string['confirmdelete-selected'] = 'Dette vil slette valgte timer. Slettingen kan ikke angres. Fortsett likevel?';
$string['confirmdelete-unused'] = 'Dette vil slette ubenyttede timer. Slettingen kan ikke angres. Fortsett likevel?';
$string['copytomyself'] = 'Send kopi til meg selv';
$string['course'] = 'Kurs';
$string['createexport'] = 'Opprett eksportfil';
$string['csvformat'] = 'CSV';
$string['date'] = 'Dato';
$string['datelist'] = 'Overblikk';
$string['defaultslotduration'] = 'Standard varighet for time';
$string['defaultslotduration_help'] = 'Standardlengden (i minutter) for timer du oppretter.';
$string['deleteallslots'] = 'Slett alle timer';
$string['deleteallunusedslots'] = 'Slett ubenyttede timer';
$string['deletecommands'] = 'Slett timer';
$string['deletemyslots'] = 'Slett alle mine timer';
$string['deleteonsave'] = 'Slett denne avtalen (når skjemaet lagres)';
$string['deleteselection'] = 'Slett valgte timer';
$string['deletetheseslots'] = 'Slett disse timene';
$string['deleteunusedslots'] = 'Slett mine ubenyttede timer';
$string['disengage'] = 'Annulér mine avtaler';
$string['displayfrom'] = 'Vis time til brukere fra';
$string['distributetoslot'] = 'Distribuer til hele gruppen';
$string['divide'] = 'Dele opp i timer?';
$string['duration'] = 'Varighet';
$string['editbooking'] = 'Rediger time';
$string['email_applied_html'] = '<p>En time er forespurt  {$a->date} at {$a->time},<br/>
av <a href="{$a->attendee_url}">{$a->attendee}</a> i kurset:

<p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></p>

<p>i timeplanleggeren med navn "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" på nettsiden: <a href="{$a->site_url}">{$a->site}</a>.</p>';
$string['email_applied_plain'] = 'En time er forespurt {$a->date} at {$a->time},
av bruker {$a->attendee} i kurset:

{$a->course_short}: {$a->course}

i timeplanleggeren med navn "{$a->module}" på nettsiden: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Ny avtale';
$string['email_cancelled_html'] = '<p>Din avtale <strong>{$a->date}</strong> klokka <strong>{$a->time}</strong>,<br/>
med bruker <strong><a href="{$a->attendee_url}">{$a->attendee}</a></strong> fi kurs :</p>

<p><strong>{$a->course_short} : <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>i timeplanleggeren med navn "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" på nettsiden : <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">har blitt kansellert eller flyttet</span></strong>.</p>';
$string['email_cancelled_plain'] = 'Din avtale  {$a->date} klokka {$a->time},
med bruker {$a->attendee} i kurset:

{$a->course_short} : {$a->course}

i timeplanleggeren "{$a->module}" på nettsiden : {$a->site}

har blitt kansellert eller flyttet.';
$string['email_cancelled_subject'] = '{$a->course_short}: Avtalen er kansellert eller flyttet av en bruker.';
$string['email_invite_html'] = '<p>Vennligst velg time på:</p> <p>{$a->scheduler_url}</p>';
$string['email_invite_subject'] = 'Invitasjon: {$a->module}';
$string['email_invitereminder_html'] = '<p>Dette er en påminnelse om at du ikke har bestilt time. Vennligst velg en time så raskt som mulig på:</p><p>{$a->scheduler_url}</p>';
$string['email_invitereminder_subject'] = 'Påminnelse: {$a->module}';
$string['email_reminder_html'] = '<p>Du har en kommende avtale <strong>{$a->date}</strong>
fra <strong>{$a->time}</strong> til <strong>{$a->endtime}</strong><br/>
med <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong>.</p>

<p>Sted: <strong>{$a->location}</strong></p>';
$string['email_reminder_plain'] = 'Du har en kommende avtale
 {$a->date} fra {$a->time} til {$a->endtime}
med {$a->attendant}.

sted: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Påminnelse om avtale';
$string['email_teachercancelled_html'] = '<p>Din avtale <strong>{$a->date}</strong> klokka <strong>{$a->time} </strong>,<br/>
med {$a->staffrole} <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong> i kurs:</p>

<p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>i timeplanleggeren "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" på nettsiden: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">har blitt kansellert.</span></strong>. Vennligst bestill ny time.</p>';
$string['email_teachercancelled_plain'] = 'Din avtale {$a->date} klokka {$a->time},
med {$a->staffrole} {$a->attendant} i kurset:

{$a->course_short}: {$a->course}

i timeplanleggeren "{$a->module}" på nettsiden: {$a->site}

Your appointment on {$a->date} at {$a->time},
with the {$a->staffrole} {$a->attendant} for course:

{$a->course_short}: {$a->course}

in the scheduler titled "{$a->module}" on the website: {$a->site}

har blitt kansellert. Vennligst bestill ny time.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Avtalen er kansellert av lærer.';
$string['emailreminder'] = 'Send e-post med påminnelse';
$string['emailreminderondate'] = 'Send e-post med påminnelse den';
$string['end'] = 'Slutt';
$string['enddate'] = 'Gjenta timer inntil';
$string['event_bookingadded'] = 'Avtale er lagt til';
$string['event_slotadded'] = 'Time er lagt til';
$string['event_slotdeleted'] = 'Time er slettet';
$string['everyone'] = 'Alle';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Eksklusiv';
$string['exclusivity_help'] = '<p>Du kan sette en grense for antall deltakere som kan bestille time</p> <p> En grense på 1 (standard) betyr at plassen er eksklusiv for en enkelt deltaker. </p> <p> Innstilling av en grense på f.eks. 3 betyr at opp til tre deltagere kan booke tiden samtidig. </p> <p> Hvis den er deaktivert, kan et vilkårlig antall deltagere booke timen; det vil aldri bli betraktet som "fullt". </p>';
$string['export'] = 'Eksporter';
$string['exporthdr'] = 'Eksporter timer og avtaler';
$string['exporttimerange'] = 'Tidsramme';
$string['exporttimerangeall'] = 'Kommende og tidligere timer';
$string['exporttimerangefuture'] = 'Kun kommende timer';
$string['exporttimerangepast'] = 'Kun tidligere timer';
$string['field-appointmentnote'] = 'Avtalenotat (til student)';
$string['field-date'] = 'Dato';
$string['field-endtime'] = 'Sluttid';
$string['field-filecount'] = 'Antall vedlagte filer';
$string['field-grade'] = 'Karakter';
$string['field-groupsmulti'] = 'Grupper (flere kolonner)';
$string['field-groupssingle'] = 'Grupper';
$string['field-groupssingle-label'] = 'Grupper (en kolonne)';
$string['field-location'] = 'Sted';
$string['field-maxstudents'] = 'Maks. deltakere';
$string['field-slotnotes'] = 'Time-notater';
$string['field-starttime'] = 'Starttid';
$string['field-studentemail'] = 'Deltakers e-post';
$string['field-studentfirstname'] = 'Fornavn (deltaker)';
$string['field-studentfullname'] = 'Deltakers fulle navn';
$string['field-studentidnumber'] = 'Detaker ID';
$string['field-studentlastname'] = 'Etternavn (deltaker)';
$string['field-studentnote'] = 'Beskjed fra deltaker';
$string['field-studentusername'] = 'Brukernavn (deltaker)';
$string['field-teachernote'] = 'Skjulte notater (sees kun av lærer)';
$string['fileformat'] = 'Filformat';
$string['finalgrade'] = 'Avsluttende karakter';
$string['firstslotavailable'] = 'Denne timen vil være tilgjengelig fra  {$a}';
$string['forbidgroup'] = 'Gruppetime - klikk for å endre';
$string['forcewhenoverlap'] = 'Overskriv eksisterende timer ved overlap';
$string['forcewhenoverlap_link'] = 'mod/scheduler/conflict';
$string['friday'] = 'Fredag';
$string['generalconfig'] = 'Generelle innstillinger';
$string['grade'] = 'Karakter';
$string['gradeingradebook'] = 'Karakter i karakterboka';
$string['gradingstrategy'] = 'Strategi for karaktersetting';
$string['group'] = 'gruppe';
$string['groupbookings'] = 'Bestill i grupper';
$string['groupbookings_help'] = 'Tillat bruker å bestille time på vegne av andre i en gruppe.';
$string['groupbreakdown'] = 'Etter gruppestørrelse';
$string['groupscheduling'] = 'Aktiver gruppeplanlegging';
$string['groupsession'] = 'Gruppetime';
$string['groupsize'] = 'Gruppestørrelse';
$string['guardtime'] = 'Deadline for endringer';
$string['guardtime_help'] = 'Deadline forhindrer deltakere å endre reservasjonen kort før avtalen. <p> Hvis tiden er aktivtert og innstilt til for eksempel 2 timer, vil deltakeren ikke være i stand til å bestille en time som starter mindre enn 2 timer fra nå. Deltakeren vil heller ikke kunne slette avtale hvis den starter om mindre enn to timer. </p>';
$string['ignoreconflicts'] = 'Ignorer konflikter';
$string['ignoreconflicts_link'] = 'mod/scheduler/conflict';
$string['includeemptyslots'] = 'Inkluder tomme timer';
$string['includeslotsfor'] = 'Inkluder timer for';
$string['incourse'] = 'i kurs';
$string['introduction'] = 'Introduksjon';
$string['isnonexclusive'] = 'Gruppeavtale';
$string['lengthbreakdown'] = 'Etter varighet';
$string['limited'] = 'Ledige plasser ({$a} left)';
$string['location'] = 'Sted';
$string['markasseennow'] = 'Marker som sett';
$string['markseen'] = 'Når du har hatt møte med en bruker, kan du markere dem som "Sett" ved å klikke på avkrysningsfeltet ved deres profilbilde.';
$string['maxstudentsperslot'] = 'Maks. antall deltakere pr time';
$string['meetingwith'] = 'Møte med';
$string['meetingwithplural'] = 'Møte med';
$string['message'] = 'Beskjed';
$string['messageprovider:reminder'] = 'Påminnelse om kommende time';
$string['messagesubject'] = 'Emne';
$string['minutes'] = 'minutter';
$string['minutesperslot'] = 'minutter pr. time';
$string['missingstudents'] = '{$a} deltaker(e) kan fortsatt booke en tid. (se liste nedenfor)';
$string['missingstudentsmany'] = '{$a} deltager(e) kan fortsatt booke en tid. Liste vises ikke pga. antallet.';
$string['modeappointments'] = 'avtale(r)';
$string['modeintro'] = 'Deltakere kan booke';
$string['modeoneatatime'] = 'av gangen';
$string['modeoneonly'] = 'i denne timeplanleggeren';
$string['modulename'] = 'Planlegger';
$string['modulename_link'] = 'mod/scheduler/view';
$string['monday'] = 'Mandag';
$string['myappointments'] = 'Mine avtaler';
$string['myself'] = 'Meg selv';
$string['never'] = 'Aldri';
$string['noappointments'] = 'Ingen avtaler';
$string['note'] = 'Karakter';
$string['notifications'] = 'Meldinger';
$string['notifications_help'] = 'Når denne innstillingen er aktivert, mottar lærere og deltakere melding når det opprettes eller kanselleres avtaler.';
$string['notseen'] = 'Ikke sett';
$string['now'] = 'Nå';
$string['on'] = 'på';
$string['onedaybefore'] = '1 dag før time';
$string['oneslotadded'] = '1 time er lagt til';
$string['oneslotdeleted'] = '1 time er slettet';
$string['oneweekbefore'] = '1 uke før time';
$string['onthemorningofappointment'] = 'Om morgenen (dagen for avtalen)';
$string['options'] = 'Muligheter';
$string['otherstudents'] = 'Andre deltakere';
$string['overall'] = 'Samlet';
$string['privacy:metadata:scheduler_appointment:studentid'] = 'Deltaker som har bestilt time';
$string['privacy:metadata:scheduler_appointment:studentnote'] = 'Notater lagt til av deltaker';
$string['privacy:metadata:scheduler_appointment:teachernote'] = 'Notater skrevet av lærer (privat, men skal deles ved GDPR-innsikt)';
$string['privacy:metadata:scheduler_slots:appointmentlocation'] = 'Sted';
$string['privacy:metadata:scheduler_slots:duration'] = 'Varighet (minutter)';
$string['privacy:metadata:scheduler_slots:starttime'] = 'Starttid for timen';
$string['privacy:metadata:scheduler_slots:teacherid'] = 'Tilknyttet lærer';
$string['recipients'] = 'Mottakere';
$string['reminder'] = 'Påminnelse';
$string['requireupload'] = 'Filopplasting påkrevd';
$string['resetappointments'] = 'Slett avtaker og karakterer';
$string['return'] = 'Tilbake til kurset';
$string['revoke'] = 'Avlys avtalen';
$string['saturday'] = 'Lørdag';
$string['save'] = 'Lagre';
$string['savechoice'] = 'Lagre mine valg';
$string['saveseen'] = 'Lagre som sett';
$string['schedule'] = 'Planlegg';
$string['scheduleinnew'] = 'Planlegg i ny time';
$string['scheduleinslot'] = 'Planlegg i tilme';
$string['scheduler'] = 'Planlegger';
$string['scheduler:appoint'] = 'Bestill time';
$string['scheduler:editallnotes'] = 'Rediger notater i alle avtaler';
$string['schedulestudents'] = 'Planlegg avtale for elever';
$string['scopemenu'] = 'Vis timer i: {$a}';
$string['seen'] = 'Sett';
$string['selectedtoomany'] = 'Du har valgt for mange timer. Du kan ikke slette flere enn {$a}.';
$string['sendinvitation'] = 'Send invitasjon';
$string['sendmessage'] = 'Send beskjed';
$string['sendreminder'] = 'Send påminnelse';
$string['sendreminders'] = 'Send e-post med påminnelse til kommende avtaler';
$string['sepcolon'] = 'Kolonne';
$string['sepcomma'] = 'Komma';
$string['sepsemicolon'] = 'Semikolon';
$string['septab'] = 'Tab';
$string['showemailplain'] = 'Vis e-postadresse som ren tekst';
$string['showparticipants'] = 'Vis deltakere';
$string['slot'] = 'Time';
$string['slotdatetimelabel'] = 'Dato og tid';
$string['slots'] = 'Timer';
$string['slotsadded'] = '{$a} timer er tilført';
$string['slotsdeleted'] = '{$a} timer er slettet';
$string['slottype'] = 'Type time';
$string['slotupdated'] = '1 time er oppdatert';
$string['staffbreakdown'] = 'Av {$a}';
$string['staffrolename'] = 'Rollenavn på lærer';
$string['staffrolename_help'] = 'Personen det bookes tid hos er ikke nødvendigvis lærer. Det kan også være mentor, veileder osv.';
$string['start'] = 'Start';
$string['statistics'] = 'Statistikk';
$string['student'] = 'Deltaker';
$string['studentbreakdown'] = 'Av deltaker';
$string['studentcomments'] = 'Beskjed fra deltaker';
$string['studentdetails'] = 'Detaljer om deltaker';
$string['studentfiles'] = 'Vedlagte filer';
$string['studentnote'] = 'Beskjed fra deltaker';
$string['students'] = 'Deltakere';
$string['sunday'] = 'Søndag';
$string['tab-otherappointments'] = 'Alle avtaler opprettet av denne deltaker';
$string['tab-otherstudents'] = 'Deltakere i denne timen';
$string['tab-thisappointment'] = 'Denne avtalen';
$string['teacher'] = 'Lærer';
$string['teachernote'] = 'Fortrolige notater (kun synlig for lærer)';
$string['teachersmenu'] = 'Vis timer for {$a}.';
$string['thiscourse'] = 'dette kurset';
$string['thisscheduler'] = 'denne planleggeren';
$string['thissite'] = 'hele Moodle';
$string['thursday'] = 'Torsdag';
$string['timefrom'] = 'Fra:';
$string['timerange'] = 'Tidsramme';
$string['timeto'] = 'Til:';
$string['totalgrade'] = 'Samlet karakter';
$string['tuesday'] = 'Tirsdag';
$string['unlimited'] = 'Ubegrenset';
$string['upcomingslots'] = 'Kommende timer';
$string['updategrades'] = 'Oppdater karakter';
$string['uploadmaxfiles'] = 'Maks. antall vedlagte filer';
$string['uploadmaxfilesglobal'] = 'Maks. antall vedlagte filer';
$string['uploadmaxsize'] = 'Maksimal filstørrelse';
$string['uploadstudentfiles'] = 'Last opp filer';
$string['usebookingform'] = 'Bruk bestillingsskjema';
$string['usebookingform_link'] = 'mod/scheduler/bookingform';
$string['usenotes'] = 'Benytt notater';
$string['usenotesboth'] = 'Fortrolige notater + felles notater';
$string['usenotesnone'] = 'ingen';
$string['usenotesstudent'] = 'Fellesnotater (synlige for både lærer og elev)';
$string['usenotesteacher'] = 'Fortrolige notater (kun synlig for lærer)';
$string['usestudentnotes'] = 'La deltakere skrive beskjed';
$string['viewbooking'] = 'Se detaljer';
$string['wednesday'] = 'Onsdag';
$string['welcomenewstudent'] = 'Nedenfor vises alle tilgjengelige timer. Hvis du har behov for å endre senere, kan du gå tilbake til denne oversikten.';
$string['welcomenewteacher'] = 'Klikk på knappen nedenfor for å opprette timer.';
$string['what'] = 'Hva?';
$string['whathappened'] = 'Hva skjedde?';
$string['whatresulted'] = 'Hva var resultatet?';
$string['when'] = 'Når?';
$string['where'] = 'Hvor?';
$string['who'] = 'Med hvem?';
$string['whosthere'] = 'Hver er der?';
$string['xdaysbefore'] = '{$a} dager før timen';
$string['xweeksbefore'] = '{$a} uker før timen';
$string['yesallgroups'] = 'Ja, for alle grupper';
$string['yesoptional'] = 'Ja (frivillig)';
$string['yesrequired'] = 'Ja, bruker må skrive en melding.';
$string['yourstudentnote'] = 'Din beskjed';
$string['yourtotalgrade'] = 'Din samlede karakter i denne aktiviteten er <strong>{$a}</strong>.';
