<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'search_solr', language 'no', version '3.9'.
 *
 * @package     search_solr
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['connectionerror'] = 'Den oppgitte Solr-serveren er ikke tilgjengelig eller så eksisterer ikke den oppgitte indeksen';
$string['connectionsettings'] = 'Tilkoblingsinnstillinger';
$string['errorcreatingschema'] = 'En feil oppstod under oppretting av Solr skjemaet: {$a}';
$string['errorsolr'] = 'Søkemotoren Solr rapporterte om en feil: {$a}';
$string['errorvalidatingschema'] = 'Feil ved validering av Solr-skjema: felt  {$a->fieldname} eksisterer ikke. Vennligst <a href="{$a->setupurl}">følg denne lenken</a> for å sette opp nødvendige felter.';
$string['extensionerror'] = 'Apache Solr PHP utvidelsen er ikke installert. Vennligst les dokumentasjonen.';
$string['fileindexing'] = 'Aktiver filindeksering';
$string['fileindexing_help'] = 'Dersom Solr-installasjonen din støtter det kan denne funksjonen sende filer til indeksering.<br/>
Du må reindeksere alt portalinnhold etter aktivering av denne funksjonen slik at alt innholdet blir lagt til.';
$string['fileindexsettings'] = 'Innstillinger for filindeksering';
$string['maxindexfilekb'] = 'Største filstørrelse for indeksering (kB)';
$string['maxindexfilekb_help'] = 'Filer som er større enn dette vil ikke inkluderes i søkeindekseringen. 0 betyr at alle filer vil indekseres.';
$string['minimumsolr4'] = 'Solr 4.0 er minste versjon som kreves av Moodle';
$string['missingconfig'] = 'Apache Solr serveren er ennå ikke konfigurert i Moodle';
$string['multivaluedfield'] = 'Feltet "{$a}" returnerte en matrise i stedet for en skalar. Vennligst slett den nåværende indeksen, opprett en ny og kjør setup_schema.php før indekseringen i Solr.';
$string['nodatafromserver'] = 'Ingen data fra Server';
$string['pluginname'] = 'Solr';
$string['privacy:metadata'] = 'Denne modulen sender data til en eksternt lenket Solr søkemotor. Den lagrer ingen data lokalt.';
$string['privacy:metadata:data'] = 'Persondata som har passert gjennom fra søkeundersystemet';
$string['schemafieldautocreated'] = 'Feltet "{$a}" eksisterer allerede i Solr-skjemaet. Du har sannsynligvis glemt å kjøre skriptet før indekseringen av data og felt ble autoopprettet av Solr. Vennligst slett den nåværende indeksen, opprett en ny og kjør setup_schema.ph på nytt førindeksering av data i Solr.';
$string['schemasetupfromsolr5'] = 'SOLR-serverversjonen er lavere enn 5.0. Dette skriptet kan bare brukes på ditt skjema hvis SOLR er på versjon 5.0 eller høyere. Du må manuelt angi feltene i ditt skjema i samsvar med \\search_solr\\document::get_default_fields_definition().';
$string['searchinfo'] = 'Søk i spørringer';
$string['searchinfo_help'] = 'Feltet som skal søkes må være angitt ved å prefikse spørringen med
 \'title:\', \'content:\', \'name:\', eller \'intro:\'. F.eks., et søk med  \'title:news\' vil returnere resultater med ordet \'news\' i tittelen.

Boolean operatorer (\'AND\', \'OR\', \'NOT\') kan brukes for å kombinere eller eksludere nøkkelord.

Wildcard tegn (\'*\' or \'?\' ) kan brukes for å representerer bokstaver i spørringen.';
$string['setupok'] = 'Dette skjemaet er klar til bruk';
$string['solrauthpassword'] = 'HTTP autentiseringspassord';
$string['solrauthuser'] = 'HTTP autentiseringsnavn';
$string['solrhttpconnectionport'] = 'Port';
$string['solrhttpconnectiontimeout'] = 'Timeout';
$string['solrhttpconnectiontimeout_desc'] = 'HTTP tilkoblingsvarighet er de maksimale antall sekunder tillatt for HTTP dataoverføringsoperasjonen.';
$string['solrindexname'] = 'Indeksnavn';
$string['solrinfo'] = 'Solr';
$string['solrnotselected'] = 'Solr-motoren er ikke den konfigurerte søkemotoren.';
$string['solrsecuremode'] = 'Sikkerhetmodus';
$string['solrserverhostname'] = 'Vertens navn';
$string['solrserverhostname_desc'] = 'Domenenavn for Solr-serveren';
$string['solrsetting'] = 'Solr innstillinger';
$string['solrsslcainfo'] = 'SSL CA sertifikatnavn';
$string['solrsslcainfo_desc'] = 'Filnavn som inneholder ett eller flere CA-sertifikater for å bekrefte peer med';
$string['solrsslcapath'] = 'SSL CA sertifikatsti';
$string['solrsslcapath_desc'] = 'Mappe-sti som inneholder flere CA-sertifikater for å bekrefte peer med';
$string['solrsslcert'] = 'SSL-sertifikat';
$string['solrsslcert_desc'] = 'Filnavn som inneholder et PEM-formatert privat sertifikat';
$string['solrsslkey'] = 'SSL nøkkel';
$string['solrsslkey_desc'] = 'Filnavn som inneholder en PEM-formatert privat nøkkel';
$string['solrsslkeypassword'] = 'SSL nøkkelpassord';
$string['solrsslkeypassword_desc'] = 'Passord for PEM-formattert privat nøkkelfil';
