<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>, phpBBservice.nl <http://www.phpbbservice.nl>, phpBB.nl <http://www.phpbb.nl>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'Nederlandse vertaling door <a href="https://www.phpbb.nl/">phpBB.nl</a>.',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'DATETIME_FORMAT'	=> '|d M Y, H:i|',	// 01 Jan 2007, 13:37 (with Relative days enabled)
	'USER_LANG'			=> 'nl-nl',

	// You can define different rules for the determination of plural forms here.
	// See https://area51.phpbb.com/docs/dev/3.3.x/language/plurals.html for more information
	// or ask the translation manager for help.
	'PLURAL_RULE'		=> 1,

	'1_DAY'			=> '1 dag',
	'1_MONTH'		=> '1 maand',
	'1_YEAR'		=> '1 jaar',
	'2_WEEKS'		=> '2 weken',
	'3_MONTHS'		=> '3 maanden',
	'6_MONTHS'		=> '6 maanden',
	'7_DAYS'		=> '7 dagen',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Je account is al geactiveerd.',
	'ACCOUNT_DEACTIVATED'			=> 'Je account is handmatig gedeactiveerd en is alleen te heractiveren door een beheerder.',
	'ACP'							=> 'Beheerderspaneel',
	'ACP_SHORT'						=> 'Beheer',
	'ACTIVE'						=> 'actief',
	'ACTIVE_ERROR'					=> 'De opgevraagde gebruikersnaam is momenteel inactief. Als je problemen hebt met het activeren van je account, neem dan contact op met de beheerder.',
	'ADMINISTRATOR'					=> 'Beheerder',
	'ADMINISTRATORS'				=> 'Beheerders',
	'AGE'							=> 'Leeftijd',
	'AIM'							=> 'AIM',
	'AJAX_ERROR_TITLE'				=> 'AJAX-fout',
	'AJAX_ERROR_TEXT'				=> 'Er ging iets mis met het verwerken van je aanvraag.',
	'AJAX_ERROR_TEXT_ABORT'			=> 'Aanvraag is afgebroken door de gebruiker.',
	'AJAX_ERROR_TEXT_TIMEOUT'		=> 'Je aanvraag is verlopen; probeer het nog een keer.',
	'AJAX_ERROR_TEXT_PARSERERROR'	=> 'Er ging iets mis met de aanvraag en de server stuurde een ongeldige reactie terug.',
	'ALLOWED'						=> 'Toegestaan',
	'ALL_FILES'						=> 'Alle bestanden',
	'ALL_FORUMS'					=> 'Alle forums',
	'ALL_MESSAGES'					=> 'Alle berichten',
	'ALL_POSTS'						=> 'Alle berichten',
	'ALL_TIMES'						=> 'Alle tijden zijn <span title="%2$s">%1$s</span>',
	'ALL_TOPICS'					=> 'Alle onderwerpen',
	'ALT_TEXT'						=> 'Alternatieve tekst',
	'AND'							=> 'En',
	'ARE_WATCHING_FORUM'			=> 'Je wordt op de hoogte gehouden van nieuwe onderwerpen in dit forum.',
	'ARE_WATCHING_TOPIC'			=> 'Je wordt op de hoogte gehouden van nieuwe berichten in dit onderwerp.',
	'ASCENDING'						=> 'Oplopend',
	'ATTACHMENTS'					=> 'Bijlagen',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'De afbeelding die je probeert bij te voegen is ongeldig.',
	'AUTHOR'						=> 'Auteur',
	'AUTH_NO_PROFILE_CREATED'		=> 'Het aanmaken van een gebruikersprofiel is mislukt.',
	'AUTH_PROVIDER_OAUTH_ERROR_ALREADY_LINKED'				=> 'Deze externe dienst is al geassocieerd met een ander gebruikersaccount.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'				=> 'Ongeldige databasevermelding.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'		=> 'Ongeldig servicetype opgegeven voor OAuth service handler.',
    'AUTH_PROVIDER_OAUTH_ERROR_REQUEST'						=> 'Er ging helaas iets fout bij het afhandelen van je OAuth request.',
	'AUTH_PROVIDER_OAUTH_RETURN_ERROR'						=> 'De externe service gaf een ongeldige waarde terug en daardoor kon je verzoek niet worden verwerkt.',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'			=> 'OAuth-service niet aangemaakt',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'Google',
	'AUTH_PROVIDER_OAUTH_SERVICE_TWITTER'					=> 'Twitter',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'			=> 'OAuth-token niet opgeslagen.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'	=> 'OAuth-token incorrect opgeslagen.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'De upload is geweigerd omdat het geüploade bestand mogelijk gevaarlijk is.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Dit bestand kan niet worden weergegeven omdat de extensie <strong>%s</strong> niet is toegestaan.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'De avatar kon niet geüpload worden omdat de data ongeldig of corrupt is.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Het geüploade bestand is leeg.',
	'AVATAR_INVALID_FILENAME'		=> '%s is een ongeldige bestandsnaam.',
	'AVATAR_NOT_UPLOADED'			=> 'Avatar kon niet worden geüpload.',
	'AVATAR_NO_TEMP_DIR'			=> 'Tijdelijke map kan niet gevonden worden of is niet schrijfbaar.',
	'AVATAR_NO_SIZE'				=> 'De breedte of hoogte van de gekoppelde avatar kon niet worden vastgesteld. Vul ze hier handmatig in.',
	'AVATAR_NO_UPLOAD_DIR'			=> 'Avataropslaglocatie bestaat niet of is niet schrijfbaar.',
	'AVATAR_NO_UPLOAD_PATH'			=> 'Het uploaden van avatars is ingeschakeld maar er is op geen opslaglocatie voor avatars ingesteld.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Het opgegeven bestand is maar gedeeltelijk geüpload.',
	'AVATAR_PHP_SIZE_NA'			=> 'De bestandsgrootte van de avatar is te groot.<br />De maximum bestandsgrootte, ingesteld in php.ini, kon niet vastgesteld worden.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'De bestandsgrootte van de avatar is te groot. De maximum bestandsgrootte is %1$d %2$s.<br />Let op: dit is ingesteld in php.ini en kan niet worden omzeild.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'	=> 'De opgegeven avatar kon niet worden geüpload omdat de aanvraag is verlopen.',
	'AVATAR_PHP_UPLOAD_STOPPED'		=> 'Het uploaden is gestopt door een PHP-extensie.',
	'AVATAR_URL_INVALID'			=> 'De URL die je hebt opgegeven is ongeldig.',
	'AVATAR_URL_NOT_FOUND'			=> 'Het gespecificeerde bestand kon niet gevonden worden.',
	'AVATAR_WRONG_FILESIZE'			=> 'De bestandsgrootte van de avatar moet tussen 0 en %1$d %2$s zijn.',
	'AVATAR_WRONG_SIZE'				=> 'De verstuurde avatar is %5$s breed en %6$s hoog. Avatars moeten ten minste %1$s breed en %2$s hoog zijn, maar niet groter dan %3$s breed en %4$s hoog.',

	'BACK_TO_TOP'			=> 'Omhoog',
	'BACK_TO_PREV'			=> 'Terug naar de vorige pagina',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Je e-mailadres is verbannen.',
	'BAN_TRIGGERED_BY_IP'	=> 'Je IP-adres is verbannen.',
	'BAN_TRIGGERED_BY_USER'	=> 'Je gebruikersnaam is verbannen.',
	'BBCODE_GUIDE'			=> 'BBCode-handleiding',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'Verjaardagen',
	'BOARD_BAN_PERM'		=> 'Je bent <strong>permanent</strong> verbannen van dit forum.<br /><br />Neem contact op met een %2$sbeheerder%3$s voor meer informatie.',
	'BOARD_BAN_REASON'		=> 'Opgegeven reden voor verbanning: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Je bent verbannen van dit forum tot <strong>%1$s</strong>.<br /><br />Neem contact op met de %2$sbeheerder%3$s voor meer informatie.',
	'BOARD_DISABLE'			=> 'Sorry, dit forum is momenteel niet beschikbaar.',
	'BOARD_DISABLED'		=> 'Dit forum is momenteel uitgeschakeld.',
	'BOARD_UNAVAILABLE'		=> 'Sorry, het forum is tijdelijk niet beschikbaar. Probeer het over een paar minuten opnieuw.',
	'BROWSING_FORUM'		=> 'Gebruikers op dit forum: %1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		1	=> 'Gebruikers op dit forum: %2$s en %1$d gast',
		2	=> 'Gebruikers op dit forum: %2$s en %1$d gasten',
	),
	'BUTTON_DELETE'         => 'Verwijder',
	'BUTTON_EDIT'			=> 'Wijzig',
	'BUTTON_FORUM_LOCKED'	=> 'Gesloten',
	'BUTTON_INFORMATION'    => 'Informatie',
	'BUTTON_NEW_TOPIC'		=> 'Nieuw onderwerp',
	'BUTTON_PM'				=> 'PB',
	'BUTTON_PM_FORWARD'		=> 'Doorsturen',
	'BUTTON_PM_NEW'			=> 'Nieuw PB',
	'BUTTON_PM_REPLY'		=> 'Verstuur reactie',
	'BUTTON_PM_REPLY_ALL'	=> 'Beantwoord allen',
	'BUTTON_POST_REPLY'		=> 'Plaats reactie',
	'BUTTON_QUOTE'			=> 'Citeer',
	'BUTTON_REPORT'         => 'Rapporteer',
	'BUTTON_TOPIC_LOCKED'	=> 'Gesloten',
	'BUTTON_WARN'           => 'Waarschuw',
	'BYTES'					=> 'Bytes',
	'BYTES_SHORT'			=> 'B',

	'CANCEL'				=> 'Annuleren',
	'CHANGE'				=> 'wijzigen',
	'CHANGE_FONT_SIZE'		=> 'Wijzig tekengrootte',
	'CHANGING_PREFERENCES'	=> 'Wijzig forumvoorkeuren',
	'CHANGING_PROFILE'		=> 'Wijzig profielinstellingen',
	'CHARACTERS'			=> array(
		1	=> '%d tekens',
		2	=> '%d tekens',
	),
	'COLLAPSE_VIEW'			=> 'Weergave inklappen',
	'CLOSE_WINDOW'			=> 'Sluit venster',
	'CODE'				=> 'Code',
	'COLOUR_SWATCH'			=> 'Kleurenpalet',
	'COLON'					=> ':',
	'COMMA_SEPARATOR'		=> ', ',	// Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Bevestig',
	'CONFIRM_CODE'			=> 'Bevestigingscode',
	'CONFIRM_CODE_EXPLAIN'	=> 'Voer de code exact in zoals deze weergegeven wordt. Alle letters zijn hoofdlettergevoelig.',
	'CONFIRM_CODE_WRONG'	=> 'De bevestigingscode die je hebt ingevuld is niet correct.',
	'CONFIRM_OPERATION'		=> 'Weet je zeker dat je deze actie wil uitvoeren?',
	'CONFIRM_AVATAR_DELETE' => 'Weet je zeker dat je deze avatar wil verwijderen?',
	'CONGRATULATIONS'		=> 'Felicitaties aan',
	'CONNECTION_FAILED'		=> 'Verbinding verbroken.',
	'CONNECTION_SUCCESS'	=> 'Succesvol verbonden!',
	'CONTACT'				=> 'Contacteer',
	'CONTACT_USER'			=> 'Contacteer %s',
	'CONTACT_US'			=> 'Contact',
	'COOKIE_CONSENT_INFO'	=> 'Meer informatie',
	'COOKIE_CONSENT_MSG'	=> 'Deze website maakt gebruik van cookies om de beste surfervaring te kunnen bieden.',
	'COOKIE_CONSENT_OK'		=> 'Begrepen!',
	'COOKIE_CONSENT_HREF'	=> 'https://cookiesandyou.com',
	'COOKIES_DELETED'		=> 'Alle forumcookies succesvol verwijderd.',
	'CURRENT_TIME'			=> 'Het is momenteel %s',

	'DAY'					=> 'Dag',
	'DAYS'					=> 'Dagen',
	'DELETE'				=> 'Verwijder',
	'DELETE_ALL'			=> 'Verwijder alles',
	'DELETE_COOKIES'		=> 'Verwijder cookies',
	'DELETE_MARKED'			=> 'Verwijder gemarkeerden',
	'DELETE_POST'			=> 'Verwijder bericht',
	'DELIMITER'				=> 'Scheidingsteken',
	'DESCENDING'			=> 'Aflopend',
	'DISABLED'				=> 'Uitgeschakeld',
	'DISPLAY'				=> 'Weergave',
	'DISPLAY_GUESTS'		=> 'Gasten weergeven',
	'DISPLAY_MESSAGES'		=> 'Toon berichten van afgelopen',
	'DISPLAY_POSTS'			=> 'Toon berichten van afgelopen',
	'DISPLAY_TOPICS'		=> 'Toon onderwerpen van afgelopen',
	'DOMAIN_NO_MX_RECORD_EMAIL'	=> 'Het ingevoerde e-mailadres heeft geen valide MX record.',
	'DOWNLOADED'			=> 'Gedownload',
	'DOWNLOADING_FILE'		=> 'Bestand wordt gedownload',
	'DOWNLOAD_COUNTS'		=> array(
		0	=> 'Nog niet gedownload',
		1	=> '%d keer gedownload',
		2	=> '%d keer gedownload',
	),

	'EDIT_POST'							=> 'Wijzig bericht',
	'ELLIPSIS'							=> '…',
	'EMAIL'								=> 'E-mail', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'E-mailadres',
	'EMAIL_INVALID_EMAIL'				=> 'Het e-mailadres wat je hebt ingevuld is ongeldig.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Er liep iets fout bij het versturen van de e-mail op <strong>regel %1$s</strong>. Antwoord: %2$s.',
	'EMPTY_SUBJECT'						=> 'Je moet een onderwerp opgeven wanneer je een nieuw onderwerp plaatst.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Je moet een onderwerp opgeven wanneer je een nieuw bericht opstelt.',
	'ENABLED'							=> 'Ingeschakeld',
	'ENCLOSURE'							=> 'Omsluiting',
	'ENTER_USERNAME'					=> 'Vul gebruikersnaam in',
	'ERR_CHANGING_DIRECTORY'			=> 'Niet mogelijk om map te veranderen.',
	'ERR_CONNECTING_SERVER'				=> 'Fout bij verbinden met de server.',
	'ERR_JAB_AUTH'						=> 'Kon niet autoriseren op Jabber-server.',
	'ERR_JAB_CONNECT'					=> 'Kon niet verbinden met Jabber-server.',
	'ERR_UNABLE_TO_LOGIN'				=> 'De ingevoerde gebruikersnaam of wachtwoord is incorrect.',
	'ERR_UNWATCHING'					=> 'Er is een fout opgetreden tijdens het stopzetten van het abonnement.',
	'ERR_WATCHING'						=> 'Er is een fout opgetreden tijdens het aanvragen van het abonnement.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Het opgegeven phpBB-pad lijkt ongeldig te zijn.',
	'ERROR'								=> 'Fout',
	'EXPAND_VIEW'						=> 'Weergave uitklappen',
	'EXTENSION'							=> 'Extensie',
	'EXTENSION_DISABLED'				=> 'De extensie <strong>%s</strong> is uitgeschakeld.',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'De extensie <strong>%s</strong> is uitgeschakeld en kan niet langer worden weergegeven.',
	'EXTENSION_DOES_NOT_EXIST'			=> 'De extensie <strong>%s</strong> bestaat niet.',

	'FACEBOOK'				=> 'Facebook',
	'FAQ'					=> 'V&amp;A',
	'FAQ_EXPLAIN'			=> 'Veelgestelde vragen',
	'FEATURE_NOT_AVAILABLE' => 'De gevraagde functie is niet beschikbaar op dit forum.',
	'FILENAME'				=> 'Bestandsnaam',
	'FILESIZE'				=> 'Bestandsgrootte',
	'FILEDATE'				=> 'Bestandsdatum',
	'FILE_COMMENT'			=> 'Opmerkingen bij bestand',
	'FILE_CONTENT_ERR'		=> 'Kan de inhoud van het bestand %s niet lezen',
	'FILE_JSON_DECODE_ERR'	=> 'Het decoderen van het JSON-bestand %s mislukt',
	'FILE_NOT_FOUND'		=> 'Het opgevraagde bestand, %s, kon niet worden gevonden.',
	'FIND_USERNAME'			=> 'Zoek een lid',
	'FOLDER'				=> 'Map',
	'FORGOT_PASS'			=> 'Ik ben mijn wachtwoord vergeten',
	'FORM_INVALID'			=> 'Het verstuurde formulier is ongeldig. Probeer het nogmaals te versturen.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Forums',
	'FORUMS_MARKED'			=> 'Forums zijn gemarkeerd als gelezen.',
	'FORUM_CAT'				=> 'Forumcategorie',
	'FORUM_INDEX'			=> 'Forumoverzicht',
	'FORUM_LINK'			=> 'Forumlink',
	'FORUM_LOCATION'		=> 'Forumlocatie',
	'FORUM_LOCKED'			=> 'Forum gesloten',
	'FORUM_RULES'			=> 'Forumregels',
	'FORUM_RULES_LINK'		=> 'Klik hier om de forumregels te bekijken',
	'FROM'					=> 'van',
	'FSOCK_DISABLED'		=> 'De operatie kon niet voltooid worden omdat de <var>fsockopen</var>-functie is uitgeschakeld of de server die werd gezocht niet gevonden kon worden.',
	'FSOCK_TIMEOUT'			=> 'Er is een time-out opgetreden tijdens het lezen van de netwerkstream.',

	'FILESYSTEM_CANNOT_CHANGE_FILE_GROUP'			=> 'Kan bestandsgroep niet veranderen',
	'FILESYSTEM_CANNOT_CHANGE_FILE_PERMISSIONS'	=> 'Kan bestandspermissies niet veranderen',
	'FILESYSTEM_CANNOT_COPY_FILES'					=> 'Kan bestanden niet kopieren',
	'FILESYSTEM_CANNOT_CREATE_SYMLINK'				=> 'Kan geen symlink aanmaken',
	'FILESYSTEM_CANNOT_CREATE_DIRECTORY'		=> 'Kan geen map aanmaken',
	'FILESYSTEM_CANNOT_DELETE_FILES'				=> 'Kan geen bestanden verwijderen van het systeem',
	'FILESYSTEM_CANNOT_DUMP_FILE'					=> 'Kan het bestand niet opslaan',
	'FILESYSTEM_CANNOT_MIRROR_DIRECTORY'			=> 'Kan geen kopie van de map maken',
	'FILESYSTEM_CANNOT_RENAME_FILE'				=> 'Kan een bestand van het systeem niet hernoemen',
	'FILESYSTEM_CANNOT_TOUCH_FILES'				=> 'Kan niet vaststellen of het bestand bestaat',

	'FTP_FSOCK_HOST'				=> 'FTP-host',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'FTP-server die gebruikt wordt om te verbinden met je site.',
	'FTP_FSOCK_PASSWORD'			=> 'FTP-wachtwoord',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Wachtwoord voor je FTP-gebruikersnaam.',
	'FTP_FSOCK_PORT'				=> 'FTP-poort',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Poort gebruikt om te verbinden met je server.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Pad naar phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Pad van de bron naar je phpBB-forum.',
	'FTP_FSOCK_TIMEOUT'				=> 'FTP-time-out',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'De tijd die het systeem zal wachten op een antwoord van je server, in secondes.',
	'FTP_FSOCK_USERNAME'			=> 'FTP-gebruikersnaam',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'De FTP-gebruikersnaam die gebruikt wordt om verbinding te maken met je server.',

	'FTP_HOST'					=> 'FTP-host',
	'FTP_HOST_EXPLAIN'			=> 'De FTP-server die gebruikt wordt om te verbinden met je site.',
	'FTP_PASSWORD'				=> 'FTP-wachtwoord',
	'FTP_PASSWORD_EXPLAIN'		=> 'Wachtwoord voor je FTP-gebruikersnaam.',
	'FTP_PORT'					=> 'FTP-poort',
	'FTP_PORT_EXPLAIN'			=> 'De poort gebruikt om te verbinden met je server.',
	'FTP_ROOT_PATH'				=> 'Pad naar phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Pad van de bron naar je phpBB-forum.',
	'FTP_TIMEOUT'				=> 'FTP-time-out',
	'FTP_TIMEOUT_EXPLAIN'		=> 'De hoeveelheid tijd, in seconden, die het systeem zal wachten op een antwoord van je server.',
	'FTP_USERNAME'				=> 'FTP-gebruikersnaam',
	'FTP_USERNAME_EXPLAIN'		=> 'De FTP-gebruikersnaam die gebruikt wordt om verbinding te maken met je server.',

	'GENERAL_ERROR'				=> 'Algemene fout',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Ga',
	'GOTO_FIRST_POST'			=> 'Ga naar eerste bericht',
	'GOTO_LAST_POST'			=> 'Ga naar laatste bericht',
	'GOTO_PAGE'					=> 'Ga naar pagina',
	'GROUP'						=> 'Groep',
	'GROUPS'					=> 'Groepen',
	'GROUP_ERR_TYPE'			=> 'Ongeschikt groepstype opgegeven.',
	'GROUP_ERR_USERNAME'		=> 'Geen groepsnaam opgegeven.',
	'GROUP_ERR_USER_LONG'		=> 'Groepsnamen kunnen niet meer dan 60 tekens bevatten. De opgegeven groepsnaam is te lang.',
	'GUEST'						=> 'Gast',
	'GUEST_USERS_ONLINE'		=> array(
		1	=> 'Er is %d gast online',
		2	=> 'Er zijn %d gasten online',
	),
	'GUEST_USERS_TOTAL'			=>  array(
		1	=> '%d gast',
		2	=> '%d gasten',
	),
	'G_ADMINISTRATORS'			=> 'Beheerders',
	'G_BOTS'					=> 'Bots',
	'G_GUESTS'					=> 'Gasten',
	'G_REGISTERED'				=> 'Geregistreerde gebruikers',
	'G_REGISTERED_COPPA'		=> 'Geregistreerde COPPA-gebruikers',
	'G_GLOBAL_MODERATORS'		=> 'Algemene moderators',
	'G_NEWLY_REGISTERED'		=> 'Onlangs geregistreerde gebruikers',

	'HIDDEN_USERS_ONLINE'		=> array(
		1	=> '%d verborgen gebruiker',
		2	=> '%d verborgen gebruikers',
	),
	'HIDDEN_USERS_TOTAL'		=> array(
		1	=> '%d verborgen',
		2	=> '%d verborgen',
	),
	'HIDE_GUESTS'					=> 'Verberg gasten',
	'HIDE_ME'						=> 'Mij deze sessie niet weergeven in de lijst met online gebruikers',
	'HOURS'							=> 'Uren',
	'HOME'							=> 'Home',

	'ICQ'						=> 'ICQ',
	'IF'						=> 'Als',
	'IMAGE'						=> 'Afbeelding',
	'IMAGE_FILETYPE_INVALID'	=> 'Bestandstype %d van de afbeelding voor mime-type %s wordt niet ondersteund.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Verkeerde combinatie van bestandstype en afbeelding: extensie %1$s werd verwacht, maar extensie %2$s is gegeven.',
	'IN'						=> 'in',
	'INACTIVE'					=> 'Inactief',
	'INDEX'						=> 'Forumoverzicht',
	'INFORMATION'				=> 'Informatie',
	'INSECURE_REDIRECT'			=> 'Geprobeerd door te sturen naar een mogelijk onveilige URL.',
	'INTERESTS'					=> 'Interesses',
	'INVALID_DIGEST_CHALLENGE'	=> 'Ongeldig verslag.', // verslag uitdaging wat is dit? oO geen idee
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> is mogelijk een ongeldig e-mailadres?',
	'INVALID_FEED_ATTACHMENTS'	=> 'De geselecteerde feed probeerde op een ongeldige wijze bijlagen te verkrijgen.',
	'INVALID_PLURAL_RULE'		=> 'De gekozen meervoudsregel is ongeldig. Geldige waardes zijn gehele getallen tussen 0 en 15.',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Je IP %1$s is geblokkeerd omdat het op een zwarte lijst staat. Voor meer informatie bekijk <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Lid geworden op',
	'JUMP_PAGE'				=> 'Vul het paginanummer in waar je naar toe wil gaan',
	'JUMP_TO'				=> 'Ga naar',
	'JUMP_TO_PAGE'			=> 'Ga naar pagina',
	'JUMP_TO_PAGE_CLICK'	=> 'Klik om naar de pagina te gaan…',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Laatste bericht',
	'LAST_UPDATED'						=> 'Laatst bijgewerkt',
	'LAST_VISIT'						=> 'Laatste bezoek',
	'LDAP_NO_LDAP_EXTENSION'			=> 'LDAP-extensie is niet beschikbaar.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Kan niet verbinden met LDAP-server.',
	'LDAP_SEARCH_FAILED'				=> 'Een fout is opgetreden tijdens het doorzoeken van de LDAP-map.',
	'LEGEND'							=> 'Legenda',
	'LIVE_SEARCHES_NOT_ALLOWED'			=> 'Live zoeken is niet toegestaan.',  // live zoeken? :/
	'LOADING'							=> 'Laden',
	'LOCATION'							=> 'Locatie',
	'LOCK_POST'							=> 'Bericht sluiten',
	'LOCK_POST_EXPLAIN'					=> 'Voorkom wijzigen',
	'LOCK_TOPIC'						=> 'Onderwerp sluiten',
	'LOGIN'								=> 'Aanmelden',
	'LOGIN_CHECK_PM'					=> 'Meld je aan om je privéberichten te controleren.',
	'LOGIN_CONFIRMATION'				=> 'Bevestiging van aanmelden',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Om bruteforceaanvallen op accounts te voorkomen moet je een bevestigingscode invullen na een maximum aantal mislukte aanmeldpogingen. De code wordt weergegeven in de afbeelding die je hier onder ziet. Als je visueel beperkt bent en deze code niet kunt lezen, neem dan contact op met de %sforumbeheerder%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Je hebt het maximum aantal aanmeldpogingen bereikt. Als extra beveiliging naast je gebruikersnaam en wachtwoord moet je nu ook de CAPTCHA hieronder oplossen.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Je bent niet geverifiëerd door Apache.',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'	=> 'Een niet bestaande OAuth-service is opgevraagd.',
	'LOGIN_ERROR_PASSWORD'				=> 'Je hebt een ongeldig wachtwoord opgegeven. Controleer je wachtwoord en probeer het nogmaals. Als je problemen blijft houden, neem dan contact op met de %sforumbeheerder%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Het was niet mogelijk om je wachtwoord te converteren tijdens de update van dit forum. %sVraag een nieuw wachtwoord aan%s. Als je problemen blijft houden, neem dan contact op met de %sforumbeheerder%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Je hebt een ongeldige gebruikersnaam opgegeven. Controleer je gebruikersnaam en probeer het nogmaals. Als je problemen blijft houden, neem dan contact op met de %sforumbeheerder%s.',
	'LOGIN_FORUM'						=> 'Om dit forum te bekijken of er berichten te plaatsen, moet je het wachtwoord invullen.',
	'LOGIN_INFO'						=> 'Om je te kunnen aanmelden, moet je geregistreerd zijn. Registratie neemt enkele minuten in beslag, maar geeft je extra mogelijkheden. De forumbeheerder kan ook extra permissies toestaan aan geregistreerde gebruikers. Lees voor registratie onze gebruiksvoorwaarden en het bijbehorend beleid. Bekijk ook de regels als je gebruik maakt van het forum.',
	'LOGIN_VIEWFORUM'					=> 'Het forum wil dat je geregistreerd en aangemeld bent om dit forum te kunnen lezen.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Om berichten in dit forum te wijzigen, moet je geregistreerd en aangemeld zijn.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Om de online lijst te kunnen zien, moet je geregistreerd en aangemeld zijn.',
	'LOGIN_REQUIRED'					=> 'Je moet aangemeld zijn om deze actie uit te kunnen voeren.',
	'LOGOUT'							=> 'Afmelden',
	'LOGOUT_USER'						=> 'Afmelden [ %s ]',
	'LOG_ME_IN'							=> 'Onthouden',

	'MAIN'					=> 'Hoofd',
	'MARK'					=> 'Markeer',
	'MARK_ALL'				=> 'Alles markeren',
	'MARK_ALL_READ'			=> 'Markeer alles als gelezen',
	'MARK_FORUMS_READ'		=> 'Markeer forums als gelezen',
	'MARK_READ'				=> 'Markeer als gelezen',
	'MARK_SUBFORUMS_READ'	=> 'Markeer subforums als gelezen',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Moderatorpaneel',
	'MCP_SHORT'				=> 'Modereer',
	'MEMBERLIST'			=> 'Leden',
	'MEMBERLIST_EXPLAIN'	=> 'Bekijk de volledige ledenlijst',
	'MERGE'					=> 'Samenvoegen',
	'MERGE_POSTS'			=> 'Berichten verplaatsen',
	'MERGE_TOPIC'			=> 'Onderwerp samenvoegen',
	'MESSAGE'				=> 'Bericht',
	'MESSAGES'				=> 'Berichten',
	'MESSAGES_COUNT'		=> array(
		0	=> 'onbeperkte berichten',
		1	=> '%d bericht',
		2	=> '%d berichten',
	),
	'MESSAGE_BODY'			=> 'Berichtinhoud',
	'MINUTES'				=> 'Minuten',
	'MODERATE'				=> 'Modereer',
	'MODERATOR'				=> 'Moderator',
	'MODERATORS'			=> 'Moderators',
	'MODULE_NOT_ACCESS'		=> 'Module niet toegankelijk',
	'MODULE_NOT_FIND'		=> 'Kan module %s niet vinden',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'Modulebestand %s bevat geen correcte class [%s]',
	'MONTH'					=> 'Maand',
	'MOVE'					=> 'Verplaats',

	'NA'						=> 'N/B',
	'NEWEST_USER'				=> 'Ons nieuwste lid is <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Nieuw bericht',
	'NEW_MESSAGES'				=> 'Nieuwe berichten',
	'NEW_POST'					=> 'Nieuw bericht',	// Not used anymore
	'NEW_POSTS'					=> 'Nieuwe berichten',	// Not used anymore
	'NEXT'						=> 'Volgende',		// Used in pagination
	'NEXT_STEP'					=> 'Volgende',
	'NEVER'						=> 'Nooit',
	'NO'						=> 'Nee',
	'NO_NOTIFICATIONS'			=> 'Je hebt geen notificaties',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Je hebt geen toestemming om deze groep te beheren.',
	'NOT_AUTHORISED'			=> 'Je hebt geen toestemming om deze pagina te bekijken.',
	'NOT_WATCHING_FORUM'		=> 'Je bent niet langer geabonneerd op dit forum.',
	'NOT_WATCHING_TOPIC'		=> 'Je bent niet langer geabonneerd op dit onderwerp.',
	'NOTIFICATIONS'				=> 'Notificaties',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1	=> '<strong>Reactie</strong> van %1$s op het gebladwijzerde onderwerp:',
		2	=> '<strong>Reacties</strong> van %1$s op het gebladwijzerde onderwerp:',
	),
	'NOTIFICATION_FORUM'				=> '<em>Forum:</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'		=> '<strong>Groepsaanvraag</strong> van %1$s om lid te worden van groep %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'	=> '<strong>Groepsaanvraag goedgekeurd</strong> om lid te worden van groep %1$s.',
	'NOTIFICATION_METHOD_INVALID'		=> 'De functie "%s" verwijst niet naar een valide notificatiefunctie.',
	'NOTIFICATION_PM'					=> '<strong>Privébericht</strong> van %1$s.',
	'NOTIFICATION_POST'					=> array(
		1	=> '<strong>Reactie</strong> van %1$s op het onderwerp:',
		2	=> '<strong>Reacties</strong> van %1$s op het onderwerp:',
	),
	'NOTIFICATION_POST_APPROVED'		=> '<strong>Bericht goedgekeurd</strong>:',
	'NOTIFICATION_POST_DISAPPROVED'		=> '<strong>Bericht afgekeurd</strong>:',
	'NOTIFICATION_POST_IN_QUEUE'		=> '<strong>Berichtgoedkeuring</strong> aangevraagd door %1$s:',
	'NOTIFICATION_QUOTE'				=> array(
		1	=> '<strong>Geciteerd</strong> door %1$s in:',
	),
	'NOTIFICATION_REFERENCE'			=> '"%1$s"',
	'NOTIFICATION_REASON'				=> '<em>Reden:</em> %1$s.',
	'NOTIFICATION_REPORT_PM'			=> '<strong>Privébericht gemeld</strong> door %1$s:',
	'NOTIFICATION_REPORT_PM_CLOSED'		=> '<strong>Melding privébericht gesloten</strong> door %1$s:',
	'NOTIFICATION_REPORT_POST'			=> '<strong>Bericht gemeld</strong> door %1$s:',
	'NOTIFICATION_REPORT_CLOSED'		=> '<strong>Melding gesloten</strong> door %1$s vanwege:',
	'NOTIFICATION_TOPIC'				=> '<strong>Nieuw onderwerp</strong> door %1$s:',
	'NOTIFICATION_TOPIC_APPROVED'		=> '<strong>Onderwerp goedgekeurd</strong>:',
	'NOTIFICATION_TOPIC_DISAPPROVED'	=> '<strong>Onderwerp afgekeurd</strong>:',
	'NOTIFICATION_TOPIC_IN_QUEUE'		=> '<strong>Onderwerpgoedkeuring</strong> aangevraagd door %1$s:',
	'NOTIFICATION_TYPE_NOT_EXIST'		=> 'Het notificatietype "%s" mist in het bestandssysteem.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>Activatie benodigd</strong> voor gedeactiveerde nieuw geregistreerde gebruiker: “%1$s”',
	// Used in conjuction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'			=> 'anderen',
	'NOTIFICATION_X_OTHERS'				=> array(
		2	=> '%d anderen',
	),
	'NOTIFY_ADMIN'				=> 'Breng de forumbeheerder of sitebeheerder op de hoogte.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Breng de forumbeheerder of sitebeheerder op de hoogte: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Je hebt geen toestemming om dit bestand te openen.',
	'NO_ACTION'					=> 'Er is geen actie opgegeven.',
	'NO_ADMINISTRATORS'			=> 'Er zijn geen beheerders.',
	'NO_AUTH_ADMIN'				=> 'Toegang tot het beheerderspaneel is niet toegestaan als je geen beheerderspermissies hebt.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Je kunt je niet als een andere gebruiker opnieuw aanmelden.',
	'NO_AUTH_OPERATION'			=> 'Je hebt niet de juiste permissies om deze actie te voltooien.',
	'NO_AVATARS'				=> 'Er zijn momenteel geen avatars beschikbaar',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Kan niet verbinden met SMTP-host : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Er zijn geen verjaardagen vandaag.',
	'NO_EMAIL_MESSAGE'			=> 'E-mailbericht was leeg.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Kan geen reactie krijgen van de mailserver.',
	'NO_EMAIL_SUBJECT'			=> 'Geen e-mailonderwerp opgegeven.',
	'NO_FORUM'					=> 'Het forum dat je hebt geselecteerd bestaat niet.',
	'NO_FORUMS'					=> 'Deze site heeft geen forums.',
	'NO_GROUP'					=> 'De opgevraagde gebruikersgroep bestaat niet.',
	'NO_GROUP_MEMBERS'			=> 'Deze groep heeft momenteel geen leden.',
	'NO_IPS_DEFINED'			=> 'Geen IP-adres of hostnamen opgegeven',
	'NO_MEMBERS'				=> 'Geen leden gevonden met deze zoekcriteria.',
	'NO_MESSAGES'				=> 'Geen berichten',
	'NO_MODE'					=> 'Er is geen modus opgegeven.',
	'NO_MODERATORS'				=> 'Er zijn geen moderators.',
	'NO_NEW_MESSAGES'			=> 'Geen nieuwe berichten',
	'NO_NEW_POSTS'				=> 'Geen nieuwe berichten',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'Geen geregistreerde gebruikers',
	'NO_POSTS'					=> 'Geen berichten',
	'NO_POSTS_TIME_FRAME'		=> 'Er zijn in dit onderwerp in de gekozen periode geen berichten geplaatst.',
	'NO_FEED_ENABLED'			=> 'Feeds zijn niet beschikbaar op dit forum.',
	'NO_FEED'					=> 'De opgevraagde feed is niet beschikbaar.',
	'NO_STYLE_DATA'				=> 'Kan geen stijldata vinden voor user_style %s en user_id %s.',
	'NO_STYLE_CFG'				=> 'Kan geen stijlconfiguratiebestand (CFG) vinden voor: %s',
	'NO_SUBJECT'				=> 'Geen onderwerp opgegeven',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'De opgegeven zoekmodule bestaat niet.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Geen ondersteunde authenticatiemethodes.',
	'NO_TOPIC'					=> 'Het opgevraagde onderwerp bestaat niet.',
	'NO_TOPIC_FORUM'			=> 'Het onderwerp of forum bestaat niet meer.',
	'NO_TOPICS'					=> 'Er zijn geen onderwerpen of berichten in dit forum.',
	'NO_TOPICS_TIME_FRAME'		=> 'Er zijn in dit forum in de gekozen periode geen onderwerpen.',
	'NO_UNREAD_POSTS'			=> 'Geen ongelezen berichten',
	'NO_UPLOAD_FORM_FOUND'		=> 'De upload is gestart maar er is geen geldig uploadformulier gevonden.',
	'NO_USER'					=> 'De opgevraagde gebruiker bestaat niet.',
	'NO_USERS'					=> 'De opgevraagde gebruikers bestaan niet.',
	'NO_USER_SPECIFIED'			=> 'Geen gebruikersnaam opgegeven.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS'		=> array(
		1	=> '%d bijlage',
		2	=> '%d bijlages',
	),

	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Geen berichten in wachtrij',		// 0
		1			=> '1 bericht in wachtrij',		// 1
		2			=> '%d berichten in wachtrij',		// 2+
	),

	'OCCUPATION'				=> 'Beroep',
	'OFFLINE'					=> 'Offline',
	'ONLINE'					=> 'Online',
	'ONLINE_BUDDIES'			=> 'Online vrienden',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1	=> 'In totaal is er <strong>%1$d</strong> gebruiker online :: %2$s en %3$s',
		2	=> 'In totaal zijn er <strong>%1$d</strong> gebruikers online :: %2$s en %3$s',
	),
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1	=> 'In totaal is er <strong>%1$d</strong> gebruiker online :: %2$s, %3$s en %4$s',
		2	=> 'In totaal zijn er <strong>%1$d</strong> gebruikers online :: %2$s, %3$s en %4$s',
	),
	'OPTIONS'					=> 'Opties',

	'PAGE_NOT_FOUND'		=> 'De opgevragen pagina werd niet gevonden.',
	'PAGE_OF'				=> 'Pagina <strong>%1$d</strong> van <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'Pagina %s',
	'PASSWORD'				=> 'Wachtwoord',
	'PIXEL'					=> 'px',
	'PIXELS'				=> array(
		1	=> '%d pixel',
		2	=> '%d pixels',
	),
	'PLEASE_WAIT'			=> 'Even wachten.',
	'PM'					=> 'PB',
	'PM_REPORTED'			=> 'Klik hier om de melding te bekijken',
	'POSTING_MESSAGE'		=> 'Plaatst bericht in %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Schrijft een privébericht',
	'POST'					=> 'Bericht',
	'POST_ANNOUNCEMENT'		=> 'Aankondiging',
	'POST_STICKY'			=> 'Sticky',
	'POSTED'				=> 'Geplaatst',
	'POSTED_IN_FORUM'		=> 'in',
	'POSTED_ON_DATE'		=> 'op',
	'POSTS'					=> 'Berichten',
	'POSTS_UNAPPROVED'		=> 'Tenminste één bericht in dit onderwerp is nog niet goedgekeurd.',
	'POSTS_UNAPPROVED_FORUM'=> 'Tenminste één bericht in dit forum is nog niet goedgekeurd.',
	'POST_BY_AUTHOR'		=> 'door',
	'POST_BY_FOE'			=> '<strong>%1$s</strong>, die momenteel op je negeerlijst staat, heeft dit bericht geschreven.',
	'POST_DISPLAY'			=> 'Dit bericht weergeven.',
	'POST_DAY'				=> '%.2f berichten per dag',
	'POST_DELETED_ACTION'	=> 'Verwijderd bericht:',
	'POST_DELETED'			=> 'Dit bericht is verwijderd.',
	'POST_DELETED_BY'		=> '<strong>%2$s</strong> verwijderde het bericht van <strong>%1$s</strong> op %3$s.',
	'POST_DELETED_BY_REASON'=> '<strong>%2$s</strong> verwijderde het bericht van <strong>%1$s</strong> op %3$s vanwege de volgende reden: %4$s',
	'POST_DETAILS'			=> 'Berichtdetails',
	'POST_NEW_TOPIC'		=> 'Nieuw onderwerp plaatsen',
	'POST_PCT'				=> '%.2f%% van alle berichten',
	'POST_PCT_ACTIVE'		=> '%.2f%% van gebruikers berichten',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% van je berichten',
	'POST_REPLY'			=> 'Plaats een reactie',
	'POST_REPORTED'			=> 'Klik hier om de melding te bekijken',
	'POST_SUBJECT'			=> 'Berichtonderwerp',
	'POST_TIME'				=> 'Plaatsingstijd',
	'POST_TOPIC'			=> 'Plaats een nieuw onderwerp',
	'POST_UNAPPROVED_ACTION'=> 'Bericht wacht op goedkeuring:',
	'POST_UNAPPROVED'		=> 'Dit bericht is nog niet goedgekeurd.',
    'POST_UNAPPROVED_EXPLAIN'	=> 'Dit bericht is niet zichtbaar voor andere gebruikers totdat het is goedgekeurd door een moderator.',
   	'POWERED_BY'			=> 'Powered by %s',
	
	'QUOTE'					=> 'Citeer',
	
	'PREVIEW'				=> 'Voorbeeld',
	'PREVIOUS'				=> 'Vorige',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Vorige',
	'PRIVACY'				=> 'Privacybeleid',
	'PRIVACY_LINK'			=> 'Privacy',
	'PRIVATE_MESSAGE'		=> 'Privébericht',
	'PRIVATE_MESSAGES'		=> 'Privéberichten',
	'PRIVATE_MESSAGING'		=> 'Privéberichten',
	'PROFILE'				=> 'Gebruikerspaneel',

	'QUICK_LINKS'			=> 'Snelle links',

	'RANK'						=> 'Rang',
	'READING_FORUM'				=> 'Bekijkt onderwerpen in %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Leest algemene aankondiging',
	'READING_LINK'				=> 'Volgt forumlink %s',
	'READING_TOPIC'				=> 'Leest onderwerp in %s',
	'READ_PROFILE'				=> 'Profiel',
	'REASON'					=> 'Reden',
	'RECORD_ONLINE_USERS'		=> 'Het grootste aantal gebruikers online was <strong>%1$s</strong> op %2$s',
	'REDIRECT'					=> 'Doorsturen',
	'REDIRECTS'					=> 'Totaal aantal doorsturingen',
	'REGISTER'					=> 'Registreer',
	'REGISTERED_USERS'			=> 'Geregistreerde gebruikers:',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1	=> 'Er is %1$d geregistreerde gebruiker en %2$s online',
		2	=> 'Er zijn %1$d geregistreerde gebruikers en %2$s online',
	),
	'REG_USERS_TOTAL'			=> array(
		1	=> '%d geregistreerd',
		2	=> '%d geregistreerd',
	),
	'REMOVE'					=> 'Verwijder',
	'REMOVE_INSTALL'			=> 'Verwijder, verplaats of hernoem de install-map voordat je je forum gaat gebruiken. Als deze map nog steeds aanwezig is zal alleen het beheerderspaneel toegankelijk zijn.',
	'REPLIES'					=> 'Reacties',
	'REPLY_WITH_QUOTE'			=> 'Reageer met citaat',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Reageert op algemene aankondiging',
	'REPLYING_MESSAGE'			=> 'Reageert op bericht in %s',
	'REPORT_BY'					=> 'Gemeld door',
	'REPORT_POST'				=> 'Meld dit bericht',
	'REPORTING_POST'			=> 'Meld bericht',
	'RESEND_ACTIVATION'			=> 'Stuur activatie-e-mail opnieuw',
	'RESET'						=> 'Herstel',
	'RESTORE_PERMISSIONS'		=> 'Herstel permissies',
	'RETURN_INDEX'				=> '%sTerug naar het forumoverzicht%s',
	'RETURN_FORUM'				=> '%sTerug naar laatst bezochte forum%s',
	'RETURN_PAGE'				=> '%sTerug naar vorige pagina%s',
	'RETURN_TOPIC'				=> '%sTerug naar laatst bezochte onderwerp%s',
	'RETURN_TO'					=> 'Terug naar “%s”',
	'RETURN_TO_INDEX'			=> 'Terug naar het forumoverzicht',

	'ROUTE_NOT_FOUND'				=> 'De opgrevraagde route “%s” kon niet worden gevonden.',
	'ROUTE_INVALID_MISSING_PARAMS'	=> 'Ongeldige or missende parameters doorgegeven voor route “%s”.',
	
	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'Nieuws',
	'FEED_TOPICS_ACTIVE'		=> 'Actieve onderwerpen',
	'FEED_TOPICS_NEW'			=> 'Nieuwe onderwerpen',
	'RULES_ATTACH_CAN'			=> 'Je <strong>kunt</strong> bijlagen plaatsen in dit forum',
	'RULES_ATTACH_CANNOT'		=> 'Je <strong>kunt geen</strong> bijlagen plaatsen in dit forum',
	'RULES_DELETE_CAN'			=> 'Je <strong>kunt</strong> je eigen berichten verwijderen in dit forum',
	'RULES_DELETE_CANNOT'		=> 'Je <strong>kunt niet</strong> je eigen berichten verwijderen in dit forum',
	'RULES_DOWNLOAD_CAN'		=> 'Je <strong>kunt</strong> bijlagen downloaden in dit forum',
	'RULES_DOWNLOAD_CANNOT'		=> 'Je <strong>kunt geen</strong> bijlagen downloaden in dit forum',
	'RULES_EDIT_CAN'			=> 'Je <strong>kunt</strong> je eigen berichten wijzigen in dit forum',
	'RULES_EDIT_CANNOT'			=> 'Je <strong>kunt niet</strong> je eigen berichten wijzigen in dit forum',
	'RULES_LOCK_CAN'			=> 'Je <strong>kunt</strong> je onderwerpen sluiten in dit forum',
	'RULES_LOCK_CANNOT'			=> 'Je <strong>kunt niet</strong> je onderwerpen sluiten in dit forum',
	'RULES_POST_CAN'			=> 'Je <strong>kunt</strong> nieuwe berichten plaatsen in dit forum',
	'RULES_POST_CANNOT'			=> 'Je <strong>kunt niet</strong> nieuwe berichten plaatsen in dit forum',
	'RULES_REPLY_CAN'			=> 'Je <strong>kunt</strong> reageren op onderwerpen in dit forum',
	'RULES_REPLY_CANNOT'		=> 'Je <strong>kunt niet</strong> reageren op onderwerpen in dit forum',
	'RULES_VOTE_CAN'			=> 'Je <strong>kunt</strong> stemmen op peilingen in dit forum',
	'RULES_VOTE_CANNOT'			=> 'Je <strong>kunt niet</strong> stemmen op peilingen in dit forum',

	'SEARCH'					=> 'Zoek',
	'SEARCH_MINI'				=> 'Zoek…',
	'SEARCH_ADV'				=> 'Uitgebreid zoeken',
	'SEARCH_ADV_EXPLAIN'		=> 'Bekijk de uitgebreide zoekopties',
	'SEARCH_KEYWORDS'			=> 'Zoek op sleutelwoorden',
	'SEARCHING_FORUMS'			=> 'Doorzoeken forum',
	'SEARCH_ACTIVE_TOPICS'		=> 'Actieve onderwerpen',
	'SEARCH_FOR'				=> 'Zoek op',
	'SEARCH_FORUM'				=> 'Doorzoek dit forum…',
	'SEARCH_NEW'				=> 'Nieuwe berichten',
	'SEARCH_POSTS_BY'			=> 'Zoek berichten door',
	'SEARCH_SELF'				=> 'Je berichten',
	'SEARCH_TOPIC'				=> 'Doorzoek dit onderwerp…',
	'SEARCH_UNANSWERED'			=> 'Onbeantwoorde onderwerpen',
	'SEARCH_UNREAD'				=> 'Ongelezen berichten',
	'SEARCH_USER_POSTS'			=> 'Zoek gebruikers berichten',
	'SECONDS'					=> 'Seconden',
	'SEE_ALL'					=> 'Bekijk alle',
	'SELECT'					=> 'Selecteer',
	'SELECT_ALL_CODE'			=> 'Selecteer alles',
	'SELECT_DESTINATION_FORUM'	=> 'Selecteer een doelforum',
	'SELECT_FORUM'				=> 'Selecteer een forum',
	'SEND_EMAIL'				=> 'Verstuur e-mail', // Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Verstuur e-mail naar %s',
	'SEND_PRIVATE_MESSAGE'		=> 'Verstuur privébericht',
	'SETTINGS'					=> 'Instellingen',
	'SIGNATURE'					=> 'Onderschrift',
	'SKIP'						=> 'Doorgaan naar inhoud',
	'SKYPE'						=> 'Skype',
	'SMTP_NO_AUTH_SUPPORT'		=> 'SMTP-server ondersteunt authenticatie niet.',
	'SORRY_AUTH_READ'			=> 'Je hebt geen toestemming om dit forum te lezen.',
	'SORRY_AUTH_READ_TOPIC'		=> 'Je hebt geen toestemming om dit onderwerp te lezen.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Je hebt geen toestemming om deze bijlage te downloaden.',
	'SORT_BY'					=> 'Sorteer op',
	'SORT_DIRECTION'			=> 'Richting',
	'SORT_JOINED'				=> 'Aanmelddatum',
	'SORT_LOCATION'				=> 'Locatie',
	'SORT_OPTIONS'				=> 'Weergave- en sorteeropties',
	'SORT_RANK'					=> 'Rang',
	'SORT_POSTS'				=> 'Berichten',
	'SORT_TOPIC_TITLE'			=> 'Onderwerptitel',
	'SORT_USERNAME'				=> 'Gebruikersnaam',
	'SPLIT_TOPIC'				=> 'Splits onderwerp',
	'SQL_ERROR_OCCURRED'		=> 'Een SQL-fout is opgetreden tijdens het ophalen van deze pagina. Neem contact op met de %sforumbeheerder%s als dit probleem zich blijft voordoen.',
	'STATISTICS'				=> 'Statistieken',
	'START_WATCHING_FORUM'		=> 'Abonneer op forum',
	'START_WATCHING_TOPIC'		=> 'Abonneer op onderwerp',
	'STOP_WATCHING_FORUM'		=> 'Abonnement op forum opzeggen',
	'STOP_WATCHING_TOPIC'		=> 'Abonnement op onderwerp opzeggen',
	'STRING_LIST_MULTI'			=> '%1$s, en %2$s',
	'STRING_LIST_SIMPLE'		=> '%1$s en %2$s',
	'SUBFORUM'					=> 'Subforum',
	'SUBFORUMS'					=> 'Subforums',
	'SUBJECT'					=> 'Onderwerp',
	'SUBMIT'					=> 'Verstuur',

	'TB'				=> 'TB',
	'TERMS_LINK'		=> 'Gebruikersvoorwaarden',
	'TERMS_USE'			=> 'Gebruikersvoorwaarden',
	'TEST_CONNECTION'	=> 'Test verbinding',
	'THE_TEAM'			=> 'Het team',
	'TIB'				=> 'TiB',
	'TIME'				=> 'Tijd',
	'TIMEOUT_PROCESSING_REQ'			=> 'Tijdslimiet voor aanvraag verstreken.',

	'TOO_LARGE'						=> 'De waarde die je hebt ingevuld is te groot.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'De waarde van de <strong>Maximum aantal ontvangers per privébericht</strong>-instelling die je hebt ingevuld is te groot.',

	'TOO_LONG'						=> 'De waarde die je hebt ingevuld is te lang.',

	'TOO_LONG_CONFIRM_CODE'			=> 'De bevestigingscode die je hebt ingevuld is te lang.',
	'TOO_LONG_DATEFORMAT'			=> 'Het datumformaat dat je hebt ingevuld is te lang.',
	'TOO_LONG_JABBER'				=> 'De Jabber-accountnaam die je hebt ingevuld is te lang.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Het wachtwoord dat je hebt ingevuld is te lang.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'De wachtwoordbevestiging die je hebt ingevuld is te lang.',
	'TOO_LONG_USER_PASSWORD'		=> 'Het wachtwoord dat je hebt ingevuld is te lang.',
	'TOO_LONG_USERNAME'				=> 'De gebruikersnaam die je hebt ingevuld is te lang.',
	'TOO_LONG_EMAIL'				=> 'Het e-mailadres dat je hebt ingevuld is te lang.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Je hebt geprobeerd om op te veel opties te stemmen.',

	'TOO_SHORT'						=> 'De waarde die je hebt ingevuld is te kort.',

	'TOO_SHORT_CONFIRM_CODE'		=> 'De bevestigingscode die je hebt ingevuld is te kort.',
	'TOO_SHORT_DATEFORMAT'			=> 'De datumformaat die je hebt ingevuld is te kort.',
	'TOO_SHORT_JABBER'				=> 'De Jabber-accountnaam die je hebt ingevuld is te kort.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Het wachtwoord dat je hebt ingevuld is te kort.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'De wachtwoord bevestiging die je hebt ingevuld is te kort.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Het wachtwoord dat je hebt ingevuld is te kort.',
	'TOO_SHORT_USERNAME'			=> 'De gebruikersnaam die je hebt ingevuld is te kort.',
	'TOO_SHORT_EMAIL'				=> 'Het e-mailadres dat je hebt ingevuld is te kort.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'Het e-mailadres dat je ter bevestiging hebt opgegeven is te kort.',
	'TOO_SMALL'						=> 'De waarde die je hebt ingevuld is te klein.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'De waarde van de <strong>Maximum aantal ontvangers van privéberichten</strong>-instelling die je hebt ingevuld is te klein.',

	'TOPIC'				=> 'Onderwerp',
	'TOPICS'			=> 'Onderwerpen',
	'TOPICS_UNAPPROVED'	=> 'Tenminste één onderwerp in dit forum is nog niet goedgekeurd.',
	'TOPIC_ICON'		=> 'Onderwerpicoon',
	'TOPIC_LOCKED'		=> 'Dit onderwerp is gesloten, je kunt geen berichten wijzigen of reacties plaatsen.',
	'TOPIC_LOCKED_SHORT'=> 'Onderwerp gesloten',
	'TOPIC_MOVED'		=> 'Verplaatst onderwerp',
	'TOPIC_REVIEW'		=> 'Voorafgaande berichten',
	'TOPIC_TITLE'		=> 'Onderwerptitel',
	'TOPIC_UNAPPROVED'	=> 'Dit onderwerp is nog niet goedgekeurd.',
	'TOPIC_UNAPPROVED_FORUM'	=> array(
		1	=> 'Onderwerp nog niet goedgekeurd',
		2	=> 'Onderwerpen nog niet goedgekeurd',
	),
	'TOPIC_DELETED'		=> 'Dit onderwerp is verwijderd.',
	'TOTAL_ATTACHMENTS'	=> 'Bijlage(n)',
	'TOTAL_LOGS'		=> array(
		1	=> '%d log',
		2	=> '%d logs',
	),
	'TOTAL_PMS'		=> array(
		1	=> '%d privébericht in totaal',
		2	=> '%d privéberichten in totaal',
	),
	'TOPIC_POLL'		=> 'Dit onderwerp heeft een peiling.',
	'TOTAL_POSTS'		=> 'Aantal berichten',
	'TOTAL_POSTS_COUNT'	=> array(
		2	=> 'Aantal berichten <strong>%d</strong>',
	),
	'TOPIC_REPORTED'	=> 'Dit onderwerp is gemeld',
	'TOTAL_TOPICS'		=> array(
		2	=> 'Aantal onderwerpen <strong>%d</strong>',
	),
	'TOTAL_USERS'		=> array(
		2	=> 'Aantal leden <strong>%d</strong>',
	),
	'TRACKED_PHP_ERROR'	=> 'Bijgehouden PHP-fouten: %s',
	'TWITTER'		=> 'Twitter',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Het was niet mogelijk om de afmetingen van de afbeelding te bepalen. Controleer of de URL die je hebt ingevoerd juist is.',
	'UNABLE_TO_DELIVER_FILE'=> 'Kan bestand niet leveren.',
	'UNKNOWN_BROWSER'		=> 'Onbekende browser',
	'UNMARK_ALL'			=> 'Alles demarkeren',
	'UNREAD_MESSAGES'		=> 'Ongelezen berichten',
	'UNREAD_POST'			=> 'Ongelezen bericht',
	'UNREAD_POSTS'			=> 'Ongelezen berichten',
	'UNWATCH_FORUM_CONFIRM'		=> 'Weet je zeker dat je je abonnement voor dit forum wil opzeggen?',
	'UNWATCH_FORUM_DETAILED'	=> 'Weet je zeker dat je je abonnement voor het forum “%s” wil opzeggen?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Weet je zeker dat je je abonnement voor dit onderwerp wil opzeggen?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Weet je zeker dat je je abonnement voor het onderwerp “%s” wil opzeggen?',
	'UNWATCHED_FORUMS'			=> 'Je bent niet langer meer geabonneerd op de geselecteerde forums.',
	'UNWATCHED_TOPICS'			=> 'Je bent niet langer meer geabonneerd op de geselecteerde onderwerpen.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Je bent niet langer meer geabonneerd op de geselecteerde vermeldingen.',
	'UPDATE'				=> 'Update',
	'UPLOAD_IN_PROGRESS'	=> 'De upload is momenteel bezig.',
	'URL_REDIRECT'			=> 'Als je browser geen meta doorsturingen ondersteund, %sklik dan HIER om te worden doorgestuurd%s.',
	'USERGROUPS'			=> 'Groepen',
	'USERNAME'				=> 'Gebruikersnaam',
	'USERNAMES'				=> 'Gebruikersnamen',
	'USER_AVATAR'			=> 'Gebruikersavatar',
	'USER_CANNOT_READ'		=> 'Je kunt geen berichten lezen in dit forum.',
	'USER_POSTS'			=> array(
		1	=> '%d bericht',
		2	=> '%d berichten',
	),
	'USERS'					=> 'Gebruikers',
	'USE_PERMISSIONS'		=> 'Test gebruikerspermissies',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Je hebt geen permissies om deze functie te gebruiken. Het kan zijn dat je pas bent geregistreerd en dat je meer berichten moet plaatsen op het forum om deze functie te kunnen gebruiken.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Bekijken',
	'VIEWED_COUNTS'		=> array(
		0	=> 'Nog niet bekeken',
		1	=> '%d keer bekeken',
		2	=> '%d keer bekeken',
	),
	'VIEWING_CONTACT_ADMIN'		=> 'Bekijkt contactpagina',
	'VIEWING_FAQ'				=> 'Bekijkt veelgestelde vragen',
	'VIEWING_MEMBERS'			=> 'Bekijkt gebruikersinformatie',
	'VIEWING_ONLINE'			=> 'Bekijkt wie is er online',
	'VIEWING_MCP'				=> 'Bekijkt moderatorpaneel',
	'VIEWING_MEMBER_PROFILE'	=> 'Bekijkt gebruikersprofiel',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Bekijkt privéberichten',
	'VIEWING_REGISTER'			=> 'Registreert een account',
	'VIEWING_UCP'				=> 'Bekijkt gebruikerspaneel',
	'VIEWS'						=> 'Weergaves',
	'VIEW_BOOKMARKS'			=> 'Bekijk bladwijzers',
	'VIEW_FORUM_LOGS'			=> 'Bekijk logs',
	'VIEW_LATEST_POST'			=> 'Bekijk laatste bericht',
	'VIEW_NEWEST_POST'			=> 'Bekijk eerst ongelezen bericht',
	'VIEW_NOTES'				=> 'Bekijk gebruikersnotities',
	'VIEW_ONLINE_TIMES'			=> array(
		1	=> 'gebaseerd op actieve gebruikers in de laatste %d minuut',
		2	=> 'gebaseerd op actieve gebruikers in de laatste %d minuten',
	),
	'VIEW_TOPIC'				=> 'Bekijk onderwerp',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Aankondiging: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Algemene aankondiging: ',
	'VIEW_TOPIC_LOCKED'			=> 'Gesloten: ',
	'VIEW_TOPIC_LOGS'			=> 'Bekijk logs',
	'VIEW_TOPIC_MOVED'			=> 'Verplaatst: ',
	'VIEW_TOPIC_POLL'			=> 'Peiling: ',
	'VIEW_TOPIC_STICKY'			=> 'Sticky: ',
	'VISIT_WEBSITE'				=> 'Bezoek website',

	'WARNINGS'			=> 'Waarschuwingen',
	'WARN_USER'			=> 'Waarschuw gebruiker',
	'WATCH_FORUM_CONFIRM'	=> 'Weet je zeker dat je je wil abonneren op dit forum?',
	'WATCH_FORUM_DETAILED'	=> 'Weet je zeker dat je je wil abonneren op het forum “%s”?',
	'WATCH_TOPIC_CONFIRM'	=> 'Weet je zeker dat je je wil abonneren op dit onderwerp?',
	'WATCH_TOPIC_DETAILED'	=> 'Weet je zeker dat je je wil abonneren op het onderwerp “%s”?',
	'WELCOME_SUBJECT'	=> 'Welkom bij de %s forums',
	'WEBSITE'			=> 'Website',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE'		=> 'Wie is er online',
	'WRONG_PASSWORD'	=> 'Je hebt een ongeldig wachtwoord ingevuld.',

	'WRONG_DATA_COLOUR'			=> 'De kleurwaarde die je hebt ingevuld is ongeldig.',
	'WRONG_DATA_JABBER'			=> 'De naam die je hebt ingevuld is geen geldige Jabber-accountnaam.',
	'WRONG_DATA_LANG'			=> 'De taal die je hebt gespecificeerd is ongeldig.',
	'WRONG_DATA_POST_SD'		=> 'De gekozen sorteerrichting van de berichten is niet geldig.',
	'WRONG_DATA_POST_SK'		=> 'De gekozen sorteeroptie van de berichten is niet geldig.',
	'WRONG_DATA_TOPIC_SD'		=> 'De gekozen sorteerrichting van de onderwerpen is niet geldig.',
	'WRONG_DATA_TOPIC_SK'		=> 'De gekozen sorteeroptie van de onderwerpen is niet geldig.',
	'WROTE'						=> 'schreef',

	'YAHOO'				=> 'Yahoo! Messenger',
	'YOUTUBE'			=> 'YouTube',
	'YEAR'				=> 'Jaar',
	'YEAR_MONTH_DAY'	=> '(JJJJ-MM-DD)',
	'YES'				=> 'Ja',
	'YOU_LAST_VISIT'	=> 'Laatste bezoek was: %s',

	'datetime'			=> array(
		'TODAY'		=> 'Vandaag',
		'TOMORROW'	=> 'Morgen',
		'YESTERDAY'	=> 'Gisteren',
		'AGO'		=> array(
			0		=> 'minder dan een minuut geleden',
			1		=> '%d minuut geleden',
			2		=> '%d minuten geleden',
		),

		'Sunday'	=> 'zondag',
		'Monday'	=> 'maandag',
		'Tuesday'	=> 'dinsdag',
		'Wednesday'	=> 'woensdag',
		'Thursday'	=> 'donderdag',
		'Friday'	=> 'vrijdag',
		'Saturday'	=> 'zaterdag',

		'Sun'		=> 'zo',
		'Mon'		=> 'ma',
		'Tue'		=> 'di',
		'Wed'		=> 'wo',
		'Thu'		=> 'do',
		'Fri'		=> 'vr',
		'Sat'		=> 'za',

		'January'	=> 'januari',
		'February'	=> 'februari',
		'March'		=> 'maart',
		'April'		=> 'april',
		'May'		=> 'mei',
		'June'		=> 'juni',
		'July'		=> 'juli',
		'August'	=> 'augustus',
		'September' => 'september',
		'October'	=> 'oktober',
		'November'	=> 'november',
		'December'	=> 'december',

		'Jan'		=> 'jan',
		'Feb'		=> 'feb',
		'Mar'		=> 'mar',
		'Apr'		=> 'apr',
		'May_short'	=> 'mei',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'jun',
		'Jul'		=> 'jul',
		'Aug'		=> 'aug',
		'Sep'		=> 'sep',
		'Oct'		=> 'okt',
		'Nov'		=> 'nov',
		'Dec'		=> 'dec',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'		=> array(
		'UTC'					=> 'UTC',
		'UTC_OFFSET'			=> 'UTC%1$s',
		'UTC_OFFSET_CURRENT'	=> 'UTC%1$s - %2$s',

		'Etc/GMT-12'	=> 'UTC+12',
		'Etc/GMT-11'	=> 'UTC+11',
		'Etc/GMT-10'	=> 'UTC+10',
		'Etc/GMT-9'		=> 'UTC+9',
		'Etc/GMT-8'		=> 'UTC+8',
		'Etc/GMT-7'		=> 'UTC+7',
		'Etc/GMT-6'		=> 'UTC+6',
		'Etc/GMT-5'		=> 'UTC+5',
		'Etc/GMT-4'		=> 'UTC+4',
		'Etc/GMT-3'		=> 'UTC+3',
		'Etc/GMT-2'		=> 'UTC+2',
		'Etc/GMT-1'		=> 'UTC+1',
		'Etc/GMT+1'		=> 'UTC-1',
		'Etc/GMT+2'		=> 'UTC-2',
		'Etc/GMT+3'		=> 'UTC-3',
		'Etc/GMT+4'		=> 'UTC-4',
		'Etc/GMT+5'		=> 'UTC-5',
		'Etc/GMT+6'		=> 'UTC-6',
		'Etc/GMT+7'		=> 'UTC-7',
		'Etc/GMT+8'		=> 'UTC-8',
		'Etc/GMT+9'		=> 'UTC-9',
		'Etc/GMT+10'	=> 'UTC-10',
		'Etc/GMT+11'	=> 'UTC-11',
		'Etc/GMT+12'	=> 'UTC-12',

		'Africa/Abidjan'	=> 'Afrika/Abidjan',
		'Africa/Accra'		=> 'Afrika/Accra',
		'Africa/Addis_Ababa'	=> 'Afrika/Addis Ababa',
		'Africa/Algiers'	=> 'Afrika/Algiers',
		'Africa/Asmara'		=> 'Afrika/Asmara',
		'Africa/Bamako'		=> 'Afrika/Bamako',
		'Africa/Bangui'		=> 'Afrika/Bangui',
		'Africa/Banjul'		=> 'Afrika/Banjul',
		'Africa/Bissau'		=> 'Afrika/Bissau',
		'Africa/Blantyre'	=> 'Afrika/Blantyre',
		'Africa/Brazzaville'	=> 'Afrika/Brazzaville',
		'Africa/Bujumbura'	=> 'Afrika/Bujumbura',
		'Africa/Cairo'		=> 'Afrika/Caïro',
		'Africa/Casablanca'	=> 'Afrika/Casablanca',
		'Africa/Ceuta'		=> 'Afrika/Ceuta',
		'Africa/Conakry'	=> 'Afrika/Conakry',
		'Africa/Dakar'		=> 'Afrika/Dakar',
		'Africa/Dar_es_Salaam'	=> 'Afrika/Dar es Salaam',
		'Africa/Djibouti'	=> 'Afrika/Djibouti',
		'Africa/Douala'		=> 'Afrika/Douala',
		'Africa/El_Aaiun'	=> 'Afrika/El Aaiun',
		'Africa/Freetown'	=> 'Afrika/Freetown',
		'Africa/Gaborone'	=> 'Afrika/Gaborone',
		'Africa/Harare'		=> 'Afrika/Harare',
		'Africa/Johannesburg'	=> 'Afrika/Johannesburg',
		'Africa/Juba'		=> 'Afrika/Juba',
		'Africa/Kampala'	=> 'Afrika/Kampala',
		'Africa/Khartoum'	=> 'Afrika/Khartoem',
		'Africa/Kigali'		=> 'Afrika/Kigali',
		'Africa/Kinshasa'	=> 'Afrika/Kinshasa',
		'Africa/Lagos'		=> 'Afrika/Lagos',
		'Africa/Libreville'	=> 'Afrika/Libreville',
		'Africa/Lome'		=> 'Afrika/Lome',
		'Africa/Luanda'		=> 'Afrika/Luanda',
		'Africa/Lubumbashi'	=> 'Afrika/Lubumbashi',
		'Africa/Lusaka'		=> 'Afrika/Lusaka',
		'Africa/Malabo'		=> 'Afrika/Malabo',
		'Africa/Maputo'		=> 'Afrika/Maputo',
		'Africa/Maseru'		=> 'Afrika/Maseru',
		'Africa/Mbabane'	=> 'Afrika/Mbabane',
		'Africa/Mogadishu'	=> 'Afrika/Mogadishu',
		'Africa/Monrovia'	=> 'Afrika/Monrovia',
		'Africa/Nairobi'	=> 'Afrika/Nairobi',
		'Africa/Ndjamena'	=> 'Afrika/Ndjamena',
		'Africa/Niamey'		=> 'Afrika/Niamey',
		'Africa/Nouakchott'	=> 'Afrika/Nouakchott',
		'Africa/Ouagadougou'	=> 'Afrika/Ouagadougou',
		'Africa/Porto-Novo'	=> 'Afrika/Porto-Novo',
		'Africa/Sao_Tome'	=> 'Afrika/Sao Tomé',
		'Africa/Tripoli'	=> 'Afrika/Tripoli',
		'Africa/Tunis'		=> 'Afrika/Tunis',
		'Africa/Windhoek'	=> 'Afrika/Windhoek',

		'America/Adak'		=> 'Amerika/Adak',
		'America/Anchorage'	=> 'Amerika/Anchorage',
		'America/Anguilla'	=> 'Amerika/Anguilla',
		'America/Antigua'	=> 'Amerika/Antigua',
		'America/Araguaina'	=> 'Amerika/Araguaina',

		'America/Argentina/Buenos_Aires'	=> 'Amerika/Argentinië/Buenos Aires',
		'America/Argentina/Catamarca'	=> 'Amerika/Argentinië/Catamarca',
		'America/Argentina/Cordoba'		=> 'Amerika/Argentinië/Cordoba',
		'America/Argentina/Jujuy'		=> 'Amerika/Argentinië/Jujuy',
		'America/Argentina/La_Rioja'	=> 'Amerika/Argentinië/La Rioja',
		'America/Argentina/Mendoza'		=> 'Amerika/Argentinië/Mendoza',
		'America/Argentina/Rio_Gallegos'	=> 'Amerika/Argentinië/Rio Gallegos',
		'America/Argentina/Salta'		=> 'Amerika/Argentinië/Salta',
		'America/Argentina/San_Juan'	=> 'Amerika/Argentinië/San Juan',
		'America/Argentina/San_Luis'	=> 'Amerika/Argentinië/San Luis',
		'America/Argentina/Tucuman'		=> 'Amerika/Argentinië/Tucuman',
		'America/Argentina/Ushuaia'		=> 'Amerika/Argentinië/Ushuaia',

		'America/Aruba'			=> 'Amerika/Aruba',
		'America/Asuncion'		=> 'Amerika/Asuncion',
		'America/Atikokan'		=> 'Amerika/Atikokan',
		'America/Bahia'			=> 'Amerika/Bahia',
		'America/Bahia_Banderas'	=> 'Amerika/Bahia Banderas',
		'America/Barbados'		=> 'Amerika/Barbados',
		'America/Belem'			=> 'Amerika/Belem',
		'America/Belize'		=> 'Amerika/Belize',
		'America/Blanc-Sablon'	=> 'Amerika/Blanc-Sablon',
		'America/Boa_Vista'		=> 'Amerika/Boa Vista',
		'America/Bogota'		=> 'Amerika/Bogota',
		'America/Boise'			=> 'Amerika/Boise',
		'America/Cambridge_Bay'	=> 'Amerika/Cambridge Bay',
		'America/Campo_Grande'	=> 'Amerika/Campo Grande',
		'America/Cancun'		=> 'Amerika/Cancun',
		'America/Caracas'		=> 'Amerika/Caracas',
		'America/Cayenne'		=> 'Amerika/Cayenne',
		'America/Cayman'		=> 'Amerika/Cayman',
		'America/Chicago'		=> 'Amerika/Chicago',
		'America/Chihuahua'		=> 'Amerika/Chihuahua',
		'America/Costa_Rica'	=> 'Amerika/Costa Rica',
		'America/Creston'		=> 'Amerika/Creston',
		'America/Cuiaba'		=> 'Amerika/Cuiaba',
		'America/Curacao'		=> 'Amerika/Curacao',
		'America/Danmarkshavn'	=> 'Amerika/Danmarkshavn',
		'America/Dawson'		=> 'Amerika/Dawson',
		'America/Dawson_Creek'	=> 'Amerika/Dawson Creek',
		'America/Denver'		=> 'Amerika/Denver',
		'America/Detroit'		=> 'Amerika/Detroit',
		'America/Dominica'		=> 'Amerika/Dominica',
		'America/Edmonton'		=> 'Amerika/Edmonton',
		'America/Eirunepe'		=> 'Amerika/Eirunepe',
		'America/El_Salvador'	=> 'Amerika/El Salvador',
		'America/Fortaleza'		=> 'Amerika/Fortaleza',
		'America/Glace_Bay'		=> 'Amerika/Glace Bay',
		'America/Godthab'		=> 'Amerika/Godthab',
		'America/Goose_Bay'		=> 'Amerika/Goose Bay',
		'America/Grand_Turk'	=> 'Amerika/Grand Turk',
		'America/Grenada'		=> 'Amerika/Grenada',
		'America/Guadeloupe'	=> 'Amerika/Guadeloupe',
		'America/Guatemala'		=> 'Amerika/Guatemala',
		'America/Guayaquil'		=> 'Amerika/Guayaquil',
		'America/Guyana'		=> 'Amerika/Guyana',
		'America/Halifax'		=> 'Amerika/Halifax',
		'America/Havana'		=> 'Amerika/Havana',
		'America/Hermosillo'		=> 'Amerika/Hermosillo',
		'America/Indiana/Indianapolis'	=> 'Amerika/Indiana/Indianapolis',
		'America/Indiana/Knox'		=> 'Amerika/Indiana/Knox',
		'America/Indiana/Marengo'	=> 'Amerika/Indiana/Marengo',
		'America/Indiana/Petersburg'	=> 'Amerika/Indiana/Petersburg',
		'America/Indiana/Tell_City'	=> 'Amerika/Indiana/Tell City',
		'America/Indiana/Vevay'		=> 'Amerika/Indiana/Vevay',
		'America/Indiana/Vincennes'	=> 'Amerika/Indiana/Vincennes',
		'America/Indiana/Winamac'	=> 'Amerika/Indiana/Winamac',
		'America/Inuvik'		=> 'Amerika/Inuvik',
		'America/Iqaluit'		=> 'Amerika/Iqaluit',
		'America/Jamaica'		=> 'Amerika/Jamaica',
		'America/Juneau'		=> 'Amerika/Juneau',
		'America/Kentucky/Louisville'	=> 'Amerika/Kentucky/Louisville',
		'America/Kentucky/Monticello'	=> 'Amerika/Kentucky/Monticello',
		'America/Kralendijk'	=> 'Amerika/Kralendijk',
		'America/La_Paz'		=> 'Amerika/La Paz',
		'America/Lima'			=> 'Amerika/Lima',
		'America/Los_Angeles'	=> 'Amerika/Los Angeles',
		'America/Lower_Princes'	=> 'Amerika/Lower Princes',
		'America/Maceio'		=> 'Amerika/Maceio',
		'America/Managua'		=> 'Amerika/Managua',
		'America/Manaus'		=> 'Amerika/Manaus',
		'America/Marigot'		=> 'Amerika/Marigot',
		'America/Martinique'	=> 'Amerika/Martinique',
		'America/Matamoros'		=> 'Amerika/Matamoros',
		'America/Mazatlan'		=> 'Amerika/Mazatlan',
		'America/Menominee'		=> 'Amerika/Menominee',
		'America/Merida'		=> 'Amerika/Merida',
		'America/Metlakatla'	=> 'Amerika/Metlakatla',
		'America/Mexico_City'	=> 'Amerika/Mexico City',
		'America/Miquelon'		=> 'Amerika/Miquelon',
		'America/Moncton'		=> 'Amerika/Moncton',
		'America/Monterrey'		=> 'Amerika/Monterrey',
		'America/Montevideo'	=> 'Amerika/Montevideo',
		'America/Montreal'		=> 'Amerika/Montreal',
		'America/Montserrat'	=> 'Amerika/Montserrat',
		'America/Nassau'		=> 'Amerika/Nassau',
		'America/New_York'		=> 'Amerika/New York',
		'America/Nipigon'		=> 'Amerika/Nipigon',
		'America/Nome'			=> 'Amerika/Nome',
		'America/Noronha'		=> 'Amerika/Noronha',
		'America/North_Dakota/Beulah'		=> 'Amerika/North Dakota/Beulah',
		'America/North_Dakota/Center'		=> 'Amerika/North Dakota/Center',
		'America/North_Dakota/New_Salem'	=> 'Amerika/North Dakota/New Salem',
		'America/Ojinaga'		=> 'Amerika/Ojinaga',
		'America/Panama'		=> 'Amerika/Panama',
		'America/Pangnirtung'	=> 'Amerika/Pangnirtung',
		'America/Paramaribo'	=> 'Amerika/Paramaribo',
		'America/Phoenix'		=> 'Amerika/Phoenix',
		'America/Port-au-Prince'	=> 'Amerika/Port-au-Prince',
		'America/Port_of_Spain'	=> 'Amerika/Port of Spain',
		'America/Porto_Velho'	=> 'Amerika/Porto Velho',
		'America/Puerto_Rico'	=> 'Amerika/Puerto Rico',
		'America/Rainy_River'	=> 'Amerika/Rainy River',
		'America/Rankin_Inlet'	=> 'Amerika/Rankin Inlet',
		'America/Recife'		=> 'Amerika/Recife',
		'America/Regina'		=> 'Amerika/Regina',
		'America/Resolute'		=> 'Amerika/Resolute',
		'America/Rio_Branco'	=> 'Amerika/Rio Branco',
		'America/Santa_Isabel'	=> 'Amerika/Santa Isabel',
		'America/Santarem'		=> 'Amerika/Santarem',
		'America/Santiago'		=> 'Amerika/Santiago',
		'America/Santo_Domingo'	=> 'Amerika/Santo Domingo',
		'America/Sao_Paulo'		=> 'Amerika/Sao Paulo',
		'America/Scoresbysund'	=> 'Amerika/Scoresbysund',
		'America/Shiprock'		=> 'Amerika/Shiprock',
		'America/Sitka'			=> 'Amerika/Sitka',
		'America/St_Barthelemy'	=> 'Amerika/St. Barthelemy',
		'America/St_Johns'		=> 'Amerika/St. Johns',
		'America/St_Kitts'		=> 'Amerika/St. Kitts',
		'America/St_Lucia'		=> 'Amerika/St. Lucia',
		'America/St_Thomas'		=> 'Amerika/St. Thomas',
		'America/St_Vincent'	=> 'Amerika/St. Vincent',
		'America/Swift_Current'	=> 'Amerika/Swift Current',
		'America/Tegucigalpa'	=> 'Amerika/Tegucigalpa',
		'America/Thule'			=> 'Amerika/Thule',
		'America/Thunder_Bay'	=> 'Amerika/Thunder Bay',
		'America/Tijuana'		=> 'Amerika/Tijuana',
		'America/Toronto'		=> 'Amerika/Toronto',
		'America/Tortola'		=> 'Amerika/Tortola',
		'America/Vancouver'		=> 'Amerika/Vancouver',
		'America/Whitehorse'	=> 'Amerika/Whitehorse',
		'America/Winnipeg'		=> 'Amerika/Winnipeg',
		'America/Yakutat'		=> 'Amerika/Yakutat',
		'America/Yellowknife'	=> 'Amerika/Yellowknife',

		'Antarctica/Casey'		=> 'Antarctica/Casey',
		'Antarctica/Davis'		=> 'Antarctica/Davis',
		'Antarctica/DumontDUrville'	=> 'Antarctica/DumontDUrville',
		'Antarctica/Macquarie'	=> 'Antarctica/Macquarie',
		'Antarctica/Mawson'		=> 'Antarctica/Mawson',
		'Antarctica/McMurdo'	=> 'Antarctica/McMurdo',
		'Antarctica/Palmer'		=> 'Antarctica/Palmer',
		'Antarctica/Rothera'	=> 'Antarctica/Rothera',
		'Antarctica/South_Pole'	=> 'Antarctica/South Pole',
		'Antarctica/Syowa'		=> 'Antarctica/Syowa',
		'Antarctica/Vostok'		=> 'Antarctica/Vostok',

		'Arctic/Longyearbyen'	=> 'Arctica/Longyearbyen',

		'Asia/Aden'			=> 'Azië/Aden',
		'Asia/Almaty'		=> 'Azië/Almaty',
		'Asia/Amman'		=> 'Azië/Amman',
		'Asia/Anadyr'		=> 'Azië/Anadyr',
		'Asia/Aqtau'		=> 'Azië/Aqtau',
		'Asia/Aqtobe'		=> 'Azië/Aqtobe',
		'Asia/Ashgabat'		=> 'Azië/Ashgabat',
		'Asia/Baghdad'		=> 'Azië/Baghdad',
		'Asia/Bahrain'		=> 'Azië/Bahrain',
		'Asia/Baku'			=> 'Azië/Baku',
		'Asia/Bangkok'		=> 'Azië/Bangkok',
		'Asia/Beirut'		=> 'Azië/Beirut',
		'Asia/Bishkek'		=> 'Azië/Bishkek',
		'Asia/Brunei'		=> 'Azië/Brunei',
		'Asia/Choibalsan'	=> 'Azië/Choibalsan',
		'Asia/Chongqing'	=> 'Azië/Chongqing',
		'Asia/Colombo'		=> 'Azië/Colombo',
		'Asia/Damascus'		=> 'Azië/Damascus',
		'Asia/Dhaka'		=> 'Azië/Dhaka',
		'Asia/Dili'			=> 'Azië/Dili',
		'Asia/Dubai'		=> 'Azië/Dubai',
		'Asia/Dushanbe'		=> 'Azië/Dushanbe',
		'Asia/Gaza'			=> 'Azië/Gaza',
		'Asia/Harbin'		=> 'Azië/Harbin',
		'Asia/Hebron'		=> 'Azië/Hebron',
		'Asia/Ho_Chi_Minh'	=> 'Azië/Ho Chi Minh',
		'Asia/Hong_Kong'	=> 'Azië/Hong Kong',
		'Asia/Hovd'			=> 'Azië/Hovd',
		'Asia/Irkutsk'		=> 'Azië/Irkutsk',
		'Asia/Jakarta'		=> 'Azië/Jakarta',
		'Asia/Jayapura'		=> 'Azië/Jayapura',
		'Asia/Jerusalem'	=> 'Azië/Jerusalem',
		'Asia/Kabul'		=> 'Azië/Kabul',
		'Asia/Kamchatka'	=> 'Azië/Kamchatka',
		'Asia/Karachi'		=> 'Azië/Karachi',
		'Asia/Kashgar'		=> 'Azië/Kashgar',
		'Asia/Kathmandu'	=> 'Azië/Kathmandu',
		'Asia/Khandyga'		=> 'Azië/Khandyga',
		'Asia/Kolkata'		=> 'Azië/Kolkata',
		'Asia/Krasnoyarsk'	=> 'Azië/Krasnoyarsk',
		'Asia/Kuala_Lumpur'	=> 'Azië/Kuala Lumpur',
		'Asia/Kuching'		=> 'Azië/Kuching',
		'Asia/Kuwait'		=> 'Azië/Kuwait',
		'Asia/Macau'		=> 'Azië/Macau',
		'Asia/Magadan'		=> 'Azië/Magadan',
		'Asia/Makassar'		=> 'Azië/Makassar',
		'Asia/Manila'		=> 'Azië/Manila',
		'Asia/Muscat'		=> 'Azië/Muscat',
		'Asia/Nicosia'		=> 'Azië/Nicosia',
		'Asia/Novokuznetsk'	=> 'Azië/Novokuznetsk',
		'Asia/Novosibirsk'	=> 'Azië/Novosibirsk',
		'Asia/Omsk'			=> 'Azië/Omsk',
		'Asia/Oral'			=> 'Azië/Oral',
		'Asia/Phnom_Penh'	=> 'Azië/Phnom Penh',
		'Asia/Pontianak'	=> 'Azië/Pontianak',
		'Asia/Pyongyang'	=> 'Azië/Pyongyang',
		'Asia/Qatar'		=> 'Azië/Qatar',
		'Asia/Qyzylorda'	=> 'Azië/Qyzylorda',
		'Asia/Rangoon'		=> 'Azië/Rangoon',
		'Asia/Riyadh'		=> 'Azië/Riyadh',
		'Asia/Sakhalin'		=> 'Azië/Sakhalin',
		'Asia/Samarkand'	=> 'Azië/Samarkand',
		'Asia/Seoul'		=> 'Azië/Seoul',
		'Asia/Shanghai'		=> 'Azië/Shanghai',
		'Asia/Singapore'	=> 'Azië/Singapore',
		'Asia/Taipei'		=> 'Azië/Taipei',
		'Asia/Tashkent'		=> 'Azië/Tashkent',
		'Asia/Tbilisi'		=> 'Azië/Tbilisi',
		'Asia/Tehran'		=> 'Azië/Tehran',
		'Asia/Thimphu'		=> 'Azië/Thimphu',
		'Asia/Tokyo'		=> 'Azië/Tokyo',
		'Asia/Ulaanbaatar'	=> 'Azië/Ulaanbaatar',
		'Asia/Urumqi'		=> 'Azië/Urumqi',
		'Asia/Ust-Nera'		=> 'Azië/Ust-Nera',
		'Asia/Vientiane'	=> 'Azië/Vientiane',
		'Asia/Vladivostok'	=> 'Azië/Vladivostok',
		'Asia/Yakutsk'		=> 'Azië/Yakutsk',
		'Asia/Yekaterinburg'	=> 'Azië/Yekaterinburg',
		'Asia/Yerevan'		=> 'Azië/Yerevan',

		'Atlantic/Azores'		=> 'Atlantisch/Azores',
		'Atlantic/Bermuda'		=> 'Atlantisch/Bermuda',
		'Atlantic/Canary'		=> 'Atlantisch/Canary',
		'Atlantic/Cape_Verde'	=> 'Atlantisch/Cape Verde',
		'Atlantic/Faroe'		=> 'Atlantisch/Faroe',
		'Atlantic/Madeira'		=> 'Atlantisch/Madeira',
		'Atlantic/Reykjavik'	=> 'Atlantisch/Reykjavik',
		'Atlantic/South_Georgia'	=> 'Atlantisch/South Georgia',
		'Atlantic/St_Helena'	=> 'Atlantisch/St. Helena',
		'Atlantic/Stanley'		=> 'Atlantisch/Stanley',

		'Australia/Adelaide'	=> 'Australië/Adelaide',
		'Australia/Brisbane'	=> 'Australië/Brisbane',
		'Australia/Broken_Hill'	=> 'Australië/Broken Hill',
		'Australia/Currie'		=> 'Australië/Currie',
		'Australia/Darwin'		=> 'Australië/Darwin',
		'Australia/Eucla'		=> 'Australië/Eucla',
		'Australia/Hobart'		=> 'Australië/Hobart',
		'Australia/Lindeman'	=> 'Australië/Lindeman',
		'Australia/Lord_Howe'	=> 'Australië/Lord Howe',
		'Australia/Melbourne'	=> 'Australië/Melbourne',
		'Australia/Perth'		=> 'Australië/Perth',
		'Australia/Sydney'		=> 'Australië/Sydney',

		'Europe/Amsterdam'	=> 'Europa/Amsterdam',
		'Europe/Andorra'	=> 'Europa/Andorra',
		'Europe/Athens'		=> 'Europa/Athens',
		'Europe/Belgrade'	=> 'Europa/Belgrade',
		'Europe/Berlin'		=> 'Europa/Berlin',
		'Europe/Bratislava'	=> 'Europa/Bratislava',
		'Europe/Brussels'	=> 'Europa/Brussels',
		'Europe/Bucharest'	=> 'Europa/Bucharest',
		'Europe/Budapest'	=> 'Europa/Budapest',
		'Europe/Busingen'	=> 'Europa/Busingen',
		'Europe/Chisinau'	=> 'Europa/Chisinau',
		'Europe/Copenhagen'	=> 'Europa/Copenhagen',
		'Europe/Dublin'		=> 'Europa/Dublin',
		'Europe/Gibraltar'	=> 'Europa/Gibraltar',
		'Europe/Guernsey'	=> 'Europa/Guernsey',
		'Europe/Helsinki'	=> 'Europa/Helsinki',
		'Europe/Isle_of_Man'	=> 'Europa/Isle of Man',
		'Europe/Istanbul'	=> 'Europa/Istanbul',
		'Europe/Jersey'		=> 'Europa/Jersey',
		'Europe/Kaliningrad'	=> 'Europa/Kaliningrad',
		'Europe/Kiev'		=> 'Europa/Kiev',
		'Europe/Lisbon'		=> 'Europa/Lisbon',
		'Europe/Ljubljana'	=> 'Europa/Ljubljana',
		'Europe/London'		=> 'Europa/London',
		'Europe/Luxembourg'	=> 'Europa/Luxemburg',
		'Europe/Madrid'		=> 'Europa/Madrid',
		'Europe/Malta'		=> 'Europa/Malta',
		'Europe/Mariehamn'	=> 'Europa/Mariehamn',
		'Europe/Minsk'		=> 'Europa/Minsk',
		'Europe/Monaco'		=> 'Europa/Monaco',
		'Europe/Moscow'		=> 'Europa/Moscow',
		'Europe/Oslo'		=> 'Europa/Oslo',
		'Europe/Paris'		=> 'Europa/Paris',
		'Europe/Podgorica'	=> 'Europa/Podgorica',
		'Europe/Prague'		=> 'Europa/Prague',
		'Europe/Riga'		=> 'Europa/Riga',
		'Europe/Rome'		=> 'Europa/Rome',
		'Europe/Samara'		=> 'Europa/Samara',
		'Europe/San_Marino'	=> 'Europa/San Marino',
		'Europe/Sarajevo'	=> 'Europa/Sarajevo',
		'Europe/Simferopol'	=> 'Europa/Simferopol',
		'Europe/Skopje'		=> 'Europa/Skopje',
		'Europe/Sofia'		=> 'Europa/Sofia',
		'Europe/Stockholm'	=> 'Europa/Stockholm',
		'Europe/Tallinn'	=> 'Europa/Tallinn',
		'Europe/Tirane'		=> 'Europa/Tirane',
		'Europe/Uzhgorod'	=> 'Europa/Uzhgorod',
		'Europe/Vaduz'		=> 'Europa/Vaduz',
		'Europe/Vatican'	=> 'Europa/Vatican',
		'Europe/Vienna'		=> 'Europa/Vienna',
		'Europe/Vilnius'	=> 'Europa/Vilnius',
		'Europe/Volgograd'	=> 'Europa/Volgograd',
		'Europe/Warsaw'		=> 'Europa/Warsaw',
		'Europe/Zagreb'		=> 'Europa/Zagreb',
		'Europe/Zaporozhye'	=> 'Europa/Zaporozhye',
		'Europe/Zurich'		=> 'Europa/Zurich',

		'Indian/Antananarivo'	=> 'Indische Oceaan/Antananarivo',
		'Indian/Chagos'		=> 'Indische Oceaan/Chagos',
		'Indian/Christmas'	=> 'Indische Oceaan/Christmas',
		'Indian/Cocos'		=> 'Indische Oceaan/Cocos',
		'Indian/Comoro'		=> 'Indische Oceaan/Comoro',
		'Indian/Kerguelen'	=> 'Indische Oceaan/Kerguelen',
		'Indian/Mahe'		=> 'Indische Oceaan/Mahe',
		'Indian/Maldives'	=> 'Indische Oceaan/Maldives',
		'Indian/Mauritius'	=> 'Indische Oceaan/Mauritius',
		'Indian/Mayotte'	=> 'Indische Oceaan/Mayotte',
		'Indian/Reunion'	=> 'Indische Oceaan/Reunion',

		'Pacific/Apia'		=> 'Oceanië/Apia',
		'Pacific/Auckland'	=> 'Oceanië/Auckland',
		'Pacific/Chatham'	=> 'Oceanië/Chatham',
		'Pacific/Chuuk'		=> 'Oceanië/Chuuk',
		'Pacific/Easter'	=> 'Oceanië/Easter',
		'Pacific/Efate'		=> 'Oceanië/Efate',
		'Pacific/Enderbury'	=> 'Oceanië/Enderbury',
		'Pacific/Fakaofo'	=> 'Oceanië/Fakaofo',
		'Pacific/Fiji'		=> 'Oceanië/Fiji',
		'Pacific/Funafuti'	=> 'Oceanië/Funafuti',
		'Pacific/Galapagos'	=> 'Oceanië/Galapagos',
		'Pacific/Gambier'	=> 'Oceanië/Gambier',
		'Pacific/Guadalcanal'	=> 'Oceanië/Guadalcanal',
		'Pacific/Guam'		=> 'Oceanië/Guam',
		'Pacific/Honolulu'	=> 'Oceanië/Honolulu',
		'Pacific/Johnston'	=> 'Oceanië/Johnston',
		'Pacific/Kiritimati'	=> 'Oceanië/Kiritimati',
		'Pacific/Kosrae'	=> 'Oceanië/Kosrae',
		'Pacific/Kwajalein'	=> 'Oceanië/Kwajalein',
		'Pacific/Majuro'	=> 'Oceanië/Majuro',
		'Pacific/Marquesas'	=> 'Oceanië/Marquesas',
		'Pacific/Midway'	=> 'Oceanië/Midway',
		'Pacific/Nauru'		=> 'Oceanië/Nauru',
		'Pacific/Niue'		=> 'Oceanië/Niue',
		'Pacific/Norfolk'	=> 'Oceanië/Norfolk',
		'Pacific/Noumea'	=> 'Oceanië/Noumea',
		'Pacific/Pago_Pago'	=> 'Oceanië/Pago Pago',
		'Pacific/Palau'		=> 'Oceanië/Palau',
		'Pacific/Pitcairn'	=> 'Oceanië/Pitcairn',
		'Pacific/Pohnpei'	=> 'Oceanië/Pohnpei',
		'Pacific/Port_Moresby'	=> 'Oceanië/Port Moresby',
		'Pacific/Rarotonga'	=> 'Oceanië/Rarotonga',
		'Pacific/Saipan'	=> 'Oceanië/Saipan',
		'Pacific/Tahiti'	=> 'Oceanië/Tahiti',
		'Pacific/Tarawa'	=> 'Oceanië/Tarawa',
		'Pacific/Tongatapu'	=> 'Oceanië/Tongatapu',
		'Pacific/Wake'		=> 'Oceanië/Wake',
		'Pacific/Wallis'	=> 'Oceanië/Wallis',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Jan 1st, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Ma Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'Januari 1ste, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Vandaag, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Vandaag, 1:37 pm / Januari 1ste, 2007, 1:37 pm',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'd M Y, H:i', // 01 Jan 2007, 13:37

));
