<?php

function loginizer_security_init(){
	
	global $loginizer;

	// TODO : Disable loginizer/loginizer.php
	// ATM, it will not load if the premium plugin is loaded
	
	// Load license
	if(!defined('SITEPAD')){
		
		$loginizer['license'] = get_option('loginizer_license');
		
		// Check for updates
		include_once('updater/plugin-update-checker.php');
		$loginizer_updater = Loginizer_PucFactory::buildUpdateChecker(LOGINIZER_API.'updates.php?version='.LOGINIZER_VERSION, LOGINIZER_FILE);
		
		// Add the license key to query arguments
		$loginizer_updater->addQueryArgFilter('loginizer_updater_filter_args');
		
		// Show the text to install the license key
		add_filter('puc_manual_final_check_link-loginizer-security', 'loginizer_updater_check_link', 10, 1);
		
		// Update license details as well
		if(!empty($loginizer['license']) && (time() - @$loginizer['license']['last_update']) >= 86400){
			
			$resp = wp_remote_get(LOGINIZER_API.'license.php?license='.$loginizer['license']['license']);
			
			// Did we get a response ?
			if(is_array($resp)){
				
				$tosave = json_decode($resp['body'], true);
				
				// Is it the license ?
				if(!empty($tosave['license'])){
					$tosave['last_update'] = time();
					update_option('loginizer_license', $tosave);
				}
				
			}
			
		}
	}
	
	add_filter('loginizer_system_information', 'loginizer_premium_system_info', 10);
	add_filter('loginizer_pre_page_dashboard', 'loginizer_premium_page_dashboard', 10);

	// A way to remove the settings
	if(file_exists(LOGINIZER_DIR.'/reset_admin.txt')){
		update_option('loginizer_wp_admin', array());
	}
	
	// Are we to ban user emails ?
	if(!empty($loginizer['domains_blacklist']) && count($loginizer['domains_blacklist']) > 0){			
		add_filter('registration_errors', 'loginizer_domains_blacklist', 10, 3);
		add_filter('woocommerce_registration_errors', 'loginizer_domains_blacklist', 10, 3);
	}
	
	// Is email password less login enabled ?
	if(!empty($loginizer['email_pass_less']) && !defined('XMLRPC_REQUEST')){
		
		// Add a handler for the GUI Login
		add_filter('authenticate', 'loginizer_epl_wp_authenticate', 10002, 3);
		
		// Dont show password error
		add_filter('wp_login_errors', 'loginizer_epl_error_handler', 10000, 2);
		
		// Hide the password field
		add_action('login_enqueue_scripts', 'loginizer_epl_hide_pass');
		
	}
	
	// Are we to rename the login ?
	if(!empty($loginizer['login_slug'])){
		
		//$loginizer['login_slug'] = 'login';
		
		// Add the filters / actions
		add_filter('site_url', 'loginizer_rl_site_url', 10, 2);
		add_filter('network_site_url', 'loginizer_rl_site_url', 10, 2);
		add_filter('wp_redirect', 'loginizer_rl_wp_redirect', 10, 2);
		add_filter('register', 'loginizer_rl_register');
		add_action('wp_loaded', 'loginizer_rl_wp_loaded');
		
	}
	
	// Rename the WP-ADMIN folder
	if(!defined('SITEPAD') && !empty($loginizer['admin_slug'])){
		
		add_filter('admin_url', 'loginizer_admin_url', 10001, 3);
		add_action('set_auth_cookie', 'loginizer_admin_url_cookie');
		
		// For multisite
		if(lz_is_multisite()){
			add_filter('network_admin_url', 'loginizer_network_admin_url', 10001, 2);
		}
		
		if(!empty($loginizer['restrict_wp_admin']) && preg_match('/\/wp-admin/is', $_SERVER['REQUEST_URI'])){
			die(empty($loginizer['wp_admin_msg']) ? $loginizer['wp_admin_d_msg'] : $loginizer['wp_admin_msg']);
		}
		
	}
	
	// WP-Admin Test AJAX handler
	add_action('wp_ajax_loginizer_wp_admin', 'loginizer_wp_admin_ajax');
	
	// Are we to rename the xmlrpc ?
	if(!defined('SITEPAD') && !empty($loginizer['xmlrpc_slug']) && empty($loginizer['xmlrpc_disable'])){
		
		// Add the filters / actions
		add_action('wp_loaded', 'loginizer_xml_rename_wp_loaded');
		
	}

	// Are we to DISABLE the xmlrpc ?
	if(!empty($loginizer['xmlrpc_disable'])){
		
		// Add the filters / actions
		add_filter('xmlrpc_enabled', 'loginizer_xmlrpc_null');
		add_filter('bloginfo_url', 'loginizer_xmlrpc_remove_pingback_url', 10000, 2);
		add_action('wp_loaded', 'loginizer_xmlrpc_disable');
		
	}
	
	// Are we to disable pingbacks ?
	if(!empty($loginizer['pingbacks_disable'])){
		
		// Add the filters / actions
		add_filter('xmlrpc_methods', 'loginizer_pingbacks_disable');
		
	}
	
	//-----------------------------------
	// Add the captcha filters / actions
	//-----------------------------------
	
	if(!empty($loginizer['captcha_key']) || !empty($loginizer['captcha_no_google'])){
		
		add_action('login_init', 'loginizer_cap_session_key');
	
		// Is reCaptcha on for login ?
		if(!empty($loginizer['captcha_login']) && !defined('XMLRPC_REQUEST')){
			
			add_filter('authenticate', 'loginizer_cap_login_verify', 10000);
			add_action('login_form', 'loginizer_cap_form_login', 100);
			add_action('woocommerce_login_form', 'loginizer_cap_form_login', 100);
			
			// Need to make more room for login form
			if(empty($loginizer['captcha_remove_css'])){
				add_action('login_enqueue_scripts', 'loginizer_cap_login_form');
			}
			
		}

		// Is reCaptcha on for Lost Password utility ?
		if(!empty($loginizer['captcha_lostpass'])){			
			add_action('allow_password_reset', 'loginizer_cap_lostpass_verify', 10, 2);
			add_action('lostpassword_form', 'loginizer_cap_form_login', 100);
			add_filter('woocommerce_lostpassword_form', 'loginizer_cap_form_login');
		}

		// Is reCaptcha on for Reset Password utility ?
		if(!empty($loginizer['captcha_resetpass'])){
			add_filter('validate_password_reset', 'loginizer_cap_resetpass_verify', 10, 2);
			add_action('resetpass_form', 'loginizer_cap_reset_form', 99);
			add_filter('woocommerce_resetpassword_form', 'loginizer_cap_form_login');
		}

		// Is reCaptcha on for registration ?
		if(!empty($loginizer['captcha_register'])){			
			add_filter('registration_errors', 'loginizer_cap_register_verify', 10, 3);
			add_action('register_form', 'loginizer_cap_form_login', 100);
			
			add_filter('woocommerce_before_checkout_process', 'loginizer_wc_before_checkout_process', 10);
			
			add_filter('woocommerce_register_form', 'loginizer_cap_form_login');
			add_filter('woocommerce_registration_errors', 'loginizer_cap_register_verify', 10, 3);
			
			if(!empty($loginizer['captcha_wc_checkout'])){
				add_action('woocommerce_checkout_order_review', 'loginizer_cap_form_ecommerce');
			}
		}
		
		// Are we to show Captcha for guests only ?
		if((is_user_logged_in() && empty($loginizer['captcha_user_hide'])) || !is_user_logged_in()){
		
			// Is reCaptcha on for comment utility ?
			if(!empty($loginizer['captcha_comment'])){
				add_filter('preprocess_comment', 'loginizer_cap_comment_verify');
				add_action('comment_form', 'loginizer_cap_comment_form');
			}
			
			// Is reCaptcha on for WooCommerce Logout utility ?
			if(!empty($loginizer['captcha_wc_checkout'])){
				add_action('woocommerce_after_checkout_validation', 'loginizer_wc_checkout_verify');
				add_action('woocommerce_checkout_order_review', 'loginizer_cap_form_ecommerce');
			}
		
		}
	
	}
	
	//-----------------
	// Two Factor Auth
	//-----------------
	
	if(!defined('SITEPAD') && (!empty($loginizer['2fa_app']) || !empty($loginizer['2fa_email']) || !empty($loginizer['2fa_sms']) || !empty($loginizer['question']))
		&& !defined('XMLRPC_REQUEST')){
		
		// After username and password check has been verified, are we to redirect ?
		add_filter('authenticate', 'loginizer_user_redirect', 10003, 3);
		
		// Shows the Question / 2fa field
		add_action('login_form_loginizer_security', 'loginizer_user_security');
		
		// Ajax handler
		add_action('wp_ajax_loginizer_ajax', 'loginizer_user_page_ajax');
		
		// Is the user logged in ?
		if(is_user_logged_in()){
			
			// Load user settings
			loginizer_load_user_settings($tfa_uid, $tfa_user, $tfa_settings, $tfa_current_pref);
			
			// If 2FA applicable as per role
			if(loginizer_is_2fa_applicable($tfa_user)){
		
				// Add to Settings menu on sites
				add_action('admin_menu', 'loginizer_user_menu');
			
				// Show the user the notification to set a 2FA
				$loginizer['loginizer_2fa_notice'] = get_user_meta($tfa_uid, 'loginizer_2fa_notice');
				
				// Are we to show the loginizer notification to set a 2FA
				if(empty($loginizer['loginizer_2fa_notice']) && 
					@$_COOKIE['loginizer_2fa_notice_'.$tfa_uid] != md5(wp_get_session_token()) && 
					(empty($tfa_current_pref) || $tfa_current_pref == 'none') &&
					lz_optget('page') != 'loginizer_user'
				){
				
					add_action('admin_notices', 'loginizer_2fa_notice');
				
				}
				
				// Are we to disable the notice forever ?
				if(isset($_GET['loginizer_2fa_notice']) && (int)$_GET['loginizer_2fa_notice'] == 0){
					update_user_meta($tfa_uid, 'loginizer_2fa_notice', time());
					die('DONE');
				}
				
				// Are we to disable the notice temporarily ?
				if(isset($_GET['loginizer_2fa_notice']) && (int)$_GET['loginizer_2fa_notice'] == 1){
					@setcookie('loginizer_2fa_notice_'.$tfa_uid, md5(wp_get_session_token()), time() + (3 * DAY_IN_SECONDS), COOKIEPATH, COOKIE_DOMAIN);
				}
			
			}
			
		}
		
	}
	
	// Checksum is enabled right i.e. its not disabled ?
	if(!defined('SITEPAD') && empty($loginizer['disable_checksum'])){
		
		// Create an action always
		add_action('loginizer_do_checksum', 'loginizer_checksums');
		
		// Difference in seconds since last time
		$diff = (time() - $loginizer['checksums_last_run']);
		
		// Has it crossed the time ?
		if(($diff / 86400) >= $loginizer['checksum_frequency']){
			//loginizer_checksums();
			wp_schedule_single_event(time(), 'loginizer_do_checksum');
		}
		
	}

}

function loginizer_premium_system_info(){
	
	global $loginizer;
	
	echo '
	<tr>			
		<th align="left" valign="top">'.__('Loginizer License', 'loginizer').'</th>
		<td align="left">
			'.(empty($loginizer['license']) ? '<span style="color:red">Unlicensed</span> &nbsp; &nbsp;' : '').' 
			<input type="text" name="lz_license" value="'.(empty($loginizer['license']) ? '' : $loginizer['license']['license']).'" size="30" placeholder="e.g. WXCSE-SFJJX-XXXXX-AAAAA-BBBBB" style="width:300px;" /> &nbsp; 
			<input name="save_lz" class="button button-primary" value="Update License" type="submit" />';
			
			if(!empty($loginizer['license'])){
				
				$expires = $loginizer['license']['expires'];
				$expires = substr($expires, 0, 4).'/'.substr($expires, 4, 2).'/'.substr($expires, 6);
				
				echo '<div style="margin-top:10px;">License Active : '.(empty($loginizer['license']['active']) ? '<span style="color:red">No</span>' : '<span style="color:green">Yes</span>').' &nbsp; &nbsp; &nbsp; 
				License Expires : '.($loginizer['license']['expires'] <= date('Ymd') ? '<span style="color:red">'.$expires.'</span>' : $expires).'
				</div>';
			}
		echo 
		'</td>
	</tr>';
	
}

function loginizer_premium_page_dashboard(){
	
	global $loginizer, $lz_error;

	// Is there a license key ?
	if(isset($_POST['save_lz'])){
	
		$license = lz_optpost('lz_license');
		
		// Check if its a valid license
		if(empty($license)){
			$lz_error['lic_invalid'] = __('The license key was not submitted', 'loginizer');
			return loginizer_page_dashboard_T();
		}
		
		$resp = wp_remote_get(LOGINIZER_API.'license.php?license='.$license, array('timeout' => 30));
		
		if(is_array($resp)){
			$json = json_decode($resp['body'], true);
			//print_r($json);
		}else{
		
			$lz_error['resp_invalid'] = __('The response was malformed<br>'.var_export($resp, true), 'loginizer');
			return loginizer_page_dashboard_T();
			
		}
		
		// Save the License
		if(empty($json['license'])){
		
			$lz_error['lic_invalid'] = __('The license key is invalid', 'loginizer');
			return loginizer_page_dashboard_T();
			
		}else{
			
			update_option('loginizer_license', $json);
			
			// Mark as saved
			$GLOBALS['lz_saved'] = true;
		}
		
	}
	
}

// Add our license key if ANY
function loginizer_updater_filter_args($queryArgs) {
	
	global $loginizer;
	
	if ( !empty($loginizer['license']['license']) ) {
		$queryArgs['license'] = $loginizer['license']['license'];
	}
	
	return $queryArgs;
}

// Handle the Check for update link and ask to install license key
function loginizer_updater_check_link($final_link){
	
	global $loginizer;
	
	if(empty($loginizer['license']['license'])){
		return '<a href="'.admin_url('admin.php?page=loginizer').'">Install License Key to Update</a>';
	}
	
	return $final_link;
}

// Change the Admin URL
function loginizer_admin_url($url, $path, $blog_id){
	
	global $loginizer;
	
	//echo $url."\n";echo $path."\n";
	$new = str_replace('wp-admin', $loginizer['admin_slug'], $url);
	
	//echo $new.'<br>';
	return $new;
}

function loginizer_network_admin_url($url, $path){
	
	global $loginizer;
	
	//echo $url.'<br>';echo $path.'<br>';
	$new = str_replace('wp-admin', $loginizer['admin_slug'], $url);
	
	//echo $new.'<br>';	
	return $new;
}

// Required to be able to Login
function loginizer_admin_url_cookie($auth_cookie, $expire = 0, $expiration = '', $user_id = '', $scheme = ''){
	
	global $loginizer;
	
	if($scheme == 'secure_auth' || is_ssl()){
		$auth_cookie_name = SECURE_AUTH_COOKIE;
		$secure = true;
	}else {
		$auth_cookie_name = AUTH_COOKIE;
		$secure = false;
	}
	
	setcookie($auth_cookie_name, $auth_cookie, $expire, SITECOOKIEPATH . $loginizer['admin_slug'], COOKIE_DOMAIN, $secure, true);
	
}

// Verifies if the token is valid and creates the user session
function loginizer_epl_verify(){
	
	global $loginizer;
	
	if(empty($_GET['uid']) || empty($_GET['lepltoken'])){
		return false;
	}
	
	$uid = (int) sanitize_key($_GET['uid']);
	$token = sanitize_key($_GET['lepltoken']);
	$action = 'loginizer_epl_'.$uid;
	
	$hash = get_user_meta($uid, $action, true);
	$expires = get_user_meta($uid, $action.'_expires', true);
	
	include_once(ABSPATH.'/'.$loginizer['wp-includes'].'/class-phpass.php');
	$wp_hasher = new PasswordHash(8, TRUE);
	$time = time();

	if(!$wp_hasher->CheckPassword($expires.$token, $hash) || $expires < $time){
		$token_error_msg = __('The token is invalid or has expired. Please request a new email', 'loginizer');
		// Throw an error
		return new WP_Error('token_invalid', $token_error_msg, 'loginizer_epl');
		
	}else{
		
		// Login the User
		wp_set_auth_cookie($uid);
		
		// Delete the meta
		delete_user_meta($uid, $action);
		delete_user_meta($uid, $action.'_expires');
		
		// Redirect and exit
		wp_redirect(admin_url());
		exit;
		
	}
	
	return false;
		
}

// Hides the password field for the password less email login
function loginizer_epl_hide_pass() { 
	?>
	<style type="text/css">
	label[for="user_pass"], .user-pass-wrap {
	display:none;
	}
	</style>
	<?php 
}

// Handles the error of the password not being there
function loginizer_epl_error_handler($errors, $redirect_to){
	
	//echo 'loginizer_epl_error_handler :';print_r($errors->errors);echo '<br>';
	
	// Remove the empty password error
	if(is_wp_error($errors)){
		$errors->remove('empty_password');
	}
	
	return $errors;
	
}

// Handles the verification of the username or email
function loginizer_epl_wp_authenticate($user, $username, $password){
	
	global $loginizer;
	
	//echo 'loginizer_epl_wp_authenticate : '; print_r($user).'<br>';
	
	if(is_wp_error($user)){
		
		// Ignore certain codes
		$ignore_codes = array('empty_username', 'empty_password');

		if(is_wp_error($user) && !in_array($user->get_error_code(), $ignore_codes)) {
			return $user;
		}
		
	}
	
	// Is it a login attempt
	$verified = loginizer_epl_verify();
	if(is_wp_error($verified)){
		return $verified;
	}
	
	if(empty($username) && empty($_POST)){
		return $user;
	}
	
	$email = NULL;
	
	// Is it an email address ?
	if(is_email($username) && email_exists($username)){
		$email = $username;
	}
	
	// Maybe its a username
	if(!is_email($username) && username_exists($username)){
		$user = get_user_by('login', $username);
		if($user){
			$email = $user->data->user_email;
		}
	}
	
	// Did you get any valid email ?
	if(empty($email)){
		$account_error_msg = __('The username or email you provided does not exist !', 'loginizer');
		return new WP_Error('invalid_account', $account_error_msg, 'loginizer_epl');
	}
	
	// Send the email
	$site_name = get_bloginfo('name');
	$login_url = loginizer_epl_login_url($email);
	
	$vars = array('email' => $email,
				'site_name' => $site_name,
				'site_url' => get_site_url(),
				'login_url' => $login_url);
				
	$subject = lz_lang_vars_name($loginizer['passwordless_sub'], $vars);
	$message = lz_lang_vars_name($loginizer['passwordless_msg'], $vars);

	//echo $subject.'<br><br>';echo $message;
	
	$headers = array();
	
	// Do we need to send the email as HTML ? 
	if(!empty($loginizer['passwordless_html'])){
		$headers[] = 'Content-Type: text/html; charset=UTF-8';
		
		if(!empty($loginizer['passwordless_msg_is_custom'])){
			$message = html_entity_decode($message);
		}else{
			$message = preg_replace("/\<br\s*\/\>/i", "<br/>", $message);
			$message = preg_replace('/(?<!<br\/>)\n/i', "<br/>\n", $message);
		}
	}

	$sent = wp_mail($email, $subject, $message, $headers);
	
	//echo $login_url;
	
	if(empty($sent)){
		$email_not_sent = __('There was a problem sending your email. Please try again or contact an admin.', 'loginizer');
		return new WP_Error('email_not_sent', $email_not_sent, 'loginizer_epl');
	}else{
		$loginizer['no_loginizer_logs'] = 1;
		$email_sent_msg = __('An email has been sent with the Login URL', 'loginizer');
		return new WP_Error('email_sent', $email_sent_msg, 'message');
	}
	
}


// Generate the URL for the 
function loginizer_epl_login_url($email){
	
	// Get the User ID
	$user = get_user_by('email', $email);
	$token = loginizer_epl_token($user->ID);
	
	// The current URL
	$url = wp_login_url().'?uid='.$user->ID.'&lepltoken='.$token;

	return $url;
	
}

// Creates a one time token
function loginizer_epl_token($uid = 0){
	
	global $loginizer;
	
	// Variables
	$time = time();
	$expires = ($time + 600);
	$action =  'loginizer_epl_'.$uid;

	include_once( ABSPATH . '/'.$loginizer['wp-includes'].'/class-phpass.php');
	$wp_hasher = new PasswordHash(8, TRUE);

	// Create the token with a random salt and the time
	$token  = wp_hash(wp_generate_password(20, false).$action.$time);

	// Create a hash of the token
	$stored_hash = $wp_hasher->HashPassword($expires.$token);
	
	// Store the hash and when it expires
	update_user_meta($uid, $action, $stored_hash);
	update_user_meta($uid, $action.'_expires', $expires);
	
	return $token;
	
}

// Send a 404
function loginizer_set_404(){
	
	global $wp_query;
	
	status_header(404);	
	$wp_query->set_404();
	
	if( (($template = get_404_template()) || ($template = get_index_template()))
		&& ($template = apply_filters('template_include', $template))
	){
		include($template);
	}
	
	die();
	
}

// Find the page being accessed
function loginizer_cur_page(){
	
	$blog_url = trailingslashit(get_bloginfo('url'));
	
	// Build the Current URL
	$url = (is_ssl() ? 'https://' : 'http://').$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
	
	if(is_ssl() && preg_match('/^http\:/is', $blog_url)){
		$blog_url = substr_replace($blog_url, 's', 4, 0);
	}
	
	// The relative URL to the Blog URL
	$req = str_replace($blog_url, '', $url);
	$req = str_replace('index.php/', '', $req);
	
	// We dont need the args
	$parts = explode('?', $req, 2);
	$relative = basename($parts[0]);

	// Remove trailing slash
	$relative = rtrim($relative, '/');
	$tmp = explode('/', $relative, 2);
	$page = end($tmp);
	
	//echo 'Page : '.$page.'<br>';
	
	return $page;
	
}

// Converts the URL as per the one stored
function loginizer_rl_convert_url($link){
	
	global $loginizer;
	
	// If the login page is to be kept secret
	if(!empty($loginizer['rename_login_secret']) && loginizer_cur_page() !== $loginizer['login_slug'] && !is_user_logged_in()){
		return $link;
	}
	
	$result = $link;
	
	if(!empty($loginizer['login_slug']) && strpos($link, $loginizer['login_basename']) !== false){
		$result = str_replace($loginizer['login_basename'], $loginizer['login_slug'], $link);
	}
	
	if(!empty($loginizer['xmlrpc_slug']) && strpos($link, 'xmlrpc.php') !== false){
		$result = str_replace($loginizer['login_basename'], $loginizer['login_slug'], $link);
	}
	
	return $result;
}

function loginizer_rl_site_url($link){
	$result = loginizer_rl_convert_url($link);
	return $result;
}

function loginizer_rl_wp_redirect($link){
	$result = loginizer_rl_convert_url($link);
	return $result;
}

function loginizer_rl_register($link){
	$result = loginizer_rl_convert_url($link);
	return $result;
}
	
// Shows the Login correctly
function loginizer_rl_wp_loaded(){
	
	global $loginizer;
	
	$page = loginizer_cur_page();

	// Is it wp-login.php ?
	if ($page === $loginizer['login_basename']) {
		loginizer_set_404();
	}

	// Is it our SLUG ? If not then return
	if($page !== rtrim($loginizer['login_slug'], '/')){
		return false;
	}

	// We dont want a WP plugin caching this page
	@define('NO_CACHE', true);
	@define('WTC_IN_MINIFY', true);
	@define('WP_CACHE', false);

	// Prevent errors from defining constants again
	error_reporting(E_ERROR | E_CORE_ERROR | E_COMPILE_ERROR);

	include ABSPATH.'/'.$loginizer['login_basename'];
	
	exit();
	
}
	
// Renames the XML-RPC functionality
function loginizer_xml_rename_wp_loaded(){
	
	global $loginizer;
	
	$page = loginizer_cur_page();
	
	// Is it xmlrpc.php ?
	if ($page === 'xmlrpc.php') {
		loginizer_set_404();
	}

	// Is it our SLUG ? If not then return
	if($page !== $loginizer['xmlrpc_slug']){
		return false;
	}

	// We dont want a WP plugin caching this page
	@define('NO_CACHE', true);
	@define('WTC_IN_MINIFY', true);
	@define('WP_CACHE', false);

	// Prevent errors from defining constants again
	error_reporting(E_ERROR | E_CORE_ERROR | E_COMPILE_ERROR);

	include ABSPATH.'/xmlrpc.php';
	
	exit();
	
}
	
// Disables the XML-RPC functionality
function loginizer_xmlrpc_null(){
	return null;
}

// Disables the XML-RPC functionality
function loginizer_xmlrpc_disable(){
	
	global $loginizer;
	
	$page = loginizer_cur_page();
	
	// Is it xmlrpc.php ?
	if ($page === 'xmlrpc.php'){	
		echo 'XML-RPC is disabled';
		exit();
	}
	
}
	
// Disables the XML-RPC functionality
function loginizer_xmlrpc_remove_pingback_url($output, $show) {

	if($show == 'pingback_url'){
		$output = '';
	}

	return $output;
	
}

// Disable Pingbacks
function loginizer_pingbacks_disable($methods) {

	if(isset($methods['pingback.ping'])){
		unset($methods['pingback.ping']);
	}

	if(isset($methods['pingback.extensions.getPingbacks'])){
		unset($methods['pingback.extensions.getPingbacks']);
	}

	return $methods;

}

//========================
// Captcha Codes
//========================

// Adjusts the login form
function loginizer_cap_login_form(){
	?>
	<style type="text/css">
	#login {
	width: 350px !important;
	padding: 4% 0 0 !important;
	}
	</style>
	<?php
}

// Verify the login captcha is valid ?
function loginizer_cap_login_verify($user){
	
	if(!loginizer_cap_verify()){
		$captcha_fail_msg = __('The CAPTCHA verification failed. Please try again.', 'loginizer');
		return new WP_Error('loginizer_cap_login_error', $captcha_fail_msg, 'loginizer_cap');
	}
	
	return $user;

}

// Verify the lostpass captcha is valid ?
function loginizer_cap_lostpass_verify($res, $uid){

	if(!loginizer_cap_verify()){
		$captcha_fail_msg = __('The CAPTCHA verification failed. Please try again.', 'loginizer');
		return new WP_Error('loginizer_cap_lostpass_error', $captcha_fail_msg, 'loginizer_cap');
	}
	
	return $res;
	
}

// Verify the resetpass captcha is valid ?
function loginizer_cap_resetpass_verify($errors, $user){
	
	if(!loginizer_cap_verify()){
		$captcha_fail_msg = __('The CAPTCHA verification failed. Please try again.', 'loginizer');
		$errors->add('loginizer_resetpass_cap_error', $captcha_fail_msg, 'loginizer_cap');
	}
	
}

// Verify the register captcha is valid ?
function loginizer_cap_register_verify($errors, $username, $email){
	
	if(!loginizer_cap_verify()){
		$captcha_fail_msg = __('The CAPTCHA verification failed. Please try again.', 'loginizer');
		$errors->add('loginizer_cap_register_error', $captcha_fail_msg, 'loginizer_cap');
	}
	
	return $errors;
	
}

// Verify the register captcha is valid ?
function loginizer_cap_comment_verify($comment){
	
	if(!loginizer_cap_verify()){
		wp_die('The CAPTCHA verification failed. Please try again.', 200);
	}
	
	return $comment;
	
}

// Verify WooCommerce Checkout Orders
function loginizer_wc_checkout_verify(){
	
	global $loginizer;
	
	// Is the registration function verifying it ?
	if(!is_user_logged_in() 
		&& get_option('woocommerce_enable_signup_and_login_from_checkout', 'yes') == 'yes'
		&& !empty($loginizer['captcha_register'])){
			
		// So, no need of any more verification
	
	// Lets verify
	}elseif(!loginizer_cap_verify()){
		$captcha_fail_msg = __('The CAPTCHA verification failed. Please try again.', 'loginizer');
		wc_add_notice($captcha_fail_msg, 'error');
	}
}

// Reset password form passes $user, hence we need to manually write echo
function loginizer_cap_reset_form($user = false){
	loginizer_cap_form_login(false);
}

// For comment form pass false to echo the form
function loginizer_cap_comment_form($post_id = 0){
	echo '<br />';loginizer_cap_form_social(false);
}

// Converts numbers to words
function loginizer_cap_num_to_words( $number ) {
	$words = array(
		1	 => __( 'one', 'loginizer' ),
		2	 => __( 'two', 'loginizer' ),
		3	 => __( 'three', 'loginizer' ),
		4	 => __( 'four', 'loginizer' ),
		5	 => __( 'five', 'loginizer' ),
		6	 => __( 'six', 'loginizer' ),
		7	 => __( 'seven', 'loginizer' ),
		8	 => __( 'eight', 'loginizer' ),
		9	 => __( 'nine', 'loginizer' ),
		10	 => __( 'ten', 'loginizer' ),
		11	 => __( 'eleven', 'loginizer' ),
		12	 => __( 'twelve', 'loginizer' ),
		13	 => __( 'thirteen', 'loginizer' ),
		14	 => __( 'fourteen', 'loginizer' ),
		15	 => __( 'fifteen', 'loginizer' ),
		16	 => __( 'sixteen', 'loginizer' ),
		17	 => __( 'seventeen', 'loginizer' ),
		18	 => __( 'eighteen', 'loginizer' ),
		19	 => __( 'nineteen', 'loginizer' ),
		20	 => __( 'twenty', 'loginizer' ),
		30	 => __( 'thirty', 'loginizer' ),
		40	 => __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __( 'forty', 'loginizer' ),
		m> __(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     