<?php
namespace Redaxscript;

use function array_key_exists;
use function array_merge;
use function is_array;

/**
 * children class to store the registry
 *
 * @since 2.1.0
 *
 * @package Redaxscript
 * @category Registry
 * @author Gary Aylward
 */

class Registry extends Singleton
{
	/**
	 * array of the registry
	 *
	 * @var array
	 */

	protected static array $_registryArray = [];

	/**
	 * init the class
	 *
	 * @since 2.1.0
	 *
	 * @param array $registryArray array of the registry
	 */

	public function init(array $registryArray = []) : void
	{
		self::$_registryArray = array_merge(self::$_registryArray, $registryArray);
	}

	/**
	 * get the value from registry
	 *
	 * @since 3.0.0
	 *
	 * @param string $key key of the item
	 *
	 * @return mixed
	 */

	public function get(string $key) : mixed
	{
		if (is_array(self::$_registryArray) && array_key_exists($key, self::$_registryArray))
		{
			return self::$_registryArray[$key];
		}
		return null;
	}

	/**
	 * get the array from registry
	 *
	 * @since 4.0.0
	 *
	 * @return array
	 */

	public function getArray() : array
	{
		return self::$_registryArray;
	}

	/**
	 * set the value to registry
	 *
	 * @since 2.1.0
	 *
	 * @param string $key key of the item
	 * @param mixed $value value of the item
	 */

	public function set(string $key, mixed $value = null) : void
	{
		self::$_registryArray[$key] = $value;
	}
}
