<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace App;

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
class Blog_Admin extends \SCHLIX\cmsAdmin_ManyToMany {

    /**
     *
     * @var Blog 
     */
    protected $app;
    //_________________________________________________________________________//    
    public function __construct() {
        $datatype = 'basicnestedcategory';
        $methods = array('standard_main_app' => 'Main Application Page',
          'standard_browse' => 'View a specific item/category',
          'rss' => 'View RSS 2.0'
        );

        parent::__construct($datatype, $methods);
        $this->setItemFieldNamesForAjaxListing('cid', 'id', 'title', 'virtual_filename', 'date_available', 'date_created', 'date_modified', 'sort_order', 'pageview', 'status', 'featured','summary_intro_image');
        $this->setCategoryFieldNamesForAjaxListing('cid', 'parent_id', 'title', 'virtual_filename', 'date_available', 'date_created', 'date_modified', 'sort_order', 'status');
    }

    
    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function xmodifyItemResponseSchemaFields(array $response_schema) {
        $response_schema = parent::modifyItemResponseSchemaFields($response_schema);

        $response_schema[] = array('key' => 'file_exists', 'parser' => 'string');
        $response_schema[] = array('key' => 'url_image_small', 'parser' => 'string');

        return $response_schema;
    }
    
    public function modifyAjaxSearchObjectsResult($keyword, $result_array)
    {
        
        return $this->modifyAjaxGetItemsByCategoryIDResult($keyword, $result_array);

    }
    
    public function modifyAjaxGetItemsByCategoryIDResult($id, $result_array)
    {
        $totalcount = ___c($result_array);
        
        for ($i = 0; $i < $totalcount; $i++) {
            $image_filename = !empty($result_array[$i]['summary_intro_image']) ? $result_array[$i]['summary_intro_image'] : '';
            if ($image_filename)
            {
                if (str_starts_with($image_filename, 'https://') || str_starts_with($image_filename, 'http://')  )
                {
                    $result_array[$i]['file_exists'] = true;                
                } else 
                {
                    $result_array[$i]['file_exists'] = file_exists( $this->app->getDataFileFullPath('image_small', $image_filename));
                }

                $result_array[$i]['url_image_small'] =  $this->app->getBlogImage('image_small', $image_filename);
                $result_array[$i]['url_image_medium'] = $this->app->getBlogImage('image_medium', $image_filename);
                $result_array[$i]['url_image_large'] =  $this->app->getBlogImage('image_large', $image_filename);
            }
        }
        
        return $result_array;
    }
    
    /**
     * Before save category
     * @param array $datavalues
     */
    public function onModifyDataBeforeSaveCategory($datavalues) {
        
        global $CurrentUser;
        

        $external_images_save_path = '/media/images/clippings/';        
        $datavalues = parent::onModifyDataBeforeSaveCategory($datavalues);
        $current_admin_id = $CurrentUser->getCurrentUserID();

        $field_admin_id = ($datavalues[$this->app->getFieldCategoryID()]) ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename']);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'cat' . $datavalues['cid'];
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInCategoryTableUnderParentCategory('virtual_filename', $datavalues['virtual_filename'], $datavalues[$this->field_category_id], $datavalues[$this->field_category_parent_id]);
        /* NO LONGER NEEDED AS OF 2.2.0 if ($datavalues['permission_read_everyone'])
            $datavalues['permission_read'] = 'everyone';
        $datavalues['permission_read'] = serialize($datavalues['permission_read']);
        $datavalues['permission_write'] = serialize($datavalues['permission_write']); */
        $datavalues['options'] = serialize($datavalues['options']);
        $datavalues['summary'] = convert_pasted_png_images_from_html_text($datavalues['summary'],  CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        $datavalues['description'] = convert_pasted_png_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        if ($this->app->getConfig('bool_convert_external_images')) {
            $datavalues['summary'] = move_static_external_images_from_html_text($datavalues['summary'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
            $datavalues['description'] = move_static_external_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        }
        return $datavalues;        
    }  
            
    /**
     * Internal helper function that you can override to display the 
     * individual category in the item editor window     
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param array $item
     * @param array $data
     * @return string
     */
    public function viewCategoryTreeList_Item($item, $data)
    {
        global $SystemDB;
        
        $the_id = (int) $item['id'];
        $the_cid = (int) $data['cid'];
        
        $catjoins = $SystemDB->getQueryResultSingleRow("SELECT * FROM {$this->table_categories_items} WHERE id = {$the_id} AND cid = {$the_cid}");
        
        $cid = (int) $data[$this->field_category_id];
        
        $chk_has_category = $this->app->isItemInCategoryID($item[$this->field_id], $cid);
        if ($item[$this->app->getFieldID()] == 'new')
        {
            $browse_cat_id = $this->getCurrentCategoryIDFromCookie();
            if ($browse_cat_id > 0 && $cid == $browse_cat_id)
                $chk_has_category = true;
        }
        $chk_has_primary_category = $catjoins['is_primary'];
        if ( ($item['id'] == 'new') && $chk_has_category)
            $chk_has_primary_category = true;
        //$input_checkbox_category_ids = \INPUT::CHECKBOX('__category_ids[]',$cid , $chk_has_category, array('class' => 'item-category-checkbox', 'data-required-one'=>'required','id' => '__category_id_'.$cid));
        $input_radiobox_primary_cid = \INPUT::RADIO('primary_cid', $cid, $chk_has_primary_category, array('class'=>'schlix-primary-category-radiobox','id' => '__radio_category_id_'.$cid));
        
        $text = ___h($data['title']); 
        //$leaf =   \__HTML::SPAN_start(array('class'=>'checkbox checkbox-info')).$input_checkbox_category_ids.\__HTML::LABEL_FOR($text, '__category_id_'.$cid).\__HTML::SPAN_end();
        // TODO: clean up
        $leaf = '<schlix-cms-document-status id="__category_id_'.$cid.'" data-checkbox-class="chk_category_assoc" data-input-name="__category_ids[]" data-value="'.$chk_has_category.'" data-input-value="'.$cid.'"
                                                            data-icon-yes="fas fa-folder-open fa-2x" data-icon-no="far fa-folder fa-2x" data-color-yes="orange" data-color-no="gray" 
                                                            data-text-yes="" data-text-no=""></schlix-cms-document-status>';
        
        $leaf.= \__HTML::LABEL($text.'&nbsp;&nbsp;',$input_radiobox_primary_cid);
        //$category_txt.= '&nbsp;&nbsp;'.$input_radiobox_primary_cid;

        return $leaf;
    }
            
    
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        global $CurrentUser;
        $external_images_save_path = '/media/images/clippings/';
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        
        $del_summary_img = isset($datavalues['delete_summary_intro_image']) ? $datavalues['delete_summary_intro_image'] : 0;
        $del_description_img = isset($datavalues['delete_description_intro_image'] ) ? $datavalues['delete_description_intro_image']  : 0;
        if ( (int) $del_summary_img == 1)
        {
            $datavalues['summary_intro_image'] = '';
        }
        if ( (int) $del_description_img == 1)
        {
            $datavalues['description_intro_image'] = '';
        }
        
        $current_admin_id = $CurrentUser->getCurrentUserID();
        $field_admin_id = ($datavalues['id'] == 'new') ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename'], true);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'item' . $datavalues[$this->field_id];
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInItemTableUnderCategory('virtual_filename',  $datavalues['virtual_filename'],$datavalues[$this->field_id], $datavalues[$this->field_item_category_id] );
/* NO LONGER NEEDED AS OF 2.2.0 if ($datavalues['permission_read_everyone'])        
        if ($datavalues['permission_read_everyone'])
            $datavalues['permission_read'] = 'everyone';
        $datavalues['permission_read'] = serialize($datavalues['permission_read']);
        $datavalues['permission_write'] = serialize($datavalues['permission_write']); */
        $datavalues['options'] = serialize($datavalues['options']);
        $datavalues['featured'] = isset($datavalues['featured']) ? (int) $datavalues['featured'] : 0;
        $datavalues['summary'] = convert_pasted_png_images_from_html_text($datavalues['summary'],  CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        $datavalues['description'] = convert_pasted_png_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        if ($this->app->getConfig('bool_convert_external_images')) {
            $datavalues['summary'] = move_static_external_images_from_html_text($datavalues['summary'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
            $datavalues['description'] = move_static_external_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        }

        
        return $datavalues;
    }
    
    /**
     * Delete images in data directories
     * @param string $s
     */
    private function deleteImagesInDataDirectories($s)
    {
        if (str_starts_with($s, 'https://') || str_starts_with($s, 'http://') || str_starts_with($s, '/') || str_starts_with($s, '.'))
            return;
        $datadirs = $this->app->getDataDirectories();
        foreach ($datadirs as $location => $path)
        {
            $img = $this->app->getDataFileFullPath($location, $s);
            if (file_exists($img))
                @unlink($img);                
            
        }
    }
    //_________________________________________________________________________//    
    public function ajaxDeleteObjects($mixed_items_to_delete) {
        global $SystemDB;
        $mixed_items_array = explode(',', $mixed_items_to_delete); // e.g: i4,i14
        // Process sub-folders first
        foreach ($mixed_items_array as $mixed_item) {
            $item_id = substr($mixed_item, 1);
            $items_to_delete[] = $item_id;
        }
        $items_to_delete_str = implode(",", $items_to_delete);
        if ($items_to_delete_str) {
            $sql = "SELECT * from {$this->table_items} WHERE {$this->field_id} in ({$items_to_delete_str})";
            $result_array = $SystemDB->getQueryResultArray($sql);
            foreach ($result_array as $item) {
                $this->deleteImagesInDataDirectories($item['summary_intro_image']);
                $this->deleteImagesInDataDirectories($item['description_intro_image']);
            }
            $items_to_delete_str = implode(",", $items_to_delete);
        }
        return parent::ajaxDeleteObjects($mixed_items_to_delete);
        //	echo ajaxReply(200,'Delete OK');
    }

    
}

