<?php
/**
 * Core: Application Manager - Admin class
 * 
 * Core - Application Manager
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
 if (!defined('SCHLIX_VERSION')) die('No Access'); 
?>
<?php 

    $sanitized_ext_name = strtolower(fget_alphanumeric('name')); 
    $is_post_back = is_postback();
    
    $ext_exists = $this->extensionExists($sanitized_ext_name);
    if ($ext_exists)
    {
        $url_return = $this->createFriendlyAdminURL('');
        $is_from_extgallery = $this->isInstalledFromExtensionGallery($sanitized_ext_name);
    }
    $ext_icon = $this->getIconURL($sanitized_ext_name);
    $app_icon = \App\Admin::getApplicationIcon($sanitized_ext_name);
    
?>
<!-- end sidebar -->
<x-ui:schlix-item-editor data-schlix-controller="SCHLIX.CMS.Core_ApplicationManagerAdminController" data-main-app-description="<?= sprintf(___('Uninstall %s'), $sanitized_ext_name ) ?>">    

    <?php if ($is_from_extgallery): ?>
    <x-ui:alert type="error">
        <?= ___('This extension must be uninstalled from the Extension Gallery') ?>
    </x-ui:alert>
    <?php elseif ($ext_exists): ?>
        <x-ui:row>
            <?php if ($app_icon): ?>
            <x-ui:column lg="1" md="2" sm="2" xs="3">
                
                <div class="float-right pull-right content">
                <img src="<?= $app_icon ?>" class="img-responsive" />
                </div>
            </x-ui:column>
            <?php endif ?>
            <x-ui:column md="6" sm="6" xs="9" >
                <div class="content">
                <div class="schlix-ajax-output"></div>
                    
                <x-ui:form-simple-ajax name="uninstall_form"  method="post" data-action="<?= $this->createFriendlyAdminURL("action=confirmuninstall&name={$sanitized_ext_name}"); ?>" enctype="multipart/form-data" >
                    <x-ui:csrf />
                    <x-ui:hidden name="name" value="<?= ___h($sanitized_ext_name) ?>" />
                    <x-ui:checkbox id="sure_database" name="database"  value="1" label="<?= ___('Do you want to delete all the database tables? You will not be able to restore the existing data later if you change your mind.') ?>" />
                    <x-ui:textbox type="password" name="password" id="password" required="required" label="<?= ___('Please enter your password') ?>" fonticon="fas fa-lock" />
                    <x-ui:button button-type="ok"  type="submit" name="submit" data-form-submit="1" id="btn-uninstall" value="Submit" label="<?= ___('OK') ?>" fonticon="fas fa-check" />
                    <x-ui:link-button button-type="danger"  href="<?= $href ?>" id="cancel_uninstall_button" data-schlix-command="cancel-save-item" name="btn_cancel"  type="submit" fonticon="fas fa-times" label="<?= ___('Cancel'); ?>" />
                </x-ui:form-simple-ajax>
                </div>
            </x-ui:column>
        </x-ui:row>
    <?php else: ?>
    <x-ui:alert type="error">
        <?= ___('Invalid application name') ?>
    </x-ui:alert>
    <?php endif ?>
</x-ui:schlix-item-editor>

