<?php
namespace App;
/**
 * Core: Block Manager - Main Class
 * 
 * Core - Block Manager
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_BlockManager extends \SCHLIX\cmsApplication_CategorizedList {

    private $block_output = [];
    
    protected $block_visibilities = [];

    public function __construct() {
        parent::__construct( ___('Block Manager'), 'gk_block_items', 'gk_block_categories');
        $this->disable_frontend_runtime = true;       
    }

    //_______________________________________________________________________________________________________________//
    public function getCurrentMenuId() {
        return \App\Core_Menu::getCurrentMenuID();
    }

    //_______________________________________________________________________________________________________________//

    public function getBlockCountInCategory($category_name) {

        if (array_key_exists($category_name, $this->block_output)) {
            return ___c($this->block_output[$category_name]);
        } else
            return false;
    }

    //_______________________________________________________________________________________________________________//
    public function getBlocksByCategoryName($category_name) {
        $result = '';
        if (array_key_exists($category_name, $this->block_output) && $this->block_output[$category_name] != null) {
            foreach ($this->block_output[$category_name] as $block_item) {
                $result.=$block_item;
            }
        } 
        return $result;
    }

    //_______________________________________________________________________________________________________________//
    public function displayBlocksByCategoryName($category_name) {
        echo $this->getBlocksByCategoryName($category_name);
    }

    //_______________________________________________________________________________________________________________//
    /**
     * 
     * @global \cmsDatabase $SystemDB
     * @global App\Users $CurrentUser
     * @param string $block_name
     * @return boolean
     */
    public function getSingleBlock($block_name) {
        global $SystemDB, $CurrentUser;

        $gk_block_config = new \SCHLIX\cmsConfigRegistry('gk_block_config');

        $s = sanitize_string($block_name);
        $sql = "SELECT * from {$this->table_items} WHERE (title = $s) AND status > 0";
        $block = $SystemDB->getCachedQueryResultSingleRow($sql);
        if ($block && $CurrentUser->hasReadPermission($block['permission_read'])) {
            $instance_name = $block['title'];
            $instance_config = $gk_block_config->get($instance_name, '', true);
            //$original_block='Block';
            $original_block = '\\Block\\' . $block['original_block'];

// Feb 27, 2017 - remove as it was causing issue with insertblockbyposition
//            if (ob_get_length() > 0)
//                ob_end_clean();
            ob_start();

            $the_block = new $original_block($instance_name, $instance_config);
            $the_block->viewCachedRun();

            $block_output = ob_get_contents();
            ob_end_clean();
            return $block_output;
        } else {
            return FALSE;
        }
    }

    //_______________________________________________________________________________________________________________//
    public function displaySingleBlock($block_name) {
        $output = $this->getSingleBlock($block_name);
        echo ($output !== FALSE) ? $output : ''; // "Block {$block_name} cannot be found";
        /* global $SystemDB, $CurrentUser;

          $gk_block_config = new \SCHLIX\cmsConfigRegistry('gk_block_config');

          $s = sanitizeString($block_name);
          $sql =  "SELECT * from {$this->table_items} WHERE (title = $s) AND status > 0";
          $block  = $SystemDB->get_query_singleresult($sql,true);
          if ($block && $CurrentUser->hasReadPermission($block['permission_read']))
          {
          $instance_name = $block['title'];
          $instance_config = $gk_block_config->get($instance_name,'',true);
          //$original_block='Block';
          $original_block = '\\Block\\'.$block['original_block'];
          $the_block = new  $original_block($instance_name, $instance_config);
          $the_block->Run();
          } else
          {
          echo "Block {$block_name} cannot be found";
          } */
    }
    
    //_______________________________________________________________________________________________________________//
    public function displayBlockByCategoryNameRerun($title) {
        global $SystemDB;

        $title = sanitize_string($title);
        $sql = "SELECT {$this->field_category_id}, title FROM {$this->table_categories} WHERE status > 0 AND title={$title} ";
        $category = $SystemDB->getQueryResultSingleRow($sql);
        if ($category) {
            $blocks = $this->getItemsByCategoryID($category[$this->field_category_id], "{$this->field_id},title", "status > 0", 0, 0, 'sort_order', 'ASC', true);


            foreach ($blocks as $block) {
                $this->displaySingleBlock($block['title']);
            }
        }
    }
    //_______________________________________________________________________________________________________________//
    public function viewMainPage() {
        return false;
    }

    /**
     * Returns category ID# if a block with this name exists. Returns 0 otherwise
     * @global \cmsDatabase $SystemDB
     * @param string $title
     * @return int
     */
    public function getExistingBlockCategoryIDWithName($title) {
        global $SystemDB;

        $title = sanitize_string($title);
        $sql = "SELECT {$this->field_category_id} FROM {$this->table_categories} WHERE title={$title} ";

        $category = $SystemDB->getQueryResultSingleRow($sql);
        return ($category !== NULL) ? $category[$this->field_category_id] : NULL;
    }

    
    /**
     * Returns an array of error list if there's an error during save category
     * @param array $datavalues
     * @return array
     */
    public function getValidationErrorListBeforeSaveCategory($datavalues) {
        $error_list = parent::getValidationErrorListBeforeSaveCategory($datavalues);
        $existing_id = $this->getExistingBlockCategoryIDWithName($datavalues['title']);
        if ($existing_id > 0)
        {
            if ( ($datavalues[$this->field_category_id] == 'new') )
            {
                $error_list[] = sprintf(___('Cannot create a new category with the name %s since it already exists '),___h($datavalues['title'])); 
            } else
            {
                $this_block_category_id = (int) $datavalues[$this->field_category_id];
                if ($this_block_category_id != $existing_id)
                {
                    $error_list[] = sprintf(___('Cannot change block category name to [%s] as there is already an existing block category with the same name'),___h($datavalues['title'])); 
                }
            }
        }
        
        return $error_list;
    }
    //_______________________________________________________________________________________________________________//
    /**
     * Override default modify category data before save
     * @param array $datavalues
     * @return array
     */
    public function modifyDataValuesBeforeSaveCategory($datavalues) {
        $datavalues = parent::modifyDataValuesBeforeSaveCategory($datavalues);        
        
        $datavalues['title'] = str_limit (convert_into_sef_friendly_title($datavalues['title']), 255);
        return $datavalues;
    }

    /**
     * Override default modify item data before save
     * @param array $datavalues
     */
    public function modifyDataValuesBeforeSaveItem($datavalues) {
        
        $datavalues = parent::modifyDataValuesBeforeSaveItem($datavalues);                
        $datavalues['title'] = convert_into_sef_friendly_title(fpost_string('title', 255));
        return $datavalues;
    }

    //_________________________________________________________________________//
    /**
     * Returns block association
     * @global \cmsDatabase $SystemDB
     * @param int $id
     * @param bool $use_cached_result
     * @return array
     */
    public function getBlockVisibility($id, $use_cached_result = false) {
        global $SystemDB;


        $sql = "SELECT menu_id FROM gk_block_menu_association WHERE {$this->field_id} = :id ";

        $visible_in_these_menus = $use_cached_result ? 
            $SystemDB->getCachedQueryResultArray($sql,['id'=>(int) $id]) : 
            $SystemDB->getQueryResultArray($sql,['id'=>(int) $id]);
        return $visible_in_these_menus;
    }

    /**
     * Cache block visibilities for current context
     * @global \SCHLIX\cmsDatabase $SystemDB
     */
    protected function getAllBlockVisibilities()
    {
        global $SystemDB;

        $sql = "SELECT id, display_in_menu FROM {$this->table_items} ORDER BY id ASC";
        $block_vis = $SystemDB->getQueryResultArray($sql);
        foreach ($block_vis as $block)
            $this->block_visibilities[$block['id']] = $block['display_in_menu'];
    }
    //_________________________________________________________________________//
    public function isBlockVisibleInThisMenuId($id, $menu_id) {
        global $SystemDB;

        $id = (int) $id;
        $menu_id = (int) $menu_id;

        $visible_in_every_page = true;
        
        $block_vis_config = $this->block_visibilities[$id];        
        
        if ($block_vis_config == 2)
            $visible_in_every_page = false;
        if (!$visible_in_every_page) {
            if ($menu_id == 0)
                return false;
            $sql = "SELECT menu_id FROM gk_block_menu_association WHERE {$this->field_id} = '{$id}' AND menu_id = '{$menu_id}'";
            $visible_in_these_menus = $SystemDB->getCachedQueryResultArray($sql);
            return (___c($visible_in_these_menus) > 0);
        } else
            return true;
    }

    //_______________________________________________________________________________________________________________//
    public function findDuplicateItems($data) {
        global $SystemDB;

        $current_id = $data[$this->field_id];
        $sql = "SELECT * FROM {$this->table_items} WHERE (title = '{$data['title']}')";

        if (intval($current_id) != 0)
            $sql.= " AND (id != '{$current_id}')";

        $result = $SystemDB->getQueryResultArray($sql);

        return $result;
    }

    //_______________________________________________________________________________________________________________//
    public function Run($command) {
        
        global $SystemDB, $CurrentUser;
        global $Macros;

        
        $this->getAllBlockVisibilities();
        $gk_block_config = new \SCHLIX\cmsConfigRegistry('gk_block_config');

        $sql = "SELECT {$this->field_category_id}, {$this->table_categories}.title AS block_category, {$this->table_items}.*  FROM {$this->table_categories} INNER JOIN {$this->table_items} "
        . "ON {$this->table_items}.category_id = {$this->field_category_id} WHERE ({$this->table_items}.status > 0) AND ({$this->table_categories}.status > 0) ORDER by  {$this->field_category_id}, {$this->table_items}.sort_order";
        $all_blocks = $SystemDB->getQueryResultArray($sql);
        $current_menu_id = $this->getCurrentMenuId();    
        
        $block_instance_name_array = array_column($all_blocks, 'title');
        $all_block_config = $gk_block_config->getMultipleSections($block_instance_name_array);        
        foreach ($all_blocks as $block) {
            if ($block['status'] > 0 && $CurrentUser->hasReadPermission($block['permission_read'])) { // don't wanna call displaysingleblock as it will increase call to the DB
                $original_block = '\Block\\' . $block['original_block'];                
                $instance_name = $block['title'];
                //$instance_config = $gk_block_config->get($instance_name, '', true);
                $instance_config = array_key_exists($instance_name, $all_block_config) ? $all_block_config[$instance_name] : null;
                //$original_block.='Block';
                
                if ($this->isBlockVisibleInThisMenuId($block['id'], $current_menu_id)) {
                    if (ob_get_length() > 0)
                        ob_end_clean();
                    ob_start();

                    if (class_exists($original_block))
                    {                        
                        $the_block = new $original_block($instance_name, $instance_config);
                        $the_block->viewCachedRun();
                    } else echo "Fatal error: unable to find the class for block {$instance_name}";
                    
                    $block_output = ob_get_contents();
                    ob_end_clean();
                    $extra_info = array('id' => $block['id'], 'title' => $block['title']);
                    $Macros->modifyData($block_output, $the_block,  'viewBlock', $extra_info);
                    $this->block_output[$block['block_category']][$instance_name] = $block_output;
                    
                }  else 
                {
                    //DEBUG echo "Block {$instance_name} is invisible";
                }
            }
        }
        //////////////
        
    } 
}
