<?php
namespace App;

/**
 * Core: LogViewer - Admin class
 * 
 * Core - LogViewer
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_LogViewer_Admin extends \SCHLIX\cmsAdmin_List {

    /**
     * Constructor
     */
    public function __construct()
    {
        // Data: Item
        parent::__construct( true, []);
        $this->search_field = 'description';
        $this->setItemFieldNamesForAjaxListing('id', 'request_uri', 'referrer', 'user_agent', 'ip_address', 'date_created', 'host_name', 'description','module','type');
    }
    
    private function getCachedBrowser($ua)
    {
        $browser_icons = ['Firefox' => 'fab fa-firefox', 'Chrome' => 'fab fa-chrome', 'Opera' => 'fab fa-opera', 'Safari' => 'fab fa-safari', 'MSIE' => 'fab fa-internet-explorer', 'Edge' => 'fab fa-internet-explorer'];
        $platform_icons = ['Windows' => 'fab fa-windows', 'Linux' => 'fab fa-linux', 'Macintosh' => 'fab fa-apple', 'Android' => 'fab fa-android', 'iPhone' => 'fas fa-mobile-alt'];
        
        $browser_icon = '';
        $k = 'browser_'.md5($ua);
        $existing_cache = \SCHLIX\cmsContextCache::get('logviewer',$k);
        if (!$existing_cache)
        {
            $br = get_user_browser_info ($ua);
            if (array_key_exists($br['browser'], $browser_icons))
                    $browser_icon = $browser_icons[$br['browser']];
            else $browser_icon = 'fas fa-window-maximize';
            
            if (array_key_exists($br['platform'], $platform_icons))
                    $os_icon = $platform_icons[$br['platform']];
            $os_fonticon = $os_icon ?  "<i class=\"{$os_icon}\"></i>" : '';
            if ($br['is_bot'])
                
            {
               $browser_string = "<i class=\"fas fa-robot\"></i>  {$br['platform']}"; 
            } else 
            {
                $browser_string = "<i class=\"{$browser_icon}\"></i>  {$br['browser']} {$br['browser_version']}";

                if (isset($br['os']))
                    $browser_string.= " on {$os_fonticon} {$br['os']} {$br['os_version']}";
                else if ($br['platform'])
                    $browser_string.= " on {$os_fonticon} {$br['platform']}";
            }
            \SCHLIX\cmsContextCache::set('logviewer',$k, $browser_string);
        }
        return $existing_cache;
        
    }
    
    protected function modifyResult($result)
    {
        $count = ___c($result);
        if ($count > 0)
        {
            for ($i = 0;$i < $count; $i++)
            {
                $img = \App\Core_ApplicationManager::getApplicationIcon($result[$i]['module']);
                if (!empty($img))
                $result[$i]['module']  = \__HTML::IMG ($img, ['class' => 'schlix-data-listview-image-icon', 'alt' => $result[$i]['module']]). ' '.$result[$i]['module'] ;
                $result[$i]['user_agent'] = $this->getCachedBrowser($result[$i]['user_agent']);
            }
        }
        return $result;
    }
    
    public function modifyAjaxGetAllItemsResult($result) {
        $result = parent::modifyAjaxGetAllItemsResult($result);
        $result = $this->modifyResult($result);
        return $result;
    }
    
    public function modifyAjaxSearchObjectsResult($keyword, $result) {
        $result = parent::modifyAjaxSearchObjectsResult($keyword, $result);
        $result = $this->modifyResult($result);
        return $result;
    }
}
 
