<?php
namespace App;
/**
 * Core: Macro Manager - Main Class
 * 
 * Core - Macro Manager
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_MacroManager extends \SCHLIX\cmsApplication_List {

    /**
     * Constructor
     * @global \SCHLIX\cmsDatabase $SystemDB
     */
    public function __construct() {
        parent::__construct('Macro Manager', 'gk_macro_items');
        $this->disable_frontend_runtime = true; // not enabled for public
    }
    
    protected function getAllMacros($caller_object)
    {
        $all_macros = NULL;
        if (is_a($caller_object,'\\SCHLIX\\cmsApplication_Basic'))
        {
            $app_name = $caller_object->getApplicationName();
            $str = serialize($app_name);
            $additional_criteria = " OR (display_in_apps = 2 AND enabled_apps LIKE '%{$str}%')";
        } else if (is_a($caller_object,'\\SCHLIX\\cmsBlock'))
        {
            $block_name = $caller_object->getBlockInstanceName();
            $str = serialize($block_name);
            $additional_criteria = " OR (display_in_blocks = 2 AND enabled_blocks LIKE '%{$str}%')";
        }
        $criteria = " `status`= 1 AND (display_in_apps = 1 {$additional_criteria}) ";
        $sha1_crit = sha1($criteria);
        $macro_cache = \SCHLIX\cmsContextCache::get('macro',$sha1_crit);
        if ($macro_cache)
        {
            $all_macros = $macro_cache;
        }
        else
        {
            $all_macros = $this->getAllItems('*', $criteria, 0, 0, 'sort_order', 'ASC', true);
            \SCHLIX\cmsContextCache::set('macro',$sha1_crit, $all_macros);
        }
        return $all_macros;
    }
    
    protected function getAllMacroConfig($all_macros)
    {
            $macro_config = new \SCHLIX\cmsConfigRegistry('gk_macro_config');
            $macro_name_array = array_column($all_macros, 'title');
            $all_macro_config = \SCHLIX\cmsContextCache::get('macro', 'all_config');
            if (!is_array($all_macro_config))
            {
                $all_macro_config = $macro_config->getMultipleSections($macro_name_array);
                \SCHLIX\cmsContextCache::set('macro', 'all_config', $all_macro_config);
            }
            return $all_macro_config;
    }
    /**
     * Modify output data
     * @param array $data
     * @param object $caller_object
     * @param string $function_name
     * @param array $extra_info
     * @return bool
     */
    public function modifyData(&$data, $caller_object, $function_name, $extra_info = [])
    {
        $all_macros = $this->getAllMacros($caller_object);
        if ($all_macros) {
            $all_macro_config = $this->getAllMacroConfig($all_macros);
            foreach ($all_macros as $macro) {
                $macro_title = $macro['title'];
                $instance_config = array_key_exists($macro_title, $all_macro_config) ? $all_macro_config[$macro_title] : null;
                $macro_name = 'Macro\\' . $macro_title;      
                $macro_instance = new $macro_name($instance_config);
                $result = $macro_instance->Run($data, $caller_object, $function_name, $extra_info);
                
            }
        }
        return $result;
    } 
    
    /**
     * Modify output data
     * @param array $data
     * @param object $caller_object
     * @param string $function_name
     * @param array $extra_info
     * @return bool
     */
    public function runBeforeFinalHTMLOutput(&$data)
    {
        $all_macros = $this->getAllMacros(null);
        if ($all_macros) {
            $all_macro_config = $this->getAllMacroConfig($all_macros);
            foreach ($all_macros as $macro) {
                $instance_config = $all_macro_config[$macro['title']];
                $macro_name = 'Macro\\' . $macro['title'];      
                $macro_instance = new $macro_name($instance_config);
                if (method_exists($macro_instance, 'runBeforeFinalHTMLOutput'))
                $result = $macro_instance->runBeforeFinalHTMLOutput($data);
                
            }
        }
        return $result;
    } 
    
    //_______________________________________________________________________________________________________________//
    /**
     * Disable view main page
     */
    public function viewMainPage() {
        return false;
    }

//_______________________________________________________________________________________________________________//
    public function findDuplicateItems($data) {
        global $SystemDB;

        $current_id = intval($data[$this->field_id]);
        $sql = "SELECT * from {$this->table_items} WHERE (title = '{$data['title']}')";

        if (intval($current_id) != 0)
            $sql.= " AND (id != '{$current_id}')";

        $result = $SystemDB->getQueryResultArray($sql);

        return $result;
    }

}