<?php
namespace App;
/**
 * Core: Media Manager - Main Class
 * 
 * Core - Media Manager
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_MediaManager extends \SCHLIX\cmsApplication_HierarchicalTree_List {


    /**
     *
     * @var wysiwygEditors
     */
    protected $default_editor_name;

    public function __construct() {

        parent::__construct('File Manager', 'gk_mediamanager_items', 'gk_mediamanager_categories');
    }

    //_______________________________________________________________________________________________________________//
    public function viewMainPage() {
        die('~L~');
        return false;
    }

    /**
     * Check if user allowed access to full list
     * @global \SCHLIX\cmsConfigRegistry $SystemConfig
     * @global \App\Users $CurrentUser
     * @return bool
     */
    public function CheckIfCurrentUserAllowedAccess() {
        global $SystemConfig, $CurrentUser;

        $array_groups_allowed_for_backend_access = $SystemConfig->get($this->app_name, 'array_groups_allowed_for_backend_access');
        return ($CurrentUser->hasPermission($array_groups_allowed_for_backend_access));
    }

    /**
     * Generate sitemap URLs for file list
     * @global type $SystemConfig
     * @return string
     */
    protected function generateSitemapURLs() {
        global $SystemConfig;

        $default_app_array = array('html', 'blog');
        $enabled_apps_array = $SystemConfig->get('mediamanager', 'array_enabled_apps');

        if (empty($enabled_apps_array))
            $enabled_apps_array = $default_app_array;
        $item_array = get_list_of_all_apps();
        if ($item_array) {
            foreach ($item_array as $appname) {
                if (in_array($appname, $enabled_apps_array)) {
                    $alias = get_application_alias($appname);

                    $temp_app_name = '\\App\\' . $appname;
                    $temp_app = new $temp_app_name;
                    if (!$temp_app->isFrontendRuntimeDisabled()) {

                        if (method_exists($temp_app, 'getAllItems') && $temp_app->itemColumnExists('virtual_filename')) {
                            $all_items = $temp_app->getAllItems('*', 'status > 0', 0, 0, 'id', 'ASC');
                            foreach ($all_items as $the_item) {
                                $link = $temp_app->createFriendlyURL("action=viewitem&id={$the_item['id']}");
                                $title = "Item {$the_item['id']}";
                                if ($the_item['title'])
                                    $title = "{$appname} - item - " . $the_item['title'];
                                $urls[] = array('title' => $title, 'link' => $link);
                            }
                        }
                        if (method_exists($temp_app, 'getAllCategories')) {
                            $all_cats = $temp_app->getAllCategories('*', 'status = 1', 0, 0, 'id', 'ASC');
                            if (method_exists($temp_app, 'getCategoryFieldName'))
                                $field_c = $temp_app->getCategoryFieldName();
                            else
                                $field_c = 'cid';
                            foreach ($all_cats as $the_cat) {
                                $cid = $the_cat["cid"];
                                $title = "Category {$the_cat['cid']}";
                                if ($the_cat['title'])
                                    $title = "{$appname} - category - " . $the_cat['title'];

                                $link = $temp_app->createFriendlyURL("action=viewcategory&cid={$cid}");
                                $urls[] = array('title' => $title, 'link' => $link);
                            }
                        }
                    }
                }
            }
        }
        return $urls;
    }

    //_______________________________________________________________________________________________________________//

    /**
     * View full file list - only for those who have access to the backend
     * @param bool $for_privileged_user
     * @global \App\Users $CurrentUser
     */
    public function viewFileList($for_privileged_user = false) {
        global $CurrentUser;

        if (!$this->checkPrivilege($for_privileged_user))            
            die(___('No Access'));                
        header('Content-type: text/javascript; charset=UTF-8');

        $array_links = $for_privileged_user ? $this->generateSitemapURLs() : [];

        $array_files = [];
        //echo 'var tinyMCELinkList = new Array(';
        //echo "[";
        $start_path = $for_privileged_user ? CURRENT_SUBSITE_PATH . "/media/downloads/" : $CurrentUser->getDataDirectoryFullPath('user_public_files');
        $items = \SCHLIX\cmsDirectoryFilter::getRecursiveDirectoryIterator($start_path, \SCHLIX\cmsDirectoryFilter::FILTER_FILE_ONLY, array('Thumbs.db', 'Thumb.db', '__MACOSX'));
        $total = $items ? ___c($items) : 0;
        $i = 0;
        if ($items)
        {
            foreach ($items as $item) {
                $file = remove_prefix_from_file_name($item->getPathName(), SCHLIX_SITE_PATH);
                $path_parts = pathinfo($file);
                $array_files[] = array('title' => ___('Direct Download') . ' - ' . ucwords($path_parts['filename']), 'value' => $file);

                $i++;
            }
        }


        $total = ___c($array_links);

        for ($i = 0; $i < $total; $i++) {
            $file = $array_links[$i];

            $file_title = ___h($file['title']);
            $file_link = $file['link'];
            $array_files[] = array('title' => $file_title, 'value' => $file_link);
        }
        echo json_encode($array_files);
    }

    protected function getImageListDescription($file) {
        $arr_path = explode('/', $file);
        $arr_path = array_splice($arr_path, 2);
        $count = ___c($arr_path);
        for ($i = 0; $i < $count; $i++) {
            if ($i == $count - 1) {
                $arr_path[$i] = substr($arr_path[$i], 0, strpos($arr_path[$i], '.'));
            }
            $arr_path[$i] = ucwords($arr_path[$i]);
        }
        return implode(' - ', $arr_path);
    }

    /**
     * Check access to links, images, and files
     * @global \App\Users $CurrentUser
     * @param bool $for_privileged_user
     * @return boolean
     */
    protected function checkPrivilege($for_privileged_user)
    {
        global $CurrentUser;
        if (!$for_privileged_user)
        {
            return $CurrentUser->getCurrentUserID()  > 0 ;
        }
        if ($for_privileged_user)
         {
            if (!$this->CheckIfCurrentUserAllowedAccess()) {
                die('Access not allowed');
                $CurrentUser->logout();
            }  else return true;
        }
        return false;
    }
    /**
     * View full image list 
     * @global \App\Users $CurrentUser
     * @param bool $for_privileged_user
     * @return bool
     */
    public function viewImageList($for_privileged_user = false) 
    {
        global $CurrentUser;

        if (!$this->checkPrivilege($for_privileged_user))            
            die(___('No Access'));        
        header('Content-type: text/javascript; charset=UTF-8');

        $start_path = $for_privileged_user ? CURRENT_SUBSITE_PATH . "/media/images/" : $CurrentUser->getDataDirectoryFullPath('user_public_images');
        $items = \SCHLIX\cmsDirectoryFilter::getRecursiveDirectoryIterator($start_path, \SCHLIX\cmsDirectoryFilter::FILTER_FILE_ONLY, array('Thumbs.db', 'Thumb.db', '__MACOSX'));
        $total = $items ? ___c($items) : 0;

        $img_array = [];
        $i = 0;
        if ($items)
        {
            foreach ($items as $item) {
                $file = CURRENT_SUBSITE_URL_PATH . remove_prefix_from_file_name($item->getPathName(), SCHLIX_SITE_PATH);


                $img_array[] = array('title' => $this->getImageListDescription($file), 'value' => $file);

                $i++;
            }
        }

        echo json_encode($img_array);
    }

    //_______________________________________________________________________________________________________________//
    public function Run($command) {
        //$this->insertTest();
        switch ($command['action']) {
            case 'full_file_list':
                $this->viewFileList(true);
                return false;
                break;
            case 'full_image_list':
                $this->viewImageList(true);
                return false;
                break;
            case 'user_file_list':
                $this->viewFileList(false);
                return false;
                break;
            case 'user_image_list':
                $this->viewImageList(false);
                return false;
                break;
            case 'viewitem':
            case 'viewcategory':
            case 'main': die('Not available');
                return true;
                break;
            default: return parent::Run($command);
        }
    }

}
