<?php
namespace App;
/**
 * Core: Menu - Main Class
 * 
 * Core - Menu
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_Menu extends \SCHLIX\cmsApplication_CategorizedList {

    protected $element_ul_class;
    protected $element_li;
    protected $element_ul;
    protected $submenu_icon;
    protected $tmpstore = [];
    
    protected $backend_mode = null;
    protected $use_menu_human_readable_css = null;

    public function __construct()
    {
        global $CurrentUser;

        $this->disable_frontend_runtime = true; // not enabled for public
        parent::__construct('Menu', 'gk_menu_items', 'gk_menu_categories');
        $this->backend_mode = ($CurrentUser != null);
        $this->use_menu_human_readable_css = true; // $this->getConfig('int_menu_human_readable_css');
        $this->setOutputHTMLElements();
        $this->refreshAllMenuLinks(false);
    }

    //_______________________________________________________________________________________________________________//
    protected function setOutputHTMLElements()
    {
        if ($this->getConfig('int_menu_html_element') == 1 && !$this->backend_mode) {
            $this->element_ul = 'div';
            $this->element_li = 'div';
        }
        else {
            $this->element_ul = 'ul';
            $this->element_li = 'li';
        }
        $this->element_ul_class = "dropdown-menu";
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Refresh all the menu links
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @global \SCHLIX\cmsConfigRegistry $SystemConfig
     * @param bool $force
     */
    public function refreshAllMenuLinks($force = false) // new, IIS fix only
    {
        global $SystemDB, $SystemConfig;

        $int_httpbase_set = (int) $SystemConfig->get('system', 'int_httpbase_set'); 
        // set to 3 - quick fix - 2020 Nov 10 - issue with getFullPathByCategoryID on MySQL 8
        if (($int_httpbase_set < 3) || $force) { 
            $sql = "SELECT * FROM {$this->table_items} order by id";
            $menus = $SystemDB->getQueryResultArray($sql);
            foreach ($menus as $menu)
            {
                $sefurl = '';
                switch ($menu['application'])
                {
                    case 'home': if (SCHLIX_SITE_HTTPBASE)
                            $sefurl = SCHLIX_SITE_HTTPBASE;
                        else
                            $sefurl = '/';break;
                    case 'external_link':
                        $sefurl = $menu['customurl'];
                        break;
                    case 'menu_divider':
                    case 'menu_placeholder':
                        $sefurl =  'javascript:void(0)';
                        
                        break;
                    default:
                        $file_exists = false;
                        if (str_contains($menu['application'],'.'))
                        {
                            $ap = explode('.', $menu['application']);
                            $master = alpha_numeric_with_dash_underscore($ap[0]);
                            $child = alpha_numeric_with_dash_underscore($ap[1]);
                            $sub_app_name1 = "/apps/{$master}/{$child}/{$master}.{$child}.class.php";
                            $sub_app_name2 = "/apps/{$master}/{$master}.{$child}.class.php";
                            $file_exists = get_system_or_user_file($sub_app_name1, false) || get_system_or_user_file($sub_app_name2, false);
                        } else 
                        {
                            $file_exists = get_system_or_user_file("/apps/{$menu['application']}/{$menu['application']}.class.php", false);
                        }
                        
                        if ($file_exists)
                        {
                            $the_app_name =   '\\App\\'.alpha_numeric_with_underscore($menu['application'],'_');
                            $temp_app = new $the_app_name;                            
                            $sefurl = $temp_app->createFriendlyURL($menu['internalurl']);
                        }
                        break;
                }
                // Fix 2024-02-18
                $sql = "UPDATE {$this->table_items} SET sefurl = :sef_url WHERE id = :menu_id";
                $SystemDB->query($sql, ['sef_url' => $sefurl, 'menu_id' => $menu['id']]);
                
            }
            $SystemConfig->set('system', 'str_httpbase', SCHLIX_SITE_HTTPBASE);
            $SystemConfig->set('system', 'int_httpbase_set', $int_httpbase_set + 1); 
        }
    }


    //_______________________________________________________________________________________________________________//
    /**
     * Get the current menu ID based on the URL entered, e.g. http://website.com/html/test123.html and if it's in the menu it will return
     * that ID from gk_menu_items table
     *
     * @return -1 if it's not anywhere, or an integer of the menu id
     */
    public static function getCurrentMenuID()
    {
        $menu_info = self::getCurrentMenuInformation();
        return isset($menu_info['id']) ? $menu_info['id'] : NULL;
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Get the current menu ID based on the URL entered, e.g. http://website.com/html/test123.html and if it's in the menu it will return
     * that ID from gk_menu_items table
     *
     * @return -1 if it's not anywhere, or an integer of the menu id
     */
    public static function getCurrentMenuInformation()
    {
        // TODO: expand/include subchild - Prana - Oct 1, 2010
        global $SystemDB;

        $current_menu_info = \SCHLIX\cmsContextCache::get('menu','current_menu_info');
        if ($current_menu_info)
        {
            return $current_menu_info;
        } else
        {
            $base = "'" . SCHLIX_SITE_HTTPBASE . "'";
            if (SCHLIX_SITE_HTTPBASE == '')
                $base = "'/'";
            $request_uri = parse_url( $_SERVER['REQUEST_URI'], PHP_URL_PATH);
            $url = sanitize_string($request_uri);

            if ($request_uri == SCHLIX_SITE_HTTPBASE . '/')
                $url = $base; // special exception for base Oct 11, 2010
            $sql = "SELECT * FROM gk_menu_items WHERE sefurl = {$url} OR internalurl = {$url}";
            $menu = $SystemDB->getQueryResultSingleRow($sql, true);
            if (!$menu) {
                // test
                if ($request_uri == '/')
                    $sql = "SELECT * FROM gk_menu_items WHERE sefurl='/'";
                else
                    $sql = "SELECT * FROM gk_menu_items WHERE (INSTR({$url},sefurl) = 1) AND (sefurl <> {$base}) ";
                $menu = $SystemDB->getQueryResultSingleRow($sql, true);
                $menu['exact_url'] = false;
                $menu['inside_page'] = true;
            } else {
                
                $menu['exact_url'] = true;
                $menu['inside_page'] = false;
            }
             \SCHLIX\cmsContextCache::set('menu','current_menu_info', $menu);
            return $menu;
        }
    }
                    
    //_________________________________________________________________________//
    public function getMenuArrayByCategoryID($category_id, $active_only = false, $fields = '*')
    {
        global $SystemDB, $CurrentUser;
        // Get Menu Block
        $category_id = (int) $category_id;
        $extra_qry = ($active_only) ? " AND status > 0" : '';
        $sql = "SELECT {$fields} FROM {$this->table_items} where category_id = {$category_id} {$extra_qry} ORDER BY sort_order"; // fix sept 5, 2010
        // Nov 29, 2011 - only enable cache if display invisible = true (meaning it's being accessed from the admin)
        $main_menu_items = $SystemDB->getQueryResultArray($sql);
        
        return $main_menu_items;
        
        // Get Menu Block
        /* Old version pre v2.2.0 $category_id = (int) $category_id;
        $parent_id = (int) $parent_id;
        $extra_qry = ($active_only) ? " AND status > 0" : '';
        $sql = "SELECT * FROM {$this->table_items} where parent_id = {$parent_id} AND category_id = {$category_id} {$extra_qry} ORDER BY sort_order"; // fix sept 5, 2010
        // Nov 29, 2011 - only enable cache if display invisible = true (meaning it's being accessed from the admin)
        $main_menu_items = $SystemDB->getQueryResultArray($sql);
        
        if ($main_menu_items) {
            foreach ($main_menu_items as $menu)
            {
                $child_menu_items = $this->getMenuArrayByCategoryID($category_id, $menu[$this->field_id]);
                if (!empty($child_menu_items))
                    $main_menu_items = array_merge($main_menu_items, $child_menu_items);
            }
        }
        return $main_menu_items;*/
        
    }

    /**
     * Before save item
     * @param array $datavalues
     * @return array
     */
    public function modifyDataValuesBeforeSaveItem($datavalues) {
        $datavalues = parent::modifyDataValuesBeforeSaveItem($datavalues);
        
        // Process menu types
        $datavalues['open_in_new_window'] = (int) isset($datavalues['open_in_new_window']) ? $datavalues['open_in_new_window'] : 0;
        $datavalues['status'] = (int) $datavalues['status']; //Sept 5, 2010
        $datavalues['use_font_icon_only_no_text'] =  (int) isset($datavalues['use_font_icon_only_no_text']) ? $datavalues['use_font_icon_only_no_text'] : 0;  

        if( $datavalues['subtemplate'] === '')
            $datavalues['subtemplate'] = 'index';
            
        if( $datavalues['subtemplate_mobile'] === '')
            $datavalues['subtemplate_mobile'] = $datavalues['subtemplate'];        
        if( $datavalues['subtemplate_inner_pages'] === '')
            $datavalues['subtemplate_inner_pages'] = $datavalues['subtemplate'];
        if ($datavalues['application'] == 'home') {
            $datavalues['internalurl'] = '/' . SCHLIX_SITE_HTTPBASE;
            $datavalues['sefurl'] = '/' . SCHLIX_SITE_HTTPBASE;
        }
        else
        if ($datavalues['application'] == 'external_link') {
            $datavalues['internalurl'] = $datavalues['customurl'];
            $datavalues['sefurl'] = $datavalues['customurl'];
        }
        else
        if ($datavalues['application'] == 'menu_divider' || $datavalues['application'] == 'menu_placeholder') {
            $datavalues['internalurl'] = '';
            $datavalues['sefurl'] = 'javascript:void(0)';
        }
        
        else {
            //////  
            switch ($datavalues['menuaction'])
            {
                case 'standard_main_app':
                    $datavalues['internalurl'] = "app={$datavalues['application']}";
                    $datavalues['menuitem'] = '';
                    break;
                case 'standard_browse':
                    $itemid = intval(substr($datavalues['menuitem'], 1, strlen($datavalues['menuitem']) - 1));
                    if ($datavalues['menuitem'][0] == 'c')
                        $action = "viewcategory&cid={$itemid}";
                    else if ($datavalues['menuitem'][0] == 'i')
                        $action = "viewitem&id={$itemid}";
                    $datavalues['internalurl'] = "app={$datavalues['application']}&action={$action}";
                    break;
                default:
                    $datavalues['internalurl'] = "app={$datavalues['application']}&action={$datavalues['menuaction']}";
                    break;
            }
            // add support for subapplication (Jan 2020)
            $full_app_name = alpha_numeric_with_underscore($datavalues['application'],'_');
            $the_app_name = '\\App\\'.$full_app_name;
            $temp_app = new  $the_app_name; //$datavalues['application'];

            // fix up quirks for non-SEF URL (internal)
            parse_str($datavalues['internalurl'], $tmp_url_array);
            $array_tmp_keys = array_keys($tmp_url_array); // separate it
            foreach ($array_tmp_keys as $key)
            {
                $value = trim($tmp_url_array[$key]);
                if (empty($value))
                    unset($tmp_url_array[$key]);
            }
            $datavalues['internalurl'] = http_build_query($tmp_url_array);
            ////////////

            $datavalues['sefurl'] = $temp_app->createFriendlyURL($datavalues['internalurl']);
        }
        // Fix - Nov 3, 2013
        if ($datavalues['application'] != 'external_link') {
            $datavalues['internalurl'] = remove_multiple_slashes($datavalues['internalurl']);
            $datavalues['sefurl'] = remove_multiple_slashes($datavalues['sefurl']);
        }

        
        return $datavalues;
    }
    
    
    /**
     * Modify some stuff
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param array $datavalues
     * @param array $retval
     */
    public function onAfterSaveItem($datavalues, $original_datavalues, $previous_item, $retval) 
    {
        global $SystemDB;
        
        parent::onAfterSaveItem($datavalues, $original_datavalues, $previous_item, $retval);
        $item_id = (int) $retval['id'];
        if ($retval['is_new'])
        {
            $sql = "UPDATE {$this->table_items} SET sort_order=id WHERE {$this->field_id} = '{$item_id}';";
            $SystemDB->query($sql);
        }
        
    }

}
                