<?php
/**
 * Core - Menu - Edit Item Template
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');
global $CurrentUser;

$array_ssl_states = array(array('label' => ___('Auto (Default)'), 'value' => '0'),
    array('label' => ___('HTTP - Regular'), 'value' => '1'),
    array('label' => ___('HTTPS - Encrypted SSL only (will not work if it is not setup properly)'), 'value' => '2'));

$array_subtemplates = $this->getListOfFrontendSubtemplates();

$current_website_template = $this->getDefaultFrontendThemeID();
$template_name = $current_website_template['title'];
$template_id = $current_website_template['id'];
$template_link =  $template_name; //A($template_name, "index.php?app=templates&action=edititem&id={$template_id}", array('target' => '_blank'));

$header_title = ($id == 'new') ? ___('New Item') : ___('Edit Item');
if ($id == 'new') 
{
    $item['application'] = null;
    $item['sefurl'] = null;
    $item['guid'] = new_uuid_v4();
    $item['customurl'] = null;
    $item['open_in_new_window'] = false;
    $item['status'] = 1;
    $item['menuaction'] = null;
    $item['menuitem'] = null;
    $item['use_font_icon_only_no_text'] = false;
    $item['font_icon'] = null;
    $item['permission_read'] = serialize('everyone');
}

$url = SCHLIX_SEF_ENABLED ? SCHLIX_SITE_URL . $item['sefurl'] : SCHLIX_SITE_URL . '/index.php?' . $item['internalurl'];
if ($item['application'] == 'external_link')
    $url = $item['customurl'];

$category_id = (int) $item['category_id'];
$category_name = '';
if ($category_id > 0)
{
    $category_info = $this->getCategoryByID($category_id);
    $category_name = $category_info['title'];
}
?>
<x-ui:schlix-explorer-sub-application-header />
<x-ui:schlix-item-editor data-schlix-controller="SCHLIX.CMS.MenusAdmin">    
   
        <x-ui:schlix-editor-form id="form-edit-item" method="post" admin-action="saveitem">
            
            <x-ui:csrf id="_csrftoken" />
            
            <x-ui:hidden id="id" name="id" data-field="id" />
            <x-ui:hidden id="category_id" data-field="category_id" name="category_id" />
            <x-ui:hidden name="existing_application" id="existing_application" value="<?= ___h($item['application']) ?>" />
            <x-ui:hidden name="existing_menuaction" id="existing_menuaction" value="<?= ___h($item['menuaction']) ?>" />
            <x-ui:hidden name="existing_menuitem" id="existing_menuitem" value="<?= ___h($item['menuitem']) ?>" />
            <x-ui:hidden name="existing_customurl" id="existing_customurl" value="<?= ___h($item['customurl']) ?>" />
            <x-ui:hidden name="user_changed_item_or_category" id="user_changed_item_or_category" value="0" />
            <?php if ($item['menuaction'] == 'standard_browse'):
                $existing_menu_parent_category = $this->getMenuItemParentCategoryForMenuItemSelection($item['application'], $item['menuitem']);
                ?>
                <input type="hidden" name="existing_menu_parent_category" id="existing_menu_parent_category" value="<?= $existing_menu_parent_category; ?>" />
            <?php endif; ?>

            
            
            <x-ui:schlix-editor-top-row>    
                <x-ui:schlix-editor-top-left>
                    <!-- Page Title -->
                     
                    <x-ui:form-group>
                        <label for="title"><?= ___("Menu Title") ?></label>
                        <x-ui:input-group>
                            <!-- title -->                                  
                            <x-ui:textbox name="title"  id="title" type="text" size="49" maxlength="254" input-size="large" required="required"   data-field="title" /> 
                            <!-- Status -->
                            <x-ui:input-addon>
                                <schlix-cms-document-status id="status" data-input-name="status" data-value="<?= ($item['status'] == 1 || $item['id'] == 'new') ?>" 
                                                            data-icon-yes="fa fa-check" data-icon-no="fa fa-times" data-color-yes="green" data-color-no="red" 
                                                            data-text-yes="<?= ___('Active') ?>" data-text-no="<?= ___('Inactive') ?>"></schlix-cms-document-status>
                            </x-ui:input-addon>
                            
                            <x-ui:input-addon>
                                <i class="fas fa-folder text-orange"></i> <?= ___h($category_name) ?>
                            </x-ui:input-addon>
                            
                            <!-- New Window -->
                            <x-ui:input-addon>
                                <schlix-cms-document-status id="open_in_new_window" data-input-name="open_in_new_window" data-value="<?= ($item['open_in_new_window'] == 1) ?>" 
                                        data-icon-yes="fa fa-external-link-square-alt" data-icon-no="far fa-minus-square" data-color-yes="blue" data-color-no="blue" 
                                        data-text-yes="<?= ___('Open in a new tab/window') ?>" data-text-no="<?= ___('Open in current window') ?>"></schlix-cms-document-status>

                            </x-ui:input-addon>
                        </x-ui:input-group>
                    <!-- current link -->
                    <?= ___('currently links to') ?> <?= $item['application'] ?>:
                    <?= ($item['id'] == 'new') ? ___('undefined (new item)') : $url; ?>
                    <!-- end current link -->                        
                    </x-ui:form-group>               
                    <!-- end -->                    
                </x-ui:schlix-editor-top-left>
                <x-ui:schlix-editor-top-right>
                    <x-ui:schlix-editor-action-buttons />
                </x-ui:schlix-editor-top-right>            
            </x-ui:schlix-editor-top-row>

            <!-- main -->
            <x-ui:clearboth />
            
            <x-ui:schlix-document-save-result />
            <!-- begin tabs -->
            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_application" fonticon="fa fa-puzzle-piece" label="<?= ___('Application') ?>"> 
                        <!-- tab 1 content -->
                        <x-ui:row>
                            <x-ui:column md="3">
                                <h4><i class="fa fa-puzzle-piece"></i> <?= ___("Please select an application") ?></h4>
                                <?= $this->drawApplicationChoices($item['application']); ?>
                            </x-ui:column>
                            <x-ui:column md="9">
                                <div id="menu_application_methods_container">
                                    <!-- this is where the action (e.g. main, view item, rss, etc will be displayed -->
                                </div>
                                
                                 
                                <!-- ################################## -->
                                <!-- ########## For the app ########### -->
                                <!-- ################################## -->
                                <div id="menu_editor_layout">
                                    <?php include('edit.item.layout.template.php') ?>
                                </div>
                                <!-- ################################## -->
                                <!-- ########## end for the app ####### -->
                                <!-- ################################## -->
                            </x-ui:column>
                        </x-ui:row>
                        

                        <!-- end tab 1 content -->
                    
                </x-ui:schlix-tab>
                
                <!-- tab -->
                <x-ui:schlix-tab id="tab_icon_n_template" fonticon="fa fa-sticky-note" label="<?= ___('Icon and Page subtemplate') ?>"> 
                        <!-- tab content -->
                        <x-ui:row>
                            <x-ui:column md="3">
                            <fieldset>
                                <legend><?= ___('Font icon') ?></legend>
                               <button class="btn btn-default" name="font_icon"  data-iconset="fontawesome" data-icon="<?= ___h(trim($item['font_icon'])); ?>" role="iconpicker"></button> 
                                <schlix-cms-document-status id="use_font_icon_only_no_text" data-input-name="use_font_icon_only_no_text" 
                                                            data-value="<?= ($item['use_font_icon_only_no_text'] == 1) ?>" 
                                                            data-icon-yes="fa fa-check" data-icon-no="fa fa-times" data-color-yes="green" data-color-no="red" 
                                                            data-text-yes="<?= ___('Use font icon only') ?>" data-text-no="<?= ___('Use both text and font icon') ?>"></schlix-cms-document-status>
                                
                            </fieldset>
                                
                            <fieldset>
                                <legend><?= ___('CSS') ?></legend>
                                <!-- custom css class -->
                                <x-ui:textbox name="custom_css_class" type="text" data-field="custom_css_class" label="<?= ___('Custom CSS Class'); ?>" />
                            </fieldset>
                            </x-ui:column>
                            
                            <!-- col -->
                            <x-ui:column md="7">
                            <x-ui:textbox fonticon="fas fa-folder text-orange" readonly="readonly" value="<?= ___h(CURRENT_THEME_URL_PATH) ?>" label="<?= ___('Current website theme') ?>: <?= $template_link; ?>" /><p><?= ___('Note') ?>: <?= sprintf(___('You can create more custom %s (sub-template files) in the current theme directory: %s'), '*.template.php', '<strong>'. CURRENT_THEME_URL_PATH.'</strong>') ?> </p>
                            <?php $subtemplate_desktop = ($id ==='new') ? 'index' : $item['subtemplate']; ?>
                            <?php $subtemplate_desktop_inner_pages = ($id ==='new') ? 'index' : $item['subtemplate_inner_pages']; ?>
                            <?php $subtemplate_mobile = ($id ==='new') ? 'index' : $item['subtemplate_mobile']; ?>
                            
                            <?= \INPUT::RADIO_GROUP('subtemplate', $array_subtemplates, $subtemplate_desktop, '<i class="fa fa-desktop"></i> '. ___('Desktop and Responsive subtemplate') ); ?>
                            <?= \INPUT::RADIO_GROUP('subtemplate_inner_pages', $array_subtemplates, $subtemplate_desktop_inner_pages, '<i class="fa fa-desktop"></i> '. ___('Desktop and Responsive inner pages subtemplate')); ?>
                            <?= \INPUT::RADIO_GROUP('subtemplate_mobile', $array_subtemplates, $subtemplate_mobile, '<i class="fas fa-mobile-alt-phone"></i> '.___('Specific mobile subtemplate (Adaptive)') ); ?>
                            
                            </x-ui:column>
                        </x-ui:row>
                        <!-- end tab content -->                    
                </x-ui:schlix-tab>
                <!-- tab -->
                
                <x-ui:schlix-tab id="tab_connection" fonticon="fas fa-project-diagram" label="<?= ___('Connection') ?>">    
                    
                    <x-ui:radio-group id="ssl_state" name="ssl_state" data-options-var="array_ssl_states" data-field="ssl_state" label="<?= ___('Connection Type') ?>" /> 
                    <!-- row -->
                </x-ui:schlix-tab>
                <!-- tab -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditItemTab', $this, $item) ?>
            </x-ui:schlix-tab-container>            
            <!-- end tabs -->
        </x-ui:schlix-editor-form>
</x-ui:schlix-item-editor>