/**
 * Core - SCHLIX Updater - Javascript admin controller class
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_SCHLIXUpdaterAdminController = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("core.schlixupdater");
    };
    
    beginUpdate ()
    { // Step 1

      //if (confirm("Are you sure you want to upgrade"))
      //{
            document.getElementById('update_progress_complete').style.display = 'none';
            document.getElementById('update_upgrading_post_install').style.display = 'none';

            document.getElementById('download_progress_indicator').style.display = 'block';
            document.getElementById('update_progress_error').innerHTML = '';
            document.getElementById('update_progress_message').innerHTML = '';
                document.getElementById('btn-begin-update').style.display = 'none';
            
            this.ajaxRequestPOST("action=downloadupdate", this.receiveUpdate, "_csrftoken=" + _csrftoken);
      //}
    };
    ///////////////////////////////////////////////////////////
    receiveUpdate (o)
    {// Step 2
        var response = ajax_parse (o.responseText);
        if (response)
        {
            document.getElementById('update_processing_files').style.display = 'block';
            document.getElementById('update_upgrading_post_install').style.display = 'none';
            document.getElementById('download_progress_indicator').style.display = 'none';
            this.ajaxRequestPOST("action=runupdate", this.receiveUpdateText, "_csrftoken=" + _csrftoken);
        }

    };
    receiveUpdateText(o)
    { //Step 3
        var response = ajax_parse (o.responseText);
        if (response)
        {
            document.getElementById('update_processing_files').style.display = 'none';
            document.getElementById('update_upgrading_post_install').style.display = 'block';

            this.displayMessagesAndErrors('update_progress', response.messages, response.errors);
            if (response.errors.length == 0  )
            {
                this.ajaxRequestPOST("action=updatescript", this.runDatabaseUpdate, "_csrftoken=" + _csrftoken);
            }
        }
    }

    runDatabaseUpdate (o)
    { //Step 4
        var response = ajax_parse (o.responseText);
        if (response)
        {
            this.displayMessagesAndErrors('post_upgrade', response.messages, response.errors);
            document.getElementById('update_upgrading_post_install').style.display = 'none';
            if (response.errors.length === 0  )
            {            
                this.ajaxRequestPOST("action=updatelang", this.runLanguageUpdate, "_csrftoken=" + _csrftoken);
            }
        }
    }
    
    runLanguageUpdate (o)
    { //Step 4
        var response = ajax_parse (o.responseText);
        if (response)
        {
            this.displayMessagesAndErrors('upgrade_lang', response.messages, response.errors);
            var response = ajax_parse (o.responseText);

            if (response.errors &&  response.errors.length === 0  )
            {            
                document.getElementById('update_progress_complete').style.display = 'block';
                document.getElementById('btn-begin-update').style.display = 'none';
            }
        }
        document.getElementById('update_upgrading_post_install').style.display = 'none';
    }
    
    
    ajaxRequestPOST (therequest, thefunction, postData, app_name, indicate_busy)
    {
        var the_app_url = this.cms_control.schlix_application_url;

        var callback = {success: thefunction, failure: this.handleFailure, scope: this};
        var sUrl = site_httpbase + the_app_url + "&ajax=1&" + therequest;
        if (typeof indicate_busy !== "undefined")
            this.setBusy(true);
        var request = SCHLIX.Ajax.POST(sUrl, callback, postData);
    };

    displayMessagesAndErrors(container, messages, errors)
    {
            var str_errors = errors && (errors.length > 0) ? errors.join('<br />') : '';
            var str_message = messages && (messages.length > 0) ? messages.join('<br />') : '';
            if (str_errors)
            {
                var error_container = document.getElementById(container +'_error');
                error_container.innerHTML = error_container.innerHTML + str_errors;
                error_container.classList.add('alert');
                error_container.classList.add('alert-danger');
                
            }
            
            if (str_message)
            {
                var message_container = document.getElementById(container + '_message');
                
                message_container.innerHTML = message_container.innerHTML + str_message;
                message_container.classList.add('alert');
                message_container.classList.add('alert-info');
                
            }
        
    }
    ///////////////////////////////////////////////////////////
    
    onDOMReady ()
    {
        SCHLIX.Event.on('btn-begin-update', 'click', this.beginUpdate, this, true);
    }; // end func

 
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'config':
                this.redirectToCMSCommand("editconfig");
                return true;
                break;
            
            default:
                return super.runCommand(command, evt);
                break;
        }
    }

};


