<?php
/**
 *  Landing Pages - Edit Item Template
 *
 * @copyright 2016 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php
global $CurrentUser;
if ($id == 'new') {
    $item['permission_read'] = serialize('everyone');
    $header_title = ___('New Item');
} else {
    $id = (int) $id;
    $preview_link = $this->app->createFriendlyURL("action=viewitem&id={$id}");
    $header_title = ___('Edit Item').' #'.___h($id);
}

//$parent_category_text = $this->getItemParentURLPathPreviewLink($item); 
?>

<x-ui:schlix-item-editor data-type-desc="<?= ___('page fragment') ?>" data-schlix-controller="SCHLIX.CMS.LandingPagesAdminController">    
        
        <x-ui:schlix-editor-form id="form-edit-item" method="post" admin-action="saveitem">
            
            <x-ui:csrf id="_csrftoken" />
            <x-ui:hidden id="id" name="id" data-field="id" />
            <x-ui:hidden id="category_id" data-field="category_id" name="category_id" />
            <x-ui:hidden id="guid" data-field="guid" name="guid" />
            <x-ui:schlix-editor-top-row>    
                <x-ui:schlix-editor-top-left>
                    <!-- Page Title -->
                     <x-ui:schlix-document-title id="title" maxlength="191"  required="required"  data-field="title" table-type="item" />
                    <!-- Virtual Filename -->
                    <x-ui:schlix-document-virtual-filename id="virtual_filename" data-field="virtual_filename" name="virtual_filename" />
                    
                </x-ui:schlix-editor-top-left>
                <x-ui:schlix-editor-top-right>
                    <x-ui:schlix-editor-action-buttons />
                </x-ui:schlix-editor-top-right>            
            </x-ui:schlix-editor-top-row>

            <!-- main -->
            <x-ui:clearboth />
            
            <x-ui:schlix-document-save-result />
            <!-- end main section -->
            <!-- begin tabs -->
            <x-ui:schlix-tab-container>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_content" fonticon="far fa-file-alt" label="<?= ___('Content') ?>"> 
                    <x-ui:wysiwyg id="summary" name="summary" data-field="summary" label="<?= ___('Summary') ?>" />
                    <x-ui:clearboth />
                    <x-ui:wysiwyg id="description" name="description" data-field="description" label="<?= ___('Description') ?>" />
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_dates" fonticon="far fa-calendar" label="<?= ___('Dates') ?>"> 
                    
                    <x-ui:schlix-datetime-picker id="date_created" data-field="date_created" label="<?= ___('Created') ?>" />
                    <x-ui:schlix-datetime-picker id="date_modified" data-field="date_modified" label="<?= ___('Modified') ?>" />
                    <x-ui:schlix-datetime-picker id="date_available" name="date_available" data-field="date_available" label="<?= ___('Available on') ?>" />
                    <x-ui:schlix-datetime-picker id="date_expiry" name="date_expiry" data-field="date_expiry" label="<?= ___('Expiry') ?>" />
                    
                </x-ui:schlix-tab>
                <!-- tab -->
                <x-ui:schlix-tab id="tab_options" fonticon="fa fa-sliders-h" label="<?= ___('Options') ?>">
                    <x-ui:schlix-editor-item-meta-options name="options" data-field="options" max-item-per-column="1" column="3" />
                </x-ui:schlix-tab>
                <!-- tab -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditItemTab', $this, $item) ?>
            </x-ui:schlix-tab-container>            
            <!-- end tabs -->
        </x-ui:schlix-editor-form>
</x-ui:schlix-item-editor>
 