<?php
/**
 * Personal Data Request - Main page template. Lists all items. 
 * 
 * Plugin for compliance with GDPR
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package personaldatarequest
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');

 $str_mainpage_title =  $this->getConfig('str_mainpage_title') ? $this->getConfig('str_mainpage_title') : $this->getApplicationDescription();
$str_mainpage_text =  $this->getConfig('str_mainpage_text');
 // OPTIONAL - feel free to uncomment
 // $this->processDataOutputWithMacro($str_mainpage_text, 'viewMainPage');
$show_captcha = $this->getConfig('bool_enable_captcha_request');
$show_removal_reason = $this->getConfig('bool_ask_for_removal_reason');

?>
<div class="app-page-main app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-main">
    <h1 class="main title"><?= ___h($str_mainpage_title) ?></h1>
    
    <x-ui:row>
        <x-ui:column sm="4">
            <div class="schlix-ajax-output"></div>
        <x-ui:form-simple-ajax name="form_personal_data_request"  method="post" data-action="<?= $this->createFriendlyURL("action=request"); ?>" enctype="multipart/form-data" >
            <x-ui:csrf />

            <x-ui:form-group>
                <x-ui:textbox type="email" name="email_address" id="email_address" autofocus="autofocus" required="required" fonticon="fa fa-envelope" label="<?= ___('Email Address') ?>"  placeholder="<?= ___('Email Address') ?>" value="test@test.com" />
            </x-ui:form-group>

            <p><?= ___('Please choose your type of request') ?></p>
            <x-ui:radio-group id="request_type" name="request_type">
                <x-ui:option value="1" id="gdpr_opt_request" class="gdpr_opts" label="<?= ___('Request Data'); ?>" required="required" />
                <x-ui:option value="2" id="gdpr_opt_remove" class="gdpr_opts" label="<?= ___('Remove Data'); ?>" />
            </x-ui:radio-group> 
            
            <?php if ($show_removal_reason): ?>
                <x-ui:textarea id="reason" name="reason" rows="10" label="<?= ___('Feedback') ?>" placeholder="<?= ___('Please provide a reason for the data removal request') ?>" />
            <?php endif ?>


            <?php if ($show_captcha): ?>
            <x-ui:captcha id="verification_code" name="verification_code" required="required" title="<?= ___('Please enter a valid captcha') ?>" value="" />
            <?php endif; ?>

            <x-ui:button button-type="ok"  type="submit" name="submit" data-form-submit="1" id="btn-request" value="Submit" label="<?= ___('Send Request') ?>" fonticon="fas fa-sign-in-alt" block="1" size="large" />
        </x-ui:form-simple-ajax>
        </x-ui:column>

        <x-ui:column sm="8">
                <?= $str_mainpage_text ?>
        </x-ui:column>

    </x-ui:row>
      
</div>