<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace App;

class SimpleSitemap_Admin extends \SCHLIX\cmsAdmin_Basic {

//_________________________________________________________________________//
    public function __construct() {
        // Data: Item
        $methods = array('standard_main_app' => 'Main Page',);


        parent::__construct('basic', $methods);
        $this->app = new simplesitemap();
    }

    public function getListofApplications($type) {
        $all_frontend_apps = get_list_of_all_apps(false);
        foreach ($all_frontend_apps as $app) {
            if ($app != $this->app_name)
                $item_array[] = array('label' => $app, 'value' => $app);
        }
        return $item_array;
    }

    public function regenerateSitemap()
    {
        if (fpost_int('regen')=== 1)
        {
            check_csrf_halt_on_error(true);
            $this->app->saveSitemapXMLToCache();
            $current_sitemap_content = file_get_contents(CURRENT_SUBSITE_PATH.'/cache/sitemap.xml');
            $status = 'OK';
            $reply = array('status' => $status, 'content' => $current_sitemap_content);
            return ajax_reply(200, $reply);
        } else
        {
            return ajax_reply(201, 'Invalid command');
        }
    }
    
    public function Run() {
        switch (fget_string('action')) {
            case 'regeneratesitemap':
                return ajax_echo($this->regenerateSitemap());
                break;
            default:return parent::Run();
        }
    }

}

?>