<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace App;


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
class Users_Admin extends \SCHLIX\cmsAdmin_ManyToMany {

    /**
     * List of default restricted view files
     * @var tarray
     */
    protected $restricted_view_files = ['view.hook.edit.template.php', 'config.permission.hook.template.php'];
    
    /**
     * User class
     * @var \App\Users 
     */
    protected $app;
//_________________________________________________________________________//
    public function __construct() {
        // Data: Item
        $datatype = 'basicmultiplecategory';
        $methods = array('standard_main_app' => ___('Main members page / Login for unauthenticated users'),
          
          'myprofile' => ___('Edit Profile'),
          'changepassword' => ___('Change Password'),
          'register' => ___('Registration form page'),
          'login' => ___('Login'),
          'logout' => ___('Logout'),
            
        );


        parent::__construct($datatype, $methods);


        $this->tree_config['translate'] = array
          ('groupname' => 'label');
        $this->setItemFieldNamesForAjaxListing('id', 'email_address', 'username', 'date_created', 'date_modified', 'date_last_logged_in', 'status', 'last_ip_address', 'date_last_failed_login_attempt', 'total_failed_login_attempt');
        $this->setCategoryFieldNamesForAjaxListing('cid', 'groupname', 'status');
    }

/*
      //_________________________________________________________________________//
      public function displayPageHeader()
      {
      cmsAdmin_Basic::displayPageHeader();
      $this->loadApplicationJavascript();
      $this->startAjax();
      } */

    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function modifyItemResponseSchemaFields(array $response_schema) {
        $response_schema = parent::modifyItemResponseSchemaFields($response_schema);
        $response_schema[] = array('key' => 'groupname', 'parser' => 'string');
        return $response_schema;
    }  

    //_________________________________________________________________________//
    public function getMenuInfo() {
        $answer['app_name'] = $this->app_name;
        $answer['data_type'] = $this->data_type;
        $answer['field_item_title'] = 'username';
        $answer['field_category_title'] = 'groupname';
        $answer['public_methods'] = $this->public_methods;
        return $answer;
    }

    //_________________________________________________________________________//

    protected function getUsersGroupArray() {
        $groups = $this->app->getAllCategories();
        foreach ($groups as $group) {
            $group_array[] = array('label' => $group['groupname'], 'value' => $group['groupname']);
        }
        return $group_array;
    }
    
    /**
     * Validation
     * @param array $datavalues
     * @return array
     */
    public function onGetAdminValidationErrorListBeforeSaveItem($datavalues) {

        $error_list = parent::onGetAdminValidationErrorListBeforeSaveItem($datavalues);
        $__category_ids_array = \SCHLIX\cmsHttpInputFilter::array_int ($datavalues, '__category_ids');
        $email_addr = trim($datavalues['email_address']);
        
        $int_user_id = (int) $datavalues[$this->field_id];
        if ($int_user_id > 0)
        {
            $user_prev_version = $this->app->getItemByID($int_user_id);
            if (!$user_prev_version)
            {
                $error_list[] = ___('Trying to modify a non-existing user');
                return $error_list; // halt immediately
            }
        }
        if (empty($__category_ids_array) && !$datavalues['change_email'] && !$datavalues['change_password'])
        {            
            $error_list[] = ___('A user must belong to at least one group');
        }        
        $existing_user_with_same_email = $this->app->getUserByEmailAddress($email_addr);
        $dv_cid = isset($datavalues[$this->field_category_id]) ? $datavalues[$this->field_category_id] : null;
        $ex_user_cid = isset($existing_user_with_same_email[$this->field_category_id]) ? $existing_user_with_same_email[$this->field_category_id] : null;
        if ($existing_user_with_same_email && ($dv_cid != $ex_user_cid))
        {
            $error_list[] = ___('Another user already has the following email address').': '.___h($datavalues['email_address']);
        }
        if (empty($email_addr))
        {
            $error_list[] = ___('Please specify an email address');
        }
        // should use user->validateEmailAddressString
        if (filter_var($email_addr, FILTER_VALIDATE_EMAIL) === false) {
            $error_list[] =___('Invalid email address');
        }        
        if ($datavalues[$this->field_id] == 'new')            
        {
            if ($this->app->userNameExists($datavalues['username']))
                $error_list[] =___('The username has already been taken');
            $thecount = ___c($this->app->getUserByEmailAddress($datavalues['email_address']));
            if ($thecount > 0)
                $error_list[] =___('The email address has already been registered');
            
        }
        // If it's a new user or password change flag is checked
        $dv_change_password = isset($datavalues['change_password']) ? $datavalues['change_password'] : null;
        $dv_change_email = isset($datavalues['change_email']) ? $datavalues['change_email'] : null;
        if ($datavalues[$this->field_id] == 'new' || $dv_change_password)
        {
            if (empty($datavalues['_plaintext_password']))
                $error_list[] = ___('Cannot assign a new user with an empty password');
            if (strlen($datavalues['_plaintext_password']) < 7)
                $error_list[] = ___('Minimum password length is 7 characters  ');
            // 4. Check if password = password_verify
            if ($datavalues['_plaintext_password'] != $datavalues['_plaintext_password_verify'])
               $error_list[] = ___('The password does not match its verification');
        }
        // If it's a new user or email change flag is checked
        if ($datavalues[$this->field_id] == 'new' || $dv_change_email)
        {
            if ($datavalues['email_address'] != $datavalues['email_address_verify'])
               $error_list[] = ___('The e-mail address does not match its verification');
            
            if ($int_user_id > 0 && $user_prev_version)
            {
                // if the admin specifies the email to be changed but didn't really change anything
                $old_email = strtolower(trim($user_prev_version['email_address']));
                $new_email = strtolower(trim($datavalues['email_address']));
                if ($old_email == $new_email)
                {
                    $error_list[] = ___('Email address is still the same as the old one but you ticked the change email address checkbox');
                }
            }
            
        }
        $valid_user_status_array = array(USER_ACTIVATED_IMMEDIATELY, USER_REQUIRES_ACTIVATION, 0);
        $int_status = (int) $datavalues['status'];
        if (!in_array($int_status, $valid_user_status_array))
        {
               $error_list[] = ___('Invalid user status');            
        }
        
        // If date of birth is required
        if ($this->app->getConfig('bool_require_dob'))
        {
            $int_dob_year = (int) $datavalues['dob_year'];
            $int_dob_month = (int) $datavalues['dob_month'];
            $int_dob_day = (int) $datavalues['dob_day'];
            $user_input_date = $int_dob_year.'-'.str_pad($int_dob_month,2,'0',STR_PAD_LEFT).'-'.str_pad($int_dob_day,2,'0',STR_PAD_LEFT);
            if (!is_date($user_input_date,'Y-m-d'))
            {
                $error_list[] = ___('Invalid date of birth').' ('.$user_input_date.')';
            }
            
            $minimum_age = $this->app->getConfig('int_minimum_age_registration');
            if ($minimum_age > 0)
            {
                $birthdate = new \DateTime($user_input_date);
                $now = new \DateTime();
                $interval = $now->diff($birthdate);
                $age = $interval->y;
                if ($age < $minimum_age)
                {
                    $error_list[] = ___('This person does not meet the minimum age requirement to register for this site');
                }
            }            
        }
        
        if ($this->app->getConfig('bool_require_gender'))
        {
            $int_gender = (int) $datavalues['gender'];
            if (!($int_gender > 0 && $int_gender <=3))
                $error_list[] = ___('Please specify the gender');
        }
        
        return $error_list;
    }
    /**
     * Before save category
     * @param array $datavalues
     */
    public function onModifyDataBeforeSaveCategory($datavalues) {
        
        $datavalues = parent::onModifyDataBeforeSaveCategory($datavalues);        
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInCategoryTableUnderParentCategory('virtual_filename', $datavalues['virtual_filename'], $datavalues[$this->field_category_id], $datavalues[$this->field_category_parent_id]);
        return $datavalues;        
    }

    /**
     * Reset other fields when change_email or change_password selected.
     * @param array $datavalues
     * @return array
     */
    private function resetOnEmailPasswordChange($datavalues) {
        
        
        $id = (int) $datavalues[$this->field_id];
        if ($id == 0)
            return $datavalues;

        $user_prev_version = $this->app->getItemByID($id);
        $dv_change_email = isset($datavalues['change_email']) ? $datavalues['change_email'] : null;
        $dv_change_password = isset($datavalues['change_password']) ? $datavalues['change_password'] : null;
        if ($user_prev_version && ($dv_change_email || $dv_change_password)) {
            $datavalues = array_merge($user_prev_version, $datavalues);
        }
        if ($dv_change_email) {
            $datavalues['password'] = NULL;
            unset($datavalues['password']);            
        } else {
            $datavalues['email_address'] = $user_prev_version['email_address'];
        }
        
        return $datavalues;
    }
               
    /**
     * Modify data before save item
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        global $CurrentUser;

        // reset other data on email and password update
        $datavalues = $this->resetOnEmailPasswordChange($datavalues);
        
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        $datavalues['username'] = $this->app->preventDuplicateValueInItemTable('username',  $datavalues['username'],$datavalues[$this->field_id] );
        $int_dob_year = isset($datavalues['dob_year']) ? (int) $datavalues['dob_year'] : 0;
        $int_dob_month = isset($datavalues['dob_month']) ? (int) $datavalues['dob_month'] : 0;
        $int_dob_day = isset($datavalues['dob_day']) ? (int) $datavalues['dob_day'] : 0;

        $dn = trim($datavalues['display_name']);
        if (empty($dn))
            $datavalues['display_name'] = $datavalues['firstname'].' '.$datavalues['lastname'];
        $user_input_date = $int_dob_year.'-'.str_pad($int_dob_month,2,'0',STR_PAD_LEFT).'-'.str_pad($int_dob_day,2,'0',STR_PAD_LEFT);
        if (is_date($user_input_date,'Y-m-d'))
        {    
            $datavalues['date_of_birth'] = $user_input_date;
        } else
        {
            unset($datavalues['date_of_birth']);
        }
        if ($datavalues['status'] == USER_REQUIRES_ACTIVATION)
        {
             $datavalues['activation_string'] = md5(get_current_datetime() . $datavalues['username']. mt_rand());     
        }
        if ($datavalues['id'] == 'new')
            $datavalues['source'] = 'admincreated_'.$CurrentUser->getCurrentUserID();        
        return $datavalues;
    }
    
    //_______________________________________________________________________________________________________________//
    protected function sendAdminCreatedRegistrationEmailToUser($email_to, $user, $email_template_name, $vars = []) {
        global $SystemMail;

        if ($user)
        {
            $login_url = SCHLIX_SITE_URL.$this->app->createFriendlyURL('action=login');
            $email_vars = array(
                  'firstname' => $user['firstname'], 
                  'lastname' => $user['lastname'],
                  'username' => $user['username'],               
                  'email_address' => $user['email_address'],
                  'site_url' => SCHLIX_SITE_URL, 
                  'site_name' => SCHLIX_SITE_NAME, 
                  'login_url' => $login_url);
            if (is_array($vars) && ___c($vars) > 0)
                $email_vars = array_merge($email_vars, $vars);
            if (!$SystemMail->sendEmailFromWebMasterWithTemplateName($user['firstname'].' '.$user['lastname'], $email_to, $email_template_name,  $email_vars)) {
                display_schlix_alert(___('SMTP/Local mail send failed!'));
                $this->app->recordLog("SMTP/Local mail send failed - Cannot send a registration email to {$user['email_address']}");
            }
        }
    }
    
    /**
     * @global \App\Users $CurrentUser
     * @global \App\Core_EmailQueue $SystemMail
     * @param array $datavalues
     * @param array $original_datavalues
     * @param array $previous_item
     * @param array $retval
     */
    public function onAfterSaveItem($datavalues, $original_datavalues, $previous_item, $retval) 
    {
        global $SystemMail, $CurrentUser;
        
        parent::onAfterSaveItem($datavalues, $original_datavalues, $previous_item, $retval);
        if ($retval['status'] == SAVE_OK)
        {
            // set the group
            if (!isset($original_datavalues['change_email']) && !isset($original_datavalues['change_password']))
                $this->setItemCategories($retval['id'], array_values($original_datavalues['__category_ids']));
            $the_user = $this->app->getItemByID($retval['id']);
            $email_to = $the_user['email_address'];
             // if it's a new user
            if ($retval['is_new'])
            {
                if ($original_datavalues['notify_new_account'])
                {
                    if ($the_user['status'] == USER_ACTIVATED_IMMEDIATELY)
                    {
                        $this->sendAdminCreatedRegistrationEmailToUser($email_to, $the_user,'new-user-created-by-web-administrator', array('password' => $original_datavalues['password']));
                        
                    } else if ($the_user['status'] == USER_REQUIRES_ACTIVATION)
                    {
                        $no_ip_text = ___('N/A - created by Administrator');
                        $activation_url = SCHLIX_SITE_URL . $this->app->createFriendlyURL("action=activation&id={$retval['id']}&token={$the_user['activation_string']}");                        
                        $this->sendAdminCreatedRegistrationEmailToUser($email_to, $the_user,'new-user-activation-required', 
                            array('activation_string' => $the_user['activation_string'], 'activation_url' => $activation_url,'ip_address' => $no_ip_text));
                    }
                        
                } 
                $CurrentUser->recordCurrentUserActivity("Created a new user with ID#{$retval['id']} and username:{$the_user['username']}");
            } else // if it's an existing user
            {             
                if (isset($original_datavalues['change_password'])  && isset($original_datavalues['notify_user_password_change']) )
                {
                    $text = sprintf(___('Your password has been changed to %s (case sensitive)'),$original_datavalues['password']);                    
                    $this->sendAdminCreatedRegistrationEmailToUser($email_to,$the_user,'existing-user-changed-by-administrator', array('password' => $original_datavalues['password'],'text'=>$text));
                } else if (isset($original_datavalues['change_email']))
                {
                    $text = sprintf(___('Your e-mail address has been changed from %s to %s'),$previous_item['email_address'], $datavalues['email_address']);
                    $email_vars =  array('old_email' => $previous_item['email_address'], 'new_email' => $datavalues['email_address'], 'text' => $text );
                    if (isset($original_datavalues['notify_user_email_change_old_address']))
                    {
                        $this->sendAdminCreatedRegistrationEmailToUser($previous_item['email_address'],$the_user,'existing-user-changed-by-administrator',$email_vars);
                    }
                    if (isset($original_datavalues['notify_user_email_change_new_address']))
                    {
                        $this->sendAdminCreatedRegistrationEmailToUser($email_to,$the_user,'existing-user-changed-by-administrator',$email_vars);
                    }
                    
                }
                if (!isset($original_datavalues['change_password']) && !isset($original_datavalues['change_email']))
                {
                    $CurrentUser->recordCurrentUserActivity("Modified attributes of user with ID#{$retval['id']} and username:{$the_user['username']}");
                } else if (isset($original_datavalues['change_password']))
                {
                    $CurrentUser->recordCurrentUserActivity("Modified password of user with ID#{$retval['id']} and username:{$the_user['username']}");
                }
                else if ($original_datavalues['change_email'])
                {
                    $CurrentUser->recordCurrentUserActivity("Modified email address of user with ID#{$retval['id']} and username:{$the_user['username']}");
                }
            }
        } else // if save failed
        {
            $error_list = @array_merge($this->onGetAdminValidationErrorListBeforeSaveItem($original_datavalues), $this->app->getValidationErrorListBeforeSaveItem($original_datavalues));
            $error_more_str = (is_array($error_list)) ? implode("\n", $error_list) : '';
            $this->recordLog('Failed when trying to save user '.$error_more_str);
        }
    } 
    
  /**
     * AJAX GET - autocomplete handler
     * @return array
     */
    protected function ajxg_searchUsers()
    {
        global $SystemDB;
        
        $keyword = fget_string_noquotes_notags('keyword',30);
        $keyword = mb_strtolower(str_replace("'", '', $keyword));
        $sanitized_keyword_like = "'". sanitize_string("%{$keyword}%", true)."'";
        $sanitized_keyword = sanitize_string($keyword);
        $data = $this->table_items->q()->select("id AS value, CONCAT(username, ' - ', email_address) AS label")->
                where([["CONCAT(username, ' - ', email_address) = {$sanitized_keyword}", 'OR',
                        "LOWER(firstname) LIKE {$sanitized_keyword_like}", 'OR', 
                        "LOWER(lastname) LIKE {$sanitized_keyword_like}", 'OR',
                        "LOWER(username) LIKE {$sanitized_keyword_like}", 'OR',
                        "LOWER(email_address) LIKE {$sanitized_keyword_like}" 
                                ]])->startEnd(0,30)->getQueryResultArray();
        if ($data == null)
                $data = [];
        return ajax_reply_ok($data);
        
    }
        
    //_________________________________________________________________________//
    public function ajaxSearchObjects($keyword = '', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC') {
        global $SystemDB;

        $cleankeyword = sanitize_string("{$keyword}%");

        $x = implode(',', $this->getItemFieldNamesForAjaxListing());
        $y = implode(',', $this->getCategoryFieldNamesForAjaxListing());
        $username_field = $this->app->getUsernameFieldName();
        $sql = "SELECT {$x} FROM {$this->table_items} WHERE ({$username_field} LIKE {$cleankeyword}) OR (firstname LIKE {$cleankeyword}) OR (lastname LIKE {$cleankeyword}) order by sort_order";

        $result_array = $SystemDB->getQueryResultArray($sql);
        return ajax_reply(200, $result_array);
    }

    //_______________________________________________________________________________________________________________//
    public function createAnnouncement($subject, $message) {
        global $site_name, $site_infomail, $site_template, $site_url;

        //TODO
    }

    //_________________________________________________________________________//
    protected function getTotalMessageCountforContactByID($user_id) {
        global $SystemDB;

        $user_id = intval($user_id);
        $sql = "SELECT COUNT(id) AS total_count FROM gk_user_history WHERE user_id = {$user_id}";
        $result = $SystemDB->getQueryResultSingleRow($sql);
        return $result['total_count'];
    }

    //_________________________________________________________________________//
    public function ajaxGetHistoryForUserByID($id, $start, $end, $sortby, $sortdirection) {
        global $SystemDB;
         $user_id = intval($id);
        $sortby = alpha_numeric_with_dash_underscore($sortby);
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);

        $total_item_count = $this->getTotalMessageCountforContactByID($user_id);

        $sql = $SystemDB->generateSelectSQLStatement('gk_user_history', '*', "user_id = {$user_id}", $start, $end, $sortby, $sortdirection, true, SCHLIX_SQL_ENFORCE_ROW_LIMIT);

        $result = $SystemDB->getQueryResultArray($sql);
        
        return ajax_datasource_reply(200, $result, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
    }

    public function ajaxGetUsersHistorySchema() {
        $userHistoryAdmin = new Users_History_Admin();
        return $userHistoryAdmin->ajaxGetAllDataResponseSchema();
    } 
    /**
     * Internal helper function that you can override to display the 
     * individual category in the item editor window     
     * @param array $item
     * @param array $data
     * @return string
     */
    function viewCategoryTreeList_Item($item, $data)
    {
        $cid = (int) $data[$this->field_category_id];
        if ($item['id'] == 'new')
        {
            $checked = $this->getCurrentCategoryIDFromCookie() == $cid;
        }
        else
            $checked = $this->app->isItemInCategoryID($item[$this->field_id], $cid);
        $input = \INPUT::CHECKBOX('__category_ids[]',$cid , $checked, array('data-required-one'=>'required'));
        $icon = '<i class="fas fa-folder text-orange"></i>&nbsp;';
        $text = ___h($data['groupname']); 
        return \__HTML::DIV_start(array('class'=>'checkbox')).\__HTML::LABEL($icon.$text, $input, false). \__HTML::DIV_end();
    } 
    
    /**
     * AJAX POST handler - change email
     * @return array
     */
    public function ajxp_ChangeEmail()
    {
        $error_list = [];
        check_csrf_halt_on_error();
        
        $user_id = fpost_int('id');        
        $the_user = $this->app->getItemByID($user_id);
        if (!$the_user)
            $error_list[] =  ___('Invalid user');
        $new_email = fpost_string('email_address', 255);
        $new_email_verify = fpost_string('email_address_verify', 255);
        
        
        if (empty($error_list))
        {
            $the_user['change_email'] = 1;
            unset($the_user['password']);
            $the_user['email_address'] = $new_email;
            $the_user['email_address_verify'] = $new_email_verify;            
            $retval = $this->app->saveItem($user_id, $the_user);
            if ($retval['status'] != SAVE_OK)
            {
                $error_list = $retval['errors'];
            }
        }
        $status = empty($error_list);
        if (!$status)
            $reply = $error_list;
        else $reply = 'OK';
        return ajax_reply($status, $reply);        
    }
    /**
     * AJAX POST handler - change password - merged with Roy's ajxp_SendPasswordReset
     * @return array
     */
    public function ajxp_ChangePassword()
    {
        
        $error_list = [];
        check_csrf_halt_on_error();
        
        $user_id = fpost_int('id');        
        $user = $this->app->getItemByID($user_id);
        if (!$user)
            $error_list[] =  ___('Invalid user');
        $change_password_type = fpost_string('change_password_type');
        
        if (empty($error_list))
        {
            if ($change_password_type == 'reset_link')
            {
                if (!filter_var($user['email_address'], FILTER_VALIDATE_EMAIL))
                    $error_list[] = ___('Invalid e-mail address');
                    if (___c($error_list) == 0) {
                        $days = $this->app->getConfig('int_days_forgot_password');
                        if ($days < 1) $days = 1;
                        $password_request_id = $this->app->getExistingPasswordResetRequestByUserID($user[$this->field_id],$days);
                        if ($password_request_id == 0)
                        {
                            $password_request_id = $this->app->createPasswordResetRequest($user);
                        }
                        if ($password_request_id > 0)
                        {
                            $error_list = $this->app->sendPasswordResetRequest($password_request_id);
                        } else 
                        {
                            $error_list[] = ___('Strange error - password request ID is NULL');
                        }

                    } 

            } else if($change_password_type == 'change_password')
            {
                $pt_passwd_old = fpost_string('oldpassword',72);
                $pt_passwd = fpost_string('_plaintext_password', 63);
                $pt_passwd_verify = fpost_string('_plaintext_password_verify', 63);
                $error_list = $this->app->checkPasswordQuality($pt_passwd, $pt_passwd_verify);
                $is_editing_current_user = $user_id == $this->app->getCurrentUserID();
                
                if ($pt_passwd == $pt_passwd_old)
                {
                    $error_list = ___('New password cannot be the same as the old one');
                }

                /*$datavalues = $user;
                $datavalues['change_password'] = 1;
                $datavalues['password'] = $pt_passwd;
                $datavalues['password_verify'] = $pt_passwd_verify;
                //$datavalues['_plaintext_password_verify'] = $pt_passwd_verify;*/

                if ($is_editing_current_user)
                {
                    $check_old_pw = $this->app->verifyUserNamePassword($user['username'], $pt_passwd_old);
                    if (!$check_old_pw)
                        $error_list[] = ___('You have entered an invalid current password');
                    
                } 
                if (empty($error_list))
                {
                    //$retval = $this->saveItem($user_id, $datavalues);
                    $result = $this->app->changePassword($user_id, $pt_passwd);
                    if (!$result)
                        $error_list = ___('Error while changing password');
                    $this->app->logInfo( sprintf("An administrator has changed the password for user ID# %d with username: [%s]", $user[$this->field_id], $user['username']));
                }

            } else $error_list[] = ___('Invalid type');
            
        }
        $status = empty($error_list);
        if (!$status)
            $reply = $error_list;
        else $reply = 'OK';
        return ajax_reply($status, $reply);
        
    }
    //_________________________________________________________________________//
    public function hook_getApplicationAdminExtraEditConfigTab()
    {
         $this->loadNativeTemplateFile('config.permission.hook', null, true);
    }
    
    //_________________________________________________________________________//
    public function hook_getApplicationAdminExtraEditCategoryTab($obj, $category)
    {
        return $this->loadHookTemplateFile($obj, $category, 'category');
    }
    //_________________________________________________________________________//
    public function hook_getApplicationAdminExtraEditItemTab($obj, $item)
    {       
        return $this->loadHookTemplateFile($obj, $item, 'item');
    }

    
    private function loadHookTemplateFile($obj, $data, $type)
    {
        if ($obj instanceof \SCHLIX\cmsAdmin_List)
        {
            $frontendapp = $obj->frontendApp();
            $local_variables = compact(array_keys(get_defined_vars()));            
            $show = ($type === 'category') ?  $frontendapp->categoryColumnExists('permission_read') || $frontendapp->categoryColumnExists('permission_write') :  $frontendapp->itemColumnExists('permission_read') || $frontendapp->itemColumnExists('permission_write');            
            if ($show) 
                $this->loadNativeTemplateFile('view.hook.edit', $local_variables, true);
        }
    }
    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            case 'getuserhistoryresponseschema': 
                return ajax_echo($this->ajaxGetUsersHistorySchema());
                break;
            case 'gethistory':
                return ajax_echo($this->ajaxGetHistoryForUserByID(fget_int('id'), fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));
                break;
            default:return parent::Run();
        }
    }

}
            