<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace Block;

/**
 * Block/widget to display blog categories
 */
class BlogCategories extends \SCHLIX\cmsBlock
{
    /**
     * DIV wrapper CSS class
     * @var string
     */
    protected $css_class_div;
    /**
     * Main CSS Class for UL
     * @var string 
     */
    protected $css_class_ul;
    /**
     * Dropdown CSS Class for UL inside LI
     * @var string 
     */    
    protected $css_class_ul_sub;
    /**
     * Main CSS Class for LI
     * @var string 
     */    
    protected $css_class_li;
    /**
     * Dropdown CSS Class for LI that has submenus
     * @var string 
     */    
    protected $css_class_li_sub;
    
    
    protected $blog;
    protected $block_title;
    /**
     * Generate tree menu
     * @param array $datas
     * @param int $parent
     * @param int $depth
     * @return string
     */
    public function generateTree($datas, $parent = 0, $depth = 0) {
        if ($depth > 100)
            return ''; // Make sure not to have an endless recursion
        $ul_css_class = $this->css_class_ul;
        if ($depth > 0)
            $ul_css_class =  $this->css_class_ul_sub;

        $subtree = '';
        $menu_count = count($datas);
        for ($i = 0; $i < $menu_count; $i++) {
            if ($datas[$i]['parent_id'] == $parent) {
                $link = $this->blog->createFriendlyURL("action=viewcategory&cid={$datas[$i]['cid']}");
                $childnodes = $this->generateTree($datas, $datas[$i]['cid'], $depth + 1);
                $li_css_class = $this->css_class_li;
                if ($childnodes)
                    $li_css_class =  $this->css_class_li_sub;
                $li_css_class = $li_css_class ? "class=\"{$li_css_class}\"" : '';
                $subtree .= "<li {$li_css_class}>\n";
                //$link_attr = $childnodes ? array('class'=>"dropdown-toggle", 'data-toggle'=>"dropdown") : array();
                $link_attr = array();
                $subtree .= \__HTML::A($datas[$i]['title'], $link, $link_attr, array('data-category-id' => $datas[$i]['cid']));
                $subtree .= $childnodes;
                $subtree .= '</li>' . "\n";
            }
        }
        $tree = '';
        if ($subtree)
        {
            $tree = \__HTML::UL_start(array('class' => $ul_css_class)) . "\n";
            $tree.= $subtree;
            $tree .= \__HTML::UL_end() . "\n";
        }
        return $tree;
    }
    //_________________________________________________________________________//
    
	public function Run()
	{
            $this->blog = new \App\blog();
            $this->css_class_ul = $this->getConfig('str_css_class_ul');
            $this->css_class_ul_sub = $this->getConfig('str_css_class_ul_sub');
            $this->css_class_li_sub = $this->getConfig('str_css_class_li_sub');
            $this->css_class_li = $this->getConfig('str_css_class_li');        
            $this->block_title = $this->getConfig('str_block_title');
            
            $cid = $this->blog->getFieldCategoryID();
            $allcategories = $this->blog->getAllCategories("*",'status > 0',0,0,'title','ASC');           
            $this->loadTemplateFile('view.blog.categories',compact(array_keys(get_defined_vars())));
                
  	}
}
 
