<?php
namespace App;

/**
 * Core: Block Manager - Admin class
 * 
 * Core - Block Manager
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_BlockManager_Admin extends \SCHLIX\cmsAdmin_PluginsManager {
    
    use \SCHLIX\cmsAdmin_CustomizablePluginInfo;
    /**
     *
     * @var Core_BlockManager 
     */
    protected $app;

    //_________________________________________________________________________//
    /**
     * Constructor
     * @global \SCHLIX\cmsDatabase $SystemDB
     */        
    public function __construct()
    {
        // Data: Item
        parent::__construct('blocks');
        $this->setItemFieldNamesForAjaxListing('id', 'category_id', 'title', 'date_modified', 'status', 'original_block', 'sort_order');
        
    }

    /**
     * Returns true if a class exists
     * @param string $name
     */
    public function extensionExists($name)
    {
        $class = '\\Block\\'.$name;
        return (class_exists($class));
    }
    
    
    //_________________________________________________________________________//	
    public function findInstalledItem($title)
    {
        global $SystemDB;

        //$current_id = $data[$this->field_id];
        $sql = "SELECT * from {$this->table_items} WHERE (original_block = '{$title}')";
        $result = $SystemDB->getQueryResultArray($sql);
        return $result;
    }

    //_________________________________________________________________________//	
    /**
     * clean up orphaned items
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $items_from_directory
     */
    public function cleanUpOrphanedItems($items_from_directory)
    {
        global $SystemDB; // yes this is a dup, but this is it for now

        for ($i = 0; $i < $total_count = ___c($items_from_directory); $i++)
            $items_from_directory[$i] = "'" . $items_from_directory[$i] . "'";
        $existing_apps = implode(',', $items_from_directory);
        $sql = "DELETE FROM `{$this->table_items}` WHERE original_block NOT IN ({$existing_apps})";
        $SystemDB->query($sql);
    }
    
    //_________________________________________________________________________//
    /** Edit Item
     * 
     * @global \App\Users $CurrentUser
     * @param int $id
     */
    public function editItem($id)
    {
        global $CurrentUser;

        $hasWritePermission = true;
        $id = ($id == 'new') ? 'new' : (int) $id;
        if ($id == 'new') {
            $item['id'] = 'new';
            $item['category_id'] = fcookie_int($this->app_name . '_currentCategory');  
            if ($item['category_id'] == 0)
            {
                $item['category_id'] = $this->app->getDefaultCategoryID();
            }
            $item['date_created'] = get_current_datetime();
            $item['date_available'] = $item['date_created'];
            $item['date_modified'] = $item['date_created'];
            $item['original_block'] = convert_to_safe_filename(fget_string_noquotes_notags('blocktype'));
        }
        else {
            return parent::editItem($id);
        }

        if ($id == 'new') {

            if ($item['id'] != 'new' && $this->app->itemColumnExists('permission_write')) {

                //$hasWritePermission = $CurrentUser->hasWritePermission($item['permission_write']);
                //if (!$hasWritePermission) echo H3(___('You do not have a write access to this'));
            }
            // Restore POST keys if there's any post errors
            if (is_postback() && $this->lastSaveResult != NULL && $this->lastSaveResult['status'] != SAVE_OK)
                foreach ($item as $key => $value)
                    if (array_key_exists($key, $_POST))
                        $item[$key] = is_string($_POST[$key]) ? trim($_POST[$key]) : $_POST[$key];
            
            $local_variables = compact(array_keys(get_defined_vars()));
            if (!$this->loadTemplateFile('edit.item', $local_variables, true))
            {
                echo ___('Cannot find the editor template for ').$this->app_name;
            }
        }
        else
            echo \__HTML::H3(___('Item does not exist'));
    }
    
    /**
     * Returns all block types
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @return array
     */
    protected function getAllBlockTypes()
    {
        global $SystemDB;
        
        return $SystemDB->getQueryResultArray("SELECT DISTINCT original_block FROM `{$this->table_items}` ");        
    }
    //_________________________________________________________________________//	
    public function installItem($filename)
    {
        global $SystemDB;

        
        $datavalues['title'] = $filename;
        $datavalues['original_block'] = $filename;
        $datavalues['category_id'] = $this->getCurrentCategoryIDFromCookie();

        $SystemDB->simpleInsertInto($this->table_items, $datavalues);
        display_schlix_alert(___('Installed ') . ' ' . ___('Block') . ' ' . $filename);
    }
            

    //_________________________________________________________________________//	
    public function ajaxGetItemsByCategoryID($id, $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        $this->checkForUnregisteredItems(); // Experimental
        return parent::ajaxGetItemsByCategoryID($id, $start, $end, $sortby, $sortdirection);
    }

    //_________________________________________________________________________//	
    /**
     * Hook Before save Item
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues)
    {
        $post_keys_to_ignore = array('display_in_menu_workaround','status','display_in_menu','permission_read','_csrftoken','title','submit','id','status');
 
        $datavalues['title'] = strtolower(alpha_numeric_with_dash_underscore($datavalues['title'] ));
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        check_csrf_halt_on_error();

        $data_for_block = $_POST;
        
        $data_for_block['title'] = strtolower(alpha_numeric_with_dash_underscore($data_for_block['title'] ));
        $data_block_name = trim($data_for_block['title']);
        // actually we don't need to clear it because cmsConfigRegistry
        // will ignore keys without type prefix (str, int, bool, float, array, etc)
        foreach ($post_keys_to_ignore as $ignore)
             unset($data_for_block[$ignore]);
        
        $block_config = new \SCHLIX\cmsConfigRegistry('gk_block_config');
        $existing_keys = $block_config->get($data_block_name);
        if ($existing_keys)
        {
            foreach ($existing_keys as $ex_key => $ex_value)
            {
                if (!array_key_exists($ex_key, $data_for_block))
                    $data_for_block[$ex_key] = NULL;
            }
        }
        // handle checkbox save because it won't show up in post
        foreach ($data_for_block as $key => $value)
        {
            $block_config->set($data_block_name, $key, $value);
        }
        /*no longer needed as of 2.2.0 if ($datavalues['permission_read_everyone'])
            $datavalues['permission_read'] = 'everyone';
        $datavalues['permission_write'] = '';*/
        
        if ($datavalues[$this->app->getFieldID()] == 'new')
        {
            $datavalues['original_block'] = $data_for_block['ob'];
            
        }
        //$datavalues['permission_read'] = serialize($datavalues['permission_read']);
        return $datavalues;
    }

    //_________________________________________________________________________// 	
    public function ajaxGetMenus()
    {
        $menu = new \App\Core_Menu();
        $menu_blocks = $menu->getAllCategories();
        $total_menu_blocks = ___c($menu_blocks);
        for ($i = 0; $i < $total_menu_blocks; $i++)
        {
            $menu_blocks[$i]['id'] = 0;
            $menu_blocks[$i]['parent_id'] = 0;
            $menu_blocks[$i]['category_id'] = 0;
        }
        $menus = $menu_blocks;
        foreach ($menu_blocks as $menu_block)
        {
            $menu_items = $menu->getItemsByCategoryID($menu_block['cid']);
            $menus = array_merge($menus, $menu_items);
        }
        return ajax_reply(200, $menus);
    }

    //_________________________________________________________________________//
    public function ajaxGetBlockVisibility($id)
    {
        $visible_in_these_menus = $this->app->getBlockVisibility($id);
        return ajax_reply(200, $visible_in_these_menus);
    }

    //_________________________________________________________________________//
    public function ajaxSetBlockVisibility($id, $menu_id, $state)
    {
        //$status = $this->app->setItemCategory($id, $cid, $state == 'true');
        global $SystemDB;

        $id = (int) $id;
        $menu_id = (int) $menu_id;

        if ($id > 0 and $menu_id >= 0) {
            if ($state == 'true') {
                //TODO: fix it by verifying menu id existance
                //	if ($this->getCategoryByID($menu_id) && $this->getItemByID($id))
                $sql = "INSERT IGNORE INTO gk_block_menu_association (id,menu_id) VALUES ($id, $menu_id)";
                $result = true;
                //echo $sql;
                //else
                //	$result =  false;
            }
            else
                $sql = "DELETE FROM gk_block_menu_association WHERE id = {$id} AND menu_id = {$menu_id}";
            $SystemDB->query($sql);
            $result = true;
        }
        else
            $result = false;

        return ajax_reply(200, $result);
    }
    
    //_________________________________________________________________________// 	
    public function Run()
    {
        switch (fget_alphanumeric('action'))
        {
            case 'getmenus': 
                return ajax_echo($this->ajaxGetMenus());
                break;
            case 'setvisibility':
                return ajax_echo($this->ajaxSetBlockVisibility($_POST['id'], $_POST['menu_id'], $_POST['state']));
                break;
            case 'getvisibility': 
                return ajax_echo($this->ajaxGetBlockVisibility(fget_int('id')));
                break;
            default:
                return parent::Run();
        }
    }

}
            