const u=`{# @private might get removed with any update (even minor!) as it likely gets replaced by shopware analytics #} <div v-if="acl.can('order.viewer')" class="sw-dashboard-statistics" > <template v-if="isLoading"> <sw-skeleton variant="detail" /> <sw-skeleton variant="detail" /> </template> <template v-else> <template v-if="hasOrderToday"> <div class="sw-dashboard-statistics__card-headline"> <h1>{{ $tc('sw-dashboard.todayStats.headline') }}</h1> <span class="sw-dashboard-statistics__card-headline-timerange"> {{ formatChartHeadlineDate(today) }} </span> </div> <mt-card position-identifier=""> <div class="sw-dashboard-statistics__intro-stats-today"> <div v-if="hasOrderToday" class="sw-dashboard-statistics__intro-stats-today-stats" > <div class="sw-dashboard-statistics__intro-stats-today-single-stat"> <span class="sw-dashboard-statistics__intro-stats-today-single-stat-number-type">{{ $tc('sw-dashboard.todayStats.orders') }}</span> <span class="sw-dashboard-statistics__intro-stats-today-single-stat-number-value">{{ orderCountToday }}</span> </div> <div class="sw-dashboard-statistics__intro-stats-today-single-stat"> <span class="sw-dashboard-statistics__intro-stats-today-single-stat-number-type">{{ $tc('sw-dashboard.todayStats.turnover') }}</span> {# price aggregations do not support currencies yet, see NEXT-5069 #} <span class="sw-dashboard-statistics__intro-stats-today-single-stat-number-value">{{ currencyFilter(orderSumToday, systemCurrencyISOCode, 2) }}</span> </div> </div> </div> <template #grid> <sw-entity-listing v-if="todayOrderDataLoaded" :sort-by="todayOrderDataSortBy" :sort-direction="todayOrderDataSortDirection" :repository="orderRepository" :items="todayOrderData" :columns="orderGridColumns()" :show-selection="false" :allow-column-edit="false" :full-page="false" > <template #column-orderDateTime="{ item }"> <sw-time-ago :date="item.orderDateTime" :date-time-format="{ month: '2-digit', day: '2-digit' }" /> </template> <template #column-orderCustomer.firstName="{ item }"> <router-link :to="{ name: 'sw.order.detail', params: { id: item.id } }" class="sw-data-grid__cell-value" > {{ item.orderCustomer.firstName }} {{ item.orderCustomer.lastName }} </router-link> </template> <template #column-amountTotal="{ item }" > {{ currencyFilter(item.amountTotal, item.currency.isoCode) }} </template> <template #column-stateMachineState.name="{ item }"> <sw-label :variant="getVariantFromOrderState(item)" appearance="pill" > {{ item?.stateMachineState?.translated?.name }} </sw-label> </template> <template #actions="{ item }" > <sw-context-menu-item class="sw-order-list__order-view-action" :router-link="{ name: 'sw.order.detail', params: { id: item.id } }" > {{ $tc('sw-order.list.contextMenuView') }} </sw-context-menu-item> </template> </sw-entity-listing> <sw-loader v-else-if="!todayOrderDataLoaded" /> </template> </mt-card> </template> <template v-if="hasOrderInMonth"> <sw-chart-card class="sw-dashboard-statistics__statistics-count" :available-ranges="availableRanges" :card-subtitle="getCardSubtitle(ordersDateRange)" :series="orderCountSeries" :options="chartOptionsOrderCount" :fill-empty-values="ordersDateRange.aggregate" type="line" sort position-identifier="" @sw-chart-card-range-update="onOrdersRangeUpdate" > <template #header-title> {{ $tc('sw-dashboard.monthStats.orderNumber') }} </template> <template #range-option="{ range }"> {{ $tc(\`sw-dashboard.monthStats.dateRanges.\${range}\`) }} </template> </sw-chart-card> <sw-chart-card class="sw-dashboard-statistics__statistics-sum" :available-ranges="availableRanges" :card-subtitle="getCardSubtitle(turnoverDateRange)" :series="orderSumSeries" :options="chartOptionsOrderSum" :fill-empty-values="turnoverDateRange.aggregate" type="line" sort position-identifier="" @sw-chart-card-range-update="onTurnoverRangeUpdate" > <template #header-title> {{ $tc('sw-dashboard.monthStats.turnover') }} <sw-help-text class="sw-dashboard-index__help-text" :text="$tc('sw-dashboard.monthStats.helperText')" /> </template> <template #range-option="{ range }"> {{ $tc(\`sw-dashboard.monthStats.dateRanges.\${range}\`) }} </template> </sw-chart-card> </template> </template> </div>`,{Criteria:i}=Shopware.Data,m=Shopware.Component.wrapComponentConfig({template:u,inject:["repositoryFactory","stateStyleDataProviderService","acl"],data(){return{historyOrderDataCount:null,historyOrderDataSum:null,todayOrderData:null,todayOrderDataLoaded:!1,todayOrderDataSortBy:"orderDateTime",todayOrderDataSortDirection:"DESC",ordersDateRange:{label:"30Days",range:30,interval:"day",aggregate:"day"},turnoverDateRange:{label:"30Days",range:30,interval:"day",aggregate:"day"},isLoading:!0}},computed:{rangesValueMap(){return[{label:"30Days",range:30,interval:"day",aggregate:"day"},{label:"14Days",range:14,interval:"day",aggregate:"day"},{label:"7Days",range:7,interval:"day",aggregate:"day"},{label:"24Hours",range:24,interval:"hour",aggregate:"hour"},{label:"yesterday",range:1,interval:"day",aggregate:"hour"}]},availableRanges(){return this.rangesValueMap.map(t=>t.label)},chartOptionsOrderCount(){return{xaxis:{type:"datetime",min:this.getDateAgo(this.ordersDateRange).getTime(),labels:{datetimeUTC:!1}},yaxis:{min:0,tickAmount:3,labels:{formatter:t=>parseInt(t,10)}}}},chartOptionsOrderSum(){return{xaxis:{type:"datetime",min:this.getDateAgo(this.turnoverDateRange).getTime(),labels:{datetimeUTC:!1}},yaxis:{min:0,tickAmount:5,labels:{formatter:t=>Shopware.Utils.format.currency(Number.parseFloat(t),Shopware.Context.app.systemCurrencyISOCode,2)}}}},orderRepository(){return this.repositoryFactory.create("order")},orderCountSeries(){if(!this.historyOrderDataCount)return[];const t=this.historyOrderDataCount.buckets.map(e=>({x:this.parseDate(e.key),y:e.count}));return this.todayBucketCount||t.push({x:this.today.getTime(),y:0}),[{name:this.$tc("sw-dashboard.monthStats.numberOfOrders"),data:t}]},orderCountToday(){return this.todayBucketCount?this.todayBucketCount.count:0},orderSumMonthSeries(){return this.orderSumSeries},orderSumSeries(){if(!this.historyOrderDataSum)return[];const t=this.historyOrderDataSum.buckets.map(e=>({x:this.parseDate(e.key),y:e.totalAmount.sum}));return this.todayBucketSum||t.push({x:this.today.getTime(),y:0}),[{name:this.$tc("sw-dashboard.monthStats.totalTurnover"),data:t}]},orderSumToday(){return this.todayBucketCount?this.todayBucketCount.totalAmount.sum:0},hasOrderToday(){return this.todayOrderData&&this.todayOrderData.length>0},hasOrderInMonth(){return!!this.historyOrderDataCount&&!!this.historyOrderDataSum},today(){const t=Shopware.Utils.format.dateWithUserTimezone();return t.setHours(0,0,0,0),t},todayBucketCount(){return this.calculateTodayBucket(this.historyOrderDataCount)},todayBucketSum(){return this.calculateTodayBucket(this.historyOrderDataSum)},systemCurrencyISOCode(){return Shopware.Context.app.systemCurrencyISOCode},isSessionLoaded(){var t;return!((t=Shopware.Store.get("session"))!=null&&t.userPending)},currencyFilter(){return Shopware.Filter.getByName("currency")},dateFilter(){return Shopware.Filter.getByName("date")}},watch:{isSessionLoaded:{immediate:!0,async handler(){this.isSessionLoaded&&await this.initializeOrderData()}}},methods:{calculateTodayBucket(t){const e=t==null?void 0:t.buckets;if(!e)return null;const a=this.today,s=e.find(r=>r.key?new Date(r.key).setHours(0,0,0,0)===a.setHours(0,0,0,0):!1);return s||null},async initializeOrderData(){if(!this.acl.can("order.viewer")){this.isLoading=!1;return}this.todayOrderDataLoaded=!1,await this.getHistoryOrderData(),this.todayOrderData=await this.fetchTodayData(),this.todayOrderDataLoaded=!0,this.isLoading=!1},getHistoryOrderData(){return Promise.all([this.fetchHistoryOrderDataCount().then(t=>{this.historyOrderDataCount=t}),this.fetchHistoryOrderDataSum().then(t=>{this.historyOrderDataSum=t})])},fetchHistoryOrderDataCount(){return this.fetchHistory(!1,this.formatDateToISO(this.getDateAgo(this.ordersDateRange)))},fetchHistoryOrderDataSum(){return this.fetchHistory(!0,this.formatDateToISO(this.getDateAgo(this.turnoverDateRange)))},fetchHistory(t,e){var d;const a=this.orderRepository.buildHeaders(),r=Shopware.Application.getContainer("init").httpClient,n=((d=Shopware.Store.get("session").currentUser)==null?void 0:d.timeZone)??"UTC";return r.get(`/_admin/dashboard/order-amount/${e}?timezone=${n}&paid=${t.toString()}`,{headers:a}).then(l=>({name:"order_sum_bucket",buckets:l.data.statistic.map(o=>({key:o.date,count:o.count,apiAlias:"aggregation_bucket",totalAmount:{sum:o.amount,name:"totalAmount"}})),apiAlias:"order_sum_bucket_aggregation"}))},fetchTodayData(){const t=new i(1,10);return t.addAssociation("currency"),t.addAssociation("stateMachineState"),t.addFilter(i.equals("orderDate",this.formatDateToISO(new Date))),t.addSorting(i.sort(this.todayOrderDataSortBy,this.todayOrderDataSortDirection)),this.orderRepository.search(t)},formatDateToISO(t){return Shopware.Utils.format.toISODate(t,!1)},formatChartHeadlineDate(t){const e=Shopware.Application.getContainer("factory").locale.getLastKnownLocale();return t.toLocaleDateString(e,{day:"numeric",month:"short"})},orderGridColumns(){return[{property:"orderNumber",label:"sw-order.list.columnOrderNumber",routerLink:"sw.order.detail",allowResize:!0,primary:!0},{property:"orderDateTime",dataIndex:"orderDateTime",label:"sw-dashboard.todayStats.orderTime",allowResize:!0,primary:!1},{property:"orderCustomer.firstName",dataIndex:"orderCustomer.firstName,orderCustomer.lastName",label:"sw-order.list.columnCustomerName",allowResize:!0},{property:"stateMachineState.name",label:"sw-order.list.columnState",allowResize:!0},{property:"amountTotal",label:"sw-order.list.columnAmount",align:"right",allowResize:!0}]},getVariantFromOrderState(t){var a;const e=(a=t.stateMachineState)==null?void 0:a.technicalName;return e?this.stateStyleDataProviderService.getStyle("order.state",e).variant:""},parseDate(t){return new Date(t.replace(/-/g,"/").replace("T"," ").replace(/\..*|\+.*/,"")).valueOf()},async onOrdersRangeUpdate(t){const e=this.rangesValueMap.find(a=>a.label===t);if(!e)throw Error("Range not found");this.ordersDateRange=e,this.historyOrderDataCount=await this.fetchHistoryOrderDataCount()},async onTurnoverRangeUpdate(t){const e=this.rangesValueMap.find(a=>a.label===t);if(!e)throw Error("Range not found");this.turnoverDateRange=e,this.historyOrderDataSum=await this.fetchHistoryOrderDataSum()},getCardSubtitle(t){return`${this.formatChartHeadlineDate(this.getDateAgo(t))} - ${this.formatChartHeadlineDate(this.today)}`},getDateAgo(t){const e=Shopware.Utils.format.dateWithUserTimezone();return t.interval==="hour"?(e.setHours(e.getHours()-t.range),e):(e.setDate(e.getDate()-t.range),e.setHours(0,0,0,0),e)}}});export{m as default};
