const s=`{% block sw_review_detail %} <sw-page class="sw-review-detail"> {% block sw_review_detail_header %} <template #smart-bar-header> <h2>{{ placeholder(review, 'title', $tc('sw-review.detail.textHeadline')) }}</h2> </template> {% endblock %} {% block sw_review_detail_actions %} <template #smart-bar-actions> {% block sw_review_detail_actions_abort %} <mt-button v-tooltip.bottom="tooltipCancel" variant="secondary" size="default" @click="onCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_review_detail_actions_save %} <sw-button-process v-tooltip.bottom="tooltipSave" class="sw-review-detail__save-action" variant="primary" :disabled="isLoading || !acl.can('review.editor') || undefined" :process-success="isSaveSuccessful" @update:process-success="onSaveFinish" @click="onSave" > {{ $tc('global.default.save') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_review_detail_content %} <template #content> <sw-card-view> <template v-if="isLoading"> <sw-skeleton /> <sw-skeleton variant="detail-bold" /> </template> <template v-else> {% block sw_review_detail_basic_info_card %} <mt-card v-if="review" position-identifier="sw-review-detail-basic-info" :title="$tc('sw-review.detail.cardTitleReviewInfo')" > {% block sw_customer_card_rows %} <template #grid> <sw-container rows="auto auto"> {% block sw_customer_card_row_primary %} <sw-card-section divider="bottom"> {% block sw_customer_card_metadata_container %} <sw-container> {% block sw_customer_card_metadata %} <div class="sw-review-detail__metadata"> {% block sw_customer_card_metadata_customer_name %} {% block sw_custsomer_card_metadata_customer_name_label %} <div class="sw-review-detail__metadata-review-headline"> <sw-container columns="auto 150px" gap="0px 15px" > <div class="sw-review-detail__metadata-review-title"> {{ review.title }} </div> <div v-if="stars" class="sw-review-detail__metadata-review-stars" > <sw-rating-stars :value="review.points" class="star-count-display" /> <div class="star-count-description"> {{ $tc(\`sw-review.detail.review\${Math.round(stars)}PointRatingText\`) }} </div> </div> </sw-container> </div> <p class="sw-review-detail__metadata-review-content"> {{ review.content }} </p> {% endblock %} {% endblock %} </div> {% endblock %} </sw-container> {% endblock %} </sw-card-section> {% endblock %} {% block sw_customer_card_row_secondary %} <sw-card-section secondary slim > <slot name="default"> <sw-container class="sw-review-base-info" columns="repeat(auto-fit, minmax(250px, 1fr))" gap="0px 15px" > <div class="sw-review-base-info-columns"> {% block sw_customer_base_metadata_created_at %} <sw-description-list> {% block sw_customer_base_metadata_created_at_label %} <dt class="sw-review-base-info__label"> {{ $tc('sw-review.detail.labelCreatedAt') }} </dt> {% endblock %} {% block sw_customer_base_metadata_created_at_content %} <dd> <sw-time-ago :date="review.createdAt" :date-time-format="{ month: '2-digit', day: '2-digit' }" /> </dd> {% endblock %} </sw-description-list> {% endblock %} {% block sw_customer_base_metadata_sales_channel %} <sw-description-list> {% block sw_customer_base_metadata_sales_channel_label %} <dt class="sw-review-base-info__label"> {{ $tc('sw-review.detail.labelSalesChannel') }} </dt> {% endblock %} {% block sw_customer_base_metadata_sales_channel_content %} <dd> {{ review.salesChannel.name }} </dd> {% endblock %} </sw-description-list> {% endblock %} {% block sw_customer_base_metadata_product %} <sw-description-list> {% block sw_customer_base_metadata_product_label %} <dt class="sw-review-base-info__label"> {{ $tc('sw-review.detail.labelProduct') }} </dt> {% endblock %} {% block sw_customer_base_metadata_product_content %} <dd>{{ review.product.translated.name }}</dd> {% endblock %} </sw-description-list> {% endblock %} </div> <div class="sw-review-base-info-columns"> {% block sw_customer_base_metadata_customer %} <sw-description-list> {% block sw_customer_base_metadata_customer_label %} <dt class="sw-review-base-info__label"> {{ $tc('sw-review.detail.labelCustomer') }} </dt> {% endblock %} {% block sw_customer_base_metadata_customer_content %} <dd v-if="review.customer"> {{ salutation(review.customer) }} </dd> <dd v-else> {{ review.externalUser }} </dd> {% endblock %} </sw-description-list> {% endblock %} {% block sw_customer_base_metadata_email %} <sw-description-list> {% block sw_customer_base_metadata_email_label %} <dt class="sw-review-base-info__label"> {{ $tc('sw-review.detail.labelEmail') }} </dt> {% endblock %} {% block sw_customer_base_metadata_email_content %} <dd v-if="review.customer"> {{ emailIdnFilter(review.customer.email) }} </dd> <dd v-else> {{ review.externalEmail }} </dd> {% endblock %} </sw-description-list> {% endblock %} </div> </sw-container> </slot> </sw-card-section> {% endblock %} </sw-container> </template> {% endblock %} </mt-card> {% endblock %} <mt-card v-if="review" position-identifier="sw-review-detail-properties" class="sw-review-properties" :title="$tc('sw-review.detail.cardTitleReviewProperties')" > {% block sw_review_detail_basic_info_card_description_list %} <sw-container columns="1fr 1fr" gap="16px" > {% block sw_review_detail_description_list_language %} <sw-entity-single-select id="language" v-model:value="review.languageId" name="sw-field--review-languageId" entity="language" class="sw-review__language-select" required show-clearable-button :disabled="!acl.can('review.editor') || undefined" :label="$tc('sw-review.detail.labelLanguage')" :criteria="languageCriteria" /> {% endblock %} {% block sw_review_detail_description_list_status %} <mt-switch v-model="review.status" name="sw-field--review-status" class="status-switch" :disabled="!acl.can('review.editor') || undefined" :label="$tc('sw-review.detail.labelStatus')" bordered /> {% endblock %} </sw-container> {% endblock %} </mt-card> <mt-card v-if="review" position-identifier="sw-review-detail-comment" :title="$tc('sw-review.detail.labelComment')" > {% block sw_review_detail_basic_info_card_comment %} <mt-textarea v-model="review.comment" name="sw-field--review-comment" class="sw-review__comment-field" :disabled="!acl.can('review.editor') || undefined" :label="$tc('sw-review.detail.titleCardComment')" :placeholder="$tc('sw-review.detail.placeholderComment')" /> {% endblock %} </mt-card> {% block sw_review_detail_custom_field_sets %} <mt-card v-if="showCustomFields" position-identifier="sw-review-detail-custom-field-sets" :title="$tc('sw-settings-custom-field.general.mainMenuItemGeneral')" > <sw-custom-field-set-renderer :entity="review" :disabled="!acl.can('review.editor')" :sets="customFieldSets" /> </mt-card> {% endblock %} </template> </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`,{Criteria:t}=Shopware.Data,r={template:s,inject:["repositoryFactory","acl","customFieldDataProviderService"],mixins:["placeholder","notification","salutation"],shortcuts:{"SYSTEMKEY+S":{active(){return this.acl.can("review.editor")},method:"onSave"},ESCAPE:"onCancel"},data(){return{isLoading:null,isSaveSuccessful:!1,reviewId:null,review:{},customFieldSets:null}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{identifier(){return this.review.title},repository(){return this.repositoryFactory.create("product_review")},stars(){return this.review.points>=0?this.review.points:0},languageCriteria(){const e=new t(1,25);return e.addSorting(t.sort("name","ASC",!1)),e},tooltipSave(){return this.acl.can("review.editor")?{message:`${this.$device.getSystemKey()} + S`,appearance:"light"}:{message:this.$tc("sw-privileges.tooltip.warning"),disabled:!0,showOnDisabledElements:!0}},tooltipCancel(){return{message:"ESC",appearance:"light"}},showCustomFields(){return this.review&&this.customFieldSets&&this.customFieldSets.length>0},dateFilter(){return Shopware.Filter.getByName("date")},emailIdnFilter(){return Shopware.Filter.getByName("decode-idn-email")}},watch:{"$route.params.id"(){this.createdComponent()}},created(){this.createdComponent()},methods:{createdComponent(){Shopware.ExtensionAPI.publishData({id:"sw-review-detail__review",path:"review",scope:this}),this.$route.params.id&&(this.reviewId=this.$route.params.id.toLowerCase(),this.loadEntityData(),this.loadCustomFieldSets())},loadEntityData(){this.isLoading=!0;const e=new t(1,25);e.addAssociation("customer"),e.addAssociation("salesChannel"),e.addAssociation("product");const a={...Shopware.Context.api,inheritance:!0};this.repository.get(this.reviewId,a,e).then(i=>{this.review=i,this.isLoading=!1})},loadCustomFieldSets(){this.customFieldDataProviderService.getCustomFieldSets("product_review").then(e=>{this.customFieldSets=e})},onSave(){this.isSaveSuccessful=!1;const e=this.$tc("global.notification.notificationSaveErrorMessageRequiredFieldsInvalid");this.repository.save(this.review).then(()=>{this.isSaveSuccessful=!0}).catch(()=>{this.createNotificationError({message:e})})},onSaveFinish(){this.loadEntityData(),this.isSaveSuccessful=!1},onCancel(){this.$router.push({name:"sw.review.index"})}}};export{r as default};
