const l=`{% block sw_settings_shipping_index %} <sw-page class="sw-settings-shipping-list"> {% block sw_settings_shipping_list_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="shipping_method" :placeholder="$tc('sw-settings-shipping.general.placeholderSearchBar')" :initial-search="term" @search="onSearch" /> </template> {% endblock %} {% block sw_settings_shipping_list_smart_bar_header %} <template #smart-bar-header> {% block sw_settings_shipping_list_smart_bar_header_title %} <h2> {% block sw_settings_shipping_list_smart_bar_header_title_text %} {{ $tc('sw-settings.index.title') }} <mt-icon name="regular-chevron-right-xs" size="12px" /> {{ $tc('sw-settings-shipping.list.textHeadline') }} {% endblock %} {% block sw_settings_shipping_list_smart_bar_header_amount %} <span v-if="!isLoading" class="sw-page__smart-bar-amount" > ({{ total }}) </span> {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_settings_shipping_list_smart_bar_actions %} <template #smart-bar-actions> {% block sw_settings_shipping_list_smart_bar_actions_add %} <mt-button :disabled="!acl.can('shipping.creator') || undefined" variant="primary" size="default" @click="$router.push({ name: 'sw.settings.shipping.create' })" > {{ $tc('sw-settings-shipping.list.buttonAddShippingMethod') }} </mt-button> {% endblock %} </template> {% endblock %} {% block sw_settings_shipping_list_language_switch %} <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> {% endblock %} <template #content> {% block sw_settings_shipping_list_content %} <div class="sw-settings-shipping-list__content"> {% block sw_settings_shipping_list_grid %} <sw-entity-listing v-if="entitySearchable" ref="swSettingsTaxGrid" :items="shippingMethods" :columns="columns" :repository="shippingRepository" :sort-by="currentSortBy" :sort-direction="sortDirection" :full-page="false" detail-route="sw.settings.shipping.detail" :show-selection="undefined" :show-settings="true" :allow-inline-edit="false" :allow-edit="acl.can('shipping.editor') || undefined" :allow-delete="acl.can('shipping.deleter') || undefined" :is-loading="isLoading" @column-sort="onSortColumn" > {% block sw_setting_shipping_list_grid_columns %} {% block sw_settings_shipping_list_grid_columns_active %} <template #column-active="{ item, isInlineEdit }" > {% block sw_settings_shipping_list_grid_columns_active_inline_edit %} <template v-if="isInlineEdit"> <mt-checkbox v-model:checked="item.active" /> </template> {% endblock %} {% block sw_settings_shipping_list_grid_columns_active_content %} <template v-else> <mt-icon v-if="item.active" name="regular-checkmark-xs" size="16px" class="is--active" /> <mt-icon v-else name="regular-times-s" size="16px" class="is--inactive" /> </template> {% endblock %} </template> {% endblock %} {% block sw_settings_shipping_list_grid_columns_tax_type %} <template #column-taxType="{ item, isInlineEdit }"> {% block sw_settings_shipping_list_grid_columns_tax_type_inline_edit %} <template v-if="isInlineEdit"> <sw-single-select v-model:value="item.taxType" required show-clearable-button size="small" :placeholder="$tc('sw-settings-shipping.list.placeholderTaxType')" :options="shippingCostTaxOptions" /> </template> {% endblock %} {% block sw_settings_shipping_list_grid_columns_tax_type_content %} <template v-else> {{ shippingTaxTypeLabel(item.taxType) }} </template> {% endblock %} </template> {% endblock %} {% block sw_settings_shipping_list_grid_columns_actions %} <template #actions="{ item }"> {% block sw_settings_shipping_list_grid_columns_actions_edit %} <sw-context-menu-item :router-link="{ name: 'sw.settings.shipping.detail', params: { id: item.id, edit: 'edit' }}" :disabled="!acl.can('shipping.editor') || undefined" class="sw-settings-shipping-list__edit-action" > {{ $tc('sw-settings-shipping.list.contextMenuEdit') }} </sw-context-menu-item> {% endblock %} {% block sw_settings_shipping_list_grid_columns_actions_delete %} <sw-context-menu-item variant="danger" :disabled="!acl.can('shipping.deleter') || undefined" @click="onDelete(item.id)" > {{ $tc('sw-settings-shipping.list.contextMenuDelete') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% endblock %} {% block sw_settings_shipping_list_grid_action_modals %} <template #action-modals="{ item }"> {% block sw_settings_shipping_list_delete_modal %} <sw-modal v-if="showDeleteModal === item.id" :title="$tc('global.default.warning')" variant="small" @modal-close="onCloseDeleteModal" > {% block sw_settings_shipping_list_delete_modal_confirm_delete_text %} <p class="sw-settings-shipping-list__confirm-delete-text"> {{ $tc('sw-settings-shipping.list.textDeleteConfirm', { name: item.name }, 0) }} </p> {% endblock %} {% block sw_settings_shipping_list_delete_modal_footer %} <template #modal-footer> {% block sw_settings_shipping_list_delete_modal_cancel %} <mt-button size="small" variant="secondary" @click="onCloseDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_shipping_list_delete_modal_confirm %} <mt-button variant="critical" size="small" @click="onConfirmDelete(item.id)" > {{ $tc('sw-settings-shipping.list.buttonDelete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </template> {% endblock %} </sw-entity-listing> {% endblock %} {% block sw_settings_shipping_list_empty_state %} <template v-if="!isLoading && !total"> <sw-empty-state v-if="isValidTerm(term)" :title="$tc('sw-empty-state.messageNoResultTitle')" > <template #default> {{ $tc('sw-empty-state.messageNoResultSublineBefore') }} <router-link class="sw-empty-state__description-link" :to="{ name: 'sw.profile.index.searchPreferences' }" > {{ $tc('sw-empty-state.messageNoResultSublineLink') }} </router-link> {{ $tc('sw-empty-state.messageNoResultSublineAfter') }} </template> </sw-empty-state> <sw-empty-state v-else :title="$tc('sw-settings-shipping.list.messageEmpty')" /> </template> {% endblock %} </div> {% endblock %} </template> {% block sw_settings_shipping_list_sidebar %} <template #sidebar> <sw-sidebar> {% block sw_settings_shipping_list_sidebar_refresh %} <sw-sidebar-item icon="regular-undo" :title="$tc('sw-settings-shipping.list.titleSidebarItemRefresh')" @click="onRefresh" /> {% endblock %} </sw-sidebar> </template> {% endblock %} </sw-page> {% endblock %}`,{Mixin:s,Data:{Criteria:n}}=Shopware,a={template:l,inject:["repositoryFactory","acl"],mixins:[s.getByName("listing"),s.getByName("notification")],data(){return{shippingMethods:null,isLoading:!1,sortBy:"name",sortDirection:"ASC",skeletonItemAmount:3,showDeleteModal:!1,searchConfigEntity:"shipping_method"}},metaInfo(){return{title:this.$createTitle()}},computed:{shippingRepository(){return this.repositoryFactory.create("shipping_method")},columns(){return[{property:"name",label:"sw-settings-shipping.list.columnName",inlineEdit:"string",routerLink:"sw.settings.shipping.detail",allowResize:!0,primary:!0},{property:"description",label:"sw-settings-shipping.list.columnDescription",inlineEdit:"string",allowResize:!0},{property:"taxType",label:"sw-settings-shipping.list.columnTaxType",inlineEdit:"string",allowResize:!0},{property:"active",label:"sw-settings-shipping.list.columnActive",inlineEdit:"boolean",allowResize:!0,align:"center"},{property:"position",label:"sw-settings-shipping.list.columnPosition",inlineEdit:"number",allowResize:!0,align:"center"}]},listingCriteria(){const t=new n(1,25);return this.term&&t.setTerm(this.term),t.addSorting(n.sort("name","ASC")),t},shippingCostTaxOptions(){return[{label:this.$tc("sw-settings-shipping.shippingCostOptions.auto"),value:"auto"},{label:this.$tc("sw-settings-shipping.shippingCostOptions.highest"),value:"highest"},{label:this.$tc("sw-settings-shipping.shippingCostOptions.fixed"),value:"fixed"}]}},methods:{async getList(){this.isLoading=!0;const t=await this.addQueryScores(this.term,this.listingCriteria);if(!this.entitySearchable){this.isLoading=!1,this.total=0;return}this.freshSearchTerm&&t.resetSorting(),this.shippingRepository.search(t).then(e=>(this.total=e.total,this.shippingMethods=e,e)).finally(()=>{this.isLoading=!1})},onInlineEditSave(t){this.isLoading=!0;const e=t.name||t.translated.name;return this.entityRepository.save(t).then(()=>{this.createNotificationSuccess({message:this.$tc("sw-settings-shipping.list.messageSaveSuccess",{name:e},0)})}).catch(()=>{this.createNotificationError({message:this.$tc("sw-settings-shipping.list.messageSaveError",{name:e},0)})}).finally(()=>{this.isLoading=!1})},onDelete(t){this.showDeleteModal=t},onConfirmDelete(t){const e=this.shippingMethods.find(i=>i.id===t).name;this.onCloseDeleteModal(),this.shippingRepository.delete(t).then(()=>{this.createNotificationSuccess({message:this.$tc("sw-settings-shipping.list.messageDeleteSuccess",{name:e},0)})}).catch(()=>{this.createNotificationError({message:this.$tc("sw-settings-shipping.list.messageDeleteError",{name:e},0)})}).finally(()=>{this.showDeleteModal=null,this.getList()})},onCloseDeleteModal(){this.showDeleteModal=!1},onChangeLanguage(t){Shopware.Store.get("context").api.languageId=t,this.getList()},shippingTaxTypeLabel(t){if(!t)return"";const e=this.shippingCostTaxOptions.find(i=>t===i.value)||"";return e==null?void 0:e.label}}};export{a as default};
