<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelists;

/**
 * Class representing the Text subject code qualifiers
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
class ZugferdTextSubjectCodeQualifiers
{
    /**
     * Goods item description
     */
    public const UNTDID_4451_AAA = 'AAA';

    /**
     * Payment term
     */
    public const UNTDID_4451_AAB = 'AAB';

    /**
     * Dangerous goods additional information
     */
    public const UNTDID_4451_AAC = 'AAC';

    /**
     * Dangerous goods technical name
     */
    public const UNTDID_4451_AAD = 'AAD';

    /**
     * Acknowledgement description
     */
    public const UNTDID_4451_AAE = 'AAE';

    /**
     * Rate additional information
     */
    public const UNTDID_4451_AAF = 'AAF';

    /**
     * Party instructions
     */
    public const UNTDID_4451_AAG = 'AAG';

    /**
     * General information
     */
    public const UNTDID_4451_AAI = 'AAI';

    /**
     * Additional conditions of sale/purchase
     */
    public const UNTDID_4451_AAJ = 'AAJ';

    /**
     * Price conditions
     */
    public const UNTDID_4451_AAK = 'AAK';

    /**
     * Goods dimensions in characters
     */
    public const UNTDID_4451_AAL = 'AAL';

    /**
     * Equipment re-usage restrictions
     */
    public const UNTDID_4451_AAM = 'AAM';

    /**
     * Handling restriction
     */
    public const UNTDID_4451_AAN = 'AAN';

    /**
     * Error description (free text)
     */
    public const UNTDID_4451_AAO = 'AAO';

    /**
     * Response (free text)
     */
    public const UNTDID_4451_AAP = 'AAP';

    /**
     * Package content's description
     */
    public const UNTDID_4451_AAQ = 'AAQ';

    /**
     * Terms of delivery
     */
    public const UNTDID_4451_AAR = 'AAR';

    /**
     * Bill of lading remarks
     */
    public const UNTDID_4451_AAS = 'AAS';

    /**
     * Mode of settlement information
     */
    public const UNTDID_4451_AAT = 'AAT';

    /**
     * Consignment invoice information
     */
    public const UNTDID_4451_AAU = 'AAU';

    /**
     * Clearance invoice information
     */
    public const UNTDID_4451_AAV = 'AAV';

    /**
     * Letter of credit information
     */
    public const UNTDID_4451_AAW = 'AAW';

    /**
     * License information
     */
    public const UNTDID_4451_AAX = 'AAX';

    /**
     * Certification statements
     */
    public const UNTDID_4451_AAY = 'AAY';

    /**
     * Additional export information
     */
    public const UNTDID_4451_AAZ = 'AAZ';

    /**
     * Tariff statements
     */
    public const UNTDID_4451_ABA = 'ABA';

    /**
     * Medical history
     */
    public const UNTDID_4451_ABB = 'ABB';

    /**
     * Conditions of sale or purchase
     */
    public const UNTDID_4451_ABC = 'ABC';

    /**
     * Contract document type
     */
    public const UNTDID_4451_ABD = 'ABD';

    /**
     * Additional terms and/or conditions (documentary credit)
     */
    public const UNTDID_4451_ABE = 'ABE';

    /**
     * Instructions or information about standby documentary
     */
    public const UNTDID_4451_ABF = 'ABF';

    /**
     * Instructions or information about partial shipment(s)
     */
    public const UNTDID_4451_ABG = 'ABG';

    /**
     * Instructions or information about transhipment(s)
     */
    public const UNTDID_4451_ABH = 'ABH';

    /**
     * Additional handling instructions documentary credit
     */
    public const UNTDID_4451_ABI = 'ABI';

    /**
     * Domestic routing information
     */
    public const UNTDID_4451_ABJ = 'ABJ';

    /**
     * Chargeable category of equipment
     */
    public const UNTDID_4451_ABK = 'ABK';

    /**
     * Government information
     */
    public const UNTDID_4451_ABL = 'ABL';

    /**
     * Onward routing information
     */
    public const UNTDID_4451_ABM = 'ABM';

    /**
     * Accounting information
     */
    public const UNTDID_4451_ABN = 'ABN';

    /**
     * Discrepancy information
     */
    public const UNTDID_4451_ABO = 'ABO';

    /**
     * Confirmation instructions
     */
    public const UNTDID_4451_ABP = 'ABP';

    /**
     * Method of issuance
     */
    public const UNTDID_4451_ABQ = 'ABQ';

    /**
     * Documents delivery instructions
     */
    public const UNTDID_4451_ABR = 'ABR';

    /**
     * Additional conditions
     */
    public const UNTDID_4451_ABS = 'ABS';

    /**
     * Information/instructions about additional amounts covered
     */
    public const UNTDID_4451_ABT = 'ABT';

    /**
     * Deferred payment termed additional
     */
    public const UNTDID_4451_ABU = 'ABU';

    /**
     * Acceptance terms additional
     */
    public const UNTDID_4451_ABV = 'ABV';

    /**
     * Negotiation terms additional
     */
    public const UNTDID_4451_ABW = 'ABW';

    /**
     * Document name and documentary requirements
     */
    public const UNTDID_4451_ABX = 'ABX';

    /**
     * Instructions/information about revolving documentary credit
     */
    public const UNTDID_4451_ABZ = 'ABZ';

    /**
     * Documentary requirements
     */
    public const UNTDID_4451_ACA = 'ACA';

    /**
     * Additional information
     */
    public const UNTDID_4451_ACB = 'ACB';

    /**
     * Factor assignment clause
     */
    public const UNTDID_4451_ACC = 'ACC';

    /**
     * Reason
     */
    public const UNTDID_4451_ACD = 'ACD';

    /**
     * Dispute
     */
    public const UNTDID_4451_ACE = 'ACE';

    /**
     * Additional attribute information
     */
    public const UNTDID_4451_ACF = 'ACF';

    /**
     * Absence declaration
     */
    public const UNTDID_4451_ACG = 'ACG';

    /**
     * Aggregation statement
     */
    public const UNTDID_4451_ACH = 'ACH';

    /**
     * Compilation statement
     */
    public const UNTDID_4451_ACI = 'ACI';

    /**
     * Definitional exception
     */
    public const UNTDID_4451_ACJ = 'ACJ';

    /**
     * Privacy statement
     */
    public const UNTDID_4451_ACK = 'ACK';

    /**
     * Quality statement
     */
    public const UNTDID_4451_ACL = 'ACL';

    /**
     * Statistical description
     */
    public const UNTDID_4451_ACM = 'ACM';

    /**
     * Statistical definition
     */
    public const UNTDID_4451_ACN = 'ACN';

    /**
     * Statistical name
     */
    public const UNTDID_4451_ACO = 'ACO';

    /**
     * Statistical title
     */
    public const UNTDID_4451_ACP = 'ACP';

    /**
     * Off-dimension information
     */
    public const UNTDID_4451_ACQ = 'ACQ';

    /**
     * Unexpected stops information
     */
    public const UNTDID_4451_ACR = 'ACR';

    /**
     * Principles
     */
    public const UNTDID_4451_ACS = 'ACS';

    /**
     * Terms and definition
     */
    public const UNTDID_4451_ACT = 'ACT';

    /**
     * Segment name
     */
    public const UNTDID_4451_ACU = 'ACU';

    /**
     * Simple data element name
     */
    public const UNTDID_4451_ACV = 'ACV';

    /**
     * Scope
     */
    public const UNTDID_4451_ACW = 'ACW';

    /**
     * Message type name
     */
    public const UNTDID_4451_ACX = 'ACX';

    /**
     * Introduction
     */
    public const UNTDID_4451_ACY = 'ACY';

    /**
     * Glossary
     */
    public const UNTDID_4451_ACZ = 'ACZ';

    /**
     * Functional definition
     */
    public const UNTDID_4451_ADA = 'ADA';

    /**
     * Examples
     */
    public const UNTDID_4451_ADB = 'ADB';

    /**
     * Cover page
     */
    public const UNTDID_4451_ADC = 'ADC';

    /**
     * Dependency (syntax) notes
     */
    public const UNTDID_4451_ADD = 'ADD';

    /**
     * Code value name
     */
    public const UNTDID_4451_ADE = 'ADE';

    /**
     * Code list name
     */
    public const UNTDID_4451_ADF = 'ADF';

    /**
     * Clarification of usage
     */
    public const UNTDID_4451_ADG = 'ADG';

    /**
     * Composite data element name
     */
    public const UNTDID_4451_ADH = 'ADH';

    /**
     * Field of application
     */
    public const UNTDID_4451_ADI = 'ADI';

    /**
     * Type of assets and liabilities
     */
    public const UNTDID_4451_ADJ = 'ADJ';

    /**
     * Promotion information
     */
    public const UNTDID_4451_ADK = 'ADK';

    /**
     * Meter condition
     */
    public const UNTDID_4451_ADL = 'ADL';

    /**
     * Meter reading information
     */
    public const UNTDID_4451_ADM = 'ADM';

    /**
     * Type of transaction reason
     */
    public const UNTDID_4451_ADN = 'ADN';

    /**
     * Type of survey question
     */
    public const UNTDID_4451_ADO = 'ADO';

    /**
     * Carrier's agent counter information
     */
    public const UNTDID_4451_ADP = 'ADP';

    /**
     * Description of work item on equipment
     */
    public const UNTDID_4451_ADQ = 'ADQ';

    /**
     * Message definition
     */
    public const UNTDID_4451_ADR = 'ADR';

    /**
     * Booked item information
     */
    public const UNTDID_4451_ADS = 'ADS';

    /**
     * Source of document
     */
    public const UNTDID_4451_ADT = 'ADT';

    /**
     * Note
     */
    public const UNTDID_4451_ADU = 'ADU';

    /**
     * Fixed part of segment clarification text
     */
    public const UNTDID_4451_ADV = 'ADV';

    /**
     * Characteristics of goods
     */
    public const UNTDID_4451_ADW = 'ADW';

    /**
     * Additional discharge instructions
     */
    public const UNTDID_4451_ADX = 'ADX';

    /**
     * Container stripping instructions
     */
    public const UNTDID_4451_ADY = 'ADY';

    /**
     * CSC (Container Safety Convention) plate information
     */
    public const UNTDID_4451_ADZ = 'ADZ';

    /**
     * Cargo remarks
     */
    public const UNTDID_4451_AEA = 'AEA';

    /**
     * Temperature control instructions
     */
    public const UNTDID_4451_AEB = 'AEB';

    /**
     * Text refers to expected data
     */
    public const UNTDID_4451_AEC = 'AEC';

    /**
     * Text refers to received data
     */
    public const UNTDID_4451_AED = 'AED';

    /**
     * Section clarification text
     */
    public const UNTDID_4451_AEE = 'AEE';

    /**
     * Information to the beneficiary
     */
    public const UNTDID_4451_AEF = 'AEF';

    /**
     * Information to the applicant
     */
    public const UNTDID_4451_AEG = 'AEG';

    /**
     * Instructions to the beneficiary
     */
    public const UNTDID_4451_AEH = 'AEH';

    /**
     * Instructions to the applicant
     */
    public const UNTDID_4451_AEI = 'AEI';

    /**
     * Controlled atmosphere
     */
    public const UNTDID_4451_AEJ = 'AEJ';

    /**
     * Take off annotation
     */
    public const UNTDID_4451_AEK = 'AEK';

    /**
     * Price variation narrative
     */
    public const UNTDID_4451_AEL = 'AEL';

    /**
     * Documentary credit amendment instructions
     */
    public const UNTDID_4451_AEM = 'AEM';

    /**
     * Standard method narrative
     */
    public const UNTDID_4451_AEN = 'AEN';

    /**
     * Project narrative
     */
    public const UNTDID_4451_AEO = 'AEO';

    /**
     * Radioactive goods, additional information
     */
    public const UNTDID_4451_AEP = 'AEP';

    /**
     * Bank-to-bank information
     */
    public const UNTDID_4451_AEQ = 'AEQ';

    /**
     * Reimbursement instructions
     */
    public const UNTDID_4451_AER = 'AER';

    /**
     * Reason for amending a message
     */
    public const UNTDID_4451_AES = 'AES';

    /**
     * Instructions to the paying and/or accepting and/or
     */
    public const UNTDID_4451_AET = 'AET';

    /**
     * Interest instructions
     */
    public const UNTDID_4451_AEU = 'AEU';

    /**
     * Agent commission
     */
    public const UNTDID_4451_AEV = 'AEV';

    /**
     * Remitting bank instructions
     */
    public const UNTDID_4451_AEW = 'AEW';

    /**
     * Instructions to the collecting bank
     */
    public const UNTDID_4451_AEX = 'AEX';

    /**
     * Collection amount instructions
     */
    public const UNTDID_4451_AEY = 'AEY';

    /**
     * Internal auditing information
     */
    public const UNTDID_4451_AEZ = 'AEZ';

    /**
     * Constraint
     */
    public const UNTDID_4451_AFA = 'AFA';

    /**
     * Comment
     */
    public const UNTDID_4451_AFB = 'AFB';

    /**
     * Semantic note
     */
    public const UNTDID_4451_AFC = 'AFC';

    /**
     * Help text
     */
    public const UNTDID_4451_AFD = 'AFD';

    /**
     * Legend
     */
    public const UNTDID_4451_AFE = 'AFE';

    /**
     * Batch code structure
     */
    public const UNTDID_4451_AFF = 'AFF';

    /**
     * Product application
     */
    public const UNTDID_4451_AFG = 'AFG';

    /**
     * Customer complaint
     */
    public const UNTDID_4451_AFH = 'AFH';

    /**
     * Probable cause of fault
     */
    public const UNTDID_4451_AFI = 'AFI';

    /**
     * Defect description
     */
    public const UNTDID_4451_AFJ = 'AFJ';

    /**
     * Repair description
     */
    public const UNTDID_4451_AFK = 'AFK';

    /**
     * Review comments
     */
    public const UNTDID_4451_AFL = 'AFL';

    /**
     * Title
     */
    public const UNTDID_4451_AFM = 'AFM';

    /**
     * Description of amount
     */
    public const UNTDID_4451_AFN = 'AFN';

    /**
     * Responsibilities
     */
    public const UNTDID_4451_AFO = 'AFO';

    /**
     * Supplier
     */
    public const UNTDID_4451_AFP = 'AFP';

    /**
     * Purchase region
     */
    public const UNTDID_4451_AFQ = 'AFQ';

    /**
     * Affiliation
     */
    public const UNTDID_4451_AFR = 'AFR';

    /**
     * Borrower
     */
    public const UNTDID_4451_AFS = 'AFS';

    /**
     * Line of business
     */
    public const UNTDID_4451_AFT = 'AFT';

    /**
     * Financial institution
     */
    public const UNTDID_4451_AFU = 'AFU';

    /**
     * Business founder
     */
    public const UNTDID_4451_AFV = 'AFV';

    /**
     * Business history
     */
    public const UNTDID_4451_AFW = 'AFW';

    /**
     * Banking arrangements
     */
    public const UNTDID_4451_AFX = 'AFX';

    /**
     * Business origin
     */
    public const UNTDID_4451_AFY = 'AFY';

    /**
     * Brand names' description
     */
    public const UNTDID_4451_AFZ = 'AFZ';

    /**
     * Business financing details
     */
    public const UNTDID_4451_AGA = 'AGA';

    /**
     * Competition
     */
    public const UNTDID_4451_AGB = 'AGB';

    /**
     * Construction process details
     */
    public const UNTDID_4451_AGC = 'AGC';

    /**
     * Construction specialty
     */
    public const UNTDID_4451_AGD = 'AGD';

    /**
     * Contract information
     */
    public const UNTDID_4451_AGE = 'AGE';

    /**
     * Corporate filing
     */
    public const UNTDID_4451_AGF = 'AGF';

    /**
     * Customer information
     */
    public const UNTDID_4451_AGG = 'AGG';

    /**
     * Copyright notice
     */
    public const UNTDID_4451_AGH = 'AGH';

    /**
     * Contingent debt
     */
    public const UNTDID_4451_AGI = 'AGI';

    /**
     * Conviction details
     */
    public const UNTDID_4451_AGJ = 'AGJ';

    /**
     * Equipment
     */
    public const UNTDID_4451_AGK = 'AGK';

    /**
     * Workforce description
     */
    public const UNTDID_4451_AGL = 'AGL';

    /**
     * Exemption
     */
    public const UNTDID_4451_AGM = 'AGM';

    /**
     * Future plans
     */
    public const UNTDID_4451_AGN = 'AGN';

    /**
     * Interviewee conversation information
     */
    public const UNTDID_4451_AGO = 'AGO';

    /**
     * Intangible asset
     */
    public const UNTDID_4451_AGP = 'AGP';

    /**
     * Inventory
     */
    public const UNTDID_4451_AGQ = 'AGQ';

    /**
     * Investment
     */
    public const UNTDID_4451_AGR = 'AGR';

    /**
     * Intercompany relations information
     */
    public const UNTDID_4451_AGS = 'AGS';

    /**
     * Joint venture
     */
    public const UNTDID_4451_AGT = 'AGT';

    /**
     * Loan
     */
    public const UNTDID_4451_AGU = 'AGU';

    /**
     * Long term debt
     */
    public const UNTDID_4451_AGV = 'AGV';

    /**
     * Location
     */
    public const UNTDID_4451_AGW = 'AGW';

    /**
     * Current legal structure
     */
    public const UNTDID_4451_AGX = 'AGX';

    /**
     * Marital contract
     */
    public const UNTDID_4451_AGY = 'AGY';

    /**
     * Marketing activities
     */
    public const UNTDID_4451_AGZ = 'AGZ';

    /**
     * Merger
     */
    public const UNTDID_4451_AHA = 'AHA';

    /**
     * Marketable securities
     */
    public const UNTDID_4451_AHB = 'AHB';

    /**
     * Business debt
     */
    public const UNTDID_4451_AHC = 'AHC';

    /**
     * Original legal structure
     */
    public const UNTDID_4451_AHD = 'AHD';

    /**
     * Employee sharing arrangements
     */
    public const UNTDID_4451_AHE = 'AHE';

    /**
     * Organization details
     */
    public const UNTDID_4451_AHF = 'AHF';

    /**
     * Public record details
     */
    public const UNTDID_4451_AHG = 'AHG';

    /**
     * Price range
     */
    public const UNTDID_4451_AHH = 'AHH';

    /**
     * Qualifications
     */
    public const UNTDID_4451_AHI = 'AHI';

    /**
     * Registered activity
     */
    public const UNTDID_4451_AHJ = 'AHJ';

    /**
     * Criminal sentence
     */
    public const UNTDID_4451_AHK = 'AHK';

    /**
     * Sales method
     */
    public const UNTDID_4451_AHL = 'AHL';

    /**
     * Educational institution information
     */
    public const UNTDID_4451_AHM = 'AHM';

    /**
     * Status details
     */
    public const UNTDID_4451_AHN = 'AHN';

    /**
     * Sales
     */
    public const UNTDID_4451_AHO = 'AHO';

    /**
     * Spouse information
     */
    public const UNTDID_4451_AHP = 'AHP';

    /**
     * Educational degree information
     */
    public const UNTDID_4451_AHQ = 'AHQ';

    /**
     * Shareholding information
     */
    public const UNTDID_4451_AHR = 'AHR';

    /**
     * Sales territory
     */
    public const UNTDID_4451_AHS = 'AHS';

    /**
     * Accountant's comments
     */
    public const UNTDID_4451_AHT = 'AHT';

    /**
     * Exemption law location
     */
    public const UNTDID_4451_AHU = 'AHU';

    /**
     * Share classifications
     */
    public const UNTDID_4451_AHV = 'AHV';

    /**
     * Forecast
     */
    public const UNTDID_4451_AHW = 'AHW';

    /**
     * Event location
     */
    public const UNTDID_4451_AHX = 'AHX';

    /**
     * Facility occupancy
     */
    public const UNTDID_4451_AHY = 'AHY';

    /**
     * Import and export details
     */
    public const UNTDID_4451_AHZ = 'AHZ';

    /**
     * Additional facility information
     */
    public const UNTDID_4451_AIA = 'AIA';

    /**
     * Inventory value
     */
    public const UNTDID_4451_AIB = 'AIB';

    /**
     * Education
     */
    public const UNTDID_4451_AIC = 'AIC';

    /**
     * Event
     */
    public const UNTDID_4451_AID = 'AID';

    /**
     * Agent
     */
    public const UNTDID_4451_AIE = 'AIE';

    /**
     * Domestically agreed financial statement details
     */
    public const UNTDID_4451_AIF = 'AIF';

    /**
     * Other current asset description
     */
    public const UNTDID_4451_AIG = 'AIG';

    /**
     * Other current liability description
     */
    public const UNTDID_4451_AIH = 'AIH';

    /**
     * Former business activity
     */
    public const UNTDID_4451_AII = 'AII';

    /**
     * Trade name use
     */
    public const UNTDID_4451_AIJ = 'AIJ';

    /**
     * Signing authority
     */
    public const UNTDID_4451_AIK = 'AIK';

    /**
     * Guarantee
     */
    public const UNTDID_4451_AIL = 'AIL';

    /**
     * Holding company operation
     */
    public const UNTDID_4451_AIM = 'AIM';

    /**
     * Consignment routing
     */
    public const UNTDID_4451_AIN = 'AIN';

    /**
     * Letter of protest
     */
    public const UNTDID_4451_AIO = 'AIO';

    /**
     * Question
     */
    public const UNTDID_4451_AIP = 'AIP';

    /**
     * Party information
     */
    public const UNTDID_4451_AIQ = 'AIQ';

    /**
     * Area boundaries description
     */
    public const UNTDID_4451_AIR = 'AIR';

    /**
     * Advertisement information
     */
    public const UNTDID_4451_AIS = 'AIS';

    /**
     * Financial statement details
     */
    public const UNTDID_4451_AIT = 'AIT';

    /**
     * Access instructions
     */
    public const UNTDID_4451_AIU = 'AIU';

    /**
     * Liquidity
     */
    public const UNTDID_4451_AIV = 'AIV';

    /**
     * Credit line
     */
    public const UNTDID_4451_AIW = 'AIW';

    /**
     * Warranty terms
     */
    public const UNTDID_4451_AIX = 'AIX';

    /**
     * Division description
     */
    public const UNTDID_4451_AIY = 'AIY';

    /**
     * Reporting instruction
     */
    public const UNTDID_4451_AIZ = 'AIZ';

    /**
     * Examination result
     */
    public const UNTDID_4451_AJA = 'AJA';

    /**
     * Laboratory result
     */
    public const UNTDID_4451_AJB = 'AJB';

    /**
     * Allowance/charge information
     */
    public const UNTDID_4451_ALC = 'ALC';

    /**
     * X-ray result
     */
    public const UNTDID_4451_ALD = 'ALD';

    /**
     * Pathology result
     */
    public const UNTDID_4451_ALE = 'ALE';

    /**
     * Intervention description
     */
    public const UNTDID_4451_ALF = 'ALF';

    /**
     * Summary of admittance
     */
    public const UNTDID_4451_ALG = 'ALG';

    /**
     * Medical treatment course detail
     */
    public const UNTDID_4451_ALH = 'ALH';

    /**
     * Prognosis
     */
    public const UNTDID_4451_ALI = 'ALI';

    /**
     * Instruction to patient
     */
    public const UNTDID_4451_ALJ = 'ALJ';

    /**
     * Instruction to physician
     */
    public const UNTDID_4451_ALK = 'ALK';

    /**
     * All documents
     */
    public const UNTDID_4451_ALL = 'ALL';

    /**
     * Medicine treatment
     */
    public const UNTDID_4451_ALM = 'ALM';

    /**
     * Medicine dosage and administration
     */
    public const UNTDID_4451_ALN = 'ALN';

    /**
     * Availability of patient
     */
    public const UNTDID_4451_ALO = 'ALO';

    /**
     * Reason for service request
     */
    public const UNTDID_4451_ALP = 'ALP';

    /**
     * Purpose of service
     */
    public const UNTDID_4451_ALQ = 'ALQ';

    /**
     * Arrival conditions
     */
    public const UNTDID_4451_ARR = 'ARR';

    /**
     * Service requester's comment
     */
    public const UNTDID_4451_ARS = 'ARS';

    /**
     * Authentication
     */
    public const UNTDID_4451_AUT = 'AUT';

    /**
     * Requested location description
     */
    public const UNTDID_4451_AUU = 'AUU';

    /**
     * Medicine administration condition
     */
    public const UNTDID_4451_AUV = 'AUV';

    /**
     * Patient information
     */
    public const UNTDID_4451_AUW = 'AUW';

    /**
     * Precautionary measure
     */
    public const UNTDID_4451_AUX = 'AUX';

    /**
     * Service characteristic
     */
    public const UNTDID_4451_AUY = 'AUY';

    /**
     * Planned event comment
     */
    public const UNTDID_4451_AUZ = 'AUZ';

    /**
     * Expected delay comment
     */
    public const UNTDID_4451_AVA = 'AVA';

    /**
     * Transport requirements comment
     */
    public const UNTDID_4451_AVB = 'AVB';

    /**
     * Temporary approval condition
     */
    public const UNTDID_4451_AVC = 'AVC';

    /**
     * Customs Valuation Information
     */
    public const UNTDID_4451_AVD = 'AVD';

    /**
     * Value Added Tax (VAT) margin scheme
     */
    public const UNTDID_4451_AVE = 'AVE';

    /**
     * Maritime Declaration of Health
     */
    public const UNTDID_4451_AVF = 'AVF';

    /**
     * Passenger baggage information
     */
    public const UNTDID_4451_BAG = 'BAG';

    /**
     * Maritime Declaration of Health
     */
    public const UNTDID_4451_BAH = 'BAH';

    /**
     * Additional product information address
     */
    public const UNTDID_4451_BAI = 'BAI';

    /**
     * Information to be printed on despatch advice
     */
    public const UNTDID_4451_BAJ = 'BAJ';

    /**
     * Missing goods remarks
     */
    public const UNTDID_4451_BAK = 'BAK';

    /**
     * Non-acceptance information
     */
    public const UNTDID_4451_BAL = 'BAL';

    /**
     * Returns information
     */
    public const UNTDID_4451_BAM = 'BAM';

    /**
     * Sub-line item information
     */
    public const UNTDID_4451_BAN = 'BAN';

    /**
     * Test information
     */
    public const UNTDID_4451_BAO = 'BAO';

    /**
     * External link
     */
    public const UNTDID_4451_BAP = 'BAP';

    /**
     * VAT exemption reason
     */
    public const UNTDID_4451_BAQ = 'BAQ';

    /**
     * Processing Instructions
     */
    public const UNTDID_4451_BAR = 'BAR';

    /**
     * Relay Instructions
     */
    public const UNTDID_4451_BAS = 'BAS';

    /**
     * Transport contract document clause
     */
    public const UNTDID_4451_BLC = 'BLC';

    /**
     * Instruction to prepare the patient
     */
    public const UNTDID_4451_BLD = 'BLD';

    /**
     * Medicine treatment comment
     */
    public const UNTDID_4451_BLE = 'BLE';

    /**
     * Examination result comment
     */
    public const UNTDID_4451_BLF = 'BLF';

    /**
     * Service request comment
     */
    public const UNTDID_4451_BLG = 'BLG';

    /**
     * Prescription reason
     */
    public const UNTDID_4451_BLH = 'BLH';

    /**
     * Prescription comment
     */
    public const UNTDID_4451_BLI = 'BLI';

    /**
     * Clinical investigation comment
     */
    public const UNTDID_4451_BLJ = 'BLJ';

    /**
     * Medicinal specification comment
     */
    public const UNTDID_4451_BLK = 'BLK';

    /**
     * Economic contribution comment
     */
    public const UNTDID_4451_BLL = 'BLL';

    /**
     * Status of a plan
     */
    public const UNTDID_4451_BLM = 'BLM';

    /**
     * Random sample test information
     */
    public const UNTDID_4451_BLN = 'BLN';

    /**
     * Period of time
     */
    public const UNTDID_4451_BLO = 'BLO';

    /**
     * Legislation
     */
    public const UNTDID_4451_BLP = 'BLP';

    /**
     * Security measures requested
     */
    public const UNTDID_4451_BLQ = 'BLQ';

    /**
     * Transport contract document remark
     */
    public const UNTDID_4451_BLR = 'BLR';

    /**
     * Previous port of call security information
     */
    public const UNTDID_4451_BLS = 'BLS';

    /**
     * Security information
     */
    public const UNTDID_4451_BLT = 'BLT';

    /**
     * Waste information
     */
    public const UNTDID_4451_BLU = 'BLU';

    /**
     * B2C marketing information, short description
     */
    public const UNTDID_4451_BLV = 'BLV';

    /**
     * B2B marketing information, long description
     */
    public const UNTDID_4451_BLW = 'BLW';

    /**
     * B2C marketing information, long description
     */
    public const UNTDID_4451_BLX = 'BLX';

    /**
     * Product ingredients
     */
    public const UNTDID_4451_BLY = 'BLY';

    /**
     * Location short name
     */
    public const UNTDID_4451_BLZ = 'BLZ';

    /**
     * Packaging material information
     */
    public const UNTDID_4451_BMA = 'BMA';

    /**
     * Filler material information
     */
    public const UNTDID_4451_BMB = 'BMB';

    /**
     * Ship-to-ship activity information
     */
    public const UNTDID_4451_BMC = 'BMC';

    /**
     * Package material description
     */
    public const UNTDID_4451_BMD = 'BMD';

    /**
     * Consumer level package marking
     */
    public const UNTDID_4451_BME = 'BME';

    /**
     * Customs clearance instructions
     */
    public const UNTDID_4451_CCI = 'CCI';

    /**
     * Customs clearance instructions export
     */
    public const UNTDID_4451_CEX = 'CEX';

    /**
     * Change information
     */
    public const UNTDID_4451_CHG = 'CHG';

    /**
     * Customs clearance instruction import
     */
    public const UNTDID_4451_CIP = 'CIP';

    /**
     * Clearance place requested
     */
    public const UNTDID_4451_CLP = 'CLP';

    /**
     * Loading remarks
     */
    public const UNTDID_4451_CLR = 'CLR';

    /**
     * Order information
     */
    public const UNTDID_4451_COI = 'COI';

    /**
     * Customer remarks
     */
    public const UNTDID_4451_CUR = 'CUR';

    /**
     * Customs declaration information
     */
    public const UNTDID_4451_CUS = 'CUS';

    /**
     * Damage remarks
     */
    public const UNTDID_4451_DAR = 'DAR';

    /**
     * Document issuer declaration
     */
    public const UNTDID_4451_DCL = 'DCL';

    /**
     * Delivery information
     */
    public const UNTDID_4451_DEL = 'DEL';

    /**
     * Delivery instructions
     */
    public const UNTDID_4451_DIN = 'DIN';

    /**
     * Documentation instructions
     */
    public const UNTDID_4451_DOC = 'DOC';

    /**
     * Duty declaration
     */
    public const UNTDID_4451_DUT = 'DUT';

    /**
     * Effective used routing
     */
    public const UNTDID_4451_EUR = 'EUR';

    /**
     * First block to be printed on the transport contract
     */
    public const UNTDID_4451_FBC = 'FBC';

    /**
     * Government bill of lading information
     */
    public const UNTDID_4451_GBL = 'GBL';

    /**
     * Entire transaction set
     */
    public const UNTDID_4451_GEN = 'GEN';

    /**
     * Further information concerning GGVS par. 7
     */
    public const UNTDID_4451_GS7 = 'GS7';

    /**
     * Consignment handling instruction
     */
    public const UNTDID_4451_HAN = 'HAN';

    /**
     * Hazard information
     */
    public const UNTDID_4451_HAZ = 'HAZ';

    /**
     * Consignment information for consignee
     */
    public const UNTDID_4451_ICN = 'ICN';

    /**
     * Insurance instructions
     */
    public const UNTDID_4451_IIN = 'IIN';

    /**
     * Invoice mailing instructions
     */
    public const UNTDID_4451_IMI = 'IMI';

    /**
     * Commercial invoice item description
     */
    public const UNTDID_4451_IND = 'IND';

    /**
     * Insurance information
     */
    public const UNTDID_4451_INS = 'INS';

    /**
     * Invoice instruction
     */
    public const UNTDID_4451_INV = 'INV';

    /**
     * Information for railway purpose
     */
    public const UNTDID_4451_IRP = 'IRP';

    /**
     * Inland transport details
     */
    public const UNTDID_4451_ITR = 'ITR';

    /**
     * Testing instructions
     */
    public const UNTDID_4451_ITS = 'ITS';

    /**
     * Location Alias
     */
    public const UNTDID_4451_LAN = 'LAN';

    /**
     * Line item
     */
    public const UNTDID_4451_LIN = 'LIN';

    /**
     * Loading instruction
     */
    public const UNTDID_4451_LOI = 'LOI';

    /**
     * Miscellaneous charge order
     */
    public const UNTDID_4451_MCO = 'MCO';

    /**
     * Maritime Declaration of Health
     */
    public const UNTDID_4451_MDH = 'MDH';

    /**
     * Additional marks/numbers information
     */
    public const UNTDID_4451_MKS = 'MKS';

    /**
     * Order instruction
     */
    public const UNTDID_4451_ORI = 'ORI';

    /**
     * Other service information
     */
    public const UNTDID_4451_OSI = 'OSI';

    /**
     * Packing/marking information
     */
    public const UNTDID_4451_PAC = 'PAC';

    /**
     * Payment instructions information
     */
    public const UNTDID_4451_PAI = 'PAI';

    /**
     * Payables information
     */
    public const UNTDID_4451_PAY = 'PAY';

    /**
     * Packaging information
     */
    public const UNTDID_4451_PKG = 'PKG';

    /**
     * Packaging terms information
     */
    public const UNTDID_4451_PKT = 'PKT';

    /**
     * Payment detail/remittance information
     */
    public const UNTDID_4451_PMD = 'PMD';

    /**
     * Payment information
     */
    public const UNTDID_4451_PMT = 'PMT';

    /**
     * Product information
     */
    public const UNTDID_4451_PRD = 'PRD';

    /**
     * Price calculation formula
     */
    public const UNTDID_4451_PRF = 'PRF';

    /**
     * Priority information
     */
    public const UNTDID_4451_PRI = 'PRI';

    /**
     * Purchasing information
     */
    public const UNTDID_4451_PUR = 'PUR';

    /**
     * Quarantine instructions
     */
    public const UNTDID_4451_QIN = 'QIN';

    /**
     * Quality demands/requirements
     */
    public const UNTDID_4451_QQD = 'QQD';

    /**
     * Quotation instruction/information
     */
    public const UNTDID_4451_QUT = 'QUT';

    /**
     * Risk and handling information
     */
    public const UNTDID_4451_RAH = 'RAH';

    /**
     * Regulatory information
     */
    public const UNTDID_4451_REG = 'REG';

    /**
     * Return to origin information
     */
    public const UNTDID_4451_RET = 'RET';

    /**
     * Receivables
     */
    public const UNTDID_4451_REV = 'REV';

    /**
     * Consignment route
     */
    public const UNTDID_4451_RQR = 'RQR';

    /**
     * Safety information
     */
    public const UNTDID_4451_SAF = 'SAF';

    /**
     * Consignment documentary instruction
     */
    public const UNTDID_4451_SIC = 'SIC';

    /**
     * Special instructions
     */
    public const UNTDID_4451_SIN = 'SIN';

    /**
     * Ship line requested
     */
    public const UNTDID_4451_SLR = 'SLR';

    /**
     * Special permission for transport, generally
     */
    public const UNTDID_4451_SPA = 'SPA';

    /**
     * Special permission concerning the goods to be transported
     */
    public const UNTDID_4451_SPG = 'SPG';

    /**
     * Special handling
     */
    public const UNTDID_4451_SPH = 'SPH';

    /**
     * Special permission concerning package
     */
    public const UNTDID_4451_SPP = 'SPP';

    /**
     * Special permission concerning transport means
     */
    public const UNTDID_4451_SPT = 'SPT';

    /**
     * Subsidiary risk number (IATA/DGR)
     */
    public const UNTDID_4451_SRN = 'SRN';

    /**
     * Special service request
     */
    public const UNTDID_4451_SSR = 'SSR';

    /**
     * Supplier remarks
     */
    public const UNTDID_4451_SUR = 'SUR';

    /**
     * Consignment tariff
     */
    public const UNTDID_4451_TCA = 'TCA';

    /**
     * Consignment transport
     */
    public const UNTDID_4451_TDT = 'TDT';

    /**
     * Transportation information
     */
    public const UNTDID_4451_TRA = 'TRA';

    /**
     * Requested tariff
     */
    public const UNTDID_4451_TRR = 'TRR';

    /**
     * Tax declaration
     */
    public const UNTDID_4451_TXD = 'TXD';

    /**
     * Warehouse instruction/information
     */
    public const UNTDID_4451_WHI = 'WHI';

    /**
     * Mutually defined
     */
    public const UNTDID_4451_ZZZ = 'ZZZ';
}
