const l=`{% block sw_product_detail_prices %} <div v-if="isLoading"> <sw-skeleton /> <sw-skeleton /> </div> <sw-container v-else rows="auto" columns="100%" class="sw-product-detail-context-prices" > {% block sw_product_detail_prices_price_card %} <sw-container v-if="priceRuleGroupsExists" columns="100%" > <mt-card v-for="(priceGroup, key, index) in priceRuleGroups" :key="priceGroup.ruleId" class="context-price" position-identifier="sw-product-detail-context-prices-context-price" :class="getPriceRuleGroupClass(index)" :title="priceGroup.rule ? priceGroup.rule.name : $tc('sw-product.prices.cardTitlePriceRule')" :large="true" > <template #grid> {% block sw_product_detail_prices_price_card_toolbar %} <div class="sw-product-detail-context-prices__toolbar"> <sw-container columns="1fr minmax(50px, max-content) minmax(50px, max-content)" gap="0 10px" > {% block sw_product_detail_prices_price_card_toolbar_rule_selection %} <sw-select-rule-create v-if="rules.entity" id="rule" :rule-id="priceGroup.ruleId" :placeholder="$tc('sw-product.advancedPrices.selectRule')" :disabled="!acl.can('product.editor')" class="sw-product-detail-context-prices__toolbar-selection" size="small" rule-aware-group-key="productPrices" :restricted-rule-ids="Object.keys(priceRuleGroups)" :restricted-rule-ids-tooltip-label="$tc('sw-product.advancedPrices.ruleAlreadyUsed')" @save-rule="onRuleChange($event, priceGroup.ruleId)" /> {% endblock %} {% block sw_product_detail_prices_price_card_toolbar_rule_delete %} <mt-button v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('product.editor'), showOnDisabledElements: true }" size="small" :disabled="!acl.can('product.editor')" variant="secondary" @click="onPriceGroupDelete(priceGroup.ruleId)" > {{ $tc('sw-product.prices.buttonPriceRuleDelete') }} </mt-button> {% endblock %} {% block sw_product_detail_prices_price_card_toolbar_add_price_rule %} <mt-button v-if="canAddPriceRule" v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('product.editor'), showOnDisabledElements: true }" class="sw-product-detail-context-prices__toolbar-duplicate" size="small" :disabled="priceGroup.ruleId === null || !acl.can('product.editor')" variant="secondary" @click="onPriceGroupDuplicate(priceGroup)" > {{ $tc('sw-product.prices.buttonPriceRuleDuplicate') }} </mt-button> {% endblock %} </sw-container> </div> {% endblock %} {% block sw_product_detail_prices_price_card_price_group_grid %} <sw-data-grid v-if="priceGroup.ruleId" :data-source="priceGroup.prices" :columns="pricesColumns" show-settings :show-selection="false" :compact-mode="true" > {% block sw_product_detail_prices_price_card_price_group_grid_settings %} <template #additionalSettings> {% block sw_product_detail_prices_price_card_price_group_grid_settings_list_prices %} <mt-switch :model-value="showListPrices[priceGroup.ruleId] !== false" remove-top-margin :label="$tc('sw-product.prices.settingShowListPrices')" @update:model-value="onChangeShowListPrices($event, priceGroup.ruleId)" /> {% endblock %} </template> {% endblock %} {% block sw_product_detail_prices_price_card_price_group_grid_type %} <template #column-type="{ item, itemIndex, compact }" > <div class="sw-product-detail-context-prices__type-label"> <label>{{ $tc('sw-product.advancedPrices.advancedListPricePriceLabel') }}</label> <label v-if="showListPrices[priceGroup.ruleId] !== false"> {{ $tc('sw-product.advancedPrices.advancedListPriceLabel') }} </label> <label v-if="showListPrices[priceGroup.ruleId] !== false"> {{ $tc('sw-product.advancedPrices.labelRegulationPrice') }} </label> </div> </template> {% endblock %} {% block sw_product_detail_prices_price_card_price_group_grid_quantity_start %} <template #column-quantityStart="{ item, itemIndex, compact }" > {% block sw_product_detail_prices_price_card_price_group_grid_quantity_start_field %} <mt-number-field v-model="item.quantityStart" v-tooltip="getStartQuantityTooltip(itemIndex, item.quantityStart)" :name="\`\${item.ruleId}-\${item.quantityStart}-quantityStart\`" validation="required" :min="priceGroup.prices[itemIndex - 1] ? priceGroup.prices[itemIndex - 1].quantityEnd + 1 : 1" :max="item.quantityEnd ? item.quantityEnd : null" :size="compact ? 'small' : 'default'" :disabled="(itemIndex === 0 && item.quantityStart === 1) || !acl.can('product.editor')" /> {% endblock %} </template> {% endblock %} {% block sw_product_detail_prices_price_card_price_group_grid_quantity_end %} <template #column-quantityEnd="{ item, itemIndex, compact }" > {% block sw_product_detail_prices_price_card_price_group_grid_quantity_end_field %} <mt-number-field v-model="item.quantityEnd" :validation="item.quantityEnd === null || item.quantityEnd > item.quantityStart" placeholder="∞" :name="\`\${item.ruleId}-\${item.quantityStart}-quantityEnd\`" :min="item.quantityStart" :max="priceGroup.prices[itemIndex + 1] ? priceGroup.prices[itemIndex + 1].quantityStart - 1 : null" :size="compact ? 'small' : 'default'" :disabled="!acl.can('product.editor')" @update:model-value="onQuantityEndChange(item, priceGroup)" /> {% endblock %} </template> {% endblock %} {% block sw_product_detail_prices_price_card_price_group_grid_currencies_list %} <template v-for="currency in currencies" :key="currency.id" #[\`column-price-\${currency.isoCode}\`]="{ item, column, compact }" > <template v-if="showListPrices[priceGroup.ruleId] === false"> <div class="product-detail-context-prices__price-field-wrapper" > {% block sw_product_detail_prices_price_card_price_group_grid_currencies_list_inherit_field %} <sw-inheritance-switch v-if="!currency.isSystemDefault" class="sw-product-detail-context-prices__inherited-icon" :is-inherited="isPriceFieldInherited(item, currency)" :disabled="!acl.can('product.editor')" @inheritance-restore="onInheritanceRestore(item, currency)" @inheritance-remove="onInheritanceRemove(item, currency)" /> {% endblock %} {% block sw_product_detail_prices_price_card_price_group_grid_currencies_list_price_field %} <sw-price-field :value="item.price" :default-price="findDefaultPriceOfRule(item)" :tax-rate="productTaxRate" :label="false" :compact="compact" :name="\`\${item.ruleId}-\${currency.isoCode}-\${item.quantityStart}\`" :currency="currency" :disabled="!acl.can('product.editor')" /> {% endblock %} </div> </template> <template v-if="showListPrices[priceGroup.ruleId] !== false"> <div :key="\`else-\${currency}\`" class="product-detail-context-prices__price-field-wrapper" > <sw-inheritance-switch v-if="!currency.isSystemDefault" class="sw-product-detail-context-prices__inherited-icon" :is-inherited="isPriceFieldInherited(item, currency)" :disabled="!acl.can('product.editor')" @inheritance-restore="onInheritanceRestore(item, currency)" @inheritance-remove="onInheritanceRemove(item, currency)" /> <sw-list-price-field :price="item.price" :default-price="findDefaultPriceOfRule(item)" :vertical="true" :tax-rate="productTaxRate" :label="false" :compact="compact" :disabled="!acl.can('product.editor')" :currency="currency" hide-purchase-prices /> </div> </template> </template> {% endblock %} {% block sw_product_detail_prices_price_card_price_group_grid_actions %} <template #actions="{ item }" > {% block sw_product_detail_prices_price_card_price_group_grid_actions_delete %} <sw-context-menu-item variant="danger" class="product-detail-context-prices__context-delete" :disabled="!acl.can('product.editor')" @click="onPriceRuleDelete(item)" > {{ $tc('sw-product.prices.contextMenuDelete') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} </sw-data-grid> {% endblock %} {% block sw_product_detail_prices_price_card_price_group_empty_state %} <div v-else class="sw-product-detail-context-prices__empty-state" > {% block sw_product_detail_prices_price_card_price_group_empty_state_warning %} <p>{{ $tc('sw-product.advancedPrices.newRuleWarning') }}</p> {% endblock %} </div> {% endblock %} </template> </mt-card> {% block sw_product_detail_prices_price_card_price_group_add_price_rule %} <sw-container justify="center" columns="250x" > {% block sw_product_detail_prices_price_card_price_group_add_price_rule_button %} <mt-button v-if="canAddPriceRule" v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('product.editor'), showOnDisabledElements: true }" class="sw-product-detail-context-prices__add-new-rule" ghost :disabled="emptyPriceRuleExists || !acl.can('product.editor')" size="small" variant="secondary" @click="onAddNewPriceGroup(null)" > {{ $tc('sw-product.prices.buttonAddAdditionalPriceRuleGroup') }} </mt-button> {% endblock %} </sw-container> {% endblock %} </sw-container> <mt-card v-else class="sw-product-detail-context-prices__empty-state-card" position-identifier="sw-product-detail-context-prices-empty-state-card" > {% block sw_product_detail_prices_price_empty_state %} <div class="sw-product-detail-context-prices__empty-state"> {% block sw_product_detail_prices_empty_state_image %} <img :src="assetFilter('/administration/administration/static/img/empty-states/products-empty-state.svg')" alt="" > {% endblock %} {% block sw_product_detail_prices_price_empty_state_text %} <template v-if="isChild"> {% block sw_product_detail_prices_price_empty_state_text_child %} <template v-if="isInherited"> {% block sw_product_detail_prices_price_empty_state_text_inherited %} <p>{{ $tc('sw-product.advancedPrices.advancedPricesInherited') }}</p> {% block sw_product_detail_prices_price_empty_state_text_link %} <router-link v-if="isInherited" :to="{ name: 'sw.product.detail.prices', params: { id: product.parentId } }" class="sw-product-detail-context-prices__parent-prices-link" > {{ $tc('sw-product.advancedPrices.linkAdvancedPricesOfParent') }} <mt-icon name="regular-long-arrow-right" size="16px" /> </router-link> {% endblock %} {% endblock %} </template> <template v-else> {% block sw_product_detail_prices_price_empty_state_text_not_inherited %} <p>{{ $tc('sw-product.advancedPrices.advancedPricesNotInherited') }}</p> {% endblock %} </template> {% endblock %} </template> <template v-else> {% block sw_product_detail_prices_price_empty_state_text_empty %} <p>{{ $tc('sw-product.advancedPrices.advancedPricesNotExisting') }}</p> {% endblock %} </template> {% endblock %} {% block sw_product_detail_prices_price_empty_state__inherit_switch %} <template v-if="isChild"> <div class="sw-product-detail-context-prices__inherit-toggle-wrapper" :class="{ 'is--inherited': isInherited }" > <mt-switch v-model="isInherited" class="sw-product-detail-context-prices__inherit-switch" :disabled="!acl.can('product.editor')" /> <sw-inheritance-switch class="sw-product-detail-context-prices__inheritance-icon" :is-inherited="isInherited" :disabled="!acl.can('product.editor')" @inheritance-restore="restoreInheritance" @inheritance-remove="removeInheritance" /> <label class="sw-product-detail-context-prices__inheritance-label"> {{ $tc('sw-product.advancedPrices.inheritSwitchLabel') }} </label> </div> </template> {% endblock %} {% block sw_product_detail_prices_price_empty_state_select_rule %} <sw-select-rule-create v-if="rules.entity" id="rule" class="sw-product-detail-context-prices__empty-state-select-rule" :placeholder="$tc('sw-product.advancedPrices.selectRule')" :disabled="isInherited || !acl.can('product.editor')" rule-aware-group-key="productPrices" :restricted-rule-ids="Object.keys(priceRuleGroups)" :restricted-rule-ids-tooltip-label="$tc('sw-product.advancedPrices.ruleAlreadyUsed')" @save-rule="onAddNewPriceGroup($event)" /> {% endblock %} </div> {% endblock %} </mt-card> {% endblock %} </sw-container> {% endblock %}`,{Mixin:d}=Shopware,{Criteria:s}=Shopware.Data,o={template:l,inject:["repositoryFactory","acl","feature"],mixins:[d.getByName("notification")],props:{isSetDefaultPrice:{type:Boolean,required:!1,default:!1},canSetLoadingRules:{type:Boolean,required:!1,default:!0}},data(){return{rules:[],totalRules:0,isInherited:!1,showListPrices:{}}},computed:{product(){return Shopware.Store.get("swProductDetail").product},parentProduct(){return Shopware.Store.get("swProductDetail").parentProduct},taxes(){return Shopware.Store.get("swProductDetail").taxes},currencies(){return Shopware.Store.get("swProductDetail").currencies},isLoading(){return Shopware.Store.get("swProductDetail").isLoading},defaultCurrency(){return Shopware.Store.get("swProductDetail").defaultCurrency},defaultPrice(){return Shopware.Store.get("swProductDetail").defaultPrice},productTaxRate(){return Shopware.Store.get("swProductDetail").productTaxRate},isChild(){return Shopware.Store.get("swProductDetail").isChild},priceRepository(){return this.product&&this.product.prices?this.repositoryFactory.create(this.product.prices.entity,this.product.prices.source):null},ruleRepository(){return this.repositoryFactory.create("rule")},priceRuleGroups(){const e={};return!this.product.prices||!this.rules||(this.product.prices.toSorted((r,i)=>{const c=this.findRuleById(r.ruleId),a=this.findRuleById(i.ruleId);return!c||!c.name||!a||!a.name?0:c.name>a.name?1:-1}).forEach(r=>{e[r.ruleId]||(e[r.ruleId]={ruleId:r.ruleId,rule:this.findRuleById(r.ruleId),prices:this.findPricesByRuleId(r.ruleId)})}),Object.values(e).forEach(r=>{r.prices.sort((i,c)=>i.quantityStart-c.quantityStart)})),e},priceRuleGroupsExists(){return Object.values(this.priceRuleGroups).length>0},canAddPriceRule(){const e=Object.keys(this.priceRuleGroups).length,t=this.rules.length;return e!==t},emptyPriceRuleExists(){return typeof this.priceRuleGroups.null<"u"},isLoaded(){return!this.isLoading&&this.currencies&&this.taxes&&this.product},currencyColumns(){return this.sortCurrencies(),this.currencies.map(e=>({property:`price-${e.isoCode}`,label:e.translated.name||e.name,visible:!0,allowResize:!0,primary:!1,rawData:!1,width:"270px",multiLine:!0}))},pricesColumns(){return[...[{property:"quantityStart",label:"sw-product.advancedPrices.columnFrom",visible:!0,allowResize:!0,primary:!0,rawData:!1,width:"120px"},{property:"quantityEnd",label:"sw-product.advancedPrices.columnTo",visible:!0,allowResize:!0,primary:!0,rawData:!1,width:"120px"},{property:"type",label:"sw-product.advancedPrices.columnType",visible:!0,allowResize:!0,width:"250px",multiLine:!0}],...this.currencyColumns]},assetFilter(){return Shopware.Filter.getByName("asset")}},watch:{"product.prices":{handler(e){e&&(this.isInherited=this.isChild&&!this.product.prices.total)},immediate:!0}},mounted(){this.mountedComponent()},methods:{mountedComponent(){const e=new s(1,500);e.addFilter(s.multi("OR",[s.contains("rule.moduleTypes.types","price"),s.equals("rule.moduleTypes",null)])),this.canSetLoadingRules&&Shopware.Store.get("swProductDetail").setLoading(["rules",!0]),this.ruleRepository.search(e).then(t=>{this.rules=t,this.totalRules=t.total,Shopware.Store.get("swProductDetail").setLoading(["rules",!1])}),this.isInherited=this.isChild&&!this.product.prices.total},sortCurrencies(){this.currencies.sort((e,t)=>e.isSystemDefault?-1:t.isSystemDefault?1:e.translated.name<t.translated.name?-1:e.translated.name>t.translated.name?1:0)},onRuleChange(e,t){const r=()=>{this.product.prices.forEach(i=>{i.ruleId===t&&(i.ruleId=e)})};this.$nextTick(()=>{r()})},async onAddNewPriceGroup(e=null){if(await this.$nextTick(),this.emptyPriceRuleExists)return;const t=this.priceRepository.create();t.ruleId=e,t.productId=this.product.id,t.quantityStart=1,t.quantityEnd=null,t.currencyId=this.defaultCurrency.id,t.price=[{currencyId:this.defaultCurrency.id,gross:this.isSetDefaultPrice?0:this.defaultPrice.gross,linked:this.defaultPrice.linked,net:this.isSetDefaultPrice?0:this.defaultPrice.net,listPrice:null}],this.defaultPrice.listPrice&&(t.price[0].listPrice={currencyId:this.defaultCurrency.id,gross:this.defaultPrice.listPrice.gross,linked:this.defaultPrice.listPrice.linked,net:this.defaultPrice.listPrice.net}),this.product.prices.add(t),await this.$nextTick();const r=this.$parent.$el.children.item(0);r&&r.scrollTo({top:r.scrollHeight,behavior:"smooth"})},onPriceGroupDelete(e){this.product.prices.map(r=>({id:r.id,ruleId:r.ruleId})).forEach(r=>{e===r.ruleId&&this.product.prices.remove(r.id)})},onPriceGroupDuplicate(e){typeof this.priceRuleGroups.null<"u"||e.prices.forEach(t=>{this.duplicatePriceRule(t,null)})},onPriceRuleDelete(e){const t=this.priceRuleGroups[e.ruleId];if(t.prices.length<=1){this.createNotificationError({message:this.$tc("sw-product.advancedPrices.deletionNotPossibleMessage")});return}const r=t.prices.indexOf(e);if(typeof e.quantityEnd>"u"||e.quantityEnd===null){const i=t.prices[r-1];i.quantityEnd=null}else{const i=t.prices[r+1];i.quantityStart=e.quantityStart}this.product.prices.remove(e.id)},onInheritanceRestore(e,t){const r=e.price.findIndex(i=>i.currencyId===t.id);e.price.splice(r,1)},onInheritanceRemove(e,t){const r=this.findDefaultPriceOfRule(e),i={currencyId:t.id,gross:this.convertPrice(r.gross,t),linked:r.linked,net:this.convertPrice(r.net,t),listPrice:null};r.listPrice&&(i.listPrice={currencyId:t.id,gross:this.convertPrice(r.listPrice.gross,t),linked:r.listPrice.linked,net:this.convertPrice(r.listPrice.net,t)}),e.price[e.price.length]=i},isPriceFieldInherited(e,t){return e.price.findIndex(r=>r.currencyId===t.id)<0},convertPrice(e,t){const i=(e*t.factor).toFixed(t.decimalPrecision);return Number(i)},findRuleById(e){return this.rules.find(t=>t.id===e)},findPricesByRuleId(e){return this.product.prices.filter(t=>t.ruleId===e)},findDefaultPriceOfRule(e){return e.price.find(t=>t.currencyId===this.defaultCurrency.id)},onQuantityEndChange(e,t){t.prices.indexOf(e)+1===t.prices.length&&this.createPriceRule(t)},createPriceRule(e){const t=this.priceRepository.create();t.productId=this.product.id,t.ruleId=e.ruleId;const r=Math.max(...e.prices.map(i=>i.quantityEnd));t.quantityStart=r+1,t.price=[{currencyId:this.defaultCurrency.id,gross:this.defaultPrice.gross,linked:this.defaultPrice.linked,net:this.defaultPrice.net,listPrice:null}],this.defaultPrice.listPrice&&(t.price[0].listPrice={currencyId:this.defaultCurrency.id,gross:this.defaultPrice.listPrice?this.defaultPrice.listPrice.gross:null,linked:this.defaultPrice.listPrice?this.defaultPrice.listPrice.linked:!0,net:this.defaultPrice.listPrice?this.defaultPrice.listPrice.net:null}),this.product.prices.add(t)},canCreatePriceRule(e){return!!e.prices.filter(r=>!r.quantityEnd).length},duplicatePriceRule(e,t=null){const r=this.priceRepository.create();r.productId=e.productId,r.quantityEnd=e.quantityEnd,r.quantityStart=e.quantityStart,r.ruleId=t,r.price=[],e.price.forEach((i,c)=>{r.price[c]={...i}}),this.product.prices.add(r)},getPriceRuleGroupClass(e){return[`context-price-group-${e}`]},restoreInheritance(){this.isInherited=!0},removeInheritance(){this.isInherited=!1},onChangeShowListPrices(e,t){this.showListPrices[t]=e},getStartQuantityTooltip(e,t){return{message:this.$tc("sw-product.advancedPrices.advancedPriceDisabledTooltip"),width:275,showDelay:200,disabled:e!==0||t!==1}}}};export{o as default};
