<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Tervetuloa keskustelualueelle {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Kiitos rekisteröitymisestä keskustelualueelle {FORUMNAME}. Käyttäjänimesi on {USERNAME}. Jos unohdat salasanasi, saat asetettua uuden tästä: {FORGOTPASSWORDLINK}.

Ennen kuin voit kirjautua, sinun pitää ensin aktivoida tilisi valitsemalla seuraava linkki:

{ACTIVATIONLINK}

Jos sinulla on ongelmia tilisi aktivoinnin kanssa, mene sivulle {ACTIVATIONLINKWITHOUTCODE} ja syötä koodi "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Tervetuloa keskustelualueelle {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Rekisteröitymishakemuksesi keskustelualueelle {FORUMNAME} on otettu vastaan, {REALNAME}.

Rekisteröimäsi käyttäjänimi oli {USERNAME}.

Ennen kuin voit kirjautua sisään ja aloittaa keskustelualueen käytön, hakemuksesi tarkistetaan ja hyväksytään. Sen tapahduttua saat toisen sähköpostin tästä samasta osoitteesta.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Ryhmän jäsenyyden hyväksyminen';
$txt['mc_group_approve_body'] = '{USERNAME}, ilmoitamme ilolla sinulle, että pyyntösi liittyä ryhmään "{GROUPNAME}" foorumilla {FORUMNAME} on hyväksytty ja sinun käyttäjätilisi on päivitetty sisältämään tämän uuden jäsenryhmän. {REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Ryhmän jäsenyyden evääminen';
$txt['mc_group_reject_body'] = '{USERNAME}, valitettavasti ilmoitamme sinulle, että pyyntösi liittyä ryhmään "{GROUPNAME}" foorumilla {FORUMNAME} on evätty. {REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Ryhmään liittymisen evääminen';
$txt['mc_group_reject_reason_body'] = '{USERNAME},  valitettavasti ilmoitamme sinulle, että pyyntösi liittyä ryhmään "{GROUPNAME}" foorumilla {FORUMNAME} on evätty. Tämän syy on seuraava: {REASON} {REGARDS}
';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Tervetuloa foorumille {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Tervetuloa, {NAME} Ylläpitäjä aktivoi manuaalisti käyttäjätilisi ja voi nyt kirjautua ja kirjoittaa viestejä. Käyttäjänimesi on: {USERNAME}. Jos unohdat salasanasi, voit vaihtaa sen täällä: {FORGOTPASSWORDLINK}. {REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Tervetuloa foorumille {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Tervetuloa, {USERNAME}! Tilisi foorumille {FORUMNAME} on foorumin ylläpitäjän hyväksymä. Ennen kuin voit kirjautua sisään, sinun pitää ensin aktivoida tilisi valitsemalla oheinen linkki: {ACTIVATIONLINK} Jos sinulla on jotain ongelmia aktivoinnin kanssa, ole hyvä ja vieraile täällä: {ACTIVATIONLINKWITHOUTCODE} ja anna siellä koodi "{ACTIVATIONCODE}". {REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Rekisteröinti evätty';
$txt['admin_approve_reject_body'] = '{USERNAME}, valitettavasti anomuksesi liittyä foorumille {FORUMNAME} on torjuttu. {REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Tili poistettu';
$txt['admin_approve_delete_body'] = '{USERNAME}, tilisi foorumilla {FORUMNAME} on poistettu. Näin on ehkä tapahtunut siksi, ettet ole ikinä aktivoinut tiliäsi. Siinä tapauksessa sinä voit rekisteröityä uudestaan. {REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Muistutus rekisteröinnistä';
$txt['admin_approve_remind_body'] = '{USERNAME}, et ole vielä aktivoinnut tiliäsi foorumille {FORUMNAME}. Ole hyvä ja käytä oheista linkkiä tilisi aktivointiin: {ACTIVATIONLINK} Jos sinulla on aktivoinnissa ongelmia, vieraile täällä {ACTIVATIONLINKWITHOUTCODE} ja anna koodi "{ACTIVATIONCODE}". {REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Tervetuloa foorumille {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Kiitos rekisteröitymisestäsi foorumille {FORUMNAME}. Käyttäjänimesi on {USERNAME} ja salasanasi on {PASSWORD}. Ennen kuin voit kirjautua sisään, sinun pitää ensin aktivoida tilisi valitsemalla tämä linkki: {ACTIVATIONLINK} Jos sinulla on jotain ongelmia aktivoinnin kanssa, ole hyvä jäa vieraile täällä: {ACTIVATIONLINKWITHOUTCODE} ja anna siellä koodi "{ACTIVATIONCODE}". {REGARDS}';

$txt['admin_register_immediate_subject'] = 'Tervetuloa foorumille {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Kiitos rekisteröitymisestä foorumilel {FORUMNAME}. Käyttäjänimesi on {USERNAME}, salasanasi on {PASSWORD} ja foorumin osoite on: {SCRIPTURL}. {REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Uusi ilmoitus: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE} Lopettaaksesi näiden ilmoitusten tilaamisen kirjoittaudu foorumille ja ota ruksi pois kohdasta "Ota vastaan ilmoituksia ja merkittäviä tiedotuksia sähköpostilla. Voit nähdä koko ilmoituksen seuraamalla linkkiä: {TOPICLINK} {REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Uusi aihe: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Uusi aihe, \'{TOPICSUBJECT}\', on ilmestynyt alueelle, jota seuraat. Voit nähdä sen täällä: {TOPICLINK} Lisää aiheita voi olla ilmestynyt, mutta et saa enempää sähköpostimuistutuksia ennen kuin palaat alueelle ja luet jonkun niistä. Aiheen otsikko näytetään tässä: {MESSAGE} Voit lopettaa uusien aiheiden seuraamisen tästä linkistä: {UNSUBSCRIBELINK} {REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Uusi aihe: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Uusi aihe, \'{TOPICSUBJECT}\', on ilmestynyt alueelle, jota seuraat. Voit nähdä sen täällä: {TOPICLINK} Lisää aiheita voi olla ilmestynyt, mutta et saa enempää sähköpostimuistutuksia ennen kuin palaat alueelle ja luet jonkun niistä. Voit lopettaa uusien aiheiden seuraamisen tästä linkistä: {UNSUBSCRIBELINK} {REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Uusi aihe: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Uusi aihe, \'{TOPICSUBJECT}\', on ilmestynyt alueelle, jota seuraat. Voit nähdä sen täällä: {TOPICLINK} Aiheen otsikko näytetään tässä: {MESSAGE} Voit lopettaa uusien aiheiden seuraamisen tästä linkistä: {UNSUBSCRIBELINK} {REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Uusi aihe: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Uusi aihe, \'{TOPICSUBJECT}\', on ilmestynyt alueelle, jota seuraat. Voit nähdä sen täällä: {TOPICLINK} Voit lopettaa uusien aiheiden seuraamisen tästä linkistä: {UNSUBSCRIBELINK} {REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Vastaus aiheeseen: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = 'Jäsen {POSTERNAME} on laittanut uuden vastauksen aiheeseen \'{SUBJECT}\'. Näet sen täältä: {LINK} {REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Uusi hyväksymätön liite täällä: {SUBJECT}';
$txt['unapproved_attachment_body'] = ' Aiheessa \'{SUBJECT}\' on uusi hyväksymätön liite, mikä pitää hyväksyä. Voit hyväksyä tai hylätä tämän liitteen alla olevassa viestissä, johon se kuuluu {LINK} {REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Uusi hyväksymätön viesti: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'On tullut uusi viesti, mikä pitää hyväksyä: \'{SUBJECT}\' Voit hyväksyä tai hylätä tämän viestin tästä linkistä: {LINK} {REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Uusi hyväksymätön aihe: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'On ilmestynyt uusi aihe, joka pitää hyväksyä: \'{SUBJECT}\' Voit hyväksyä tai hylätä tämän aiheen tästä linkistä: {LINK} {REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Uusi ryhmän anomus';
$txt['request_membership_body'] = '{RECPNAME}, {APPYNAME} on pyytänyt liittyä ryhmään "{GROUPNAME}". Jäsen on kertonut tämän syyksi: {REASON} Voit hyväksyä tai hylätä tämän aiheen tästä linkistä: {MODLINK} {REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Tilauksesi foorumille {FORUMNAME} on päättymässä';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

Your subscription at {FORUMNAME} is about to expire. If you have elected to auto-renew, you do not need to take action; otherwise, you may wish to consider subscribing once more. Details are below:

Subscription Name: {SUBSCRIPTION}
Expires: {END_DATE}

To edit your subscriptions visit the following URL:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Tervetuloa takaisin foorumille {FORUMNAME}';
$txt['activate_reactivate_body'] = 'Vahvistaaksesi uudestaan sähköpostisi tilisi ei ole nyt käytössä. Klikkaa oheista linkkiä aktivoidaksesi se uudestaan : {ACTIVATIONLINK} Jos sinulla on ongelmia aktivoinnissa, vieraile täällä: {ACTIVATIONLINKWITHOUTCODE} ja käytä koodia "{ACTIVATIONCODE}". {REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Uusi salasana foorumille {FORUMNAME}';
$txt['forgot_password_body'] = 'Hyvä {REALNAME}, Tämä viesti lähetettiin koska tilillesi käytettiin funktiota \'unohtunut salasana\'. Asettaaksesi uuden salasanan, mene tänne: {REMINDLINK} IP: {IP} Käyttäjänimi: {MEMBERNAME} {REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Raportoitu viesti: {TOPICSUBJECT} , kirjoittaja: {POSTERNAME}';
$txt['report_to_moderator_body'] = 'Seuraavasta {POSTERNAME} kirjoittamasta viestistä "{TOPICSUBJECT}" raportoi käyttäjä {REPORTERNAME} alueella, jota valvot. Aihe: {TOPICLINK} Valvontakeskus: {REPORTLINK} Raportoija on kommentoinut assiaa seuraavasti: {COMMENT} {REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Raportoidun viestin seuranta: {TOPICSUBJECT} käyttäjältä {POSTERNAME}';
$txt['reply_to_moderator_body'] = 'Aiemmin raportoitiin aiheesta "{TOPICSUBJECT}" valvojille. Sen jälkeen {COMMENTERNAME} on kommentoinut raporttia. Enemmän tietoa löydät foorumilta. Aihe: {TOPICLINK} Valvontakeskus: {REPORTLINK} {REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Raportoitu profiili: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'Jäsen {REPORTERNAME} on raportoinut käyttäjän "{MEMBERNAME}" profiilista. Profiili: {PROFILELINK} Valvontakeskus: {REPORTLINK} Raportoija on kommentoinut asiaa seuraavasti: {COMMENT} {REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Raportoidun profiilin seuranta: {MEMBERNAME}';
$txt['reply_to_member_report_body'] = 'Aiemmin raportoitiin käyttäjän {MEMBERNAME} profiilista valvojille. Sen jälkeen {COMMENTERNAME} on kommentoinut raporttia. Enemmän tietoa löydät foorumilta. Profiili: {PROFILELINK} Valvontakeskus: {REPORTLINK} {REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Uuden salasanan yksityiskohdat';
$txt['change_password_body'] = 'Hyvä {USERNAME}, kirjautumisen yksityiskohdat foorumille {FORUMNAME} ovat muuttuneet ja salasanasi on nollattu. Alta löydät kirjautumisesi yksityiskohdat. Käyttäjänimesi on "{USERNAME}" ja salasanasi on  "{PASSWORD}". Voit muuttaa sitä kirjautumisen jälkeen menemällä proffilisi sivulle tai vierailemalla tällä sivulla kirjautumisen jälkeen: {SCRIPTURL}?action=profile {REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Tervetuloa foorumille {FORUMNAME}';
$txt['register_activate_body'] = 'Kiitos rekisteröitymisestä foorumille {FORUMNAME}. Käyttäjänimesi on {USERNAME}. Jos unohdat salasanasi, voit nollata sen vierailemalla täällä: {FORGOTPASSWORDLINK}. Ennen kuin voit kirjautua, sinun pitää ensin aktivoida tilisi. Tehdäksesi tämä vieraile täällä: {ACTIVATIONLINK} Jos sinulla on jotain pulmia aktivoinnin kanssa, vieraile täällä: {ACTIVATIONLINKWITHOUTCODE} ja käytä koodia "{ACTIVATIONCODE}". {REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Tervetuloa foorumille {FORUMNAME}';
$txt['register_coppa_body'] = 'Kiitos rekisteröitymisestä foorumille {FORUMNAME}. Käyttäjänimesi on {USERNAME}. Jos unohdat salasanasi, voit nollata sen vierailemalla täällä: {FORGOTPASSWORDLINK}. Ennen kuin voit kirjautua, ylläpitäjä edellyttää vanhemman/huoltajan hyväksyvän liittymisesi foorumille. Saat enemmän tietoa asiasta linkistä: {COPPALINK} {REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Tervetuloa foorumille {FORUMNAME}';
$txt['register_immediate_body'] = 'Kiitos rekisteröitymisestä foorumille {FORUMNAME}. Käyttäjänimesi on {USERNAME}. Jos unohdat salasanasi, voit vaihtaa sen täältä: {FORGOTPASSWORDLINK}. {REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Tervetuloa foorumille {FORUMNAME}';
$txt['register_pending_body'] = 'Hei {REALNAME}, sinun rekisteröitymispyyntösi foorumille {FORUMNAME} on vastaanotettu. Olet rekisteröitynyt käyttäjänimellä {USERNAME}. Jos unohdat salasanasi, voit vaihtaa sen täällä: {FORGOTPASSWORDLINK}. Ennen kuin voit kirjautua sisään ja ryhtyä foorumin käyttäjäksi, sinun rekisteröitymispyyntösi käsitellään ja hyväksytään. Kun se on hoidettu, saat toisen viestin tästä osoitteesta.{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Vastaus aiheeseen: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'Käyttäjä {POSTERNAME} on lähettänyt vastauksen seuraamaasi aiheeseen. Katso vastausta täällä: {TOPICLINK} Voit perua aiheen seuraamisen tästä linkistä: {UNSUBSCRIBELINK} {REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Vastaus aiheeseen: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'Käyttäjä {POSTERNAME} on lähettänyt vastauksen seuraamaasi aiheeseen. Katso vastausta täällä: {TOPICLINK} Voit perua aiheen seuraamisen tästä linkistä: {UNSUBSCRIBELINK} Vastauksen teksti näkyy täällä: {MESSAGE} {REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Vastaus aiheeseen: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'Käyttäjä {POSTERNAME} on lähettänyt vastauksen seuraamaasi aiheeseen. Katso vastausta täällä: {TOPICLINK} Voit perua aiheen seuraamisen tästä linkistä: {UNSUBSCRIBELINK} Ehkä useampi vastaus on lähetetty, mutta et saa niistä lisää muistutuksia ennen kuin luet aiheen viestit {REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Vastaus aiheeseen: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'Käyttäjä {POSTERNAME} on lähettänyt vastauksen seuraamaasi aiheeseen. Katso vastausta täällä: {TOPICLINK} Voit perua aiheen seuraamisen tästä linkistä: {UNSUBSCRIBELINK} astauksen teksti näkyy täällä: {MESSAGE} Ehkä useampi vastaus on lähetetty, mutta et saa niistä lisää muistutuksia ennen kuin luet aiheen viestit {REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Aihe laitettu pysyväksi: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Seuraamasi aihe on merkitty pysyväksi aiheeksi. Katso aihetta täältä: {TOPICLINK} Peru aiheen seuraaminen täältä: {UNSUBSCRIBELINK} {REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Aihe lukittu: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Seuraamasi aihe on lukittu. Katso aihetta täältä: {TOPICLINK} Peru aiheen seuraaminen täältä: {UNSUBSCRIBELINK} {REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = '	Aihe lukittu: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Seuraamasi aiheen lukitus on purettu. Katso aihetta täältä: {TOPICLINK} Peru aiheen seuraaminen täältä: {UNSUBSCRIBELINK} {REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Aihe poistettu: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Seuraamasi aihe on poistettu. {REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Aihe siirretty: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Seuraamasi aihe on siirretty toiselle alueelle. Katso aihetta täältä: {TOPICLINK} Peru aiheen seuraaminen täältä: {UNSUBSCRIBELINK} {REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Aihe yhdistetty: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Seuraamasi aihe on yhdistetty toiseen aiheeseen. Katso aihetta täältä: {TOPICLINK} Peru aiheen seuraaminen täältä: {UNSUBSCRIBELINK} {REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Aihe jaettu: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Seuraamasi aihe on jaettu kahteen tai useampaan aiheeseen. Katso aihetta täältä: {TOPICLINK} Peru aiheen seuraaminen täältä: {UNSUBSCRIBELINK} {REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Uusi jäsen on liittynyt';
$txt['admin_notify_body'] = '{USERNAME} on liittynyt uutena jäsenenä foorumillesi. Klikkaa tänne katsoaksesi hänen profiiliaan: {PROFILELINK} {REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Uusi jäsen on liittynyt';
$txt['admin_notify_approval_body'] = '{USERNAME} on liittynyt uutena jäsenenä foorumillesi. Klikkaa tänne katsoaksesi hänen profiiliaan: {PROFILELINK} Ennen kuin jäsen voi alkaa lähettää viestejä foorumille hänen tilinsä pitää hyväksyä. Klikkaa tänne mennäksesi hyväksymisikkunaan: {APPROVALLINK} {REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Kiireellinen! Liitteiden hakemisto melkein täynnä';
$txt['admin_attachments_full_body'] = '{REALNAME}, liitteiden hakemisto foorumilla {FORUMNAME} on melkein täynnä. Ole hyvä ja vieraile foorumilla ratkaistaksesi tämän pulman. Kun liitteiden hakemisto saavuttaa sallitun maksimikoon, käyttäjät eivät voi laittaa liitteitä tai asettaa omia avattaria (jos ovat sallittuja). {REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Maksetun tilauksen hyvitys';
$txt['paid_subscription_refund_body'] = '{REALNAME}, käyttäjä on saanut hyvitystä maksetusta tilauksesta. Alla ovat tilauksen yksityiskohdat: Tilaus: {NAME} Käyttäjän nimi: {REFUNDNAME} ({REFUNDUSER}) Päiväys: {DATE} Voit tarkastella tämän käyttäjän profiilia alla olevasta linkistä: {PROFILELINK} {REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Uusi maksettu tilaus';
$txt['paid_subscription_new_body'] = '{REALNAME}, käyttäjä on ottanut uuden maksetun tilauksen. Below are the details of this subscription: Tilaus: {NAME} Käyttäjän nimi: {SUBNAME} ({SUBUSER}) Käyttäjän sähköposti: {SUBEMAIL} Hinta: {PRICE} Päiväys: {DATE} Voit tarkastella tämän käyttäjän profiilia alla olevasta linkistä: {PROFILELINK} {REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Sattui virhe maksetussa tilauksessa';
$txt['paid_subscription_error_body'] = 'Hyvä {REALNAME}, Seuraava virhe tapahtui maksullisen tilauksen käsittelyssä --------------------------------------------------------------- {ERROR} {REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Uusi yksityisviesti: {SUBJECT}';
$txt['new_pm_body'] = 'Olet juuri saanut yksityisviestin foorumin {FORUMNAME} käyttäjältä {SENDER}. TÄRKEÄÄ, muista, että tämä on vain muistutus asiasta. Ole hyvä äläkä vastaa tähän viestiin. Lue yksityisviestisi täällä: {READLINK} Vastaa yksityisviestiin täällä: {REPLYLINK} {REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Uusi yksityisviesti: {SUBJECT}';
$txt['new_pm_body_body'] = 'Olet juuri saanut yksityisviestin käyttäjältä {SENDER} foorumilla {FORUMNAME} TÄRKEÄÄ: Huomaa että tämä on vain muistutus. Älä vastaa tähän sähköpostiin. Lähetetty viesti oli tämä: {MESSAGE} Vastaa tähän yksityisviestiin täällä: {REPLYLINK} {REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Uusi yksityisviesti: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'Sinä ja nämä {TOLIST} olette juuri saaneet yksityisviestin käyttäjältä {SENDER} foorumilla {FORUMNAME} TÄRKEÄÄ: Huomaa että tämä on vain muistutus. Älä vastaa tähän sähköpostiin. Lue viesti täältä: {MESSAGE} Vastaa tähän yksityisviestiin (vain lähettäjälle) täällä: {REPLYLINK} {REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Uusi yksityisviesti: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'Sinä ja nämä {TOLIST} olette juuri saaneet yksityisviestin käyttäjältä {SENDER} foorumilla {FORUMNAME} TÄRKEÄÄ: Huomaa että tämä on vain muistutus. Älä vastaa tähän sähköpostiin. Lähetetty viesti oli tämä: {MESSAGE} Vastaa tähän yksityisviestiin (vain lähettäjälle) täällä: {REPLYLINK} {REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Sinua on lainattu tässä viestissä: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Hei {MEMBERNAME}, sinua on lainattu viestissä otsikoltaan "{CONTENTSUBJECT}" jonka kirjotti {QUOTENAME}, voit nähdä viestin täällä: {CONTENTLINK} {REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Sinut on mainittu tässä viestissä: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Hei {MEMBERNAME}, sinut on mainittu viestissä otsikoltaan "{CONTENTSUBJECT}" jonka kirjotti {MENTIONNAME}, voit nähdä viestin täällä: {CONTENTLINK} {REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'Hyvää syntymäpäivää, toivottaa foorumi {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Hyvä {REALNAME}, me tällä foorumilla {FORUMNAME} haluamme toivottaa sinulle hyvää syntymäpäivää. Olkoon tämä päivä ja tuleva vuosi täynnä iloa. {REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'Syntymäpäivänäsi…';
$txtBirthdayEmails['karlbenson1_body'] = 'Me olisimme voineet lähettää sinulle syntymäpäiväkortin. Me olisimme voineet lähettää sinulle kukkia tai kakun. Mutta emme tehneet sitä. Me olisimme ainakin voineet lähettää sinulle jonkun niistä automaattisesti luodun syntymäpäiväviestin, johon meidän ei edes tarvitse lisätä nimeä. Mutta emme tehneet sitä. Me kirjoitimme tämän syntymäpäivätoivotuksen juuri sinulle. Me haluamme toivoa sinulle oikein erityistä syntymäpäivää.  {REGARDS} //:: Tämä viesti on luotu automaattisesti :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Hyvää syntymäpäivää!';
$txtBirthdayEmails['nite0859_body'] = 'Sinun ystäväsi foorumilla {FORUMNAME} haluavat tarttua tilaisuuteen ja toivottaa sinulle hyvää syntymäpäivää, {REALNAME}. Jos et ole tehnyt tätä hiljan, ole hyvä ja vieraile foorumillamme välittääksesi lämpimät toivotukset. Vaikka tänään on syntymäpäiväsi, {REALNAME},  me haluamme muistuttaa sinua, että jäsenyytesi foorumilla on ollut meille paras lahja tähän mennessä. Parasta toivoen, foorumin {FORUMNAME} henkilökunta';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Syntymäpäiväonnittelut jäsenelle {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Hyvä {REALNAME}, jäleen on kulunut vuosi elämääsi. Me foorumilla {FORUMNAME} toivomme sen sujuneen onnellisesti ja toivomme onnea tulevana vuonna. {REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Hyvää syntymäpäivää, {REALNAME!';
$txtBirthdayEmails['geezmo_body'] = 'Tiedätkö kenellä on tänään syntymäpäivä, {REALNAME}? Me tiedämm… SINULLA! Hyvää syntymäpäivää! Olet nyt vuotta vanhempi mutta toivomme, että olet paljon onnellisempi kuin edeltäneenä vuonna. Nauti tästä päivästä, {REALNAME}! - Sinun foorumisi {FORUMNAME} perheeltä';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Syntymäpäiväonnittelut';
$txtBirthdayEmails['karlbenson2_body'] = 'Toivomme että syntymäpäiväsi on paras, olipa pilvistä, aurinkoista tai mitä tahansa säätä. Olkoon sinulla paljon synttärikakkua ja haussa ja kerro meille, mitä olet tehnyt. Me toivomme että tämä viesti toi sinulle iloa ja että se kestää aina vuoden päästä samaan paikkaan ja aikaan. {REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>