<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Üdvözöl a {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Köszönjük, hogy regisztrált a {FORUMNAME} oldalon. A felhasználóneved {USERNAME}. Ha elfelejtetted a jelszavadat, akkor azt a {FORGOTPASSWORDLINK} oldalon tudod visszaállítani.

Mielőtt bejelentkezhetnél, először aktiválnod kell a fiókodat az alábbi linkre kattintva:

{ACTIVATIONLINK}

Amennyiben az aktiválással bármilyen problémád adódna, kérjük, látogass el a {ACTIVATIONLINKWITHOUTCODE} oldalra, és írd be a "{ACTIVATIONCODE}" kódot.

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Üdvözöl a {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Szia {REALNAME}, regisztrációs kérelmedet a {FORUMNAME}-nél megkaptuk.

A felhasználónév, amellyel regisztráltál, {USERNAME} volt.

Mielőtt bejelentkezhetnél és elkezdhetnéd használni a fórumot, a kérésedet átnézzük és jóváhagyjuk.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Csoporttagság jóváhagyása';
$txt['mc_group_approve_body'] = '{USERNAME},

We\'re pleased to notify you that your application to join the "{GROUPNAME}" group at {FORUMNAME} has been accepted, and your account has been updated to include this new membergroup.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Csoporttagság elutasítása';
$txt['mc_group_reject_body'] = '{USERNAME},

We\'re sorry to notify you that your application to join the "{GROUPNAME}" group at {FORUMNAME} has been rejected.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Csoporttagság elutasítása';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

We\'re sorry to notify you that your application to join the "{GROUPNAME}" group at {FORUMNAME} has been rejected.

This is due to the following reason: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Üdvözöl a {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Üdvözöllek, {NÉV}

Az adminisztrátor manuálisan aktiválta a fiókodat, és most már be tudsz jelentkezni és hozzászólhatsz. A felhasználóneved: {USERNAME}. Ha elfelejtetted a jelszavadat, a {FORGOTPASSWORDLINK} címen tudod megváltoztatni.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Üdvözöl a {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Üdvözöljük, {USERNAME}!

A fórum adminisztrátora jóváhagyta a fiókodat a {FORUMNAME} oldalon. Mielőtt bejelentkezhetnél, először aktiválnod kell a fiókodat az alábbi linkre kattintva:

{ACTIVATIONLINK}

Ha bármilyen problémád adódna az aktiválással, kérjük, látogass el a {ACTIVATIONLINKWITHOUTCODE} oldalra, és add meg a "{ACTIVATIONCODE}" kódot.

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Regisztráció elutasítva';
$txt['admin_approve_reject_body'] = '{USERNAME},

Regrettably, your application to join {FORUMNAME} has been rejected.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'A fiók törlésre került';
$txt['admin_approve_delete_body'] = '{USERNAME},

Your account on {FORUMNAME} has been deleted. This may be because you never activated your account, in which case you should be able to register again.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Regisztrációs emlékeztető';
$txt['admin_approve_remind_body'] = '{USERNAME},
You still have not activated your account at {FORUMNAME}.

Please use the link below to activate your account:
{ACTIVATIONLINK}

Should you have any problems with the activation, please visit {ACTIVATIONLINKWITHOUTCODE} and enter the code "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Üdvözöl a {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Köszönjük, hogy regisztráltál a {FORUMNAME} oldalon. A felhasználóneved {USERNAME} és a jelszavad {PASSWORD}.

Mielőtt bejelentkezhetnél, először aktiválnod kell a fiókodat az alábbi linkre kattintva:

{ACTIVATIONLINK}

Amennyiben az aktiválással bármilyen problémád adódna, kérjük, látogass el a {ACTIVATIONLINKWITHOUTCODE} oldalra, és írd be a "{ACTIVATIONCODE}" kódot.

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Üdvözöl a {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Köszönjük, hogy regisztráltál a {FORUMNAME} oldalra. A felhasználóneved: {USERNAME}, jelszavad: {PASSWORD}, és a fórum URL-je: {SCRIPTURL}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Új bejelentés: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

A teljes bejelentést megtekintheted itt:
{TOPICLINK}

Hogy leiratkozz ezekről a bejelentésekről, kövesd ezt a linket:
{UNSUBSCRIBELINK}

Ha több kontrollt szeretnél a kapott e-mail érdesítéseid fölött, jelentkezz be a fórumra és menj az Értesítések beállításaira a profilodon.

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Új téma: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Egy általad figyelt fórumon új téma indult \'{TOPICSUBJECT}\' címen.

Itt tekintheted meg:
{TOPICLINK}

További új témák is létrejöhetnek, de nem fogsz több e-mail értesítést kapni, amíg vissza nem mész a fórumra és el nem olvasol közülük párat.

A téma szövege alább olvasható:
{MESSAGE}

A fórumban indított új témakról a következő linken tudsz leiratkozni:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Új téma: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Egy általad figyelt fórumon új téma indult \'{TOPICSUBJECT}\' címen.

Itt tekintheted meg:
{TOPICLINK}

További új témák is létrejöhetnek, de nem fogsz több e-mail értesítést kapni, amíg vissza nem mész a fórumra és el nem olvasol közülük párat.

A fórumban indított új témakról a következő linken tudsz leiratkozni:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Új téma: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Egy általad figyelt fórumon új téma indult \'{TOPICSUBJECT}\' címen.

Itt tekintheted meg:
{TOPICLINK}

A téma szövege alább olvasható:
{MESSAGE}

A fórumban indított új témakról a következő linken tudsz leiratkozni:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Új téma: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Egy általad figyelt fórumon új téma indult \'{TOPICSUBJECT}\' címen.

Itt tekintheted meg:
{TOPICLINK}

A fórumban indított új témakról a következő linken tudsz leiratkozni:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Téma válasz: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = '{POSTERNAME} egy új választ írt az egyik általad figyelt \'{SUBJECT}\' témába.

A válasz megtekintése:
{LINK}

{REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Új jóváhagyásra váró csatolmány: {SUBJECT}';
$txt['unapproved_attachment_body'] = 'A new attachment has been made in \'{SUBJECT}\' which needs to be approved.

You can approve or reject this attachment from the link below which will take you to the message that it is a part of.

{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Új jóváhagyásra váró hozzászólás: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'A new post has been made which needs to be approved: \'{SUBJECT}\'

You can approve or reject this post by using the link below:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Új jóváhagyásra váró téma: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'A new topic has been made which needs to be approved: \'{SUBJECT}\'

You can approve or reject this topic by using the link below:
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Új csoport jelentkezés';
$txt['request_membership_body'] = '{RECPNAME},

{APPLYNAME} tagságot kért a „{GROUPNAME}” csoportba. A felhasználó a következő indoklást adta meg:

{REASON}

Az alábbi linkre kattintva jóváhagyhatod vagy elutasíthatod a kérelmet:
{MODLINK}

{REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'A feliratkozásod hamarosan lejár a {FORUMNAME} fórumon';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

Előfizetésed hamarosan lejár a {FORUMNAME} fórumon. Ha az automatikus megújítást választottad, nincs teendőd; ellenkező esetben érdemes megfontolnod az újbóli előfizetést. A részletek alább olvashatók:

Előfizetés neve: {SUBSCRIPTION}
Lejár: {END_DATE}

Az előfizetéseid szerkesztéséhez látogass el a következő URL-re:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Üdvözlünk újra itt: {FORUMNAME}';
$txt['activate_reactivate_body'] = 'In order to re-validate your email address, your account has been deactivated. Click the following link to activate it again:
{ACTIVATIONLINK}

Should you have any problems with activation, please visit {ACTIVATIONLINKWITHOUTCODE} and use the code "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Új jelszó: {FORUMNAME}';
$txt['forgot_password_body'] = 'Dear {REALNAME},
This mail was sent because the \'forgot password\' function has been applied to your account. To set a new password, click the following link:
{REMINDLINK}

IP: {IP}
Username: {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Jelentett hozzászólás: {TOPICSUBJECT}, {POSTERNAME} által';
$txt['report_to_moderator_body'] = 'The following post, "{TOPICSUBJECT}" by {POSTERNAME} has been reported by {REPORTERNAME} on a board you moderate:

The topic: {TOPICLINK}
Moderation center: {REPORTLINK}

The reporter has made the following comment:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Megjegyzés a jelentett hozzászóláshoz: {TOPICSUBJECT}, {POSTERNAME} által';
$txt['reply_to_moderator_body'] = 'Előzőleg "{TOPICSUBJECT}" jelentve lett a moderátoroknak.

Azóta {COMMENTERNAME} megjegyzést fűzött a jelentéshez. További információ a fórumon látható.

Téma: {TOPICLINK}
Moderációs központ: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Jelentett profil: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'The profile of "{MEMBERNAME}" has been reported by {REPORTERNAME}.

The profile: {PROFILELINK}
Moderation center: {REPORTLINK}

The reporter has made the following comment:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Megjegyzés a jelentett profilhoz: {MEMBERNAME}';
$txt['reply_to_member_report_body'] = 'Previously, the profile of {MEMBERNAME} was reported.

Since then, {COMMENTERNAME} has added a comment to the report. More information can be found in the forum.

The profile: {PROFILELINK}
Moderation center: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Új jelszó adatai';
$txt['change_password_body'] = 'Kedves {USERNAME}!

A bejelentkezési adataid a {FORUMNAME} oldalon megváltoztak és új jelszó került számodra beállításra. Alább találod az új bejelentkezési adataidat.

A felhasználóneved: "{USERNAME}", a jelszavad: "{PASSWORD}".

Bejelentkezés után érdemes megváltoztatnod a profil oldalon:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Üdvözöl a {FORUMNAME}';
$txt['register_activate_body'] = 'Köszönjük, hogy regisztráltál a {FORUMNAME} oldalon. A felhasználóneved {USERNAME}. Ha elfelejtetted a jelszavadat, akkor azt a {FORGOTPASSWORDLINK} oldalon tudod visszaállítani.

Mielőtt bejelentkezhetnél, először aktiválnod kell a fiókodat. Ehhez kérjük, kövesse ezt a linket:

{ACTIVATIONLINK}

Ha bármilyen problémád van az aktiválással, kérjük, látogass el a {ACTIVATIONLINKWITHOUTCODE} oldalra, és használd a "{ACTIVATIONCODE}" kódot.

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Üdvözöl a {FORUMNAME}';
$txt['register_coppa_body'] = 'Örülünk, hogy regisztráltál a {FORUMNAME} oldalon! A felhasználóneved {USERNAME}. Ha eljelejted a jelszavad, itt változtathatod meg: {FORGOTPASSWORDLINK}.

Mielőtt bejelentkezhetnél, az adminisztrátornak szüksége van a szülőd/gondviselőd beleegyezésére, hogy csatlakozhass a közösséghez. További információt az alábbi linken kaphatsz:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Üdvözöl a {FORUMNAME}';
$txt['register_immediate_body'] = 'Thank you for registering at {FORUMNAME}. Your username is {USERNAME}. If you forget your password, you may change it at {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Üdvözöl a {FORUMNAME}';
$txt['register_pending_body'] = 'Szia {REALNAME}, regisztrációs kérelmed a(z) {FORUMNAME} oldalra megkaptuk.

Az általad regisztrált felhasználónév: {USERNAME}. Ha elfelejted a jelszavad, itt változtathatod meg: {FORGOTPASSWORDLINK}.

Mielőtt bejelentkezhetnél és megkezdhetnéd a fórum használatát, a kérelmed az oldal üzemeltetői áttekintik és megerősítik.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Téma válasz: {TOPICSUBJECT}';
$txt['notification_reply_body'] = '{POSTERNAME} egy új választ írt az egyik általad figyelt témába.

A válasz megtekintése: {TOPICLINK}

A témáról a következő linkre kattintva iratkozhatsz le: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Téma válasz: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = '{POSTERNAME} egy új választ írt az egyik általad figyelt témába.

A válasz megtekintése: {TOPICLINK}

A témáról a következő linkre kattintva iratkozhatsz le: {UNSUBSCRIBELINK}

A válasz szövege alább látható:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Téma válasz: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = '{POSTERNAME} egy új választ írt az egyik általad figyelt témába.

A válasz megtekintése: {TOPICLINK}

A témáról a következő linkre kattintva iratkozhatsz le: {UNSUBSCRIBELINK}

További válaszok is érkezhetnek, de nem fogsz több értesítést kapni, amíg meg nem látogatod a témát.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Téma válasz: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = '{POSTERNAME} egy új választ írt az egyik általad figyelt témába.

A válasz megtekintése: {TOPICLINK}

A témáról a következő linkre kattintva iratkozhatsz le: {UNSUBSCRIBELINK}

A válasz szövege alább látható:
{MESSAGE}

További válaszok is érkezhetnek, de nem fogsz több értesítést kapni, amíg meg nem látogatod a témát.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Téma kitűzve: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Az általad figyelt téma ki lett emelve.

A téma megtekintése: {TOPICLINK}

A témáról a következő linkre kattintva iratkozhatsz le: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Téma lezárva: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Az általad figyelt téma lezárásra került.

A téma megtekintése: {TOPICLINK}

A témáról a következő linkre kattintva iratkozhatsz le: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Téma feloldva: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Az általad figyelt téma feloldásra került.

A téma megtekintése: {TOPICLINK}

A témáról a következő linkre kattintva iratkozhatsz le: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Téma törölve: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'A topic you are watching has been removed.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Téma áthelyezve: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Az általad figyelt téma áthelyezésre került egy másik fórumba.

A téma megtekintése: {TOPICLINK}

A témáról a következő linkre kattintva iratkozhatsz le: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Téma összevonva: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Az általad figyelt téma össze lett vonva egy másik témával.

Nézd meg az új összevont témát a következő címen: {TOPICLINK}

A témáról a következő linkre kattintva iratkozhatsz le: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Téma felosztása: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Az általad megfigyelt téma kettő vagy több témára lett szétválasztva.

Nézd meg, mi maradt a témában itt: {TOPICLINK}

A témáról a következő linkre kattintva iratkozhatsz le: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Egy új tag csatlakozott';
$txt['admin_notify_body'] = '{USERNAME} has just signed up as a new member of your forum. Click the link below to view their profile.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Egy új tag csatlakozott';
$txt['admin_notify_approval_body'] = '{USERNAME} has just signed up as a new member of your forum. Click the link below to view their profile.
{PROFILELINK}

Before this member can begin posting they must first have their account approved. Click the link below to go to the approval screen.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Sürgős! A csatolmányok könyvtára majdnem megtelt!';
$txt['admin_attachments_full_body'] = '{REALNAME},

{FORUMNAME} csatolmányok könyvtára majdnem megtelt. Kérjük, látogass el a fórumra, hogy megoldja ezt a problémát.

Amint a csatolmányok könyvtára eléri a maximálisan megengedett méretet, a felhasználók nem tudják folytatni a csatolmányok közzétételét vagy az egyéni avatarok feltöltését (ha engedélyezve van).

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Visszafizetett előfizetés';
$txt['paid_subscription_refund_body'] = '{REALNAME},

A member has received a refund on a paid subscription. Below are the details of this subscription:

	Subscription: {NAME}
	User Name: {REFUNDNAME} ({REFUNDUSER})
	Date: {DATE}

You can view this member\'s profile by clicking the link below:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Új fizetett feliratkozás';
$txt['paid_subscription_new_body'] = '{REALNAME},

A member has taken out a new paid subscription. Below are the details of this subscription:

	Subscription: {NAME}
	User Name: {SUBNAME} ({SUBUSER})
	User Email: {SUBEMAIL}
	Price: {PRICE}
	Date: {DATE}

You can view this member\'s profile by clicking the link below:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Fizetett feliratkozással kapcsolatos hiba történt';
$txt['paid_subscription_error_body'] = 'Kedves {REALNAME}!

A következő probléma adódott a fizetett feliratkozásod feldolgozása közben:
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Új személyes üzenet: {SUBJECT}';
$txt['new_pm_body'] = '{SENDER} új személyes üzenetet küldött neked a következő oldalon: {FORUMNAME}.

FONTOS: Emlékezz, ez csak egy értesítõ. Kérlek, ne válaszolj erre a levélre.

Itt olvashatod el az üzenetet: {READLINK}

Itt válaszolhatsz a személyes üzenetre: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Új személyes üzenet: {SUBJECT}';
$txt['new_pm_body_body'] = '{SENDER} új személyes üzenetet küldött neked a következő oldalon: {FORUMNAME}.

FONTOS: Emlékezz, ez csak egy értesítõ. Kérlek, ne válaszolj erre a levélre.

Az üzenet:

{MESSAGE}

Itt válaszolhatsz a személyes üzenetre: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Új személyes üzenet: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'Te és {TOLIST} személyes üzenetet kaptatok {SENDER} felhasználótól a(z) {FORUMNAME} oldalon.

FONTOS: Emlékezz, ez csak egy értesítõ. Kérlek, ne válaszolj erre a levélre.

Itt olvashatod el az üzenetet: {READLINK}

Itt válaszolhatsz a személyes üzenetre (csak a feladónak): {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Új személyes üzenet: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'Te és {TOLIST} személyes üzenetet kaptatok {SENDER} felhasználótól a(z) {FORUMNAME} oldalon.

FONTOS: Emlékezz, ez csak egy értesítõ. Kérlek, ne válaszolj erre a levélre.

Az üzenet:

{MESSAGE}

Itt válaszolhatsz a személyes üzenetre (csak a feladónak): {REPLYLINK}

{REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Valaki idézte a hozzászólásodat: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Hello {MEMBERNAME},

You have been quoted in the post titled "{CONTENTSUBJECT}" by {QUOTENAME}, you can see the post here:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Valaki említett téged: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Hello {MEMBERNAME},

You have been mentioned in the post titled "{CONTENTSUBJECT}" by {MENTIONNAME}, you can see the post here:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = '{FORUMNAME} boldog születésnapot kíván!';
$txtBirthdayEmails['happy_birthday_body'] = 'Dear {REALNAME},

We here at {FORUMNAME} would like to wish you a happy birthday. May this day and the year to follow be full of joy.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'A születésnapodon...';
$txtBirthdayEmails['karlbenson1_body'] = 'Küldhettünk volna neked egy születésnapi képeslapot. Küldhettünk volna neked virágokat vagy tortát.

De nem tettük.

Küldhettünk volna neked egy olyan automatikusan generált üzenetet, hogy boldog születésnapot kívánjunk neked, ahol nem is kellene átírnunk, hogy NÉV HELYE.

De nem tettük.

Ezt a születésnapi üdvözletet írtuk neked.

Különösen boldog szülinapot kívánunk!

{REGARDS}

//:: Ez egy automatikusan generált üzenet :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Boldog születésnapot!';
$txtBirthdayEmails['nite0859_body'] = '{FORUMNAME} barátaid szeretnének egy kis időt szánni arra, hogy boldog születésnapot kívánjanak neked, {REALNAME}. Ha nem tetted meg mostanában, kérlek, látogass el közösségünkbe, hogy másoknak is legyen lehetőségük átadni szívélyes üdvözletüket.

Bár ma van a születésnapod, {REALNAME}, szeretnénk emlékeztetni téged arra, hogy a közösségünkhöz való tartozásod eddig a legjobb ajándék volt számunkra.

Minden jót kívánunk:
{FORUMNAME} csapata';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Születésnapi üdvözlet {REALNAME} számára';
$txtBirthdayEmails['zwaldowski_body'] = 'Dear {REALNAME},

Another year in your life has passed. We at {FORUMNAME} hope it has been filled with happiness, and wish you luck in the coming one.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Boldog születésnapot, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Do you know who\'s having a birthday today, {REALNAME}?

We know... YOU!

Happy birthday!

You\'re now a year older but we hope you\'re a lot happier than last year.

Enjoy your day today, {REALNAME}!

- From your {FORUMNAME} family';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'A személyes születésnapi üdvözleted';
$txtBirthdayEmails['karlbenson2_body'] = 'Reméljük, hogy a születésnapod a legjobban telik; felhős, napos, vagy bármilyen is legyen az időjárás.
Zabálj jó sok szülinapi tortát és mulass jól, aztán ha van kedved, meséld el, mit csináltál.

Reméljük, ez az üzenet megmosolyogtatott, ami kitart jövő év ugyaneddig, ugyanitt.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>