<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Bem-vindo(a) ao {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Obrigado por se registar no {FORUMNAME}. O seu nome de utilizador é {USERNAME}. Se esqueceu a sua senha, pode recuperá-la visitando {FORGOTPASSWORDLINK}.

Antes de poder entrar, tem primeiro de ativar a sua conta clicando na ligação abaixo:

{ACTIVATIONLINK}

Se tiver algum problema com a ativação, por favor visite {ACTIVATIONLINKWITHOUTCODE} e insira o código "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Olá {REALNAME}, o seu pedido de registo no {FORUMNAME} foi recebido.

Registou-se com o nome de utilizador {USERNAME}.

Antes de poder entrar e usar o fórum, o seu pedido irá ser revisto e aprovado.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Aprovação do Grupo de Membros';
$txt['mc_group_approve_body'] = '{USERNAME},

Estamos encantados por o notificar de que a sua aplicação para se untar ao grupo "{GROUPNAME}" no {FORUMNAME} foi aceite, e a sua conta foi atualizada para incluir este novo grupo de membros.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Rejeição do Grupo de Membros';
$txt['mc_group_reject_body'] = '{USERNAME},

Lamentamos notificá-lo de que a sua aplicação para se juntar ao grupo "{GROUPNAME}" no {FORUMNAME} foi rejeitada.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Rejeição do Grupo de Membros';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

Lamentamos notificá-lo de que a sua aplicação para se juntar ao grupo "{GROUPNAME}" no {FORUMNAME} foi rejeitada.

Isto aconteceu devido ao seguinte motivo: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Bem-vindo, {NAME}

A sua conta foi ativada manualmente por um administrador e pode agora entrar e colocar mensagens. O seu nome de utilizador é: {USERNAME}. Se esqueceu a sua senha, pode mudá-la em {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Bem-vindo, {USERNAME}!

A sua conta no {FORUMNAME} foi aprovada por um administrador. Antes de poder entrar, tem primeiro de ativar a sua conta clicando na seguinte ligação:

{ACTIVATIONLINK}

Se tiver algum problema com a ativação, por favor visite {ACTIVATIONLINKWITHOUTCODE} e insira o código "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Registo rejeitado';
$txt['admin_approve_reject_body'] = '{USERNAME},

Lamentavelmente, a sua aplicação para se juntar ao {FORUMNAME} foi rejeitada.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Conta apagada';
$txt['admin_approve_delete_body'] = '{USERNAME},

A sua conta no {FORUMNAME} foi apagada. Isto pode ter acontecido porque nunca ativou a sua conta, pelo que deverá ser capaz de se registar novamente.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Lembrete de registo';
$txt['admin_approve_remind_body'] = '{USERNAME},
Ainda não ativou a sua conta no {FORUMNAME}.

Por favor, use a ligação abaixo para ativar a sua conta:
{ACTIVATIONLINK}

Se tiver algum problema com a ativação, por favor visite {ACTIVATIONLINKWITHOUTCODE} e insira o código "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Obrigado por se registar em {FORUMNAME}. O seu nome de utilizador é {USERNAME} e a sua senha é {PASSWORD}.

Antes de poder entrar, tem primeiro de ativar a sua conta clicando na seguinte ligação:

{ACTIVATIONLINK}

Se tiver algum problema com a ativação, por favor visite {ACTIVATIONLINKWITHOUTCODE} e insira o código "{ACTIVATIONCODE}".

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Obrigado por se registar em {FORUMNAME}. O seu nome de utilizador é {USERNAME}, a sua senha é {PASSWORD} e o endereço do fórum é: {SCRIPTURL}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Novo anúncio: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

Pode ver o anúncio completo clicando na seguinte ligação:
{TOPICLINK}

Para retirar a subscrição destes anúncios, clique na ligação abaixo:
{UNSUBSCRIBELINK}

Para mais controlo acerca das notificações que recebe por e-mail, entre na sua conta e vá à área de notificações no seu perfil.

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Novo tópico: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Um novo tópico, \'{TOPICSUBJECT}\', foi criado num quadro que está a observar.

Pode vê-lo em
{TOPICLINK}

Mais tópicos podem ser criados, mas não receberá mais notificações por e-mail deste quadro até que volte e leia alguns deles.

O texto do tópico é mostrado abaixo:
{MESSAGE}

Remova as notificações por e-mail deste quadro clicando na ligação abaixo:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Novo tópico: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Um novo tópico, \'{TOPICSUBJECT}\', foi criado num quadro que está a observar.

Pode vê-lo em
{TOPICLINK}

Mais tópicos podem ser criados, mas não receberá mais notificações por e-mail deste quadro até que volte e leia alguns deles.

Remova as notificações por e-mail deste quadro clicando na ligação abaixo:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Novo tópico: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Um novo tópico, \'{TOPICSUBJECT}\', foi criado num quadro que está a observar.

Pode vê-lo em
{TOPICLINK}

O texto do tópico é mostrado abaixo:
{MESSAGE}

Remova as notificações por e-mail deste quadro clicando na ligação abaixo:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Novo tópico: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Um novo tópico, \'{TOPICSUBJECT}\', foi criado num quadro que está a observar.

Pode vê-lo em
{TOPICLINK}

Remova as notificações por e-mail deste quadro clicando na ligação abaixo:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Resposta ao tópico: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = 'Uma resposta foi colocada em \'{SUBJECT}\' por {POSTERNAME}.

Pode vê-la em
{LINK}

{REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Novo anexo não aprovado: {SUBJECT}';
$txt['unapproved_attachment_body'] = 'Um novo anexo foi colocado em \'{SUBJECT}\' que precisa de ser aprovado

Pode aprovar ou rejeitar este anexo através da ligação abaixo que o vai levar à mensagem da qual o anexo faz parte.

{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Nova mensagem não aprovada: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'Uma nova mensagem foi colocada e precisa de aprovação: \'{SUBJECT}\'

Pode aprovar ou rejeitar esta mensagem através da ligação abaixo:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Novo tópico não aprovado: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'Um novo tópico foi feito e precisa de aprovação: \'{SUBJECT}\'

Pode aprovar ou rejeitar este tópico através da ligação abaixo:
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Nova aplicação a um grupo';
$txt['request_membership_body'] = '{RECPNAME},

{APPLYNAME} pediu para se juntar ao grupo "{GROUPNAME}". O utilizador deu o seguinte motivo:

{REASON}

Pode aprovar ou rejeitar esta aplicação através da ligação abaixo:

{MODLINK}

{REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Subscrição prestes a vencer em {FORUMNAME}';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

A sua subscrição em {FORUMNAME} está prestes a vencer. Se ligou a renovação automática, não precisa de fazer nada, caso contrário pode querer considerar fazer uma nova subscrição. Os detalhes são mostrados abaixo:

Nome da subscrição: {SUBSCRIPTION}
Data de vencimento: {END_DATE}

Para editar as suas subscrições, visite a ligação abaixo:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Bem-vindo de volta a {FORUMNAME}';
$txt['activate_reactivate_body'] = 'De forma a poder revalidar o seu endereço de e-mail, a sua conta foi desativada. Clique na ligação seguinte para ativar a sua conta novamente:
{ACTIVATIONLINK}

Se tiver algum problema com a ativação, por favor visite {ACTIVATIONLINKWITHOUTCODE} e insira o código "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Nova senha para {FORUMNAME}';
$txt['forgot_password_body'] = 'Caro {REALNAME},
Este e-mail foi enviado porque a função \'esqueci a senha\' foi aplicada à sua conta. Para definir uma nova senha, clique na ligação seguinte:
{REMINDLINK}

IP: {IP}
Nome de utilizador: {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Mensagem denunciada: {TOPICSUBJECT} por {POSTERNAME}';
$txt['report_to_moderator_body'] = 'A seguinte mensagem, "{TOPICSUBJECT}" por {POSTERNAME} foi denunciada por {REPORTERNAME} num quadro onde é moderador:

O tópico: {TOPICLINK}
Centro de moderação: {REPORTLINK}

O utilizador fez o seguinte comentário:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Acompanhamento da mensagem denunciada: {TOPICSUBJECT} por {POSTERNAME}';
$txt['reply_to_moderator_body'] = 'Anteriormente, "{TOPICSUBJECT}" foi denunciado aos moderadores.

Desde então, {COMMENTERNAME} adicionou comentários à denúncia. Mais informação pode ser encontrada no fórum.

O tópico: {TOPICLINK}
Centro de moderação: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Perfil denunciado: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'O perfil de "{MEMBERNAME}" foi denunciado por {REPORTERNAME}.

O perfil: {PROFILELINK}
Centro de moderação: {REPORTLINK}

O utilizador fez o seguinte comentário:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Acompanhamento de perfil denunciado: {MEMBERNAME}';
$txt['reply_to_member_report_body'] = 'Anteriormente, o perfil de {MEMBERNAME} foi denunciado.

Desde então, {COMMENTERNAME} adicionou um comentário à denúncia. Mais informação pode ser encontrada no fórum.

O perfil: {PROFILELINK}
Centro de moderação: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Novos detalhes da senha';
$txt['change_password_body'] = 'caro {USERNAME},

Os seus detalhes no {FORUMNAME} foram mudados e a sua senha foi redefinida. Abaixo estão os novos detalhes para poder entrar no fórum.

O seu nome de utilizador é "{USERNAME}" e a sua senha é "{PASSWORD}".

Pode mudar isto depois de entrar indo à sua página de perfil, ou visitando esta ligação depois de ter feito o login:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['register_activate_body'] = 'Obrigado por se registar em {FORUMNAME}. O seu nome de utilizador é {USERNAME}. Se esqueceu a sua senha, pode mudá-la em {FORGOTPASSWORDLINK}.

Antes de entrar, primeiro necessita de ativar a sua conta. Para o fazer, clique na ligação abaixo:

{ACTIVATIONLINK}

Se tiver algum problema com a ativação, por favor visite {ACTIVATIONLINKWITHOUTCODE} e insira o código "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['register_coppa_body'] = 'Obrigado por se registar em {FORUMNAME}. O seu nome de utilizador é {USERNAME}. Se esqueceu a sua senha, pode mudá-la em {FORGOTPASSWORDLINK}.

Antes de poder entrar, o administrador requer um consentimento dos seus pais/tutores para se poder juntar à comunidade. Pode obter mais informações na ligação abaixo:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['register_immediate_body'] = 'Obrigado por se registar em {FORUMNAME}. O seu nome de utilizador é {USERNAME}. Se esqueceu a sua senha, pode mudá-la em {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['register_pending_body'] = 'Olá {REALNAME}, o seu pedido de registo em {FORUMNAME} foi recebido.

O nome de utilizador que quer registar é {USERNAME}. Se esqueceu a sua senha, pode mudá-la em {FORGOTPASSWORDLINK}.

Antes de poder entrar e usar o fórum, o seu pedido irá ser revisto e aprovado.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Resposta ao tópico: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'Um tópico que está a observar recebeu uma resposta de {POSTERNAME}.

Veja a resposta em: {TOPICLINK}

Desligue as notificações para este tópico através desta ligação: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Resposta ao tópico: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'Um tópico que está a observar recebeu uma resposta de {POSTERNAME}.

Veja a resposta em: {TOPICLINK}

Desligue as notificações para este tópico através desta ligação: {UNSUBSCRIBELINK}

O texto da resposta é mostrado abaixo:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Resposta ao tópico: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'Um tópico que está a observar recebeu uma resposta de {POSTERNAME}.

Veja a resposta em: {TOPICLINK}

Desligue as notificações para este tópico através desta ligação: {UNSUBSCRIBELINK}

Mais respostas podem ser colocadas, mas não receberá mais nenhuma notificação para este tópico até que o visite.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Resposta ao tópico: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'Um tópico que está a observar recebeu uma resposta de {POSTERNAME}.

Veja a resposta em: {TOPICLINK}

Desligue as notificações para este tópico através desta ligação: {UNSUBSCRIBELINK}

O texto da resposta é mostrado abaixo:
{MESSAGE}

Mais respostas podem ser colocadas, mas não receberá mais nenhuma notificação para este tópico até que o visite.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Tópico fixado: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Um tópico que está a observar foi fixado.

Veja o tópico em: {TOPICLINK}

Desligue as notificações para este tópico através desta ligação: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Tópico trancado: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Um tópico que está a observar foi trancado.

Veja o tópico em: {TOPICLINK}

Desligue as notificações para este tópico através desta ligação: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Tópico destrancado: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Um tópico que está a observar foi destrancado.

Veja o tópico em: {TOPICLINK}

Desligue as notificações para este tópico através desta ligação: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Tópico removido: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Um tópico que está a observar foi removido.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Tópico movido: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Um tópico que está a observar foi movido.

Veja o tópico em: {TOPICLINK}

Desligue as notificações para este tópico através desta ligação: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Tópico fundido: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Um tópico que está a observar foi fundido com outro.

Veja o novo tópico em: {TOPICLINK}

Desligue as notificações para este tópico através desta ligação: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Tópico dividido: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Um tópico que está a observar foi dividido em dois ou mais tópicos.

Veja o que resta deste tópico em: {TOPICLINK}

Desligue as notificações para este tópico através desta ligação: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Um novo membro juntou-se ao seu fórum';
$txt['admin_notify_body'] = '{USERNAME} juntou-se ao seu fórum. Clique na ligação abaixo para ver o seu perfil.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Um novo membro juntou-se ao seu fórum';
$txt['admin_notify_approval_body'] = '{USERNAME} juntou-se ao seu fórum. Clique na ligação abaixo para ver o seu perfil.
{PROFILELINK}

Antes deste membro poder colocar mensagens, primeiro tem de ter a sua conta ativada. Clique na ligação abaixo para ir para o painel de aprovações.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Urgente! O diretório de anexos está quase cheio!';
$txt['admin_attachments_full_body'] = '{REALNAME},

O diretório de anexos no {FORUMNAME} está quase cheio. Visite o fórum para resolver este problema.

Assim que o diretório dos anexos atinga a capacidade máxima permitida, os utilizadores não serão capazes de continuar a enviar anexos ou avatares (se estiver ligado).

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Reembolso de subscrição paga';
$txt['paid_subscription_refund_body'] = '{REALNAME},

Um membro recebeu um reembolso de uma subscrição paga. Abaixo estão os detalhes desta subscrição:

	Subscrição: {NAME}
	Nome do utilizador: {REFUNDNAME} ({REFUNDUSER})
	Data: {DATE}

Pode ver o perfil deste membro seguindo a ligação abaixo:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Nova subscrição paga';
$txt['paid_subscription_new_body'] = '{REALNAME},

Um membro ativou uma subscrição paga. Abaixo estão os detalhes desta subscrição:

	Subscrição: {NAME}
	Nome do utilizador: {SUBNAME} ({SUBUSER})
	Endereço de e-mail: {SUBEMAIL}
	Preço: {PRICE}
	Data: {DATE}

Pode ver o perfil deste membro seguindo a ligação abaixo:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Erro numa subscrição paga';
$txt['paid_subscription_error_body'] = 'Caro {REALNAME},

Ocorreu o seguinte erro quando se processava uma subscrição paga
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Nova mensagem pessoal: {SUBJECT}';
$txt['new_pm_body'] = 'Acabou de receber uma mensagem pessoal de {SENDER} no {FORUMNAME}.

IMPORTANTE: Lembre-se, isto é apenas uma notificação. Por favor não responda a este e-mail.

Leia esta mensagem pessoal aqui: {READLINK}

Responda a esta mensagem pessoal aqui: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Nova mensagem pessoal: {SUBJECT}';
$txt['new_pm_body_body'] = 'Acabou de receber uma mensagem pessoal de {SENDER} no {FORUMNAME}.

IMPORTANTE: Lembre-se, isto é apenas uma notificação. Por favor não responda a este e-mail.

A mensagem que recebeu é a seguinte:

{MESSAGE}

Responda a esta mensagem pessoal aqui: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Nova mensagem pessoal: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'Você e {TOLIST} acabaram de receber uma mensagem pessoal de {SENDER} no {FORUMNAME}.

IMPORTANTE: Lembre-se, isto é apenas uma notificação. Por favor não responda a este e-mail.

Leia esta mensagem pessoal aqui: {READLINK}

Responda a esta mensagem pessoal (apenas ao remetente) aqui: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Nova mensagem pessoal: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'Você e {TOLIST} acabaram de receber uma mensagem pessoal de {SENDER} no {FORUMNAME}.

IMPORTANTE: Lembre-se, isto é apenas uma notificação. Por favor não responda a este e-mail.

A mensagem que recebeu é a seguinte:

{MESSAGE}

Responda a esta mensagem pessoal (apenas ao remetente) aqui: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Foi citado na mensagem: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Olá {MEMBERNAME},

Foi citado numa mensagem com o título "{CONTENTSUBJECT}" por {QUOTENAME}. Pode ver a mensagem aqui:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Foi mencionado na mensagem: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Olá {MEMBERNAME},

Foi mencionado numa mensagem com o título "{CONTENTSUBJECT}" por {MENTIONNAME}. Pode ver a mensagem aqui:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'Feliz aniversário {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Caro {REALNAME},

Aqui no {FORUMNAME} queremos desejar-lhe um feliz aniversário! Que este dia e o ano que se segue seja repleto de alegria.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'No seu aniversário...';
$txtBirthdayEmails['karlbenson1_body'] = 'Poderíamos enviar-lhe um cartão de felicitações. Até poderíamos enviar-lhe flores ou um bolo.

Mas não o fizemos.

Poderíamos enviar-lhe uma daquelas mensagens geradas automaticamente a desejar-lhe um feliz aniversário onde nem sequer teríamos que substituir INSERIR NOME.

Mas não o fizemos.

Escrevemos esta mensagem apenas para si.

Gostaríamos de lhe desejar um aniversário muito especial.

{REGARDS}

//:: Esta mensagem foi gerada automaticamente :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Feliz aniversário!';
$txtBirthdayEmails['nite0859_body'] = 'Os seus amigos do {FORUMNAME} gostariam de lhe desejar um feliz aniversário, {REALNAME}. Se não o fez recentemente, por favor visite a nossa comunidade de forma a outros poderem dar-lhe os parabéns.

Apesar de hoje ser o seu dia, {REALNAME}, gostaríamos de lhe lembrar que ser um membro da nossa comunidade tem sido o melhor presente que poderíamos receber.

Com os melhores cumprimentos,
A equipa de {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Tudo de bom {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Caro {REALNAME},

Outro ano passou na sua vida. E nos no {FORUMNAME} esperamos que tenha sido preenchido com felicidade, e desejamos sorte no ano que se segue.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Feliz aniversário, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Sabe quem faz anos hoje, {REALNAME}?

Nós sabemos... VOCÊ!

Feliz aniversário!

Está agora um anos mais velho, mas esperamos que seja muito mais feliz que no ano passado.

Disfrute do seu dia, {REALNAME}!

- Da sua família do {FORUMNAME}';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'A sua saudação de aniversário';
$txtBirthdayEmails['karlbenson2_body'] = 'Esperamos que o seu aniversário seja o melhor de sempre, com nuvens, sol ou qualquer previsão meteorológica.
Tenha muitos bolos e diversão, e diga-nos o que tem feito.

Esperamos que esta mensagem lhe traga alegria, e que dure até aos mesmo dia, no mesmo lugar, daqui a um ano.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>