<?php
/**
 * Shipping zone admin
 *
 * @package Kkart\Admin\Shipping
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<h2>
	<a href="<?php echo esc_url( admin_url( 'admin.php?page=kkart-settings&tab=shipping' ) ); ?>"><?php esc_html_e( 'Shipping zones', 'kkart' ); ?></a> &gt;
	<span class="kkart-shipping-zone-name"><?php echo esc_html( $zone->get_zone_name() ? $zone->get_zone_name() : __( 'Zone', 'kkart' ) ); ?></span>
</h2>

<?php do_action( 'kkart_shipping_zone_before_methods_table', $zone ); ?>

<table class="form-table kkart-shipping-zone-settings">
	<tbody>
		<?php if ( 0 !== $zone->get_id() ) : ?>
			<tr valign="top" class="">
				<th scope="row" class="titledesc">
					<label for="zone_name">
						<?php esc_html_e( 'Zone name', 'kkart' ); ?>
						<?php echo kkart_help_tip( __( 'This is the name of the zone for your reference.', 'kkart' ) ); // @codingStandardsIgnoreLine ?>
					</label>
				</th>
				<td class="forminp">
					<input type="text" data-attribute="zone_name" name="zone_name" id="zone_name" value="<?php echo esc_attr( $zone->get_zone_name( 'edit' ) ); ?>" placeholder="<?php esc_attr_e( 'Zone name', 'kkart' ); ?>">
				</td>
			</tr>
			<tr valign="top" class="">
				<th scope="row" class="titledesc">
					<label for="zone_locations">
						<?php esc_html_e( 'Zone regions', 'kkart' ); ?>
						<?php echo kkart_help_tip( __( 'These are regions inside this zone. Customers will be matched against these regions.', 'kkart' ) ); // @codingStandardsIgnoreLine ?>
					</label>
				</th>
				<td class="forminp">
					<select multiple="multiple" data-attribute="zone_locations" id="zone_locations" name="zone_locations" data-placeholder="<?php esc_attr_e( 'Select regions within this zone', 'kkart' ); ?>" class="kkart-shipping-zone-region-select chosen_select">
						<?php
						foreach ( $shipping_continents as $continent_code => $continent ) {
							echo '<option value="continent:' . esc_attr( $continent_code ) . '"' . kkart_selected( "continent:$continent_code", $locations ) . '>' . esc_html( $continent['name'] ) . '</option>';

							$countries = array_intersect( array_keys( $allowed_countries ), $continent['countries'] );

							foreach ( $countries as $country_code ) {
								echo '<option value="country:' . esc_attr( $country_code ) . '"' . kkart_selected( "country:$country_code", $locations ) . '>' . esc_html( '&nbsp;&nbsp; ' . $allowed_countries[ $country_code ] ) . '</option>';

								$states = KKART()->countries->get_states( $country_code );

								if ( $states ) {
									foreach ( $states as $state_code => $state_name ) {
										echo '<option value="state:' . esc_attr( $country_code . ':' . $state_code ) . '"' . kkart_selected( "state:$country_code:$state_code", $locations ) . '>' . esc_html( '&nbsp;&nbsp;&nbsp;&nbsp; ' . $state_name . ', ' . $allowed_countries[ $country_code ] ) . '</option>';
									}
								}
							}
						}
						?>
					</select>
					<?php if ( empty( $postcodes ) ) : ?>
						<a class="kkart-shipping-zone-postcodes-toggle" href="#"><?php esc_html_e( 'Limit to specific ZIP/postcodes', 'kkart' ); ?></a>
					<?php endif; ?>
					<div class="kkart-shipping-zone-postcodes">
						<textarea name="zone_postcodes" data-attribute="zone_postcodes" id="zone_postcodes" placeholder="<?php esc_attr_e( 'List 1 postcode per line', 'kkart' ); ?>" class="input-text large-text" cols="25" rows="5"><?php echo esc_textarea( implode( "\n", $postcodes ) ); ?></textarea>
						<?php /* translators: Kkart link to setting up shipping zones */ ?>
						<span class="description"><?php printf( __( 'Postcodes containing wildcards (e.g. CB23*) or fully numeric ranges (e.g. <code>90210...99000</code>) are also supported. Please see the shipping zones <a href="%s" target="_blank">documentation</a>) for more information.', 'kkart' ), 'https://docs.kkart.com/document/setting-up-shipping-zones/#section-3' ); ?></span><?php // @codingStandardsIgnoreLine. ?>
					</div>
				</td>
			<?php endif; ?>
		</tr>
		<tr valign="top" class="">
			<th scope="row" class="titledesc">
				<label>
					<?php esc_html_e( 'Shipping methods', 'kkart' ); ?>
					<?php echo kkart_help_tip( __( 'The following shipping methods apply to customers with shipping addresses within this zone.', 'kkart' ) ); // @codingStandardsIgnoreLine ?>
				</label>
			</th>
			<td class="">
				<table class="kkart-shipping-zone-methods widefat">
					<thead>
						<tr>
							<th class="kkart-shipping-zone-method-sort"></th>
							<th class="kkart-shipping-zone-method-title"><?php esc_html_e( 'Title', 'kkart' ); ?></th>
							<th class="kkart-shipping-zone-method-enabled"><?php esc_html_e( 'Enabled', 'kkart' ); ?></th>
							<th class="kkart-shipping-zone-method-description"><?php esc_html_e( 'Description', 'kkart' ); ?></th>
						</tr>
					</thead>
					<tfoot>
						<tr>
							<td colspan="4">
								<button type="submit" class="button kkart-shipping-zone-add-method" value="<?php esc_attr_e( 'Add shipping method', 'kkart' ); ?>"><?php esc_html_e( 'Add shipping method', 'kkart' ); ?></button>
							</td>
						</tr>
					</tfoot>
					<tbody class="kkart-shipping-zone-method-rows"></tbody>
				</table>
			</td>
		</tr>
	</tbody>
</table>

<?php do_action( 'kkart_shipping_zone_after_methods_table', $zone ); ?>

<p class="submit">
	<button type="submit" name="submit" id="submit" class="button button-primary button-large kkart-shipping-zone-method-save" value="<?php esc_attr_e( 'Save changes', 'kkart' ); ?>" disabled><?php esc_html_e( 'Save changes', 'kkart' ); ?></button>
</p>

<script type="text/html" id="tmpl-kkart-shipping-zone-method-row-blank">
	<tr>
		<td class="kkart-shipping-zone-method-blank-state" colspan="4">
			<p><?php esc_html_e( 'You can add multiple shipping methods within this zone. Only customers within the zone will see them.', 'kkart' ); ?></p>
		</td>
	</tr>
</script>

<script type="text/html" id="tmpl-kkart-shipping-zone-method-row">
	<tr data-id="{{ data.instance_id }}" data-enabled="{{ data.enabled }}">
		<td width="1%" class="kkart-shipping-zone-method-sort"></td>
		<td class="kkart-shipping-zone-method-title">
			<a class="kkart-shipping-zone-method-settings" href="admin.php?page=kkart-settings&amp;tab=shipping&amp;instance_id={{ data.instance_id }}">{{{ data.title }}}</a>
			<div class="row-actions">
				<a class="kkart-shipping-zone-method-settings" href="admin.php?page=kkart-settings&amp;tab=shipping&amp;instance_id={{ data.instance_id }}"><?php esc_html_e( 'Edit', 'kkart' ); ?></a> | <a href="#" class="kkart-shipping-zone-method-delete"><?php esc_html_e( 'Delete', 'kkart' ); ?></a>
			</div>
		</td>
		<td width="1%" class="kkart-shipping-zone-method-enabled"><a href="#">{{{ data.enabled_icon }}}</a></td>
		<td class="kkart-shipping-zone-method-description">
			<strong class="kkart-shipping-zone-method-type">{{ data.method_title }}</strong>
			{{{ data.method_description }}}
		</td>
	</tr>
</script>

<script type="text/template" id="tmpl-kkart-modal-shipping-method-settings">
	<div class="kkart-backbone-modal kkart-backbone-modal-shipping-method-settings">
		<div class="kkart-backbone-modal-content">
			<section class="kkart-backbone-modal-main" role="main">
				<header class="kkart-backbone-modal-header">
					<h1>
						<?php
						printf(
							/* translators: %s: shipping method title */
							esc_html__( '%s Settings', 'kkart' ),
							'{{{ data.method.method_title }}}'
						);
						?>
					</h1>
					<button class="modal-close modal-close-link dashicons dashicons-no-alt">
						<span class="screen-reader-text"><?php esc_html_e( 'Close modal panel', 'kkart' ); ?></span>
					</button>
				</header>
				<article class="kkart-modal-shipping-method-settings">
					<form action="" method="post">
						{{{ data.method.settings_html }}}
						<input type="hidden" name="instance_id" value="{{{ data.instance_id }}}" />
					</form>
				</article>
				<footer>
					<div class="inner">
						<button id="btn-ok" class="button button-primary button-large"><?php esc_html_e( 'Save changes', 'kkart' ); ?></button>
					</div>
				</footer>
			</section>
		</div>
	</div>
	<div class="kkart-backbone-modal-backdrop modal-close"></div>
</script>

<script type="text/template" id="tmpl-kkart-modal-add-shipping-method">
	<div class="kkart-backbone-modal">
		<div class="kkart-backbone-modal-content">
			<section class="kkart-backbone-modal-main" role="main">
				<header class="kkart-backbone-modal-header">
					<h1><?php esc_html_e( 'Add shipping method', 'kkart' ); ?></h1>
					<button class="modal-close modal-close-link dashicons dashicons-no-alt">
						<span class="screen-reader-text"><?php esc_html_e( 'Close modal panel', 'kkart' ); ?></span>
					</button>
				</header>
				<article>
					<form action="" method="post">
						<div class="kkart-shipping-zone-method-selector">
							<p><?php esc_html_e( 'Choose the shipping method you wish to add. Only shipping methods which support zones are listed.', 'kkart' ); ?></p>

							<select name="add_method_id">
								<?php
								foreach ( KKART()->shipping()->load_shipping_methods() as $method ) {
									if ( ! $method->supports( 'shipping-zones' ) ) {
										continue;
									}
									echo '<option data-description="' . esc_attr( wp_kses_post( wpautop( $method->get_method_description() ) ) ) . '" value="' . esc_attr( $method->id ) . '">' . esc_html( $method->get_method_title() ) . '</li>';
								}
								?>
							</select>
						</div>
					</form>
				</article>
				<footer>
					<div class="inner">
						<button id="btn-ok" class="button button-primary button-large"><?php esc_html_e( 'Add shipping method', 'kkart' ); ?></button>
					</div>
				</footer>
			</section>
		</div>
	</div>
	<div class="kkart-backbone-modal-backdrop modal-close"></div>
</script>
