<?php
/**
 * Product Search Widget.
 *
 * @package Kkart\Widgets
 * @version 2.3.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Widget product search class.
 */
class KKART_Widget_Product_Search extends KKART_Widget {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->widget_cssclass    = 'kkart widget_product_search';
		$this->widget_description = __( 'A search form for your store.', 'kkart' );
		$this->widget_id          = 'kkart_product_search';
		$this->widget_name        = __( 'Product Search', 'kkart' );
		$this->settings           = array(
			'title' => array(
				'type'  => 'text',
				'std'   => '',
				'label' => __( 'Title', 'kkart' ),
			),
		);

		parent::__construct();
	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args     Arguments.
	 * @param array $instance Widget instance.
	 */
	public function widget( $args, $instance ) {
		$this->widget_start( $args, $instance );

		get_product_search_form();

		$this->widget_end( $args );
	}
}
