<?php
defined( 'ABSPATH' ) || exit;

if ( ! defined( 'KKART_PLUGIN_FILE' ) ) {
	define( 'KKART_PLUGIN_FILE', __FILE__ );
}

define('KKART_ADMIN_DIR', ABSPATH .(defined('SITEPAD') ? 'site-admin/' : 'wp-admin/'));
define('KKART_BASE', plugin_basename(KKART_FILE));
define('KKART_PRO_BASE', 'kkart-pro/kkart-pro.php');
define('KKART_VERSION', '1.0.4');
define('KKART_DIR', dirname(KKART_FILE));
define('KKART_SLUG', 'kkart');
define('KKART_URL', plugins_url('', KKART_FILE));
define('KKART_CSS', KKART_URL.'/css');
define('KKART_JS', KKART_URL.'/js');
define('KKART_PRO_URL', 'https://kkart.com/pricing?from=plugin');
define('KKART_WWW_URL', 'https://kkart.com/');
define('KKART_DOCS', 'https://kkart.com/docs/');
define('KKART_API', 'https://api.kkart.com/');
define('KKART_SC_PREFIX', 'pl');
define('KKART_YOUTUBE_BG', 'https://www.youtube.com/watch?v=Csa6rvCWmLU');
@define('KKART_BRAND_TEXT', 'Kkart');
@define('KKART_LOGO', KKART_URL.'/images/kkart-logo-40.png');
@define('KKART_ORDERS_MENU', 'Orders');
@define('KKART_SCREEN_PREFIX', sanitize_title( KKART_ORDERS_MENU ));
@define('KKART_PLUGIN_DIR', (0 === strpos( KKART_FILE, WP_PLUGIN_DIR )) ? WP_PLUGIN_DIR : SP_PLUGIN_DIR);

// Load core packages and the autoloader.
require __DIR__ . '/src/Autoloader.php';
require __DIR__ . '/src/Packages.php';

if ( ! \Automattic\Kkart\Autoloader::init() ) {
	return;
}
\Automattic\Kkart\Packages::init();

// Include the main Kkart class.
if ( ! class_exists( 'Kkart', false ) ) {
	include_once dirname( KKART_PLUGIN_FILE ) . '/includes/class-kkart.php';
}

// Initialize dependency injection.
$GLOBALS['kkart_container'] = new Automattic\Kkart\Container();

/**
 * Returns the main instance of KKART.
 *
 * @since  2.1
 * @return Kkart
 */
function KKART() { // phpcs:ignore WordPress.NamingConventions.ValidFunctionName.FunctionNameInvalid
	return Kkart::instance();
}

/**
 * Returns the Kkart PSR11-compatible object container.
 * Code in the `includes` directory should use the container to get instances of classes in the `src` directory.
 *
 * @return \Psr\Container\ContainerInterface The Kkart PSR11 container.
 */
function kkart_get_container() : \Psr\Container\ContainerInterface {
	return $GLOBALS['kkart_container'];
}

// Global for backwards compatibility.
$GLOBALS['kkart'] = KKART();

// Add shortcode in Pagelayer shortcode loader
add_action( 'pagelayer_load_custom_widgets', 'kkart_load_shortcodes' );

// Loads the shortcodes
function kkart_load_shortcodes(){

	include_once(KKART_DIR.'/includes/shortcode_functions.php');
	if(defined('KKART_PREMIUM')){
		include_once(KKART_DIR.'/includes/premium.php');
		include_once(KKART_DIR.'/includes/premium_functions.php');
	}
	include_once(KKART_DIR.'/includes/shortcodes.php');
	
	// Apply filter to load custom widgets
	do_action('kkart_load_custom_widgets');

}

// Load frontend js and css
add_action( 'pagelayer_custom_frontend_enqueue', 'kkart_custom_frontend_enqueue' );
// Load any header we have
function kkart_custom_frontend_enqueue(){
	
	$premium_js = '';
	$premium_css = '';
	if(defined('KKART_PREMIUM')){
		$premium_js = ',premium-frontend.js';
		$premium_css = ',premium-frontend.css';
	}
	
	// Enqueue our Editor's Frontend JS
	wp_register_script('kkart-frontend', KKART_JS.'/givejs.php?give=frontend.js'.$premium_js, array('jquery'), KKART_VERSION);
	wp_enqueue_script('kkart-frontend');

	wp_register_style('kkart-frontend', KKART_CSS.'/givecss.php?give=kkart-frontend.css'.$premium_css, array(), KKART_VERSION);
	wp_enqueue_style('kkart-frontend');
}

// Load editor js and css
add_action( 'pagelayer_custom_editor_enqueue', 'kkart_custom_editor_enqueue' );
// Load any header we have
function kkart_custom_editor_enqueue(){
	
	$premium_js = '';
	if(defined('KKART_PREMIUM')){
		$premium_js = '';
	}
	
	// Enqueue JS
	wp_register_script('kkart-editor', KKART_JS.'/givejs.php?give=properties.js,widgets.js,'.$premium_js, array('jquery'), KKART_VERSION);
	wp_enqueue_script('kkart-editor');
		
	// Enqueue CSS
	wp_register_style('kkart-editor', KKART_CSS.'/givecss.php?give=kkart-editor-frontend.css', KKART_VERSION);
	wp_enqueue_style('kkart-editor');
}

// Load the editor head
add_action('pagelayer_editor_wp_head', 'kkart_editor_wp_head');
function kkart_editor_wp_head(){
	global $post;
	
	echo '<script>
var kkart_meta_nonce = "'.wp_create_nonce('kkart_save_data').'";
pagelayer_ajax_post_data.kkart_meta_nonce = "'.wp_create_nonce('kkart_save_data').'";
kkart_editor_nonce = "'.wp_create_nonce('kkart_editor_nonce').'";
pagelayer_ajax_post_data.post_ID = "'.$post->ID.'";
</script>';

}

// Load the editor head
add_action('pagelayer_live_body_head', 'kkart_live_body_head');
function kkart_live_body_head(){
	global $post;
	
	echo '<link rel="stylesheet" href="'.KKART_CSS.'/givecss.php?give=kkart-editor.css&ver='.KKART_VERSION.'">';
}

// Load the global styles
add_action('wp_head', 'kkart_global_js', 2);
// Load any header we have
function kkart_global_js(){

	echo '<script>
var kkart_ajaxurl = "'.admin_url( 'admin-ajax.php' ).'?";
var kkart_ajax_nonce = "'.wp_create_nonce('kkart_ajax').'";
var kkart_checkout_nonce = "'.wp_create_nonce('kkart-process_checkout').'";
var kkart_myaccount_logout = "'.kkart_get_page_permalink('myaccount').''.get_option('kkart_logout_endpoint').'/?_wpnonce='.wp_create_nonce('customer-logout').'";
var kkart_server_time = '.time().';
var kkart_currency_symbol = "'.get_kkart_currency_symbol().'";
</script>';

}

// Save product data
add_action('pagelayer_save_content', 'kkart_save_product_data', 2);
function kkart_save_product_data($post){
	
	$allowed = ['kkart_title', 'kkart_excerpt', '_thumbnail_id'];
		
	foreach($allowed as $k){
		if(!empty($_REQUEST[$k])){
			$kk = str_replace('kkart', 'post', $k);
			$post[$kk] = $_REQUEST[$k];
		}
	}
	
	return $post;
}

// Shortcode params filter
add_action('pagelayer_shortcode_params', 'kkart_shortcode_params', 10, 2);
function kkart_shortcode_params($params, $tag){
	global $post;
	
	if((!empty($post->post_type) && $post->post_type != 'product') || $tag != 'pl_post_props'){
		return $params;
	}
	
	include_once(KKART_DIR.'/includes/body-props-settings.php');
	
	return kkart_body_props_settings($params);
}

// Element attr filter while do shortcode
add_action('pagelayer_do_shortcode_el', 'kkart_do_shortcode_el', 10, 2);
function kkart_do_shortcode_el($el){
	global $post;
	
	if((!empty($post) && $post->post_type != 'product') || $el['tag'] != 'pl_post_props'){
		return $el;
	}
	
	include_once(KKART_DIR.'/includes/body-props-settings.php');
	
	return kkart_do_shortcode_el_filter($el);
}

// All post types are editable by Pagelayer
//add_filter('pagelayer_supported_post_type', 'kkart_pagelayer_supported_post_type', 10, 1);
function kkart_pagelayer_supported_post_type($types){

	// Get the current filename from the URL
	$current_file = basename($_SERVER['PHP_SELF']);

	// Check if the current file is 'edit.php'
	if($current_file === 'edit.php' && isset($_GET['post_type']) && $_GET['post_type'] == 'product'){
		return $types;
	}
	
	if(!in_array('product', $types)){
		$types[] = 'product';
	}
	return $types;
}

// All post types are editable by Pagelayer
/* add_filter('replace_editor', 'kkart_replace_editor', 10, 2);
function kkart_replace_editor($ret, $post){
	
	if(!empty($post) && $post->post_type == 'product'){
		
		if(empty($post->post_title) && $post->post_status == 'auto-draft'){
			$post->post_status = 'draft';		
			$post->post_title = 'New Product';
			wp_update_post($post);
		}
		
		//r_print(get_post($post));exit;
		wp_redirect( pagelayer_livelink($post) );
	}
} */

// Buy now handler
add_filter('kkart_add_to_cart_redirect', 'kkart_buy_now_handler', 10, 2);
function kkart_buy_now_handler($url, $adding_to_cart){
	
	if ( empty( $_REQUEST['buy-now'] ) ) { 
		return $url;
	}
	
	return kkart_get_checkout_url();
}

// Add Pagelayer Template builder options
include_once(KKART_DIR.'/includes/template.php');