/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { SHOP_URL } from '@kkart/block-settings';
import { Icon, cart } from '@kkart/icons';

const EmptyCart = () => {
	return (
		<div className="kkart-block-checkout-empty">
			<Icon
				className="kkart-block-checkout-empty__image"
				alt=""
				srcElement={ cart }
				size={ 100 }
			/>
			<strong className="kkart-block-checkout-empty__title">
				{ __( 'Your cart is empty!', 'kkart' ) }
			</strong>
			<p className="kkart-block-checkout-empty__description">
				{ __(
					"Checkout is not available whilst your cart is empty—please take a look through our store and come back when you're ready to place an order.",
					'kkart'
				) }
			</p>
			<span className="wp-block-button">
				<a href={ SHOP_URL } className="wp-block-button__link">
					{ __( 'Browse store', 'kkart' ) }
				</a>
			</span>
		</div>
	);
};

export default EmptyCart;
