/**
 * External dependencies
 */
import { getValidBlockAttributes } from '@kkart/base-utils';
import {
	renderParentBlock,
	renderStandaloneBlocks,
} from '@kkart/atomic-utils';

/**
 * Internal dependencies
 */
import Block from './block';
import blockAttributes from './attributes';
import { BLOCK_NAME } from './constants';

const getProps = ( el ) => {
	return {
		attributes: getValidBlockAttributes( blockAttributes, el.dataset ),
	};
};

renderParentBlock( {
	Block,
	blockName: BLOCK_NAME,
	selector: '.wp-block-kkart-single-product',
	getProps,
} );

renderStandaloneBlocks();
