<?php
/**
 * Checkout coupon form
 *
 * This template can be overridden by copying it to yourtheme/kkart/checkout/form-coupon.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 3.4.4
 */

defined( 'ABSPATH' ) || exit;

if ( ! kkart_coupons_enabled() ) { // @codingStandardsIgnoreLine.
	return;
}

?>
<div class="kkart-form-coupon-toggle">
	<?php kkart_print_notice( apply_filters( 'kkart_checkout_coupon_message', esc_html__( 'Have a coupon?', 'kkart' ) . ' <a href="#" class="showcoupon">' . esc_html__( 'Click here to enter your code', 'kkart' ) . '</a>' ), 'notice' ); ?>
</div>

<form class="checkout_coupon kkart-form-coupon" method="post" style="display:none">

	<p><?php esc_html_e( 'If you have a coupon code, please apply it below.', 'kkart' ); ?></p>

	<p class="form-row form-row-first">
		<input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Coupon code', 'kkart' ); ?>" id="coupon_code" value="" />
	</p>

	<p class="form-row form-row-last">
		<button type="submit" class="button" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'kkart' ); ?>"><?php esc_html_e( 'Apply coupon', 'kkart' ); ?></button>
	</p>

	<div class="clear"></div>
</form>
