<?php
/**
 * Login form
 *
 * This template can be overridden by copying it to yourtheme/kkart/global/form-login.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.kkart.com/document/template-structure/
 * @package     Kkart\Templates
 * @version     3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( is_user_logged_in() ) {
	return;
}

?>
<form class="kkart-form kkart-form-login login" method="post" <?php echo ( $hidden ) ? 'style="display:none;"' : ''; ?>>

	<?php do_action( 'kkart_login_form_start' ); ?>

	<?php echo ( $message ) ? wpautop( wptexturize( $message ) ) : ''; // @codingStandardsIgnoreLine ?>

	<p class="form-row form-row-first">
		<label for="username"><?php esc_html_e( 'Username or email', 'kkart' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="text" class="input-text" name="username" id="username" autocomplete="username" />
	</p>
	<p class="form-row form-row-last">
		<label for="password"><?php esc_html_e( 'Password', 'kkart' ); ?>&nbsp;<span class="required">*</span></label>
		<input class="input-text" type="password" name="password" id="password" autocomplete="current-password" />
	</p>
	<div class="clear"></div>

	<?php do_action( 'kkart_login_form' ); ?>

	<p class="form-row">
		<label class="kkart-form__label kkart-form__label-for-checkbox kkart-form-login__rememberme">
			<input class="kkart-form__input kkart-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <span><?php esc_html_e( 'Remember me', 'kkart' ); ?></span>
		</label>
		<?php wp_nonce_field( 'kkart-login', 'kkart-login-nonce' ); ?>
		<input type="hidden" name="redirect" value="<?php echo esc_url( $redirect ); ?>" />
		<button type="submit" class="kkart-button button kkart-form-login__submit" name="login" value="<?php esc_attr_e( 'Login', 'kkart' ); ?>"><?php esc_html_e( 'Login', 'kkart' ); ?></button>
	</p>
	<p class="lost_password">
		<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Lost your password?', 'kkart' ); ?></a>
	</p>

	<div class="clear"></div>

	<?php do_action( 'kkart_login_form_end' ); ?>

</form>
